/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    abstract class PetroliumFluid extends Internal.ForgeFlowingFluid {
        getClass(): typeof any;
        getStateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>;
        tick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidState_): void;
        getHeight(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        getFlow(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.FluidState_): Vec3d;
        abstract isSource(arg0: Internal.FluidState_): boolean;
        getOwnHeight(arg0: Internal.FluidState_): number;
        isEmpty(): boolean;
        notify(): void;
        getFluidType(): Internal.FluidType;
        wait(arg0: number, arg1: number): void;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Fluid>;
        getShape(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        defaultFluidState(): Internal.FluidState;
        getTickDelay(arg0: Internal.LevelReader_): number;
        canConvertToSource(arg0: Internal.FluidState_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        handler$fcc000$ac_canHoldFluid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_, arg4: Internal.CallbackInfoReturnable_<any>): void;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
        abstract getAmount(arg0: Internal.FluidState_): number;
        getSource(arg0: boolean): Internal.FluidState;
        toString(): string;
        handler$fcc000$ac_spreadTo(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Direction_, arg4: Internal.FluidState_, arg5: Internal.CallbackInfo_): void;
        getExplosionResistance(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getFlowing(): Internal.Fluid;
        notifyAll(): void;
        getBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: boolean): Internal.BlockPathTypes;
        getBucket(): Internal.Item;
        isSame(arg0: Internal.Fluid_): boolean;
        move(arg0: Internal.FluidState_, arg1: Internal.LivingEntity_, arg2: Vec3d_, arg3: number): boolean;
        canExtinguish(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        shouldUpdateWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_, arg2: Internal.Entity_): boolean;
        getAdjacentBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        hashCode(): number;
        canHydrate(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: BlockPos_): boolean;
        wait(): void;
        getFlowing(arg0: number, arg1: boolean): Internal.FluidState;
        wait(arg0: number): void;
        getSource(): Internal.Fluid;
        supportsBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        is(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        getIfEmpty(): boolean;
        get class(): typeof any
        get stateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>
        get empty(): boolean
        get fluidType(): Internal.FluidType
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get flowing(): Internal.Fluid
        get bucket(): Internal.Item
        get source(): Internal.Fluid
        get ifEmpty(): boolean
        static readonly PROPERTIES: (Internal.ForgeFlowingFluid$Properties) & (Internal.ForgeFlowingFluid$Properties);
    }
    type PetroliumFluid_ = PetroliumFluid;
    abstract class InputDecorator implements Internal.Serializable {
        constructor()
        getClass(): typeof any;
        abstract decorate(arg0: Internal.IOContext_, arg1: Internal.Reader_): Internal.Reader;
        abstract "decorate(com.fasterxml.jackson.core.io.IOContext,java.io.Reader)"(arg0: Internal.IOContext_, arg1: Internal.Reader_): Internal.Reader;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        abstract decorate(arg0: Internal.IOContext_, arg1: Internal.InputStream_): Internal.InputStream;
        hashCode(): number;
        wait(): void;
        "decorate(com.fasterxml.jackson.core.io.IOContext,java.io.DataInput)"(arg0: Internal.IOContext_, arg1: Internal.DataInput_): Internal.DataInput;
        wait(arg0: number): void;
        abstract decorate(arg0: Internal.IOContext_, arg1: number[], arg2: number, arg3: number): Internal.InputStream;
        equals(arg0: any): boolean;
        decorate(arg0: Internal.IOContext_, arg1: Internal.DataInput_): Internal.DataInput;
        abstract "decorate(com.fasterxml.jackson.core.io.IOContext,java.io.InputStream)"(arg0: Internal.IOContext_, arg1: Internal.InputStream_): Internal.InputStream;
        get class(): typeof any
    }
    type InputDecorator_ = InputDecorator;
    class BrewingRecipe implements Internal.Recipe<Internal.Container> {
        constructor(identifier: ResourceLocation_, ingredients: Internal.NonNullList_<Internal.Ingredient>, output: Internal.ItemStack_, material: Internal.BrewMaterial_)
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        assemble(container: Internal.Container_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        matches(inventory: Internal.Container_, world: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems(arg0: Internal.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getMaterial(): Internal.BrewMaterial;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        notifyAll(): void;
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get material(): Internal.BrewMaterial
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type BrewingRecipe_ = BrewingRecipe;
    interface MessageSenderKJS {
        getDisplayName(): Internal.Component;
        setStatusMessage(message: Internal.Component_): void;
        getName(): Internal.Component;
        runCommandSilent(command: string): number;
        tell(message: Internal.Component_): void;
        runCommand(command: string): number;
        get displayName(): Internal.Component
        set statusMessage(message: Internal.Component_)
        get name(): Internal.Component
    }
    type MessageSenderKJS_ = MessageSenderKJS;
    class ShapedFallbackRecipe$Serializer extends Internal.ShapedRecipe$Serializer {
        constructor()
        getClass(): typeof any;
        "fromJson(net.minecraft.resources.ResourceLocation,com.google.gson.JsonObject)"(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.ShapedRecipe;
        "fromNetwork(net.minecraft.resources.ResourceLocation,net.minecraft.network.FriendlyByteBuf)"(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.ShapedFallbackRecipe;
        "fromNetwork(net.minecraft.resources.ResourceLocation,net.minecraft.network.FriendlyByteBuf)"(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        toString(): string;
        "toNetwork(net.minecraft.network.FriendlyByteBuf,net.minecraft.world.item.crafting.Recipe)"(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        "toNetwork(net.minecraft.network.FriendlyByteBuf,net.minecraft.world.item.crafting.ShapedRecipe)"(arg0: Internal.FriendlyByteBuf_, arg1: Internal.ShapedRecipe_): void;
        notifyAll(): void;
        "fromJson(net.minecraft.resources.ResourceLocation,com.google.gson.JsonObject)"(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.ShapedFallbackRecipe;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        notify(): void;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_, arg2: Internal.ICondition$IContext_): Internal.ShapedRecipe;
        wait(arg0: number, arg1: number): void;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.ShapedRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>(arg0: string, arg1: S): S;
        hashCode(): number;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.ShapedRecipe_): void;
        wait(): void;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.ShapedFallbackRecipe;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.ShapedFallbackRecipe;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        get class(): typeof any
    }
    type ShapedFallbackRecipe$Serializer_ = ShapedFallbackRecipe$Serializer;
    class DataFormatReaders {
        constructor(arg0: Internal.Collection_<Internal.ObjectReader>)
        constructor(...arg0: Internal.ObjectReader_[])
        getClass(): typeof any;
        "with"(arg0: Internal.ObjectReader_[]): this;
        toString(): string;
        findFormat(arg0: number[], arg1: number, arg2: number): Internal.DataFormatReaders$Match;
        withOptimalMatch(arg0: Internal.MatchStrength_): this;
        notifyAll(): void;
        "findFormat(java.io.InputStream)"(arg0: Internal.InputStream_): Internal.DataFormatReaders$Match;
        withType(arg0: Internal.JavaType_): this;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        withMinimalMatch(arg0: Internal.MatchStrength_): this;
        "with(com.fasterxml.jackson.databind.DeserializationConfig)"(arg0: Internal.DeserializationConfig_): this;
        findFormat(arg0: Internal.InputStream_): Internal.DataFormatReaders$Match;
        hashCode(): number;
        "findFormat(byte[])"(arg0: number[]): Internal.DataFormatReaders$Match;
        wait(): void;
        wait(arg0: number): void;
        withMaxInputLookahead(arg0: number): this;
        "with(com.fasterxml.jackson.databind.ObjectReader[])"(arg0: Internal.ObjectReader_[]): this;
        equals(arg0: any): boolean;
        "with"(arg0: Internal.DeserializationConfig_): this;
        findFormat(arg0: number[]): Internal.DataFormatReaders$Match;
        get class(): typeof any
        static readonly DEFAULT_MAX_INPUT_LOOKAHEAD: (64) & (number);
    }
    type DataFormatReaders_ = DataFormatReaders;
    class SmallDrawersBlock extends Internal.BaseEntityBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        crafttweaker$setJumpFactor(arg0: number): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        crafttweaker$setExplosionResistance(arg0: number): void;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        crafttweaker$getFriction(): number;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static createTickerHelper<E extends Internal.BlockEntity, A extends Internal.BlockEntity>(arg0: Internal.BlockEntityType_<A>, arg1: Internal.BlockEntityType_<E>, arg2: Internal.BlockEntityTicker_<E>): Internal.BlockEntityTicker<A>;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$getHasCollision(): boolean;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        handler$bbb000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        crafttweaker$setFriction(arg0: number): void;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        crafttweaker$setHasCollision(arg0: boolean): void;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        needsDynamicBurningCheck(): boolean;
        getDescriptionId(): string;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        crafttweaker$setSpeedFactor(arg0: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        tacztweaks$setDestroySpeedMultiplier(arg0: number): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        crafttweaker$getSpeedFactor(): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        crafttweaker$getExplosionResistance(): number;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<Internal.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        crafttweaker$getJumpFactor(): number;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    }
    type SmallDrawersBlock_ = SmallDrawersBlock;
    class ClassInfo {
        getFieldInfo(): Internal.List<Internal.FieldInfo>;
        getClass(): typeof any;
        getClazzRaw(): typeof any;
        getAnnotations(): Internal.List<Internal.Annotation>;
        isAbstract(): boolean;
        toString(): string;
        static getOrCache(clazz: typeof any): Internal.ClassInfo;
        notifyAll(): void;
        isInterface(): boolean;
        getInterfaceTypes(): Internal.List<Internal.ITypeInfo>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getSuperClassType(): Internal.ITypeInfo;
        getInterfaces(): Internal.List<Internal.ClassInfo>;
        getSuperClass(): this;
        getParameters(): Internal.List<Internal.ITypeInfo>;
        hashCode(): number;
        wait(): void;
        getName(): string;
        isEnum(): boolean;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        getConstructorInfo(): Internal.List<Internal.ConstructorInfo>;
        getMethodInfo(): Internal.List<Internal.MethodInfo>;
        get fieldInfo(): Internal.List<Internal.FieldInfo>
        get class(): typeof any
        get clazzRaw(): typeof any
        get annotations(): Internal.List<Internal.Annotation>
        get "abstract"(): boolean
        get "interface"(): boolean
        get interfaceTypes(): Internal.List<Internal.ITypeInfo>
        get superClassType(): Internal.ITypeInfo
        get interfaces(): Internal.List<Internal.ClassInfo>
        get superClass(): Internal.ClassInfo
        get parameters(): Internal.List<Internal.ITypeInfo>
        get name(): string
        get enum(): boolean
        get constructorInfo(): Internal.List<Internal.ConstructorInfo>
        get methodInfo(): Internal.List<Internal.MethodInfo>
        static readonly CLASS_CACHE: ({[key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo}) & (Internal.Map<typeof any, Internal.ClassInfo>);
        static readonly CLASS_NAME_CACHE: ({"net.minecraft.world.level.Level$ExplosionInteraction": Internal.ClassInfo, "net.minecraft.network.protocol.status.ServerStatus$Players": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.BeanDeserializerModifier": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument$Info": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelFoggyCageArmorBlock": Internal.ClassInfo, "appeng.api.parts.IFacadeContainer": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.RemoveOresProperties": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.flarestack.FlarestackBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.DoubleFallenBurntSlabBlock": Internal.ClassInfo, "com.tacz.guns.client.model.bedrock.BedrockCube": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2BooleanFunction": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.Ignite": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.BeltBlockEntity$CasingType": Internal.ClassInfo, "net.minecraft.world.level.block.ChainBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMilitaryPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "edn.stratodonut.trackwork.tracks.blocks.variants.MedSuspensionTrackBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDesertPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframeCallbackHandler": Internal.ClassInfo, "net.mcreator.sab.block.PinkhardsteelblockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.FrostedIceBlock": Internal.ClassInfo, "com.github.alexthe666.citadel.client.event.EventPosePlayerHand": Internal.ClassInfo, "com.railwayteam.railways.content.switches.TrackSwitchBlockEntity$PonderData": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortListIterator": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket": Internal.ClassInfo, "com.github.alexthe666.citadel.client.event.EventRenderSplashText": Internal.ClassInfo, "net.minecraftforge.client.gui.overlay.IGuiOverlay": Internal.ClassInfo, "com.jozufozu.flywheel.util.box.GridAlignedBB": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.HoneyGlazedHamBlock": Internal.ClassInfo, "com.simibubi.create.content.redstone.analogLever.AnalogLeverBlockEntity": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.display.ammo.AmmoParticle": Internal.ClassInfo, "org.embeddedt.embeddium.client.gui.options.OptionIdentifier": Internal.ClassInfo, "com.simibubi.create.content.kinetics.base.IRotate": Internal.ClassInfo, "java.nio.channels.InterruptibleChannel": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingTrapdoorMagentaBlock": Internal.ClassInfo, "dev.aika.taczjs.forge.interfaces.client.IClientGun": Internal.ClassInfo, "com.tacz.guns.resource.index.CommonAmmoIndex": Internal.ClassInfo, "com.simibubi.create.content.processing.AssemblyOperatorBlockItem": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.CoveredBlockBlobFeature": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCaramelElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.impl.script.ScriptSerializer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedSteelReinforcedBlastGlassBlock": Internal.ClassInfo, "net.minecraft.util.Tuple": Internal.ClassInfo, "org.valkyrienskies.physics_api.PhysicsWorldReference": Internal.ClassInfo, "com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlock": Internal.ClassInfo, "appeng.api.util.IConfigurableObject": Internal.ClassInfo, "xaero.map.file.export.PNGExportResultType": Internal.ClassInfo, "com.simibubi.create.foundation.mixin.accessor.EntityAccessor": Internal.ClassInfo, "xaero.hud.category.setting.ObjectCategorySetting": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedVerticalSlicedStairsBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMesaArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.WallSkullBlock": Internal.ClassInfo, "slimeknights.mantle.data.loadable.field.DefaultingField": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.links.StringBooleans": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.primitive.AzLoopType": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingSlabGrayBlock": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.GeneralCannonTorpedoBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.LimeArmorSlabBlock": Internal.ClassInfo, "net.minecraft.world.item.Item$Properties": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.SecretWallSignBlock": Internal.ClassInfo, "net.minecraft.client.InputType": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumPurityFortifiedArmorBlockBlock": Internal.ClassInfo, "xaero.hud.minimap.waypoint.server.ServerWaypointManager": Internal.ClassInfo, "mezz.jei.api.recipe.IFocusGroup": Internal.ClassInfo, "java.nio.channels.AsynchronousChannel": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyBirchLogBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.TemptingSensor": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntBambooFencegateBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumFoggyPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "com.dsvv.cbcat.base.CustomPropellantContext": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigValueSerializer": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.ControlTriggerOnBlock": Internal.ClassInfo, "net.minecraft.server.ServerScoreboard$Method": Internal.ClassInfo, "net.minecraft.advancements.CriterionTriggerInstance": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingMossBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.BlockRecipeIngredient": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOvergrownArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMilitaryCageArmorBlock": Internal.ClassInfo, "net.minecraft.advancements.CriterionTrigger$Listener": Internal.ClassInfo, "net.minecraft.client.resources.DownloadedPackSource": Internal.ClassInfo, "net.mcreator.crustychunks.block.HarddirtBlock": Internal.ClassInfo, "net.minecraft.world.item.BowItem": Internal.ClassInfo, "mod.lucky77.block.base.MachinaTall": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.cog_crank.CogCrankBlockEntity": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.entity.movement_tracker.EntityMovementTrackerSection": Internal.ClassInfo, "slimeknights.mantle.registration.object.IdAwareObject": Internal.ClassInfo, "org.antarcticgardens.newage.content.heat.heater.HeaterBlock": Internal.ClassInfo, "net.mcreator.sab.block.MacraggebluehardsteelblockBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.ser.ContextualSerializer": Internal.ClassInfo, "com.forsteri.createendertransmission.blocks.AbstractMatterTransmitterBlockEntity": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.long_range_torpedo.LongRangeTorpedoProjectile": Internal.ClassInfo, "xaero.map.gui.GuiSettings": Internal.ClassInfo, "net.mcreator.sab.block.BrassrBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedDoubleCornerSlopePanelBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelForestReinforcedArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock": Internal.ClassInfo, "com.codinglitch.simpleradio.radio.RadioListener": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.generation.large_generator.RotorBlockEntity": Internal.ClassInfo, "com.petrolpark.recipe.manualonly.ManualOnlyShapedRecipe": Internal.ClassInfo, "net.geforcemods.securitycraft.fluids.FakeWaterFluid": Internal.ClassInfo, "com.tacz.guns.api.event.server.AmmoHitBlockEvent": Internal.ClassInfo, "net.minecraft.commands.synchronization.ArgumentTypeInfo$Template": Internal.ClassInfo, "com.ordana.spelunkery.blocks.DiamondGrindstoneBlock": Internal.ClassInfo, "net.minecraft.world.item.SwordItem": Internal.ClassInfo, "net.minecraft.world.level.chunk.UpgradeData": Internal.ClassInfo, "java.nio.file.attribute.BasicFileAttributes": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.RemoveWorldgenEventJS": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanel.FramedStackedSlopePanelBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.LootItemFunction": Internal.ClassInfo, "de.keksuccino.konkrete.mixin.client.IMixinScreen": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelFoggyElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDustyCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.NuclearFurnaceBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SeagrassBlock": Internal.ClassInfo, "com.simibubi.create.foundation.utility.IPartialSafeNBT": Internal.ClassInfo, "com.fasterxml.jackson.databind.ser.BeanSerializer": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.capability.TinkerDataCapability$Holder": Internal.ClassInfo, "vazkii.patchouli.common.recipe.BookRecipeSerializer": Internal.ClassInfo, "com.hlysine.create_connected.content.crankwheel.CrankWheelBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.VerticalAirbrakeDarkGrayBlock": Internal.ClassInfo, "java.nio.file.attribute.FileTime": Internal.ClassInfo, "net.mcreator.cbccw.fluid.HydrochloricAcidFluid$Flowing": Internal.ClassInfo, "net.minecraft.network.protocol.PacketFlow": Internal.ClassInfo, "net.minecraft.world.entity.RelativeMovement": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.render.immediate.model.ModelCuboid": Internal.ClassInfo, "xaero.hud.category.ui.GuiCategoryEditor$SettingRowList": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabWingYellowBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.FeaturePlaceContext": Internal.ClassInfo, "net.minecraft.server.players.IpBanList": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.display.LaserConfig": Internal.ClassInfo, "xfacthd.framedblocks.common.item.FramedHangingSignItem": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IWaypointableNavigation": Internal.ClassInfo, "net.minecraft.world.level.block.SimpleWaterloggedBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.PapaLetterBlock": Internal.ClassInfo, "io.netty.channel.ChannelPipeline": Internal.ClassInfo, "net.minecraftforge.event.server.ServerStartedEvent": Internal.ClassInfo, "net.minecraft.nbt.NbtAccounter": Internal.ClassInfo, "appeng.crafting.pattern.SmithingTablePatternItem": Internal.ClassInfo, "com.github.alexthe666.citadel.server.world.ModifiableTickRateServer": Internal.ClassInfo, "plus.dragons.createdragonlib.fluid.NoTintFluidType": Internal.ClassInfo, "mcinterface1201.BuilderBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.materials.definition.LazyMaterial": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ShortFunction": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseDragged$Pre": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.copper.CopperLargeBoilerBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntWoolBlock": Internal.ClassInfo, "org.antarcticgardens.newage.content.electricity.wire.WireType": Internal.ClassInfo, "team.creative.creativecore.common.util.math.base.Facing": Internal.ClassInfo, "java.security.SignatureSpi": Internal.ClassInfo, "java.time.format.FormatStyle": Internal.ClassInfo, "com.google.gson.ReflectionAccessFilter$FilterResult": Internal.ClassInfo, "net.minecraft.world.level.block.SupportType": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCreamBlastGlassBlock": Internal.ClassInfo, "net.minecraft.client.GameNarrator": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockAccessor": Internal.ClassInfo, "appeng.api.parts.IPartItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration": Internal.ClassInfo, "com.google.common.collect.ImmutableMultiset": Internal.ClassInfo, "appeng.api.orientation.RelativeSide": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.AtlasSpriteRegistryEventJS": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.FloorTrapBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.EndIslandFeature": Internal.ClassInfo, "net.mcreator.crustychunks.block.EnergyNodeBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectList": Internal.ClassInfo, "com.deltasf.createpropulsion.lodestone_tracker.LodestoneTrackerBlock": Internal.ClassInfo, "org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOceanBlastGlassBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMorningCageArmorBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2ByteFunction": Internal.ClassInfo, "net.mcreator.cbccw.item.PlasticMaskItem": Internal.ClassInfo, "net.mcreator.sab.block.DoublesteelblockcamoplainsBlock": Internal.ClassInfo, "net.minecraft.world.level.block.MultifaceSpreader": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.world.interests.PointOfInterestSetExtended": Internal.ClassInfo, "net.minecraft.world.level.chunk.storage.ChunkScanAccess": Internal.ClassInfo, "com.simibubi.create.infrastructure.worldgen.LayeredOreFeature": Internal.ClassInfo, "java.nio.LongBuffer": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntFencegateBlock": Internal.ClassInfo, "com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock": Internal.ClassInfo, "org.valkyrienskies.mod.mixin.accessors.resource.ResourceKeyAccessor": Internal.ClassInfo, "rbasamoyai.ritchiesprojectilelib.network.RootPacket": Internal.ClassInfo, "net.minecraft.world.level.SpawnData": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.controller.HeaterBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.LightAutocannonBlock": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.FaucetBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.color.Color": Internal.ClassInfo, "net.mcreator.crustychunks.block.YellowArmorTrapdoorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumArmorBlockBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.LightGrayArmorStairsBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeMap": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetHealthPacket": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.types.GateTypes": Internal.ClassInfo, "mezz.jei.api.gui.placement.HorizontalAlignment": Internal.ClassInfo, "com.atsuishio.superbwarfare.command.LowerCamelCaseEnumArgument$Info": Internal.ClassInfo, "java.security.cert.Certificate": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.VerticalControlSurfaceDarkGrayBlock": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.WaxedPlatformBlock": Internal.ClassInfo, "net.minecraft.world.level.block.PitcherCropBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsMagentaBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.BlockLinkPort": Internal.ClassInfo, "xaero.common.gui.widget.WidgetScreenHandler": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$Type": Internal.ClassInfo, "net.satisfy.vinery.core.block.AppleLeavesBlock": Internal.ClassInfo, "net.minecraft.world.level.WorldGenLevel": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CarverDebugSettings": Internal.ClassInfo, "net.minecraft.world.entity.decoration.PaintingVariant": Internal.ClassInfo, "org.apache.maven.artifact.repository.ArtifactRepository": Internal.ClassInfo, "net.minecraft.world.entity.monster.PatrollingMonster": Internal.ClassInfo, "com.tacz.guns.resource.modifier.AttachmentCacheProperty": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.AlphaTitaniumCasingBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.DisguisableBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.ForestBulletproofGlassBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Wolf": Internal.ClassInfo, "com.tom.storagemod.block.InventoryConnectorBlock": Internal.ClassInfo, "xfacthd.framedblocks.api.predicate.contex.FalseConnectionPredicate": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.ICarriageFlywheel": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyAcaciaSlabBlock": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.IGeometryLoader": Internal.ClassInfo, "net.mcreator.crustychunks.block.ControlRodBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderHighlightEvent$Block": Internal.ClassInfo, "slimeknights.tconstruct.library.recipe.TinkerRecipeTypes$1": Internal.ClassInfo, "com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsYellowBlock": Internal.ClassInfo, "software.bernie.geckolib.core.animation.Animation$LoopType": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelcamotaigaBlock": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlock": Internal.ClassInfo, "net.minecraft.world.inventory.StackedContentsCompatible": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.millstone.block.VeridiumDecoMillStoneBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntPathBlock": Internal.ClassInfo, "com.ordana.spelunkery.blocks.RopeLadderBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMuddyReinforcedCageArmorBlock": Internal.ClassInfo, "me.dantaeusb.zetter.item.crafting.PaletteRechargeRecipe$Serializer": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedDoubleSlabBlock": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.foundation.mixin.TankSegmentAccessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2IntFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.PlayerChatDecorateEventJS": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.recipe.GunSmithTableResultComponents$1": Internal.ClassInfo, "com.axperty.storagedelight.block.DrawerBlock": Internal.ClassInfo, "com.fasterxml.jackson.annotation.OptBoolean": Internal.ClassInfo, "com.tom.storagemod.item.IItemFilter": Internal.ClassInfo, "net.minecraft.network.chat.Style": Internal.ClassInfo, "java.util.EventListener": Internal.ClassInfo, "net.minecraftforge.event.TagsUpdatedEvent": Internal.ClassInfo, "net.mcreator.sab.block.CcBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsOrangeBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.OceanTankHatchBlock": Internal.ClassInfo, "net.mcreator.sab.block.DoublesteelblockrotbraunBlock": Internal.ClassInfo, "uwu.lopyluna.create_dd.access.AccessGearshiftBlock": Internal.ClassInfo, "com.simibubi.create.foundation.utility.ICoordinate": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntAcaciaTrapdoorBlock": Internal.ClassInfo, "net.minecraft.commands.arguments.TimeArgument$Info$Template": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetExperiencePacket": Internal.ClassInfo, "xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderContext": Internal.ClassInfo, "com.supermartijn642.fusion.api.texture.SpriteCreationContext": Internal.ClassInfo, "net.minecraft.world.entity.npc.VillagerProfession": Internal.ClassInfo, "net.pixelbank.burnt.block.WoodFireBlock": Internal.ClassInfo, "java.lang.StackTraceElement": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBarsBlock": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.WrappedCopycatBlock": Internal.ClassInfo, "dev.aika.taczjs.forge.events.crafting.legacy.RecipeLoadEvent": Internal.ClassInfo, "com.simibubi.create.foundation.mixin.accessor.MouseHandlerAccessor": Internal.ClassInfo, "com.simibubi.create.content.kinetics.saw.SawBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.modifiers.impl.BasicModifier$Builder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.OceanFireSupressionSystemBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkGenerator": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMuddyEletromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "com.mojang.brigadier.context.ParsedCommandNode": Internal.ClassInfo, "com.simibubi.create.content.trains.station.GlobalStation": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BaseContainerBlockEntity": Internal.ClassInfo, "com.verr1.controlcraft.content.links.IRenderer": Internal.ClassInfo, "team.creative.creativecore.common.gui.style.GuiStyle": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedCheckeredCubeBlock": Internal.ClassInfo, "net.minecraft.world.level.gameevent.BlockPositionSource": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.FeedType": Internal.ClassInfo, "mezz.jei.api.gui.widgets.ITextWidget": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IStandardBogeyTEVirtualCoupling": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.lights.rgb.RGBLightBulbBlockEntity": Internal.ClassInfo, "net.mcreator.cbccw.block.SulfurDioxideBlock": Internal.ClassInfo, "io.netty.channel.MessageSizeEstimator": Internal.ClassInfo, "org.valkyrienskies.mod.common.block.TestSphereBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BlockColumnFeature": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.ArrayBuilders$ByteBuilder": Internal.ClassInfo, "com.ordana.spelunkery.blocks.GlowstickBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundAddPlayerPacket": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeManager": Internal.ClassInfo, "net.minecraft.world.item.crafting.ShulkerBoxColoring": Internal.ClassInfo, "net.minecraft.world.level.block.SculkSpreader$ChargeCursor": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.stairs.CopycatStairsBlock$FaceShape": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.copper.CopperLargeBoilerBlockItem": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.digital.ComparatorLinkPort": Internal.ClassInfo, "net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity": Internal.ClassInfo, "net.minecraft.tags.TagEntry": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.mines.BaseFullMineBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOceanExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.client.renderer.ViewArea": Internal.ClassInfo, "net.minecraft.server.level.Ticket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSunflowerCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeCommandSourceStack": Internal.ClassInfo, "net.minecraft.client.sounds.SoundBufferLibrary": Internal.ClassInfo, "com.simibubi.create.foundation.mixin.accessor.ServerLevelAccessor": Internal.ClassInfo, "net.minecraft.client.gui.components.toasts.ToastComponent$ToastInstance": Internal.ClassInfo, "net.minecraft.world.level.block.WoolCarpetBlock": Internal.ClassInfo, "com.fasterxml.jackson.core.io.CharacterEscapes": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.TraderLlama": Internal.ClassInfo, "com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock": Internal.ClassInfo, "earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer": Internal.ClassInfo, "xaero.map.region.texture.LeafRegionTexture": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.MinecartFurnace": Internal.ClassInfo, "ht.treechop.common.settings.ChopSettings": Internal.ClassInfo, "net.minecraft.network.syncher.EntityDataSerializer$ForValueType": Internal.ClassInfo, "dan200.computercraft.shared.recipe.RecipeProperties": Internal.ClassInfo, "com.mojang.blaze3d.font.GlyphInfo": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.core.components.NamedComponent": Internal.ClassInfo, "io.netty.util.concurrent.GenericFutureListener": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock": Internal.ClassInfo, "net.mcreator.sab.block.RedstarBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyStoneBrickSlabBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.particle.InterfaceHighlightParticleType": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedTitaniumBlastGlassBlock": Internal.ClassInfo, "appeng.crafting.pattern.ProcessingPatternItem": Internal.ClassInfo, "xaero.map.world.MapWorld": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.FireSound": Internal.ClassInfo, "net.minecraft.server.network.ServerGamePacketListenerImpl": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntBinaryOperator": Internal.ClassInfo, "me.muksc.tacztweaks.mixininterface.compat.vs.ClipContextExtension": Internal.ClassInfo, "com.fasterxml.jackson.databind.cfg.DatatypeFeature": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.TravellingPoint": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor": Internal.ClassInfo, "com.lazrproductions.cuffed.blocks.SafeBlock": Internal.ClassInfo, "com.supermartijn642.core.data.condition.ResourceConditionSerializer": Internal.ClassInfo, "dan200.computercraft.api.lua.ILuaCallback": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientGamePacketListener": Internal.ClassInfo, "com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromChestRecipe$Serializer": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.half_layer.CopycatHalfLayerBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTransformRecipe": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMilitaryReinforcedBlastGlassBlock": Internal.ClassInfo, "net.satisfy.vinery.core.block.ModWallSignBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RiverTankHatchBlock": Internal.ClassInfo, "org.valkyrienskies.tournament.items.old.UpdateItem": Internal.ClassInfo, "net.minecraft.world.entity.ExperienceOrb": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BlockEntity": Internal.ClassInfo, "java.util.RegularEnumSet": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.GobstopperGeodeFeature": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent": Internal.ClassInfo, "com.simibubi.create.content.trains.signal.SignalBlockEntity$OverlayState": Internal.ClassInfo, "net.minecraft.world.level.block.MushroomBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.node.JsonNodeFactory": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopeslab.FramedDoubleSlopeSlabBlock": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListener": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.WoodType": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumFoggyReinforcedArmorBlockBlock": Internal.ClassInfo, "com.railwayteam.railways.content.handcar.HandcarBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2ReferenceFunction": Internal.ClassInfo, "com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity": Internal.ClassInfo, "slimeknights.mantle.data.predicate.IJsonPredicate": Internal.ClassInfo, "net.geforcemods.securitycraft.items.AdminToolItem": Internal.ClassInfo, "net.minecraft.client.renderer.item.ItemPropertyFunction": Internal.ClassInfo, "org.apache.logging.log4j.core.filter.AbstractFilterable": Internal.ClassInfo, "net.mcreator.cbccw.fluid.VinegarFluid$Flowing": Internal.ClassInfo, "net.minecraft.world.ticks.TickAccess": Internal.ClassInfo, "net.minecraftforge.registries.NewRegistryEvent": Internal.ClassInfo, "net.mcreator.crustychunks.block.OrangeArmorStairsBlock": Internal.ClassInfo, "net.minecraft.core.RegistryAccess$ImmutableRegistryAccess": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.MatchingFluidsPredicate": Internal.ClassInfo, "net.minecraft.client.gui.layouts.LayoutElement": Internal.ClassInfo, "com.jozufozu.flywheel.util.transform.Rotate": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.AmberMonolithBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials": Internal.ClassInfo, "net.minecraft.world.item.FireworkStarItem": Internal.ClassInfo, "appeng.crafting.inv.ICraftingInventory": Internal.ClassInfo, "net.minecraft.world.level.block.GrowingPlantBodyBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure": Internal.ClassInfo, "slimeknights.mantle.data.loadable.Streamable": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabWingBlackBlock": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.ICrashAdvancement": Internal.ClassInfo, "net.minecraftforge.client.event.ModelEvent$BakingCompleted": Internal.ClassInfo, "com.simibubi.create.content.fluids.hosePulley.HosePulleyBlockEntity": Internal.ClassInfo, "java.nio.file.attribute.FileStoreAttributeView": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$TransparencyStateShard": Internal.ClassInfo, "xaero.map.palette.FastPalette": Internal.ClassInfo, "net.mcreator.sab.block.GraysteelblockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.NetherrackBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.RegistryInfo": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCeramicReinforcedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.MangroveRootsBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumReinforcedArmorBlockBlock": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonInclude$Value": Internal.ClassInfo, "com.simibubi.create.content.trains.graph.DimensionPalette": Internal.ClassInfo, "xaero.pac.common.server.IOpenPACMinecraftServer": Internal.ClassInfo, "com.simibubi.create.content.trains.station.StationEditPacket": Internal.ClassInfo, "com.fasterxml.jackson.databind.cfg.ConstructorDetector": Internal.ClassInfo, "xfacthd.framedblocks.common.block.interactive.FramedButtonBlock": Internal.ClassInfo, "net.mcreator.sab.block.MBlock": Internal.ClassInfo, "com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity$FuelType": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour$ValueSettings": Internal.ClassInfo, "net.ngbatz.createnuclearwar.item.HazmatSuitItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeShapelessRecipe": Internal.ClassInfo, "com.verr1.controlcraft.foundation.api.operatable.IAdjustableJoint": Internal.ClassInfo, "net.minecraft.world.phys.shapes.CubeVoxelShape": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DecoratedPotBlockEntity": Internal.ClassInfo, "net.minecraft.core.BlockPos": Internal.ClassInfo, "net.pixelbank.burnt.block.WoodFire10Block": Internal.ClassInfo, "com.verr1.controlcraft.content.links.input.InputPortBlock": Internal.ClassInfo, "appeng.items.tools.fluix.FluixSpadeItem": Internal.ClassInfo, "com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock": Internal.ClassInfo, "net.minecraftforge.event.server.ServerLifecycleEvent": Internal.ClassInfo, "com.nukateam.ntgl.modules.enchantment.enchantments.ReclaimedEnchantment": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.propellant.IntegratedPropellantProjectile": Internal.ClassInfo, "com.mrh0.createaddition.energy.NodeRotation": Internal.ClassInfo, "net.minecraft.world.item.HoeItem": Internal.ClassInfo, "cc.tweaked_programs.cccbridge.common.minecraft.block.RedRouterBlock": Internal.ClassInfo, "java.util.function.DoubleBinaryOperator": Internal.ClassInfo, "forge.me.toastymop.combatlog.util.IEntityDataSaver": Internal.ClassInfo, "com.ordana.spelunkery.blocks.MagnetiteBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ClientPlayerNetworkEvent$LoggingOut": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.type.JsonDecorationType": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2DoubleFunction": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.AnyOfCondition$Builder": Internal.ClassInfo, "com.simibubi.create.content.equipment.toolbox.ToolboxBlock": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.CastingTableBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapelessRecipeSchema$ShapelessRecipeJS": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.HologramProjectorBlock": Internal.ClassInfo, "net.minecraft.core.AxisCycle": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootContext$Builder": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractChestBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeRecipe$Serializer": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedController": Internal.ClassInfo, "com.google.common.base.Suppliers$NonSerializableMemoizingSupplier": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelForestReinforcedBlastGlassBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingOakDoorBlock": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.gui.options.control.ControlElement": Internal.ClassInfo, "net.minecraft.world.item.enchantment.SoulSpeedEnchantment": Internal.ClassInfo, "net.mcreator.cbccw.item.ThiodiglycolItem": Internal.ClassInfo, "me.steinborn.krypton.mixin.shared.network.util.ServerPlayNetworkHandlerAccessor": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.BlockWrapper": Internal.ClassInfo, "com.nukateam.ntgl.common.foundation.particles.BulletHoleData": Internal.ClassInfo, "java.util.Spliterator$OfLong": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.KhBlock": Internal.ClassInfo, "net.minecraftforge.event.RegisterCommandsEvent": Internal.ClassInfo, "net.minecraft.advancements.critereon.SerializationContext": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelVersion": Internal.ClassInfo, "appeng.debug.EraserItem": Internal.ClassInfo, "xaero.hud.category.ui.node.EditorNode": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCaramelFortifiedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.ContainerEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor": Internal.ClassInfo, "io.netty.buffer.PooledByteBufAllocator": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedSteelReinforcedArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.AluminumOreBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.mortar_stone.MortarStoneBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SunflowerChainArmorBlockBlock": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockpanzergrauBlock": Internal.ClassInfo, "dev.architectury.registry.menu.MenuRegistry$ScreenFactory": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundMoveEntityPacket": Internal.ClassInfo, "net.minecraft.network.TickablePacketListener": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SwampFireSupressionSystemBlockBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.FissionBombBlock": Internal.ClassInfo, "net.minecraft.client.User$Type": Internal.ClassInfo, "xaero.hud.minimap.player.tracker.synced.ClientSyncedTrackedPlayerManager": Internal.ClassInfo, "vectorwing.farmersdelight.common.crafting.CookingPotRecipe$Serializer": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.zinc.ZincLargeBoilerBlock": Internal.ClassInfo, "net.minecraft.world.level.block.RedstoneWallTorchBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonReleased$Post": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ArrayRecipeComponent": Internal.ClassInfo, "net.minecraft.world.ticks.SerializableTickContainer": Internal.ClassInfo, "net.mcreator.sab.block.Lightsteelblock4boBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CharcoalExternalFluidTankBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.AbstractIntSet": Internal.ClassInfo, "xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemAPI": Internal.ClassInfo, "xaero.hud.minimap.element.render.MinimapElementRenderProvider": Internal.ClassInfo, "com.llamalad7.mixinextras.sugar.ref.LocalFloatRef": Internal.ClassInfo, "net.minecraft.client.resources.language.LanguageManager": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortList": Internal.ClassInfo, "net.mcreator.sab.block.Hardsteelblockcolored31Block": Internal.ClassInfo, "appeng.api.storage.ITerminalHost": Internal.ClassInfo, "xaero.pac.common.entity.IEntity": Internal.ClassInfo, "net.minecraft.data.CachedOutput": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ServerLevelKJS": Internal.ClassInfo, "com.simibubi.create.foundation.gui.widget.TooltipArea": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.VengefulChainArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.RepairItemRecipe": Internal.ClassInfo, "net.minecraft.world.level.block.FungusBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RiverFireSupressionSystemBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.gantry.GantryCarriageBlockEntity": Internal.ClassInfo, "com.simibubi.create.content.logistics.funnel.BeltFunnelBlock": Internal.ClassInfo, "appeng.items.tools.SettingsCategory": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownExperienceBottle": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket": Internal.ClassInfo, "net.minecraft.world.item.ArmorItem": Internal.ClassInfo, "com.tacz.guns.api.entity.ReloadState$StateType": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity": Internal.ClassInfo, "team.creative.creativecore.common.gui.integration.IGuiIntegratedParent": Internal.ClassInfo, "java.util.concurrent.atomic.AtomicInteger": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.motor.DynamicRevoluteMotorBlockEntity": Internal.ClassInfo, "net.minecraft.world.entity.VariantHolder": Internal.ClassInfo, "net.minecraft.client.color.block.BlockColor": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.beam.CopycatBeamBlock": Internal.ClassInfo, "com.dsvv.cbcat.cannon.twin_autocannon.MovesWithTwinAutocannonRecoilSpring": Internal.ClassInfo, "net.minecraft.world.level.block.WitherRoseBlock": Internal.ClassInfo, "xaero.map.region.MapPixel": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.CaveFilter$Type": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBambooFenceBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket": Internal.ClassInfo, "java.security.Key": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSnowArmorBlockBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.NeodymiumPillarBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildSackgasseBlock": Internal.ClassInfo, "net.minecraft.nbt.CollectionTag": Internal.ClassInfo, "com.railwayteam.railways.content.distant_signals.IOverridableSignal": Internal.ClassInfo, "com.nukateam.ntgl.common.foundation.blockentity.WorkbenchBlockEntity": Internal.ClassInfo, "dev.tr7zw.notenoughanimations.mixins.PlayerModelAccessor": Internal.ClassInfo, "slimeknights.tconstruct.world.block.SlimeDirtBlock": Internal.ClassInfo, "com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumFoggyReinforcedBlastGlassBlock": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.andesite.AndesiteLargeBoilerBlock": Internal.ClassInfo, "net.mcreator.sab.block.BrassffBlock": Internal.ClassInfo, "net.minecraft.world.item.BrushItem": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.crushing_wheels.MmbCrushingWheelControllerBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.receiver.PeripheralInterfaceBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMesaCageArmorBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2DoubleFunction": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyAndesiteBlock": Internal.ClassInfo, "xaero.common.minimap.waypoints.WaypointWorldContainer": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedExtendedDoubleCornerSlopePanelWallBlock": Internal.ClassInfo, "com.leclowndu93150.baguettelib.event.entity.death.LivingDeathEvent": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeModifier": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.model.FaceItem": Internal.ClassInfo, "net.minecraft.client.GuiMessage": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchlidBlankBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntBambooSlabBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.elevator.ElevatorContactBlockEntity": Internal.ClassInfo, "java.time.Period": Internal.ClassInfo, "com.codinglitch.simpleradio.core.registry.blocks.ReceiverBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildfahrradwegBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMilitaryElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickEmpty": Internal.ClassInfo, "com.supermartijn642.fusion.api.texture.SpritePreparationContext": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSeaPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.phys.Vec2": Internal.ClassInfo, "net.minecraft.world.phys.Vec3": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe": Internal.ClassInfo, "slimeknights.tconstruct.world.block.CrystalBlock": Internal.ClassInfo, "appeng.items.storage.StorageTier": Internal.ClassInfo, "net.minecraft.core.HolderGetter$Provider": Internal.ClassInfo, "com.atsuishio.superbwarfare.mobeffect.StrikeProtectionEffect": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.BoatPropellerBlock": Internal.ClassInfo, "appeng.api.networking.events.GridEvent": Internal.ClassInfo, "dan200.computercraft.shared.turtle.recipes.TurtleOverlayRecipe": Internal.ClassInfo, "org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory": Internal.ClassInfo, "net.minecraft.data.DataProvider$Factory": Internal.ClassInfo, "com.simibubi.create.content.trains.track.TrackShape": Internal.ClassInfo, "com.simibubi.create.content.decoration.encasing.CasingBlock": Internal.ClassInfo, "com.jozufozu.flywheel.api.FlywheelWorld": Internal.ClassInfo, "com.possible_triangle.sliceanddice.Content$createRecipeType$type$1": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.LicorootTreeWithSproutsFeature": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator": Internal.ClassInfo, "xaero.hud.category.ui.node.options.EditorOptionNode$Builder": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanel.FramedFlatInverseDoubleSlopePanelCornerBlock": Internal.ClassInfo, "java.lang.invoke.TypeDescriptor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCommandsPacket": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.cast_iron.CastIronLargeBoilerBlock": Internal.ClassInfo, "net.minecraft.world.item.BowlFoodItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration": Internal.ClassInfo, "org.valkyrienskies.mod.common.blockentity.TestHingeBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.StairBlockBuilder": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager": Internal.ClassInfo, "xaero.map.core.IWorldMapSMultiBlockChangePacket": Internal.ClassInfo, "mod.azure.azurelib.rewrite.util.state.State": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyJungleStrippedWoodBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.decoration.TrussBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.RocketPodChamberBlock": Internal.ClassInfo, "net.minecraft.world.level.gameevent.PositionSourceType": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.kinetic_motor.KineticMotorBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.ser.Serializers": Internal.ClassInfo, "net.minecraft.world.inventory.BrewingStandMenu": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.capitalism.CapitalismLargeBoilerBlockItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ModifiableItemKJS": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedSteelReinforcedCageArmorBlock": Internal.ClassInfo, "team.creative.creativecore.common.gui.sync.GuiSyncGlobalLayer": Internal.ClassInfo, "org.apache.logging.log4j.core.config.ReliabilityStrategy": Internal.ClassInfo, "net.minecraft.util.StringRepresentable$EnumCodec": Internal.ClassInfo, "net.minecraft.world.level.entity.EntitySection": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.NetherWorldCarver": Internal.ClassInfo, "com.atsuishio.superbwarfare.perk.Perk$Type": Internal.ClassInfo, "net.minecraft.client.renderer.RenderType": Internal.ClassInfo, "kotlin.Triple": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.OleicAcidFluidType": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.Annotated": Internal.ClassInfo, "xfacthd.framedblocks.common.block.pillar.FramedWallBlock": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet$Companion": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.PlacedFeature": Internal.ClassInfo, "com.fasterxml.jackson.databind.JsonNode$OverwriteMode": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumBlastGlassBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.RedArmorBlock": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModInfo$ModVersion": Internal.ClassInfo, "com.jozufozu.flywheel.backend.instancing.entity.EntityTypeExtension": Internal.ClassInfo, "com.codinglitch.lexiconfig.classes.LexiconPageData": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$FluidPlaceBlockEvent": Internal.ClassInfo, "org.valkyrienskies.mod.common.block.TestHingeBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.GreenArmorTrapdoorBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.item.IItemStack": Internal.ClassInfo, "xaero.hud.category.ui.entry.widget.EditorButton$PressActionWithContext": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$InteractionKeyMappingTriggered": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.SaltWaterFluidType": Internal.ClassInfo, "com.ordana.spelunkery.blocks.PortalFluidCauldronBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.shapes.VoxelShapeEmpty": Internal.ClassInfo, "xaero.common.mods.SupportIris": Internal.ClassInfo, "com.verr1.controlcraft.foundation.type.descriptive.SlotDirection": Internal.ClassInfo, "com.supermartijn642.core.item.BaseBlockItem": Internal.ClassInfo, "org.joml.primitives.Rayf": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.FenceGateBlockBuilder": Internal.ClassInfo, "net.mcreator.crustychunks.block.OrdinanceInlineFusionWarheadStage1Block": Internal.ClassInfo, "net.minecraft.client.model.geom.ModelPart": Internal.ClassInfo, "org.joml.primitives.Rayd": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBirchDoorBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.RemoveSpawnsProperties": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket$Action": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.SimplePlayerEventJS": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.RotationAxis": Internal.ClassInfo, "com.ordana.spelunkery.items.RopeLadderBlockItem": Internal.ClassInfo, "net.minecraft.client.gui.components.TabOrderedElement": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.YoLetterBlock": Internal.ClassInfo, "java.util.AbstractSequentialList": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyCherrySlabBlock": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientAdvancements$Listener": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.munitions.box.HeavyAutocannonAmmoContainerItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.EchoLetterBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.UrineFluidType": Internal.ClassInfo, "com.verr1.controlcraft.content.links.func.FunctionsBlockEntity": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.color.NoColor": Internal.ClassInfo, "net.minecraft.world.level.block.DetectorRailBlock": Internal.ClassInfo, "com.ordana.spelunkery.blocks.nephrite.NephriteFountainBlock": Internal.ClassInfo, "com.tacz.guns.api.client.animation.statemachine.AnimationState": Internal.ClassInfo, "xaero.hud.minimap.waypoint.render.WaypointDeleter": Internal.ClassInfo, "net.minecraft.advancements.FrameType": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.AzAbstractAnimationController": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.IEventHandler": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyStrippedOakLogBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSnowExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.fasterxml.jackson.annotation.PropertyAccessor": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.GunMeleeData": Internal.ClassInfo, "net.minecraft.client.renderer.entity.player.PlayerRenderer": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.welding.WeldableBlock": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BeeDebugRenderer": Internal.ClassInfo, "net.minecraft.world.phys.HitResult": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RedSandbagBlock": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.stacked_half_layer.CopycatStackedHalfLayerBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable": Internal.ClassInfo, "net.minecraft.client.gui.components.ObjectSelectionList": Internal.ClassInfo, "com.hlysine.create_connected.content.brassgearbox.BrassGearboxBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket": Internal.ClassInfo, "java.lang.Record": Internal.ClassInfo, "xaero.hud.category.ui.node.options.EditorOptionNode": Internal.ClassInfo, "me.steinborn.krypton.mod.shared.network.ClientConnectionEncryptionExtension": Internal.ClassInfo, "com.fasterxml.jackson.core.json.JsonReadFeature": Internal.ClassInfo, "com.tacz.guns.entity.shooter.ShooterDataHolder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedSteelPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "io.netty.util.concurrent.AbstractEventExecutorGroup": Internal.ClassInfo, "com.ordana.spelunkery.blocks.rock_salt.RockSaltWall": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyReleased": Internal.ClassInfo, "com.simibubi.create.content.equipment.wrench.IWrenchableWithBracket": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.lights.LightBulbBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.DoubleBlockHalf": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.GolemSensor": Internal.ClassInfo, "java.security.Permission": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase": Internal.ClassInfo, "com.verr1.controlcraft.mixinducks.IServerPlayerDuck": Internal.ClassInfo, "net.minecraft.network.protocol.Packet": Internal.ClassInfo, "net.minecraftforge.fml.event.config.ModConfigEvent$Reloading": Internal.ClassInfo, "net.minecraft.world.level.BaseCommandBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrushedDioriteBlock": Internal.ClassInfo, "net.minecraft.nbt.StreamTagVisitor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket": Internal.ClassInfo, "forge.me.thosea.badoptimizations.interfaces.EntityMethods": Internal.ClassInfo, "xaero.map.gui.message.MessageBox": Internal.ClassInfo, "net.minecraft.world.item.CompassItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blending.Blender$DistanceGetter": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyGraniteBlock": Internal.ClassInfo, "com.simibubi.create.content.decoration.palettes.ConnectedGlassBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntLeavesBlock": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.BoneAnimationQueue": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.WorldCarver": Internal.ClassInfo, "de.maxhenkel.voicechat.api.packets.LocationalSoundPacket$Builder": Internal.ClassInfo, "appeng.recipes.transform.TransformRecipeSerializer": Internal.ClassInfo, "net.minecraftforge.event.entity.player.ArrowNockEvent": Internal.ClassInfo, "com.tom.storagemod.block.IPaintable": Internal.ClassInfo, "net.mcreator.crustychunks.fluid.types.KeroseneFluidType": Internal.ClassInfo, "net.minecraft.client.sounds.Weighted": Internal.ClassInfo, "edn.stratodonut.drivebywire.blocks.WireNetworkBackupBlock": Internal.ClassInfo, "com.mojang.realmsclient.gui.task.RepeatedDelayStrategy": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityEvent": Internal.ClassInfo, "com.petrolpark.mixin.compat.create.accessor.client.OutlineParamsAccessor": Internal.ClassInfo, "com.railwayteam.railways.content.conductor.vent.VentBlock": Internal.ClassInfo, "com.happysg.radar.block.radar.bearing.RadarTrack": Internal.ClassInfo, "net.minecraft.client.Realms32BitWarningStatus": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RightBracketsBlock": Internal.ClassInfo, "xaero.hud.minimap.element.render.over.MinimapElementOverMapRendererHandler": Internal.ClassInfo, "net.minecraft.server.level.progress.StoringChunkProgressListener": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.trapdoor.CopycatTrapdoorBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.EnderDragon": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.data.KeyFrameData": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.IceCreamBlock": Internal.ClassInfo, "java.util.concurrent.Delayed": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.fluids.FlammableFluid": Internal.ClassInfo, "net.mcreator.sab.block.LightgraylightsteelblockBlock": Internal.ClassInfo, "appeng.blockentity.misc.ChargerBlockEntity": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.cannon_torpedo.CannonTorpedoProjectile": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.CraftingContainerKJS": Internal.ClassInfo, "com.dsvv.cbcat.mixin.BigCannonBlockMixin": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$AttachmentPropertyEventJS": Internal.ClassInfo, "com.mojang.brigadier.ImmutableStringReader": Internal.ClassInfo, "appeng.api.networking.GridFlags": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.motor.DynamicJointMotorBlock": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.InputKey": Internal.ClassInfo, "com.fasterxml.jackson.databind.node.ArrayNode": Internal.ClassInfo, "net.minecraft.client.renderer.texture.AbstractTexture": Internal.ClassInfo, "ht.treechop.common.settings.SyncedChopData": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.containers.blue.BlueContainerBlock": Internal.ClassInfo, "com.github.talrey.createdeco.items.ShippingContainerBlockItem": Internal.ClassInfo, "mezz.jei.api.recipe.transfer.IRecipeTransferError$Type": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsNotification": Internal.ClassInfo, "slimeknights.tconstruct.world.block.StickySlimeBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.PfostenUntenBlock": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawable": Internal.ClassInfo, "net.minecraft.world.level.block.BucketPickup": Internal.ClassInfo, "net.satisfy.brewery.registry.RecipeTypeRegistry$1": Internal.ClassInfo, "com.ordana.spelunkery.blocks.ModBaseEntityBlock": Internal.ClassInfo, "com.simibubi.create.content.decoration.girder.GirderEncasedShaftBlock": Internal.ClassInfo, "net.mcreator.sab.block.BrassyiBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.RawUraniumBlockBlock": Internal.ClassInfo, "net.minecraftforge.client.event.sound.PlaySoundEvent": Internal.ClassInfo, "net.minecraftforge.eventbus.api.IEventBus": Internal.ClassInfo, "com.mrh0.createaddition.index.CAFluids$NoColorFluidAttributes": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMorningElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabWingOrangeBlock": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.BallastBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.BaseFunction": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.normal.plastic.GlassPlasticPipeBlock": Internal.ClassInfo, "kotlin.enums.EnumEntries": Internal.ClassInfo, "com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity": Internal.ClassInfo, "com.almostreliable.unified.recipe.ClientRecipeTracker$Serializer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumVengefulCompositeArmorBlockBlock": Internal.ClassInfo, "java.lang.Appendable": Internal.ClassInfo, "com.tom.storagemod.block.InventoryProxyBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.RedArmorStairsBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$ItemCraftedEvent": Internal.ClassInfo, "net.minecraft.world.level.block.DispenserBlock": Internal.ClassInfo, "xaero.common.controls.ControlsHandler": Internal.ClassInfo, "de.srendi.advancedperipherals.common.items.MemoryCardItem": Internal.ClassInfo, "net.mcreator.sab.block.PurplelightsteelblockBlock": Internal.ClassInfo, "me.steinborn.krypton.mod.shared.network.ConfigurableAutoFlush": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockcamomesaBlock": Internal.ClassInfo, "net.minecraft.world.item.Item": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider": Internal.ClassInfo, "com.lazrproductions.cuffed.entity.base.IDetainableEntity": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ItemSupplier": Internal.ClassInfo, "net.minecraftforge.event.GameShuttingDownEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.HoeItemBuilder": Internal.ClassInfo, "net.mcreator.createtankdefenses.fluid.CoalFluidFluid": Internal.ClassInfo, "mcinterface1201.mixin.common.DimensionDataStorageMixin": Internal.ClassInfo, "net.minecraft.world.entity.decoration.HangingEntity": Internal.ClassInfo, "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer$DebugGoal": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumReinforcedBlastGlassBlock": Internal.ClassInfo, "com.smoothchunk.world.IChunkTimeSave": Internal.ClassInfo, "net.mcreator.sab.block.PlusBlock": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframeCallbacks$Builder": Internal.ClassInfo, "mcinterface1201.mixin.common.ConcretePowderBlockMixin": Internal.ClassInfo, "com.hlysine.create_connected.content.itemsilo.ItemSiloBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.small.EngineBackPartBlock": Internal.ClassInfo, "net.mcreator.sab.block.ArmorglassBlock": Internal.ClassInfo, "team.creative.creativecore.common.gui.GuiChildControl": Internal.ClassInfo, "xfacthd.framedblocks.common.item.FramedSignItem": Internal.ClassInfo, "team.creative.creativecore.common.util.math.box.AlignedBox": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.LootTableEntry": Internal.ClassInfo, "com.deltasf.createpropulsion.magnet.RedstoneMagnetBlock": Internal.ClassInfo, "xaero.map.region.MapLayer": Internal.ClassInfo, "net.mcreator.sab.block.BrownlightsteelblockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.CherryLeavesBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.LimeArmorOpticBlock": Internal.ClassInfo, "net.minecraft.world.level.block.VineBlock": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.controller.HeatingControllerBlock": Internal.ClassInfo, "team.creative.creativecore.common.util.math.geo.NormalPlaneF": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2CharFunction": Internal.ClassInfo, "team.creative.creativecore.common.util.math.geo.NormalPlaneD": Internal.ClassInfo, "net.minecraft.world.item.ItemFrameItem": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.beam.CopycatBeamBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.track.FakeTrackBlock": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockgelbBlock": Internal.ClassInfo, "com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.impl.ValueInjector": Internal.ClassInfo, "net.minecraft.world.entity.GlowSquid": Internal.ClassInfo, "net.minecraft.world.level.block.TrappedChestBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.RobotChuteBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMesaBlastGlassBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate": Internal.ClassInfo, "com.ordana.spelunkery.items.SaltBlockItem": Internal.ClassInfo, "net.minecraft.world.level.block.HayBlock": Internal.ClassInfo, "java.nio.file.PathMatcher": Internal.ClassInfo, "net.satisfy.brewery.effect.SnowWhiteEffect": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.furnace_engine.PoweredFlywheelBlock": Internal.ClassInfo, "appeng.blockentity.storage.SkyStoneTankBlockEntity": Internal.ClassInfo, "net.minecraft.client.resources.metadata.animation.AnimationMetadataSectionSerializer": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.DinosaurChopBlock": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.millstone.block.DeepslateDecoMillStoneBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMossCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.client.renderer.block.ModelBlockRenderer": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.functional.FanSailBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedIronBarsBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BlastLeavesBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelVengefulReinforcedCageArmorBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyStrippedBirchLogBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.links.proxy.ProxyLinkBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.SulfurBlockBlock": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.colossal_cogwheel.ColossalCogwheelBlock$Position$Clock": Internal.ClassInfo, "net.minecraft.server.ReloadableServerResources": Internal.ClassInfo, "dev.lambdaurora.lambdynlights.api.DynamicLightHandler": Internal.ClassInfo, "org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.OrangeArmorTrapdoorBlock": Internal.ClassInfo, "net.minecraft.network.chat.ChatDecorator": Internal.ClassInfo, "appeng.debug.MeteoritePlacerItem": Internal.ClassInfo, "com.getitemfromblock.create_tweaked_controllers.compat.ComputerCraft.ModSyncedPeripheral": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.AdvancementJS": Internal.ClassInfo, "com.probejs.features.plugin.VSCodeFileSavedEventJS": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntAcaciaDoorBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntCherryDoorBlock": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.apfsds_shot.APFSDSShotProjectile": Internal.ClassInfo, "com.verr1.controlcraft.foundation.camera.CameraMovementTracker": Internal.ClassInfo, "com.fasterxml.jackson.databind.cfg.MutableCoercionConfig": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteMap$Entry": Internal.ClassInfo, "org.luaj.vm2.lib.DebugLib$CallFrame": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.TravellingPoint$SteerDirection": Internal.ClassInfo, "net.minecraft.client.CloudStatus": Internal.ClassInfo, "appeng.items.storage.BasicStorageCell": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsLightBlueBlock": Internal.ClassInfo, "net.minecraft.client.resources.model.UnbakedModel": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.IMergeableBE": Internal.ClassInfo, "xaero.pac.common.parties.party.member.PartyMemberRank": Internal.ClassInfo, "net.minecraft.world.entity.monster.Silverfish": Internal.ClassInfo, "net.minecraft.SystemReport": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.cable_blocks.electric_post.ElectricPostBlockEntity": Internal.ClassInfo, "com.lazrproductions.cuffed.blocks.base.DetentionBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeFriendlyByteBuf": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.RetinalScannerBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.spatial.SpatialAnchorBlockEntity": Internal.ClassInfo, "com.dsvv.cbcat.cannon.twin_autocannon.ITwinAutocannonBlockEntity": Internal.ClassInfo, "com.google.gson.JsonDeserializationContext": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.nbt.IToolContext": Internal.ClassInfo, "com.supermartijn642.rechiseled.blocks.RechiseledBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRedstoneLampBlock": Internal.ClassInfo, "slimeknights.mantle.data.loadable.primitive.StringLoadable": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.munitions.AbstractHeavyAutocannonProjectileItem": Internal.ClassInfo, "com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator": Internal.ClassInfo, "me.dantaeusb.zetter.item.crafting.PaletteRechargeRecipe": Internal.ClassInfo, "net.minecraft.world.RandomSequences": Internal.ClassInfo, "net.mcreator.sab.block.GreendoublesteelblockBlock": Internal.ClassInfo, "java.time.temporal.TemporalField": Internal.ClassInfo, "net.minecraft.commands.arguments.ArgumentSignatures$Signer": Internal.ClassInfo, "java.util.function.ToDoubleFunction": Internal.ClassInfo, "com.github.alexthe666.citadel.server.generation.SpawnProbabilityModifier": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer": Internal.ClassInfo, "xfacthd.framedblocks.common.block.rail.FramedFancyRailBlock": Internal.ClassInfo, "net.minecraft.world.level.block.piston.PistonBaseBlock": Internal.ClassInfo, "mezz.jei.api.recipe.transfer.IRecipeTransferHandler": Internal.ClassInfo, "com.supermartijn642.fusion.api.util.Serializer": Internal.ClassInfo, "com.hlysine.create_connected.content.sequencedpulsegenerator.instructions.Instruction$ParameterConfig": Internal.ClassInfo, "net.minecraft.core.particles.DustParticleOptions": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.OilBarrelBlock": Internal.ClassInfo, "java.util.Calendar": Internal.ClassInfo, "com.ordana.spelunkery.items.NephriteDiodeItem": Internal.ClassInfo, "net.minecraft.stats.Stats": Internal.ClassInfo, "com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer": Internal.ClassInfo, "net.mcreator.cbccw.block.HydrochloricAcidBlock": Internal.ClassInfo, "appeng.items.contents.PortableCellMenuHost": Internal.ClassInfo, "org.apache.logging.log4j.core.Logger": Internal.ClassInfo, "net.minecraft.world.level.BlockAndTintGetter": Internal.ClassInfo, "net.minecraft.server.level.BlockDestructionProgress": Internal.ClassInfo, "com.simibubi.create.content.logistics.chute.ChuteBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.IItemDecorator": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.controller.TinyMultiblockControllerBlock": Internal.ClassInfo, "net.minecraft.world.item.ComplexItem": Internal.ClassInfo, "com.mrh0.createaddition.energy.network.EnergyNetwork": Internal.ClassInfo, "net.minecraft.world.item.enchantment.WaterWorkerEnchantment": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.ICopycatWithWrappedBlock": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.BasinLidBlock": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ThornsEnchantment": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.tag.AccessTagManager": Internal.ClassInfo, "de.maxhenkel.voicechat.api.packets.EntitySoundPacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumRiverReinforcedBlastGlassBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingCaveVinesBlock": Internal.ClassInfo, "net.minecraft.world.WorldlyContainerHolder": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelblockpanzergrauBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.small.turbine.TurbineEngineTileEntity": Internal.ClassInfo, "java.time.InstantSource": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerSleepInBedEvent": Internal.ClassInfo, "xaero.pac.common.server.player.config.api.IPlayerConfigManagerAPI": Internal.ClassInfo, "slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe": Internal.ClassInfo, "com.atsuishio.superbwarfare.item.PerkItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelRiverReinforcedArmorBlockBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.pane.FramedFloorBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.GiantAncientTreeFeature": Internal.ClassInfo, "org.apache.commons.lang3.mutable.MutableObject": Internal.ClassInfo, "net.minecraftforge.fml.config.ConfigFileTypeHandler": Internal.ClassInfo, "java.util.function.LongToDoubleFunction": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.ProjectileInfo": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2FloatMap$Entry": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.TravellingPoint$IPortalListener": Internal.ClassInfo, "com.happysg.radar.block.radar.bearing.RadarContraption": Internal.ClassInfo, "net.minecraft.core.HolderSet$Direct": Internal.ClassInfo, "com.fasterxml.jackson.dataformat.cbor.CBORFactoryBuilder": Internal.ClassInfo, "org.apache.logging.log4j.core.impl.LogEventFactory": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.ap_shell.APShellBlock": Internal.ClassInfo, "net.minecraft.advancements.AdvancementList": Internal.ClassInfo, "net.mcreator.sab.block.BrassbbBlock": Internal.ClassInfo, "xaero.map.core.IWorldMapServerLevel": Internal.ClassInfo, "net.mcreator.cbccw.item.ChlorineItem": Internal.ClassInfo, "com.google.common.reflect.Invokable": Internal.ClassInfo, "net.minecraftforge.client.gui.overlay.NamedGuiOverlay": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.ReplaceSphereConfiguration": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.FuzedCannonTorpedoProjectile": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.debug.DebugElectricBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildAutobahneBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMesaExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$GunEventJS": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyChiseledStoneBricksBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.render.ContraptionLighter": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockElementFace": Internal.ClassInfo, "net.mcreator.sab.block.BrasslBlock": Internal.ClassInfo, "net.minecraft.world.entity.player.PlayerModelPart": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCharcoalReinforcedArmorBlockBlock": Internal.ClassInfo, "software.bernie.geckolib.renderer.GeoRenderer": Internal.ClassInfo, "net.minecraft.world.level.block.WitherSkullBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.ThreeNumberBlock": Internal.ClassInfo, "dzwdz.chat_heads.HeadData": Internal.ClassInfo, "appeng.api.networking.events.statistics.GridStatisticsEvent": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedVerticalHalfStairsBlock": Internal.ClassInfo, "net.minecraft.world.phys.EntityHitResult": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannon_control.cannon_mount.YawControllerBlockEntity": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelcamoforestBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedSlotted": Internal.ClassInfo, "com.llamalad7.mixinextras.sugar.ref.LocalIntRef": Internal.ClassInfo, "net.geforcemods.securitycraft.misc.PageGroup": Internal.ClassInfo, "software.bernie.geckolib.loading.json.raw.ModelProperties": Internal.ClassInfo, "com.tom.peripherals.block.IForgeBlock": Internal.ClassInfo, "net.mcreator.cbccw.potion.CrystalBlueAddictionMobEffect": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.DirectionProperty": Internal.ClassInfo, "com.simibubi.create.content.trains.signal.SignalBoundary": Internal.ClassInfo, "java.security.KeyPair": Internal.ClassInfo, "net.mcreator.cbccw.potion.NapalmSoakedMobEffect": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCharcoalCageArmorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSunflowerPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiEvent$Post": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Info$Template": Internal.ClassInfo, "net.minecraft.world.level.block.FurnaceBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer": Internal.ClassInfo, "net.minecraftforge.client.event.RenderHandEvent": Internal.ClassInfo, "net.mcreator.crustychunks.block.GasBombBlock": Internal.ClassInfo, "com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock": Internal.ClassInfo, "org.apache.logging.log4j.MarkerManager$Log4jMarker": Internal.ClassInfo, "net.mcreator.sab.block.GBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.PlusSymbolBlock": Internal.ClassInfo, "com.mojang.realmsclient.dto.ValueObject": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.SugarGlassBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MuddyBulletproofGlassBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.builtup.BuiltUpHeatingRecipe$Serializer": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.shelless_he_shell.ShellessHEShellProjectile": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.differential.DummyDifferentialBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$Action": Internal.ClassInfo, "org.apache.commons.lang3.mutable.Mutable": Internal.ClassInfo, "net.mcreator.createtankdefenses.world.features.ores.AluminumOreFeature": Internal.ClassInfo, "org.apache.logging.log4j.core.lookup.StrMatcher": Internal.ClassInfo, "net.mcreator.cbccw.item.AcetonePeroxideItem": Internal.ClassInfo, "appeng.debug.ChunkLoaderBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.types.AnalogTypes": Internal.ClassInfo, "net.mcreator.cbccw.block.BleachBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSnowBlastGlassBlock": Internal.ClassInfo, "com.mrh0.createaddition.blocks.digital_adapter.ISpeedControllerAdapter": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.entity.util.MinecartAccessor": Internal.ClassInfo, "net.minecraft.world.level.block.BigDripleafBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntCollection": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.AddLakeProperties": Internal.ClassInfo, "com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity": Internal.ClassInfo, "com.simibubi.create.content.contraptions.bearing.ClockworkBearingBlock": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.ICopycatBlock": Internal.ClassInfo, "appeng.api.config.FuzzyMode": Internal.ClassInfo, "dev.latvian.mods.rhino.util.wrap.TypeWrappers": Internal.ClassInfo, "com.ordana.spelunkery.items.BunnyEarsItem": Internal.ClassInfo, "net.satisfy.vinery.core.block.CabinetBlock": Internal.ClassInfo, "com.mojang.serialization.DataResult": Internal.ClassInfo, "net.mcreator.crustychunks.block.FuelRods3Block": Internal.ClassInfo, "slimeknights.mantle.block.MantleCeilingHangingSignBlock": Internal.ClassInfo, "org.luaj.vm2.Prototype": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsGreenBlock": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.CopycatTransformableState$Part": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingDestroyBlockEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.HeightProviderType": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedVerticalStairsBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.LargeRocketPodChamberBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.GasDispenserBlock": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.ExtraDamage": Internal.ClassInfo, "com.simibubi.create.content.trains.graph.TrackEdgeIntersection": Internal.ClassInfo, "org.slf4j.Marker": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedScaffoldingBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.DistilledWaterFluid": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabWingBlueBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumAshesCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "org.joml.Matrix4x3d": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.CannonBehavior": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelVengefulPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingPlanks3Block": Internal.ClassInfo, "org.joml.Matrix4x3f": Internal.ClassInfo, "net.minecraft.world.entity.player.Inventory": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.OneThousandMillimetersMeasureBlockBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.links.logic.LogicGateBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.AbstractContraptionEntity$ContraptionRotationState": Internal.ClassInfo, "com.jozufozu.flywheel.api.Material": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.world.ServerWorldExtended": Internal.ClassInfo, "appeng.block.misc.CrankBlock": Internal.ClassInfo, "net.mcreator.cbccw.potion.MethanePoisonMobEffect": Internal.ClassInfo, "net.minecraft.world.DifficultyInstance": Internal.ClassInfo, "java.time.OffsetTime": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDustyReinforcedArmorBlockBlock": Internal.ClassInfo, "com.illusivesoulworks.comforts.mixin.AccessorPlayer": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformCustomSerializer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCellBlastGlassBlock": Internal.ClassInfo, "com.mojang.serialization.Codec$ResultFunction": Internal.ClassInfo, "net.spaceeye.vmod.mixin.BufferBuilderAccessor": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.LootPoolEntryType": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.kinetics.resistor.RedstoneResistorBlockEntity": Internal.ClassInfo, "com.fasterxml.jackson.databind.ser.impl.FailingSerializer": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.util.Point2i": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDesertCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder": Internal.ClassInfo, "com.jozufozu.flywheel.util.box.ImmutableBox": Internal.ClassInfo, "com.fasterxml.jackson.core.io.OutputDecorator": Internal.ClassInfo, "net.mcreator.crustychunks.block.DeepslateLeadOreBlock": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.ClientShip": Internal.ClassInfo, "xaero.map.file.export.PNGExportResult": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.HugeRedMushroomFeature": Internal.ClassInfo, "xaero.common.effect.MinimapStatusEffect": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Helmet": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$WriteMaskStateShard": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer": Internal.ClassInfo, "com.mojang.datafixers.util.Unit": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.HardLetterBlock": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.state.CookingPotSupport": Internal.ClassInfo, "net.minecraft.util.valueproviders.ClampedInt": Internal.ClassInfo, "net.ngbatz.createnuclearwar.block.UraniumOreBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SculkBlock": Internal.ClassInfo, "net.minecraft.client.model.HumanoidModel$ArmPose": Internal.ClassInfo, "com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingSpruceTrapdoorBlock": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.AbstractMinecartContainer": Internal.ClassInfo, "com.probejs.jdoc.document.DocumentMethod": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionBlock": Internal.ClassInfo, "org.luaj.vm2.lib.TwoArgFunction": Internal.ClassInfo, "com.codinglitch.simpleradio.api.central.Medium": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock": Internal.ClassInfo, "com.railwayteam.railways.mixin.AccessorCarriageBogey": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSwampExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingAzaleaBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.PotionBuilder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMesaPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowInfiniteEnchantment": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.industrial_gear.IndustrialGearBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$RenderInventoryMobEffects": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.SmithingBackpackUpgradeRecipe$Serializer": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.AnimationPointQueue": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$OverlayStateShard": Internal.ClassInfo, "net.minecraft.world.level.block.EquipableCarvedPumpkinBlock": Internal.ClassInfo, "java.util.jar.Manifest": Internal.ClassInfo, "com.deltasf.createpropulsion.optical_sensors.OpticalSensorBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.links.circuit.CircuitBlockEntity": Internal.ClassInfo, "io.netty.util.concurrent.ScheduledFuture": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration": Internal.ClassInfo, "dev.latvian.mods.kubejs.create.custom.SandpaperItemBuilder": Internal.ClassInfo, "com.ordana.spelunkery.items.ChannelItem": Internal.ClassInfo, "net.mcreator.crustychunks.block.RotaryAutoCannonBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent$IntRange": Internal.ClassInfo, "appeng.api.config.CpuSelectionMode": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RoastChickenBlock": Internal.ClassInfo, "com.electronwill.nightconfig.core.UnmodifiableCommentedConfig$Entry": Internal.ClassInfo, "net.mcreator.sab.block.OrangeBlock": Internal.ClassInfo, "slimeknights.mantle.recipe.helper.LoadableRecipeSerializer$TypeAware": Internal.ClassInfo, "org.luaj.vm2.LuaBoolean": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$RangeChoice": Internal.ClassInfo, "net.minecraft.world.level.block.CakeBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.Ravager": Internal.ClassInfo, "net.mcreator.sab.block.SBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2ShortFunction": Internal.ClassInfo, "com.dsvv.cbcat.cannon.SilencerBlockEntity": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BakedQuad": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket$Action": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemTransform": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLeverBlock": Internal.ClassInfo, "dev.tr7zw.notenoughanimations.access.PlayerData": Internal.ClassInfo, "com.simibubi.create.content.processing.recipe.ProcessingRecipe": Internal.ClassInfo, "io.netty.channel.ChannelOption": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCaramelReinforcedBlastGlassBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.command.CommandRegistryEventJS": Internal.ClassInfo, "net.minecraft.world.item.crafting.ArmorDyeRecipe": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.ILimitedGlobalStation": Internal.ClassInfo, "net.minecraft.world.level.block.TripWireHookBlock": Internal.ClassInfo, "mod.lucky77.block.base.MachinaWide": Internal.ClassInfo, "com.lazrproductions.cuffed.recipes.serializer.KeyMoldBakeRecipeSerializer": Internal.ClassInfo, "net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider$Context": Internal.ClassInfo, "net.minecraftforge.server.permission.events.PermissionGatherEvent": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.block.BrassCallBellBlock": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.value.Starter": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.ConversionCrucibleBlock": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.AzAnimationContext": Internal.ClassInfo, "net.mcreator.crustychunks.block.GrayArmorStairsBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket": Internal.ClassInfo, "net.minecraft.world.entity.player.Abilities": Internal.ClassInfo, "appeng.api.networking.crafting.CraftingJobStatus": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.block.TrayBlock$Empty": Internal.ClassInfo, "xaero.map.file.MapSaveLoad": Internal.ClassInfo, "com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SevenNumberBlock": Internal.ClassInfo, "org.apache.logging.log4j.core.util.Source": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ChestLidController": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedMagmaBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.config.IceCreamScoopFeatureConfiguration": Internal.ClassInfo, "com.simibubi.create.content.kinetics.clock.CuckooClockBlockEntity": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Donkey": Internal.ClassInfo, "io.netty.channel.ChannelId": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket": Internal.ClassInfo, "com.fasterxml.jackson.databind.ObjectReader": Internal.ClassInfo, "net.mcreator.sab.block.BrassultramarBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.FlyingAnimal": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.NoonLetterBlock": Internal.ClassInfo, "slimeknights.tconstruct.fluids.block.MobEffectLiquidBlock": Internal.ClassInfo, "net.mcreator.sab.block.BundeswehrcrossBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.MethylamineFluidType": Internal.ClassInfo, "java.util.concurrent.ScheduledThreadPoolExecutor": Internal.ClassInfo, "malte0811.ferritecore.mixin.dedupbakedquad.BakedQuadAccess": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.CavePaintingBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.world.ChunkRandomSource": Internal.ClassInfo, "mezz.jei.api.gui.builder.IRecipeSlotBuilder": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.model.color.interop.BlockColorsExtended": Internal.ClassInfo, "java.io.ObjectInput": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingSpruceDoorBlock": Internal.ClassInfo, "com.simibubi.create.foundation.outliner.Outline": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.ReportEvidence": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyAcaciaFenceGateBlock": Internal.ClassInfo, "net.minecraft.client.renderer.debug.RaidDebugRenderer": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeFluid": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobSpawnEvent": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RedConcretebagBlock": Internal.ClassInfo, "java.util.function.DoubleUnaryOperator": Internal.ClassInfo, "dynamic_fps.impl.util.duck.DuckScreen": Internal.ClassInfo, "net.minecraft.world.item.enchantment.TridentImpalerEnchantment": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.component.SearedSoulGlassBlock": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor": Internal.ClassInfo, "java.lang.Thread$UncaughtExceptionHandler": Internal.ClassInfo, "xfacthd.framedblocks.api.predicate.contex.NonDetailedConnectionPredicate": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.cannons.torpedo_tube.breeches.sliding_breech.TorpedoSlidingBreechBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.storage.CapacitorBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.AutoGyroBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.ConverterBlock": Internal.ClassInfo, "java.time.chrono.ChronoLocalDate": Internal.ClassInfo, "appeng.recipes.handlers.InscriberRecipe": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument$Info$Template": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.energy_components.transistor.TransistorBlock": Internal.ClassInfo, "net.mcreator.sab.block.BrassxBlock": Internal.ClassInfo, "com.simibubi.create.content.fluids.FlowSource": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.generation.large_generator.StatorBlock": Internal.ClassInfo, "java.util.stream.IntStream$IntMapMultiConsumer": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.MinecraftRemapper": Internal.ClassInfo, "com.connectivity.networkstats.IWrappedPacket": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.display.gun.GunLod": Internal.ClassInfo, "net.minecraft.world.level.chunk.storage.ChunkStorage": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelWoodsReinforcedBlastGlassBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed": Internal.ClassInfo, "com.jozufozu.flywheel.util.DiffuseLightCalculator": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.transmitter.PeripheralProxyBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.GobthumperBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.casting.CannonCastMouldBlock": Internal.ClassInfo, "dev.aika.taczjs.forge.events.shooter.LivingEntityMeleeEvent": Internal.ClassInfo, "net.minecraft.client.Camera$NearPlane": Internal.ClassInfo, "java.util.concurrent.RejectedExecutionHandler": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.component.SearedLadderBlock": Internal.ClassInfo, "org.valkyrienskies.physics_api.PhysicsBodyInertiaData": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgePotion": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.controller.MelterBlock": Internal.ClassInfo, "com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDustyCageArmorBlock": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowFireEnchantment": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.BlankEngineBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.large.LargePumpjackHammerPartBlock": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.render.immediate.model.ModelPartData": Internal.ClassInfo, "java.text.CharacterIterator": Internal.ClassInfo, "appeng.api.storage.cells.IBasicCellItem": Internal.ClassInfo, "com.simibubi.create.content.kinetics.simpleRelays.ICogWheel": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCharcoalCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "com.getitemfromblock.create_tweaked_controllers.item.TweakedLinkedControllerItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCreamElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "appeng.items.tools.GuideItem": Internal.ClassInfo, "java.security.PrivilegedExceptionAction": Internal.ClassInfo, "com.github.alexthe666.citadel.server.entity.ICitadelDataEntity": Internal.ClassInfo, "net.geforcemods.securitycraft.util.IBlockMine": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.large.LargePumpjackHammerConnectorBlock": Internal.ClassInfo, "org.embeddedt.embeddium.api.model.EmbeddiumBakedModelExtension": Internal.ClassInfo, "org.antarcticgardens.newage.content.generation.magnets.IMagneticBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.DustyExternalFluidTankBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCellReinforcedArmorBlockBlock": Internal.ClassInfo, "com.lazrproductions.cuffed.enchantment.DrainEnchantment": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerPacketListener": Internal.ClassInfo, "net.satisfy.vinery.core.recipe.ApplePressFermentingRecipe": Internal.ClassInfo, "net.minecraft.world.level.block.InfestedRotatedPillarBlock": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.ClientShipTransformProvider": Internal.ClassInfo, "net.minecraft.client.GuiMessageTag$Icon": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelFoggyExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.decoration.palettes.LayeredBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ShortFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidWrapper": Internal.ClassInfo, "net.mcreator.sab.block.PurplesteelblockBlock": Internal.ClassInfo, "net.minecraft.client.gui.font.FontSet": Internal.ClassInfo, "java.nio.file.attribute.GroupPrincipal": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer": Internal.ClassInfo, "net.minecraft.world.inventory.ContainerListener": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmithingTransformRecipe$Serializer": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.InputItem": Internal.ClassInfo, "terrablender.worldgen.IExtendedParameterList": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelcamosnowBlock": Internal.ClassInfo, "com.jozufozu.flywheel.core.materials.FlatLit": Internal.ClassInfo, "net.minecraft.util.valueproviders.UniformFloat": Internal.ClassInfo, "mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe": Internal.ClassInfo, "appeng.recipes.mattercannon.MatterCannonAmmo": Internal.ClassInfo, "org.embeddedt.modernfix.duck.IBlockState": Internal.ClassInfo, "com.fasterxml.jackson.core.JsonFactory": Internal.ClassInfo, "net.satisfy.vinery.core.block.PaleStemBlock": Internal.ClassInfo, "mod.azure.azurelib.core.keyframe.event.data.CustomInstructionKeyframeData": Internal.ClassInfo, "net.minecraft.core.RegistryAccess$Frozen": Internal.ClassInfo, "java.lang.IllegalStateException": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$OutputStateShard": Internal.ClassInfo, "net.minecraft.server.network.ServerPlayerConnection": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowDamageEnchantment": Internal.ClassInfo, "com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.GlycerolFluidType": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.OceanFloraBlock": Internal.ClassInfo, "net.minecraft.client.HotbarManager": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.VillagerBabiesSensor": Internal.ClassInfo, "net.minecraft.client.sounds.MusicManager": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.coaxial_gear.LongShaftBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.EntityTrackingSectionAccessor": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.radial.large.LargeRadialEngineBlock": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.ReportEnvironment": Internal.ClassInfo, "net.minecraft.world.inventory.StonecutterMenu": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationContext": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingKnockBackEvent": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AmmoniumNitrateFluid$Source": Internal.ClassInfo, "xaero.map.mcworld.WorldMapClientWorldData": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$MouseButton": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLavaCauldronBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedBarbedWireBlock": Internal.ClassInfo, "net.minecraft.world.level.block.LiquidBlockContainer": Internal.ClassInfo, "com.electronwill.nightconfig.core.io.WritingMode": Internal.ClassInfo, "java.util.HashMap": Internal.ClassInfo, "mod.azure.azurelib.entities.TickingLightBlock": Internal.ClassInfo, "net.minecraft.client.gui.components.events.ContainerEventHandler": Internal.ClassInfo, "net.mcreator.crustychunks.block.SummonatorActiveBlock": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.airdropped_torpedo.AirdroppedTorpedoProjectile": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ComparatorBlockEntity": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingPotatoesBlock": Internal.ClassInfo, "dan200.computercraft.api.upgrades.UpgradeData": Internal.ClassInfo, "mezz.jei.api.recipe.category.IRecipeCategory": Internal.ClassInfo, "com.probejs.jdoc.property.PropertyParam": Internal.ClassInfo, "xfacthd.framedblocks.common.block.interactive.FramedWeightedPressurePlateBlock": Internal.ClassInfo, "net.ngbatz.createnuclearwar.item.HazmatSuitItem$Helmet": Internal.ClassInfo, "net.minecraft.world.level.block.WallTorchBlock": Internal.ClassInfo, "net.satisfy.vinery.core.block.FacingBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory": Internal.ClassInfo, "com.petrolpark.client.creativemodetab.CustomTab": Internal.ClassInfo, "net.mcreator.sab.block.BrassaeBlock": Internal.ClassInfo, "com.dsvv.cbcat.cannon.twin_autocannon.TwinAutocannonBreechBlockEntity": Internal.ClassInfo, "org.valkyrienskies.mod.common.item.ShipCreatorItem": Internal.ClassInfo, "net.minecraft.nbt.NumericTag": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongOpenHashSet": Internal.ClassInfo, "net.mcreator.cbccw.block.AmmoniaBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSeaReinforcedCageArmorBlock": Internal.ClassInfo, "appeng.blockentity.networking.CreativeEnergyCellBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.event.ClientPlayerNetworkEvent$Clone": Internal.ClassInfo, "net.minecraft.world.effect.MobEffect": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AdvancementEvent$AdvancementProgressEvent": Internal.ClassInfo, "net.minecraft.world.item.ArmorStandItem": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.wrapper.ColorWrapper": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOreBlock": Internal.ClassInfo, "net.minecraft.world.SimpleContainer": Internal.ClassInfo, "net.minecraft.tags.TagManager$LoadResult": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SmallRadarBlock": Internal.ClassInfo, "com.happysg.radar.block.monitor.MonitorFilter": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.logistics.item_stockpile.ItemStockpileBlock": Internal.ClassInfo, "ht.treechop.common.settings.SneakBehavior": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumFoggyReinforcedCageArmorBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderLivingEvent": Internal.ClassInfo, "dev.aika.taczjs.forge.events.index.AttachmentIndexLoadEvent": Internal.ClassInfo, "slimeknights.tconstruct.tables.block.TabbedTableBlock": Internal.ClassInfo, "net.mcreator.sab.block.Brass4Block": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumWoodsCageArmorBlock": Internal.ClassInfo, "appeng.blockentity.spatial.SpatialPylonBlockEntity$AxisPosition": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.flarestack.FlarestackBlockEntity": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.metal_processing.blast_furnace.BlastFurnaceOutputBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListener$DeliveryMode": Internal.ClassInfo, "com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition": Internal.ClassInfo, "net.mcreator.sab.block.BrassminusBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BlazingPlanksBlock": Internal.ClassInfo, "org.joml.primitives.LineSegmentf": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.ThiodiglycolFluidType": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronState": Internal.ClassInfo, "javax.script.Bindings": Internal.ClassInfo, "me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationFrameAccessor": Internal.ClassInfo, "com.fasterxml.jackson.databind.cfg.CoercionInputShape": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.diagonal_girder.DiagonalGirderBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.TintedGlassTrapdoorBlock": Internal.ClassInfo, "net.minecraft.server.players.UserBanListEntry": Internal.ClassInfo, "net.minecraft.world.item.SignItem": Internal.ClassInfo, "net.minecraftforge.eventbus.ListenerList": Internal.ClassInfo, "com.fasterxml.jackson.core.FormatFeature": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.motor.AbstractKinematicMotor": Internal.ClassInfo, "org.embeddedt.embeddium.api.OptionGUIConstructionEvent": Internal.ClassInfo, "com.mojang.datafixers.DataFixer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelFoggyPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.MutableToolTier": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelStorageSource$LevelCandidates": Internal.ClassInfo, "de.srendi.advancedperipherals.common.blocks.PlayerDetectorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelForestReinforcedCageArmorBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.normal.brass.GlassBrassPipeBlock": Internal.ClassInfo, "appeng.block.crafting.ICraftingUnitType": Internal.ClassInfo, "net.minecraftforge.client.event.RenderPlayerEvent$Post": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntHighGrassBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile": Internal.ClassInfo, "de.srendi.advancedperipherals.common.blocks.RedstoneIntegratorBlock": Internal.ClassInfo, "org.lwjgl.CLongBuffer": Internal.ClassInfo, "team.creative.creativecore.mixin.StringSplitterAccessor": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.debug.DebugSourceBlockEntity": Internal.ClassInfo, "io.netty.channel.ChannelProgressiveFuture": Internal.ClassInfo, "com.codinglitch.simpleradio.core.registry.blocks.RadiosmitherBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabWingMagentaBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonLandingPhase": Internal.ClassInfo, "net.minecraft.client.resources.sounds.Sound$Type": Internal.ClassInfo, "com.jozufozu.flywheel.event.RenderLayerEvent": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MeasureLetterBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.TFMGHorizontalDirectionalBlock": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.AnimationPoint": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.PeppermintPileFeature": Internal.ClassInfo, "net.satisfy.vinery.core.effect.ExpandableEffect": Internal.ClassInfo, "cpw.mods.jarhandling.SecureJar": Internal.ClassInfo, "net.minecraft.world.entity.monster.piglin.PiglinBrute": Internal.ClassInfo, "com.tacz.guns.init.ModRecipe$1": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.builtup.BuiltUpCannonBlock": Internal.ClassInfo, "net.satisfy.brewery.block.property.Heat": Internal.ClassInfo, "slimeknights.tconstruct.library.recipe.material.ShapedMaterialRecipe": Internal.ClassInfo, "net.minecraft.world.level.Level": Internal.ClassInfo, "net.minecraft.world.scores.Objective": Internal.ClassInfo, "net.mcreator.cbccw.fluid.HydrogenPeroxideFluid$Source": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.NameTransformer$NopTransformer": Internal.ClassInfo, "appeng.blockentity.storage.ChestBlockEntity": Internal.ClassInfo, "com.fasterxml.jackson.dataformat.cbor.CBORGenerator": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.capitalism.CapitalismBoilerStructure": Internal.ClassInfo, "net.minecraft.world.entity.Display$BlockDisplay": Internal.ClassInfo, "com.fasterxml.jackson.core.TSFBuilder": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableBuilder": Internal.ClassInfo, "java.nio.charset.CodingErrorAction": Internal.ClassInfo, "com.fasterxml.jackson.databind.Module$SetupContext": Internal.ClassInfo, "com.simibubi.create.content.trains.graph.TrackGraph": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableAnimated$StartDirection": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongBidirectionalIterator": Internal.ClassInfo, "net.minecraftforge.event.brewing.PotionBrewEvent$Post": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.world.chunk.ClassGroupFilterableList": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonschema.SchemaAware": Internal.ClassInfo, "java.nio.DoubleBuffer": Internal.ClassInfo, "net.minecraftforge.common.crafting.conditions.IConditionSerializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize": Internal.ClassInfo, "snownee.jade.addon.mixin.create.BacktankBlockEntityAccess": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.ArrayBuilders": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSnowCageArmorBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceArgument$Info": Internal.ClassInfo, "net.minecraft.world.entity.animal.Parrot": Internal.ClassInfo, "xfacthd.framedblocks.common.block.pillar.FramedThreewayCornerPillarBlock": Internal.ClassInfo, "com.dsvv.cbcat.cannon.twin_autocannon.TwinAutocannonBlockItem": Internal.ClassInfo, "net.minecraft.server.MinecraftServer$ReloadableResources": Internal.ClassInfo, "net.minecraftforge.fluids.FluidType$Properties": Internal.ClassInfo, "net.satisfy.brewery.effect.DrunkEffect": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.casing.forge.CasingCollisionBlockImpl": Internal.ClassInfo, "net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.cannons.torpedo_tube.TorpedoTubeBaseBlock": Internal.ClassInfo, "com.jozufozu.flywheel.core.layout.LayoutItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.YetLetterBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.TrainStatus": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerBlock$State": Internal.ClassInfo, "com.probejs.jdoc.property.PropertyValue": Internal.ClassInfo, "net.minecraft.util.random.WeightedEntry$Wrapper": Internal.ClassInfo, "xaero.hud.category.ui.entry.EditorListEntry": Internal.ClassInfo, "com.tacz.guns.client.model.functional.ShellRender": Internal.ClassInfo, "net.minecraft.world.level.material.FogType": Internal.ClassInfo, "de.keksuccino.melody.mixin.mixins.common.client.IMixinSoundEngine": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RopeBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.Scriptable": Internal.ClassInfo, "net.minecraftforge.eventbus.api.IGenericEvent": Internal.ClassInfo, "com.simibubi.create.content.logistics.vault.ItemVaultBlock": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarrationThunk": Internal.ClassInfo, "com.simibubi.create.content.logistics.crate.CrateBlockEntity": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.normal.steel.GlassSteelPipeBlock": Internal.ClassInfo, "com.mrh0.createaddition.blocks.creative_energy.CreativeEnergyBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType": Internal.ClassInfo, "net.minecraft.world.level.block.BannerBlock": Internal.ClassInfo, "java.util.concurrent.Callable": Internal.ClassInfo, "org.apache.logging.log4j.core.time.Instant": Internal.ClassInfo, "ht.treechop.common.properties.ChoppedLogShape": Internal.ClassInfo, "com.simibubi.create.content.kinetics.crank.ValveHandleBlock": Internal.ClassInfo, "xaero.hud.minimap.waypoint.TemporaryWaypointHandler": Internal.ClassInfo, "java.util.ArrayList": Internal.ClassInfo, "com.mojang.authlib.properties.Property": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.GunPropertyModifier": Internal.ClassInfo, "net.mcreator.cbccw.item.DistilledWaterItem": Internal.ClassInfo, "net.minecraft.world.entity.decoration.Painting": Internal.ClassInfo, "net.minecraftforge.common.data.ExistingFileHelper$IResourceType": Internal.ClassInfo, "com.simibubi.create.content.fluids.pipes.valve.FluidValveBlock": Internal.ClassInfo, "appeng.me.cluster.implementations.CraftingCPUCluster": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.PumpjackBearingBBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.OrdinanceIRSeekerHeadBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2ReferenceFunction": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.ControlSurfaceOffsetBottomBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.decoration.kinetics.flywheels.TFMGFlywheelBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.Train": Internal.ClassInfo, "net.minecraftforge.common.util.FakePlayer": Internal.ClassInfo, "xaero.common.effect.NoWaypointsEffect": Internal.ClassInfo, "slimeknights.tconstruct.tables.block.ChestBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.HangingSignBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOvergrownArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.AmbientAdditionsSettings": Internal.ClassInfo, "net.minecraft.world.level.portal.PortalShape": Internal.ClassInfo, "net.mcreator.cbccw.fluid.MethanolFluid$Flowing": Internal.ClassInfo, "net.minecraft.network.FriendlyByteBuf$Writer": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IBufferBlockedTrain": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.AlternativesEntry$Builder": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.ConcreteBeanPropertyBase": Internal.ClassInfo, "org.apache.maven.repository.Proxy": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.MinecraftClientKJS": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntIvyBlock": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.recipe.TimelessRecipeJS": Internal.ClassInfo, "immersive_aircraft.entity.misc.WeaponMount$Type": Internal.ClassInfo, "net.minecraftforge.common.util.MutableHashedLinkedMap$IdentityStrategy": Internal.ClassInfo, "net.minecraft.world.entity.ai.gossip.GossipContainer": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Result": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$ItemDisplayRenderInfo": Internal.ClassInfo, "appeng.api.networking.IGridNodeService": Internal.ClassInfo, "java.time.chrono.IsoEra": Internal.ClassInfo, "net.mcreator.cbccw.fluid.ChlorineFluid$Flowing": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedFenceBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrimsonFireSupressionSystemBlockBlock": Internal.ClassInfo, "com.probejs.features.plugin.DocGenerationEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket": Internal.ClassInfo, "com.ordana.spelunkery.blocks.rock_salt.SaltLampBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.ScheduledEvents$Callback": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMilitaryPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.entity.Display$BillboardConstraints": Internal.ClassInfo, "net.minecraftforge.event.level.SleepFinishedTimeEvent": Internal.ClassInfo, "mezz.jei.api.gui.widgets.ISlottedRecipeWidget": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.WhalefallFeature": Internal.ClassInfo, "com.drmangotea.tfmg.base.DebugBlock": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.ChatReportBuilder$ChatReport": Internal.ClassInfo, "com.tacz.guns.api.client.animation.ObjectAnimationSoundChannel": Internal.ClassInfo, "net.mcreator.sab.block.SteelblockcamoswampBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.HeightmapPlacement": Internal.ClassInfo, "com.atsuishio.superbwarfare.tools.Ammo": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMilitaryElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SureLetterBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCreamReinforcedCageArmorBlock": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryProperty$GameMode": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelBlastGlassBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumSidePanelPlatingLightGrayBlock": Internal.ClassInfo, "net.minecraft.network.chat.OutgoingChatMessage": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest": Internal.ClassInfo, "net.satisfy.brewery.block.brewingstation.BrewTimerBlock": Internal.ClassInfo, "net.minecraft.resources.ResourceKey": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MossBulletproofGlassBlock": Internal.ClassInfo, "xaero.map.gui.ScreenBase": Internal.ClassInfo, "xaero.hud.minimap.world.MinimapDimensionHelper": Internal.ClassInfo, "net.satisfy.brewery.effect.HarddrinkingEffect": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.nbt.ToolDataNBT": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour$TankSegment": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MilitaryExternalFuelTankBlock": Internal.ClassInfo, "net.minecraft.world.level.LevelHeightAccessor": Internal.ClassInfo, "appeng.items.storage.ViewCellItem": Internal.ClassInfo, "net.mcreator.sab.block.GraydoublesteelblockBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventExit": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelVengefulElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectMap": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CeramicBulletproofGlassBlock": Internal.ClassInfo, "corgitaco.corgilib.entity.IsInsideStructureTracker": Internal.ClassInfo, "net.minecraft.world.entity.animal.goat.Goat": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingBlackBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.joints.RevoluteJointBlockEntity": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$HarvestCheck": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour$ProcessingResult": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.mines.FurnaceMineBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ReplaceBlockFeature": Internal.ClassInfo, "net.minecraft.world.entity.animal.frog.Frog": Internal.ClassInfo, "com.verr1.controlcraft.content.links.circuit.IoData": Internal.ClassInfo, "net.mcreator.crustychunks.block.RadioactiveAshBlock": Internal.ClassInfo, "xaero.hud.category.ui.node.options.text.EditorTextFieldOptionsNode$Builder": Internal.ClassInfo, "mod.azure.azurelib.enchantments.IncendiaryEnchantment": Internal.ClassInfo, "com.atsuishio.superbwarfare.api.event.PreKillEvent$Indicator": Internal.ClassInfo, "net.mcreator.sab.block.SixBlock": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedGameEventExtension": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AmmoniumNitrateFluid": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.RadrockUraniumOreBlock": Internal.ClassInfo, "xaero.common.gui.MyOptions": Internal.ClassInfo, "software.bernie.geckolib.core.object.DataTicket": Internal.ClassInfo, "xaero.common.minimap.region.MinimapChunk": Internal.ClassInfo, "org.apache.logging.log4j.core.config.Reconfigurable": Internal.ClassInfo, "com.fasterxml.jackson.dataformat.cbor.CBORParser": Internal.ClassInfo, "edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.platform.IngredientPlatformHelper": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSeaReinforcedCageArmorBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectFunction": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.phantom.PhantomTrackBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerXpEvent$LevelChange": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.sap_shell.SAPShellBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.links.func.FunctionsBlock": Internal.ClassInfo, "com.simibubi.create.foundation.utility.BlockFace": Internal.ClassInfo, "net.minecraft.world.level.levelgen.Aquifer$FluidPicker": Internal.ClassInfo, "net.minecraft.world.level.block.IceBlock": Internal.ClassInfo, "dan200.computercraft.shared.recipe.ShapelessRecipeSpec": Internal.ClassInfo, "appeng.blockentity.misc.InterfaceBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor": Internal.ClassInfo, "net.minecraft.client.resources.TextureAtlasHolder": Internal.ClassInfo, "com.mojang.serialization.Lifecycle": Internal.ClassInfo, "xfacthd.framedblocks.common.block.sign.FramedWallHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.entity.HasCustomInventoryScreen": Internal.ClassInfo, "java.security.ProtectionDomain": Internal.ClassInfo, "java.nio.channels.WritableByteChannel": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.DustyOpenTankHatchBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.SummonationBlock": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.value.StringEnumValue": Internal.ClassInfo, "io.netty.buffer.ByteBufAllocatorMetricProvider": Internal.ClassInfo, "java.nio.FloatBuffer": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.low_grade_fuel.LowGradeFuelEngineBlockEntity": Internal.ClassInfo, "com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBambooDoorBlock": Internal.ClassInfo, "org.valkyrienskies.mod.mixin.mod_compat.create.accessors.OutlineParamsAccessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CellChainArmorBlockBlock": Internal.ClassInfo, "com.jozufozu.flywheel.event.BeginFrameEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.util.ITintable": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.PanicButtonBlock": Internal.ClassInfo, "com.mojang.datafixers.util.Either$Mu": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.headstock.HeadstockBlockEntity": Internal.ClassInfo, "com.hlysine.create_connected.content.inventorybridge.InventoryBridgeBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.BlockLootEventJS": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.ICannonBlockEntity": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteMap": Internal.ClassInfo, "net.mcreator.crustychunks.block.ReinforcedGlassBlock": Internal.ClassInfo, "com.petrolpark.tube.TubeBehaviour": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$StartTracking": Internal.ClassInfo, "de.maxhenkel.voicechat.api.Position": Internal.ClassInfo, "com.mrh0.createaddition.blocks.digital_adapter.DigitalAdapterBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedDoubleStairsBlock": Internal.ClassInfo, "net.minecraft.util.valueproviders.FloatProviderType": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.BlockGeometryBakingContext": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage": Internal.ClassInfo, "net.minecraft.world.level.levelgen.BelowZeroRetrogen": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedTitaniumArmorBlockBlock": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.TimelessForgeEventWrappers$GunReloadWrapper": Internal.ClassInfo, "slimeknights.mantle.data.loadable.Loadable": Internal.ClassInfo, "com.railwayteam.railways.content.fuel.tank.FuelTankBlock$Shape": Internal.ClassInfo, "net.pixelbank.burnt.block.BlazingWoodBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanel.FramedExtendedSlopePanelBlock": Internal.ClassInfo, "xaero.pac.common.server.player.config.api.PlayerConfigType": Internal.ClassInfo, "com.mojang.blaze3d.platform.IconSet": Internal.ClassInfo, "java.util.PrimitiveIterator$OfDouble": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight": Internal.ClassInfo, "com.hlysine.create_connected.CCGuiTextures": Internal.ClassInfo, "org.valkyrienskies.eureka.block.BallastBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlockEntity": Internal.ClassInfo, "dan200.computercraft.api.turtle.TurtleUpgradeType": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeSerializer": Internal.ClassInfo, "com.simibubi.create.content.trains.track.TrackMaterial$TrackModelHolder": Internal.ClassInfo, "net.satisfy.brewery.effect.ToxicTouchEffect": Internal.ClassInfo, "de.maxhenkel.voicechat.api.ServerPlayer": Internal.ClassInfo, "net.mcreator.sab.block.BrassmyagkiiBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.items.SecurityCameraItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSwampReinforcedCageArmorBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.pillar.FramedCornerPillarBlock": Internal.ClassInfo, "net.minecraft.world.item.ItemStack$TooltipPart": Internal.ClassInfo, "net.mcreator.sab.block.DoublesteelblockcamoswampBlock": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarratableEntry$NarrationPriority": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType$ContextlessType": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.CopycatBaseBlock": Internal.ClassInfo, "com.mojang.blaze3d.platform.InputConstants$Key": Internal.ClassInfo, "net.minecraft.world.level.block.CactusBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDustyFortifiedArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMilitaryBlastGlassBlock": Internal.ClassInfo, "net.minecraft.commands.arguments.ArgumentSignatures$Entry": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AnvilRepairEvent": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.shellless_ap_shot.ShellessAPShotProjectile": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.PainterObjectStorage": Internal.ClassInfo, "xaero.map.gui.dropdown.DropDownWidget": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.SensorBlock": Internal.ClassInfo, "com.ordana.spelunkery.worldgen.features.HugeConkFungusFeature": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.UraniumFullBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.EnchantmentBuilder$PostFunction": Internal.ClassInfo, "com.simibubi.create.content.kinetics.gauge.GaugeBlock": Internal.ClassInfo, "com.tom.storagemod.util.ItemPredicate": Internal.ClassInfo, "net.minecraft.world.level.levelgen.PositionalRandomFactory": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot": Internal.ClassInfo, "com.mojang.datafixers.types.Type$TypeError": Internal.ClassInfo, "java.io.Reader": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$Output": Internal.ClassInfo, "java.security.PrivateKey": Internal.ClassInfo, "net.mcreator.crustychunks.block.OrdinanceClusterWarheadBlock": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.InaccuracyType": Internal.ClassInfo, "net.minecraftforge.fml.config.ModConfig": Internal.ClassInfo, "net.minecraftforge.registries.RegisterEvent": Internal.ClassInfo, "com.simibubi.create.content.trains.bogey.BogeyInstance": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ChestBlockEntity": Internal.ClassInfo, "net.satisfy.brewery.block.barrel.BigBarrelRightHeadBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.FoggyChainArmorBlockBlock": Internal.ClassInfo, "net.mcreator.sab.block.BluehardsteelblockBlock": Internal.ClassInfo, "appeng.items.materials.StorageComponentItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSnowReinforcedArmorBlockBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.HydrogenSulfiteFluid": Internal.ClassInfo, "appeng.recipes.entropy.EntropyRecipeSerializer": Internal.ClassInfo, "net.mcreator.crustychunks.block.DieselBlock": Internal.ClassInfo, "java.lang.Number": Internal.ClassInfo, "net.minecraft.client.resources.sounds.Sound": Internal.ClassInfo, "me.jellysquid.mods.sodium.mixin.features.textures.NativeImageAccessor": Internal.ClassInfo, "net.mcreator.sab.block.UuBlock": Internal.ClassInfo, "net.minecraft.world.level.block.CarrotBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2ReferenceFunction": Internal.ClassInfo, "com.simibubi.create.content.equipment.potatoCannon.PotatoRecoveryEnchantment": Internal.ClassInfo, "javax.sound.sampled.AudioFormat$Encoding": Internal.ClassInfo, "java.time.chrono.ChronoZonedDateTime": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure": Internal.ClassInfo, "com.fasterxml.jackson.databind.ser.BeanSerializerBuilder": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.entity.FluidCannonBlockEntity$IFluidCannon": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.lights.neon.NeonTubeBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumForestPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "org.valkyrienskies.core.apigame.constraints.VSConstraintType": Internal.ClassInfo, "net.minecraft.world.entity.FlyingMob": Internal.ClassInfo, "net.mcreator.sab.block.SteelblocklightskyBlock": Internal.ClassInfo, "com.tterrag.registrate.util.entry.ItemProviderEntry": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MossExternalFluidTankBlock": Internal.ClassInfo, "com.mojang.brigadier.context.SuggestionContext": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServer$WorldType": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.SecondaryPoiSensor": Internal.ClassInfo, "net.minecraft.world.level.block.DragonEggBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedCompDrawers": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.DirectionalFacingBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyStrippedAcaciaLogBlock": Internal.ClassInfo, "dev.kir.cubeswithoutborders.client.FullscreenMode": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyMangroveStrippedWoodBlock": Internal.ClassInfo, "de.cristelknight.doapi.common.block.StorageBlock": Internal.ClassInfo, "java.math.RoundingMode": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.display.gun.DamageStyle": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingOakTrapdoorBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.ArtilleryChargeLoaderBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.RecipeKey": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.DeserializerFactory": Internal.ClassInfo, "org.embeddedt.modernfix.duck.IProfilingServerFunctionManager": Internal.ClassInfo, "org.apache.logging.log4j.core.async.AsyncLoggerConfig$Builder": Internal.ClassInfo, "net.minecraft.world.inventory.CraftingContainer": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.entity.NavigatingEntity": Internal.ClassInfo, "com.supermartijn642.fusion.resources.FusionPackMetadata": Internal.ClassInfo, "org.valkyrienskies.mod.mixin.accessors.server.level.DistanceManagerAccessor": Internal.ClassInfo, "com.petrolpark.tube.ITubeBlockEntity": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.millstone.block.DripstoneDecoMillStoneBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDesertCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$TextureStateShard": Internal.ClassInfo, "xaero.map.gui.MapTileSelection": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.ArrayBuilders$ShortBuilder": Internal.ClassInfo, "software.bernie.geckolib.core.animatable.model.CoreGeoBone": Internal.ClassInfo, "slimeknights.mantle.data.loadable.mapping.MappedLoadable": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDustyPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SplashBlock": Internal.ClassInfo, "xaero.hud.minimap.element.render.world.MinimapElementWorldRendererHandler": Internal.ClassInfo, "net.minecraft.world.inventory.MenuType$MenuSupplier": Internal.ClassInfo, "com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance": Internal.ClassInfo, "com.simibubi.create.content.redstone.diodes.BrassDiodeBlock": Internal.ClassInfo, "vazkii.patchouli.mixin.AccessorSmithingTransformRecipe": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.slider.DynamicSliderBlock": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.torpedo_tube.medium_range_torpedo.MediumRangeTorpedoBlock": Internal.ClassInfo, "com.railwayteam.railways.content.switches.TrackSwitchBlock": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.render.chunk.map.ChunkTracker": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntGrassySandyDIrtBlock": Internal.ClassInfo, "appeng.api.inventories.InternalInventory": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData": Internal.ClassInfo, "cc.tweaked_programs.cccbridge.common.minecraft.block.SourceBlock": Internal.ClassInfo, "appeng.block.misc.CellWorkbenchBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedButtonBlock": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.LoggedChatEvent$Type": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildrechtsBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.links.output.OutputPortBlockEntity": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.SolidBigCannonBlock": Internal.ClassInfo, "net.minecraft.world.inventory.SmokerMenu": Internal.ClassInfo, "io.netty.buffer.PoolChunkListMetric": Internal.ClassInfo, "immersive_aircraft.item.DescriptionItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.HoglinSpecificSensor": Internal.ClassInfo, "appeng.api.parts.IPartHost": Internal.ClassInfo, "mezz.jei.api.ingredients.ITypedIngredient": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemOverrides$BakedOverride": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.VengefulBulletproofGlassBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.cables.WireManager$Conductor": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.bytes.CopycatByteBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.RechtskurveschwerBlock": Internal.ClassInfo, "io.netty.channel.ChannelInboundHandlerAdapter": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.kinetic_motor.KineticMotorBlockEntity": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexBuffer": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$CropGrowEvent$Post": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.IngredientKJS": Internal.ClassInfo, "com.mojang.realmsclient.gui.RealmsNewsManager": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.RedstoneConnectingBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DaylightDetectorBlockEntity": Internal.ClassInfo, "appeng.items.tools.quartz.QuartzHoeItem": Internal.ClassInfo, "com.ordana.spelunkery.blocks.ChannelSluiceBlock": Internal.ClassInfo, "net.minecraft.world.level.block.TallSeagrassBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.ConstantHeight": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCaramelCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "vazkii.patchouli.mixin.client.AccessorScreen": Internal.ClassInfo, "com.supermartijn642.fusion.api.texture.TextureType": Internal.ClassInfo, "com.nukateam.ntgl.common.util.util.GunData": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2ByteFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration$Layer": Internal.ClassInfo, "net.minecraft.server.packs.resources.ResourceManager": Internal.ClassInfo, "io.netty.channel.ChannelOutboundBuffer$MessageProcessor": Internal.ClassInfo, "com.railwayteam.railways.content.palettes.smokebox.PalettesSmokeboxBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuData": Internal.ClassInfo, "appeng.blockentity.storage.IOPortBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.LootItemFunctionType": Internal.ClassInfo, "me.dantaeusb.zetter.item.crafting.FramingRecipe": Internal.ClassInfo, "net.satisfy.vinery.core.recipe.FermentationBarrelRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.item.crafting.MapCloningRecipe": Internal.ClassInfo, "appeng.api.networking.IGridServiceProvider": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCreamReinforcedBlastGlassBlock": Internal.ClassInfo, "net.minecraft.server.level.ChunkHolder$PlayerProvider": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleIterable": Internal.ClassInfo, "net.minecraft.client.renderer.FogRenderer$FogMode": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MoltenSlagBlockBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.CandyCaneFeature": Internal.ClassInfo, "com.atsuishio.superbwarfare.capability.player.PlayerVariable": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.HeavyAutocannonBarrelBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2FloatFunction": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.gui.options.OptionGroup$Builder": Internal.ClassInfo, "com.simibubi.create.content.kinetics.motor.CreativeMotorBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.event.RenderArmEvent": Internal.ClassInfo, "net.minecraft.world.level.chunk.BlockColumn": Internal.ClassInfo, "net.minecraft.world.level.block.DecoratedPotBlock": Internal.ClassInfo, "java.nio.file.attribute.UserPrincipalLookupService": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.ChatListener": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientVisibility$IListener": Internal.ClassInfo, "xaero.map.file.worldsave.WorldDataHandler": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSnowReinforcedBlastGlassBlock": Internal.ClassInfo, "net.minecraftforge.event.level.NoteBlockEvent$Octave": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractGlassBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.BeanDescription": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.entity.AccessFallingBlockEntity": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy": Internal.ClassInfo, "com.simibubi.create.content.redstone.rail.ControllerRailBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectIterable": Internal.ClassInfo, "me.dantaeusb.zetter.storage.AbstractCanvasData$Resolution": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.ICDGKinetics": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.OysterLetterBlock": Internal.ClassInfo, "net.minecraft.world.level.block.TwistingVinesPlantBlock": Internal.ClassInfo, "net.minecraftforge.fml.config.ModConfig$Type": Internal.ClassInfo, "java.time.LocalDate": Internal.ClassInfo, "net.mcreator.crustychunks.block.BerylliumOreBlock": Internal.ClassInfo, "net.minecraft.client.renderer.texture.DynamicTexture": Internal.ClassInfo, "com.probejs.jdoc.document.AbstractDocument": Internal.ClassInfo, "xaero.pac.common.server.parties.system.api.IPlayerPartySystemAPI": Internal.ClassInfo, "java.util.OptionalDouble": Internal.ClassInfo, "org.apache.logging.log4j.LogBuilder": Internal.ClassInfo, "net.mcreator.cbccw.item.PhosphorusDustItem": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.TravellingPoint$IEdgePointListener": Internal.ClassInfo, "net.minecraft.world.level.block.CropBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedDoubleHalfSlopeBlock": Internal.ClassInfo, "xaero.common.effect.NoRadarEffect": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent": Internal.ClassInfo, "net.minecraft.world.entity.animal.camel.Camel": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.TrackBufferBlockEntity": Internal.ClassInfo, "team.creative.creativecore.common.gui.controls.inventory.GuiSlotBase": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.AbstractCastingBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapData$Type": Internal.ClassInfo, "com.atsuishio.superbwarfare.block.SmallContainerBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock": Internal.ClassInfo, "com.google.common.collect.ForwardingList": Internal.ClassInfo, "xaero.map.mcworld.IWorldMapClientWorld": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CellBarbedWireBlock": Internal.ClassInfo, "com.railwayteam.railways.content.smokestack.block.DieselSmokeStackBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.stages.Stages": Internal.ClassInfo, "slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.BlockRecipeType$Simple": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.TinyMap": Internal.ClassInfo, "org.apache.logging.log4j.core.LoggerContext": Internal.ClassInfo, "com.simibubi.create.foundation.mixin.accessor.GameRendererAccessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RomeoLetterBlock": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SpriteContents$FrameInfo": Internal.ClassInfo, "net.minecraft.world.level.block.FlowerBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntBambooFenceBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteSortedMap": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.CandyRuinsFeature": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock": Internal.ClassInfo, "net.mcreator.cbccw.block.VinegarBlock": Internal.ClassInfo, "com.atsuishio.superbwarfare.block.FuMO25Block": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.standard.TripleAxleBogeyBlock": Internal.ClassInfo, "vectorwing.farmersdelight.common.effect.ComfortEffect": Internal.ClassInfo, "kotlin.jvm.functions.Function3": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumSidePanelPlatingBlackBlock": Internal.ClassInfo, "kotlin.jvm.functions.Function4": Internal.ClassInfo, "kotlin.jvm.functions.Function1": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.WardenEntitySensor": Internal.ClassInfo, "kotlin.jvm.functions.Function2": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCrimsonArmorBlockBlock": Internal.ClassInfo, "kotlin.jvm.functions.Function0": Internal.ClassInfo, "com.codinglitch.lexiconfig.classes.LexiconEntryData": Internal.ClassInfo, "com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlockEntity": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.vendor.VendorBlockEntity$Mode": Internal.ClassInfo, "appeng.crafting.CraftingLink": Internal.ClassInfo, "kotlin.jvm.functions.Function5": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkAccess$TicksToSave": Internal.ClassInfo, "net.minecraft.sounds.SoundSource": Internal.ClassInfo, "com.simibubi.create.content.trains.graph.DiscoveredPath": Internal.ClassInfo, "net.minecraft.world.entity.AgeableMob": Internal.ClassInfo, "net.minecraftforge.server.permission.nodes.PermissionNode": Internal.ClassInfo, "net.minecraft.advancements.critereon.DeserializationContext": Internal.ClassInfo, "com.simibubi.create.content.logistics.crate.CreativeCrateBlockEntity": Internal.ClassInfo, "appeng.menu.locator.MenuLocator": Internal.ClassInfo, "net.minecraft.world.entity.animal.sniffer.Sniffer": Internal.ClassInfo, "net.minecraft.world.entity.OwnableEntity": Internal.ClassInfo, "net.satisfy.vinery.core.effect.TeleportEffect": Internal.ClassInfo, "net.minecraft.world.entity.animal.AbstractGolem": Internal.ClassInfo, "net.minecraft.client.quickplay.QuickPlayLog$Type": Internal.ClassInfo, "net.pixelbank.burnt.block.EmberFenceBlock": Internal.ClassInfo, "net.mcreator.cbccw.item.AluminumIngotItem": Internal.ClassInfo, "java.util.concurrent.locks.Lock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.FeuerloBlock": Internal.ClassInfo, "appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern": Internal.ClassInfo, "java.util.function.DoubleToLongFunction": Internal.ClassInfo, "com.simibubi.create.content.schematics.cannon.SchematicannonBlock": Internal.ClassInfo, "net.minecraft.world.level.LevelTimeAccess": Internal.ClassInfo, "com.simibubi.create.content.kinetics.base.IRotate$SpeedLevel": Internal.ClassInfo, "net.pixelbank.burnt.block.LargeFlamesBlock": Internal.ClassInfo, "com.illusivesoulworks.comforts.common.block.SleepingBagBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.util.IToggleableEntries": Internal.ClassInfo, "com.railwayteam.railways.forge.mixin.ChunkMapAccessor": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonSittingFlamingPhase": Internal.ClassInfo, "net.minecraft.world.level.block.GrindstoneBlock": Internal.ClassInfo, "com.atsuishio.superbwarfare.block.SuperbItemInterfaceBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BaseCoralPlantBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.HorizontalDirectionalBlockBuilder": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.FireMode": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.concrete.formwork.FormWorkBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMuddyArmorBlockBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCooldownPacket": Internal.ClassInfo, "java.security.PrivilegedAction": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.ConverterBlockEntity": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockcamoforestBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.voltage_observer.VoltageObserverBlockEntity": Internal.ClassInfo, "com.codinglitch.simpleradio.core.registry.blocks.FrequencerBlock": Internal.ClassInfo, "me.steinborn.krypton.mod.shared.player.KryptonServerPlayerEntity": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior": Internal.ClassInfo, "com.verr1.controlcraft.content.gui.layouts.api.ISerializableDynamicController": Internal.ClassInfo, "xaero.common.minimap.radar.tracker.system.IPlayerTrackerSystem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CreamChainArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.AluminumCasingBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.api.ICustomizable": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.entity.PoweredEngineShaftBlockEntity": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.IHaveCables": Internal.ClassInfo, "com.google.common.collect.ImmutableList$Builder": Internal.ClassInfo, "net.minecraft.world.entity.ai.goal.Goal": Internal.ClassInfo, "net.minecraft.client.renderer.debug.DebugRenderer$SimpleDebugRenderer": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.KeycardReaderBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SpieleBlock": Internal.ClassInfo, "net.minecraftforge.client.gui.overlay.ForgeGui": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.FiveHundredMillimetersMeasureBlockBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.ModStairBlock": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.byte_panel.CopycatBytePanelBlock": Internal.ClassInfo, "com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipe": Internal.ClassInfo, "net.minecraft.world.item.crafting.Ingredient": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent": Internal.ClassInfo, "com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock$WhistleExtenderShape": Internal.ClassInfo, "net.minecraft.world.item.enchantment.TridentLoyaltyEnchantment": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Leggings": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.traffic_light.TrafficLightBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSwampBlastGlassBlock": Internal.ClassInfo, "net.minecraftforge.client.event.sound.SoundEvent": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.slab.CopycatSlabBlock$FaceShape": Internal.ClassInfo, "com.ordana.spelunkery.blocks.nephrite.NephriteSiphonBlock": Internal.ClassInfo, "net.ngbatz.createnuclearwar.item.HazmatSuitItem$Chestplate": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.mines.DeepslateMineBlock": Internal.ClassInfo, "com.mrbysco.disccord.item.DiscCordItem": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.KreisverkehrSchildBlock": Internal.ClassInfo, "com.atsuishio.superbwarfare.block.AircraftCatapultBlock": Internal.ClassInfo, "net.minecraft.commands.SharedSuggestionProvider$TextCoordinates": Internal.ClassInfo, "net.minecraft.network.chat.contents.DataSource": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCrimsonReinforcedArmorBlockBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.BoneNoduleBlock": Internal.ClassInfo, "com.happysg.radar.block.monitor.MonitorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOvergrownCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.hesh_shell.HESHShellProjectile": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.OvergrownBulletproofGlassBlock": Internal.ClassInfo, "xaero.common.server.player.IServerPlayer": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.config.FillBiomeAboveConfiguration": Internal.ClassInfo, "com.nukateam.ntgl.common.foundation.crafting.WorkbenchIngredient": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ItemArmorTierRegistryEventJS": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMilitaryReinforcedCageArmorBlock": Internal.ClassInfo, "org.antarcticgardens.newage.content.motors.extension.MotorExtensionBlockEntity": Internal.ClassInfo, "org.valkyrienskies.clockwork.forge.mixin.accessors.ItemAccessor": Internal.ClassInfo, "dan200.computercraft.api.upgrades.UpgradeBase": Internal.ClassInfo, "org.joml.Vector2ic": Internal.ClassInfo, "appeng.api.networking.events.statistics.GridChunkEvent$GridChunkRemoved": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelVengefulCageArmorBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.type.descriptive.GroupPolicy": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMossFortifiedArmorBlockBlock": Internal.ClassInfo, "java.nio.channels.ByteChannel": Internal.ClassInfo, "net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute": Internal.ClassInfo, "com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.AcetoneFluidType": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootPool": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyOakLogBlock": Internal.ClassInfo, "java.lang.reflect.Member": Internal.ClassInfo, "java.net.NetworkInterface": Internal.ClassInfo, "team.creative.creativecore.common.util.type.ColorType": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonAutoDetect": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.PewenTreeFeature": Internal.ClassInfo, "com.ordana.spelunkery.items.SaltBucketItem": Internal.ClassInfo, "net.pixelbank.burnt.block.FireBarrelActiveBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MinusSymbolBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Spline$Point": Internal.ClassInfo, "org.valkyrienskies.mod.mixin.accessors.world.level.block.StairBlockAccessor": Internal.ClassInfo, "net.mcreator.sab.block.SteelblockcamodesertBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureStart": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.filter.RecipeFilterParseEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2LongMap$Entry": Internal.ClassInfo, "xaero.pac.common.server.claims.api.IServerClaimsManagerAPI": Internal.ClassInfo, "net.minecraft.world.entity.monster.WitherSkeleton": Internal.ClassInfo, "xaero.hud.category.ui.entry.EditorListRootEntry": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2CharFunction": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.nbt.StatsNBT$Builder": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.bank.BankTerminalBlock": Internal.ClassInfo, "com.mojang.brigadier.suggestion.SuggestionProvider": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSeaExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.ordana.spelunkery.items.DepthGaugeItem": Internal.ClassInfo, "de.keksuccino.melody.mixin.mixins.common.client.IMixinSoundManager": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.AlterGroundDecorator": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement": Internal.ClassInfo, "xfacthd.framedblocks.common.block.cube.FramedTargetBlock": Internal.ClassInfo, "com.simibubi.create.content.redstone.displayLink.target.DisplayTarget": Internal.ClassInfo, "net.minecraftforge.registries.MissingMappingsEvent$Mapping": Internal.ClassInfo, "org.luaj.vm2.Metatable": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap": Internal.ClassInfo, "net.minecraft.world.level.chunk.Palette$Factory": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaFacingSizedOpen": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ContainerOpenersCounter": Internal.ClassInfo, "xaero.common.minimap.radar.tracker.synced.ClientSyncedTrackedPlayerManager": Internal.ClassInfo, "net.mcreator.sab.block.FourBlock": Internal.ClassInfo, "net.minecraft.world.item.HangingEntityItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MilitaryOpenTankHatchBlock": Internal.ClassInfo, "com.railwayteam.railways.content.coupling.coupler.forge.TrackCouplerBlockImpl": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.exhaust.ExhaustBlockEntity": Internal.ClassInfo, "net.pixelbank.burnt.block.EmberLogBlock": Internal.ClassInfo, "net.minecraft.world.level.block.PressurePlateBlock": Internal.ClassInfo, "net.minecraft.nbt.IntArrayTag": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOceanPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "com.nukateam.ntgl.common.event.GunProjectileHitEvent": Internal.ClassInfo, "com.google.common.collect.HashMultimap": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.RenderRegionCache": Internal.ClassInfo, "com.codinglitch.simpleradio.api.central.Auricular": Internal.ClassInfo, "com.ordana.spelunkery.fluids.PortalFluid$Source": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOvergrownReinforcedBlastGlassBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.Trafficlight3Block": Internal.ClassInfo, "appeng.api.implementations.items.IMemoryCard": Internal.ClassInfo, "com.simibubi.create.content.contraptions.OrientedContraptionEntity": Internal.ClassInfo, "com.simibubi.create.foundation.mixin.accessor.SystemReportAccessor": Internal.ClassInfo, "com.google.common.collect.ImmutableSet": Internal.ClassInfo, "net.minecraftforge.event.PlayLevelSoundEvent": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.mines.BouncingBettyBlock": Internal.ClassInfo, "java.lang.module.Configuration": Internal.ClassInfo, "slimeknights.mantle.block.GaugeBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.BleachFluid$Flowing": Internal.ClassInfo, "com.railwayteam.railways.mixin.client.AccessorPartialModel": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.PlacementContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureSpawnOverride$BoundingBoxType": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingGrayBlock": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SimpleTexture": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.AcidVentFeature": Internal.ClassInfo, "net.mcreator.crustychunks.block.AlumiumPlatingSidePanelWhiteBlock": Internal.ClassInfo, "java.util.HashSet": Internal.ClassInfo, "net.minecraft.world.level.ClipContext$ShapeGetter": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.CountPlacement": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RiverExternalFuelTankBlock": Internal.ClassInfo, "com.nukateam.ntgl.common.base.holders.AmmoType": Internal.ClassInfo, "net.mcreator.sab.block.BrassfBlock": Internal.ClassInfo, "com.mojang.blaze3d.platform.NativeImage": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationSystem": Internal.ClassInfo, "java.util.concurrent.ExecutorService": Internal.ClassInfo, "net.minecraft.world.entity.TamableAnimal": Internal.ClassInfo, "io.netty.channel.ChannelProgressivePromise": Internal.ClassInfo, "xaero.hud.category.rule.ObjectCategoryExcludeList": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$LevelTickEvent": Internal.ClassInfo, "net.minecraft.world.item.BlockItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.util.BlockBase": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.InputReplacementTransformer": Internal.ClassInfo, "com.simibubi.create.content.trains.display.FlapDisplayLayout": Internal.ClassInfo, "com.fasterxml.jackson.databind.AnnotationIntrospector$ReferenceProperty$Type": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AcetoneFluid$Source": Internal.ClassInfo, "com.ordana.spelunkery.blocks.nephrite.CarvedNephriteBlock$ChargeState": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeRecipe$Serializer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRespawnPacket": Internal.ClassInfo, "com.simibubi.create.content.decoration.encasing.EncasableBlock": Internal.ClassInfo, "appeng.crafting.pattern.EncodedPatternItem": Internal.ClassInfo, "net.mcreator.sab.block.BrassyuBlock": Internal.ClassInfo, "com.tom.storagemod.block.InventoryCableBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyMossyCobblestoneSlabBlock": Internal.ClassInfo, "xaero.common.HudMod": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiEvent$Pre": Internal.ClassInfo, "java.lang.module.ModuleReference": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.item.MethItem": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$IntValue": Internal.ClassInfo, "appeng.client.render.effects.EnergyParticleData": Internal.ClassInfo, "com.jozufozu.flywheel.light.GPULightVolume": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.CookieShelfFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.create.events.SpecialSpoutHandlerEvent": Internal.ClassInfo, "com.fasterxml.jackson.databind.JsonSerializer": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeRecipeSerializer": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.component.SearedDrainBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.NotificationBuilder": Internal.ClassInfo, "com.tacz.guns.api.event.common.GunFireSelectEvent": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedDoubleHalfStairsBlock": Internal.ClassInfo, "net.minecraft.core.RegistryAccess": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Constant": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabWingBrownBlock": Internal.ClassInfo, "com.codinglitch.simpleradio.api.central.Socket": Internal.ClassInfo, "xaero.hud.minimap.world.MinimapWorld": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildppBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent$Applicable": Internal.ClassInfo, "net.minecraft.world.entity.monster.Evoker": Internal.ClassInfo, "java.util.Dictionary": Internal.ClassInfo, "java.lang.Throwable": Internal.ClassInfo, "appeng.facade.FacadePart": Internal.ClassInfo, "net.satisfy.vinery.core.block.ModWallHangingSignBlock": Internal.ClassInfo, "org.antarcticgardens.newage.content.reactor.ReactorBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.forge.ForgeEventConsumer": Internal.ClassInfo, "net.minecraft.world.level.lighting.ChunkSkyLightSources": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.PlastaniumBlockBlock": Internal.ClassInfo, "net.minecraftforge.common.world.ForgeBiomeModifiers$AddFeaturesBiomeModifier": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlock": Internal.ClassInfo, "net.minecraft.world.Container": Internal.ClassInfo, "java.util.function.BiConsumer": Internal.ClassInfo, "com.simibubi.create.content.contraptions.pulley.PulleyBlock$RopeBlockBase": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.SwordItemBuilder": Internal.ClassInfo, "com.railwayteam.railways.mixin.AccessorTrackTargetingBehavior": Internal.ClassInfo, "com.mojang.serialization.MapCodec$ResultFunction": Internal.ClassInfo, "net.minecraft.world.level.block.DiodeBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Opening": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedTitaniumCageArmorBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.DamagedConcreteBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Animal": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedPanelBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.AddJEIEventJS": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.electric_motor.ElectricMotorBlock": Internal.ClassInfo, "com.mojang.serialization.Codec": Internal.ClassInfo, "net.satisfy.vinery.core.block.CherryLeavesBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator": Internal.ClassInfo, "slimeknights.mantle.recipe.helper.FluidOutput$OfStack": Internal.ClassInfo, "org.joml.Vector2dc": Internal.ClassInfo, "net.minecraft.world.entity.EntityDimensions": Internal.ClassInfo, "net.minecraft.client.renderer.texture.Dumpable": Internal.ClassInfo, "net.minecraft.world.entity.SlotAccess": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.LangEventJS": Internal.ClassInfo, "net.mcreator.crustychunks.block.BlastFurnaceBlock": Internal.ClassInfo, "com.simibubi.create.content.equipment.toolbox.ToolboxInventory": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.TimelessForgeEventWrappers$GunShootWrapper": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedMovingPistonBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonTakeoffPhase": Internal.ClassInfo, "net.minecraft.client.telemetry.ClientTelemetryManager": Internal.ClassInfo, "net.minecraft.world.damagesource.CombatEntry": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption": Internal.ClassInfo, "immersive_aircraft.item.AircraftItem": Internal.ClassInfo, "xaero.common.minimap.waypoints.WaypointSharingHandler": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumAshesArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.server.permission.events.PermissionGatherEvent$Nodes": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.fuse_block.FuseBlock": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEvent$Context": Internal.ClassInfo, "net.mcreator.cbccw.fluid.FormaldehydeFluid$Source": Internal.ClassInfo, "net.minecraft.client.model.ArmedModel": Internal.ClassInfo, "java.lang.Cloneable": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsGrayBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDustyReinforcedArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.gearbox.GearboxBlock": Internal.ClassInfo, "org.joml.Vector2fc": Internal.ClassInfo, "org.apache.logging.log4j.core.config.ConfigurationListener": Internal.ClassInfo, "net.mcreator.cbccw.block.UrineBlock": Internal.ClassInfo, "net.minecraft.client.renderer.MultiBufferSource": Internal.ClassInfo, "net.minecraft.world.entity.SpawnGroupData": Internal.ClassInfo, "java.time.temporal.ChronoField": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidLike": Internal.ClassInfo, "com.nukateam.ntgl.modules.enchantment.enchantments.FireStarterEnchantment": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.PrimitiveDescJS": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkWatchEvent$Watch": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityMountEvent": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.transmission.InverseBoxBlock": Internal.ClassInfo, "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDesertPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "com.jozufozu.flywheel.util.transform.Scale": Internal.ClassInfo, "net.minecraft.world.level.block.MangrovePropaguleBlock": Internal.ClassInfo, "com.ordana.spelunkery.blocks.CompressionBlastMiner": Internal.ClassInfo, "team.creative.creativecore.mixin.VoxelShapeAccessor": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Render$Post": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.FuelItem": Internal.ClassInfo, "mod.casinocraft.common.item.ItemRulebook": Internal.ClassInfo, "slimeknights.tconstruct.library.utils.ResourceId": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockModificationEventJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration": Internal.ClassInfo, "com.tterrag.registrate.builders.FluidBuilder$1": Internal.ClassInfo, "net.minecraft.world.item.SolidBucketItem": Internal.ClassInfo, "com.jozufozu.flywheel.api.InstanceData": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractCauldronBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntPumpkinBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.FrostedChocolateBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.MagnetBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.IcebergFeature": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.ReloadType": Internal.ClassInfo, "slimeknights.tconstruct.tables.block.GenericTableBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildverboteBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.HydrogenFluid$Flowing": Internal.ClassInfo, "net.mcreator.crustychunks.block.ArtillerybreechBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration": Internal.ClassInfo, "appeng.api.implementations.blockentities.ICrankable": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingDamageEvent": Internal.ClassInfo, "com.talhanation.smallships.mixin.controlling.BoatAccessor": Internal.ClassInfo, "com.simibubi.create.content.contraptions.Contraption": Internal.ClassInfo, "net.minecraft.world.item.CrossbowItem": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeLevel": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyOakFenceBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.IceSpikeFeature": Internal.ClassInfo, "xaero.hud.minimap.world.container.MinimapWorldRootContainer": Internal.ClassInfo, "net.minecraft.world.InteractionResult": Internal.ClassInfo, "org.antarcticgardens.newage.content.reactor.reactorfuelacceptor.ReactorFuelAcceptorBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.breeches.AbstractBigCannonBreechBlockEntity": Internal.ClassInfo, "com.ordana.spelunkery.entities.PickOnAStickEntity": Internal.ClassInfo, "me.dantaeusb.zetter.item.crafting.UnframingRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.entity.monster.AbstractIllager": Internal.ClassInfo, "java.nio.ByteOrder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumRiverReinforcedArmorBlockBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2ByteFunction": Internal.ClassInfo, "appeng.items.materials.EnergyCardItem": Internal.ClassInfo, "xaero.map.deallocator.ByteBufferDeallocator": Internal.ClassInfo, "com.mojang.brigadier.exceptions.BuiltInExceptionProvider": Internal.ClassInfo, "slimeknights.mantle.data.loadable.record.RecordLoadable7": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.potion.DeepsightEffect": Internal.ClassInfo, "slimeknights.mantle.data.loadable.record.RecordLoadable2": Internal.ClassInfo, "net.mcreator.cbccw.fluid.ThiodiglycolFluid$Flowing": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.SodiumFluidType": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.PartDefinition": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.medium_range_deepwater_torpedo.MediumRangeDeepwaterTorpedoBlock": Internal.ClassInfo, "net.mcreator.sab.block.BrassquestionBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.YankeeLetterBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.GeodeBlockSettings": Internal.ClassInfo, "net.minecraftforge.server.permission.nodes.PermissionNode$PermissionResolver": Internal.ClassInfo, "net.minecraft.commands.arguments.EntityArgument": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopeslab.FramedElevatedSlopeSlabBlock": Internal.ClassInfo, "net.minecraft.client.resources.model.ModelManager": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedChiseledBookshelfBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeHolderSet$SerializationType": Internal.ClassInfo, "org.valkyrienskies.mod.mixinducks.world.OfLevel": Internal.ClassInfo, "net.mcreator.cbccw.fluid.ChlorineFluid": Internal.ClassInfo, "net.mcreator.sab.block.BrassuuBlock": Internal.ClassInfo, "org.apache.logging.log4j.Marker": Internal.ClassInfo, "net.mcreator.createtankdefenses.fluid.types.CreosoteOilFluidType": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.core.records.ComponentPortName": Internal.ClassInfo, "com.fasterxml.jackson.databind.node.NumericNode": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2FloatMap$FastEntrySet": Internal.ClassInfo, "xaero.hud.category.ui.node.options.range.setting.IEditorSettingNodeBuilder": Internal.ClassInfo, "java.nio.file.FileStore": Internal.ClassInfo, "com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.dispatch.command.stage.AzAnimationStage": Internal.ClassInfo, "xaero.hud.minimap.radar.category.EntityRadarDefaultCategories": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SwampChainArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.entity.WalkAnimationState": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerBuilder": Internal.ClassInfo, "net.minecraft.util.InclusiveRange": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.diesel.DieselEngineBlock": Internal.ClassInfo, "net.minecraft.world.level.block.LeavesBlock": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$GunFireSelectEventJS": Internal.ClassInfo, "com.blamejared.crafttweaker.api.data.StringData": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent": Internal.ClassInfo, "net.mcreator.sab.block.BrassiiBlock": Internal.ClassInfo, "com.railwayteam.railways.content.fuel.tank.FuelTankBlock": Internal.ClassInfo, "java.util.ImmutableCollections$AbstractImmutableCollection": Internal.ClassInfo, "net.mcreator.sab.block.DoublesteelblockcamotaigaBlock": Internal.ClassInfo, "net.minecraft.util.SortedArraySet": Internal.ClassInfo, "java.lang.Readable": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$PlayerTickEvent": Internal.ClassInfo, "dan200.computercraft.api.turtle.TurtleSide": Internal.ClassInfo, "java.net.URLStreamHandlerFactory": Internal.ClassInfo, "net.mcreator.crustychunks.block.PinkArmorStairsBlock": Internal.ClassInfo, "net.minecraft.world.item.HoneycombItem": Internal.ClassInfo, "com.sudolev.interiors.content.block.chair.DirectionalSeatBlock": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.controller.SmelteryControllerBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.SteelPlatingStairsBlock": Internal.ClassInfo, "com.hlysine.create_connected.content.sequencedpulsegenerator.SequencedPulseGeneratorBlock": Internal.ClassInfo, "net.minecraftforge.network.NetworkEvent$ServerCustomPayloadEvent": Internal.ClassInfo, "com.hlysine.create_connected.content.linkedtransmitter.LinkedButtonBlock": Internal.ClassInfo, "net.minecraftforge.common.world.StructureModifier": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyDarkOakFenceBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyMangroveWoodBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.structure.DinoBowlStructure": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDesertExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "org.antarcticgardens.newage.content.energiser.EnergiserBlockEntity": Internal.ClassInfo, "net.geforcemods.securitycraft.items.SCManualItem": Internal.ClassInfo, "io.netty.channel.EventLoopGroup": Internal.ClassInfo, "org.valkyrienskies.mod.mixinducks.feature.command.VSCommandSource": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockcoloredparadeBlock": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo": Internal.ClassInfo, "xaero.common.interfaces.render.InterfaceRenderer": Internal.ClassInfo, "net.mcreator.crustychunks.block.RustyStairsBlock": Internal.ClassInfo, "net.minecraft.world.ticks.LevelTicks": Internal.ClassInfo, "net.mcreator.cbccw.fluid.SulfurDioxideFluid$Flowing": Internal.ClassInfo, "net.mcreator.crustychunks.block.CyanArmorSlabBlock": Internal.ClassInfo, "com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlockEntity": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SpriteTicker": Internal.ClassInfo, "net.satisfy.vinery.core.effect.WaterWalkerEffect": Internal.ClassInfo, "net.minecraft.client.OptionInstance": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.motor.AbstractMotor": Internal.ClassInfo, "java.security.AccessControlContext": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.ChlorineFluidType": Internal.ClassInfo, "com.github.alexthe666.citadel.client.event.EventGetOutlineColor": Internal.ClassInfo, "com.mojang.datafixers.types.templates.RecursivePoint$RecursivePointType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.ILinkableBlock": Internal.ClassInfo, "com.jozufozu.flywheel.mixin.PausedPartialTickAccessor": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumSidePanelPlatingMagentaBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCaramelExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "xaero.map.MapProcessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.world.features.ores.AluminumDeepslateOreFeature": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.GearStrutBlock": Internal.ClassInfo, "com.google.common.reflect.TypeParameter": Internal.ClassInfo, "org.valkyrienskies.clockwork.integration.cc.ComputerAttachmentHandler": Internal.ClassInfo, "java.nio.file.DirectoryStream$Filter": Internal.ClassInfo, "java.security.Signature": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.flap.CompactFlapBlockEntity": Internal.ClassInfo, "net.mcreator.sab.block.LimedoublesteelblockBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.stat.INumericToolStat": Internal.ClassInfo, "com.codinglitch.simpleradio.api.central.Frequencing": Internal.ClassInfo, "net.minecraft.world.entity.player.ChatVisiblity": Internal.ClassInfo, "mod.azure.azurelib.core.state.BoneSnapshot": Internal.ClassInfo, "net.mcreator.crustychunks.block.LargeRocketPodBlock": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$CullStateShard": Internal.ClassInfo, "org.apache.logging.log4j.core.Appender": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.breech.HeavyAutocannonBreechBlockEntity": Internal.ClassInfo, "net.minecraft.network.chat.MutableComponent": Internal.ClassInfo, "mezz.jei.api.gui.handlers.IGuiClickableArea": Internal.ClassInfo, "net.minecraft.world.level.block.SculkSensorBlock": Internal.ClassInfo, "net.mcreator.cbccw.potion.SulfuricAcidSoakedMobEffect": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCrimsonBlastGlassBlock": Internal.ClassInfo, "com.hlysine.create_connected.content.shearpin.ShearPinBlock": Internal.ClassInfo, "de.keksuccino.konkrete.events.ScreenKeyReleasedEvent": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelFoggyReinforcedArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.entity.movement_tracker.SectionedEntityMovementListener": Internal.ClassInfo, "net.mcreator.sab.block.SteelblockcamotaigaBlock": Internal.ClassInfo, "net.minecraft.util.ModCheck$Confidence": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.GrayConcretebagBlock": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.WeatheringPlatformBlock": Internal.ClassInfo, "com.jozufozu.flywheel.api.instance.DynamicInstance": Internal.ClassInfo, "net.minecraft.world.entity.monster.Ghast": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityEvent$Size": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopeslab.FramedFlatElevatedDoubleSlopeSlabCornerBlock": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.depositor.BrassDepositorBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.GenerationStep$Carving": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Variant": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.traffic_light.TrafficLightBlock": Internal.ClassInfo, "net.minecraft.world.level.chunk.LevelChunk$EntityCreationType": Internal.ClassInfo, "appeng.items.materials.UpgradeCardItem": Internal.ClassInfo, "net.minecraft.world.item.crafting.SingleItemRecipe$Serializer": Internal.ClassInfo, "com.mojang.brigadier.tree.LiteralCommandNode": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCreamReinforcedArmorBlockBlock": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigValueSerializer$IDeserializeResult": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapItemSavedData": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.VengefulExternalFluidTankBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCharcoalCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumPurityArmorBlockBlock": Internal.ClassInfo, "appeng.debug.CubeGeneratorBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferBuilder$DrawState": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseDragged$Post": Internal.ClassInfo, "net.mcreator.crustychunks.block.ExplosiveBarrelBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyBirchStrippedWoodBlock": Internal.ClassInfo, "team.creative.creativecore.common.gui.style.ControlFormatting$ControlStyleFace": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.aluminum.AluminumBoilerStructure": Internal.ClassInfo, "xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderer": Internal.ClassInfo, "com.simibubi.create.content.fluids.pipes.FluidPipeBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.traffic_cone.TrafficConeBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$MarkerOrMarked": Internal.ClassInfo, "org.apache.logging.log4j.core.AbstractLifeCycle": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.ButtonBlockBuilder": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyOakSlabBlock": Internal.ClassInfo, "net.minecraft.client.particle.ParticleProvider": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.StringArgumentSerializer$Template": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.Wing": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeGenerationSettings$PlainBuilder": Internal.ClassInfo, "net.mcreator.crustychunks.block.MagentaArmorStairsBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CreamFireSupressionSystemBlockBlock": Internal.ClassInfo, "net.minecraft.world.ContainerListener": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.button.CopycatButtonBlock": Internal.ClassInfo, "com.supermartijn642.fusion.extensions.EntityExtension": Internal.ClassInfo, "slimeknights.tconstruct.library.module.ModuleHookMap$Builder": Internal.ClassInfo, "com.atsuishio.superbwarfare.mobeffect.BurnMobEffect": Internal.ClassInfo, "net.mcreator.cbccw.item.NitrateDustItem": Internal.ClassInfo, "com.hlysine.create_connected.content.brassgearbox.BrassGearboxBlockEntity": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$AddCallback": Internal.ClassInfo, "com.fasterxml.jackson.databind.DatabindContext": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonIncludeProperties$Value": Internal.ClassInfo, "net.minecraft.world.item.NameTagItem": Internal.ClassInfo, "dev.latvian.mods.rhino.IdScriptableObject": Internal.ClassInfo, "com.fasterxml.jackson.databind.node.ObjectNode": Internal.ClassInfo, "net.mcreator.sab.block.BrassbBlock": Internal.ClassInfo, "org.valkyrienskies.mod.common.IShipObjectWorldClientCreator": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterParticleProvidersEvent": Internal.ClassInfo, "com.fasterxml.jackson.core.JsonPointer": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.builtup.BigCannonLayerBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Rabbit$Variant": Internal.ClassInfo, "net.minecraft.world.entity.monster.Vindicator": Internal.ClassInfo, "dev.architectury.event.EventFactory$EventImpl": Internal.ClassInfo, "mezz.jei.api.gui.placement.VerticalAlignment": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.ReportingContext": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2BooleanFunction": Internal.ClassInfo, "com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock": Internal.ClassInfo, "org.antarcticgardens.newage.content.heat.stirlingengine.StirlingEngineBlockEntity": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingHurtEvent": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.PhysicsCoreBlock": Internal.ClassInfo, "xaero.common.validator.FieldValidatorHolder": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.SodiumAcetateFluidType": Internal.ClassInfo, "net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.PseudoephedrineFluid": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.storage.AccumulatorBlockEntity": Internal.ClassInfo, "com.github.talrey.createdeco.items.CatwalkStairBlockItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder": Internal.ClassInfo, "net.geforcemods.securitycraft.blockentities.AbstractKeypadFurnaceBlockEntity": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.firebox.FireboxBlock": Internal.ClassInfo, "net.mcreator.cbccw.potion.AmmoniumAcetatePoisonMobEffect": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer": Internal.ClassInfo, "net.minecraft.world.level.border.WorldBorder$BorderExtent": Internal.ClassInfo, "com.fasterxml.jackson.databind.JsonSerializable$Base": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLadderBlock": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientItemExtensions$FontContext": Internal.ClassInfo, "org.apache.logging.log4j.core.config.Configuration": Internal.ClassInfo, "net.minecraft.commands.Commands$ParseFunction": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "com.fasterxml.jackson.core.JacksonException": Internal.ClassInfo, "net.minecraft.world.item.enchantment.FrostWalkerEnchantment": Internal.ClassInfo, "com.electronwill.nightconfig.core.Config": Internal.ClassInfo, "com.simibubi.create.content.redstone.link.IRedstoneLinkable": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$EntityHurtByGunPreEventJS": Internal.ClassInfo, "java.util.ImmutableCollections$ListN": Internal.ClassInfo, "net.minecraft.world.level.entity.EntityPersistentStorage": Internal.ClassInfo, "net.mcreator.crustychunks.block.RedArmorTrapdoorBlock": Internal.ClassInfo, "com.fasterxml.jackson.dataformat.cbor.CBORGenerator$Feature": Internal.ClassInfo, "com.ordana.spelunkery.blocks.nephrite.RawNephriteBlock": Internal.ClassInfo, "com.lazrproductions.cuffed.blocks.PosterBlock": Internal.ClassInfo, "net.minecraft.network.chat.FormattedText": Internal.ClassInfo, "net.minecraft.util.valueproviders.UniformInt": Internal.ClassInfo, "com.mojang.authlib.minecraft.UserApiService$UserProperties": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlockEntity": Internal.ClassInfo, "appeng.api.implementations.blockentities.PatternContainerGroup": Internal.ClassInfo, "com.simibubi.create.foundation.outliner.LineOutline": Internal.ClassInfo, "net.minecraft.util.FormattedCharSequence": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.AzAnimatorConfig$Builder": Internal.ClassInfo, "net.geforcemods.securitycraft.items.KeypadChestItem": Internal.ClassInfo, "xaero.hud.minimap.world.container.MinimapWorldContainer": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexConsumer": Internal.ClassInfo, "xaero.hud.pushbox.PushboxManager": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildwildBlock": Internal.ClassInfo, "kotlin.Function": Internal.ClassInfo, "com.fasterxml.jackson.core.ObjectCodec": Internal.ClassInfo, "slimeknights.tconstruct.library.modifiers.impl.BasicModifier$TooltipDisplay": Internal.ClassInfo, "net.mcreator.cbccw.block.HydrogenSulfiteBlock": Internal.ClassInfo, "io.netty.channel.epoll.EpollEventLoopGroup": Internal.ClassInfo, "com.simibubi.create.content.redstone.link.controller.LecternControllerBlock": Internal.ClassInfo, "com.simibubi.create.content.equipment.armor.BacktankBlockEntity": Internal.ClassInfo, "de.maxhenkel.voicechat.api.packets.MicrophonePacket": Internal.ClassInfo, "com.simibubi.create.content.redstone.displayLink.DisplayLinkContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Marker$Type": Internal.ClassInfo, "net.minecraft.client.renderer.EffectInstance": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.industrial_fan_block.IndustrialFanBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.SlabType": Internal.ClassInfo, "net.minecraft.world.entity.monster.warden.AngerLevel": Internal.ClassInfo, "net.pixelbank.burnt.block.CookedRedMushroomBlockBlock": Internal.ClassInfo, "com.google.gson.stream.JsonToken": Internal.ClassInfo, "com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity$AllowedOperationMode": Internal.ClassInfo, "com.mojang.datafixers.FamilyOptic": Internal.ClassInfo, "net.minecraft.world.level.block.entity.TheEndPortalBlockEntity": Internal.ClassInfo, "net.minecraft.world.flag.FeatureElement": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.ConditionalFunction": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$SwapItemWithOffHandEventJS": Internal.ClassInfo, "net.mcreator.crustychunks.block.RawLeadBlockBlock": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.slab.CopycatSlabBlock": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.SignBlock": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.SoulGlassPaneBlock": Internal.ClassInfo, "dev.isxander.yacl3.mixin.OptionInstanceAccessor": Internal.ClassInfo, "com.simibubi.create.content.contraptions.pulley.PulleyBlock$RopeBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Squid": Internal.ClassInfo, "io.netty.channel.ChannelHandlerAdapter": Internal.ClassInfo, "org.valkyrienskies.mod.common.command.ShipArgumentInfo": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.OutputFluid": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelBlock": Internal.ClassInfo, "com.talhanation.smallships.duck.BoatLeashAccess": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.PurityBulletproofGlassBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.transmission.ClutchBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.gui.layouts.api.Descriptive": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListenerRegistry": Internal.ClassInfo, "com.google.common.collect.ImmutableMultimap$Builder": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockRightClickedEventJS": Internal.ClassInfo, "xaero.map.region.OverlayManager": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.ArrayBuilders$DoubleBuilder": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.render.Line": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.recoil_spring.HeavyAutocannonRecoilSpringBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedFireSupressionSystemBlockBlock": Internal.ClassInfo, "appeng.api.networking.ticking.IGridTickable": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.TravellingPoint$ITurnListener": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingChangeTargetEvent": Internal.ClassInfo, "java.io.FilterInputStream": Internal.ClassInfo, "net.mcreator.cbccw.block.OleicAcidBlock": Internal.ClassInfo, "appeng.block.misc.LightDetectorBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.condition.type.ConditionCustom": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumAshesReinforcedBlastGlassBlock": Internal.ClassInfo, "net.minecraftforge.registries.ForgeRegistry$Snapshot": Internal.ClassInfo, "net.minecraft.world.item.LingeringPotionItem": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.Schild70eBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownEgg": Internal.ClassInfo, "com.simibubi.create.content.fluids.pump.PumpBlock": Internal.ClassInfo, "net.mcreator.cbccw.block.CombustionGelBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.fan.processing.FanProcessingType": Internal.ClassInfo, "com.nukateam.ntgl.modules.enchantment.enchantments.PuncturingEnchantment": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.PingPongSpongeFeature": Internal.ClassInfo, "net.minecraft.world.level.block.RootsBlock": Internal.ClassInfo, "com.mojang.brigadier.suggestion.Suggestion": Internal.ClassInfo, "xaero.pac.common.parties.party.ally.api.IPartyAllyAPI": Internal.ClassInfo, "net.mcreator.crustychunks.block.BrownArmorSlabBlock": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.gui.options.control.Control": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.EntityKJS": Internal.ClassInfo, "net.minecraft.core.IdMap": Internal.ClassInfo, "java.time.temporal.TemporalQuery": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.wall.CopycatWallBlock": Internal.ClassInfo, "com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongUnaryOperator": Internal.ClassInfo, "net.minecraftforge.common.capabilities.CapabilityDispatcher": Internal.ClassInfo, "net.minecraft.world.level.block.MelonBlock": Internal.ClassInfo, "appeng.api.storage.ISubMenuHost": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyBirchWoodBlock": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.physicalities.wing.WingBlock": Internal.ClassInfo, "com.possible_triangle.sliceanddice.block.slicer.SlicerTile$Companion": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.LeftBracketsBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.interactive.FramedChiseledBookshelfBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer$FoliageAttachment": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.inout.MultiOutputLinkPort": Internal.ClassInfo, "team.creative.creativecore.common.gui.event.GuiControlChangedEvent": Internal.ClassInfo, "appeng.items.AEBaseItem": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.Property": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$TextRenderState": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.kinetics.sequenced_seat.SequencedSeatBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingSlabGreenBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository$ItemRecord": Internal.ClassInfo, "net.minecraft.world.level.block.IronBarsBlock": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlock": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.Boat": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockcamosnowBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.boring.DrillBoringBlockRecipe": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.Node": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.IHeavyAutocannonBlockEntity": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle060BogeyBlock": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeModelBaker": Internal.ClassInfo, "net.mcreator.crustychunks.block.FoundryBlock": Internal.ClassInfo, "com.simibubi.create.content.redstone.analogLever.AnalogLeverBlock": Internal.ClassInfo, "net.minecraftforge.event.server.ServerAboutToStartEvent": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsNews": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumWoodsReinforcedCageArmorBlock": Internal.ClassInfo, "net.minecraftforge.registries.tags.ITag": Internal.ClassInfo, "de.keksuccino.konkrete.events.ScreenMouseClickedEvent": Internal.ClassInfo, "net.mcreator.cbccw.fluid.UrineFluid$Flowing": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.MultifaceGrowthFeature": Internal.ClassInfo, "net.minecraft.commands.arguments.ScoreHolderArgument$Info": Internal.ClassInfo, "net.minecraft.world.item.TooltipFlag": Internal.ClassInfo, "java.security.CodeSource": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.standard.DoubleAxleBogeyBlock": Internal.ClassInfo, "net.satisfy.vinery.core.block.entity.StorageBlockEntity": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortCollection": Internal.ClassInfo, "net.mcreator.sab.block.Steelblockcolored29Block": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.ShipPhysics": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$LayeringStateShard": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.GenericDescJS": Internal.ClassInfo, "com.jozufozu.flywheel.util.transform.Translate": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.recipe.TableRecipe": Internal.ClassInfo, "net.pixelbank.burnt.block.WoodFire3Block": Internal.ClassInfo, "dev.shadowsoffire.placebo.util.CachedObject$CachedObjectSource": Internal.ClassInfo, "net.mcreator.cbccw.item.AmmoniaItem": Internal.ClassInfo, "java.security.spec.AlgorithmParameterSpec": Internal.ClassInfo, "appeng.recipes.handlers.ChargerRecipe": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrimsonBulletproofGlassBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BlockStateProperties": Internal.ClassInfo, "xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEndBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.ExplosionEventJS$Before": Internal.ClassInfo, "net.minecraft.world.level.block.Block$BlockStatePairKey": Internal.ClassInfo, "org.joml.Matrix4x3fc": Internal.ClassInfo, "com.fasterxml.jackson.databind.type.TypeModifier": Internal.ClassInfo, "net.mcreator.cbccw.block.DustBlock": Internal.ClassInfo, "net.minecraft.world.level.block.HoneyBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildBauBlock": Internal.ClassInfo, "org.apache.logging.log4j.util.MessageSupplier": Internal.ClassInfo, "com.tacz.guns.client.animation.statemachine.GunAnimationStateContext": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.nbt.MultiplierNBT": Internal.ClassInfo, "xaero.pac.common.claims.result.api.ClaimResult$Type": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.WoodVariantTrackBufferBlockEntity": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemOverride$Predicate": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.boring.CannonDrillBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountExtensionBlock": Internal.ClassInfo, "net.satisfy.brewery.block.barrel.BigBarrelRightBlock": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent$CreateSkullModels": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.EnergizedGalenaBlock": Internal.ClassInfo, "appeng.api.config.PowerMultiplier": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformerReuseSerializer": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuSlot": Internal.ClassInfo, "net.satisfy.vinery.core.block.BasketBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.ObjectMapper": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCellReinforcedBlastGlassBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.SodiumHydroxideFluidType": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelblockgrassBlock": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.KeyFrameEvent": Internal.ClassInfo, "net.minecraft.client.gui.Font$DisplayMode": Internal.ClassInfo, "xaero.hud.minimap.world.io.MinimapWorldManagerIO": Internal.ClassInfo, "net.minecraft.world.entity.raid.Raids": Internal.ClassInfo, "net.minecraft.client.PrioritizeChunkUpdates": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockpodzolBlock": Internal.ClassInfo, "io.netty.channel.ChannelHandler": Internal.ClassInfo, "net.mcreator.sab.block.DoublesteelblockgelbBlock": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.item.MethItem$Blue": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromVanillaShapelessRecipe$Serializer": Internal.ClassInfo, "net.mcreator.crustychunks.block.RawLithiumBlockBlock": Internal.ClassInfo, "org.valkyrienskies.tournament.items.GiftBagItem$Companion": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SpikeFeature": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCreamPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedLiquidBlockExtension": Internal.ClassInfo, "net.minecraft.world.item.SplashPotionItem": Internal.ClassInfo, "xaero.hud.category.rule.resolver.ObjectCategoryRuleResolver": Internal.ClassInfo, "com.verr1.controlcraft.content.links.comparator.ComparatorBlockEntity": Internal.ClassInfo, "appeng.api.networking.security.IActionSource": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.ProxyTankBlock": Internal.ClassInfo, "appeng.blockentity.ClientTickingBlockEntity": Internal.ClassInfo, "dev.aika.taczjs.forge.events.asset.AttachmentDataLoadEvent": Internal.ClassInfo, "xfacthd.framedblocks.common.block.cube.FramedTubeBlock": Internal.ClassInfo, "java.nio.channels.Channel": Internal.ClassInfo, "dev.latvian.mods.rhino.Context": Internal.ClassInfo, "com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlock": Internal.ClassInfo, "appeng.api.implementations.items.IFacadeItem": Internal.ClassInfo, "com.ordana.spelunkery.blocks.ChannelBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.track.BezierTrackPointLocation": Internal.ClassInfo, "org.valkyrienskies.mod.mixinducks.mod_compat.create.IMixinControlledContraptionEntity": Internal.ClassInfo, "net.minecraft.world.entity.ai.village.poi.PoiType": Internal.ClassInfo, "slimeknights.tconstruct.tools.item.ModifiableSwordItem": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.wide.WideGaugeComicallyLargeBogeyBlock": Internal.ClassInfo, "net.spaceeye.vmod.mixin.BlockRenderDispatcherAccessor": Internal.ClassInfo, "com.nukateam.ntgl.common.data.config.Ammo": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate": Internal.ClassInfo, "net.minecraft.world.level.block.SmithingTableBlock": Internal.ClassInfo, "org.apache.logging.log4j.core.config.LoggerConfig$Builder": Internal.ClassInfo, "dev.latvian.mods.unit.function.FunctionFactory": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCharcoalExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.SmallBombBlock": Internal.ClassInfo, "com.mrh0.createaddition.blocks.alternator.AlternatorBlockEntity": Internal.ClassInfo, "net.mcreator.cbccw.item.OleicAcidItem": Internal.ClassInfo, "net.minecraft.world.entity.monster.piglin.AbstractPiglin": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkTicketLevelUpdatedEvent": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.KeyDeserializers": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannon_control.cannon_mount.ExtendsCannonMount": Internal.ClassInfo, "net.minecraft.util.LazyLoadedValue": Internal.ClassInfo, "net.ngbatz.createnuclearwar.item.HazmatSuitItem$Leggings": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountExtensionBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.CarpetBlockBuilder": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundGameEventPacket$Type": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.forge.LivingEntityDropsEventJS": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration": Internal.ClassInfo, "com.verr1.controlcraft.content.links.signal.DirectCurrentBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelFoggyReinforcedBlastGlassBlock": Internal.ClassInfo, "org.joml.Matrix4x3dc": Internal.ClassInfo, "com.simibubi.create.content.logistics.funnel.BeltFunnelBlock$Shape": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.WallBlockBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldGenerationContext": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$GunFinishReloadEventJS": Internal.ClassInfo, "xaero.common.minimap.highlight.DimensionHighlighterHandler": Internal.ClassInfo, "com.mojang.serialization.codecs.RecordCodecBuilder$Instance": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.encased.TFMGEncasedShaftBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CellExternalFuelTankBlock": Internal.ClassInfo, "net.minecraftforge.registries.tags.ITagManager": Internal.ClassInfo, "com.tom.storagemod.item.PaintedBlockItem": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedHalfStairsBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonChargePlayerPhase": Internal.ClassInfo, "net.mcreator.sab.block.BrasschBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.type.descriptive.LockMode": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap": Internal.ClassInfo, "com.google.common.collect.ImmutableSetMultimap": Internal.ClassInfo, "malte0811.ferritecore.mixin.blockstatecache.VoxelShapeAccess": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.ServerShip": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup": Internal.ClassInfo, "appeng.debug.PhantomNodeBlockEntity": Internal.ClassInfo, "org.valkyrienskies.mod.common.command.ShipArgumentInfoTemplate": Internal.ClassInfo, "net.mcreator.crustychunks.block.CrackedConcreteWallBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSelectTradePacket": Internal.ClassInfo, "org.valkyrienskies.mod.common.IShipObjectWorldProvider": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.AnnotatedWithParams": Internal.ClassInfo, "net.minecraft.client.resources.SplashManager": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.LookupCache": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.TimeComponent": Internal.ClassInfo, "net.minecraft.world.item.enchantment.FishingSpeedEnchantment": Internal.ClassInfo, "net.mcreator.crustychunks.block.BlueArmorOpticBlock": Internal.ClassInfo, "java.lang.ModuleLayer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSwampCageArmorBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.create.events.SpecialSpoutHandlerEvent$SpoutHandler": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapData": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.DistilledWaterFluidType": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelStorageSource$LevelStorageAccess": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.OvergrownFireSupressionSystemBlockBlock": Internal.ClassInfo, "java.lang.reflect.GenericDeclaration": Internal.ClassInfo, "net.mcreator.crustychunks.block.EngineCyllinderBlock": Internal.ClassInfo, "net.minecraftforge.forgespi.language.ModFileScanData$AnnotationData": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingJungleTrapdoorBlock": Internal.ClassInfo, "net.minecraft.world.level.Explosion": Internal.ClassInfo, "java.util.function.LongConsumer": Internal.ClassInfo, "appeng.api.networking.security.IActionHost": Internal.ClassInfo, "xaero.hud.category.rule.ObjectCategoryRule": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.ConnectorBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterialProperties$Builder": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.wide_gauge.WideGaugeTrackBlock": Internal.ClassInfo, "com.blamejared.controlling.mixin.AccessKeyMapping": Internal.ClassInfo, "mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedControllerIO": Internal.ClassInfo, "net.marblednull.marbledsfirstaid.init.firstaiditems.ElixirItem": Internal.ClassInfo, "org.joml.primitives.AABBic": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Closing": Internal.ClassInfo, "net.minecraft.world.phys.shapes.Shapes$DoubleLineConsumer": Internal.ClassInfo, "dev.latvian.mods.kubejs.platform.forge.ingredient.KubeJSIngredientSerializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.synth.NormalNoise": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.CommentedFileConfigBuilder": Internal.ClassInfo, "com.tom.storagemod.item.PaintKitItem": Internal.ClassInfo, "xaero.map.highlight.MapRegionHighlightsPreparer": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.field.ExposedFieldWrapper": Internal.ClassInfo, "net.marblednull.marbledsfirstaid.init.firstaiditems.BandagesItem": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingTrapdoorOrangeBlock": Internal.ClassInfo, "appeng.block.IOwnerAwareBlockEntity": Internal.ClassInfo, "com.simibubi.create.content.kinetics.base.KineticBlockEntity": Internal.ClassInfo, "com.fasterxml.jackson.core.Version": Internal.ClassInfo, "net.minecraft.world.entity.monster.Giant": Internal.ClassInfo, "cpw.mods.jarhandling.SecureJar$ModuleDataProvider": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$RenderItemInHandBobViewEventJS": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IGenericCrossingTrackBE": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMossCageArmorBlock": Internal.ClassInfo, "com.simibubi.create.foundation.config.ConfigBase$ConfigBool": Internal.ClassInfo, "xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCrimsonArmorBlockBlock": Internal.ClassInfo, "dev.latvian.mods.unit.token.CharStream": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.MigratingWaterloggedCopycatBlock": Internal.ClassInfo, "net.minecraft.world.item.ItemStack": Internal.ClassInfo, "com.google.gson.TypeAdapterFactory": Internal.ClassInfo, "net.mcreator.crustychunks.block.JetTurbineBlock": Internal.ClassInfo, "xaero.map.core.IWorldMapClientPlayNetHandler": Internal.ClassInfo, "corgitaco.corgilib.entity.IsInsideStructureTracker$IsInside": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelPurityExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.EndCityStructure": Internal.ClassInfo, "xaero.hud.category.ui.entry.widget.EditorTextField$UpdatedValueConsumer": Internal.ClassInfo, "com.jozufozu.flywheel.core.virtual.VirtualRenderWorld": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.custom.CustomGunItemBuilder": Internal.ClassInfo, "appeng.block.crafting.AbstractCraftingUnitBlock": Internal.ClassInfo, "com.mojang.datafixers.functions.PointFree": Internal.ClassInfo, "java.net.FileNameMap": Internal.ClassInfo, "com.mrh0.createaddition.recipe.rolling.RollingRecipe": Internal.ClassInfo, "appeng.recipes.entropy.EntropyRecipe": Internal.ClassInfo, "net.minecraftforge.fluids.capability.IFluidHandler": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.contraptions.phys.bearing.PhysBearingBlockEntity$Companion": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.ScriptTypePredicate": Internal.ClassInfo, "com.lazrproductions.cuffed.blocks.TrayBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.constraint.ConnectContext": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration": Internal.ClassInfo, "net.minecraft.world.ticks.LevelTickAccess": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$LightmapStateShard": Internal.ClassInfo, "net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.loader.ChunkLoaderBlockEntity": Internal.ClassInfo, "com.fasterxml.jackson.core.type.WritableTypeId": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.StringToObject": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.DesertWellFeature": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframeManager": Internal.ClassInfo, "java.io.BufferedReader": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.block.CopycatBlockBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntSlabBlock": Internal.ClassInfo, "net.minecraft.world.item.BookItem": Internal.ClassInfo, "net.minecraft.core.particles.SimpleParticleType": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.torpedo_tube.medium_range_torpedo.MediumRangeTorpedoProjectile": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock": Internal.ClassInfo, "net.minecraft.data.DataGenerator$PackGenerator": Internal.ClassInfo, "com.tacz.guns.api.client.event.RenderItemInHandBobEvent": Internal.ClassInfo, "com.simibubi.create.content.trains.bogey.BogeyRenderer$BogeyModelData": Internal.ClassInfo, "net.minecraft.world.entity.NeutralMob": Internal.ClassInfo, "net.mcreator.crustychunks.block.PurpleArmorStairsBlock": Internal.ClassInfo, "com.petrolpark.tube.TubeSpline$TubePlacementResult": Internal.ClassInfo, "net.minecraft.client.GuiMessage$Line": Internal.ClassInfo, "appeng.block.networking.EnergyAcceptorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumRiverFortifiedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonLandingApproachPhase": Internal.ClassInfo, "com.mojang.authlib.properties.PropertyMap": Internal.ClassInfo, "org.joml.primitives.AABBdc": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractFurnaceBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.propeller.PropellerControllerBlockEntity": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.jet.JetBlockEntity": Internal.ClassInfo, "slimeknights.mantle.block.IMultipartConnectedBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.schedule.Schedule": Internal.ClassInfo, "java.lang.Thread$State": Internal.ClassInfo, "com.simibubi.create.content.schematics.SchematicPrinter$EntityTargetHandler": Internal.ClassInfo, "com.verr1.controlcraft.content.links.circuit.CircuitBlock": Internal.ClassInfo, "com.google.common.collect.Multiset$Entry": Internal.ClassInfo, "net.mcreator.createtankdefenses.fluid.types.CoalFluidFluidType": Internal.ClassInfo, "java.text.Format$Field": Internal.ClassInfo, "com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$CachedInfo": Internal.ClassInfo, "com.hlysine.create_connected.content.freewheelclutch.FreewheelClutchBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.storage.CommandStorage": Internal.ClassInfo, "xaero.hud.minimap.waypoint.WaypointCollector": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.BlockPocketWallBlock": Internal.ClassInfo, "com.ordana.spelunkery.items.PortalFluidBottleItem": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelGreenBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.control.LookControl": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingLeaves3Block": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyJungleLogBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.core.components.digital.gates.Gates$Gate": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.vertical_half_layer.CopycatVerticalHalfLayerBlock": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.DoubleArgumentInfo$Template": Internal.ClassInfo, "net.minecraft.world.inventory.DispenserMenu": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEvent": Internal.ClassInfo, "edn.stratodonut.drivebywire.blocks.WireNetworkBackupBlockEntity": Internal.ClassInfo, "java.lang.Iterable": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate$StructureBlockInfo": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuClickEvent": Internal.ClassInfo, "net.minecraft.client.multiplayer.ServerData$ServerPackStatus": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.AbyssmarineWallBlock": Internal.ClassInfo, "net.minecraft.world.entity.EquipmentSlot$Type": Internal.ClassInfo, "net.mcreator.cbccw.item.SodiumAcetateItem": Internal.ClassInfo, "slimeknights.mantle.data.loadable.primitive.MaxLengthStringLoadable": Internal.ClassInfo, "com.simibubi.create.compat.computercraft.AbstractComputerBehaviour": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormatElement$Usage": Internal.ClassInfo, "org.joml.primitives.AABBfc": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes": Internal.ClassInfo, "mod.lucky77.block.base.BlockBase": Internal.ClassInfo, "java.util.Collections$UnmodifiableMap": Internal.ClassInfo, "net.minecraft.world.inventory.AnvilMenu": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.firebox.FireboxBlockEntity": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.physicalities.wing.FlapBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingSlabLightBlueBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.index.CBCRecipeTypes$SimpleRecipeSerializer": Internal.ClassInfo, "xaero.common.validator.NumericFieldValidator": Internal.ClassInfo, "net.minecraft.world.level.CollisionGetter": Internal.ClassInfo, "net.minecraft.world.entity.npc.AbstractVillager": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.config.DropMortarProjectilePropertiesComponent": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelblockBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.PaintingVariantBuilder": Internal.ClassInfo, "com.simibubi.create.content.contraptions.AssemblyException": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrimsonTankHatchBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.server.tag.TagEventJS": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformDamageSerializer": Internal.ClassInfo, "xaero.map.MapFullReloader": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntLadderBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BedPart": Internal.ClassInfo, "net.mcreator.crustychunks.block.FireSpearMissileHardpointBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingStrippedWoodBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.HeliRotorBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.pillar.FramedPillarBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyCherryLogBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BlazingFenceBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelPurpleBlock": Internal.ClassInfo, "com.simibubi.create.foundation.networking.SimplePacketBase": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedAdjustableDoubleSlabBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ReferenceCollection": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ProtectionEnchantment": Internal.ClassInfo, "net.minecraft.world.item.DyeColor": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.PropellerBlock": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeBakedModel": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.generation.large_generator.RotorBlockEntity$StatorOffset": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundUseItemOnPacket": Internal.ClassInfo, "com.supermartijn642.core.item.BaseBlockItem$InteractionFeedback": Internal.ClassInfo, "net.minecraft.client.OptionInstance$CycleableValueSet": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlock": Internal.ClassInfo, "net.mcreator.sab.block.OrangedoublesteelblockBlock": Internal.ClassInfo, "slimeknights.mantle.block.InventoryBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.SteelDoorBlock": Internal.ClassInfo, "com.simibubi.create.foundation.utility.Color": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.he_cannon_rocket.HECannonRocketBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntBambooMosaicSlabBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedDoubleCornerSlopePanelWallBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.Ingredient$Value": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.SlabBlockBuilder": Internal.ClassInfo, "net.minecraft.world.level.block.SculkSpreader": Internal.ClassInfo, "net.minecraft.client.gui.spectator.SpectatorMenuCategory": Internal.ClassInfo, "xaero.hud.category.ui.EditorCategoryNodeConverter": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.entity.PumpjackCrankBlockEntity$CrankSize": Internal.ClassInfo, "net.minecraft.world.level.biome.Climate$Sampler": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOvergrownBlastGlassBlock": Internal.ClassInfo, "net.minecraft.server.packs.repository.PackRepository": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.CarriageContraptionEntity": Internal.ClassInfo, "com.tacz.guns.client.model.BedrockGunModel": Internal.ClassInfo, "net.minecraft.world.entity.animal.SnowGolem": Internal.ClassInfo, "com.copycatsplus.copycats.mixin.foundation.copycat.ChunkAccessAccessor": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$TwoArgumentSimpleFunction$Type": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.DeltaFeature": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2ReferenceFunction": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetTimePacket": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.DetectorBlock$Builder": Internal.ClassInfo, "net.mcreator.sab.block.ZBlock": Internal.ClassInfo, "net.minecraftforge.registries.IdMappingEvent$ModRemapping": Internal.ClassInfo, "java.util.Date": Internal.ClassInfo, "xaero.pac.common.server.player.config.api.IPlayerConfigAPI": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntDarkOakTrapdoorBlock": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.LoadedServerShip": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMesaExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.SoundEventBuilder": Internal.ClassInfo, "net.geforcemods.securitycraft.items.WireCuttersItem": Internal.ClassInfo, "net.minecraft.world.inventory.ContainerData": Internal.ClassInfo, "xaero.hud.category.ui.node.options.EditorSimpleButtonNode$Builder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumAshesFortifiedArmorBlockBlock": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.item.MatchItem": Internal.ClassInfo, "net.satisfy.vinery.core.recipe.FermentationBarrelRecipe": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.BlockPathTypes": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.Property$Value": Internal.ClassInfo, "net.mcreator.sab.block.PBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.AshesbagBlock": Internal.ClassInfo, "java.lang.ref.Reference": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer": Internal.ClassInfo, "net.minecraft.world.level.LevelAccessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2DoubleFunction": Internal.ClassInfo, "net.minecraft.commands.CommandSource": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.EntityEventJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.RootSystemFeature": Internal.ClassInfo, "org.spongepowered.asm.mixin.injection.callback.Cancellable": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedDoubleSlopeBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SitsLetterBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.normal.cast_iron.CastIronPipeBlock": Internal.ClassInfo, "de.maxhenkel.corpse.corelib.dataserializers.DataSerializerItemList$1": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.AbstractIntCollection": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.IPlant": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCellFortifiedArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlockEntity": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.ICopycatBlock$OnRemoveHandler": Internal.ClassInfo, "ht.treechop.api.ITreeChopBlockBehavior": Internal.ClassInfo, "com.tacz.guns.client.model.IFunctionalRenderer": Internal.ClassInfo, "net.minecraftforge.event.server.ServerStoppingEvent": Internal.ClassInfo, "xaero.map.capabilities.ServerWorldCapabilities": Internal.ClassInfo, "net.mcreator.sab.block.Doublesteelblockcolored29Block": Internal.ClassInfo, "slimeknights.mantle.block.StrippableLogBlock": Internal.ClassInfo, "org.valkyrienskies.mod.mixin.accessors.client.multiplayer.ClientLevelAccessor": Internal.ClassInfo, "org.luaj.vm2.Globals": Internal.ClassInfo, "plus.dragons.createdragonlib.advancement.AdvancementHolder": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseScrolled$Pre": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.contraptions.phys.slicker.GooBlock": Internal.ClassInfo, "com.simibubi.create.content.equipment.bell.HauntedBellBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ShearsItemBuilder": Internal.ClassInfo, "slimeknights.tconstruct.world.block.SlimeLeavesBlock": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.TimelessForgeEventWrappers$GunDrawWrapper": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec": Internal.ClassInfo, "java.util.function.IntBinaryOperator": Internal.ClassInfo, "net.mcreator.crustychunks.block.RefineryBlock": Internal.ClassInfo, "mezz.jei.api.helpers.IColorHelper": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonInclude$Include": Internal.ClassInfo, "xaero.hud.minimap.element.render.MinimapElementRenderer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOvergrownBlastGlassBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock": Internal.ClassInfo, "appeng.blockentity.spatial.SpatialPylonBlockEntity": Internal.ClassInfo, "com.simibubi.create.content.kinetics.gantry.GantryShaftBlockEntity": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.IIngredient": Internal.ClassInfo, "dzwdz.chat_heads.mixininterface.Ownable": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig": Internal.ClassInfo, "net.minecraft.client.ClientRecipeBook": Internal.ClassInfo, "xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedInnerThreewayCornerBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.entity.BlockEntityInfo": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlockEntity": Internal.ClassInfo, "org.joml.Vector4fc": Internal.ClassInfo, "net.minecraft.world.item.BucketItem": Internal.ClassInfo, "com.atsuishio.superbwarfare.mixins.AnimationProcessorAccessor": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelDarkGrayBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.energy_components.diode.ElectricDiodeBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.ControlTriggerOffBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.InjectableValues": Internal.ClassInfo, "com.tom.storagemod.block.IInventoryCable": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientSuggestionProvider": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.AfterEntityFallenOnBlockCallbackJS": Internal.ClassInfo, "java.text.SimpleDateFormat": Internal.ClassInfo, "net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription": Internal.ClassInfo, "mcinterface1201.BuilderBlockTileEntity": Internal.ClassInfo, "net.minecraft.world.level.biome.Climate$DistanceMetric": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.LogType": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedDividedPanelBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiOverlayEvent$Pre": Internal.ClassInfo, "com.google.common.hash.HashCode": Internal.ClassInfo, "net.minecraft.world.item.DiggerItem": Internal.ClassInfo, "io.netty.buffer.ByteBufAllocatorMetric": Internal.ClassInfo, "org.valkyrienskies.physics_api.constraints.ConstraintAndId": Internal.ClassInfo, "net.minecraftforge.event.server.ServerStoppedEvent": Internal.ClassInfo, "java.time.temporal.TemporalAdjuster": Internal.ClassInfo, "net.minecraft.client.resources.model.Material": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.zinc.ZincLargeBoilerBlockItem": Internal.ClassInfo, "com.atsuishio.superbwarfare.item.ItemScreenProvider": Internal.ClassInfo, "net.minecraft.world.item.ExperienceBottleItem": Internal.ClassInfo, "slimeknights.tconstruct.library.modifiers.util.LazyModifier": Internal.ClassInfo, "org.apache.commons.math3.analysis.DifferentiableUnivariateFunction": Internal.ClassInfo, "net.satisfy.brewery.block.BeverageBlock": Internal.ClassInfo, "net.minecraft.client.gui.components.toasts.ToastComponent": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildueBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.PropertyNamingStrategy$SnakeCaseStrategy": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockcamoskyBlock": Internal.ClassInfo, "org.joml.Vector4ic": Internal.ClassInfo, "dan200.computercraft.shared.computer.blocks.AbstractComputerBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.GlycerolFluid$Flowing": Internal.ClassInfo, "com.supermartijn642.core.data.condition.ResourceCondition": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock": Internal.ClassInfo, "net.mcreator.cbccw.block.GlycerolBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MesaTankHatchBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.ScorchDirtBlock": Internal.ClassInfo, "net.minecraft.world.level.block.TwistingVinesBlock": Internal.ClassInfo, "net.minecraft.world.level.gameevent.DynamicGameEventListener": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBambooStalkBlock": Internal.ClassInfo, "net.minecraft.world.entity.AreaEffectCloud": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.control.DynamicController": Internal.ClassInfo, "com.atsuishio.superbwarfare.api.event.ReloadEvent": Internal.ClassInfo, "net.mcreator.sab.block.RustedsteelblockBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.LargeElectricMotorBlock": Internal.ClassInfo, "net.mcreator.sab.block.MacraggebluedoublesteelblockBlock": Internal.ClassInfo, "java.lang.reflect.Type": Internal.ClassInfo, "org.valkyrienskies.physics_api.PhysicsWorldReference$PhysicsWorldIsland": Internal.ClassInfo, "com.atsuishio.superbwarfare.command.LowerCamelCaseEnumArgument": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction": Internal.ClassInfo, "appeng.items.tools.powered.WirelessCraftingTerminalItem": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootContextUser": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.SettableAnyProperty": Internal.ClassInfo, "com.happysg.radar.block.controller.yaw.AutoYawControllerBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCeramicCageArmorBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.module.ModuleHookMap": Internal.ClassInfo, "xaero.map.effects.WorldMapStatusEffect": Internal.ClassInfo, "net.mcreator.cbccw.potion.AmmoniumNitrateFuelMobEffect": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventExceptionHandler": Internal.ClassInfo, "net.minecraft.core.Vec3i": Internal.ClassInfo, "net.mcreator.cbccw.item.BrineItem": Internal.ClassInfo, "net.minecraft.server.packs.PackResources": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.munitions.HeavyAutocannonAmmoType": Internal.ClassInfo, "com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTrigger": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.InformationJEIEventJS": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.shapes.OffsetVoxelShapeCache": Internal.ClassInfo, "net.minecraft.world.entity.animal.MushroomCow$MushroomType": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$BooleanValue": Internal.ClassInfo, "xfacthd.framedblocks.api.camo.CamoContainer$Factory": Internal.ClassInfo, "java.time.Clock": Internal.ClassInfo, "xaero.map.executor.Executor": Internal.ClassInfo, "appeng.blockentity.misc.CondenserBlockEntity": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock": Internal.ClassInfo, "java.util.Enumeration": Internal.ClassInfo, "net.minecraft.world.entity.projectile.WitherSkull": Internal.ClassInfo, "org.joml.Matrix3x2d": Internal.ClassInfo, "software.bernie.geckolib.animatable.GeoItem": Internal.ClassInfo, "org.joml.Matrix3x2f": Internal.ClassInfo, "dev.latvian.mods.kubejs.server.tag.TagWrapper": Internal.ClassInfo, "net.mcreator.cbccw.fluid.WoodAlcoholFluid$Flowing": Internal.ClassInfo, "org.apache.logging.log4j.core.lookup.StrMatcher$StringMatcher": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCharcoalReinforcedBlastGlassBlock": Internal.ClassInfo, "org.lwjgl.system.Pointer$Default": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRotateHeadPacket": Internal.ClassInfo, "appeng.me.helpers.IGridConnectedBlockEntity": Internal.ClassInfo, "net.minecraft.server.packs.resources.PreparableReloadListener": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.foundation.mixin.SpoutBlockEntityAccessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SwampOpenTankHatchBlock": Internal.ClassInfo, "mezz.jei.api.runtime.IScreenHelper": Internal.ClassInfo, "net.minecraft.util.thread.ReentrantBlockableEventLoop": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController": Internal.ClassInfo, "net.minecraftforge.fml.event.IModBusEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleSpliterator": Internal.ClassInfo, "net.minecraftforge.event.entity.living.BabyEntitySpawnEvent": Internal.ClassInfo, "slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource": Internal.ClassInfo, "com.google.common.collect.ImmutableBiMap$Builder": Internal.ClassInfo, "com.simibubi.create.content.kinetics.base.BlockBreakingKineticBlockEntity": Internal.ClassInfo, "rbasamoyai.createbigcannons.index.fluid_utils.CBCLiquidBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.ShoulderRidingEntity": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$DoubleValue": Internal.ClassInfo, "com.mojang.brigadier.RedirectModifier": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOvergrownExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.event.BuildCreativeModeTabContentsEvent": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer$Inventory": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.metal_processing.blast_furnace.MoltenMetalBlock": Internal.ClassInfo, "com.ordana.spelunkery.blocks.TangleRootsBodyBlock": Internal.ClassInfo, "net.minecraft.world.item.InstrumentItem": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.solid_shot.SolidShotBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.KeycardLockBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.StoppSchildBlock": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IHasTrackCasing": Internal.ClassInfo, "com.mrh0.createaddition.energy.WireConnectResult": Internal.ClassInfo, "java.util.concurrent.ConcurrentHashMap$KeySetView": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.PiglinSpecificSensor": Internal.ClassInfo, "software.bernie.geckolib.loading.json.raw.FaceUV$Rotation": Internal.ClassInfo, "net.minecraft.world.level.SpawnData$CustomSpawnRules": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.BiomeFilter": Internal.ClassInfo, "com.verr1.controlcraft.content.items.KinematicDeviceBlockItem": Internal.ClassInfo, "com.deltasf.createpropulsion.optical_sensors.InlineOpticalSensorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOceanArmorBlockBlock": Internal.ClassInfo, "java.util.EventObject": Internal.ClassInfo, "com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock": Internal.ClassInfo, "net.mcreator.sab.block.PinksteelblockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrimsonChainArmorBlockBlock": Internal.ClassInfo, "org.valkyrienskies.eureka.block.ShipHelmBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMuddyExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.JsonSerializable": Internal.ClassInfo, "com.mrh0.createaddition.energy.IWireNode": Internal.ClassInfo, "com.google.common.collect.ImmutableCollection$Builder": Internal.ClassInfo, "malte0811.ferritecore.ducks.FastMapStateHolder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer": Internal.ClassInfo, "net.minecraft.world.item.SuspiciousStewItem": Internal.ClassInfo, "java.util.jar.Attributes": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.AbstractPanelBlock": Internal.ClassInfo, "com.atsuishio.superbwarfare.block.ChargingStationBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket": Internal.ClassInfo, "net.minecraft.client.model.geom.ModelPart$Visitor": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.item.NonConsumedCatalystItem": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.concrete.asphalt.AsphaltFluid$Source": Internal.ClassInfo, "com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntMangroveTrapdoorBlock": Internal.ClassInfo, "appeng.items.tools.fluix.FluixHoeItem": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$ClientInfo": Internal.ClassInfo, "net.mcreator.sab.block.NineBlock": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.coaxial_gear.CoaxialGearBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.fluids.FlammableFluid$Source": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.AbuseReportLimits": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.CageTrapBlock": Internal.ClassInfo, "com.simibubi.create.foundation.gui.widget.Label": Internal.ClassInfo, "org.joml.Vector4dc": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.value.DoubleValue": Internal.ClassInfo, "net.minecraft.world.level.block.DropExperienceBlock": Internal.ClassInfo, "xaero.pac.common.server.player.localization.api.IAdaptiveLocalizerAPI": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrimsonBarbedWireBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.PewenBranchBlock": Internal.ClassInfo, "xaero.common.XaeroMinimapSession": Internal.ClassInfo, "com.fasterxml.jackson.core.PrettyPrinter": Internal.ClassInfo, "net.minecraft.world.level.block.SugarCaneBlock": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.munitions.box.HeavyAutocannonAmmoContainerBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blending.BlendingData": Internal.ClassInfo, "com.simibubi.create.content.logistics.depot.EjectorBlockEntity": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.IDyedBuffer": Internal.ClassInfo, "net.mcreator.cbccw.fluid.SoapFluid": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.ReportedEntity": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$EntityMultiPlaceEvent": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.TimelessForgeEventWrappers$ForgeEventWrapper": Internal.ClassInfo, "net.mcreator.sab.block.GgBlock": Internal.ClassInfo, "xaero.common.minimap.render.MinimapSafeModeRenderer": Internal.ClassInfo, "net.minecraft.world.item.UseAnim": Internal.ClassInfo, "net.minecraft.client.model.AgeableListModel": Internal.ClassInfo, "appeng.blockentity.misc.CellWorkbenchBlockEntity": Internal.ClassInfo, "net.satisfy.vinery.core.block.CompletionistBannerBlock": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour": Internal.ClassInfo, "net.minecraft.client.renderer.texture.TextureAtlasSprite$Ticker": Internal.ClassInfo, "com.tacz.guns.block.GunSmithTableBlockA": Internal.ClassInfo, "com.tacz.guns.block.GunSmithTableBlockB": Internal.ClassInfo, "com.tacz.guns.block.GunSmithTableBlockC": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.CeilingFrostmintFeature": Internal.ClassInfo, "com.mrh0.createaddition.recipe.FluidRecipeWrapper": Internal.ClassInfo, "net.mcreator.sab.block.OlivedoublesteelBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromChestRecipe": Internal.ClassInfo, "slimeknights.tconstruct.shared.particle.FluidParticleData": Internal.ClassInfo, "appeng.blockentity.grid.AENetworkPowerBlockEntity": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionCustomSerializer": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour$ProcessingCallback": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.entity.movement_tracker.SectionedEntityMovementTracker": Internal.ClassInfo, "net.pixelbank.burnt.block.SootySpruceFenceBlock": Internal.ClassInfo, "net.minecraft.core.BlockPos$MutableBlockPos": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.BasicMobEffect$Builder": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.normal.aluminum.GlassAluminumPipeBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.BreederReactorPortBlock": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.screws.ScrewBlock": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.subdata.AmmoSlot": Internal.ClassInfo, "dev.latvian.mods.unit.token.UnitToken": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownTrident": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedExtendedCornerSlopePanelBlock": Internal.ClassInfo, "net.minecraft.world.item.enchantment.FireAspectEnchantment": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeShapelessRecipe": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockElementRotation": Internal.ClassInfo, "slimeknights.tconstruct.library.modifiers.ModifierManager$ModifierRegistrationEvent": Internal.ClassInfo, "io.netty.channel.Channel": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.flap.CompactFlapBlock": Internal.ClassInfo, "xfacthd.framedblocks.api.block.cache.StateCache": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDirtPathBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.loot.AccessLootContext": Internal.ClassInfo, "net.mcreator.cbccw.potion.ChlorineGasPoisonMobEffect": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.KeypadSmokerBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.ValidationContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.CocoaDecorator": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SeaFireSupressionSystemBlockBlock": Internal.ClassInfo, "org.embeddedt.embeddium.api.OptionPageConstructionEvent": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.ComparatorMode": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.WoodAlcoholFluidType": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.RebarBlock": Internal.ClassInfo, "com.lazrproductions.cuffed.blocks.CellDoor": Internal.ClassInfo, "net.minecraft.world.item.EndCrystalItem": Internal.ClassInfo, "com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyDioriteWallBlock": Internal.ClassInfo, "xaero.common.gui.ICanTooltip": Internal.ClassInfo, "net.mcreator.sab.block.BrassiBlock": Internal.ClassInfo, "mcinterface1201.mixin.common.BiomeMixin": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingMossCarpetBlock": Internal.ClassInfo, "plus.dragons.createdragonlib.advancement.critereon.SimpleTrigger": Internal.ClassInfo, "software.bernie.geckolib.cache.object.GeoQuad": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.AlarmBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCaramelCageArmorBlock": Internal.ClassInfo, "com.google.common.collect.SingletonImmutableList": Internal.ClassInfo, "net.minecraft.world.effect.AbsoptionMobEffect": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundStopSoundPacket": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$CompiledChunk": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.entity.FluidCachingEntity": Internal.ClassInfo, "com.simibubi.create.content.contraptions.bearing.ClockworkBearingBlockEntity": Internal.ClassInfo, "net.minecraft.util.valueproviders.ClampedNormalInt": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$BeardifierOrMarker": Internal.ClassInfo, "net.minecraft.world.entity.animal.IronGolem": Internal.ClassInfo, "net.mcreator.sab.item.RustedsteelItem": Internal.ClassInfo, "net.minecraft.server.packs.PackResources$ResourceOutput": Internal.ClassInfo, "com.tterrag.registrate.util.entry.RegistryEntry": Internal.ClassInfo, "java.lang.invoke.VarHandle$AccessMode": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.PlatformBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabStabilizerBlock": Internal.ClassInfo, "net.minecraft.world.level.block.MyceliumBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCaramelPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "com.jozufozu.flywheel.util.transform.Transform": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2ShortFunction": Internal.ClassInfo, "net.minecraft.server.level.ChunkMap$DistanceManager": Internal.ClassInfo, "com.tom.peripherals.block.KeyboardBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.WaterloggedVegetationPatchFeature": Internal.ClassInfo, "net.mcreator.sab.block.BrassshBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.digital.FMALinkPort": Internal.ClassInfo, "xaero.common.events.ModClientEvents": Internal.ClassInfo, "org.apache.logging.log4j.message.ExitMessage": Internal.ClassInfo, "xaero.common.minimap.mcworld.MinimapClientWorldData": Internal.ClassInfo, "net.mcreator.crustychunks.block.CyanArmorBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongIterator": Internal.ClassInfo, "com.simibubi.create.content.contraptions.gantry.GantryCarriageBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.EnderManAngerEvent": Internal.ClassInfo, "net.mcreator.crustychunks.block.RocketPodBlock": Internal.ClassInfo, "slimeknights.tconstruct.tables.block.ITabbedBlock": Internal.ClassInfo, "net.minecraft.advancements.Advancement": Internal.ClassInfo, "com.railwayteam.railways.content.extended_sliding_doors.SlidingDoorMode$IHasDoorMode": Internal.ClassInfo, "net.pixelbank.burnt.block.FallingBurntSlabBlock": Internal.ClassInfo, "java.security.PermissionCollection": Internal.ClassInfo, "org.apache.logging.log4j.message.EntryMessage": Internal.ClassInfo, "net.mcreator.sab.block.BrassuBlock": Internal.ClassInfo, "xaero.hud.minimap.module.MinimapSession": Internal.ClassInfo, "dan200.computercraft.api.peripheral.WorkMonitor": Internal.ClassInfo, "java.util.stream.LongStream$Builder": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$DisplayItem": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.ISwitchDisabledEdge": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.property.AzAnimationStageProperties": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.smokestack.SmokestackBlock": Internal.ClassInfo, "net.minecraft.world.level.block.DirtPathBlock": Internal.ClassInfo, "mod.azure.azurelib.core.keyframe.event.data.ParticleKeyframeData": Internal.ClassInfo, "mezz.jei.api.gui.builder.IIngredientConsumer": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2FloatFunction": Internal.ClassInfo, "net.mcreator.sab.block.SteelblockcamosnowBlock": Internal.ClassInfo, "slimeknights.tconstruct.gadgets.block.InvertedCakeBlock": Internal.ClassInfo, "com.simibubi.create.foundation.mixin.accessor.LivingEntityAccessor": Internal.ClassInfo, "java.lang.ThreadGroup": Internal.ClassInfo, "net.minecraft.client.gui.spectator.SpectatorMenuItem": Internal.ClassInfo, "com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonschema.JsonSchema": Internal.ClassInfo, "com.petrolpark.contamination.IContamination": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.cable_blocks.CableTubeBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCaramelReinforcedArmorBlockBlock": Internal.ClassInfo, "com.tacz.guns.api.item.attachment.AttachmentType": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FlowingFluidBuilder": Internal.ClassInfo, "com.simibubi.create.content.contraptions.ControlledContraptionEntity": Internal.ClassInfo, "com.simibubi.create.content.logistics.crate.CrateBlock": Internal.ClassInfo, "net.minecraft.world.item.FlintAndSteelItem": Internal.ClassInfo, "net.geforcemods.securitycraft.compat.IOverlayDisplay": Internal.ClassInfo, "com.simibubi.create.content.schematics.table.SchematicTableBlockEntity": Internal.ClassInfo, "net.geforcemods.securitycraft.items.TaserItem": Internal.ClassInfo, "java.util.function.ObjDoubleConsumer": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.AbyssmarineSlabBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ComponentKJS": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonMunitionBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBoat": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ReferenceFunction": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSunflowerReinforcedBlastGlassBlock": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.MediumQuadrupleWheelBogeyBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMilitaryArmorBlockBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent$FloatRange": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.digital.Mux2LinkPort": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.response.KeyPairResponse": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.WasteDrumBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.Biome": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.context.EquipmentChangeContext": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent": Internal.ClassInfo, "com.google.common.collect.ImmutableMultimap": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.smart_pipes.TFMGSmartFluidPipeBlock": Internal.ClassInfo, "java.util.function.IntFunction": Internal.ClassInfo, "net.mcreator.sab.block.DBlock": Internal.ClassInfo, "com.tacz.guns.api.event.common.GunShootEvent": Internal.ClassInfo, "net.minecraft.advancements.AdvancementRewards": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor$Factory": Internal.ClassInfo, "com.verr1.controlcraft.content.create.DMotorKineticPeripheral": Internal.ClassInfo, "net.satisfy.brewery.recipe.BrewingRecipe$Serializer": Internal.ClassInfo, "dev.architectury.event.events.client.ClientCommandRegistrationEvent$ClientCommandSourceStack": Internal.ClassInfo, "com.supermartijn642.core.mixin.BlockPropertiesAccessor": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.BeltBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMesaCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "org.valkyrienskies.core.apigame.physics.PhysicsEntityServer": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.potion.DarknessIncarnateEffect": Internal.ClassInfo, "com.supermartijn642.core.data.condition.ResourceConditionContext": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CabbageBlock": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo$Template": Internal.ClassInfo, "com.verr1.controlcraft.mixinducks.IEntityDuck": Internal.ClassInfo, "com.nukateam.ntgl.common.util.interfaces.IModelAccessor": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryPropertyMap": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AdvancementEvent$AdvancementEarnEvent": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.block.AccessAbstractCauldronBlock": Internal.ClassInfo, "org.valkyrienskies.eureka.block.WoodType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList": Internal.ClassInfo, "de.srendi.advancedperipherals.common.blocks.base.APBlockEntityBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.SmithingTemplateItemBuilder": Internal.ClassInfo, "me.dantaeusb.zetter.item.crafting.CopyingRecipe$Serializer": Internal.ClassInfo, "xaero.map.effects.NoWorldMapEffect": Internal.ClassInfo, "xfacthd.framedblocks.common.block.torch.FramedSoulWallTorchBlock": Internal.ClassInfo, "com.supermartijn642.fusion.api.model.ModelBakingContext": Internal.ClassInfo, "com.simibubi.create.content.contraptions.bearing.SailBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.LRUMap": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.ShapedKubeJSRecipe$SerializerKJS": Internal.ClassInfo, "net.minecraft.world.entity.animal.Pig": Internal.ClassInfo, "net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.BeltPart": Internal.ClassInfo, "net.minecraft.network.chat.MessageSignature": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2DoubleFunction": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SunflowerFireSupressionSystemBlockBlock": Internal.ClassInfo, "io.netty.channel.nio.NioEventLoopGroup": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$RenderItemInHandBobHurtEventJS": Internal.ClassInfo, "net.minecraft.world.entity.player.Player": Internal.ClassInfo, "xaero.hud.minimap.waypoint.WaypointSession": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingLightBlueBlock": Internal.ClassInfo, "net.minecraft.commands.Commands$CommandSelection": Internal.ClassInfo, "net.minecraft.server.RegistryLayer": Internal.ClassInfo, "net.mcreator.crustychunks.block.TrinititeBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenshotEvent": Internal.ClassInfo, "net.minecraft.world.level.EntityGetter": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.CommentedFileConfig": Internal.ClassInfo, "xfacthd.framedblocks.common.block.pane.FramedCornerStripBlock": Internal.ClassInfo, "net.minecraft.world.level.material.PushReaction": Internal.ClassInfo, "appeng.blockentity.crafting.CraftingMonitorBlockEntity": Internal.ClassInfo, "de.srendi.advancedperipherals.lib.metaphysics.IFeedableAutomataCore": Internal.ClassInfo, "net.minecraft.world.entity.decoration.ArmorStand": Internal.ClassInfo, "net.minecraft.world.entity.npc.VillagerType": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.parameters.LootContextParamSet": Internal.ClassInfo, "net.minecraft.ReportedException": Internal.ClassInfo, "net.minecraft.world.item.crafting.CraftingRecipe": Internal.ClassInfo, "net.minecraft.world.level.block.BaseCoralWallFanBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterShadersEvent": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$PlayerChangedDimensionEvent": Internal.ClassInfo, "xaero.hud.minimap.info.render.compile.InfoDisplayOnCompile": Internal.ClassInfo, "slimeknights.tconstruct.library.materials.definition.MaterialId": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.cables.WireConnection": Internal.ClassInfo, "org.valkyrienskies.core.util.datastructures.IBlockPosSet": Internal.ClassInfo, "com.simibubi.create.content.contraptions.bearing.BearingContraption": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TenMillimetersMeasureBlockBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.misc.OwnershipEvent": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.MotionActivatedLightBlock": Internal.ClassInfo, "java.net.InetAddress": Internal.ClassInfo, "com.google.common.collect.RegularImmutableList": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2BooleanFunction": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.narrow_gauge.NarrowGaugeTrackBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOvergrownFortifiedArmorBlockBlock": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.millstone.block.GraniteDecoMillStoneBlock": Internal.ClassInfo, "dan200.computercraft.shared.command.arguments.RepeatArgumentType$Template": Internal.ClassInfo, "mezz.jei.api.gui.builder.IIngredientAcceptor": Internal.ClassInfo, "com.fasterxml.jackson.core.StreamReadCapability": Internal.ClassInfo, "net.minecraft.world.level.block.SculkBehaviour": Internal.ClassInfo, "com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer": Internal.ClassInfo, "xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.TatamiBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.KeypadTrapDoorBlock": Internal.ClassInfo, "java.io.FilterOutputStream": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSnowCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingTrapdoorBlock": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.CastingTankBlock": Internal.ClassInfo, "org.joml.Vector3dc": Internal.ClassInfo, "xaero.common.minimap.write.MinimapWriter": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.PumpjackHeadBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.MobSpawnSettings$Builder": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.BetterPaneBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOvergrownReinforcedArmorBlockBlock": Internal.ClassInfo, "com.fasterxml.jackson.core.type.WritableTypeId$Inclusion": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilderMap": Internal.ClassInfo, "com.google.common.collect.ImmutableSet$Builder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDustyPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.SulfurStackFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.RegistryCallback": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.HugeFungusFeature": Internal.ClassInfo, "net.mcreator.cbccw.item.HydrogenPeroxideItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.BlockRecipe": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.fencegate.CopycatFenceGateBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ChorusPlantFeature": Internal.ClassInfo, "com.mojang.datafixers.util.Pair": Internal.ClassInfo, "xaero.hud.minimap.waypoint.set.WaypointSet": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.DripstoneClusterFeature": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.apfsds_shot.APFSDSShotBlock": Internal.ClassInfo, "org.joml.Vector3fc": Internal.ClassInfo, "net.minecraft.world.item.enchantment.SweepingEdgeEnchantment": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent": Internal.ClassInfo, "net.minecraft.world.level.block.PowderSnowBlock": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.HeavyAutocannonBlockItem": Internal.ClassInfo, "net.minecraft.world.level.block.WetSpongeBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.tanks.SteelTankBlock$Shape": Internal.ClassInfo, "net.minecraft.util.random.WeightedEntry$IntrusiveBase": Internal.ClassInfo, "net.mcreator.cbccw.item.SaltWaterItem": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrinterBlockEntity": Internal.ClassInfo, "net.mcreator.sab.block.Steelblockcolored32Block": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedPrismCornerBlock": Internal.ClassInfo, "dev.architectury.registry.level.biome.BiomeModifications$BiomeContext": Internal.ClassInfo, "net.minecraft.world.item.crafting.FireworkStarFadeRecipe": Internal.ClassInfo, "net.minecraft.client.DebugQueryHandler": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModLanguageProvider$IModLanguageLoader": Internal.ClassInfo, "com.dsvv.cbcat.cannon.autocannon.munitions.apds.APDSProjectileItem": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.subdata.Perks": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.circuit.Summary": Internal.ClassInfo, "net.mcreator.sab.block.Brass1Block": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration": Internal.ClassInfo, "appeng.api.networking.crafting.ICraftingSubmitResult": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOvergrownReinforcedBlastGlassBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerXpEvent$PickupXp": Internal.ClassInfo, "com.sudolev.interiors.content.block.chair.BigChairBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialProperties$Builder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumVengefulExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.infrastructure.worldgen.LayerPattern": Internal.ClassInfo, "com.nukateam.ntgl.common.foundation.blockentity.inventory.IStorageBlock": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.MoveSpeed": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanel.FramedFlatExtendedDoubleSlopePanelCornerBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.PathComputationType": Internal.ClassInfo, "appeng.block.spatial.SpatialPylonBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.AbstractIllager$IllagerArmPose": Internal.ClassInfo, "com.simibubi.create.content.logistics.crate.CreativeCrateBlock": Internal.ClassInfo, "io.netty.util.concurrent.MultithreadEventExecutorGroup": Internal.ClassInfo, "org.valkyrienskies.mod.mixin.feature.ai.node_evaluator.PathNavigationRegionAccessor": Internal.ClassInfo, "mezz.jei.api.runtime.IJeiRuntime": Internal.ClassInfo, "com.tacz.guns.api.event.common.GunFinishReloadEvent": Internal.ClassInfo, "com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.AshesBulletproofGlassBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AmygdalinFluid$Flowing": Internal.ClassInfo, "net.minecraft.world.item.ArmorMaterial": Internal.ClassInfo, "org.joml.Vector3ic": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntBambooLogBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.misc.ModuleStatesSerializer": Internal.ClassInfo, "org.valkyrienskies.core.apigame.world.chunks.ChunkWatchTasks": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCharcoalReinforcedCageArmorBlock": Internal.ClassInfo, "org.embeddedt.embeddium.api.eventbus.EventHandlerRegistrar": Internal.ClassInfo, "xaero.hud.minimap.radar.category.EntityRadarCategoryManager": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.GlowBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.DeepOnesRuinsFeature": Internal.ClassInfo, "appeng.api.networking.crafting.ICraftingSimulationRequester": Internal.ClassInfo, "com.simibubi.create.content.schematics.table.SchematicTableBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.LivingEntityDeathEventJS": Internal.ClassInfo, "com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeSerializer": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$SaveToFile": Internal.ClassInfo, "com.jozufozu.flywheel.core.materials.BasicData": Internal.ClassInfo, "com.simibubi.create.content.decoration.girder.GirderBlock": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.stairs.CopycatStairsBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory": Internal.ClassInfo, "net.minecraftforge.forgespi.locating.IModFile": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2CharFunction": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDesertFortifiedArmorBlockBlock": Internal.ClassInfo, "appeng.items.parts.ColoredPartItem": Internal.ClassInfo, "xaero.hud.category.FilterObjectCategory": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.CycadFeature": Internal.ClassInfo, "com.fasterxml.jackson.databind.MappingIterator": Internal.ClassInfo, "net.minecraft.world.level.levelgen.SurfaceRules$Context": Internal.ClassInfo, "net.mcreator.sab.block.BrasscommaBlock": Internal.ClassInfo, "com.tacz.guns.api.item.gun.FireMode": Internal.ClassInfo, "java.util.ImmutableCollections$AbstractImmutableMap": Internal.ClassInfo, "com.illusivesoulworks.comforts.common.block.BaseComfortsBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.Zombie": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelblockrotbraunBlock": Internal.ClassInfo, "net.minecraft.world.level.block.LadderBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.SlabWingWhiteBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMorningPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedMasonryCornerSegmentBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingRedBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.crafting.UpgradeNextTierRecipe": Internal.ClassInfo, "appeng.block.networking.CableBusBlock": Internal.ClassInfo, "net.minecraft.world.item.enchantment.Enchantment$Rarity": Internal.ClassInfo, "com.simibubi.create.content.redstone.link.RedstoneLinkBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.casting.CannonCastingRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.VerticalAnchor$BelowTop": Internal.ClassInfo, "com.nukateam.ntgl.common.util.interfaces.IAgeableAccessor": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.primitive.AzQueuedAnimation": Internal.ClassInfo, "com.google.gson.internal.Excluder": Internal.ClassInfo, "com.tacz.guns.api.event.common.KubeJSGunEventPoster": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSeaReinforcedBlastGlassBlock": Internal.ClassInfo, "com.aizistral.nochatreports.common.core.ServerDataExtension": Internal.ClassInfo, "com.jozufozu.flywheel.api.struct.StructType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.NuclearBombBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.synth.NormalNoise$NoiseParameters": Internal.ClassInfo, "net.mcreator.cbccw.item.AluminumHoseItem": Internal.ClassInfo, "net.minecraft.core.HolderGetter": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoublePredicate": Internal.ClassInfo, "net.mcreator.sab.block.BlacksteelblockBlock": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.keyframe.handler.AzParticleKeyframeHandler": Internal.ClassInfo, "net.minecraftforge.common.crafting.ConditionalRecipe$Serializer": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.MonoTrackBufferBlock": Internal.ClassInfo, "xaero.common.gui.IXaeroClickableWidget": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.PositionedWing": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.Ship": Internal.ClassInfo, "net.minecraft.world.level.block.CauldronBlock": Internal.ClassInfo, "net.minecraft.network.chat.ChatType$Bound": Internal.ClassInfo, "java.util.function.ToIntFunction": Internal.ClassInfo, "xaero.pac.common.server.player.config.api.IPlayerConfigAPI$SetResult": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.keyframe.AzAnimationPoint": Internal.ClassInfo, "appeng.api.config.LockCraftingMode": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$RenderLevelBobViewEventJS": Internal.ClassInfo, "net.minecraft.world.level.block.ConduitBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumSidePanelYellowBlock": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$BlockToolModificationEvent": Internal.ClassInfo, "dev.tr7zw.notenoughanimations.versionless.animations.DataHolder": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.WorldBlockPos": Internal.ClassInfo, "com.fasterxml.jackson.core.Versioned": Internal.ClassInfo, "net.mcreator.cbccw.item.AlumisilicateIngotItem": Internal.ClassInfo, "xaero.map.MapRunner": Internal.ClassInfo, "net.mcreator.crustychunks.block.SmokeBombBlock": Internal.ClassInfo, "net.minecraft.world.entity.npc.Villager": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2IntFunction": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingBlueBlock": Internal.ClassInfo, "net.minecraft.world.level.block.CandleCakeBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.Trafficlight1Block": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.Schild50Block": Internal.ClassInfo, "net.mcreator.crustychunks.block.ClusterOfBombsBlock": Internal.ClassInfo, "com.petrolpark.contamination.Contaminant": Internal.ClassInfo, "com.verr1.controlcraft.foundation.network.remote.RemotePort": Internal.ClassInfo, "xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelBlackBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Fox$Type": Internal.ClassInfo, "com.blamejared.crafttweaker.api.util.random.Percentaged": Internal.ClassInfo, "com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeManager$CachedCheck": Internal.ClassInfo, "org.antarcticgardens.newage.content.motors.extension.variants.IMotorExtensionVariant": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.headstock.HeadstockBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.entity.EquipmentEntity": Internal.ClassInfo, "com.simibubi.create.content.fluids.pipes.SmartFluidPipeBlock": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.contraptions.propeller.PropellerBearingBlock$Direction": Internal.ClassInfo, "dev.latvian.mods.unit.UnitContext": Internal.ClassInfo, "xaero.hud.minimap.compass.render.CompassRenderer": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.attachment.AttachmentData": Internal.ClassInfo, "com.supermartijn642.fusion.api.util.Pair": Internal.ClassInfo, "java.util.concurrent.atomic.AtomicBoolean": Internal.ClassInfo, "net.minecraftforge.client.event.RenderTooltipEvent": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumSidePanelBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.TankTreadSegmentBlock": Internal.ClassInfo, "net.minecraft.nbt.FloatTag": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopeslab.FramedElevatedDoubleSlopeSlabBlock": Internal.ClassInfo, "java.lang.AbstractStringBuilder": Internal.ClassInfo, "com.deltasf.createpropulsion.registries.PropulsionFluidsClient$TintedFluidType": Internal.ClassInfo, "net.mcreator.createtankdefenses.world.features.ores.TitaniumOreFeature": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedSteelArmorBlockBlock": Internal.ClassInfo, "de.keksuccino.konkrete.mixin.client.IMixinEditBox": Internal.ClassInfo, "net.minecraft.network.chat.SignedMessageValidator": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket": Internal.ClassInfo, "appeng.helpers.AEMultiBlockEntity": Internal.ClassInfo, "net.geforcemods.securitycraft.items.ModuleItem": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.nbt.ToolStack": Internal.ClassInfo, "org.apache.logging.log4j.message.FlowMessage": Internal.ClassInfo, "net.minecraft.client.ToggleKeyMapping": Internal.ClassInfo, "com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlock": Internal.ClassInfo, "mod.lucky77.item.ItemBook": Internal.ClassInfo, "dan200.computercraft.shared.recipe.CustomShapedRecipe": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.entity.BlockEntityCallback": Internal.ClassInfo, "com.simibubi.create.content.kinetics.drill.DrillBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeMinecraft": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCrimsonReinforcedCageArmorBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.navigation.PathNavigation": Internal.ClassInfo, "xfacthd.framedblocks.common.crafting.FramingSawRecipeSerializer": Internal.ClassInfo, "net.minecraft.world.level.LightLayer": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.intake.AirIntakeBlockEntity": Internal.ClassInfo, "net.minecraft.world.item.crafting.FireworkRocketRecipe": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.properties.ShipTransform": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Horse": Internal.ClassInfo, "appeng.blockentity.misc.InscriberBlockEntity": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SpriteContents": Internal.ClassInfo, "dev.latvian.mods.rhino.util.CustomJavaToJsWrapper": Internal.ClassInfo, "net.minecraft.world.item.enchantment.SwiftSneakEnchantment": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.hydraulic_transmission.HydraulicTransmissionBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMossReinforcedArmorBlockBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingLog3Block": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBambooMosaicStairsBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock": Internal.ClassInfo, "vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab": Internal.ClassInfo, "net.geforcemods.securitycraft.util.ITickingBlockEntity": Internal.ClassInfo, "mezz.jei.api.helpers.IJeiHelpers": Internal.ClassInfo, "com.ordana.spelunkery.blocks.fungi.FloorAndSidesMushroomBlock": Internal.ClassInfo, "xaero.hud.minimap.world.container.config.RootConfig": Internal.ClassInfo, "dev.architectury.event.events.common.ChatEvent$ChatComponent": Internal.ClassInfo, "com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.create.ProcessingRecipeSchema$ItemApplicationRecipeJS": Internal.ClassInfo, "com.mojang.serialization.ListBuilder": Internal.ClassInfo, "net.minecraft.world.level.block.LightBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCeramicElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2LongFunction": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelRiverBlastGlassBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RiverOpenTankHatchBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntMelonBlock": Internal.ClassInfo, "net.mcreator.cbccw.block.NeutralizedAcidBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.Stray": Internal.ClassInfo, "com.simibubi.create.content.contraptions.piston.MechanicalPistonHeadBlock": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.ServicesKeyType": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.keyframe.handler.AzSoundKeyframeHandler": Internal.ClassInfo, "java.util.stream.LongStream": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonSittingPhase": Internal.ClassInfo, "net.minecraft.world.level.block.SculkCatalystBlock": Internal.ClassInfo, "xaero.map.region.MapRegion": Internal.ClassInfo, "java.time.temporal.ChronoUnit": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventJS": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerWakeUpEvent": Internal.ClassInfo, "net.minecraft.world.entity.monster.ElderGuardian": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntVineBlock": Internal.ClassInfo, "org.valkyrienskies.core.apigame.physics.VSCollisionShapes": Internal.ClassInfo, "xaero.hud.category.ui.GuiCategoryEditor$SettingRowList$Entry": Internal.ClassInfo, "net.mcreator.crustychunks.fluid.types.CrudeOilFluidType": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.cache.AzBoneCache": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyBirchStairsBlock": Internal.ClassInfo, "java.nio.file.WatchKey": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.DeltaLetterBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SunflowerReinforcedArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.track.TrackTargetingBehaviour$RenderedTrackOverlayType": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientManager": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingAttackEvent": Internal.ClassInfo, "net.minecraft.network.protocol.status.ServerStatus": Internal.ClassInfo, "net.mcreator.crustychunks.block.CrackedConcreteBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSunflowerExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "mezz.jei.api.recipe.IRecipeCategoriesLookup": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.generic_crossing.TrackShapeLookup$GenericCrossingData": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDesertExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock": Internal.ClassInfo, "java.nio.file.attribute.FileAttributeView": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction$FunctionContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.NopProcessor": Internal.ClassInfo, "net.minecraft.core.particles.BlockParticleOption": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemModificationEventJS": Internal.ClassInfo, "com.simibubi.create.content.trains.graph.TrackEdge": Internal.ClassInfo, "net.mcreator.crustychunks.block.BlastFunnelBlock": Internal.ClassInfo, "net.mcreator.crustychunks.fluid.DieselFluid": Internal.ClassInfo, "immersive_aircraft.item.WeaponItem": Internal.ClassInfo, "java.util.SortedMap": Internal.ClassInfo, "net.minecraft.world.level.block.StainedGlassPaneBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.PeppermintBlock": Internal.ClassInfo, "java.util.concurrent.atomic.AtomicReference": Internal.ClassInfo, "org.valkyrienskies.core.util.datastructures.DenseBlockPosSet": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BlueIceFeature": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMorningFortifiedArmorBlockBlock": Internal.ClassInfo, "org.valkyrienskies.clockwork.mixin.accessors.FluidAccessor": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Noise": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCeramicArmorBlockBlock": Internal.ClassInfo, "dev.aika.taczjs.forge.events.client.LocalPlayerReloadEvent": Internal.ClassInfo, "com.simibubi.create.content.fluids.tank.FluidTankBlock$Shape": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.MediumQuintupleWheelBogeyBlock": Internal.ClassInfo, "net.minecraft.world.level.border.WorldBorder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight": Internal.ClassInfo, "net.minecraft.client.gui.screens.recipebook.RecipeCollection": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.MothBallBlock": Internal.ClassInfo, "com.ordana.spelunkery.items.MagnetItem": Internal.ClassInfo, "net.minecraft.client.color.block.BlockTintCache": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelReinforcedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.RailShape": Internal.ClassInfo, "net.minecraft.world.entity.Display$ItemDisplay": Internal.ClassInfo, "com.petrolpark.contamination.Contamination": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.DesertBulletproofGlassBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.normal.cast_iron.EncasedCastIronPipeBlock": Internal.ClassInfo, "immersive_aircraft.item.DyeableAircraftItem": Internal.ClassInfo, "xaero.map.region.LeveledRegion": Internal.ClassInfo, "net.minecraft.server.packs.repository.PackSource": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$Align": Internal.ClassInfo, "net.minecraft.world.level.block.NetherPortalBlock": Internal.ClassInfo, "net.mcreator.cbccw.item.AlumisulfateIngotItem": Internal.ClassInfo, "net.pixelbank.burnt.block.SootySpruceStairsBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer": Internal.ClassInfo, "appeng.recipes.transform.TransformRecipe": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntCropsBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumVengefulEletromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingSlabBlock": Internal.ClassInfo, "net.minecraft.network.chat.HoverEvent$ItemStackInfo": Internal.ClassInfo, "org.antarcticgardens.newage.content.generation.carbonbrushes.CarbonBrushesBlockEntity": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.vertical_stairs.CopycatVerticalStairBlock": Internal.ClassInfo, "java.util.EnumSet": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Boots": Internal.ClassInfo, "com.mojang.datafixers.types.Type$FieldNotFoundException": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType": Internal.ClassInfo, "appeng.api.parts.IFacadePart": Internal.ClassInfo, "net.minecraft.util.profiling.ProfilerFiller": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleList": Internal.ClassInfo, "slimeknights.tconstruct.tools.modifiers.effect.RepulsiveEffect": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootTable$Builder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SmokeScreenTestBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.BlastingRecipe": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDesertArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CellBulletproofGlassBlock": Internal.ClassInfo, "appeng.blockentity.crafting.PatternProviderBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.entity.LecternBlockEntity": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.StorageIOBlock": Internal.ClassInfo, "io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockController": Internal.ClassInfo, "org.antarcticgardens.newage.content.generation.carbonbrushes.CarbonBrushesBlock": Internal.ClassInfo, "net.minecraft.client.gui.components.Button": Internal.ClassInfo, "com.simibubi.create.content.fluids.pipes.valve.FluidValveBlockEntity": Internal.ClassInfo, "appeng.items.tools.powered.PortableCellItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDustyExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBlockEventPacket": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration": Internal.ClassInfo, "immersive_aircraft.mixin.ServerPlayerEntityMixin": Internal.ClassInfo, "net.minecraftforge.event.RegisterGameTestsEvent": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.hydraulic_press.HydraulicPressBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.BeltBlock": Internal.ClassInfo, "net.mcreator.sab.block.Lightsteelblockcolored33Block": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCeramicElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.inferior_he_shell.InferiorHEShellProjectile": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedTitaniumReinforcedBlastGlassBlock": Internal.ClassInfo, "net.mcreator.sab.block.DoublesteelblockshipbottomBlock": Internal.ClassInfo, "edn.stratodonut.trackwork.tracks.ITrackPointProvider$PointType": Internal.ClassInfo, "net.minecraft.world.entity.animal.Bucketable": Internal.ClassInfo, "net.mcreator.sab.block.OlivelightsteelBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsBlueBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.OleicAcidFluid$Flowing": Internal.ClassInfo, "appeng.items.tools.NetworkToolItem": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.UsernameLoggerBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.block.BlockStateFlagHolder": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyInput": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.FrogAttackablesSensor": Internal.ClassInfo, "org.apache.maven.artifact.repository.ArtifactRepositoryPolicy": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.RenderingGaugeBlock": Internal.ClassInfo, "com.mojang.serialization.DynamicOps": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.TatamiHalfMatBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.deposits.surface_scanner.SurfaceScannerBlockEntity": Internal.ClassInfo, "org.lwjgl.system.Struct": Internal.ClassInfo, "com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.PumpjackHoleBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDustyArmorBlockBlock": Internal.ClassInfo, "java.util.UUID": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.ShipLetterBlock": Internal.ClassInfo, "net.minecraftforge.server.command.EnumArgument": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.GalenaPillarBlock": Internal.ClassInfo, "java.lang.constant.DynamicConstantDesc": Internal.ClassInfo, "com.ordana.spelunkery.utils.IParachuteEntity": Internal.ClassInfo, "appeng.me.cluster.implementations.SpatialPylonCluster$Axis": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceArgument$Info$Template": Internal.ClassInfo, "com.railwayteam.railways.mixin.AccessorToolboxInventory": Internal.ClassInfo, "com.google.common.collect.Maps$IteratorBasedAbstractMap": Internal.ClassInfo, "com.simibubi.create.content.schematics.requirement.ISpecialBlockEntityItemRequirement": Internal.ClassInfo, "appeng.recipes.entropy.EntropyMode": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement": Internal.ClassInfo, "xaero.common.server.mods.ftbteams.SupportFTBTeamsServer": Internal.ClassInfo, "net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType": Internal.ClassInfo, "net.mcreator.cbccw.fluid.SodiumFluid$Source": Internal.ClassInfo, "com.codinglitch.simpleradio.radio.RouterContainer": Internal.ClassInfo, "com.tacz.guns.resource.pojo.AttachmentIndexPOJO": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCharcoalFortifiedArmorBlockBlock": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelblockdirtBlock": Internal.ClassInfo, "net.mcreator.cbccw.block.FormaldehydeBlock": Internal.ClassInfo, "com.google.common.collect.ForwardingCollection": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOvergrownFortifiedArmorBlockBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.torch.FramedRedstoneWallTorchBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMossElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEndBlock": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.multimeter.MultiMeterBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.SaplingBlock": Internal.ClassInfo, "com.happysg.radar.block.radar.bearing.RadarBearingBlock": Internal.ClassInfo, "org.antarcticgardens.newage.content.reactor.reactorrod.ReactorRodBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.create.SequencedAssemblyItemBuilder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumWoodsArmorBlockBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.BlockChangeDetectorBlock": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.contraptions.phys.altmeter.AltMeterBlockEntity": Internal.ClassInfo, "xaero.common.server.IMinecraftServer": Internal.ClassInfo, "com.supermartijn642.fusion.entity.model.FusionModelPart": Internal.ClassInfo, "com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint": Internal.ClassInfo, "net.minecraft.stats.StatsCounter": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.CeilingIceCreamConeFeature": Internal.ClassInfo, "net.pixelbank.burnt.block.EmberSlabBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.drop_mortar_shell.DropMortarShellBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.BrownConcretebagBlock": Internal.ClassInfo, "appeng.api.storage.cells.ICellWorkbenchItem": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.ActivatedByAltar": Internal.ClassInfo, "net.minecraftforge.common.crafting.conditions.ICondition": Internal.ClassInfo, "de.maxhenkel.voicechat.api.packets.LocationalSoundPacket": Internal.ClassInfo, "slimeknights.tconstruct.library.tools.SlotType": Internal.ClassInfo, "com.verr1.controlcraft.foundation.vsapi.PhysShipWrapper": Internal.ClassInfo, "net.minecraft.world.item.enchantment.EnchantmentCategory": Internal.ClassInfo, "net.mcreator.crustychunks.block.TarBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseScrolled$Post": Internal.ClassInfo, "appeng.client.render.cablebus.CableCoreType": Internal.ClassInfo, "appeng.block.qnb.QuantumLinkChamberBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.cable_blocks.CableHubBlock": Internal.ClassInfo, "com.ordana.spelunkery.worldgen.feature_configs.WallMushroomFeatureConfig": Internal.ClassInfo, "net.minecraft.world.item.enchantment.DiggingEnchantment": Internal.ClassInfo, "com.simibubi.create.content.equipment.bell.AbstractBellBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMesaArmorBlockBlock": Internal.ClassInfo, "com.happysg.radar.block.controller.pitch.AutoPitchControllerBlockEntity": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator": Internal.ClassInfo, "net.geforcemods.securitycraft.items.FakeLiquidBucketItem": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyStoneBrickWallBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.FireworksJS$Shape": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundInteractPacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCrimsonFortifiedArmorBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.entity.CarriageParticles": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.render.texture.SpriteContentsExtended": Internal.ClassInfo, "net.geforcemods.securitycraft.api.Option": Internal.ClassInfo, "appeng.api.networking.ticking.ITickManager": Internal.ClassInfo, "net.mcreator.sab.block.Brass3Block": Internal.ClassInfo, "net.mcreator.crustychunks.block.YellowArmorOpticBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCreamCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.item.GlowInkSacItem": Internal.ClassInfo, "org.luaj.vm2.LuaUserdata": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframe": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.coins.CoinBag": Internal.ClassInfo, "xfacthd.framedblocks.common.block.IComplexSlopeSource": Internal.ClassInfo, "net.minecraftforge.common.world.BiomeModifier": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryPropertyMap$Builder": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay": Internal.ClassInfo, "com.fasterxml.jackson.core.util.TextBuffer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$YClampedGradient": Internal.ClassInfo, "xaero.pac.common.capability.ICapableObject": Internal.ClassInfo, "com.verr1.controlcraft.foundation.api.operatable.IFlippableJoint": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.breaker_switch.BreakerSwitchBlock": Internal.ClassInfo, "com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.items.BriefcaseItem": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.TimelessForgeEventWrappers$AmmoHitBlockWrapper": Internal.ClassInfo, "com.supermartijn642.core.item.BaseItem$InteractionFeedback": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblockcamoreddesertBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.condition.type.ConditionAnyDamage": Internal.ClassInfo, "net.minecraft.network.chat.FormattedText$StyledContentConsumer": Internal.ClassInfo, "java.lang.AutoCloseable": Internal.ClassInfo, "com.tacz.guns.client.resource.GunDisplayInstance": Internal.ClassInfo, "com.simibubi.create.content.kinetics.press.PressingBehaviour$Mode": Internal.ClassInfo, "org.valkyrienskies.core.impl.game.ships.PhysInertia": Internal.ClassInfo, "xaero.hud.minimap.radar.state.RadarStateUpdater": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.filter.mob.MobFilter": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.DamageReduce": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.ClearGlassPaneBlock": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServerPlayerList": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.mines.TrackMineBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.items.SecuritySeaBoatItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.BlockStateMirrorCallbackJS": Internal.ClassInfo, "com.tom.peripherals.block.RedstonePortBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingMangroveLeavesBlock": Internal.ClassInfo, "com.simibubi.create.foundation.mixin.accessor.FallingBlockEntityAccessor": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ItemToolTierRegistryEventJS": Internal.ClassInfo, "appeng.block.AEBaseBlockItem": Internal.ClassInfo, "appeng.debug.ItemGenBlockEntity": Internal.ClassInfo, "net.mcreator.crustychunks.block.SummonatorModuleBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingPlanks4Block": Internal.ClassInfo, "io.netty.channel.WriteBufferWaterMark": Internal.ClassInfo, "net.minecraft.world.level.block.HugeMushroomBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.JetExhaustBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.ServerLevelData": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.TypeDescJS": Internal.ClassInfo, "net.satisfy.vinery.core.effect.ResistanceEffect": Internal.ClassInfo, "appeng.block.misc.InscriberBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPressurePlateBlock": Internal.ClassInfo, "com.ordana.spelunkery.blocks.DustBlockBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonHoverPhase": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableAnimated": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelPurityArmorBlockBlock": Internal.ClassInfo, "com.mojang.blaze3d.font.GlyphProvider": Internal.ClassInfo, "de.cristelknight.doapi.common.block.WallDecorationBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityStruckByLightningEvent": Internal.ClassInfo, "org.apache.logging.log4j.core.util.FileWatcher": Internal.ClassInfo, "net.satisfy.brewery.effect.alcohol.AlcoholPlayer": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument$Result": Internal.ClassInfo, "com.mojang.blaze3d.shaders.Program$Type": Internal.ClassInfo, "net.minecraft.world.entity.EntitySelector": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.settings.MainSetting": Internal.ClassInfo, "xaero.pac.common.claims.tracker.api.IClaimsManagerTrackerRegisterAPI": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.differential.DifferentialBlock": Internal.ClassInfo, "net.minecraftforge.fluids.FluidType": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2ByteFunction": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.GradlinksBlock": Internal.ClassInfo, "org.valkyrienskies.core.apigame.world.chunks.TerrainUpdate": Internal.ClassInfo, "com.mojang.blaze3d.shaders.EffectProgram": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.links.ConnectionStatus": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldOpenFlows": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelMagentaBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.ByteBinaryOperator": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.util.TimelessItemNbtFactory": Internal.ClassInfo, "cpw.mods.jarhandling.impl.SimpleJarMetadata": Internal.ClassInfo, "net.mcreator.crustychunks.block.SeekerSpearMissileHardpointBlock": Internal.ClassInfo, "java.util.ImmutableCollections$Set12": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.entity.util.HeadRotationEntityAccessor": Internal.ClassInfo, "net.minecraftforge.client.model.ForgeFaceData": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapDecoration": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDustyCageArmorBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.RecipesEventJS": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.he_shell.HEShellBlock": Internal.ClassInfo, "team.creative.creativecore.common.gui.integration.ContainerIntegration": Internal.ClassInfo, "mod.casinocraft.common.block.BlockSlotMachine": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$BreakEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.Heightmap$Types": Internal.ClassInfo, "appeng.items.contents.NetworkToolMenuHost": Internal.ClassInfo, "net.minecraft.server.ServerFunctionManager$TraceCallbacks": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$PureTransformer": Internal.ClassInfo, "net.minecraft.client.resources.metadata.animation.AnimationFrame": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.FaceLetterBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.kinetic.resistor.KineticResistorBlock": Internal.ClassInfo, "appeng.api.features.IGridLinkableHandler": Internal.ClassInfo, "net.minecraft.client.gui.Gui": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumRiverBlastGlassBlock": Internal.ClassInfo, "net.minecraft.world.level.LevelSimulatedReader": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.HazmatBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelWoodsFortifiedArmorBlockBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.Schild30ZoneeBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.api.OwnableBlockEntity": Internal.ClassInfo, "com.jozufozu.flywheel.util.transform.TStack": Internal.ClassInfo, "com.ordana.spelunkery.blocks.rock_salt.RockSaltCrystalBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SwampTankHatchBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.AcetonePeroxideFluidType": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.PlayerAdvancementEventJS": Internal.ClassInfo, "net.minecraft.world.entity.Display$FloatInterpolator": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$PortalSpawnEvent": Internal.ClassInfo, "java.security.Provider$Service": Internal.ClassInfo, "net.mcreator.sab.block.LightgrayhardsteelblockBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.BrassBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSwampCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.modifiers.impl.BasicModifier": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelResource": Internal.ClassInfo, "com.simibubi.create.AllSpecialTextures": Internal.ClassInfo, "me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAccessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrimsonExternalFluidTankBlock": Internal.ClassInfo, "mezz.jei.api.recipe.IFocusFactory": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AcetoneFluid$Flowing": Internal.ClassInfo, "net.minecraft.client.renderer.texture.Tickable": Internal.ClassInfo, "dan200.computercraft.api.turtle.TurtleVerb": Internal.ClassInfo, "com.simibubi.create.content.trains.station.StationMarker": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.cannons.torpedo_tube.torpedo_end.TorpedoTubeEnd": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetPassengersPacket": Internal.ClassInfo, "com.lazrproductions.cuffed.enchantment.FamineEnchantment": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.ConsoleLine$SourceLine": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2ObjectMap": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.world.WorldRendererExtended": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigManager": Internal.ClassInfo, "net.mcreator.crustychunks.block.LightBlueArmorTrapdoorBlock": Internal.ClassInfo, "java.time.chrono.Era": Internal.ClassInfo, "dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState": Internal.ClassInfo, "com.tacz.guns.api.client.animation.ObjectAnimation": Internal.ClassInfo, "mezz.jei.api.gui.builder.IRecipeLayoutBuilder": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.AzAnimationQueue": Internal.ClassInfo, "com.nukateam.ntgl.common.foundation.effect.IncurableEffect": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.Boat$Type": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.StorageLinkBlock": Internal.ClassInfo, "java.util.Spliterator$OfDouble": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2ShortFunction": Internal.ClassInfo, "net.mcreator.sab.block.BlackhardsteelblockBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntBambooButtonBlock": Internal.ClassInfo, "net.minecraftforge.data.event.GatherDataEvent": Internal.ClassInfo, "com.simibubi.create.content.decoration.bracket.BracketBlock$BracketType": Internal.ClassInfo, "com.simibubi.create.content.kinetics.waterwheel.LargeWaterWheelBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor": Internal.ClassInfo, "net.minecraft.client.StringSplitter$LinePosConsumer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMilitaryReinforcedBlastGlassBlock": Internal.ClassInfo, "net.minecraftforge.forgespi.language.ILifecycleEvent": Internal.ClassInfo, "xaero.hud.category.ui.entry.EditorListRootEntry$CenteredEntryFactory": Internal.ClassInfo, "plus.dragons.createdragonlib.mixin.CreateAdvancementConstructor": Internal.ClassInfo, "xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI": Internal.ClassInfo, "net.minecraft.world.level.border.WorldBorder$Settings": Internal.ClassInfo, "com.railwayteam.railways.content.semaphore.SemaphoreBlock": Internal.ClassInfo, "com.simibubi.create.foundation.block.WrenchableDirectionalBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.he_shell.HEShellProjectile": Internal.ClassInfo, "appeng.blockentity.grid.AENetworkInvBlockEntity": Internal.ClassInfo, "org.valkyrienskies.mod.mixinducks.client.MinecraftDuck": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedExtendedDoubleCornerSlopePanelBlock": Internal.ClassInfo, "appeng.parts.AEBasePart": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMorningReinforcedCageArmorBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.KMath": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.JsonSerializable": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.AxisAlignedLinearPosTest": Internal.ClassInfo, "xaero.hud.category.ui.setting.EditorSettingType": Internal.ClassInfo, "net.minecraft.server.packs.metadata.MetadataSectionSerializer": Internal.ClassInfo, "net.minecraftforge.event.AddReloadListenerEvent": Internal.ClassInfo, "me.steinborn.krypton.mod.shared.WorldEntityByChunkAccess": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.RangedAttribute": Internal.ClassInfo, "org.valkyrienskies.core.api.world.LevelYRange": Internal.ClassInfo, "xfacthd.framedblocks.api.block.AbstractFramedBlock": Internal.ClassInfo, "appeng.api.storage.AEKeyFilter": Internal.ClassInfo, "net.minecraftforge.event.entity.player.FillBucketEvent": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.generic_crossing.GenericCrossingBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.AbyssmarineStairBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SeaPickleFeature": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.BlockGeometryBakingContext$VisibilityData": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.PlatformWrapper$ModInfo": Internal.ClassInfo, "net.minecraft.world.level.block.ChestBlock": Internal.ClassInfo, "appeng.helpers.patternprovider.PatternProviderLogic": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelOceanCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.DatabindException": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.BehaviorControl": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapDecoration$Type": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumVengefulReinforcedBlastGlassBlock": Internal.ClassInfo, "net.mcreator.sab.block.BrassnBlock": Internal.ClassInfo, "dev.architectury.fluid.FluidStack": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCharcoalEletromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "de.maxhenkel.voicechat.api.packets.ConvertablePacket": Internal.ClassInfo, "com.fasterxml.jackson.core.Base64Variant$PaddingReadBehaviour": Internal.ClassInfo, "net.mcreator.crustychunks.block.OilFireboxBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel.ShrapnelShellProjectile": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.AnnotationMap": Internal.ClassInfo, "de.srendi.advancedperipherals.common.blocks.base.BaseBlockEntityBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.low_grade_fuel.LowGradeFuelEngineBlock": Internal.ClassInfo, "appeng.block.storage.ChestBlock": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IGenerallySearchableNavigation": Internal.ClassInfo, "net.minecraft.world.entity.player.ProfileKeyPair": Internal.ClassInfo, "org.joml.primitives.Planed": Internal.ClassInfo, "org.joml.primitives.Planef": Internal.ClassInfo, "net.minecraft.client.Minecraft$ChatStatus": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.entity.PumpjackBearingBlockEntity": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.CubeDeformation": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonProperty$Access": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.EntityLootEventJS": Internal.ClassInfo, "net.minecraftforge.client.textures.ForgeTextureMetadata$Serializer": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$GunReloadEventJS": Internal.ClassInfo, "net.mcreator.sab.block.MagentasteelblockBlock": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonAutoDetect$Value": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormat$Mode": Internal.ClassInfo, "net.minecraftforge.fml.ModLoadingStage": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.NuclearSirenBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.mixin.world.combined_heightmap_update.HeightmapAccessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMossReinforcedBlastGlassBlock": Internal.ClassInfo, "net.minecraft.world.scores.criteria.ObjectiveCriteria$RenderType": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.ToolLetterBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.utils.RestrictedCompoundTag": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AdvancementEvent": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$LineStateShard": Internal.ClassInfo, "team.creative.creativecore.common.gui.sync.GuiSyncGlobal": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedSteelElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.client.textures.ForgeTextureMetadata": Internal.ClassInfo, "net.mcreator.sab.block.QuestionBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.ServerEntityManagerAccessor": Internal.ClassInfo, "net.minecraftforge.eventbus.api.Event": Internal.ClassInfo, "net.minecraft.world.inventory.MerchantMenu": Internal.ClassInfo, "org.apache.logging.log4j.spi.LoggerRegistry": Internal.ClassInfo, "slimeknights.tconstruct.smeltery.block.component.RetexturedOrientableSmelteryBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.BrownArmorBlock": Internal.ClassInfo, "com.google.common.base.Function": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.terminal.WrappedChannel": Internal.ClassInfo, "com.google.common.collect.ImmutableMap": Internal.ClassInfo, "net.minecraft.client.renderer.RenderType$OutlineProperty": Internal.ClassInfo, "com.mojang.datafixers.kinds.App": Internal.ClassInfo, "com.ordana.spelunkery.blocks.rock_salt.RockSaltBlock": Internal.ClassInfo, "net.satisfy.vinery.core.block.CompletionistWallBannerBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.radial.input.RadialEngineInputBlockEntity": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.LoggedChatEvent": Internal.ClassInfo, "com.railwayteam.railways.content.smokestack.block.AxisSmokeStackBlock": Internal.ClassInfo, "com.supermartijn642.fusion.api.model.SpriteIdentifier": Internal.ClassInfo, "net.minecraft.world.entity.animal.Bee": Internal.ClassInfo, "net.mcreator.sab.block.HardsteelblocklightskyBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.KeyPanelBlock": Internal.ClassInfo, "dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState": Internal.ClassInfo, "net.mcreator.crustychunks.block.LimeArmorTrapdoorBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.OrangeArmorOpticBlock": Internal.ClassInfo, "earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer": Internal.ClassInfo, "java.text.ParsePosition": Internal.ClassInfo, "com.supermartijn642.rechiseled.ChiselItem": Internal.ClassInfo, "java.util.Deque": Internal.ClassInfo, "net.minecraftforge.client.event.sound.SoundEvent$SoundSourceEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCeramicFortifiedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.StateTestingPredicate": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.BoneRibsBlock": Internal.ClassInfo, "org.valkyrienskies.clockwork.mixin.content.gravitron.MinecraftAccessor": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.structure.UndergroundCabinStructure": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingTrapdoorWhiteBlock": Internal.ClassInfo, "io.netty.channel.ChannelFuture": Internal.ClassInfo, "java.text.DateFormatSymbols": Internal.ClassInfo, "com.ordana.spelunkery.blocks.MineomiteBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.module.ModuleHook": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.SundropPatchFeature": Internal.ClassInfo, "net.mcreator.crustychunks.block.PetroliumBlock": Internal.ClassInfo, "net.minecraft.network.chat.LastSeenMessages$Update": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.breeches.screw_breech.ScrewBreechBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2BooleanFunction": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeGuiGraphics": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.VinegarFluidType": Internal.ClassInfo, "com.petrolpark.block.entity.IShulkerBoxBlockEntityDuck": Internal.ClassInfo, "net.minecraft.world.level.block.BeehiveBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCaramelArmorBlockBlock": Internal.ClassInfo, "xaero.common.config.CommonConfigIO": Internal.ClassInfo, "net.mcreator.cbccw.item.SiliconCrystalItem": Internal.ClassInfo, "software.bernie.geckolib.renderer.layer.GeoRenderLayer": Internal.ClassInfo, "mezz.jei.library.runtime.JeiRuntime": Internal.ClassInfo, "net.mcreator.crustychunks.block.PurpleArmorBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.IndustrialPipeBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.RegistryEventJS": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2ShortFunction": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.MetalBarrelBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.impl.ObjectIdReader": Internal.ClassInfo, "xaero.hud.pushbox.PushboxHandler": Internal.ClassInfo, "net.minecraft.world.item.DyeableHorseArmorItem": Internal.ClassInfo, "java.math.MathContext": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigValue": Internal.ClassInfo, "net.minecraft.network.syncher.EntityDataAccessor": Internal.ClassInfo, "appeng.debug.ChunkLoaderBlockEntity": Internal.ClassInfo, "net.minecraft.world.item.alchemy.Potion": Internal.ClassInfo, "java.time.ZoneId": Internal.ClassInfo, "net.minecraft.world.level.block.BambooStalkBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.structure.SodaBottleStructure": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RiceRollMedleyBlock": Internal.ClassInfo, "com.tom.storagemod.block.CraftingTerminalBlock": Internal.ClassInfo, "xaero.map.gui.message.render.MessageBoxRenderer": Internal.ClassInfo, "org.apache.logging.log4j.core.jmx.RingBufferAdminMBean": Internal.ClassInfo, "com.tacz.guns.crafting.result.GunSmithTableResult": Internal.ClassInfo, "uwu.lopyluna.create_dd.mixins.AccessorMountedFluidStorage": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.curiosities.tools.wanderwand.SerializableSelectedAreaToolkit": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BambooLeaves": Internal.ClassInfo, "net.minecraft.data.worldgen.BootstapContext": Internal.ClassInfo, "net.minecraft.client.CameraType": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSwampCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket": Internal.ClassInfo, "com.ordana.spelunkery.items.AmethystTuningForkItem": Internal.ClassInfo, "net.minecraft.client.renderer.texture.TextureAtlasSprite": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.VinesFeature": Internal.ClassInfo, "org.valkyrienskies.mod.mixin.accessors.client.render.LevelRendererAccessor": Internal.ClassInfo, "net.mcreator.cbccw.block.AluminumBlockBlock": Internal.ClassInfo, "net.satisfy.brewery.effect.HaleyEffect": Internal.ClassInfo, "net.minecraftforge.event.level.ExplosionEvent$Detonate": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedSlopedStairsBlock": Internal.ClassInfo, "net.minecraftforge.fluids.capability.IFluidHandlerItem": Internal.ClassInfo, "net.mcreator.crustychunks.block.ReactorCasingBlock": Internal.ClassInfo, "xaero.map.task.MapRunnerTask": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer": Internal.ClassInfo, "com.fasterxml.jackson.databind.Module": Internal.ClassInfo, "net.mcreator.sab.block.OneBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSunflowerElectromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCeramicReinforcedCageArmorBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.data.MapData": Internal.ClassInfo, "net.minecraft.world.level.biome.AmbientParticleSettings": Internal.ClassInfo, "com.atsuishio.superbwarfare.block.CreativeChargingStationBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.network.executors.ClientBuffer": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.NBTIOWrapper": Internal.ClassInfo, "com.simibubi.create.content.trains.signal.SignalBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Render$Pre": Internal.ClassInfo, "java.lang.ThreadLocal": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2FloatFunction": Internal.ClassInfo, "com.verr1.controlcraft.foundation.type.descriptive.CheatMode": Internal.ClassInfo, "xfacthd.framedblocks.api.predicate.fullface.FullFacePredicate": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.SlimesteelBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildSOSBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.cimulink.game.port.ISummarizable": Internal.ClassInfo, "net.pixelbank.burnt.block.EmberFenceGateBlock": Internal.ClassInfo, "java.nio.channels.SeekableByteChannel": Internal.ClassInfo, "com.railwayteam.railways.mixin.client.AccessorInstance": Internal.ClassInfo, "net.pixelbank.burnt.block.StairsFireBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.SchildzweipfeilBlock": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.small.lpg.LPGEngineBackBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyStrippedJungleLogBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap": Internal.ClassInfo, "com.mojang.datafixers.kinds.K2": Internal.ClassInfo, "net.minecraft.world.level.block.CarvedPumpkinBlock": Internal.ClassInfo, "com.mojang.datafixers.kinds.K1": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDesertCageArmorBlock": Internal.ClassInfo, "net.minecraft.world.entity.MobCategory": Internal.ClassInfo, "java.lang.constant.DirectMethodHandleDesc$Kind": Internal.ClassInfo, "com.google.common.collect.ImmutableBiMapFauxverideShim": Internal.ClassInfo, "xfacthd.framedblocks.common.block.cube.FramedStorageBlock": Internal.ClassInfo, "org.antarcticgardens.newage.content.heat.heatpump.HeatPumpBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.ShieldBlockEvent": Internal.ClassInfo, "com.fasterxml.jackson.databind.type.LogicalType": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Provides": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumVengefulCageArmorBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.links.scope.OscilloscopeBlockEntity$Channels": Internal.ClassInfo, "net.geforcemods.securitycraft.items.UniversalBlockRemoverItem": Internal.ClassInfo, "com.fasterxml.jackson.core.format.MatchStrength": Internal.ClassInfo, "cc.tweaked_programs.cccbridge.common.minecraft.block.AnimatronicBlock": Internal.ClassInfo, "com.lazrproductions.cuffed.enchantment.ExhaustEnchantment": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedInnerPrismCornerBlock": Internal.ClassInfo, "net.minecraft.world.level.entity.EntityTickList": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerXpEvent$XpChange": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure$Type": Internal.ClassInfo, "java.util.function.DoublePredicate": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$PlayerRespawnEvent": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.GunRecoil": Internal.ClassInfo, "org.luaj.vm2.Varargs": Internal.ClassInfo, "com.simibubi.create.content.trains.graph.TrackNodeLocation$DiscoveredLocation": Internal.ClassInfo, "appeng.debug.PhantomNodeBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.autocannon.recoil_spring.AutocannonRecoilSpringBlockEntity": Internal.ClassInfo, "mezz.jei.api.recipe.RecipeType": Internal.ClassInfo, "net.mcreator.createtankdefenses.fluid.CoalFluidFluid$Source": Internal.ClassInfo, "edn.stratodonut.trackwork.tracks.blocks.WheelBlock": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.entity.OilBarrelBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapBanner": Internal.ClassInfo, "appeng.client.render.effects.ParticleTypes$2": Internal.ClassInfo, "com.tom.storagemod.block.BasicInventoryHopperBlock": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.furnace_engine.PoweredFlywheelBlockEntity": Internal.ClassInfo, "appeng.client.render.effects.ParticleTypes$1": Internal.ClassInfo, "org.antarcticgardens.newage.content.heat.HeatBlockEntity": Internal.ClassInfo, "net.minecraft.server.ServerAdvancementManager": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.EckenBlock": Internal.ClassInfo, "net.minecraft.world.item.HangingSignItem": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.InterModProcessEvent": Internal.ClassInfo, "com.drmangotea.tfmg.items.weapons.explosives.thermite_grenades.fire.BlueFireBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.MediumBypassCompressorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SoundType": Internal.ClassInfo, "net.mcreator.sab.block.BrassccBlock": Internal.ClassInfo, "com.jozufozu.flywheel.util.ClientLevelExtension": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormatElement$Type": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingTrapdoorGrayBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterClientCommandsEvent": Internal.ClassInfo, "com.dsvv.cbcat.cannon.RifledBarrelBlock": Internal.ClassInfo, "org.valkyrienskies.physics_api.PhysicsWorldReference$Companion": Internal.ClassInfo, "edn.stratodonut.trackwork.tracks.blocks.WheelBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CharcoalBulletproofGlassBlock": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BellAttachType": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidStackJS": Internal.ClassInfo, "net.mcreator.sab.block.SteelblockpanzergrauBlock": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.block.BrassCallBellBlock$Trapped": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientItemExtensions": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingSidePanelOrangeBlock": Internal.ClassInfo, "net.minecraftforge.forgespi.locating.IModFile$Type": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootParams": Internal.ClassInfo, "io.netty.channel.DefaultEventLoopGroup": Internal.ClassInfo, "com.simibubi.create.content.equipment.bell.PeculiarBellBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.world.chunk.ChunkHolderExtended": Internal.ClassInfo, "net.minecraft.world.entity.monster.Guardian": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanel.FramedFlatExtendedSlopePanelCornerBlock": Internal.ClassInfo, "net.minecraft.client.resources.sounds.SoundInstance$Attenuation": Internal.ClassInfo, "net.minecraft.world.entity.EquipmentSlot": Internal.ClassInfo, "net.minecraft.world.entity.ai.Brain": Internal.ClassInfo, "net.mcreator.cbccw.block.AmmoniumNitrateBlock": Internal.ClassInfo, "dev.aika.taczjs.forge.events.client.ClientGunIndexLoadEvent": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkGeneratorStructureState": Internal.ClassInfo, "com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity": Internal.ClassInfo, "dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock": Internal.ClassInfo, "org.valkyrienskies.mod.common.command.ShipArgument$Companion": Internal.ClassInfo, "net.minecraftforge.event.GrindstoneEvent": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.links.Coefficients": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.stepped_lever.SteppedLeverBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCharcoalBlastGlassBlock": Internal.ClassInfo, "net.minecraft.world.item.DyeableArmorItem": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedHalfSlopeBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.PeeringCoprolithFeature": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SwampBarbedWireBlock": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$LineSplitter": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IUpdateCount": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedItemPropertiesExtension": Internal.ClassInfo, "net.minecraft.world.level.levelgen.BitRandomSource": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelForestCageArmorBlock": Internal.ClassInfo, "team.creative.creativecore.common.gui.sync.GuiSyncLocal": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.UfoLetterBlock": Internal.ClassInfo, "net.minecraft.util.AbortableIterationConsumer$Continuation": Internal.ClassInfo, "com.simibubi.create.content.equipment.bell.HauntedBellBlockEntity": Internal.ClassInfo, "net.minecraft.network.chat.PlayerChatMessage": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.JungleTempleStructure": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCreamCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "vazkii.patchouli.mixin.client.AccessorClientAdvancements": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeOptional": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.logistics.fluid_reservoir.FluidReservoirBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.base.AbstractEncasedShaftBlock": Internal.ClassInfo, "appeng.helpers.patternprovider.PatternContainer": Internal.ClassInfo, "java.net.ContentHandlerFactory": Internal.ClassInfo, "dev.architectury.core.fluid.ArchitecturyFluidAttributes": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCharcoalReinforcedBlastGlassBlock": Internal.ClassInfo, "org.valkyrienskies.mod.common.util.DimensionIdProvider": Internal.ClassInfo, "org.valkyrienskies.mod.common.item.ShipAssemblerItem": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.ElectrifiedIronFenceGateBlock": Internal.ClassInfo, "com.fasterxml.jackson.core.JsonToken": Internal.ClassInfo, "net.minecraft.world.item.EggItem": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBambooMosaicSlabBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOvergrownReinforcedCageArmorBlock": Internal.ClassInfo, "slimeknights.tconstruct.world.block.BuddingCrystalBlock": Internal.ClassInfo, "com.fasterxml.jackson.core.JsonGenerator$Feature": Internal.ClassInfo, "appeng.api.implementations.IPowerChannelState": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$LongValue": Internal.ClassInfo, "net.minecraft.world.item.AxeItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedTitaniumPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent$Added": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent$LongRange": Internal.ClassInfo, "appeng.items.materials.NamePressItem": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.GalenaHexagonFeature": Internal.ClassInfo, "com.railwayteam.railways.mixin.client.AccessorWalkAnimationState": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RiverBarbedWireBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ItemStackKJS": Internal.ClassInfo, "appeng.api.parts.IPartCollisionHelper": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.FuzedTorpedoProjectileBlock": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.item.MethItem$White": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.entity.EquipmentEntity$EquipmentTrackingEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.RarityFilter": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator": Internal.ClassInfo, "com.probejs.jdoc.java.MethodInfo$ParamInfo": Internal.ClassInfo, "com.tacz.guns.api.GunProperties": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WoodsBulletproofGlassBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeType": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.special.monobogey.AbstractMonoBogeyBlock": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSwampReinforcedCageArmorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BarrelBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.modifiers.ModifierManager$ModifiersLoadedEvent": Internal.ClassInfo, "com.railwayteam.railways.content.palettes.boiler.BoilerBlock$Style": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.decoration.kinetics.SteelGearboxBlock": Internal.ClassInfo, "com.simibubi.create.content.logistics.filter.FilterItemStack": Internal.ClassInfo, "net.minecraft.util.FormattedCharSink": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.YieldLetterBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingBrownBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.FallingBlockBuilder": Internal.ClassInfo, "net.mcreator.sab.block.BrassexclamationBlock": Internal.ClassInfo, "appeng.items.tools.powered.EntropyManipulatorItem": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.PropellerBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.press.PressingRecipe": Internal.ClassInfo, "slimeknights.tconstruct.world.worldgen.islands.IslandStructure": Internal.ClassInfo, "com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour": Internal.ClassInfo, "xaero.common.message.MinimapMessage": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedGlassBlock": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument": Internal.ClassInfo, "com.google.common.collect.AbstractMapBasedMultimap": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelForestPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.Mirror": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.SmallCandyCaneBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.prism.FramedDoubleSlopedPrismBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.remix.HasCannonLightingVolume": Internal.ClassInfo, "xaero.hud.minimap.waypoint.WaypointPurpose": Internal.ClassInfo, "com.simibubi.create.content.kinetics.deployer.DeployerRecipeSearchEvent": Internal.ClassInfo, "net.minecraft.world.entity.LightningBolt": Internal.ClassInfo, "org.embeddedt.modernfix.world.StrongholdLocationCache": Internal.ClassInfo, "net.satisfy.brewery.block.barrel.BigBarrelBlock": Internal.ClassInfo, "java.time.format.TextStyle": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.ValueInstantiator": Internal.ClassInfo, "com.tacz.guns.api.util.LuaNbtAccessor": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingTrapdoorYellowBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.warden.Warden": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.munitions.ap_shot.APProjectileItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.JEISubtypesEventJS$Interpreter": Internal.ClassInfo, "com.verr1.controlcraft.content.links.fma.LinearAdderBlockEntity": Internal.ClassInfo, "com.simibubi.create.content.logistics.funnel.FunnelBlockEntity$Mode": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedNyliumBlock": Internal.ClassInfo, "com.fasterxml.jackson.core.base.ParserMinimalBase": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$EnumValue": Internal.ClassInfo, "me.muksc.tacztweaks.mixininterface.compat.vs.BlockHitResultWithShip": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.BravoLetterBlock": Internal.ClassInfo, "appeng.block.misc.VibrationChamberBlock": Internal.ClassInfo, "net.marblednull.marbledsfirstaid.init.firstaiditems.EyeDropsItem": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.TankTreadRearBlock": Internal.ClassInfo, "net.minecraft.nbt.TagType": Internal.ClassInfo, "mezz.jei.api.runtime.IBookmarkOverlay": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedVerticalSlopedStairsBlock": Internal.ClassInfo, "net.minecraft.world.inventory.AbstractFurnaceMenu": Internal.ClassInfo, "io.netty.channel.MultithreadEventLoopGroup": Internal.ClassInfo, "com.blamejared.crafttweaker.api.recipe.serializer.CTShapedRecipeSerializer": Internal.ClassInfo, "com.google.common.collect.ImmutableEnumMap": Internal.ClassInfo, "net.minecraft.server.packs.repository.Pack$Info": Internal.ClassInfo, "net.minecraft.world.level.ClipBlockStateContext": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.GunKubeJSEvents$EntityKillByGunEventJS": Internal.ClassInfo, "com.simibubi.create.foundation.particle.ICustomParticleData$1": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RawTitaniumBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelWoodsArmorBlockBlock": Internal.ClassInfo, "xaero.hud.minimap.world.state.MinimapWorldState": Internal.ClassInfo, "com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer": Internal.ClassInfo, "net.minecraft.world.level.entity.TransientEntitySectionManager": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelVengefulArmorBlockBlock": Internal.ClassInfo, "net.minecraft.core.Holder$Reference$Type": Internal.ClassInfo, "net.mcreator.crustychunks.block.StructuralConcreteBlock": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.SmartBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.entity.Visibility": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCreamReinforcedCageArmorBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelWoodsReinforcedCageArmorBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmokingRecipe": Internal.ClassInfo, "java.nio.charset.CharsetEncoder": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetScorePacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCreamReinforcedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator": Internal.ClassInfo, "io.netty.channel.ChannelHandlerContext": Internal.ClassInfo, "xaero.hud.minimap.waypoint.DeathpointHandler": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.PositionTracker": Internal.ClassInfo, "slimeknights.mantle.util.typed.TypedMap$Key": Internal.ClassInfo, "org.antarcticgardens.newage.content.motors.variants.IMotorVariant": Internal.ClassInfo, "net.satisfy.brewery.effect.alcohol.AlcoholLevel": Internal.ClassInfo, "software.bernie.geckolib.event.GeoRenderEvent": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.decoration.doors.TFMGSlidingDoorBlock": Internal.ClassInfo, "com.hlysine.create_connected.content.shearpin.ShearPinBlockEntity": Internal.ClassInfo, "net.mcreator.crustychunks.block.ArtilleryAutoloaderBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCharcoalReinforcedCageArmorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumAshesCageArmorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.NineNumberBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AppleJuiceFluid$Source": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedLadderBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.block.AccessBlockStateBase": Internal.ClassInfo, "net.minecraft.world.entity.monster.Vex": Internal.ClassInfo, "dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory$Simple": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityJoinLevelEvent": Internal.ClassInfo, "net.minecraft.world.entity.animal.Cat": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.BlockBuilderProvider": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.transport.BeltInventory": Internal.ClassInfo, "net.minecraftforge.fml.LogicalSide": Internal.ClassInfo, "net.minecraft.world.level.ExplosionDamageCalculator": Internal.ClassInfo, "xaero.hud.minimap.element.render.MinimapElementRendererHandler": Internal.ClassInfo, "com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlock": Internal.ClassInfo, "slimeknights.mantle.data.loadable.field.ConstantField": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell.SmokeShellBlock": Internal.ClassInfo, "java.lang.reflect.AnnotatedType": Internal.ClassInfo, "net.minecraft.world.level.block.StainedGlassBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.WrapFactory": Internal.ClassInfo, "slimeknights.tconstruct.tables.block.TinkerStationBlock": Internal.ClassInfo, "com.ordana.spelunkery.fluids.PortalFluid$Flowing": Internal.ClassInfo, "com.mrh0.createaddition.energy.InternalEnergyStorage": Internal.ClassInfo, "com.tacz.guns.client.model.listener.constraint.ConstraintObject": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.TypeResolutionContext": Internal.ClassInfo, "dev.architectury.event.EventResult": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.boring.UnboredBigCannonBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSunflowerFortifiedArmorBlockBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.links.ValueStatus": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntPlanksBlock": Internal.ClassInfo, "net.mcreator.overworldnetheriteore.item.AncientMillionaireLogoItemItem": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelBlueBlock": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCarpetBlock": Internal.ClassInfo, "com.supermartijn642.fusion.entity.VanillaModelLayerProperties": Internal.ClassInfo, "net.minecraft.server.packs.resources.IoSupplier": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer": Internal.ClassInfo, "net.minecraft.tags.TagKey": Internal.ClassInfo, "net.satisfy.vinery.core.block.entity.FermentationBarrelBlockEntity": Internal.ClassInfo, "com.simibubi.create.content.kinetics.transmission.GearshiftBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.KeypadChestBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerDestroyItemEvent": Internal.ClassInfo, "appeng.parts.automation.AnnihilationPlanePart": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongConsumer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity$AnimationStatus": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.incomplete.IncompleteAutocannonBlockEntity": Internal.ClassInfo, "me.dantaeusb.zetter.storage.CanvasDataType": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.PurityChainArmorBlockBlock": Internal.ClassInfo, "net.minecraft.util.valueproviders.ConstantInt": Internal.ClassInfo, "net.minecraft.world.level.dimension.end.EndDragonFight$Data": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableStatic": Internal.ClassInfo, "net.minecraft.data.recipes.FinishedRecipe": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider": Internal.ClassInfo, "uwu.lopyluna.create_dd.content.blocks.kinetics.multimeter.MultiMeterBlock": Internal.ClassInfo, "com.mojang.brigadier.AmbiguityConsumer": Internal.ClassInfo, "com.ordana.spelunkery.blocks.nephrite.NephriteDiodeBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.data.ShortData": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement": Internal.ClassInfo, "dev.aika.taczjs.forge.events.shooter.LivingEntityReloadEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure": Internal.ClassInfo, "mod.azure.azurelib.core.keyframe.event.data.KeyFrameData": Internal.ClassInfo, "com.mojang.serialization.codecs.ListCodec": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks$2": Internal.ClassInfo, "net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks$1": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CeilingHangingCanvasSignBlock": Internal.ClassInfo, "appeng.api.networking.IGridVisitor": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractCandleBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MagentaConcretebagBlock": Internal.ClassInfo, "xaero.pac.common.server.core.accessor.ICreateContraption": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMorningReinforcedArmorBlockBlock": Internal.ClassInfo, "net.satisfy.vinery.core.world.JungleGrapeFeature": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingConversionEvent$Pre": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.additional_placements.BlockPlacerItem": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.joints.RevoluteJointBlock": Internal.ClassInfo, "com.illusivesoulworks.polymorph.mixin.core.AccessorSmithingTrimRecipe": Internal.ClassInfo, "net.minecraft.client.User": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.UnrefinedWasteBlock": Internal.ClassInfo, "software.bernie.geckolib.core.animation.RawAnimation": Internal.ClassInfo, "java.nio.CharBuffer": Internal.ClassInfo, "net.mcreator.sab.block.AquilaskullBlock": Internal.ClassInfo, "com.mojang.blaze3d.shaders.Uniform": Internal.ClassInfo, "net.minecraft.world.item.enchantment.EnchantmentInstance": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.foundry.BasinFoundryLidBlock": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData": Internal.ClassInfo, "com.mrh0.createaddition.recipe.charging.ChargingRecipeSerializer": Internal.ClassInfo, "net.minecraft.world.entity.animal.MushroomCow": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket": Internal.ClassInfo, "net.minecraft.world.level.block.StairBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.PumpjackBlockEntity": Internal.ClassInfo, "net.minecraft.client.renderer.debug.LightSectionDebugRenderer": Internal.ClassInfo, "com.tacz.guns.api.modifier.ParameterizedCachePair": Internal.ClassInfo, "org.valkyrienskies.core.impl.shadow.Aw": Internal.ClassInfo, "com.atsuishio.superbwarfare.item.gun.GunItem": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientPacketListener": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AmmoniaFluid$Flowing": Internal.ClassInfo, "com.fasterxml.jackson.core.io.SerializedString": Internal.ClassInfo, "net.mcreator.crustychunks.block.KeroseneBlock": Internal.ClassInfo, "net.ngbatz.createnuclearwar.item.HazmatSuitItem$Boots": Internal.ClassInfo, "dev.latvian.mods.kubejs.create.SequencedAssemblyRecipeSchema$SequencedAssemblyRecipeJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Clear": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.AzAnimatorConfig": Internal.ClassInfo, "oshi.util.tuples.Pair": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2ObjectFunction": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.ToggleTriggerOffBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.metal_processing.casting_basin.CastingBasinBlock": Internal.ClassInfo, "net.minecraft.client.model.geom.ModelLayerLocation": Internal.ClassInfo, "com.simibubi.create.foundation.utility.Pair": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingLimeBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.pipes.normal.plastic.PlasticPipeBlock": Internal.ClassInfo, "net.mcreator.sab.block.LBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.AbstractSchoolingFish": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelGrayBlock": Internal.ClassInfo, "net.minecraftforge.fml.event.config.ModConfigEvent": Internal.ClassInfo, "net.minecraft.world.level.block.MultifaceSpreader$SpreadPredicate": Internal.ClassInfo, "net.minecraft.commands.synchronization.SingletonArgumentInfo$Template": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyOakFenceGateBlock": Internal.ClassInfo, "com.mojang.authlib.minecraft.MinecraftProfileTexture$Type": Internal.ClassInfo, "org.apache.commons.lang3.tuple.Pair": Internal.ClassInfo, "org.antarcticgardens.newage.content.energiser.EnergiserBlock": Internal.ClassInfo, "net.minecraft.world.level.block.TorchflowerCropBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiOverlayEvent": Internal.ClassInfo, "java.time.ZoneOffset": Internal.ClassInfo, "net.mcreator.crustychunks.block.LightGrayArmorOpticBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$PlayerLoggedInEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe$Serializer": Internal.ClassInfo, "net.mcreator.cbccw.block.AmygdalinBlock": Internal.ClassInfo, "com.mojang.serialization.MapCodec": Internal.ClassInfo, "xaero.map.gui.ICanTooltip": Internal.ClassInfo, "net.minecraftforge.common.world.ModifiableStructureInfo$StructureInfo": Internal.ClassInfo, "org.apache.maven.repository.legacy.metadata.ArtifactMetadata": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2CharFunction": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.model.BonesItem": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingOrangeBlock": Internal.ClassInfo, "net.satisfy.vinery.core.effect.LuckEffect": Internal.ClassInfo, "net.mcreator.crustychunks.block.RustyTrapdoorBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntSpliterator": Internal.ClassInfo, "net.mcreator.sab.block.BrassqBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.autocannon.config.AutocannonProjectilePropertiesComponent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.CaveSurface": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormat$IndexType": Internal.ClassInfo, "net.minecraft.world.entity.EntityType": Internal.ClassInfo, "com.fasterxml.jackson.databind.jsontype.SubtypeResolver": Internal.ClassInfo, "appeng.debug.DebugCardItem": Internal.ClassInfo, "de.cristelknight.doapi.common.util.GeneralUtil$LineConnectingType": Internal.ClassInfo, "net.minecraft.advancements.Criterion": Internal.ClassInfo, "net.mcreator.cbccw.item.AceticAcidItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.KubeJSCraftingRecipe": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CaramelBarbedWireBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMilitaryBlastGlassBlock": Internal.ClassInfo, "net.mcreator.crustychunks.fluid.OilFluid$Source": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CrimsonOpenTankHatchBlock": Internal.ClassInfo, "net.minecraft.world.level.block.ChorusFlowerBlock": Internal.ClassInfo, "appeng.api.implementations.items.ISpatialStorageCell": Internal.ClassInfo, "net.mcreator.cbccw.item.HydrogenItem": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.ArrayBuilders$FloatBuilder": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.reinforced.ReinforcedSoulSandBlock": Internal.ClassInfo, "appeng.blockentity.misc.VibrationChamberBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.properties.ShipInertiaData": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatCollection": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSwampBlastGlassBlock": Internal.ClassInfo, "java.util.function.LongUnaryOperator": Internal.ClassInfo, "com.fasterxml.jackson.core.util.ByteArrayBuilder": Internal.ClassInfo, "xaero.hud.category.rule.ObjectCategoryIncludeList": Internal.ClassInfo, "net.createcobblestone.blocks.MechanicalGeneratorBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.FireBlock": Internal.ClassInfo, "java.util.ListIterator": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.NuclearSirenFeature": Internal.ClassInfo, "net.minecraft.world.item.HoneyBottleItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CellFireSupressionSystemBlockBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.waterwheel.WaterWheelStructuralBlock": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.logical.LogicalSpatial": Internal.ClassInfo, "org.valkyrienskies.mod.common.IShipObjectWorldClientProvider": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundMovePlayerPacket": Internal.ClassInfo, "com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity": Internal.ClassInfo, "net.mcreator.crustychunks.block.LatheBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.SulfurBudBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDesertCageArmorBlock": Internal.ClassInfo, "mod.lucky77.util.content.Dummy": Internal.ClassInfo, "xaero.common.minimap.info.codec.InfoDisplayStateCodec": Internal.ClassInfo, "net.mcreator.crustychunks.block.GeneratorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MesaBulletproofGlassBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeManager": Internal.ClassInfo, "net.minecraftforge.client.event.RenderLevelStageEvent$RegisterStageEvent": Internal.ClassInfo, "java.util.Spliterator": Internal.ClassInfo, "net.minecraft.world.level.block.FlowerPotBlock": Internal.ClassInfo, "net.minecraftforge.fml.InterModComms$IMCMessage": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SeaBarbedWireBlock": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.colossal_cogwheel.ColossalCogwheelBlock": Internal.ClassInfo, "net.minecraft.world.entity.MobSpawnType": Internal.ClassInfo, "net.minecraft.world.damagesource.DamageType": Internal.ClassInfo, "net.minecraft.client.particle.TextureSheetParticle": Internal.ClassInfo, "java.util.Stack": Internal.ClassInfo, "java.util.concurrent.ConcurrentMap": Internal.ClassInfo, "xaero.common.misc.ListFactory": Internal.ClassInfo, "net.minecraftforge.event.CommandEvent": Internal.ClassInfo, "xaero.pac.client.player.config.api.IPlayerConfigOptionClientStorageAPI": Internal.ClassInfo, "com.petrolpark.petrolsparts.content.planetary_gearset.PlanetaryGearsetBlock": Internal.ClassInfo, "net.satisfy.brewery.recipe.SiloRecipe": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$ServerTickEvent": Internal.ClassInfo, "dev.latvian.mods.rhino.RhinoException": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.ChestLootEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundChatCommandPacket": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyDarkOakFenceGateBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.DustyFireSupressionSystemBlockBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.items.CircuitCompilerItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2LongFunction": Internal.ClassInfo, "java.util.concurrent.locks.Condition": Internal.ClassInfo, "com.simibubi.create.content.trains.observer.TrackObserver": Internal.ClassInfo, "com.ordana.spelunkery.worldgen.feature_configs.CrystalFeatureConfig": Internal.ClassInfo, "slimeknights.tconstruct.world.block.CrystalClusterBlock": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.entity.PumpjackHoleBlockEntity": Internal.ClassInfo, "net.minecraft.network.chat.ChatType$BoundNetwork": Internal.ClassInfo, "java.util.Comparator": Internal.ClassInfo, "xaero.map.server.player.ServerPlayerData": Internal.ClassInfo, "ht.treechop.common.settings.SettingsField": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.UniformLetterBlock": Internal.ClassInfo, "com.jozufozu.flywheel.api.vertex.VertexType": Internal.ClassInfo, "net.mcreator.sab.block.LightsteelblockpodzolBlock": Internal.ClassInfo, "net.minecraft.world.item.PickaxeItem": Internal.ClassInfo, "com.simibubi.create.content.redstone.diodes.BrassDiodeBlockEntity": Internal.ClassInfo, "com.jesz.createdieselgenerators.items.ChemicalSprayerItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.PurityExternalFuelTankBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.CatVariant": Internal.ClassInfo, "net.mcreator.crustychunks.block.DefenseCoreBlock": Internal.ClassInfo, "com.happysg.radar.block.monitor.MonitorBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.WeatheringCopperFullBlock": Internal.ClassInfo, "appeng.api.networking.IInWorldGridNodeHost": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.FlytrapBlock": Internal.ClassInfo, "net.minecraft.world.level.block.NoteBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedInverseDoubleCornerSlopePanelBlock": Internal.ClassInfo, "net.minecraftforge.network.HandshakeMessages$LoginIndexedMessage": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCeramicCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.client.StringSplitter$WidthProvider": Internal.ClassInfo, "com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialProperties": Internal.ClassInfo, "net.minecraft.nbt.StreamTagVisitor$ValueResult": Internal.ClassInfo, "net.mcreator.sab.block.OlivehardsteelBlock": Internal.ClassInfo, "team.creative.creativecore.common.util.registry.NamedHandlerRegistry": Internal.ClassInfo, "com.rabbitminers.extendedbogeys.bogeys.blocks.ExtraLargeBogeyBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ReferenceFunction": Internal.ClassInfo, "org.antarcticgardens.newage.content.reactor.CoriumBlock": Internal.ClassInfo, "org.valkyrienskies.core.apigame.GameServer": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlockEntity": Internal.ClassInfo, "net.minecraft.server.level.ChunkMap": Internal.ClassInfo, "org.valkyrienskies.clockwork.content.contraptions.phys.slicker.SlickerBlockEntity$Companion": Internal.ClassInfo, "xaero.common.effect.NoMinimapEffect": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.GameRulesKJS": Internal.ClassInfo, "net.minecraft.client.gui.components.spectator.SpectatorGui": Internal.ClassInfo, "com.fasterxml.jackson.databind.cfg.MapperBuilder": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSnowReinforcedArmorBlockBlock": Internal.ClassInfo, "team.creative.creativecore.common.gui.event.GuiEvent": Internal.ClassInfo, "com.lazrproductions.cuffed.blocks.BunkBlock": Internal.ClassInfo, "net.mcreator.cbccw.block.AcetoneBlock": Internal.ClassInfo, "xaero.map.region.MapTile": Internal.ClassInfo, "appeng.helpers.externalstorage.GenericStackInv": Internal.ClassInfo, "net.minecraft.client.particle.SpriteSet": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsLimeBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelStorageSource$LevelDirectory": Internal.ClassInfo, "java.io.File": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.base.size.LargeBogeyBlock": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkEvent": Internal.ClassInfo, "net.mcreator.crustychunks.block.BauxiteBlock": Internal.ClassInfo, "net.minecraft.core.dispenser.DispenseItemBehavior": Internal.ClassInfo, "com.simibubi.create.content.schematics.SchematicPrinter$PrintStage": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerActionPacket$Action": Internal.ClassInfo, "net.minecraft.client.gui.components.Renderable": Internal.ClassInfo, "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent": Internal.ClassInfo, "net.minecraft.util.OptionEnum": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity": Internal.ClassInfo, "com.ordana.spelunkery.items.PebbleItem": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntButtonBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.TFMGMachineBlockEntity": Internal.ClassInfo, "de.cristelknight.doapi.common.block.SideBoardBlock": Internal.ClassInfo, "earth.terrarium.chipped.common.blocks.SpecialPointedDripstoneBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.cables.CableConnectorBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.settings.IKeyConflictContext": Internal.ClassInfo, "net.minecraft.client.GuiMessageTag": Internal.ClassInfo, "com.mojang.authlib.minecraft.UserApiService$UserFlag": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2BooleanFunction": Internal.ClassInfo, "mod.azure.azurelib.rewrite.animation.controller.state.machine.AzAnimationControllerStateMachine": Internal.ClassInfo, "net.mcreator.crustychunks.fluid.DieselFluid$Flowing": Internal.ClassInfo, "com.tom.storagemod.block.StorageTerminalBlock": Internal.ClassInfo, "com.mojang.serialization.DataResult$Mu": Internal.ClassInfo, "java.lang.Byte": Internal.ClassInfo, "net.minecraft.network.chat.SignedMessageChain$Encoder": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.deposits.surface_scanner.SurfaceScannerBlock": Internal.ClassInfo, "net.minecraft.world.level.GameRules$Key": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.Behavior": Internal.ClassInfo, "org.apache.logging.log4j.core.Filter": Internal.ClassInfo, "net.minecraft.world.item.InkSacItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.PlayerSelector": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumFoggyBlastGlassBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.AbstractHurtingProjectile": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundDisconnectPacket": Internal.ClassInfo, "dev.latvian.mods.rhino.Symbol": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.DragHandleBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket": Internal.ClassInfo, "xaero.map.biome.BiomeGetter": Internal.ClassInfo, "java.time.OffsetDateTime": Internal.ClassInfo, "com.simibubi.create.content.fluids.pipes.AxisPipeBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.OrdinanceFinsBlock": Internal.ClassInfo, "net.minecraft.world.BossEvent": Internal.ClassInfo, "com.hlysine.create_connected.content.crankwheel.CrankWheelBlock$Large": Internal.ClassInfo, "net.minecraft.world.entity.animal.sniffer.Sniffer$State": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CarverConfiguration": Internal.ClassInfo, "com.verr1.controlcraft.foundation.network.handler.NetworkHandler": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MuddyFireSupressionSystemBlockBlock": Internal.ClassInfo, "com.electronwill.nightconfig.core.ConfigSpec$CorrectionAction": Internal.ClassInfo, "net.mcreator.cbccw.block.ThiodiglycolBlock": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.render.viewport.ViewportProvider": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BeeDebugRenderer$HiveInfo": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrintEntry": Internal.ClassInfo, "earth.terrarium.botarium.common.energy.base.EnergySnapshot": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.AbstractLongSet": Internal.ClassInfo, "slimeknights.mantle.recipe.crafting.ShapedFallbackRecipe": Internal.ClassInfo, "de.maxhenkel.voicechat.api.Player": Internal.ClassInfo, "com.fasterxml.jackson.databind.SerializerProvider": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiEvent": Internal.ClassInfo, "com.railwayteam.railways.mixin.AccessorBlockEntity": Internal.ClassInfo, "net.minecraft.util.valueproviders.BiasedToBottomInt": Internal.ClassInfo, "net.minecraft.world.level.block.BellBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.Schild30eBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemTooltipEventJS$StaticTooltipHandlerFromJS": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$BreakSpeed": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.AllOfPredicate": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.flap.FlapBearingBlock": Internal.ClassInfo, "vectorwing.farmersdelight.common.registry.ModRecipeTypes$1": Internal.ClassInfo, "net.minecraft.network.protocol.BundlerInfo$Provider": Internal.ClassInfo, "net.minecraft.world.level.block.PlayerHeadBlock": Internal.ClassInfo, "com.llamalad7.mixinextras.injector.wrapoperation.Operation": Internal.ClassInfo, "net.minecraftforge.common.world.StructureSettingsBuilder$StructureSpawnOverrideBuilder": Internal.ClassInfo, "net.mcreator.sab.block.SteelblockcamojungleBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.GoLetterBlock": Internal.ClassInfo, "com.nukateam.ntgl.common.foundation.block.RotatedObjectBlock": Internal.ClassInfo, "net.minecraft.client.gui.Font": Internal.ClassInfo, "appeng.api.util.AECableVariant": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.logical.LogicalKinematicMotor": Internal.ClassInfo, "net.minecraft.client.tutorial.TutorialStepInstance": Internal.ClassInfo, "net.minecraft.util.StringRepresentable": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOvergrownReinforcedArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.VengefulTankHatchBlock": Internal.ClassInfo, "net.mcreator.crustychunks.potion.FlammableMobEffect": Internal.ClassInfo, "com.hlysine.create_connected.content.sixwaygearbox.SixWayGearboxBlockEntity": Internal.ClassInfo, "net.minecraft.server.level.WorldGenRegion": Internal.ClassInfo, "net.minecraftforge.event.village.VillagerTradesEvent": Internal.ClassInfo, "team.creative.creativecore.common.network.CreativePacket": Internal.ClassInfo, "com.tacz.guns.api.client.animation.AnimationSoundChannelContent": Internal.ClassInfo, "com.mojang.blaze3d.platform.WindowEventHandler": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBeetrootBlock": Internal.ClassInfo, "appeng.blockentity.misc.GrowthAcceleratorBlockEntity": Internal.ClassInfo, "net.minecraft.world.entity.ai.control.JumpControl": Internal.ClassInfo, "xaero.map.gui.ExportScreen": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModLanguageProvider": Internal.ClassInfo, "dev.ithundxr.createnumismatics.content.backend.Trusted": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCellCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "java.lang.Thread": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SkullBlockEntity": Internal.ClassInfo, "xaero.map.region.texture.BranchTextureRenderer": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemOverride": Internal.ClassInfo, "net.minecraft.world.level.block.CeilingHangingSignBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.ScheduledEvents": Internal.ClassInfo, "net.mcreator.crustychunks.block.PurpleArmorOpticBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SculkShriekerBlockEntity": Internal.ClassInfo, "com.ordana.spelunkery.worldgen.features.CrystalFeature": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.RotatedBlockProvider": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.SprinklesPileFeature": Internal.ClassInfo, "com.dsvv.cbcat.cannon.FumeExtractorBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortIterable": Internal.ClassInfo, "com.simibubi.create.foundation.gui.element.RenderElement": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.HeartOfIronBlock": Internal.ClassInfo, "xaero.hud.minimap.element.render.MinimapElementRenderInfo": Internal.ClassInfo, "org.antarcticgardens.newage.content.motors.MotorBlockEntity": Internal.ClassInfo, "appeng.items.tools.powered.ColorApplicatorItem": Internal.ClassInfo, "javax.crypto.SecretKey": Internal.ClassInfo, "net.minecraft.CrashReport": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructurePieceAccessor": Internal.ClassInfo, "java.util.random.RandomGenerator": Internal.ClassInfo, "dev.aika.taczjs.forge.events.client.LocalPlayerShootEvent": Internal.ClassInfo, "mod.lucky77.block.entity.BlockEntityBase": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonSetter$Value": Internal.ClassInfo, "me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.ServerWorldAccessor": Internal.ClassInfo, "xaero.common.server.radar.tracker.SyncedPlayerTracker": Internal.ClassInfo, "net.minecraft.client.sounds.ChannelAccess": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleIterator": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ClientPlayerKJS": Internal.ClassInfo, "net.mcreator.cbccw.item.MethylamineItem": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.containers.green.GreenContainerBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.anchor.AnchorBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.boring.UnboredScrewBreechBlock": Internal.ClassInfo, "net.minecraftforge.client.event.CustomizeGuiOverlayEvent$Chat": Internal.ClassInfo, "net.marblednull.marbledsfirstaid.init.firstaiditems.AntidoteItem": Internal.ClassInfo, "net.minecraft.network.chat.SignableCommand": Internal.ClassInfo, "forge.me.thosea.badoptimizations.mixin.accessors.GameRendererAccessor": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RiverBulletproofGlassBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumBlockBlock": Internal.ClassInfo, "team.creative.playerrevive.mixin.CombatTrackerAccessor": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarratedElementType": Internal.ClassInfo, "org.apache.logging.log4j.core.impl.LocationAware": Internal.ClassInfo, "net.satisfy.vinery.core.block.FermentationBarrelBlock": Internal.ClassInfo, "io.netty.channel.SimpleChannelInboundHandler": Internal.ClassInfo, "com.nukateam.ntgl.modules.enchantment.enchantments.GunEnchantment": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelCyanBlock": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.large_boiler.andesite.AndesiteBoilerStructure": Internal.ClassInfo, "team.creative.creativecore.common.util.math.base.Axis": Internal.ClassInfo, "xaero.map.gui.dropdown.IDropDownContainer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelRiverCageArmorBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.CustomRecipe": Internal.ClassInfo, "edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Clamp": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCreamPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "com.railwayteam.railways.content.switches.TrackSwitchBlockEntity": Internal.ClassInfo, "org.apache.commons.lang3.tuple.MutablePair": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BrainDebugRenderer$PoiInfo": Internal.ClassInfo, "xfacthd.framedblocks.api.camo.ContainerType": Internal.ClassInfo, "com.tacz.guns.api.client.event.RenderLevelBobEvent": Internal.ClassInfo, "java.util.ImmutableCollections$SetN": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingBirchTrapdoorBlock": Internal.ClassInfo, "java.util.Locale$LanguageRange": Internal.ClassInfo, "com.mojang.brigadier.arguments.ArgumentType": Internal.ClassInfo, "net.minecraftforge.common.capabilities.Capability": Internal.ClassInfo, "net.minecraft.world.item.ItemCooldowns": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.ForestExternalFluidTankBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.VengefulOpenTankHatchBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingPinkBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSwampFortifiedArmorBlockBlock": Internal.ClassInfo, "mod.casinocraft.common.block.BlockArcade": Internal.ClassInfo, "com.simibubi.create.content.decoration.slidingDoor.DoorControl": Internal.ClassInfo, "xfacthd.framedblocks.common.block.door.FramedTrapDoorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.LanternBlock": Internal.ClassInfo, "net.minecraft.world.item.Tier": Internal.ClassInfo, "net.minecraft.client.renderer.PostPass": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController$SoundKeyframeHandler": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.MossBarbedWireBlock": Internal.ClassInfo, "net.minecraft.network.syncher.SynchedEntityData$DataValue": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMossPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "com.google.common.collect.ImmutableList": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedInverseDoubleCornerSlopePanelWallBlock": Internal.ClassInfo, "slimeknights.tconstruct.shared.block.TableBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.UraniumRodBlock": Internal.ClassInfo, "com.tacz.guns.api.client.event.RenderItemInHandBobEvent$BobView": Internal.ClassInfo, "net.mcreator.crustychunks.block.GrayArmorBlock": Internal.ClassInfo, "me.jellysquid.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.YeahLetterBlock": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.BalloonBlock": Internal.ClassInfo, "net.mcreator.sab.block.RedhardsteelblockBlock": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.CreateWorldScreen": Internal.ClassInfo, "net.minecraft.server.packs.resources.ResourceManagerReloadListener": Internal.ClassInfo, "java.text.DecimalFormat": Internal.ClassInfo, "dan200.computercraft.shared.lectern.CustomLecternBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumForestExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "xaero.map.graphics.TextureUploader": Internal.ClassInfo, "net.geforcemods.securitycraft.blocks.mines.BrushableMineBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ConfiguredFeature": Internal.ClassInfo, "com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SunflowerBulletproofGlassBlock": Internal.ClassInfo, "xaero.hud.minimap.waypoint.WaypointColor": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.WallMountBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelDesertReinforcedCageArmorBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CharcoalFireSupressionSystemBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCeramicCageArmorBlock": Internal.ClassInfo, "net.minecraft.server.packs.repository.RepositorySource": Internal.ClassInfo, "com.mojang.authlib.GameProfileRepository": Internal.ClassInfo, "com.fasterxml.jackson.core.util.JacksonFeature": Internal.ClassInfo, "net.minecraftforge.event.level.LevelEvent": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelPinkBlock": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.crushing_wheels.MmbCrushingWheelBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMorningArmorBlockBlock": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.HorizontalStabilizerDarkGrayBlock": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$Row": Internal.ClassInfo, "com.copycatsplus.copycats.content.copycat.slice.CopycatSliceBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.config.LollipopFeatureConfiguration": Internal.ClassInfo, "org.apache.commons.math3.RealFieldElement": Internal.ClassInfo, "org.valkyrienskies.clockwork.util.blocktype.ConnectedWingAlike$Companion": Internal.ClassInfo, "net.minecraft.world.damagesource.DamageScaling": Internal.ClassInfo, "com.codinglitch.simpleradio.core.registry.blocks.RadioBlock": Internal.ClassInfo, "com.simibubi.create.content.fluids.drain.ItemDrainBlock": Internal.ClassInfo, "net.mcreator.sab.block.MinusBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.flat.FlatLayerInfo": Internal.ClassInfo, "com.forsteri.createendertransmission.blocks.itemTransmitter.ItemTransmitterBlock": Internal.ClassInfo, "java.beans.PropertyChangeListener": Internal.ClassInfo, "io.netty.util.concurrent.ProgressivePromise": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingTrapdoorDarkGrayBlock": Internal.ClassInfo, "com.google.common.cache.CacheStats": Internal.ClassInfo, "net.minecraft.world.level.block.CoralWallFanBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.base.cables.CableConnectorBlock": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Info": Internal.ClassInfo, "org.embeddedt.modernfix.forge.mixin.bugfix.entity_pose_stack.PoseStackAccessor": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.ReportChatMessage": Internal.ClassInfo, "appeng.api.implementations.menuobjects.IPortableTerminal": Internal.ClassInfo, "org.apache.logging.log4j.core.lookup.LookupResult": Internal.ClassInfo, "org.luaj.vm2.lib.PackageLib$preload_searcher": Internal.ClassInfo, "net.mcreator.crustychunks.block.SmokeLauncherBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSunflowerReinforcedCageArmorBlock": Internal.ClassInfo, "com.mojang.blaze3d.audio.SoundBuffer": Internal.ClassInfo, "xfacthd.framedblocks.common.crafting.FramingSawRecipe": Internal.ClassInfo, "java.lang.module.ResolvedModule": Internal.ClassInfo, "net.minecraft.core.Rotations": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntIterable": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidBlockBuilder": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyMangroveFenceBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.HotelLetterBlock": Internal.ClassInfo, "net.minecraft.world.ticks.TickContainerAccess": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSeaCageArmorBlock": Internal.ClassInfo, "xaero.common.message.basic.ClientboundRulesPacket": Internal.ClassInfo, "edn.stratodonut.drivebywire.mixinducks.TweakedControllerDuck": Internal.ClassInfo, "dev.latvian.mods.rhino.GeneratedClassLoader": Internal.ClassInfo, "com.dsvv.cbcat.cannon.heavy_autocannon.munitions.hef_shell.HEFProjectileItem": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntMossBlock": Internal.ClassInfo, "com.simibubi.create.content.processing.burner.BlazeBurnerBlock$HeatLevel": Internal.ClassInfo, "net.minecraft.world.level.ChunkPos": Internal.ClassInfo, "com.github.talrey.createdeco.blocks.DecalBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SkullBlock$Type": Internal.ClassInfo, "mezz.jei.api.gui.handlers.IGuiProperties": Internal.ClassInfo, "com.jozufozu.flywheel.backend.model.ElementBuffer": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2IntMap": Internal.ClassInfo, "mod.azure.azurelib.rewrite.model.AzBoneSnapshot": Internal.ClassInfo, "net.minecraft.client.particle.ParticleEngine": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexSorting$DistanceFunction": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMuddyArmorBlockBlock": Internal.ClassInfo, "com.mojang.datafixers.kinds.Kind1": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingChangeTargetEvent$ILivingTargetType": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.StrawBaleBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyJungleWoodBlock": Internal.ClassInfo, "net.minecraft.world.entity.LivingEntity": Internal.ClassInfo, "com.tacz.guns.api.client.animation.AnimationController": Internal.ClassInfo, "com.tacz.guns.api.client.animation.ObjectAnimationChannel": Internal.ClassInfo, "com.ordana.spelunkery.items.EggplantItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCreamFortifiedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.ListPoolElement": Internal.ClassInfo, "net.minecraft.world.item.TippedArrowItem": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.HyperExperienceFluid": Internal.ClassInfo, "com.jetpacker06.CreateBrokenBad.block.TrayBlock$Blue": Internal.ClassInfo, "xaero.pac.common.claims.api.IClaimsManagerAPI": Internal.ClassInfo, "mod.azure.azurelib.core.keyframe.event.data.SoundKeyframeData": Internal.ClassInfo, "net.minecraft.client.renderer.LightTexture": Internal.ClassInfo, "net.minecraft.world.level.storage.PrimaryLevelData$SpecialWorldProperty": Internal.ClassInfo, "net.minecraft.advancements.RequirementsStrategy": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMossCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.CraftingBookCategory": Internal.ClassInfo, "com.codinglitch.simpleradio.api.central.Listening": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator": Internal.ClassInfo, "xaero.map.gui.IScreenBase": Internal.ClassInfo, "net.minecraftforge.client.event.ContainerScreenEvent$Render$Foreground": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelBlockBlock": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.display.gun.Align": Internal.ClassInfo, "com.railwayteam.railways.content.custom_tracks.NoCollisionCustomTrackBlock": Internal.ClassInfo, "com.verr1.controlcraft.content.blocks.OnShipBlockEntity": Internal.ClassInfo, "xaero.pac.client.player.config.api.IPlayerConfigClientStorageAPI": Internal.ClassInfo, "net.pixelbank.burnt.block.WoodFire4Block": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.LivingEntityKJS": Internal.ClassInfo, "software.bernie.geckolib.core.animatable.GeoAnimatable": Internal.ClassInfo, "xaero.hud.category.ui.node.EditorSettingsNode$Builder": Internal.ClassInfo, "com.simibubi.create.foundation.block.IHaveBigOutline": Internal.ClassInfo, "org.antarcticgardens.newage.content.motors.MotorBlock": Internal.ClassInfo, "appeng.blockentity.ServerTickingBlockEntity": Internal.ClassInfo, "mezz.jei.api.gui.ingredient.ICraftingGridHelper": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BrainDebugRenderer$BrainDump": Internal.ClassInfo, "mezz.jei.api.gui.ingredient.IRecipeSlotDrawable": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.FoggyBarbedWireBlock": Internal.ClassInfo, "net.minecraftforge.common.world.BiomeModifier$Phase": Internal.ClassInfo, "net.minecraft.client.gui.components.CycleButton$OnValueChange": Internal.ClassInfo, "xfacthd.framedblocks.api.blueprint.BlueprintCopyBehaviour": Internal.ClassInfo, "net.mcreator.sab.block.PuritysealduoBlock": Internal.ClassInfo, "net.minecraft.world.level.material.Fluid": Internal.ClassInfo, "net.mcreator.crustychunks.block.RedstoneTNTBlock": Internal.ClassInfo, "net.mcreator.sab.block.SteelblockgrassBlock": Internal.ClassInfo, "java.util.LongSummaryStatistics": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CharcoalBarbedWireBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelSeaBlastGlassBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.color.SimpleColor": Internal.ClassInfo, "com.simibubi.create.foundation.gui.element.StencilElement": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumMuddyCompositeArmorBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCharcoalFortifiedArmorBlockBlock": Internal.ClassInfo, "com.lazrproductions.cuffed.enchantment.ImbueEnchantment": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.gun.GunData": Internal.ClassInfo, "com.simibubi.create.content.fluids.VirtualFluid": Internal.ClassInfo, "net.minecraft.world.entity.Targeting": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedVerticalDoubleHalfSlopeBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSnowCageArmorBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.api.data.IData$Type": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMilitaryCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "slimeknights.tconstruct.library.utils.IdParser": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.WashedSteelCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.Schild30ZoneBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyDarkOakPlanksBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.small.gasoline.GasolineEngineBlock": Internal.ClassInfo, "com.mojang.serialization.Keyable": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent$Remove": Internal.ClassInfo, "java.io.InputStream": Internal.ClassInfo, "xaero.pac.common.server.api.OpenPACServerAPI": Internal.ClassInfo, "com.blamejared.crafttweaker.impl.script.ScriptRecipeType": Internal.ClassInfo, "net.minecraft.world.ticks.ScheduledTick": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.DisenchanterBlockEntity": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSwingPacket": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.EmptySackBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.AccessPattern": Internal.ClassInfo, "net.mcreator.cbccw.fluid.UrineFluid$Source": Internal.ClassInfo, "com.ordana.spelunkery.fluids.SpringWater$Source": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.AbstractCannonTorpedoProjectile": Internal.ClassInfo, "net.minecraft.world.item.GameMasterBlockItem": Internal.ClassInfo, "com.railwayteam.railways.content.switches.forge.TrackSwitchBlockImpl": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CreosoteOilBlock": Internal.ClassInfo, "net.minecraft.client.renderer.entity.EntityRenderer": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsPinkBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.small.lpg.LPGEngineBlock": Internal.ClassInfo, "xaero.hud.module.ModuleTransform": Internal.ClassInfo, "net.minecraft.server.level.DistanceManager": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerActionPacket": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator": Internal.ClassInfo, "com.fasterxml.jackson.databind.type.CollectionType": Internal.ClassInfo, "com.mrh0.createaddition.blocks.liquid_blaze_burner.LiquidBlazeBurnerBlockEntity$FuelType": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer": Internal.ClassInfo, "com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlockEntity": Internal.ClassInfo, "java.util.stream.Stream": Internal.ClassInfo, "net.minecraft.world.entity.Marker": Internal.ClassInfo, "com.almostreliable.unified.utils.UnifyTag": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderHeadBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMorningExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.blamejared.controlling.mixin.AccessScreen": Internal.ClassInfo, "slimeknights.mantle.data.registry.GenericLoaderRegistry": Internal.ClassInfo, "net.minecraft.commands.CommandSourceStack": Internal.ClassInfo, "xaero.map.file.worldsave.WorldDataHandler$Result": Internal.ClassInfo, "net.mcreator.sab.block.SandbagBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SootyStoneBricksBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelData": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$CachedLine": Internal.ClassInfo, "com.verr1.controlcraft.foundation.api.delegate.IControllerProvider": Internal.ClassInfo, "com.verr1.controlcraft.foundation.network.remote.RemotePanel": Internal.ClassInfo, "com.mafuyu404.taczaddon.init.VirtualInventory$ItemHandler": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile": Internal.ClassInfo, "com.github.alexthe666.citadel.server.block.CitadelLecternBlock": Internal.ClassInfo, "com.railwayteam.railways.mixin.AccessorCarriage": Internal.ClassInfo, "net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity": Internal.ClassInfo, "com.jozufozu.flywheel.api.MaterialGroup": Internal.ClassInfo, "appeng.block.storage.SkyChestBlock$SkyChestType": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.containers.green.GreenContainerBlockEntity": Internal.ClassInfo, "net.mcreator.sab.block.ABlock": Internal.ClassInfo, "appeng.blockentity.networking.CableBusBlockEntity": Internal.ClassInfo, "xaero.pac.common.server.core.accessor.ICreateContraptionEntity": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.server.AccessMinecraftServer": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationInfo": Internal.ClassInfo, "com.atsuishio.superbwarfare.perk.Perk": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CabinetBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder": Internal.ClassInfo, "com.probejs.jdoc.ISerde": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingDropsEvent": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.framed.BlockFramedStandardDrawers": Internal.ClassInfo, "com.railwayteam.railways.mixin.AccessorToolboxBlockEntity": Internal.ClassInfo, "me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.TestThrusterBlock": Internal.ClassInfo, "com.nukateam.ntgl.modules.enchantment.enchantments.QuickHandsEnchantment": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCageArmorBlock": Internal.ClassInfo, "slimeknights.tconstruct.gadgets.block.PunjiBlock": Internal.ClassInfo, "com.hlysine.create_connected.content.copycat.stairs.CopycatStairsBlock": Internal.ClassInfo, "slimeknights.tconstruct.tools.modifiers.traits.skull.SelfDestructiveModifier$SelfDestructiveEffect": Internal.ClassInfo, "com.mrh0.createaddition.blocks.connector.SmallLightConnectorBlock": Internal.ClassInfo, "dan200.computercraft.api.lua.IArguments": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumRiverExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.drmangotea.tfmg.base.effects.HellFireEffect": Internal.ClassInfo, "com.probejs.jdoc.java.ConstructorInfo": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootContext$EntityTarget": Internal.ClassInfo, "java.util.concurrent.ConcurrentHashMap": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntCaveVinesPlantBlock": Internal.ClassInfo, "net.minecraft.util.profiling.ResultField": Internal.ClassInfo, "net.minecraft.world.entity.animal.Cow": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blending.Blender": Internal.ClassInfo, "com.hlysine.create_connected.content.linkedtransmitter.LinkedAnalogLeverBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.synth.BlendedNoise": Internal.ClassInfo, "net.minecraft.world.entity.animal.Cod": Internal.ClassInfo, "org.apache.commons.math3.analysis.UnivariateFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.BoundingBox": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket": Internal.ClassInfo, "net.mcreator.crustychunks.block.ZincBlockBlock": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationUiState$SelectedGameMode": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingStairsRedBlock": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent": Internal.ClassInfo, "vectorwing.farmersdelight.common.crafting.CookingPotRecipe": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.entity.DistillationTankBlockEntity": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ObjectMap$Entry": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferBuilder": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingHayBlock": Internal.ClassInfo, "java.util.concurrent.CompletableFuture": Internal.ClassInfo, "net.minecraft.world.item.PotionItem": Internal.ClassInfo, "net.satisfy.vinery.core.effect.CreeperEffect": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.FillLayerFeature": Internal.ClassInfo, "appeng.api.networking.events.statistics.GridChunkEvent$GridChunkAdded": Internal.ClassInfo, "earth.terrarium.chipped.common.recipes.ChippedRecipe$Serializer": Internal.ClassInfo, "net.mcreator.sab.block.BrasszhBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.EyeOfEnder": Internal.ClassInfo, "net.minecraft.world.level.PathNavigationRegion": Internal.ClassInfo, "com.fasterxml.jackson.databind.introspect.AnnotatedParameter": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateTagsPacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SoftLetterBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldgenRandom": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.response.Response": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterColorHandlersEvent$Item": Internal.ClassInfo, "net.minecraft.advancements.AdvancementRewards$Builder": Internal.ClassInfo, "net.minecraft.world.level.block.AnvilBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectListIterator": Internal.ClassInfo, "net.mcreator.sab.block.YuBlock": Internal.ClassInfo, "net.minecraft.data.BlockFamily$Variant": Internal.ClassInfo, "software.bernie.geckolib.core.object.PlayState": Internal.ClassInfo, "com.railwayteam.railways.content.fuel.psi.PortableFuelInterfaceBlock": Internal.ClassInfo, "net.mcreator.cbccw.fluid.AcetonePeroxideFluid$Flowing": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingYellowBlock": Internal.ClassInfo, "net.minecraft.client.renderer.MultiBufferSource$BufferSource": Internal.ClassInfo, "xaero.common.server.mods.SupportWorldMapServer": Internal.ClassInfo, "com.github.talrey.createdeco.blocks.SupportBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.generation.generator.GeneratorBlock": Internal.ClassInfo, "net.minecraft.server.packs.PackType": Internal.ClassInfo, "appeng.api.implementations.blockentities.IMEChest": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseDragged": Internal.ClassInfo, "java.text.FieldPosition": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.WithAttachedData": Internal.ClassInfo, "slimeknights.tconstruct.world.worldgen.trees.feature.SlimeTreeFeature": Internal.ClassInfo, "net.minecraft.world.level.block.TallGrassBlock": Internal.ClassInfo, "com.tacz.guns.client.resource.pojo.display.gun.TextShow": Internal.ClassInfo, "com.verr1.controlcraft.content.gui.layouts.api.IScheduleProvider": Internal.ClassInfo, "com.simibubi.create.foundation.utility.WorldAttached": Internal.ClassInfo, "net.mcreator.cbccw.potion.NitroglycerinMobEffect": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntSpruceDoorBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration": Internal.ClassInfo, "net.minecraft.client.renderer.LevelRenderer": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.FoggyOpenTankHatchBlock": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$NeighborNotifyEvent": Internal.ClassInfo, "com.railwayteam.railways.content.buffer.WoodVariantTrackBufferBlock": Internal.ClassInfo, "earth.terrarium.chipped.common.recipes.ChippedRecipe": Internal.ClassInfo, "dan200.computercraft.api.client.TransformedModel": Internal.ClassInfo, "net.minecraft.commands.arguments.TimeArgument": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SixNumberBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.ZombieHorse": Internal.ClassInfo, "net.minecraft.world.entity.projectile.EvokerFangs": Internal.ClassInfo, "org.valkyrienskies.mod.mixinducks.com.mojang.blaze3d.audio.HasOpenALVelocity": Internal.ClassInfo, "net.satisfy.vinery.core.util.GrapeType": Internal.ClassInfo, "com.codinglitch.simpleradio.core.registry.blocks.RadiosmitherBlock$RadiosmitherPart": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingSlabLimeBlock": Internal.ClassInfo, "earth.terrarium.chipped.common.blocks.SpecialLanternBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.Hash$Strategy": Internal.ClassInfo, "net.minecraftforge.server.command.EnumArgument$Info$Template": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour$TransportedResult": Internal.ClassInfo, "net.minecraft.server.ServerScoreboard": Internal.ClassInfo, "net.minecraft.world.level.GameRules$Value": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeShapelessRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.LayerConfiguration": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.breeches.sliding_breech.SlidingBreechBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2LongFunction": Internal.ClassInfo, "com.cainiao1053.cbcmoreshells.munitions.big_cannon.long_range_torpedo.LongRangeTorpedoBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.engines.radial.RadialEngineBlockEntity": Internal.ClassInfo, "xaero.map.biome.BiomeColorCalculator": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModFileInfo": Internal.ClassInfo, "net.minecraft.network.chat.Component": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator$Variant": Internal.ClassInfo, "dev.latvian.mods.kubejs.generator.AssetJsonGenerator": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickEmpty": Internal.ClassInfo, "com.mangomilk.design_decor.blocks.railings.RailingBlockItem": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumAshesExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "com.tom.storagemod.block.FramedInventoryCableBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.TubeWormBlock$TubeShape": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingWoodBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.util.NameTransformer": Internal.ClassInfo, "net.minecraft.world.level.entity.PersistentEntitySectionManager": Internal.ClassInfo, "com.simibubi.create.foundation.fluid.CombinedTankWrapper": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDustyArmorBlockBlock": Internal.ClassInfo, "com.mojang.brigadier.exceptions.CommandSyntaxException": Internal.ClassInfo, "net.mcreator.cbccw.world.features.ores.BauxiteOreFeature": Internal.ClassInfo, "net.satisfy.brewery.block.CornCropBlock": Internal.ClassInfo, "net.mcreator.crustychunks.block.EnergyDistributionNodeBlock": Internal.ClassInfo, "net.minecraft.util.valueproviders.SampledFloat": Internal.ClassInfo, "org.valkyrienskies.tournament.TournamentBlocks$register$16$1": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.lights.LightBulbBlock": Internal.ClassInfo, "com.railwayteam.railways.content.switches.TrackSwitchBlock$SwitchState": Internal.ClassInfo, "com.dsvv.cbcat.cannon.twin_autocannon.TwinAutocannonBaseBlock": Internal.ClassInfo, "net.minecraft.client.OptionInstance$CycleableValueSet$ValueSetter": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedAdjustableDoubleBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopeslab.FramedInverseDoubleSlopeSlabBlock": Internal.ClassInfo, "com.railwayteam.railways.mixin.client.AccessorLivingEntityRenderer": Internal.ClassInfo, "me.dantaeusb.zetter.event.CanvasRegisterEvent$Post": Internal.ClassInfo, "com.petrolpark.network.RegisterPetrolparkMessagesEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.MonsterRoomFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.AndRecipeComponent": Internal.ClassInfo, "xaero.hud.pushbox.PushboxHandler$State": Internal.ClassInfo, "com.simibubi.create.content.equipment.bell.PeculiarBellBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeSpecialEffects$Builder": Internal.ClassInfo, "com.hlysine.create_connected.mixin.sequencedgearshift.InstructionAccessor": Internal.ClassInfo, "org.lwjgl.system.CustomBuffer": Internal.ClassInfo, "com.mojang.authlib.UserAuthentication": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$3": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$4": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$1": Internal.ClassInfo, "appeng.hooks.AEToolItem": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$2": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions": Internal.ClassInfo, "net.mcreator.sarosroadsignsmod.block.RechtslinksBlock": Internal.ClassInfo, "tcintegrations.data.integration.ModIntegration$OxygenEffect": Internal.ClassInfo, "com.simibubi.create.foundation.render.SuperRenderTypeBuffer": Internal.ClassInfo, "com.google.common.collect.ImmutableBiMap": Internal.ClassInfo, "net.minecraft.network.chat.ClickEvent$Action": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumFoggyEletromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "dev.ithundxr.createnumismatics.mixin.AccessorSimpleContainer": Internal.ClassInfo, "com.dsvv.cbcat.cartridge.FuzedProjectileCartridgeBlockItem": Internal.ClassInfo, "com.atsuishio.superbwarfare.data.gun.subdata.Bolt": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.CopyNameFunction$NameSource": Internal.ClassInfo, "com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour$OccupiedPredicate": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2ObjectFunction": Internal.ClassInfo, "org.apache.logging.log4j.ThreadContext$ContextStack": Internal.ClassInfo, "com.railwayteam.railways.mixin_interfaces.IHandcarTrain": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.CeramicTankHatchBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.screen.PaintScreenEventJS": Internal.ClassInfo, "net.mcreator.crustychunks.block.RustyBlockBlock": Internal.ClassInfo, "dzwdz.chat_heads.mixininterface.HeadRenderable": Internal.ClassInfo, "net.minecraft.world.item.FireworkRocketItem": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.autocannon.breech.AbstractAutocannonBreechBlockEntity": Internal.ClassInfo, "java.util.function.IntUnaryOperator": Internal.ClassInfo, "vazkii.patchouli.mixin.client.AccessorKeyMapping": Internal.ClassInfo, "com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock": Internal.ClassInfo, "appeng.api.implementations.menuobjects.IMenuItem": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.ChocolateBlock": Internal.ClassInfo, "com.simibubi.create.content.kinetics.transmission.sequencer.Instruction": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2ByteFunction": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumDesertReinforcedCageArmorBlock": Internal.ClassInfo, "plus.dragons.createenchantmentindustry.entry.CeiRecipeTypes$1": Internal.ClassInfo, "team.creative.creativecore.common.gui.event.GuiControlClickEvent": Internal.ClassInfo, "com.fasterxml.jackson.databind.type.MapLikeType": Internal.ClassInfo, "com.fasterxml.jackson.databind.type.MapType": Internal.ClassInfo, "slimeknights.tconstruct.library.recipe.material.ShapedMaterialRecipe$Serializer": Internal.ClassInfo, "net.mcreator.crustychunks.block.ActiveRobotChuteBlock": Internal.ClassInfo, "org.apache.commons.math3.FieldElement": Internal.ClassInfo, "org.valkyrienskies.core.api.ships.ContraptionWingProvider": Internal.ClassInfo, "me.jellysquid.mods.lithium.api.inventory.LithiumDefaultedList": Internal.ClassInfo, "java.io.Serializable": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2FloatFunction": Internal.ClassInfo, "net.mcreator.cbccw.fluid.VinegarFluid": Internal.ClassInfo, "net.minecraftforge.client.textures.ITextureAtlasSpriteLoader": Internal.ClassInfo, "com.fasterxml.jackson.databind.PropertyNamingStrategy$PropertyNamingStrategyBase": Internal.ClassInfo, "com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder": Internal.ClassInfo, "com.simibubi.create.content.contraptions.chassis.ChassisBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootParams$Builder": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedLargeInnerCornerSlopePanelBlock": Internal.ClassInfo, "com.fasterxml.jackson.annotation.JsonIgnoreProperties": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedDoublePrismCornerBlock": Internal.ClassInfo, "net.minecraft.world.inventory.AbstractContainerMenu": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.Behavior$Status": Internal.ClassInfo, "java.util.function.Supplier": Internal.ClassInfo, "com.simibubi.create.content.logistics.chute.SmartChuteBlock": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.CanisterBlock": Internal.ClassInfo, "xaero.hud.controls.ControlsRegister": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeFluidState": Internal.ClassInfo, "org.apache.logging.log4j.core.jmx.RingBufferAdmin": Internal.ClassInfo, "net.mcreator.sab.block.EightBlock": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.FillInBubblesWithWaterFeature": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.XRayLetterBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Init$Post": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.explosive.AbstractExplosiveBlock": Internal.ClassInfo, "com.tacz.guns.api.item.builder.AttachmentItemBuilder": Internal.ClassInfo, "com.simibubi.create.content.schematics.cannon.MaterialChecklist": Internal.ClassInfo, "com.supermartijn642.core.gui.BaseContainerType": Internal.ClassInfo, "net.minecraftforge.server.permission.nodes.PermissionType": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.BlockComponent": Internal.ClassInfo, "dan200.computercraft.shared.command.arguments.RepeatArgumentType": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntSet": Internal.ClassInfo, "net.mcreator.sab.block.MagentadoublesteelblockBlock": Internal.ClassInfo, "com.almostreliable.unified.config.Config$Serializer": Internal.ClassInfo, "org.apache.commons.lang3.mutable.MutableInt": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingUseTotemEvent": Internal.ClassInfo, "net.minecraft.client.gui.font.glyphs.BakedGlyph": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntScaffoldingBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockKeyButton": Internal.ClassInfo, "com.tacz.guns.block.TargetBlock": Internal.ClassInfo, "net.minecraft.nbt.IntTag": Internal.ClassInfo, "dev.architectury.hooks.level.biome.GenerationProperties": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement": Internal.ClassInfo, "xfacthd.framedblocks.common.block.torch.FramedTorchBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.cable_blocks.DiagonalCableBlock": Internal.ClassInfo, "net.mcreator.cbccw.item.HydrogenSulfiteItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.CarvingMaskPlacement": Internal.ClassInfo, "net.mcreator.sab.block.PuritysealtrioBlock": Internal.ClassInfo, "com.simibubi.create.content.decoration.encasing.EncasedBlock": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingJungleLeavesBlock": Internal.ClassInfo, "net.minecraft.core.Direction8": Internal.ClassInfo, "net.satisfy.vinery.core.effect.ArmorEffect": Internal.ClassInfo, "io.netty.buffer.AbstractByteBufAllocator": Internal.ClassInfo, "java.util.function.DoubleToIntFunction": Internal.ClassInfo, "rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonProjectileBlockEntity": Internal.ClassInfo, "dan200.computercraft.api.turtle.ITurtleUpgrade": Internal.ClassInfo, "dan200.computercraft.shared.recipe.CustomShapelessRecipe$Serialiser": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ScatteredOreFeature": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.FileNotFoundAction": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slope.FramedThreewayCornerBlock": Internal.ClassInfo, "com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle0100BogeyBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.display.GlobalTrainDisplayData$TrainDeparturePrediction": Internal.ClassInfo, "com.copycatsplus.copycats.foundation.copycat.ICustomCTBlocking": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumACBarrelYellowBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.VerticalAnchor": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController$State": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.MushroomColonyBlock": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$ValidateCallback": Internal.ClassInfo, "com.tacz.guns.resource.pojo.data.attachment.MeleeData": Internal.ClassInfo, "net.mcreator.crustychunks.block.FuelRods4Block": Internal.ClassInfo, "com.github.talrey.createdeco.blocks.ShippingContainerBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.signal.SignalBlock": Internal.ClassInfo, "com.google.gson.FieldNamingPolicy": Internal.ClassInfo, "net.mcreator.cbccw.fluid.types.HydrogenPeroxideFluidType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage": Internal.ClassInfo, "net.mcreator.crustychunks.block.BlockMinerBlock": Internal.ClassInfo, "net.mcreator.crustychunks.fluid.PetroliumFluid$Source": Internal.ClassInfo, "rbasamoyai.createbigcannons.crafting.incomplete.IncompleteBigCannonBlockEntity": Internal.ClassInfo, "java.io.PrintStream": Internal.ClassInfo, "dev.shadowsoffire.placebo.mixin.AbstractContainerMenuInvoker": Internal.ClassInfo, "com.github.alexthe666.citadel.server.tick.modifier.TickRateModifier": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemEntityInteractedEventJS": Internal.ClassInfo, "net.pixelbank.burnt.block.SmolderingCactusBlock": Internal.ClassInfo, "com.mojang.blaze3d.vertex.Tesselator": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelPurityPressurizedReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.AbstractHorse": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.feature.TeslaBulbFeature": Internal.ClassInfo, "net.mcreator.cbccw.fluid.ChlorineFluid$Source": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelMuddyExplosiveReactiveArmorBlockBlock": Internal.ClassInfo, "team.creative.creativecore.common.gui.manager.GuiManagerItem": Internal.ClassInfo, "slimeknights.tconstruct.tables.block.RetexturedTableBlock": Internal.ClassInfo, "com.simibubi.create.content.trains.graph.TrackGraphBounds": Internal.ClassInfo, "net.minecraftforge.registries.MissingMappingsEvent": Internal.ClassInfo, "dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfig": Internal.ClassInfo, "net.minecraft.core.Direction$AxisDirection": Internal.ClassInfo, "org.valkyrienskies.eureka.block.AnchorBlock": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.OilBarrelBlock$OilBarrelColor": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.AllOfCondition$Builder": Internal.ClassInfo, "xaero.hud.minimap.waypoint.DestinationHandler": Internal.ClassInfo, "net.mcreator.crustychunks.block.BreederReactorInterfaceBlock": Internal.ClassInfo, "com.tacz.guns.compat.kubejs.events.TimelessForgeEventWrappers$GunFireSelectWrapper": Internal.ClassInfo, "mezz.jei.api.runtime.IEditModeConfig$HideMode": Internal.ClassInfo, "net.geforcemods.securitycraft.items.KeycardHolderItem": Internal.ClassInfo, "net.minecraft.world.level.material.EmptyFluid": Internal.ClassInfo, "com.atsuishio.superbwarfare.api.event.PreKillEvent$SendKillMessage": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SunflowerArmorBlockBlock": Internal.ClassInfo, "corgitaco.corgilib.world.level.RandomTickScheduler": Internal.ClassInfo, "com.hlysine.create_connected.content.brake.BrakeBlock": Internal.ClassInfo, "net.mcreator.sab.block.VBlock": Internal.ClassInfo, "net.minecraft.world.item.trading.Merchant": Internal.ClassInfo, "net.satisfy.vinery.core.block.StemBlock": Internal.ClassInfo, "net.minecraft.world.entity.TraceableEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumForestArmorBlockBlock": Internal.ClassInfo, "com.axperty.storagedelight.block.DrawerDoorBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2CharFunction": Internal.ClassInfo, "net.minecraft.world.level.block.GrassBlock": Internal.ClassInfo, "com.nukateam.ntgl.modules.enchantment.enchantments.AcceleratorEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest": Internal.ClassInfo, "slimeknights.tconstruct.common.TinkerEffect": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopepanelcorner.FramedStackedCornerSlopePanelBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Finish": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingDarkGrayBlock": Internal.ClassInfo, "appeng.blockentity.misc.PaintSplotchesBlockEntity": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelCaramelFortifiedArmorBlockBlock": Internal.ClassInfo, "java.util.jar.Attributes$Name": Internal.ClassInfo, "net.minecraft.world.level.gameevent.PositionSource": Internal.ClassInfo, "java.lang.invoke.VarHandle": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumOvergrownEletromagneticReactiveArmorBlockBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.machines.metal_processing.blast_furnace.BlastFurnaceOutputBlockEntity$BlastFurnaceType": Internal.ClassInfo, "net.mcreator.sab.block.OrangesteelblockBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.ser.BeanPropertyFilter": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.logical.LogicalJet": Internal.ClassInfo, "com.simibubi.create.content.trains.station.StationMapData": Internal.ClassInfo, "net.mcreator.valkyrienwarium.block.ToggleTriggerOnBlock": Internal.ClassInfo, "net.minecraft.client.renderer.entity.RenderLayerParent": Internal.ClassInfo, "com.codinglitch.simpleradio.api.central.Speaking": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingPurpleBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.InSquarePlacement": Internal.ClassInfo, "net.minecraft.world.item.ScaffoldingBlockItem": Internal.ClassInfo, "net.minecraft.world.entity.LivingEntity$Fallsounds": Internal.ClassInfo, "appeng.api.networking.crafting.ICraftingPlan": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.VillagerTypeBuilder": Internal.ClassInfo, "appeng.api.config.Actionable": Internal.ClassInfo, "net.mcreator.sab.block.Steelblockcolored33Block": Internal.ClassInfo, "net.mcreator.crustychunks.block.WireFenceBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slopeedge.FramedElevatedSlopeEdgeBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LootingLevelEvent": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DecoratedPotBlockEntity$Decorations": Internal.ClassInfo, "net.geforcemods.securitycraft.api.IDisguisable": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonReleased$Pre": Internal.ClassInfo, "net.mcreator.cbccw.fluid.PseudoephedrineFluid$Flowing": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatIterable": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent$RegisterRenderers": Internal.ClassInfo, "java.security.Principal": Internal.ClassInfo, "com.verr1.controlcraft.content.links.scope.OscilloscopeBlock": Internal.ClassInfo, "com.blamejared.crafttweaker.mixin.common.access.food.AccessFoodProperties": Internal.ClassInfo, "com.fasterxml.jackson.databind.JsonMappingException": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.TerrainAdjustment": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType": Internal.ClassInfo, "com.dsvv.cbcat.cannon.autocannon.munitions.apdsfs.APDSFSProjectileItem": Internal.ClassInfo, "net.minecraft.world.effect.InstantenousMobEffect": Internal.ClassInfo, "net.mcreator.crustychunks.block.AluminumPlatingSlabDarkGrayBlock": Internal.ClassInfo, "xfacthd.framedblocks.common.block.stairs.FramedVerticalDoubleStairsBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.RawAluminumBlockBlock": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.SteelWoodsCompositeReactiveArmorBlockBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.Sensing": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumSunflowerReinforcedArmorBlockBlock": Internal.ClassInfo, "net.minecraft.client.particle.ParticleEngine$SpriteParticleRegistration": Internal.ClassInfo, "net.satisfy.brewery.effect.PintCharismaEffect": Internal.ClassInfo, "net.mcreator.sab.block.UltramarBlock": Internal.ClassInfo, "java.util.concurrent.TimeUnit": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.IngredientSupplierKJS": Internal.ClassInfo, "net.minecraft.client.color.block.BlockColors": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferVertexConsumer": Internal.ClassInfo, "net.minecraft.world.entity.EntityType$Builder": Internal.ClassInfo, "net.mcreator.crustychunks.block.PurpleArmorTrapdoorBlock": Internal.ClassInfo, "com.jesz.createdieselgenerators.blocks.entity.BasinLidBlockEntity": Internal.ClassInfo, "xaero.common.server.level.LevelMapProperties": Internal.ClassInfo, "com.possible_triangle.sliceanddice.mixins.RecipeManagerAccessor": Internal.ClassInfo, "xfacthd.framedblocks.common.block.slab.FramedCheckeredSlabSegmentBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate$StructureEntityInfo": Internal.ClassInfo, "net.mcreator.cbccw.block.PseudoephedrineBlock": Internal.ClassInfo, "com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour": Internal.ClassInfo, "xaero.map.server.MinecraftServerData": Internal.ClassInfo, "net.pixelbank.burnt.block.BurntOakTrapdoorBlock": Internal.ClassInfo, "rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBaseBlock": Internal.ClassInfo, "com.drmangotea.tfmg.blocks.electricity.energy_components.transistor.TransistorBlockEntity": Internal.ClassInfo, "de.maxhenkel.voicechat.api.packets.EntitySoundPacket$Builder": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Tick": Internal.ClassInfo, "java.nio.channels.spi.AbstractInterruptibleChannel": Internal.ClassInfo, "com.ordana.spelunkery.items.HammerAndChiselItem": Internal.ClassInfo, "com.verr1.controlcraft.foundation.data.logical.LogicalFlap": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationContext$DimensionsUpdater": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ItemKJS": Internal.ClassInfo, "net.mcreator.createtankdefenses.block.TitaniumCellReinforcedBlastGlassBlock": Internal.ClassInfo, "org.apache.logging.log4j.util.StringBuilderFormattable": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.AbstractMinecart$Type": Internal.ClassInfo, "xaero.pac.common.claims.result.api.AreaClaimResult": Internal.ClassInfo, "org.valkyrienskies.tournament.blocks.explosive.SimpleExplosiveStagedBlock": Internal.ClassInfo, "appeng.api.networking.crafting.CraftingSubmitErrorCode": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.block.DinosaurEggBlock": Internal.ClassInfo, "com.fasterxml.jackson.databind.node.JsonNodeCreator": Internal.ClassInfo, "com.tacz.guns.mixin.client.StairBlockAccessor": Internal.ClassInfo, "com.verr1.controlcraft.content.links.ff.FFBlock": Internal.ClassInfo, "com.happysg.radar.block.radar.receiver.RadarReceiverBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundUseItemPacket": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket": Internal.ClassInfo, "com.petrolpark.contamination.IItemStackDuck": Internal.ClassInfo, "com.github.alexmodguy.alexscaves.server.level.structure.OceanTrenchStructure": Internal.C