/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    south(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    above(): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    offset(arg0: Vec3i_): this;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    getY(): number;
    static getY(arg0: number): number;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    toShortString(): string;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    notify(): void;
    static "betweenClosedStream(net.minecraft.world.level.levelgen.structure.BoundingBox)"(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    compareTo(arg0: any): number;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    multiply(arg0: number): Vec3i;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): Vec3i;
    south(distance: number): this;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    east(): Vec3i;
    west(): Vec3i;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    relative(arg0: Internal.Direction$Axis_, arg1: number): Vec3i;
    relative(arg0: Internal.Direction_): this;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): Vec3i;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    wait(): void;
    static containing(arg0: Internal.Position_): BlockPos;
    cross(arg0: Vec3i_): this;
    east(distance: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    above(distance: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    below(): this;
    static getX(arg0: number): number;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    atY(arg0: number): this;
    north(distance: number): this;
    west(arg0: number): Vec3i;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): Vec3i;
    rotate(arg0: Internal.Rotation_): this;
    static "betweenClosedStream(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    getZ(): number;
    north(): this;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    toString(): string;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    get(arg0: Internal.Direction$Axis_): number;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    hashCode(): number;
    relative(arg0: Internal.Direction_, arg1: number): Vec3i;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): Vec3i;
    get y(): number
    get center(): Vec3d
    get class(): typeof any
    get x(): number
    get z(): number
    static readonly PACKED_Y_LENGTH: (12) & (number);
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: (BlockPos) & (BlockPos);
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    notify(): void;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    wait(arg0: number, arg1: number): void;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    hashCode(): number;
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    equals(arg0: any): boolean;
    get class(): typeof any
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    lengthSqr(): number;
    distanceToSqr(arg0: Vec3d_): number;
    notify(): void;
    yRot(arg0: number): this;
    z(): number;
    xRot(arg0: number): this;
    x(): number;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    reverse(): this;
    scale(arg0: number): this;
    wait(): void;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    zRot(arg0: number): this;
    subtract(arg0: number, arg1: number, arg2: number): this;
    normalize(): this;
    lerp(arg0: Vec3d_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    horizontalDistance(): number;
    getClass(): typeof any;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    cross(arg0: Vec3d_): this;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    add(arg0: Vec3d_): this;
    wait(arg0: number, arg1: number): void;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    vectorTo(arg0: Vec3d_): this;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    toString(): string;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    notifyAll(): void;
    static fromRGB24(arg0: number): Vec3d;
    distanceTo(arg0: Vec3d_): number;
    multiply(arg0: Vec3d_): this;
    hashCode(): number;
    toVector3f(): Vec3f;
    wait(arg0: number): void;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    equals(arg0: any): boolean;
    get class(): typeof any
    readonly z: number;
    static readonly ZERO: (Vec3d) & (Vec3d);
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static valueOf(name: string): RotationAxis;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    name(): string;
    static values(): RotationAxis[];
    hashCode(): number;
    rad(f: number): Quaternionf;
    getDeclaringClass(): typeof RotationAxis;
    ordinal(): number;
    wait(): void;
    "compareTo(dev.latvian.mods.kubejs.util.RotationAxis)"(arg0: RotationAxis_): number;
    wait(arg0: number): void;
    compareTo(arg0: RotationAxis_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<RotationAxis>>;
    get class(): typeof any
    get declaringClass(): typeof RotationAxis
    static readonly XN: (RotationAxis) & (RotationAxis);
    static readonly ZP: (RotationAxis) & (RotationAxis);
    static readonly YN: (RotationAxis) & (RotationAxis);
    static readonly XP: (RotationAxis) & (RotationAxis);
    static readonly YP: (RotationAxis) & (RotationAxis);
    static readonly ZN: (RotationAxis) & (RotationAxis);
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class Stats {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly SWIM_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FLY_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly TOTAL_WORLD_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly TUNE_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BREWINGSTAND: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CAMPFIRE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DISPENSER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_ENDERCHEST: (ResourceLocation) & (ResourceLocation);
    static readonly ANIMALS_BRED: (ResourceLocation) & (ResourceLocation);
    static readonly POT_FLOWER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_STONECUTTER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly FISH_CAUGHT: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_ANVIL: (ResourceLocation) & (ResourceLocation);
    static readonly BOAT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_RECORD: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_WIN: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT: (ResourceLocation) & (ResourceLocation);
    static readonly DEATHS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMOKER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMITHING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DROPPER: (ResourceLocation) & (ResourceLocation);
    static readonly DROP: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LECTERN: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLIMB_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TRADED_WITH_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_TRIGGER: (ResourceLocation) & (ResourceLocation);
    static readonly STRIDER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BEACON: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_HOPPER: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly JUMP: (ResourceLocation) & (ResourceLocation);
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly MOB_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly SLEEP_IN_BED: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_ARMOR: (ResourceLocation) & (ResourceLocation);
    static readonly CROUCH_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TALKED_TO_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LOOM: (ResourceLocation) & (ResourceLocation);
    static readonly LEAVE_GAME: (ResourceLocation) & (ResourceLocation);
    static readonly HORSE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ON_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly MINECART_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ENCHANT_ITEM: (ResourceLocation) & (ResourceLocation);
    static readonly TIME_SINCE_DEATH: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_TAKEN: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BLAST_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly TRIGGER_TRAPPED_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_GRINDSTONE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_BARREL: (ResourceLocation) & (ResourceLocation);
    static readonly SPRINT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_BLOCKED_BY_SHIELD: (ResourceLocation) & (ResourceLocation);
    static readonly EAT_CAKE_SLICE: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CRAFTING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_BANNER: (ResourceLocation) & (ResourceLocation);
    static readonly TARGET_HIT: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PIG_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly USE_CAULDRON: (ResourceLocation) & (ResourceLocation);
    static readonly AVIATE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FILL_CAULDRON: (ResourceLocation) & (ResourceLocation);
}
type Stats_ = Stats;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    getClass(): typeof any;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    toString(): string;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,net.minecraft.nbt.CompoundTag)"(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    notifyAll(): void;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,int)"(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    wait(): void;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    wait(arg0: number): void;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    equals(arg0: any): boolean;
    static water(): Internal.FluidStackJS;
    get class(): typeof any
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: (ResourceLocation) & (ResourceLocation);
    static readonly WATER_ID: (ResourceLocation) & (ResourceLocation);
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    isEmpty(): boolean;
    notify(): void;
    toJson(): Internal.JsonElement;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    static of(o: InputItem_): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    validForMatching(): boolean;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    hashCode(): number;
    unwrap(): Internal.List<InputItem>;
    wait(): void;
    wait(arg0: number): void;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    equals(arg0: any): boolean;
    kjs$asIngredient(): Internal.Ingredient;
    get class(): typeof any
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: (InputItem) & (InputItem);
    static readonly PARSE_CACHE: ({}) & (Internal.Map<string, InputItem>);
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare interface Color {
    of(o: any): Internal.Color;
    rgba(r: number, g: number, b: number, a: number): Internal.Color;
    createMapped(o: any, ...names: string[]): Internal.Color;
    readonly DARK_PURPLE: (Internal.ChatFormatting) & (Internal.Color);
    readonly YELLOW: (Internal.ChatFormatting) & (Internal.Color);
    readonly CYAN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly GRAY: (Internal.ChatFormatting) & (Internal.Color);
    readonly BROWN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIGHT_PURPLE: (Internal.ChatFormatting) & (Internal.Color);
    readonly PURPLE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DARK_AQUA: (Internal.ChatFormatting) & (Internal.Color);
    readonly GREEN: (Internal.ChatFormatting) & (Internal.Color);
    readonly LIGHT_GRAY_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly WHITE: (Internal.ChatFormatting) & (Internal.Color);
    readonly MAGENTA_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly RED: (Internal.ChatFormatting) & (Internal.Color);
    readonly BLACK_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly TEXT: ({"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting}) & (Internal.Map<string, Internal.ChatFormatting>);
    readonly RED_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly GRAY_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DARK_GRAY: (Internal.ChatFormatting) & (Internal.Color);
    readonly NONE: (Internal.NoColor) & (Internal.Color);
    readonly ORANGE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly WHITE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DYE: ({"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor}) & (Internal.Map<string, Internal.DyeColor>);
    readonly BLACK: (Internal.ChatFormatting) & (Internal.Color);
    readonly BLUE: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_GREEN: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_RED: (Internal.ChatFormatting) & (Internal.Color);
    readonly GOLD: (Internal.ChatFormatting) & (Internal.Color);
    readonly MAP: ({"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting}) & (Internal.Map<string, Internal.Color>);
    readonly GREEN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIGHT_BLUE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly AQUA: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_BLUE: (Internal.ChatFormatting) & (Internal.Color);
    readonly PINK_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly BLUE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly YELLOW_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIME_DYE: (Internal.DyeColor) & (Internal.Color);
}
type Color_ = Color;
declare const Color: Color;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    getClass(): typeof any;
    abstract doubleValue(): number;
    toString(): string;
    abstract floatValue(): number;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    shortValue(): number;
    hashCode(): number;
    abstract intValue(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    byteValue(): number;
    get class(): typeof any
}
type number_ = number;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    getClass(): typeof any;
    write(buf: Internal.FriendlyByteBuf_): void;
    toString(): string;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    notifyAll(): void;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    setAtlasIcon(icon: string): void;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    setItemIcon(stack: Internal.ItemStack_): void;
    get class(): typeof any
    set icon(icon: string)
    set atlasIcon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: (Duration) & (Duration);
    backgroundColor: Internal.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: (Internal.SimpleColor) & (Internal.Color);
    static readonly DEFAULT_BORDER_COLOR: (Internal.SimpleColor) & (Internal.Color);
    borderColor: Internal.Color;
    text: Internal.Component;
    outlineColor: Internal.Color;
    textShadow: boolean;
    static readonly NO_TEXT: Internal.Component[];
}
type Notification_ = Notification;
declare class BlockProperties {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly LEVEL_FLOWING: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly PERSISTENT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly NOTE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AGE_5: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EGGS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_RECORD: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOTTLE_2: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LAYERS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CONDITIONAL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LOCKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly POWER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EYE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: (1) & (number);
    static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_LEVEL_15: (15) & (number);
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: (7) & (number);
    static readonly FLOWER_AMOUNT: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EXTENDED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly INVERTED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: (8) & (number);
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: (0) & (number);
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ENABLED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly UNSTABLE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_4: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: (4) & (number);
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: (7) & (number);
    static readonly DOWN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_15: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BLOOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHRIEKING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_1: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly FACING_HOPPER: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly VERTICAL_DIRECTION: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly PICKLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_25: (25) & (number);
    static readonly LEVEL_HONEY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DUSTED: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_4: (4) & (number);
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SNOWY: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SIGNAL_FIRE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL_CAULDRON: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DRAG: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CAN_SUMMON: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_5: (5) & (number);
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BITES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly IN_WALL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_25: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STABILITY_MAX_DISTANCE: (7) & (number);
    static readonly HAS_BOTTLE_1: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_7: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_15: (15) & (number);
    static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DELAY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MIN_LEVEL: (0) & (number);
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: (1) & (number);
    static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOOK: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CANDLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHORT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BERRIES: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_2: (2) & (number);
    static readonly HAS_BOTTLE_0: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_LEVEL_3: (3) & (number);
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_3: (3) & (number);
    static readonly OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
}
type BlockProperties_ = BlockProperties;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    getY(): number;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    notify(): void;
    west(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    above(): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    toString(): string;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    east(): this;
    north(arg0: number): this;
    below(): this;
    notifyAll(): void;
    west(): this;
    distManhattan(arg0: Vec3i_): number;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    hashCode(): number;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    wait(): void;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get class(): typeof any
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: (Vec3i) & (Vec3i);
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare class KMath {
    constructor()
    getClass(): typeof any;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static map(value: number, min0: number, max0: number, min1: number, max1: number): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static rad(value: number): number;
    static degreesDifference(current: number, target: number): number;
    static floor(value: number): number;
    static lerp(value: number, min: number, max: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    toString(): string;
    notifyAll(): void;
    static m4f(): Matrix4f;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    hashCode(): number;
    static wrapDegrees(d: number): number;
    static m3f(): Matrix3f;
    wait(): void;
    static approachDegrees(current: number, target: number, speed: number): number;
    static clampedLerp(value: number, min: number, max: number): number;
    wait(arg0: number): void;
    static approach(current: number, target: number, speed: number): number;
    equals(arg0: any): boolean;
    static isPowerOfTwo(value: number): boolean;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly RADIANS_TO_DEGREES: (57.29577951308232) & (number);
    static readonly DEGREES_TO_RADIANS: (0.017453292519943295) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type KMath_ = KMath;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    getVolume(): number;
    hashCode(): number;
    getPitch(): number;
    wait(): void;
    wait(arg0: number): void;
    getBreakSound(): Internal.SoundEvent;
    equals(arg0: any): boolean;
    get class(): typeof any
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    get volume(): number
    get pitch(): number
    get breakSound(): Internal.SoundEvent
    static readonly EMPTY: (SoundType) & (SoundType);
    static readonly SAND: (SoundType) & (SoundType);
    static readonly DECORATED_POT: (SoundType) & (SoundType);
    static readonly TUFF: (SoundType) & (SoundType);
    static readonly GRAVEL: (SoundType) & (SoundType);
    static readonly SHROOMLIGHT: (SoundType) & (SoundType);
    static readonly MOSS: (SoundType) & (SoundType);
    readonly pitch: number;
    static readonly GRASS: (SoundType) & (SoundType);
    static readonly SOUL_SOIL: (SoundType) & (SoundType);
    static readonly WEEPING_VINES: (SoundType) & (SoundType);
    static readonly ANCIENT_DEBRIS: (SoundType) & (SoundType);
    static readonly SCULK_SENSOR: (SoundType) & (SoundType);
    static readonly POINTED_DRIPSTONE: (SoundType) & (SoundType);
    static readonly ROOTED_DIRT: (SoundType) & (SoundType);
    static readonly FROGSPAWN: (SoundType) & (SoundType);
    static readonly NETHER_ORE: (SoundType) & (SoundType);
    static readonly COPPER: (SoundType) & (SoundType);
    static readonly LANTERN: (SoundType) & (SoundType);
    static readonly BONE_BLOCK: (SoundType) & (SoundType);
    static readonly FROGLIGHT: (SoundType) & (SoundType);
    static readonly SNOW: (SoundType) & (SoundType);
    static readonly SCULK_VEIN: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD: (SoundType) & (SoundType);
    static readonly POLISHED_DEEPSLATE: (SoundType) & (SoundType);
    static readonly NYLIUM: (SoundType) & (SoundType);
    static readonly DEEPSLATE: (SoundType) & (SoundType);
    static readonly SPORE_BLOSSOM: (SoundType) & (SoundType);
    static readonly BASALT: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly SMALL_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly CANDLE: (SoundType) & (SoundType);
    static readonly FLOWERING_AZALEA: (SoundType) & (SoundType);
    static readonly ANVIL: (SoundType) & (SoundType);
    static readonly SCAFFOLDING: (SoundType) & (SoundType);
    static readonly DEEPSLATE_BRICKS: (SoundType) & (SoundType);
    static readonly CORAL_BLOCK: (SoundType) & (SoundType);
    static readonly BAMBOO_SAPLING: (SoundType) & (SoundType);
    static readonly LILY_PAD: (SoundType) & (SoundType);
    static readonly MOSS_CARPET: (SoundType) & (SoundType);
    static readonly LADDER: (SoundType) & (SoundType);
    static readonly LARGE_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly GLOW_LICHEN: (SoundType) & (SoundType);
    static readonly CROP: (SoundType) & (SoundType);
    static readonly PINK_PETALS: (SoundType) & (SoundType);
    static readonly AZALEA_LEAVES: (SoundType) & (SoundType);
    static readonly POWDER_SNOW: (SoundType) & (SoundType);
    static readonly METAL: (SoundType) & (SoundType);
    static readonly HONEY_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_BRICKS: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_SAND: (SoundType) & (SoundType);
    static readonly GILDED_BLACKSTONE: (SoundType) & (SoundType);
    static readonly HARD_CROP: (SoundType) & (SoundType);
    static readonly SCULK_CATALYST: (SoundType) & (SoundType);
    static readonly DEEPSLATE_TILES: (SoundType) & (SoundType);
    static readonly PACKED_MUD: (SoundType) & (SoundType);
    static readonly SCULK: (SoundType) & (SoundType);
    static readonly VINE: (SoundType) & (SoundType);
    static readonly BAMBOO: (SoundType) & (SoundType);
    static readonly GLASS: (SoundType) & (SoundType);
    static readonly DRIPSTONE_BLOCK: (SoundType) & (SoundType);
    static readonly CHERRY_SAPLING: (SoundType) & (SoundType);
    static readonly CALCITE: (SoundType) & (SoundType);
    static readonly MUD_BRICKS: (SoundType) & (SoundType);
    static readonly STEM: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD: (SoundType) & (SoundType);
    static readonly SOUL_SAND: (SoundType) & (SoundType);
    static readonly MUD: (SoundType) & (SoundType);
    static readonly BIG_DRIPLEAF: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly TWISTING_VINES: (SoundType) & (SoundType);
    static readonly NETHERRACK: (SoundType) & (SoundType);
    static readonly AMETHYST_CLUSTER: (SoundType) & (SoundType);
    static readonly SLIME_BLOCK: (SoundType) & (SoundType);
    static readonly SCULK_SHRIEKER: (SoundType) & (SoundType);
    static readonly CHAIN: (SoundType) & (SoundType);
    static readonly WOOD: (SoundType) & (SoundType);
    static readonly AZALEA: (SoundType) & (SoundType);
    static readonly MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly CHISELED_BOOKSHELF: (SoundType) & (SoundType);
    static readonly NETHER_GOLD_ORE: (SoundType) & (SoundType);
    static readonly CHERRY_LEAVES: (SoundType) & (SoundType);
    static readonly AMETHYST: (SoundType) & (SoundType);
    static readonly DECORATED_POT_CRACKED: (SoundType) & (SoundType);
    static readonly CAVE_VINES: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_GRAVEL: (SoundType) & (SoundType);
    static readonly LODESTONE: (SoundType) & (SoundType);
    readonly volume: number;
    static readonly FUNGUS: (SoundType) & (SoundType);
    static readonly SMALL_DRIPLEAF: (SoundType) & (SoundType);
    static readonly HANGING_ROOTS: (SoundType) & (SoundType);
    static readonly SWEET_BERRY_BUSH: (SoundType) & (SoundType);
    static readonly NETHER_WOOD: (SoundType) & (SoundType);
    static readonly NETHER_WART: (SoundType) & (SoundType);
    static readonly STONE: (SoundType) & (SoundType);
    static readonly NETHER_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly HANGING_SIGN: (SoundType) & (SoundType);
    static readonly WET_GRASS: (SoundType) & (SoundType);
    static readonly NETHERITE_BLOCK: (SoundType) & (SoundType);
    static readonly MEDIUM_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly MUDDY_MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly WOOL: (SoundType) & (SoundType);
    static readonly ROOTS: (SoundType) & (SoundType);
    static readonly WART_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_SPROUTS: (SoundType) & (SoundType);
}
type SoundType_ = SoundType;
declare class GunProperties {
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly EXPLOSION: Internal.GunProperty<Internal.ExplosionData>;
    static readonly MOVE_SPEED: Internal.GunProperty<Internal.MoveSpeed>;
    static readonly HEADSHOT_MULTIPLIER: Internal.GunProperty<number>;
    static readonly IGNITE: Internal.GunProperty<Internal.Ignite>;
    static readonly KNOCKBACK: Internal.GunProperty<number>;
    static readonly WEIGHT: Internal.GunProperty<number>;
    static readonly ARMOR_IGNORE: Internal.GunProperty<number>;
    /**
     * @deprecated
    */
    static readonly AIM_INACCURACY: Internal.GunProperty<Internal.Map<Internal.InaccuracyType, number>>;
    static readonly RECOIL: Internal.GunProperty<Internal.ParameterizedCachePair<number, number>>;
    static readonly EFFECTIVE_RANGE: Internal.GunProperty<number>;
    static readonly AMMO_SPEED: Internal.GunProperty<number>;
    static readonly SILENCE: Internal.GunProperty<it.unimi.dsi.fastutil.Pair<number, boolean>>;
    static readonly ADS_TIME: Internal.GunProperty<number>;
    static readonly ROUNDS_PER_MINUTE: Internal.GunProperty<number>;
    static readonly PIERCE: Internal.GunProperty<number>;
    static readonly INACCURACY: Internal.GunProperty<Internal.Map<Internal.InaccuracyType, number>>;
    static readonly DAMAGE: Internal.GunProperty<Internal.LinkedList<Internal.ExtraDamage$DistanceDamagePair>>;
}
type GunProperties_ = GunProperties;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    l(v: number): Internal.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    listTag(): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    "toTagCollection(java.util.Collection)"(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    longTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    intTag(v: number): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    la(v: number[]): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    toTag(v: any): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTagCompound(v: any): Internal.CompoundTag;
    toTagList(list: any): Internal.ListTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    i(v: number): Internal.Tag;
    "toTagCollection(java.lang.Object)"(v: any): Internal.CollectionTag<any>;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnYnXZ(arg0: Matrix3f_): this;
    "scale(float)"(arg0: number): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    "get(int,int)"(arg0: number, arg1: number): number;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    getClass(): typeof any;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix3f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnYX(): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    cofactor(arg0: Matrix3f_): this;
    mapnYZnX(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    mapXnZY(arg0: Matrix3f_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnXZY(arg0: Matrix3f_): this;
    "scale(float,org.joml.Matrix3f)"(arg0: number, arg1: Matrix3f_): this;
    wait(arg0: number): void;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYZX(): this;
    mapZnYX(arg0: Matrix3f_): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    m10(): number;
    mapXnZnY(): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateLocalZ(arg0: number): this;
    m22(): number;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    equals(arg0: any): boolean;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    "scaling(float)"(arg0: number): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "reflect(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflect(arg0: Internal.Vector3fc_): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mul(arg0: Internal.Matrix3fc_): this;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    m01(arg0: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    mapnXZY(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m12(arg0: number): this;
    clone(): any;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    "set(int,int,float)"(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    mapnZnXnY(): this;
    "reflection(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    negateX(): this;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    toString(): string;
    mapnZYX(arg0: Matrix3f_): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    "reflect(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    notify(): void;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    "set(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    invert(arg0: Matrix3f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    "reflect(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "set(float[])"(arg0: number[]): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    "reflect(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    wait(arg0: number, arg1: number): void;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    "get(float[])"(arg0: number[]): number[];
    "set(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "reflection(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    hashCode(): number;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapnYXZ(arg0: Matrix3f_): this;
    mapZXY(): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get class(): typeof any
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromAddress(arg0: number)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(float[])"(arg0: number[])
    set "(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    "get4x3(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "perspectiveRect(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRowColumn(arg0: number, arg1: number): number;
    "normalize3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "unprojectInv(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "normal(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "project(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    m32(): number;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "frustumLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "ortho(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get3x3(org.joml.Matrix3d)"(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    "get4x3Transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotation(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector3f)"(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set4x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    mapYZnX(): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.FloatBuffer_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    "getRow(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnZXnY(): this;
    "shadow(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    mapnXZY(): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get4x3Transposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    m12(): number;
    mapnYnZX(arg0: Matrix4f_): this;
    "getColumn(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "orthoSymmetricLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    mapXZY(): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformProject(float,float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    "scaling(float)"(arg0: number): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "get4x3Transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateLocalY(arg0: number): this;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "ortho(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnYXZ(): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    notify(): void;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "reflection(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    cofactor3x3(arg0: Matrix4f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "orthoSymmetric(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m03(): number;
    "get(float[])"(arg0: number[]): number[];
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    cofactor3x3(): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    "setTransposed(float[])"(arg0: number[]): this;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "transformProject(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m23(arg0: number): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "orthoSymmetric(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    "transformProject(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapZYX(): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    mapnXnYnZ(): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "frustum(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYnX(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    mapnYnZX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    get3x3(arg0: Matrix3f_): Matrix3f;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set3x3(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "getColumn(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    mul(arg0: Internal.Matrix4x3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "project(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    "transformProject(float,float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    m03(arg0: number): this;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invert(): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "setTransposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "get4x3Transposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    "set(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    "scale(float,org.joml.Matrix4f)"(arg0: number, arg1: Matrix4f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapYnXnZ(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "invertPerspectiveView(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    mapnYnXnZ(): this;
    identity(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    invert(arg0: Matrix4f_): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix3x2fc,org.joml.Matrix4f)"(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    "unproject(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    toString(): string;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnYnXZ(): this;
    mapnZnXY(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    "perspectiveOffCenter(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    "get3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "invertPerspectiveView(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    "get4x3(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    mapZYnX(arg0: Matrix4f_): this;
    mapZXY(): this;
    "get4x3(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get4x3(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transpose3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "perspective(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    mapnZXY(arg0: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "scale(float)"(arg0: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    mapZXY(arg0: Matrix4f_): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    "getRotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m33(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    normalize3x3(arg0: Matrix4f_): this;
    "frustumLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "shadow(org.joml.Vector4f,float,float,float,float)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    wait(arg0: number): void;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotationTowardsXY(arg0: number, arg1: number): this;
    "normalize3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float,org.joml.Matrix4f)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m33(): number;
    transpose(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    m22(): number;
    m31(arg0: number): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    "unproject(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    equals(arg0: any): boolean;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnZYnX(arg0: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    "cofactor3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m13(arg0: number): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "normal(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    "setTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveRect(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    "perspectiveLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "getRotation(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    "get4x3(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getRow(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    setFromAddress(arg0: number): this;
    m02(arg0: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnYZnX(arg0: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    transpose(): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    "set(float[])"(arg0: number[]): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    "project(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    m22(arg0: number): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    "set4x3(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "reflection(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mapnYZnX(): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m00(arg0: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mapnXnZY(arg0: Matrix4f_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapXZY(arg0: Matrix4f_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    "perspectiveLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    getClass(): typeof any;
    "transformProject(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "set(float[],int)"(arg0: number[], arg1: number): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "shadow(float,float,float,float,org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapYnZX(): this;
    mapnXnYZ(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mapZnXnY(arg0: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "cofactor3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "frustum(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    "setTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    "transpose3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertAffine(): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    "project(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    mapZXnY(arg0: Matrix4f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    notifyAll(): void;
    add4x3(arg0: Internal.Matrix4fc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "orthoSymmetricLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveFar(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaternionfc_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix4f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "perspective(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapXnZnY(arg0: Matrix4f_): this;
    mapYXZ(): this;
    determinant(): number;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    wait(arg0: number, arg1: number): void;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "perspectiveOffCenter(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnXZnY(arg0: Matrix4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    m30(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "transposed(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: Internal.ByteBuffer_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "transposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set "transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set fromAddress(arg0: number)
    set "(float[])"(arg0: number[])
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    get class(): typeof any
    set "transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: (Internal.DustParticleOptions) & (Internal.DustParticleOptions);
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: (Internal.AABB) & (Internal.AABB);
    readonly EMPTY: (Internal.AABB) & (Internal.AABB);
}
type AABB_ = AABB;
declare const AABB: AABB;
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    notify(): void;
    compareTo(arg0: any): number;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    static isAllowedInResourceLocation(arg0: string): boolean;
    static tryParse(arg0: string): ResourceLocation;
    withPath(arg0: string): this;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    static of(arg0: string, arg1: string): ResourceLocation;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    static bySeparator(arg0: string, arg1: string): ResourceLocation;
    static parse(arg0: string): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): this;
    wait(): void;
    static fromNamespaceAndPath(arg0: string, arg1: string): ResourceLocation;
    "compareTo(java.lang.Object)"(arg0: any): number;
    getClass(): typeof any;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    static withDefaultNamespace(arg0: string): ResourceLocation;
    static isValidPath(arg0: string): boolean;
    toShortLanguageKey(): string;
    wait(arg0: number, arg1: number): void;
    setPath(arg0: string): void;
    "withPath(java.lang.String)"(arg0: string): this;
    getPath(): string;
    getNamespace(): string;
    compareNamespaced(arg0: ResourceLocation_): number;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): this;
    notifyAll(): void;
    static tryBySeparator(arg0: string, arg1: string): ResourceLocation;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    wait(arg0: number): void;
    withPrefix(arg0: string): this;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: ("realms") & (string);
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly ERROR_INVALID: (Internal.SimpleCommandExceptionType) & (Internal.SimpleCommandExceptionType);
    static readonly NAMESPACE_SEPARATOR: (":") & (string);
    static readonly DEFAULT_NAMESPACE: ("minecraft") & (string);
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class JsonIO {
    constructor()
    getClass(): typeof any;
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static getJsonHashString(json: Internal.JsonElement_): string;
    notify(): void;
    static toObject(json: Internal.JsonElement_): any;
    wait(arg0: number, arg1: number): void;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    toString(): string;
    notifyAll(): void;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parse(string: string): any;
    static toPrimitive(element: Internal.JsonElement_): any;
    hashCode(): number;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    wait(): void;
    wait(arg0: number): void;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    equals(arg0: any): boolean;
    static of(o: any): Internal.JsonElement;
    get class(): typeof any
}
type JsonIO_ = JsonIO;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
}
type Item_ = Item;
declare const Item: Item;
declare class TimelessItem {
    constructor()
    getClass(): typeof any;
    static ammoItem(arg0: Internal.Item_, arg1: Internal.Consumer_<Internal.AmmoNbtFactory>): Internal.ItemStack;
    toString(): string;
    notifyAll(): void;
    notify(): void;
    static blockItem(arg0: Internal.ItemLike_, arg1: Internal.Consumer_<com.tacz.guns.api.item.builder.BlockItemBuilder>): Internal.ItemStack;
    wait(arg0: number, arg1: number): void;
    static of(arg0: ResourceLocation_): Internal.ItemStack;
    static gunItem(arg0: Internal.Consumer_<Internal.GunNbtFactory>): Internal.ItemStack;
    hashCode(): number;
    static ammoItem(arg0: Internal.Consumer_<Internal.AmmoItemBuilder>): Internal.ItemStack;
    wait(): void;
    wait(arg0: number): void;
    static attachmentItem(arg0: Internal.Item_, arg1: Internal.Consumer_<Internal.AttachmentNbtFactory>): Internal.ItemStack;
    static gunItem(arg0: Internal.Item_, arg1: Internal.Consumer_<Internal.GunNbtFactory>): Internal.ItemStack;
    equals(arg0: any): boolean;
    static of(arg0: Internal.Item_, arg1: ResourceLocation_): Internal.ItemStack;
    static attachmentItem(arg0: Internal.Consumer_<Internal.AttachmentItemBuilder>): Internal.ItemStack;
    get class(): typeof any
}
type TimelessItem_ = TimelessItem;
declare interface Facing {
    readonly south: (Internal.Direction) & (Internal.Direction);
    readonly up: (Internal.Direction) & (Internal.Direction);
    readonly UP: (Internal.Direction) & (Internal.Direction);
    readonly NORTH: (Internal.Direction) & (Internal.Direction);
    readonly east: (Internal.Direction) & (Internal.Direction);
    readonly DOWN: (Internal.Direction) & (Internal.Direction);
    readonly EAST: (Internal.Direction) & (Internal.Direction);
    readonly west: (Internal.Direction) & (Internal.Direction);
    readonly north: (Internal.Direction) & (Internal.Direction);
    readonly down: (Internal.Direction) & (Internal.Direction);
    readonly ALL: ({"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction}) & (Internal.Map<string, Internal.Direction>);
    readonly WEST: (Internal.Direction) & (Internal.Direction);
    readonly SOUTH: (Internal.Direction) & (Internal.Direction);
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    "transform(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    "getAsMatrix3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    "transformUnitPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    "transformUnitPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "get(org.joml.Quaternionf)"(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformInverse(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    getClass(): typeof any;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: Vec4f_): Vec4f;
    "setAngleAxis(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    "transformInverse(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mul(arg0: number): this;
    "transformUnitPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    "transformPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    "setFromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "transformInverseUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalize(arg0: Quaternionf_): this;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mul(arg0: number, arg1: Quaternionf_): this;
    "transformUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformInverse(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    "get(org.joml.Matrix3d)"(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    wait(arg0: number): void;
    "nlerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "transformUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    "nlerpIterative(org.joml.Quaternionfc,float,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transform(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "setFromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "transform(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "mul(float,org.joml.Quaternionf)"(arg0: number, arg1: Quaternionf_): this;
    "transformUnitPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    wait(): void;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    "transformPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "getAsMatrix4f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverse(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    static "nlerpIterative(org.joml.Quaternionf[],float[],float,org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "get(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    "getAsMatrix4f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transformUnitPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    static "nlerp(org.joml.Quaternionfc[],float[],org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    "transformUnitPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    "transformInverse(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "mul(float)"(arg0: number): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    equals(arg0: any): boolean;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    "transformInverseUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "setFromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    "transformInverse(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "setFromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "getAsMatrix4x3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    "transformUnitPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "setAngleAxis(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    "get(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    lengthSquared(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    get(arg0: Quaternionf_): this;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    "transformInverseUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "mul(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "transformUnitPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    static "slerp(org.joml.Quaternionf[],float[],org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    "get(org.joml.Matrix4x3d)"(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transformInverseUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    toString(): string;
    "transformPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    "transformInverse(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "setFromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "slerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transform(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    notify(): void;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    "transformPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "getAsMatrix4x3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    "getAsMatrix3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    "transform(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    angle(): number;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transformInverseUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): Matrix3f;
    "setFromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "transformUnitPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    "transformInverseUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    wait(arg0: number, arg1: number): void;
    "setFromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "mul(org.joml.Quaternionfc,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    "transformUnitPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transform(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    set(arg0: Internal.AxisAngle4d_): this;
    hashCode(): number;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    "transformInverse(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "transform(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    "transformUnitPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    "setFromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "transformUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    get class(): typeof any
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set "fromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set "fromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set "fromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "fromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "fromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set "fromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "fromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set "fromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class Blocks {
    constructor()
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    getClass(): typeof any;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    toString(): string;
    notifyAll(): void;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static rebuildCache(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    static MANGROVE_PROPAGULE: (Internal.MangrovePropaguleBlock) & (Internal.Block);
    static STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POTTED_CRIMSON_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CHERRY_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static POLISHED_ANDESITE: (Internal.Block) & (Internal.Block);
    static RED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static TORCH: (Internal.TorchBlock) & (Internal.Block);
    static COAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static FIRE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static WEEPING_VINES_PLANT: (Internal.WeepingVinesPlantBlock) & (Internal.Block);
    static PEONY: (Internal.TallFlowerBlock) & (Internal.Block);
    static CARROTS: (Internal.CarrotBlock) & (Internal.Block);
    static YELLOW_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static TUBE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static SMITHING_TABLE: (Internal.SmithingTableBlock) & (Internal.Block);
    static ACACIA_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static POTTED_CHERRY_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static PLAYER_WALL_HEAD: (Internal.PlayerWallHeadBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SPRUCE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static TRIPWIRE: (Internal.TripWireBlock) & (Internal.Block);
    static BLACK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static ACACIA_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRIMSON_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static BUBBLE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static PURPLE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static RED_NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SCULK_SENSOR: (Internal.SculkSensorBlock) & (Internal.Block);
    static YELLOW_WOOL: (Internal.Block) & (Internal.Block);
    static MAGENTA_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static SAND: (Internal.SandBlock) & (Internal.Block);
    static MYCELIUM: (Internal.MyceliumBlock) & (Internal.Block);
    static LIGHT_GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static ORANGE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CORNFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static DARK_OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static REDSTONE_LAMP: (Internal.RedstoneLampBlock) & (Internal.Block);
    static LIGHT: (Internal.LightBlock) & (Internal.Block);
    static TUBE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static WARPED_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DANDELION: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WARPED_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static RED_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SOUL_SOIL: (Internal.Block) & (Internal.Block);
    static ACACIA_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static CRIMSON_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static TWISTING_VINES_PLANT: (Internal.TwistingVinesPlantBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RED_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WARPED_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static COARSE_DIRT: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static TUFF: (Internal.Block) & (Internal.Block);
    static CHISELED_BOOKSHELF: (Internal.ChiseledBookShelfBlock) & (Internal.Block);
    static ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHTNING_ROD: (Internal.LightningRodBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LILY_PAD: (Internal.WaterlilyBlock) & (Internal.Block);
    static GREEN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BARRIER: (Internal.BarrierBlock) & (Internal.Block);
    static PINK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static DRAGON_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static YELLOW_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static STRIPPED_BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SEAGRASS: (Internal.SeagrassBlock) & (Internal.Block);
    static CHERRY_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static HORN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static MOSSY_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static WAXED_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRANITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static NETHER_BRICK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MOSS_CARPET: (Internal.CarpetBlock) & (Internal.Block);
    static DARK_OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static MAGENTA_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BAMBOO_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BROWN_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BEETROOTS: (Internal.BeetrootBlock) & (Internal.Block);
    static POTTED_BAMBOO: (Internal.FlowerPotBlock) & (Internal.Block);
    static FERN: (Internal.TallGrassBlock) & (Internal.Block);
    static CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WAXED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static ACACIA_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BLACK_WOOL: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static BRAIN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static VINE: (Internal.VineBlock) & (Internal.Block);
    static CHERRY_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static INFESTED_DEEPSLATE: (Internal.InfestedRotatedPillarBlock) & (Internal.Block);
    static ACACIA_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPONGE: (Internal.SpongeBlock) & (Internal.Block);
    static REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static STRIPPED_ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REDSTONE_WALL_TORCH: (Internal.RedstoneWallTorchBlock) & (Internal.Block);
    static CYAN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BLACK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static OCHRE_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRAGON_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static POTTED_WITHER_ROSE: (Internal.FlowerPotBlock) & (Internal.Block);
    static BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static BAMBOO_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static BIRCH_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static POTTED_CORNFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STICKY_PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static LIGHT_BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RAW_GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LARGE_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static POLISHED_ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_PORTAL: (Internal.NetherPortalBlock) & (Internal.Block);
    static JUNGLE_PLANKS: (Internal.Block) & (Internal.Block);
    static PINK_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POTTED_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DARK_OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static ORANGE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLUE_ORCHID: (Internal.FlowerBlock) & (Internal.Block);
    static STRIPPED_BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static CRIMSON_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static WHITE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static KELP: (Internal.KelpBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static JUNGLE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOSS_BLOCK: (Internal.MossBlock) & (Internal.Block);
    static LIME_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CRIMSON_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CARVED_PUMPKIN: (Internal.EquipableCarvedPumpkinBlock) & (Internal.Block);
    static POTATOES: (Internal.PotatoBlock) & (Internal.Block);
    static PURPUR_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MUD_BRICKS: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static NOTE_BLOCK: (Internal.NoteBlock) & (Internal.Block);
    static ENDER_CHEST: (Internal.EnderChestBlock) & (Internal.Block);
    static CYAN_BED: (Internal.BedBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static BIRCH_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static YELLOW_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LEVER: (Internal.LeverBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_MANGROVE_PROPAGULE: (Internal.FlowerPotBlock) & (Internal.Block);
    static DROPPER: (Internal.DropperBlock) & (Internal.Block);
    static SPRUCE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRAFTING_TABLE: (Internal.CraftingTableBlock) & (Internal.Block);
    static SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GRASS: (Internal.TallGrassBlock) & (Internal.Block);
    static CHERRY_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MEDIUM_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static CRIMSON_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static WITHER_ROSE: (Internal.WitherRoseBlock) & (Internal.Block);
    static OXEYE_DAISY: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static EMERALD_BLOCK: (Internal.Block) & (Internal.Block);
    static BUDDING_AMETHYST: (Internal.BuddingAmethystBlock) & (Internal.Block);
    static RAIL: (Internal.RailBlock) & (Internal.Block);
    static JUNGLE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BROWN_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static DARK_OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LADDER: (Internal.LadderBlock) & (Internal.Block);
    static OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static MELON: (Internal.MelonBlock) & (Internal.Block);
    static CRIMSON_PLANKS: (Internal.Block) & (Internal.Block);
    static GLOW_LICHEN: (Internal.GlowLichenBlock) & (Internal.Block);
    static REDSTONE_WIRE: (Internal.RedStoneWireBlock) & (Internal.Block);
    static HORN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static DARK_PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CAVE_VINES_PLANT: (Internal.CaveVinesPlantBlock) & (Internal.Block);
    static ACACIA_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRIMSON_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_BLUE_ORCHID: (Internal.FlowerPotBlock) & (Internal.Block);
    static CYAN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SCULK_CATALYST: (Internal.SculkCatalystBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DISPENSER: (Internal.DispenserBlock) & (Internal.Block);
    static PRISMARINE_WALL: (Internal.WallBlock) & (Internal.Block);
    static ORANGE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static BLACK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static SPORE_BLOSSOM: (Internal.SporeBlossomBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DEEPSLATE_TILE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static JUNGLE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIRT_PATH: (Internal.DirtPathBlock) & (Internal.Block);
    static BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static HONEYCOMB_BLOCK: (Internal.Block) & (Internal.Block);
    static ICE: (Internal.IceBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POTTED_BIRCH_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static WHITE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WATER: (Internal.LiquidBlock) & (Internal.Block);
    static CRACKED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static WATER_CAULDRON: (Internal.LayeredCauldronBlock) & (Internal.Block);
    static MUD_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_BROWN_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static WARPED_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static JUKEBOX: (Internal.JukeboxBlock) & (Internal.Block);
    static MANGROVE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static PLAYER_HEAD: (Internal.PlayerHeadBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BIRCH_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWDER_SNOW_CAULDRON: (Internal.PowderSnowCauldronBlock) & (Internal.Block);
    static BROWN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BREWING_STAND: (Internal.BrewingStandBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static REDSTONE_TORCH: (Internal.RedstoneTorchBlock) & (Internal.Block);
    static BAMBOO_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static POLISHED_GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static NETHER_SPROUTS: (Internal.NetherSproutsBlock) & (Internal.Block);
    static GREEN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static CONDUIT: (Internal.ConduitBlock) & (Internal.Block);
    static ORANGE_WOOL: (Internal.Block) & (Internal.Block);
    static POTTED_WHITE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static PRISMARINE_BRICKS: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SEA_LANTERN: (Internal.Block) & (Internal.Block);
    static MAGENTA_BED: (Internal.BedBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SCAFFOLDING: (Internal.ScaffoldingBlock) & (Internal.Block);
    static NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PISTON_HEAD: (Internal.PistonHeadBlock) & (Internal.Block);
    static BLACK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static LIME_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static LIME_BED: (Internal.BedBlock) & (Internal.Block);
    static SPAWNER: (Internal.SpawnerBlock) & (Internal.Block);
    static FROSTED_ICE: (Internal.FrostedIceBlock) & (Internal.Block);
    static IRON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static WARPED_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static STONE: (Internal.Block) & (Internal.Block);
    static MUD_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SOUL_LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static COPPER_BLOCK: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static WAXED_OXIDIZED_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POLISHED_BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DAYLIGHT_DETECTOR: (Internal.DaylightDetectorBlock) & (Internal.Block);
    static CRIMSON_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static POTTED_LILY_OF_THE_VALLEY: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static DRIPSTONE_BLOCK: (Internal.Block) & (Internal.Block);
    static COBBLED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static BIG_DRIPLEAF: (Internal.BigDripleafBlock) & (Internal.Block);
    static MANGROVE_LEAVES: (Internal.MangroveLeavesBlock) & (Internal.Block);
    static GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CHERRY_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REPEATING_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static WARPED_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_BED: (Internal.BedBlock) & (Internal.Block);
    static CHERRY_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static POTTED_DANDELION: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_CACTUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DIORITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static HOPPER: (Internal.HopperBlock) & (Internal.Block);
    static SPRUCE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static BARREL: (Internal.BarrelBlock) & (Internal.Block);
    static MELON_STEM: (Internal.StemBlock) & (Internal.Block);
    static ROOTED_DIRT: (Internal.RootedDirtBlock) & (Internal.Block);
    static LIGHT_BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static LAPIS_BLOCK: (Internal.Block) & (Internal.Block);
    static ANDESITE: (Internal.Block) & (Internal.Block);
    static YELLOW_BED: (Internal.BedBlock) & (Internal.Block);
    static END_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLAST_FURNACE: (Internal.BlastFurnaceBlock) & (Internal.Block);
    static SMALL_DRIPLEAF: (Internal.SmallDripleafBlock) & (Internal.Block);
    static KELP_PLANT: (Internal.KelpPlantBlock) & (Internal.Block);
    static RED_SAND: (Internal.SandBlock) & (Internal.Block);
    static JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static QUARTZ_BRICKS: (Internal.Block) & (Internal.Block);
    static CRIMSON_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ZOMBIE_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static LIME_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static RAW_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static CHERRY_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ORANGE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LOOM: (Internal.LoomBlock) & (Internal.Block);
    static GREEN_WOOL: (Internal.Block) & (Internal.Block);
    static BROWN_WOOL: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static PIGLIN_WALL_HEAD: (Internal.PiglinWallSkullBlock) & (Internal.Block);
    static BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static PINK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SMOKER: (Internal.SmokerBlock) & (Internal.Block);
    static ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static BROWN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static FLOWER_POT: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONECUTTER: (Internal.StonecutterBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CONCRETE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BAMBOO: (Internal.BambooStalkBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static DARK_OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DARK_OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static CHISELED_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static CRIMSON_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static PITCHER_CROP: (Internal.PitcherCropBlock) & (Internal.Block);
    static CHERRY_LEAVES: (Internal.CherryLeavesBlock) & (Internal.Block);
    static RED_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static QUARTZ_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static RED_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static AMETHYST_CLUSTER: (Internal.AmethystClusterBlock) & (Internal.Block);
    static DARK_PRISMARINE: (Internal.Block) & (Internal.Block);
    static MANGROVE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SCULK_VEIN: (Internal.SculkVeinBlock) & (Internal.Block);
    static JUNGLE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static YELLOW_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static OBSERVER: (Internal.ObserverBlock) & (Internal.Block);
    static END_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SPRUCE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static MANGROVE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BAMBOO_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static NETHER_WART: (Internal.NetherWartBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static OBSIDIAN: (Internal.Block) & (Internal.Block);
    static PURPLE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLACK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REINFORCED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static DRAGON_EGG: (Internal.DragonEggBlock) & (Internal.Block);
    static PACKED_MUD: (Internal.Block) & (Internal.Block);
    static ACACIA_PLANKS: (Internal.Block) & (Internal.Block);
    static RED_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DARK_OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static FIRE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static PURPUR_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static RED_WOOL: (Internal.Block) & (Internal.Block);
    static FARMLAND: (Internal.FarmBlock) & (Internal.Block);
    static DARK_OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static ORANGE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CAKE: (Internal.CakeBlock) & (Internal.Block);
    static GREEN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static JUNGLE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static MANGROVE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REPEATER: (Internal.RepeaterBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static AZURE_BLUET: (Internal.FlowerBlock) & (Internal.Block);
    static LILY_OF_THE_VALLEY: (Internal.FlowerBlock) & (Internal.Block);
    static STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static BIRCH_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BROWN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static FIRE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static RESPAWN_ANCHOR: (Internal.RespawnAnchorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHERRACK: (Internal.NetherrackBlock) & (Internal.Block);
    static CAVE_VINES: (Internal.CaveVinesBlock) & (Internal.Block);
    static WARPED_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_POPPY: (Internal.FlowerPotBlock) & (Internal.Block);
    static POINTED_DRIPSTONE: (Internal.PointedDripstoneBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static GLASS: (Internal.GlassBlock) & (Internal.Block);
    static WARPED_PLANKS: (Internal.Block) & (Internal.Block);
    static WET_SPONGE: (Internal.WetSpongeBlock) & (Internal.Block);
    static GRASS_BLOCK: (Internal.GrassBlock) & (Internal.Block);
    static COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPUR_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static POLISHED_DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static ANCIENT_DEBRIS: (Internal.Block) & (Internal.Block);
    static GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PODZOL: (Internal.SnowyDirtBlock) & (Internal.Block);
    static CHERRY_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static COMPARATOR: (Internal.ComparatorBlock) & (Internal.Block);
    static ACACIA_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHISELED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_WEATHERED_COPPER: (Internal.Block) & (Internal.Block);
    static SUGAR_CANE: (Internal.SugarCaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static NETHERITE_BLOCK: (Internal.Block) & (Internal.Block);
    static OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_AZURE_BLUET: (Internal.FlowerPotBlock) & (Internal.Block);
    static SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BRAIN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static PINK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static GLASS_PANE: (Internal.IronBarsBlock) & (Internal.Block);
    static GRAVEL: (Internal.GravelBlock) & (Internal.Block);
    static BAMBOO_MOSAIC: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_GRAVEL: (Internal.BrushableBlock) & (Internal.Block);
    static ENCHANTING_TABLE: (Internal.EnchantmentTableBlock) & (Internal.Block);
    static LILAC: (Internal.TallFlowerBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MANGROVE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static RED_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ALLIUM: (Internal.FlowerBlock) & (Internal.Block);
    static MUD_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ZOMBIE_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static WHITE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static WHITE_WOOL: (Internal.Block) & (Internal.Block);
    static GREEN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BLACK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TUBE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static JUNGLE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static CUT_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SKELETON_WALL_SKULL: (Internal.WallSkullBlock) & (Internal.Block);
    static TALL_GRASS: (Internal.DoublePlantBlock) & (Internal.Block);
    static POTTED_JUNGLE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static YELLOW_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static PEARLESCENT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static MAGENTA_WOOL: (Internal.Block) & (Internal.Block);
    static PUMPKIN_STEM: (Internal.StemBlock) & (Internal.Block);
    static MUD: (Internal.MudBlock) & (Internal.Block);
    static GRINDSTONE: (Internal.GrindstoneBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BAMBOO_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BLUE_ICE: (Internal.HalfTransparentBlock) & (Internal.Block);
    static BROWN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static FLOWERING_AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static CHERRY_PLANKS: (Internal.Block) & (Internal.Block);
    static PACKED_ICE: (Internal.Block) & (Internal.Block);
    static ACACIA_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DARK_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static ORANGE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BEEHIVE: (Internal.BeehiveBlock) & (Internal.Block);
    static PURPLE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BLACK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WHITE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static NETHER_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LODESTONE: (Internal.Block) & (Internal.Block);
    static WEEPING_VINES: (Internal.WeepingVinesBlock) & (Internal.Block);
    static MAGENTA_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static END_PORTAL: (Internal.EndPortalBlock) & (Internal.Block);
    static TINTED_GLASS: (Internal.TintedGlassBlock) & (Internal.Block);
    static LIME_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static SKELETON_SKULL: (Internal.SkullBlock) & (Internal.Block);
    static LIME_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE: (Internal.Block) & (Internal.Block);
    static JUNGLE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static TWISTING_VINES: (Internal.TwistingVinesBlock) & (Internal.Block);
    static END_PORTAL_FRAME: (Internal.EndPortalFrameBlock) & (Internal.Block);
    static CRIMSON_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPRUCE_PLANKS: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SNIFFER_EGG: (Internal.SnifferEggBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static ORANGE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ACACIA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BIRCH_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static HANGING_ROOTS: (Internal.HangingRootsBlock) & (Internal.Block);
    static TURTLE_EGG: (Internal.TurtleEggBlock) & (Internal.Block);
    static BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static BAMBOO_SAPLING: (Internal.BambooSaplingBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WHITE_BED: (Internal.BedBlock) & (Internal.Block);
    static CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DETECTOR_RAIL: (Internal.DetectorRailBlock) & (Internal.Block);
    static COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CAULDRON: (Internal.CauldronBlock) & (Internal.Block);
    static LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static GLOWSTONE: (Internal.Block) & (Internal.Block);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static VOID_AIR: (Internal.AirBlock) & (Internal.Block);
    static PURPUR_BLOCK: (Internal.Block) & (Internal.Block);
    static INFESTED_STONE: (Internal.InfestedBlock) & (Internal.Block);
    static CHAIN: (Internal.ChainBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static MAGMA_BLOCK: (Internal.MagmaBlock) & (Internal.Block);
    static DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SPRUCE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static SMOOTH_STONE: (Internal.Block) & (Internal.Block);
    static BUBBLE_COLUMN: (Internal.BubbleColumnBlock) & (Internal.Block);
    static CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POLISHED_DIORITE: (Internal.Block) & (Internal.Block);
    static BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static AIR: (Internal.AirBlock) & (Internal.Block);
    static AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static CAVE_AIR: (Internal.AirBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BAMBOO_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CYAN_WOOL: (Internal.Block) & (Internal.Block);
    static BIRCH_PLANKS: (Internal.Block) & (Internal.Block);
    static POTTED_ORANGE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_WARPED_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static SPRUCE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DARK_PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static SMALL_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static SPRUCE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WITHER_SKELETON_SKULL: (Internal.WitherSkullBlock) & (Internal.Block);
    static BUBBLE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static CREEPER_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static STRIPPED_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHAIN_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static PIGLIN_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static MANGROVE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static BROWN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static CYAN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static FLETCHING_TABLE: (Internal.FletchingTableBlock) & (Internal.Block);
    static TORCHFLOWER_CROP: (Internal.TorchflowerCropBlock) & (Internal.Block);
    static GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static HORN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static END_GATEWAY: (Internal.EndGatewayBlock) & (Internal.Block);
    static DEEPSLATE_TILE_WALL: (Internal.WallBlock) & (Internal.Block);
    static POTTED_ALLIUM: (Internal.FlowerPotBlock) & (Internal.Block);
    static COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CALCITE: (Internal.Block) & (Internal.Block);
    static MANGROVE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static POTTED_OXEYE_DAISY: (Internal.FlowerPotBlock) & (Internal.Block);
    static FIRE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static TERRACOTTA: (Internal.Block) & (Internal.Block);
    static JUNGLE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CYAN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BAMBOO_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static END_ROD: (Internal.EndRodBlock) & (Internal.Block);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_QUARTZ: (Internal.Block) & (Internal.Block);
    static PRISMARINE: (Internal.Block) & (Internal.Block);
    static SMOOTH_QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static NETHER_QUARTZ_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static MUDDY_MANGROVE_ROOTS: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static MANGROVE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DEEPSLATE_TILE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ATTACHED_PUMPKIN_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static CYAN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static OXIDIZED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static COCOA: (Internal.CocoaBlock) & (Internal.Block);
    static JUNGLE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static BIRCH_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static SPRUCE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POTTED_RED_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static MAGENTA_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WARPED_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CRIMSON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CHEST: (Internal.ChestBlock) & (Internal.Block);
    static SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIME_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static GILDED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static SUNFLOWER: (Internal.TallFlowerBlock) & (Internal.Block);
    static ORANGE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static VERDANT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PETRIFIED_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRIED_KELP_BLOCK: (Internal.Block) & (Internal.Block);
    static BONE_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WHITE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POTTED_SPRUCE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEAD_HORN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BUBBLE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static GREEN_CONCRETE: (Internal.Block) & (Internal.Block);
    static CHORUS_FLOWER: (Internal.ChorusFlowerBlock) & (Internal.Block);
    static GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static LIGHT_GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PINK_WOOL: (Internal.Block) & (Internal.Block);
    static PINK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DARK_OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWERED_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POWDER_SNOW: (Internal.PowderSnowBlock) & (Internal.Block);
    static ORANGE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static PINK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLACK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static WARPED_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static JIGSAW: (Internal.JigsawBlock) & (Internal.Block);
    static WHITE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DIRT: (Internal.Block) & (Internal.Block);
    static BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static TALL_SEAGRASS: (Internal.TallSeagrassBlock) & (Internal.Block);
    static CHORUS_PLANT: (Internal.ChorusPlantBlock) & (Internal.Block);
    static PINK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WHITE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOVING_PISTON: (Internal.MovingPistonBlock) & (Internal.Block);
    static CHERRY_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MANGROVE_ROOTS: (Internal.MangroveRootsBlock) & (Internal.Block);
    static POTTED_ACACIA_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_PLANKS: (Internal.Block) & (Internal.Block);
    static ACACIA_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static BAMBOO_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static RED_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static BELL: (Internal.BellBlock) & (Internal.Block);
    static MUSHROOM_STEM: (Internal.HugeMushroomBlock) & (Internal.Block);
    static EXPOSED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_CRIMSON_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static GREEN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CHISELED_QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static JUNGLE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static FROGSPAWN: (Internal.FrogspawnBlock) & (Internal.Block);
    static SOUL_TORCH: (Internal.TorchBlock) & (Internal.Block);
    static BOOKSHELF: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_COPPER: (Internal.Block) & (Internal.Block);
    static CRIMSON_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static DIAMOND_BLOCK: (Internal.Block) & (Internal.Block);
    static RED_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CRIMSON_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static SPRUCE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static STRIPPED_CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CALIBRATED_SCULK_SENSOR: (Internal.CalibratedSculkSensorBlock) & (Internal.Block);
    static AMETHYST_BLOCK: (Internal.AmethystBlock) & (Internal.Block);
    static STRUCTURE_BLOCK: (Internal.StructureBlock) & (Internal.Block);
    static BAMBOO_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BRAIN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static IRON_BARS: (Internal.IronBarsBlock) & (Internal.Block);
    static IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_SAND: (Internal.BrushableBlock) & (Internal.Block);
    static HORN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static MAGENTA_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static HONEY_BLOCK: (Internal.HoneyBlock) & (Internal.Block);
    static END_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static JACK_O_LANTERN: (Internal.CarvedPumpkinBlock) & (Internal.Block);
    static TARGET: (Internal.TargetBlock) & (Internal.Block);
    static BRAIN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static DEAD_FIRE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WITHER_SKELETON_WALL_SKULL: (Internal.WitherWallSkullBlock) & (Internal.Block);
    static CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BIRCH_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static ROSE_BUSH: (Internal.TallFlowerBlock) & (Internal.Block);
    static YELLOW_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static LECTERN: (Internal.LecternBlock) & (Internal.Block);
    static CRIMSON_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DAMAGED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static POLISHED_DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static HAY_BLOCK: (Internal.HayBlock) & (Internal.Block);
    static WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static MANGROVE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static LIME_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TRIPWIRE_HOOK: (Internal.TripWireHookBlock) & (Internal.Block);
    static CLAY: (Internal.Block) & (Internal.Block);
    static SNOW: (Internal.SnowLayerBlock) & (Internal.Block);
    static WHEAT: (Internal.CropBlock) & (Internal.Block);
    static CYAN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BROWN_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static SHROOMLIGHT: (Internal.Block) & (Internal.Block);
    static CRIMSON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POPPY: (Internal.FlowerBlock) & (Internal.Block);
    static STRUCTURE_VOID: (Internal.StructureVoidBlock) & (Internal.Block);
    static ORANGE_BED: (Internal.BedBlock) & (Internal.Block);
    static DEEPSLATE_COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static REDSTONE_BLOCK: (Internal.PoweredBlock) & (Internal.Block);
    static BLACK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GREEN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POTTED_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIME_CONCRETE: (Internal.Block) & (Internal.Block);
    static BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_FIRE: (Internal.SoulFireBlock) & (Internal.Block);
    static CHISELED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static PINK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CARTOGRAPHY_TABLE: (Internal.CartographyTableBlock) & (Internal.Block);
    static BLACK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CYAN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static BAMBOO_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static COMPOSTER: (Internal.ComposterBlock) & (Internal.Block);
    static DARK_OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ACACIA_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static PITCHER_PLANT: (Internal.DoublePlantBlock) & (Internal.Block);
    static CHISELED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POTTED_PINK_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static LARGE_FERN: (Internal.DoublePlantBlock) & (Internal.Block);
    static TNT: (Internal.TntBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WARPED_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SMOOTH_QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LAVA_CAULDRON: (Internal.LavaCauldronBlock) & (Internal.Block);
    static SCULK_SHRIEKER: (Internal.SculkShriekerBlock) & (Internal.Block);
    static BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CHISELED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static SMOOTH_STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static LIME_WOOL: (Internal.Block) & (Internal.Block);
    static LIME_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static GREEN_BED: (Internal.BedBlock) & (Internal.Block);
    static ACTIVATOR_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static SEA_PICKLE: (Internal.SeaPickleBlock) & (Internal.Block);
    static PINK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static CRACKED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static FURNACE: (Internal.FurnaceBlock) & (Internal.Block);
    static COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MANGROVE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHERRY_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BAMBOO_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static MANGROVE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static BEDROCK: (Internal.Block) & (Internal.Block);
    static BIRCH_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static PURPLE_BED: (Internal.BedBlock) & (Internal.Block);
    static LIME_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SCULK: (Internal.SculkBlock) & (Internal.Block);
    static ACACIA_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static COBWEB: (Internal.WebBlock) & (Internal.Block);
    static CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BEE_NEST: (Internal.BeehiveBlock) & (Internal.Block);
    static LAVA: (Internal.LiquidBlock) & (Internal.Block);
    static POTTED_WARPED_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static NETHER_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static TORCHFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static ATTACHED_MELON_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static DEEPSLATE_EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BROWN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static POTTED_DARK_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_FERN: (Internal.FlowerPotBlock) & (Internal.Block);
    static PUMPKIN: (Internal.PumpkinBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static RED_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static BROWN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static ORANGE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RAW_IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static CACTUS: (Internal.CactusBlock) & (Internal.Block);
    static FIRE: (Internal.FireBlock) & (Internal.Block);
    static SLIME_BLOCK: (Internal.SlimeBlock) & (Internal.Block);
    static CHIPPED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static GREEN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static JUNGLE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SOUL_SAND: (Internal.SoulSandBlock) & (Internal.Block);
    static CUT_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_CONCRETE: (Internal.Block) & (Internal.Block);
    static GRANITE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SMOOTH_BASALT: (Internal.Block) & (Internal.Block);
    static DEAD_BUSH: (Internal.DeadBushBlock) & (Internal.Block);
    static DARK_OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static SOUL_CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static MAGENTA_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SPRUCE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static CREEPER_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static BROWN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static YELLOW_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static LIME_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static TUBE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_BED: (Internal.BedBlock) & (Internal.Block);
    static PURPLE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LIGHT_GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BIG_DRIPLEAF_STEM: (Internal.BigDripleafStemBlock) & (Internal.Block);
    static LIME_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WARPED_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static WHITE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CRYING_OBSIDIAN: (Internal.CryingObsidianBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static POTTED_TORCHFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static TRAPPED_CHEST: (Internal.TrappedChestBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static FLOWERING_AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_FLOWERING_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static POLISHED_ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BUBBLE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static ANDESITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static YELLOW_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BIRCH_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_PETALS: (Internal.PinkPetalsBlock) & (Internal.Block);
    static DIORITE: (Internal.Block) & (Internal.Block);
    static SWEET_BERRY_BUSH: (Internal.SweetBerryBushBlock) & (Internal.Block);
    static DECORATED_POT: (Internal.DecoratedPotBlock) & (Internal.Block);
    static INFESTED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static POTTED_RED_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static RED_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static BAMBOO_PLANKS: (Internal.Block) & (Internal.Block);
    static BIRCH_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static JUNGLE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static GREEN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BEACON: (Internal.BeaconBlock) & (Internal.Block);
    static DEEPSLATE_LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BIRCH_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static SANDSTONE: (Internal.Block) & (Internal.Block);
    static SNOW_BLOCK: (Internal.Block) & (Internal.Block);
    static BLACK_BED: (Internal.BedBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static POTTED_DEAD_BUSH: (Internal.FlowerPotBlock) & (Internal.Block);
    static STRIPPED_CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEEPSLATE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WHITE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static BAMBOO_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static INFESTED_COBBLESTONE: (Internal.InfestedBlock) & (Internal.Block);
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    asRuleTest(): Internal.RuleTest;
    ruleTestOf(o: any): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    abstract "test(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): boolean;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    "test(java.lang.Object)"(arg0: any): boolean;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: (ResourceLocation) & (ResourceLocation);
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
declare class Items {
    constructor()
    getClass(): typeof any;
    toString(): string;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    notifyAll(): void;
    static "registerItem(net.minecraft.resources.ResourceKey,net.minecraft.world.item.Item)"(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static "registerItem(net.minecraft.resources.ResourceLocation,net.minecraft.world.item.Item)"(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static "registerBlock(net.minecraft.world.item.BlockItem)"(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.item.Item)"(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static "registerBlock(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static "registerItem(java.lang.String,net.minecraft.world.item.Item)"(arg0: string, arg1: Internal.Item_): Internal.Item;
    wait(): void;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    wait(arg0: number): void;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    equals(arg0: any): boolean;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.level.block.Block[])"(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    get class(): typeof any
    static POWERED_RAIL: (Internal.BlockItem) & (Internal.Item);
    static GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ: (Internal.Item) & (Internal.Item);
    static TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_EGG: (Internal.BlockItem) & (Internal.Item);
    static HANGING_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_DYE: (Internal.DyeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_ROD: (Internal.Item) & (Internal.Item);
    static GRASS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIED_KELP: (Internal.Item) & (Internal.Item);
    static TURTLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGENTA_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT: (Internal.Item) & (Internal.Item);
    static LIGHT_GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static MUDDY_MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static ACACIA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHAIN: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static STRIPPED_SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static DEBUG_STICK: (Internal.DebugStickItem) & (Internal.Item);
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MUSIC_DISC_CAT: (Internal.RecordItem) & (Internal.Item);
    static GOLDEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static VERDANT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static WARPED_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static TIPPED_ARROW: (Internal.TippedArrowItem) & (Internal.Item);
    static MILK_BUCKET: (Internal.MilkBucketItem) & (Internal.Item);
    static LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static WEEPING_VINES: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TORCHFLOWER: (Internal.BlockItem) & (Internal.Item);
    static LODESTONE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static MANGROVE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static INFESTED_STONE: (Internal.BlockItem) & (Internal.Item);
    static OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BRUSH: (Internal.BrushItem) & (Internal.Item);
    static END_PORTAL_FRAME: (Internal.BlockItem) & (Internal.Item);
    static AZURE_BLUET: (Internal.BlockItem) & (Internal.Item);
    static NETHER_QUARTZ_ORE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SPRUCE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static COBWEB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CARROT: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GOLDEN_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SUNFLOWER: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHEST: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static RESPAWN_ANCHOR: (Internal.BlockItem) & (Internal.Item);
    static BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static LAVA_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ENDER_PEARL: (Internal.EnderpearlItem) & (Internal.Item);
    static DRIED_KELP_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static JUNGLE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static TWISTING_VINES: (Internal.BlockItem) & (Internal.Item);
    static GRINDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PHANTOM_MEMBRANE: (Internal.Item) & (Internal.Item);
    static BRICK: (Internal.Item) & (Internal.Item);
    static ARCHER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static JUNGLE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static TINTED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA: (Internal.BlockItem) & (Internal.Item);
    static POPPED_CHORUS_FRUIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_CRYSTALS: (Internal.Item) & (Internal.Item);
    static LAPIS_LAZULI: (Internal.Item) & (Internal.Item);
    static SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_INGOT: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static NETHERITE_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static CHICKEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEEHIVE: (Internal.BlockItem) & (Internal.Item);
    static SPYGLASS: (Internal.SpyglassItem) & (Internal.Item);
    static NETHERITE_AXE: (Internal.AxeItem) & (Internal.Item);
    static ELDER_GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MULE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_STAR: (Internal.FireworkStarItem) & (Internal.Item);
    static SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SKULL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static FROG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DIRT: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static WOODEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static GLOWSTONE_DUST: (Internal.Item) & (Internal.Item);
    static ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static MUSIC_DISC_RELIC: (Internal.RecordItem) & (Internal.Item);
    static SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_FENCE: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LIME_CARPET: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static SUGAR_CANE: (Internal.BlockItem) & (Internal.Item);
    static COMMAND_BLOCK_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHEST_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SCUTE: (Internal.Item) & (Internal.Item);
    static FEATHER: (Internal.Item) & (Internal.Item);
    static JUNGLE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CUT_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WHITE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COPPER_INGOT: (Internal.Item) & (Internal.Item);
    static SWEET_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GREEN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BELL: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_POD: (Internal.ItemNameBlockItem) & (Internal.Item);
    static BLACK_DYE: (Internal.DyeItem) & (Internal.Item);
    static WHITE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static DETECTOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIME_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static CHORUS_FLOWER: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static WARDEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHISELED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SNOWBALL: (Internal.SnowballItem) & (Internal.Item);
    static LANTERN: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MAP: (Internal.EmptyMapItem) & (Internal.Item);
    static WHITE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CUT_STANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLAST_FURNACE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_INGOT: (Internal.Item) & (Internal.Item);
    static PINK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGMA_CUBE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHITE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TRADER_LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TNT: (Internal.BlockItem) & (Internal.Item);
    static OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CHERRY_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BANNER: (Internal.BannerItem) & (Internal.Item);
    static ROTTEN_FLESH: (Internal.Item) & (Internal.Item);
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WRITTEN_BOOK: (Internal.WrittenBookItem) & (Internal.Item);
    static DISC_FRAGMENT_5: (Internal.DiscFragmentItem) & (Internal.Item);
    static SNIFFER_EGG: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_DYE: (Internal.DyeItem) & (Internal.Item);
    static CLAY: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SPAWNER: (Internal.BlockItem) & (Internal.Item);
    static LIME_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SCRAP: (Internal.Item) & (Internal.Item);
    static NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static STONE: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static AMETHYST_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static HOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ZOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_DYE: (Internal.DyeItem) & (Internal.Item);
    static IRON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MAGENTA_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PETRIFIED_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_SHARD: (Internal.Item) & (Internal.Item);
    static NETHER_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BASALT: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CHERRY_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static ENDER_DRAGON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static OBSERVER: (Internal.BlockItem) & (Internal.Item);
    static GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_SWORD: (Internal.SwordItem) & (Internal.Item);
    static FOX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CALCITE: (Internal.BlockItem) & (Internal.Item);
    static PUMPKIN_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static FERMENTED_SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static HEART_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PURPLE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static MUTTON: (Internal.Item) & (Internal.Item);
    static PURPLE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static ZOMBIE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_PIGSTEP: (Internal.RecordItem) & (Internal.Item);
    static REDSTONE_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LEATHER_LEGGINGS: (Internal.DyeableArmorItem) & (Internal.Item);
    static PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static RED_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static COD: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_11: (Internal.RecordItem) & (Internal.Item);
    static AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART: (Internal.ItemNameBlockItem) & (Internal.Item);
    static NAME_TAG: (Internal.NameTagItem) & (Internal.Item);
    static CYAN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static JACK_O_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static WARPED_SLAB: (Internal.BlockItem) & (Internal.Item);
    static FURNACE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CARPET: (Internal.BlockItem) & (Internal.Item);
    static POWDER_SNOW_BUCKET: (Internal.SolidBucketItem) & (Internal.Item);
    static BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static BOOK: (Internal.BookItem) & (Internal.Item);
    static RED_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CRIMSON_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_BED: (Internal.BedItem) & (Internal.Item);
    static EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static COD_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DIAMOND: (Internal.Item) & (Internal.Item);
    static AZALEA: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static SPRUCE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MELON_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_13: (Internal.RecordItem) & (Internal.Item);
    static LIGHT_GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static FLOWER_POT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static SEA_PICKLE: (Internal.BlockItem) & (Internal.Item);
    static LARGE_FERN: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static AMETHYST_SHARD: (Internal.Item) & (Internal.Item);
    static CHICKEN: (Internal.Item) & (Internal.Item);
    static GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static TOTEM_OF_UNDYING: (Internal.Item) & (Internal.Item);
    static STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BED: (Internal.BedItem) & (Internal.Item);
    static DROPPER: (Internal.BlockItem) & (Internal.Item);
    static LIME_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static KNOWLEDGE_BOOK: (Internal.KnowledgeBookItem) & (Internal.Item);
    static LOOM: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FISHING_ROD: (Internal.FishingRodItem) & (Internal.Item);
    static BROWN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MEDIUM_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static ROOTED_DIRT: (Internal.BlockItem) & (Internal.Item);
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SHEAF_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_SAND: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SHEARS: (Internal.ShearsItem) & (Internal.Item);
    static PANDA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POTATO: (Internal.ItemNameBlockItem) & (Internal.Item);
    static LAPIS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static COMPOSTER: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static TROPICAL_FISH: (Internal.Item) & (Internal.Item);
    static POTION: (Internal.PotionItem) & (Internal.Item);
    static MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static JIGSAW: (Internal.GameMasterBlockItem) & (Internal.Item);
    static PRISMARINE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static WARPED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIGHT_BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_CHESTPLATE: (Internal.DyeableArmorItem) & (Internal.Item);
    static RED_BED: (Internal.BedItem) & (Internal.Item);
    static STONE_HOE: (Internal.HoeItem) & (Internal.Item);
    static JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static GLOW_SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static BROWN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static GREEN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BREAD: (Internal.Item) & (Internal.Item);
    static COOKED_CHICKEN: (Internal.Item) & (Internal.Item);
    static BIRCH_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GOLD_NUGGET: (Internal.Item) & (Internal.Item);
    static PHANTOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static WHEAT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static PORKCHOP: (Internal.Item) & (Internal.Item);
    static SCAFFOLDING: (Internal.ScaffoldingBlockItem) & (Internal.Item);
    static END_ROD: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static PACKED_MUD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static REINFORCED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static LILY_OF_THE_VALLEY: (Internal.BlockItem) & (Internal.Item);
    static VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PARROT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHEAT: (Internal.Item) & (Internal.Item);
    static JUNGLE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_AXE: (Internal.AxeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static NETHERRACK: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static STONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CAKE: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static FARMLAND: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PUMPKIN_PIE: (Internal.Item) & (Internal.Item);
    static SHULKER_SHELL: (Internal.Item) & (Internal.Item);
    static OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static RABBIT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static APPLE: (Internal.Item) & (Internal.Item);
    static DIAMOND_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WARPED_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static ELYTRA: (Internal.ElytraItem) & (Internal.Item);
    static WARPED_SIGN: (Internal.SignItem) & (Internal.Item);
    static GREEN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BEE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_DYE: (Internal.DyeItem) & (Internal.Item);
    static PLAYER_HEAD: (Internal.PlayerHeadItem) & (Internal.Item);
    static GLOW_LICHEN: (Internal.BlockItem) & (Internal.Item);
    static STONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ROSE_BUSH: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GLOW_ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static WHITE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static BLADE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static EGG: (Internal.EggItem) & (Internal.Item);
    static WITCH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OCELOT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_SPROUTS: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TALL_GRASS: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static FILLED_MAP: (Internal.MapItem) & (Internal.Item);
    static MUD_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static AXOLOTL_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static ZOMBIE_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_SIGN: (Internal.SignItem) & (Internal.Item);
    static STRIPPED_JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static MUSHROOM_STEM: (Internal.BlockItem) & (Internal.Item);
    static LILAC: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAMBOO_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SUSPICIOUS_STEW: (Internal.SuspiciousStewItem) & (Internal.Item);
    static SUSPICIOUS_GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static IRON_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SHULKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MELON_SLICE: (Internal.Item) & (Internal.Item);
    static HONEYCOMB_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PEARLESCENT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static ANCIENT_DEBRIS: (Internal.BlockItem) & (Internal.Item);
    static HOPPER_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static MAGMA_CREAM: (Internal.Item) & (Internal.Item);
    static ZOMBIE_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static POLISHED_GRANITE: (Internal.BlockItem) & (Internal.Item);
    static PINK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static HONEYCOMB: (Internal.HoneycombItem) & (Internal.Item);
    static NOTE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static FURNACE_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DRAGON_BREATH: (Internal.Item) & (Internal.Item);
    static CYAN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_PLANT: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static DARK_OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static COAL: (Internal.Item) & (Internal.Item);
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DANGER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BARREL: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WHITE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ORANGE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ENCHANTED_BOOK: (Internal.EnchantedBookItem) & (Internal.Item);
    static SOUL_SOIL: (Internal.BlockItem) & (Internal.Item);
    static IRON_NUGGET: (Internal.Item) & (Internal.Item);
    static ENDERMITE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static LEVER: (Internal.BlockItem) & (Internal.Item);
    static COOKED_SALMON: (Internal.Item) & (Internal.Item);
    static CAULDRON: (Internal.Items$1) & (Internal.Item);
    static ALLIUM: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static EXPLORER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static POISONOUS_POTATO: (Internal.Item) & (Internal.Item);
    static FLOWER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SMOOTH_STONE: (Internal.BlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNORT_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GHAST_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static IRON_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static AXOLOTL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SEA_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static LIME_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SHIELD: (Internal.ShieldItem) & (Internal.Item);
    static DIORITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static GOLDEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static BLACK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static REPEATER: (Internal.BlockItem) & (Internal.Item);
    static SPECTRAL_ARROW: (Internal.SpectralArrowItem) & (Internal.Item);
    static CHERRY_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LEAD: (Internal.LeadItem) & (Internal.Item);
    static WHITE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WAXED_OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PINK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BOAT: (Internal.BoatItem) & (Internal.Item);
    static BLACK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BREWING_STAND: (Internal.BlockItem) & (Internal.Item);
    static BIG_DRIPLEAF: (Internal.Items$1) & (Internal.Item);
    static CARVED_PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PINK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static END_STONE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static LIGHT: (Internal.BlockItem) & (Internal.Item);
    static BONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIPSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WET_SPONGE: (Internal.BlockItem) & (Internal.Item);
    static FLINT: (Internal.Item) & (Internal.Item);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static HUSK_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ICE: (Internal.BlockItem) & (Internal.Item);
    static JUKEBOX: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static FIRE_CHARGE: (Internal.FireChargeItem) & (Internal.Item);
    static COOKED_MUTTON: (Internal.Item) & (Internal.Item);
    static BASALT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static PIG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSHROOM_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static PURPLE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HOWL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SMALL_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static RED_WOOL: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PROPAGULE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PAPER: (Internal.Item) & (Internal.Item);
    static IRON_HOE: (Internal.HoeItem) & (Internal.Item);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STICKY_PISTON: (Internal.BlockItem) & (Internal.Item);
    static COMPASS: (Internal.CompassItem) & (Internal.Item);
    static RED_SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static CLAY_BALL: (Internal.Item) & (Internal.Item);
    static CYAN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static STONECUTTER: (Internal.BlockItem) & (Internal.Item);
    static MINECART: (Internal.MinecartItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SHELTER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static AIR: (Internal.AirItem) & (Internal.Item);
    static SEAGRASS: (Internal.BlockItem) & (Internal.Item);
    static GLOWSTONE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BED: (Internal.BedItem) & (Internal.Item);
    static ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DONKEY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static WAXED_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTED_GOLDEN_APPLE: (Internal.EnchantedGoldenAppleItem) & (Internal.Item);
    static MANGROVE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MUD: (Internal.BlockItem) & (Internal.Item);
    static OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static GOAT_HORN: (Internal.InstrumentItem) & (Internal.Item);
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CAVE_SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SUGAR: (Internal.Item) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_VEIN: (Internal.BlockItem) & (Internal.Item);
    static FLETCHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BROWN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PLENTY_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CLOCK: (Internal.Item) & (Internal.Item);
    static GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static EMERALD: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BROWN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static KELP: (Internal.BlockItem) & (Internal.Item);
    static WITHER_ROSE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static TADPOLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static SPRUCE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRAFTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static BAKED_POTATO: (Internal.Item) & (Internal.Item);
    static MANGROVE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_BED: (Internal.BedItem) & (Internal.Item);
    static CHISELED_BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static NAUTILUS_SHELL: (Internal.Item) & (Internal.Item);
    static SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STICK: (Internal.Item) & (Internal.Item);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static COARSE_DIRT: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LIGHTNING_ROD: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE: (Internal.BlockItem) & (Internal.Item);
    static POLAR_BEAR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static MOJANG_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static DEEPSLATE_REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PINK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BREWER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DIORITE: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static LIGHT_GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static BAMBOO_SIGN: (Internal.SignItem) & (Internal.Item);
    static IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static BUNDLE: (Internal.BundleItem) & (Internal.Item);
    static STRING: (Internal.ItemNameBlockItem) & (Internal.Item);
    static STRIPPED_JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static END_CRYSTAL: (Internal.EndCrystalItem) & (Internal.Item);
    static LEATHER_BOOTS: (Internal.DyeableArmorItem) & (Internal.Item);
    static SLIME_BALL: (Internal.Item) & (Internal.Item);
    static ORANGE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static BOW: (Internal.BowItem) & (Internal.Item);
    static ORANGE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ORCHID: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SAND: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HOE: (Internal.HoeItem) & (Internal.Item);
    static RED_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static MYCELIUM: (Internal.BlockItem) & (Internal.Item);
    static PINK_TULIP: (Internal.BlockItem) & (Internal.Item);
    static PINK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GOAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_LAMP: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIME_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static ARMOR_STAND: (Internal.ArmorStandItem) & (Internal.Item);
    static CHERRY_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static MANGROVE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static PRISMARINE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static RED_NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPERIENCE_BOTTLE: (Internal.ExperienceBottleItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static SMITHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SIGN: (Internal.SignItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static VEX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PIGLIN_BRUTE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_POWDER: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_MALL: (Internal.RecordItem) & (Internal.Item);
    static LARGE_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BUDDING_AMETHYST: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_FOOT: (Internal.Item) & (Internal.Item);
    static BAMBOO_MOSAIC: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SKULL_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static ACACIA_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BURN_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static BEACON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static GLOW_INK_SAC: (Internal.GlowInkSacItem) & (Internal.Item);
    static CYAN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CAMEL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static GRASS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_CHIRP: (Internal.RecordItem) & (Internal.Item);
    static MUSIC_DISC_FAR: (Internal.RecordItem) & (Internal.Item);
    static RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WOODEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static SPORE_BLOSSOM: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CROSSBOW: (Internal.CrossbowItem) & (Internal.Item);
    static BAMBOO_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static ORANGE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GREEN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_HIDE: (Internal.Item) & (Internal.Item);
    static COOKED_COD: (Internal.Item) & (Internal.Item);
    static BLACK_BED: (Internal.BedItem) & (Internal.Item);
    static PUFFERFISH: (Internal.Item) & (Internal.Item);
    static ENDER_EYE: (Internal.EnderEyeItem) & (Internal.Item);
    static INFESTED_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static GOLD_INGOT: (Internal.Item) & (Internal.Item);
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static STRIPPED_MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static ICE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static LIME_BANNER: (Internal.BannerItem) & (Internal.Item);
    static PINK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static SMALL_DRIPLEAF: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static LILY_PAD: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static CREEPER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static GLOW_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HOPPER: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static PURPLE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static HAY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static HEART_OF_THE_SEA: (Internal.Item) & (Internal.Item);
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static SHEEP_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ANGLER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PODZOL: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HOE: (Internal.HoeItem) & (Internal.Item);
    static GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SIGN: (Internal.SignItem) & (Internal.Item);
    static RABBIT_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DECORATED_POT: (Internal.BlockItem) & (Internal.Item);
    static OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIME_BED: (Internal.BedItem) & (Internal.Item);
    static TUFF: (Internal.BlockItem) & (Internal.Item);
    static GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static BARRIER: (Internal.BlockItem) & (Internal.Item);
    static DRAGON_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MUSIC_DISC_MELLOHI: (Internal.RecordItem) & (Internal.Item);
    static IRON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static VINDICATOR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SMOOTH_BASALT: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DROWNED_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_STAR: (Internal.SimpleFoiledItem) & (Internal.Item);
    static CRIMSON_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static FLINT_AND_STEEL: (Internal.FlintAndSteelItem) & (Internal.Item);
    static MAGENTA_BED: (Internal.BedItem) & (Internal.Item);
    static BONE: (Internal.Item) & (Internal.Item);
    static BROWN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CALIBRATED_SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static COMPARATOR: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HORSE_ARMOR: (Internal.DyeableHorseArmorItem) & (Internal.Item);
    static STRIPPED_BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static MOSS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CREEPER_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static JUNGLE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COOKIE: (Internal.Item) & (Internal.Item);
    static GRANITE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER: (Internal.Item) & (Internal.Item);
    static SALMON_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DANDELION: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PRISMARINE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static IRON_SWORD: (Internal.SwordItem) & (Internal.Item);
    static BONE_MEAL: (Internal.BoneMealItem) & (Internal.Item);
    static GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POINTED_DRIPSTONE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ALLAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static COW_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ARMS_UP_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_WARD: (Internal.RecordItem) & (Internal.Item);
    static PINK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_FRUIT: (Internal.ChorusFruitItem) & (Internal.Item);
    static VINE: (Internal.BlockItem) & (Internal.Item);
    static COAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_OTHERSIDE: (Internal.RecordItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SNOW_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SCULK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SIGN: (Internal.SignItem) & (Internal.Item);
    static COCOA_BEANS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_DYE: (Internal.DyeItem) & (Internal.Item);
    static CYAN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static GLOBE_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static GREEN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CONDUIT: (Internal.BlockItem) & (Internal.Item);
    static GLISTERING_MELON_SLICE: (Internal.Item) & (Internal.Item);
    static RAVAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SKELETON_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO: (Internal.BlockItem) & (Internal.Item);
    static COOKED_PORKCHOP: (Internal.Item) & (Internal.Item);
    static GOLDEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static CUT_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static BAMBOO_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static SMOKER: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MOSS_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_ROCKET: (Internal.FireworkRocketItem) & (Internal.Item);
    static OCHRE_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TADPOLE_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DRAGON_EGG: (Internal.BlockItem) & (Internal.Item);
    static PRIZE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DARK_OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static COOKED_RABBIT: (Internal.Item) & (Internal.Item);
    static CHERRY_BOAT: (Internal.BoatItem) & (Internal.Item);
    static END_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static GREEN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MUSIC_DISC_WAIT: (Internal.RecordItem) & (Internal.Item);
    static RED_NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_PLANT: (Internal.BlockItem) & (Internal.Item);
    static LIME_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static AMETHYST_CLUSTER: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static RED_DYE: (Internal.DyeItem) & (Internal.Item);
    static SPLASH_POTION: (Internal.SplashPotionItem) & (Internal.Item);
    static PURPLE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STRIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXEYE_DAISY: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PINK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static REPEATING_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CHERRY_SIGN: (Internal.SignItem) & (Internal.Item);
    static CRYING_OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CREEPER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SHRIEKER: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PINK_PETALS: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_DYE: (Internal.DyeItem) & (Internal.Item);
    static CRIMSON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static PURPLE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEETROOT_SOUP: (Internal.BowlFoodItem) & (Internal.Item);
    static CRIMSON_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BED: (Internal.BedItem) & (Internal.Item);
    static BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static TARGET: (Internal.BlockItem) & (Internal.Item);
    static SOUL_SAND: (Internal.BlockItem) & (Internal.Item);
    static DAYLIGHT_DETECTOR: (Internal.BlockItem) & (Internal.Item);
    static MOOSHROOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DAMAGED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static INK_SAC: (Internal.InkSacItem) & (Internal.Item);
    static LINGERING_POTION: (Internal.LingeringPotionItem) & (Internal.Item);
    static BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GILDED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static SOUL_CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LECTERN: (Internal.BlockItem) & (Internal.Item);
    static SHROOMLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SNIFFER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PAINTING: (Internal.HangingEntityItem) & (Internal.Item);
    static MANGROVE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ARROW: (Internal.ArrowItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static SOUL_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WRITABLE_BOOK: (Internal.WritableBookItem) & (Internal.Item);
    static PURPLE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CUT_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static LIME_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_WALL: (Internal.BlockItem) & (Internal.Item);
    static SLIME_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_SLAB: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SUSPICIOUS_SAND: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static IRON_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static PISTON: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static DEEPSLATE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static COD_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static HONEY_BOTTLE: (Internal.HoneyBottleItem) & (Internal.Item);
    static EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STRAD: (Internal.RecordItem) & (Internal.Item);
    static GREEN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_BED: (Internal.BedItem) & (Internal.Item);
    static LADDER: (Internal.BlockItem) & (Internal.Item);
    static SCULK_CATALYST: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNOW_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_CHEST_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SALMON: (Internal.Item) & (Internal.Item);
    static DISPENSER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_BANNER: (Internal.BannerItem) & (Internal.Item);
    static IRON_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEEPSLATE_LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static SILVERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ENDERMAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GOLDEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHARCOAL: (Internal.Item) & (Internal.Item);
    static WOODEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static MELON: (Internal.BlockItem) & (Internal.Item);
    static ECHO_SHARD: (Internal.Item) & (Internal.Item);
    static BAMBOO_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static DIRT_PATH: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WHITE_BED: (Internal.BedItem) & (Internal.Item);
    static DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static RECOVERY_COMPASS: (Internal.Item) & (Internal.Item);
    static SNOW: (Internal.BlockItem) & (Internal.Item);
    static GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GHAST_TEAR: (Internal.Item) & (Internal.Item);
    static GOLDEN_CARROT: (Internal.Item) & (Internal.Item);
    static FERN: (Internal.BlockItem) & (Internal.Item);
    static CORNFLOWER: (Internal.BlockItem) & (Internal.Item);
    static CHAIN_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static ZOMBIE_VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static TRIPWIRE_HOOK: (Internal.BlockItem) & (Internal.Item);
    static EVOKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SALMON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEEPSLATE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAW_GOLD: (Internal.Item) & (Internal.Item);
    static BIRCH_SIGN: (Internal.SignItem) & (Internal.Item);
    static FROGSPAWN: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static SADDLE: (Internal.SaddleItem) & (Internal.Item);
    static YELLOW_WOOL: (Internal.BlockItem) & (Internal.Item);
    static TRIDENT: (Internal.TridentItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static SLIME_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ENDER_CHEST: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BED: (Internal.BedItem) & (Internal.Item);
    static CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WANDERING_TRADER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WAXED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAIL: (Internal.BlockItem) & (Internal.Item);
    static EMERALD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static POPPY: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HELMET: (Internal.DyeableArmorItem) & (Internal.Item);
    static ACACIA_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static CARTOGRAPHY_TABLE: (Internal.BlockItem) & (Internal.Item);
    static RED_TULIP: (Internal.BlockItem) & (Internal.Item);
    static TRAPPED_CHEST: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static CHIPPED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static MAGMA_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GUNPOWDER: (Internal.Item) & (Internal.Item);
    static OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLACK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static PACKED_ICE: (Internal.BlockItem) & (Internal.Item);
    static PEONY: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CRIMSON_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static IRON_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GOLDEN_APPLE: (Internal.Item) & (Internal.Item);
    static LIGHT_BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static WARPED_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CACTUS: (Internal.BlockItem) & (Internal.Item);
    static TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GLASS_BOTTLE: (Internal.BottleItem) & (Internal.Item);
    static MAGENTA_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_VOID: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_BLOCKS: (Internal.RecordItem) & (Internal.Item);
    static COOKED_BEEF: (Internal.Item) & (Internal.Item);
    static DIAMOND_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static WOODEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static CRIMSON_SIGN: (Internal.SignItem) & (Internal.Item);
    static NETHER_BRICK: (Internal.Item) & (Internal.Item);
    static STONE_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEAD_BUSH: (Internal.BlockItem) & (Internal.Item);
    static CYAN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static DEEPSLATE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MINER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static WOLF_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MAGENTA_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CYAN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON: (Internal.Item) & (Internal.Item);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static IRON_BARS: (Internal.BlockItem) & (Internal.Item);
    static SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEDROCK: (Internal.BlockItem) & (Internal.Item);
    static MOURNER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static STRIPPED_CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static TNT_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static BEE_NEST: (Internal.BlockItem) & (Internal.Item);
    static ACTIVATOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_5: (Internal.RecordItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GOLDEN_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TORCHFLOWER_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HONEY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static FRIEND_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RAW_GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static DOLPHIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GRANITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIME_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static WOODEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WATER_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static SMOOTH_QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STAL: (Internal.RecordItem) & (Internal.Item);
    static SPONGE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static RAW_COPPER: (Internal.Item) & (Internal.Item);
    static DARK_OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOWL: (Internal.Item) & (Internal.Item);
    static BLACK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEEF: (Internal.Item) & (Internal.Item);
    static COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SPRUCE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static HEARTBREAK_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
}
type Items_ = Items;
declare class AlmostUnified {
    static getPreferredItemForTag(tag: ResourceLocation_): Internal.ItemStack;
    getClass(): typeof any;
    toString(): string;
    static getReplacementForItem(stack: Internal.ItemStack_): Internal.ItemStack;
    notifyAll(): void;
    static getUnifyConfig(): Internal.UnifyConfig;
    static getTags(): Internal.Set<string>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    static getItemIds(tag: ResourceLocation_): Internal.Set<string>;
    static getPreferredTagForItem(stack: Internal.ItemStack_): string;
    equals(arg0: any): boolean;
    get class(): typeof any
    get unifyConfig(): Internal.UnifyConfig
    get tags(): Internal.Set<string>
}
type AlmostUnified_ = AlmostUnified;
declare class GunSmithTableResultInfo {
    getClass(): typeof any;
    static create(): GunSmithTableResultInfo;
    getCount(): number;
    getCustomItem(): Internal.JsonObject;
    setNbt(arg0: Internal.CompoundTag_): this;
    setId(arg0: ResourceLocation_): this;
    notify(): void;
    toJson(): Internal.JsonObject;
    static createFromJson(arg0: Internal.JsonObject_): GunSmithTableResultInfo;
    wait(arg0: number, arg1: number): void;
    setCustomItem(arg0: Internal.JsonObject_): this;
    static createFromItemStack(arg0: Internal.ItemStack_): GunSmithTableResultInfo;
    getId(): ResourceLocation;
    getType(): string;
    static of(arg0: any): GunSmithTableResultInfo;
    setType(arg0: string): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    setGroupName(arg0: string): this;
    setCount(arg0: number): this;
    notifyAll(): void;
    hashCode(): number;
    setGroup(arg0: Internal.GunSmithTableResultInfo$OutputGroupName_): this;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get count(): number
    get customItem(): Internal.JsonObject
    set nbt(arg0: Internal.CompoundTag_)
    set id(arg0: ResourceLocation_)
    set customItem(arg0: Internal.JsonObject_)
    get id(): ResourceLocation
    get type(): string
    set type(arg0: string)
    get nbt(): Internal.CompoundTag
    set groupName(arg0: string)
    set count(arg0: number)
    set group(arg0: Internal.GunSmithTableResultInfo$OutputGroupName_)
}
type GunSmithTableResultInfo_ = GunSmithTableResultInfo;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    "dividedBy(java.time.Duration)"(arg0: Duration_): number;
    static parse(arg0: Internal.CharSequence_): Duration;
    notify(): void;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    isNegative(): boolean;
    static ofMinutes(arg0: number): Duration;
    minus(arg0: Duration_): this;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    wait(): void;
    plusNanos(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    getClass(): typeof any;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    wait(arg0: number, arg1: number): void;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    toString(): string;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    notifyAll(): void;
    toDaysPart(): number;
    "compareTo(java.time.Duration)"(arg0: Duration_): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    plusHours(arg0: number): this;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    hashCode(): number;
    minusMillis(arg0: number): this;
    wait(arg0: number): void;
    dividedBy(arg0: Duration_): number;
    equals(arg0: any): boolean;
    abs(): this;
    static ofHours(arg0: number): Duration;
    minusMinutes(arg0: number): this;
    withNanos(arg0: number): this;
    "dividedBy(long)"(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get class(): typeof any
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: (Duration) & (Duration);
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getClass(): typeof any;
    getCount(): number;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    notifyAll(): void;
    getChance(): number;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    hasChance(): boolean;
    equals(arg0: any): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get class(): typeof any
    get count(): number
    get empty(): boolean
    get nbt(): Internal.CompoundTag
    get chance(): number
    static readonly EMPTY: (OutputItem) & (OutputItem);
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class DamageSource {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    getClass(): typeof any;
    getSourcePosition(): Vec3d;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    "is(net.minecraft.tags.TagKey)"(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    notify(): void;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): Internal.Component;
    wait(arg0: number, arg1: number): void;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    type(): Internal.DamageType;
    "is(net.minecraft.resources.ResourceKey)"(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    toString(): string;
    isIndirect(): boolean;
    getImmediate(): Internal.Entity;
    notifyAll(): void;
    getFoodExhaustion(): number;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    hashCode(): number;
    isCreativePlayer(): boolean;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get sourcePosition(): Vec3d
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
}
type DamageSource_ = DamageSource;
declare class Platform {
    constructor()
    getClass(): typeof any;
    static getMcVersion(): string;
    static isForge(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static isFabric(): boolean;
    static isGeneratingData(): boolean;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    toString(): string;
    notifyAll(): void;
    static isClientEnvironment(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    hashCode(): number;
    static getMinecraftVersionString(): string;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get mcVersion(): string
    get forge(): boolean
    get fabric(): boolean
    get generatingData(): boolean
    get name(): string
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get modVersion(): string
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
}
type Platform_ = Platform;
declare class TaCZJSUtils {
    constructor()
    getClass(): typeof any;
    static getAttachmentIndex(attachmentId: ResourceLocation_): Internal.CommonAttachmentIndex;
    static mainHandHoldGun(livingEntity: Internal.LivingEntity_): boolean;
    toString(): string;
    static getAmmoIndex(ammoId: ResourceLocation_): Internal.CommonAmmoIndex;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static getGunDisplay(): Internal.GunDisplayInstance;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    static getGunIndex(gunId: ResourceLocation_): Internal.CommonGunIndex;
    static openRefitScreen(): void;
    get class(): typeof any
    get gunDisplay(): Internal.GunDisplayInstance
}
type TaCZJSUtils_ = TaCZJSUtils;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    rotateY(arg0: number): this;
    "mul(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    "fma(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    "set(float)"(arg0: number): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    round(): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "div(float)"(arg0: number): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    get(arg0: number): number;
    "mulAdd(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mul(arg0: number, arg1: number, arg2: number): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    getClass(): typeof any;
    "mulPosition(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    "mulDirection(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "div(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotateZ(arg0: number): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    set(arg0: number[]): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    "set(double)"(arg0: number): this;
    "normalize(float)"(arg0: number): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc,org.joml.Vector3f)"(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    wait(arg0: number): void;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    "mulDirection(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    normalize(arg0: number): this;
    normalize(arg0: Vec3f_): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    "mulDirection(org.joml.Matrix4dc,org.joml.Vector3f)"(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    "mul(org.joml.Matrix3dc,org.joml.Vector3f)"(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    x(): number;
    absolute(): this;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2dc,float)"(arg0: Internal.Vector2dc_, arg1: number): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mul(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    "set(org.joml.Vector2ic,float)"(arg0: Internal.Vector2ic_, arg1: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    "set(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_): this;
    "mul(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "normalize(org.joml.Vector3f)"(arg0: Vec3f_): this;
    "set(float[])"(arg0: number[]): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    "get(int,org.joml.Vector3i)"(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    distance(arg0: Internal.Vector3fc_): number;
    "mul(org.joml.Matrix3fc,org.joml.Vector3f)"(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    "mulPosition(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector3fc_): this;
    equals(arg0: any): boolean;
    setFromAddress(arg0: number): this;
    "mul(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "get(org.joml.Vector3f)"(arg0: Vec3f_): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    z(): number;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set(double,double,double)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2fc,float)"(arg0: Internal.Vector2fc_, arg1: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    floor(): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    toString(): string;
    notifyAll(): void;
    "mulPosition(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "mulPosition(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    div(arg0: number): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    "mul(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    notify(): void;
    "mulAdd(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    "set(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    "get(int)"(arg0: number): number;
    distance(arg0: number, arg1: number, arg2: number): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    dot(arg0: Internal.Vector3fc_): number;
    "set(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    wait(arg0: number, arg1: number): void;
    "mulDirection(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    "div(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    "fma(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    hashCode(): number;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get class(): typeof any
    set "(double)"(arg0: number)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    get finite(): boolean
    set "(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_)
    set "(float[])"(arg0: number[])
    set fromAddress(arg0: number)
    set "(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_)
    set "(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    "fma(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "div(float)"(arg0: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    "set(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mul(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    z(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "mul(float)"(arg0: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(org.joml.Vector2fc,float,float)"(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    getClass(): typeof any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "set(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_): this;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_): this;
    "mul(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    negate(arg0: Vec4f_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "fma(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    "get(int,org.joml.Vector4i)"(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "mulAdd(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    length(): number;
    toString(): string;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    notifyAll(): void;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Vector4f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    "get(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    "set(org.joml.Vector3ic,float)"(arg0: Internal.Vector3ic_, arg1: number): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    wait(arg0: number): void;
    static "lengthSquared(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "set(org.joml.Vector3fc,float)"(arg0: Internal.Vector3fc_, arg1: number): this;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector4f)"(arg0: Vec4f_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    "set(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    absolute(): this;
    mul(arg0: number, arg1: Vec4f_): this;
    distance(arg0: Internal.Vector4fc_): number;
    notify(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    "normalize(org.joml.Vector4f)"(arg0: Vec4f_): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    "mul(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    "div(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    "div(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(double)"(arg0: number): this;
    "div(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    wait(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    static "lengthSquared(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "get(int)"(arg0: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "normalize(float)"(arg0: number): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    add(arg0: Internal.Vector4fc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    wait(arg0: number, arg1: number): void;
    "set(org.joml.Vector2ic,float,float)"(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    "mulAdd(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    hashCode(): number;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    "set(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_): this;
    set(arg0: number): this;
    equals(arg0: any): boolean;
    mul(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    "set(float[])"(arg0: number[]): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get class(): typeof any
    set "(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get finite(): boolean
    set fromAddress(arg0: number)
    set "(double)"(arg0: number)
    set "(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_)
    set "(float[])"(arg0: number[])
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: (Internal.WildcardIngredient) & (Internal.Ingredient);
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: (Internal.Ingredient) & (Internal.Ingredient);
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static "nextUp(float)"(arg0: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static ceil(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static exp(arg0: number): number;
    static "decrementExact(long)"(arg0: number): number;
    static "floorMod(long,int)"(arg0: number, arg1: number): number;
    static "incrementExact(int)"(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static "copySign(float,float)"(arg0: number, arg1: number): number;
    static "abs(float)"(arg0: number): number;
    static "negateExact(int)"(arg0: number): number;
    static "fma(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
    static "min(double,double)"(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static "scalb(float,int)"(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "subtractExact(long,long)"(arg0: number, arg1: number): number;
    static "floorDiv(long,long)"(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static "max(float,float)"(arg0: number, arg1: number): number;
    static "nextAfter(double,double)"(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    getClass(): typeof any;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static "min(int,int)"(arg0: number, arg1: number): number;
    static "floorMod(int,int)"(arg0: number, arg1: number): number;
    static "max(long,long)"(arg0: number, arg1: number): number;
    static "fma(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
    static "nextDown(double)"(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static "round(float)"(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static "floorDiv(int,int)"(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static "multiplyExact(long,long)"(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static "scalb(double,int)"(arg0: number, arg1: number): number;
    static "decrementExact(int)"(arg0: number): number;
    static tanh(arg0: number): number;
    toString(): string;
    static "negateExact(long)"(arg0: number): number;
    static "nextUp(double)"(arg0: number): number;
    notifyAll(): void;
    static floorMod(arg0: number, arg1: number): number;
    static "min(long,long)"(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static "absExact(long)"(arg0: number): number;
    static "addExact(int,int)"(arg0: number, arg1: number): number;
    static pow(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    wait(arg0: number): void;
    static "abs(int)"(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static "addExact(long,long)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    notify(): void;
    static multiplyExact(arg0: number, arg1: number): number;
    static "ulp(float)"(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static "ulp(double)"(arg0: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static "copySign(double,double)"(arg0: number, arg1: number): number;
    static "multiplyExact(int,int)"(arg0: number, arg1: number): number;
    static "abs(double)"(arg0: number): number;
    static "subtractExact(int,int)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "floorMod(long,long)"(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static "abs(long)"(arg0: number): number;
    static rint(arg0: number): number;
    static "min(float,float)"(arg0: number, arg1: number): number;
    static "max(int,int)"(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static absExact(arg0: number): number;
    wait(): void;
    static log10(arg0: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    wait(arg0: number, arg1: number): void;
    static max(arg0: number, arg1: number): number;
    static "max(double,double)"(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static "multiplyExact(long,int)"(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static "incrementExact(long)"(arg0: number): number;
    static "getExponent(float)"(arg0: number): number;
    static "signum(float)"(arg0: number): number;
    static nextDown(arg0: number): number;
    static "nextAfter(float,double)"(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static "round(double)"(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static "getExponent(double)"(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    hashCode(): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static "floorDiv(long,int)"(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static "nextDown(float)"(arg0: number): number;
    equals(arg0: any): boolean;
    static "signum(double)"(arg0: number): number;
    static "absExact(int)"(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type JavaMath_ = JavaMath;
declare interface FluidAmounts {
    readonly MILLIBUCKET: (1) & (number);
    readonly MB: (1) & (number);
    readonly INGOT: (90) & (number);
    readonly BOTTLE: (250) & (number);
    readonly B: (1000) & (number);
    readonly NUGGET: (10) & (number);
    readonly METAL_BLOCK: (810) & (number);
    readonly BUCKET: (1000) & (number);
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    getClass(): typeof any;
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): Internal.Component;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: Internal.Component_): boolean;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    toString(): string;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    notifyAll(): void;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: Internal.Component_[]): Internal.MutableComponent;
    hashCode(): number;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    wait(): void;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<Internal.Component>): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: Internal.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    wait(arg0: number): void;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type Component_ = Component;
declare namespace Special {
    type Mod = "supermartijn642configlib" | "openpartiesandclaims" | "createdeco" | "cccbridge" | "botarium" | "submergedexplosions" | "modernfix" | "createdieselgenerators" | "cbc_cw" | "create_new_age" | "chat_heads" | "spelunkery" | "cloth_config" | "combatlog" | "embeddium" | "rubidium" | "athena" | "corpse" | "supermartijn642corelib" | "tinkers_battle_spades" | "curios" | "searchables" | "framedblocks" | "dynamic_fps" | "nemos_inventory_sorting" | "jadeaddons" | "krypton" | "toms_storage" | "playerrevive" | "sliceanddice" | "radium" | "create_tweaked_controllers" | "fastload" | "wi_zoom" | "rechiseled" | "fastboot" | "createcobblestone" | "design_decor" | "rechiseledcreate" | "molten_vents" | "corpsecurioscompat" | "fusion" | "vscontrolcraft" | "crafttweaker" | "forge" | "s_a_b" | "createbb" | "jsonthings" | "minecraft" | "overworld_netherite_ore" | "create_nuclear_war" | "smoothchunk" | "voicechat" | "terrablender" | "fabric_api_base" | "mousetweaks" | "nochatreports" | "cubes_without_borders" | "ohthetreesyoullgrow" | "alltheleaks" | "spectrelib" | "corgilib" | "createendertransmission" | "invocore" | "guccivuitton" | "e4mc_minecraft" | "astikorcarts" | "kotlinforforge" | "notenoughanimations" | "flywheel" | "mantle" | "xaerominimap" | "lexiconfig" | "endlessammo" | "toms_peripherals" | "polymorph" | "securitycraft" | "almostunified" | "jei" | "createcontraptionterminals" | "marbledsfirstaid" | "appleskin" | "cbc_at" | "disccord" | "valkyrienskies" | "vs_tournament" | "cosmeticarmorreworked" | "lazrslib" | "treechop" | "cbc_nukes" | "advancedperipherals" | "geckolib" | "taczaddon" | "superflatworldnoslimes" | "connectivity" | "casinocraft" | "immersive_aircraft" | "sophisticatedcore" | "vs_eureka" | "create_tank_defenses" | "ritchiesprojectilelib" | "xaeroworldmap" | "controlling" | "placebo" | "citadel" | "burnt" | "storagedelight" | "sophisticatedbackpacks" | "numismatics" | "create_dragon_lib" | "zetter" | "superbwarfare" | "railways" | "extendedbogeys" | "warborn" | "sodiumoptionsapi" | "melody" | "interiors" | "baguettelib" | "sodiumdynamiclights" | "konkrete" | "create_connected" | "chipped" | "rechiseled_chipped" | "farmersdelight" | "cuffed" | "create_ultimate_factory" | "goprone" | "valkyrien_warium" | "patchouli" | "collective" | "resourcefullib" | "architectury" | "doapi" | "terraform" | "vinery" | "the_vmod" | "brewery" | "computercraft" | "cc_vs" | "aiimprovements" | "cupboard" | "svmp" | "vehiclesofsurvival" | "ccynho" | "panzerkrieg" | "framework" | "camerapture" | "smallships" | "probejs" | "dragnvehicles" | "rhino" | "kubejs" | "taczjs" | "sophisticatedstorage" | "create_tinkers_compat" | "copycats" | "tacz" | "lrtactical" | "tacztweaks" | "create_copper_and_zinc" | "createclothes" | "ashvehicle" | "marbledsarsenal" | "clumps" | "comforts" | "configured" | "mcore" | "lucky77" | "guideme" | "mts" | "saros_road_signs_mod" | "continents" | "toastcontrol" | "valkyrien_ship_schematics" | "valkyrienrelogs" | "azurelib" | "ntgl" | "watut" | "tfmg" | "createpropulsion" | "tconstruct" | "tcintegrations" | "bigcontraptions" | "alexscaves" | "moonlight" | "mixinsquared" | "jade" | "ae2" | "createappliedkinetics" | "creativecore" | "iceberg" | "storagedrawers" | "immersive_paintings" | "create_radar" | "createbigcannons" | "create" | "cgs" | "kubejs_create" | "create_dd" | "vs_clockwork" | "trackwork" | "petrolpark" | "petrolsparts" | "drivebywire" | "coroutil" | "ferritecore" | "yet_another_config_lib_v3" | "cbcmoreshells" | "badoptimizations" | "crusty_chunks" | "simpleradio" | "create_enchantment_industry" | "createaddition" | "tacz_c"
    type Ingredient = "crafttweaker:any" | "crafttweaker:list" | "crafttweaker:transformed" | "crafttweaker:conditioned" | "crafttweaker:partial_tag" | "moonlight:block_type_swap" | "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "mantle:fluid_container" | "mantle:potion" | "farmersdelight:tool_action" | "sophisticatedstorage:base_tier_wooden_storage" | "tconstruct:no_container" | "tconstruct:block_tag" | "tconstruct:material" | "tconstruct:material_value" | "tconstruct:tool_hook" | "create:block_tag_ingredient" | "ntgl:workbench_ingredient";
    type Advancement = "securitycraft:recipes/building_blocks/reinforced_brick_stairs_from_reinforced_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_slab" | "minecraft:recipes/decorations/brick_wall" | "storagedelight:recipes/decorations/crimson_drawer" | "tconstruct:tools/materials_and_you" | "tconstruct:recipes/decorations/common/glass/purple_clear_stained_glass_pane_from_panes" | "minecraft:recipes/building_blocks/polished_deepslate" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "create_connected:recipes/crafting/kinetics/six_way_gearbox" | "securitycraft:recipes/decorations/reinforced_light_blue_carpet" | "framedblocks:recipes/building_blocks/framed_elevated_double_slope_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_smokebox" | "minecraft:husbandry/allay_deliver_item_to_player" | "securitycraft:recipes/building_blocks/reinforced_cobbled_deepslate_slab" | "minecraft:recipes/combat/leather_helmet" | "interiors:recipes/building_blocks/crafting/floor_chair/lime_floor_chair_from_seat" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab" | "ae2:recipes/misc/misc/tank_sky_stone" | "securitycraft:recipes/building_blocks/reinforced_birch_planks" | "farmersdelight:recipes/cooking/mushroom_rice" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_boiler" | "ae2:recipes/misc/block_cutter/stairs/smooth_quartz_stairs" | "minecraft:recipes/decorations/ladder" | "createdeco:recipes/building_blocks/cracked_dusk_brick_stairs_from_cracked_dusk_bricks_stonecutting" | "createdeco:recipes/decorations/light_blue_shipping_container" | "minecraft:recipes/decorations/magenta_stained_glass_pane" | "securitycraft:recipes/building_blocks/reinforced_light_gray_stained_glass" | "copycats:recipes/crafting/copycat_slope" | "create_dd:recipes/create_dd.palettes/cut_dolomite_slab" | "minecraft:recipes/building_blocks/stripped_mangrove_wood" | "sophisticatedstorage:recipes/misc/spruce_chest_from_quark_spruce_chest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal" | "createdeco:recipes/decorations/copper_support_wedge" | "create:recipes/building_blocks/cut_tuff_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_slab_recycling" | "farmersdelight:recipes/food/egg_sandwich" | "sophisticatedstorage:recipes/misc/netherite_shulker_box" | "create:recipes/misc/smelting/ingot_osmium_compat_mekanism" | "tconstruct:recipes/misc/common/materials/manyullyn_nugget_from_ingot" | "create_enchantment_industry:great_publisher" | "createdeco:recipes/decorations/zinc_bars_from_stonecutting" | "createdeco:recipes/building_blocks/short_dean_bricks_from_dean_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_brick_slab_recycling" | "create:recipes/building_blocks/cut_deepslate_brick_stairs" | "sophisticatedstorage:recipes/misc/shulker_box" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_bricks_from_short_verdant_bricks_stonecutting" | "securitycraft:recipes/building_blocks/chiseled_crystal_quartz_from_crystal_quartz_stonecutting" | "create_dd:recipes/create_dd.palettes/small_packed_mud_brick_slab_recycling" | "create:recipes/building_blocks/cut_andesite_brick_stairs" | "smallships:recipes/transportation/bamboo_galley" | "interiors:recipes/building_blocks/crafting/floor_chair/green_floor_chair" | "ae2:recipes/misc/network/cables/dense_smart_fluix_clean" | "tfmg:recipes/building_blocks/cut_galena_brick_slab" | "createdeco:recipes/building_blocks/short_red_bricks_from_long_red_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_slab" | "create_dd:recipes/create_dd.palettes/layered_netherrack_from_stone_types_netherrack_stonecutting" | "create:recipes/misc/crafting/kinetics/vertical_gearboxfrom_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_plated_locometal" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_slab_from_stone_types_packed_mud_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/green_brass_wrapped_locometal" | "farmersdelight:recipes/food/grilled_salmon" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_boiler" | "ae2:recipes/misc/network/parts/import_bus" | "alexscaves:alexscaves/discover_candy_cavity" | "tconstruct:recipes/misc/common/puny_smelting" | "farmersdelight:recipes/decorations/brown_canvas_sign" | "copycats:recipes/crafting/copycat_layer" | "createdeco:recipes/building_blocks/tiled_red_bricks_from_short_red_bricks_stonecutting" | "create:recipes/decorations/brass_bars_from_ingots_brass_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal" | "create:recipes/building_blocks/small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "create:recipes/misc/smelting/zinc_ingot_from_ore" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_wall_from_stone_types_weathered_limestone_stonecutting" | "minecraft:recipes/misc/emerald" | "createdeco:recipes/decorations/iron_catwalk_stairs_from_stonecutting" | "tfmg:recipes/building_blocks/galena_from_stone_types_galena_stonecutting" | "ae2:recipes/misc/decorative/quartz_fixture" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_magnet_upgrade_from_storage_magnet_upgrade" | "create:recipes/building_blocks/cut_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/scoria_from_stone_types_scoria_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_purple_terracotta" | "farmersdelight:recipes/decorations/basket" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "create:recipes/misc/crafting/kinetics/light_gray_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/copycat_headstock_link_and_pin" | "superbwarfare:recipes/misc/steel_spring" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat_from_other_seat" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "securitycraft:recipes/redstone/reinforced_birch_fence_gate" | "minecraft:recipes/misc/copper_ingot_from_blasting_deepslate_copper_ore" | "tconstruct:recipes/decorations/tables/tinker_station" | "create:recipes/misc/crafting/kinetics/chute" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_brass_wrapped_locometal" | "create:recipes/misc/crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "farmersdelight:main/get_rich_soil" | "ae2:recipes/misc/shaped/walls/sky_stone_brick" | "interiors:recipes/building_blocks/crafting/chair/brown_chair_from_seat" | "createdeco:recipes/building_blocks/mossy_pearl_brick_stairs" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_block" | "minecraft:recipes/building_blocks/smooth_quartz_slab" | "tfmg:recipes/building_blocks/polished_cut_galena_wall" | "ae2:recipes/misc/shaped/slabs/sky_stone_small_brick" | "sophisticatedbackpacks:recipes/misc/advanced_feeding_upgrade" | "minecraft:recipes/building_blocks/end_stone_brick_slab" | "createdeco:recipes/building_blocks/long_dean_bricks_from_tiled_dean_bricks_stonecutting" | "spelunkery:recipes/coal_ores" | "minecraft:recipes/decorations/polished_deepslate_wall" | "create:recipes/building_blocks/granite_from_stone_types_granite_stonecutting" | "securitycraft:recipes/redstone/reinforced_jungle_fence_gate" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_dusk_bricks_from_vine" | "create:clockwork_bearing" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_long_dean_bricks_stonecutting" | "minecraft:recipes/decorations/orange_bed" | "superbwarfare:recipes/misc/iron_spring" | "design_decor:recipes/building_blocks/blue_metal_sheet_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_from_reinforced_ingredients" | "create_dd:recipes/create_dd.palettes/crafting/decor/gray_blueprint_block_from_gray_dye" | "minecraft:recipes/food/cooked_chicken_from_campfire_cooking" | "minecraft:recipes/building_blocks/deepslate_bricks" | "superbwarfare:main/handsome_frame" | "createdeco:recipes/building_blocks/blue_brick_slab_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_dean_bricks_stonecutting" | "create:recipes/building_blocks/weathered_copper_shingle_slab_from_weathered_copper_shingles_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_stacked_inner_slope_slab_corner_rotate_to_framed_flat_stacked_inner_slope_panel_corner" | "create:recipes/building_blocks/cut_diorite_brick_wall" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "tconstruct:recipes/misc/common/materials/steel_ingot_from_block" | "securitycraft:recipes/building_blocks/reinforced_diorite_stairs" | "tconstruct:recipes/misc/common/materials/netherite_nugget_from_ingot" | "smallships:recipes/transportation/spruce_cog" | "create:recipes/building_blocks/cut_ochrum_wall" | "sophisticatedstorage:recipes/misc/cherry_chest_from_quark_cherry_chest" | "sophisticatedbackpacks:recipes/misc/deposit_upgrade" | "minecraft:recipes/building_blocks/light_blue_stained_glass" | "framedblocks:recipes/building_blocks/framed_flat_double_slope_slab_corner_from_inverse" | "securitycraft:recipes/building_blocks/reinforced_brick_slab" | "brewery:recipes/sausage" | "create:recipes/misc/crafting/kinetics/elevator_pulley" | "create_dd:recipes/create_dd.palettes/dolomite_pillar_from_stone_types_dolomite_stonecutting" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_lapis_ore" | "securitycraft:recipes/building_blocks/reinforced_white_terracotta" | "sophisticatedstorage:recipes/misc/netherite_shulker_from_netherite_chest" | "smallships:recipes/transportation/acacia_cog" | "tfmg:recipes/building_blocks/small_bauxite_brick_stairs_from_stone_types_bauxite_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_from_brick" | "minecraft:recipes/decorations/light_gray_glazed_terracotta" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper_stairs_from_reinforced_oxidized_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_vine" | "minecraft:recipes/redstone/birch_button" | "minecraft:recipes/building_blocks/jungle_wood" | "minecraft:recipes/combat/netherite_chestplate_smithing" | "securitycraft:recipes/building_blocks/reinforced_nether_brick_wall_from_reinforced_nether_bricks_stonecutting" | "create:recipes/building_blocks/cut_diorite_brick_stairs" | "alexscaves:alexscaves/bioluminescent_torch" | "minecraft:recipes/decorations/purple_glazed_terracotta" | "tconstruct:recipes/misc/tables/pattern" | "minecraft:story/deflect_arrow" | "createdeco:recipes/building_blocks/scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/lime_clear_stained_glass_pane_from_panes" | "alexscaves:alexscaves/burrowing_arrow" | "securitycraft:recipes/decorations/reinforced_glass_pane" | "railways:recipes/misc/crafting/palettes/wrapping/green_copper_wrapped_locometal" | "alexscaves:alexscaves/resistor_shield" | "ae2:recipes/misc/tools/paintballs_purple" | "create:recipes/building_blocks/cut_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_stairs_from_reinforced_end_stone_bricks_stonecutting" | "cgs:recipes/misc/raw_lead" | "createdeco:recipes/building_blocks/dusk_bricks_from_short_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_blue_bricks_from_vine" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_slashed_locometal" | "create_dd:recipes/create_dd.palettes/cut_basalt_brick_slab" | "securitycraft:recipes/decorations/secret_birch_sign_item" | "securitycraft:recipes/decorations/secret_crimson_hanging_sign" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_soul_glass" | "securitycraft:recipes/building_blocks/reinforced_brown_wool" | "brewery:main/get_whiskey_lilitusinglemalt" | "create:recipes/misc/crafting/kinetics/gantry_shaft" | "sophisticatedstorage:recipes/misc/crafting_upgrade" | "create_dd:recipes/create_dd.palettes/pink_padded_mosaic_rubber_from_pink_rubber_decor_stonecutting" | "spelunkery:recipes/glow_ink_sac" | "createdeco:recipes/decorations/zinc_catwalk_railing_from_stonecutting" | "create_dd:recipes/create_dd.palettes/padded_tiled_rubber_from_rubber_decor_stonecutting" | "framedblocks:recipes/building_blocks/framed_button" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_long_blue_brick_stairs_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_purpur_slab_from_reinforced_purpur_block_stonecutting" | "tconstruct:world/earth_island" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_stairs_from_reinforced_polished_blackstone_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/brewing/magma_cream" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_long_pearl_brick_slab_stonecutting" | "create:recipes/building_blocks/cut_scoria_stairs" | "framedblocks:recipes/building_blocks/framed_extended_slope_panel" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_pillar" | "storagedrawers:recipes/storagedrawers/one_stack_upgrade" | "create:recipes/building_blocks/cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/lime_chair_from_seat" | "securitycraft:recipes/building_blocks/reinforced_red_nether_brick_wall_from_reinforced_red_nether_bricks_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_wall_from_stone_types_netherrack_stonecutting" | "minecraft:nether/brew_potion" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_plated_locometal" | "ae2:recipes/misc/network/blocks/cell_workbench" | "createdeco:recipes/decorations/red_andesite_lamp" | "create:recipes/building_blocks/dark_oak_window" | "design_decor:recipes/building_blocks/crimsite_castel_tiles_from_stone_types_crimsite_stonecutting" | "sophisticatedstorage:recipes/misc/light_blue_shulker_box_to_sophisticated" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_brick_wall_from_stone_types_amethyst_block_stonecutting" | "securitycraft:recipes/building_blocks/gold_mine" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:recipes/decorations/purple_stained_glass_pane_from_glass_pane" | "create:recipes/building_blocks/polished_cut_crimsite_wall" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "ae2:recipes/misc/tools/fluix_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/chiseled_scorched_bricks_crafting" | "interiors:recipes/building_blocks/crafting/chair/white_chair_from_seat" | "alexscaves:alexscaves/defeat_caniac" | "minecraft:husbandry/fishy_business" | "tconstruct:recipes/building_blocks/common/glass/cyan_clear_stained_glass" | "crusty_chunks:steel" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_plated_locometal" | "storagedelight:recipes/decorations/glass_dark_oak_cabinet" | "securitycraft:recipes/decorations/reinforced_red_stained_glass_pane_from_dye" | "create:recipes/misc/crafting/kinetics/mechanical_press" | "farmersdelight:recipes/food/cooked_cod_slice_from_smoking" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper_slab" | "minecraft:nether/explore_nether" | "create_dd:recipes/create_dd.palettes/small_gabbro_brick_wall" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "ae2:recipes/misc/network/cells/item_storage_cell_64k" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_stairs_from_honeycomb" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_plated_locometal" | "ae2:recipes/misc/network/upgrade_wireless_crafting_terminal" | "securitycraft:recipes/building_blocks/reinforced_blue_ice" | "minecraft:recipes/building_blocks/polished_diorite" | "create:recipes/decorations/brass_ladder_from_ingots_brass_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "create:recipes/misc/crafting/kinetics/rope_pulley" | "minecraft:recipes/building_blocks/raw_iron_block" | "design_decor:recipes/building_blocks/red_metal_plate_stairs_from_metal_plate_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/polished_cut_veridium_from_stone_types_veridium_stonecutting" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_3_from_limited_copper_barrel_3" | "superbwarfare:recipes/combat/rpg_smithing" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_wall_from_stone_types_amethyst_block_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab_from_mud_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/acacia_barrel" | "tconstruct:recipes/redstone/world/wood/skyroot/door" | "framedblocks:recipes/building_blocks/framed_vertical_sloped_stairs" | "farmersdelight:recipes/decorations/mangrove_cabinet" | "numismatics:recipes/misc/crafting/magenta_card" | "create:recipes/building_blocks/crafting/kinetics/green_seat_from_other_seat" | "create:recipes/building_blocks/polished_cut_tuff_from_stone_types_tuff_stonecutting" | "tfmg:recipes/building_blocks/polished_cut_galena_stairs_from_stone_types_galena_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_riveted_locometal" | "ae2:recipes/misc/tools/portable_fluid_cell_4k" | "railways:recipes/misc/crafting/palettes/wrapping/lime_copper_wrapped_locometal" | "design_decor:recipes/building_blocks/ochrum_castel_brick_wall_from_stone_types_ochrum_stonecutting" | "design_decor:recipes/building_blocks/blue_metal_sheet_wall_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_long_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/decorations/industrial_iron_support_wedge" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_stonecutting" | "advancedperipherals:recipes/redstone/inventory_manager" | "framedblocks:recipes/building_blocks/framed_ext_inner_double_corner_slope_panel" | "minecraft:recipes/decorations/blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/netherite_scrap_from_blasting" | "create:glass_pipe" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_long_blue_bricks_stonecutting" | "minecraft:recipes/combat/diamond_sword" | "minecraft:recipes/decorations/cyan_stained_glass_pane" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet_from_netherite" | "superbwarfare:recipes/combat/javelin_smithing" | "minecraft:recipes/building_blocks/stripped_warped_hyphae" | "minecraft:recipes/decorations/jukebox" | "ae2:recipes/misc/block_cutter/stairs/smooth_sky_stone_stairs" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_slashed_locometal" | "minecraft:recipes/misc/silence_armor_trim_smithing_template_smithing_trim" | "tconstruct:recipes/building_blocks/world/wood/enderbark/log_to_wood" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/slab" | "framedblocks:recipes/building_blocks/framed_corner_strip_from_framed_wall_board" | "minecraft:recipes/misc/gold_nugget" | "securitycraft:recipes/decorations/reinforced_pink_stained_glass_pane" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_part" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_from_stone_types_dolomite_stonecutting" | "ae2:recipes/misc/network/blocks/quantum_link" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_plated_locometal" | "securitycraft:recipes/misc/scanner_trapdoor" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "minecraft:nether/all_effects" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_stairs_from_reinforced_deepslate_tiles_stonecutting" | "ae2:recipes/misc/decorative/certus_quartz_bricks" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_riveted_locometal" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "securitycraft:recipes/building_blocks/reinforced_prismarine_wall_from_reinforced_prismarine_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_short_dean_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/red_padded_tiled_rubber_from_red_rubber_decor_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_smokebox" | "railways:recipes/misc/crafting/track_switch_brass" | "create_dd:recipes/create_dd.palettes/black_padded_tiled_rubber_from_black_rubber_decor_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal_boiler" | "dragnvehicles:recipes/misc/sports_wheel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_pillar" | "tfmg:recipes/building_blocks/polished_cut_bauxite_slab_from_stone_types_bauxite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/white_glazed_terracotta" | "minecraft:recipes/combat/iron_helmet" | "minecraft:recipes/tools/golden_shovel" | "create_dd:recipes/create_dd.palettes/red_padded_mosaic_rubber_from_red_rubber_decor_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_wall" | "computercraft:recipes/redstone/printer" | "alexscaves:alexscaves/tame_subterranodon" | "minecraft:recipes/building_blocks/dye_magenta_carpet" | "design_decor:recipes/building_blocks/horizontal_tinted_framed_glass_from_glass_tinted_stonecutting" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_verdant_bricks_stonecutting" | "copycats:recipes/crafting/copycat_iron_trapdoor" | "create:recipes/misc/crafting/kinetics/smart_chute" | "create:recipes/building_blocks/polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal" | "createdeco:recipes/decorations/industrial_iron_bars_from_stonecutting" | "minecraft:recipes/food/beetroot_soup" | "storagedelight:recipes/decorations/birch_cabinet_with_glass_doors" | "securitycraft:recipes/building_blocks/reinforced_smooth_red_sandstone_stairs_from_reinforced_smooth_red_sandstone_stonecutting" | "createdeco:recipes/decorations/brass_bars_overlay" | "storagedelight:recipes/decorations/mangrove_drawer_with_door" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_smokebox" | "design_decor:recipes/building_blocks/black_metal_plate_from_metal_plate_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_dolomite_from_stone_types_dolomite_stonecutting" | "minecraft:recipes/food/golden_apple" | "securitycraft:recipes/decorations/reinforced_lime_carpet" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_stairs" | "ae2:recipes/misc/misc/fluixpearl" | "minecraft:recipes/building_blocks/orange_stained_glass" | "securitycraft:recipes/decorations/reinforced_deepslate_tile_wall" | "railways:recipes/misc/crafting/palettes/wrapping/purple_brass_wrapped_locometal" | "ae2:recipes/misc/tools/portable_fluid_cell_1k" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_long_pearl_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_riveted_locometal" | "create_dd:recipes/create_dd.palettes/small_netherrack_brick_wall" | "securitycraft:recipes/building_blocks/reinforced_cut_copper_slab_from_reinforced_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_stairs_from_stone_types_amethyst_block_stonecutting" | "minecraft:adventure/two_birds_one_arrow" | "framedblocks:recipes/building_blocks/framed_iron_trapdoor" | "minecraft:recipes/decorations/end_crystal" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "farmersdelight:recipes/food/melon_popsicle" | "ae2:recipes/misc/network/crafting/256k_cpu_crafting_storage" | "securitycraft:recipes/redstone/reinforced_stone_pressure_plate" | "tconstruct:smeltery/melter" | "sophisticatedstorage:recipes/misc/dark_oak_barrel" | "createdeco:recipes/decorations/brass_catwalk_stairs_from_stonecutting" | "create:root" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal" | "superbwarfare:recipes/misc/rpg_blueprint" | "tconstruct:recipes/building_blocks/common/glass/light_blue_clear_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_riveted_locometal" | "createdeco:recipes/building_blocks/dusk_bricks_from_long_dusk_bricks_stonecutting" | "create:train_crash_backwards" | "create:recipes/building_blocks/exposed_copper_tile_stairs" | "minecraft:recipes/decorations/soul_lantern" | "create_dd:recipes/create_dd.palettes/cut_stone_brick_wall_from_stone_types_stone_stonecutting" | "tcintegrations:recipes/misc/bronze_ingot_from_nuggets" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template" | "minecraft:recipes/decorations/cherry_fence" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_short_blue_bricks_stonecutting" | "minecraft:recipes/decorations/birch_fence" | "minecraft:recipes/decorations/sandstone_wall_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/andesite_door" | "interiors:recipes/building_blocks/crafting/floor_chair/light_gray_floor_chair" | "securitycraft:recipes/building_blocks/reinforced_crimson_planks" | "sophisticatedbackpacks:recipes/misc/advanced_refill_upgrade" | "ae2:recipes/misc/network/cells/spatial_components_1" | "createdeco:recipes/building_blocks/mossy_red_brick_slab" | "ae2:recipes/misc/network/cells/spatial_components_0" | "minecraft:recipes/combat/golden_boots" | "railways:recipes/misc/crafting/link_and_pin" | "computercraft:recipes/redstone/wireless_modem_advanced" | "minecraft:recipes/tools/wooden_axe" | "farmersdelight:recipes/food/beef_patty_from_campfire_cooking" | "marbledsfirstaid:marbleds_first_aid/tis_but_a_scratch" | "tconstruct:recipes/decorations/world/wood/enderbark/hanging_sign" | "tconstruct:recipes/redstone/smeltery/scorched/gauge" | "minecraft:recipes/building_blocks/chiseled_sandstone" | "computercraft:recipes/redstone/wired_modem_full_to" | "create_connected:recipes/crafting/kinetics/six_way_gearbox_from_gearbox" | "create:recipes/building_blocks/cut_limestone_slab" | "ae2:recipes/misc/network/cables/dense_smart_light_gray" | "interiors:recipes/building_blocks/crafting/chair/purple_chair_from_other_chair" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_stairs_from_stone_types_basalt_stonecutting" | "sophisticatedstorage:recipes/misc/chipped/botanist_workbench_upgrade" | "alexscaves:alexscaves/frostmint_explosion" | "createdeco:recipes/decorations/light_gray_placard" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:potato_cannon" | "create:recipes/misc/crafting/kinetics/spout" | "create_dd:recipes/create_dd.palettes/cut_basalt_slab" | "framedblocks:recipes/building_blocks/framed_soul_torch" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed" | "interiors:recipes/building_blocks/crafting/chair/gray_chair_from_floor_chair" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "create:recipes/building_blocks/cut_deepslate_from_stone_types_deepslate_stonecutting" | "copycats:recipes/crafting/copycat_vertical_half_layer" | "framedblocks:recipes/building_blocks/framed_flat_inv_double_slope_slab_corner" | "minecraft:recipes/decorations/yellow_stained_glass_pane" | "spelunkery:spelunkery/glowstick" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/granite_slab_from_granite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal_boiler" | "marbledsfirstaid:marbleds_first_aid/pills_here" | "create:recipes/building_blocks/cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_1" | "interiors:recipes/building_blocks/crafting/chair/yellow_chair_from_floor_chair" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_wall" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_2" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_3" | "sophisticatedstorage:recipes/misc/bamboo_limited_barrel_4" | "framedblocks:recipes/building_blocks/framed_large_double_corner_slope_panel" | "tconstruct:recipes/misc/common/materials/cinderslime_nugget_from_ingot" | "securitycraft:recipes/decorations/floor_trap" | "securitycraft:recipes/building_blocks/reinforced_mud_bricks" | "superbwarfare:recipes/misc/mp_443_blueprint" | "create:recipes/building_blocks/polished_cut_scoria_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/small_tuff_brick_slab_recycling" | "tconstruct:smeltery/gold_casting" | "minecraft:recipes/building_blocks/cut_sandstone" | "minecraft:recipes/building_blocks/smooth_red_sandstone" | "minecraft:recipes/decorations/blackstone_wall" | "casinocraft:recipes/decorations/wool_gray" | "minecraft:recipes/misc/cyan_dye_from_pitcher_plant" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_long_red_brick_stairs_stonecutting" | "sophisticatedstorage:recipes/misc/gold_shulker_from_gold_chest" | "ae2:recipes/misc/network/cables/covered_brown" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cut_red_sandstone_slab" | "storagedelight:recipes/decorations/small_bamboo_drawers" | "create:chained_drain" | "farmersdelight:recipes/cooking/chicken_soup" | "minecraft:recipes/decorations/purple_candle" | "create:recipes/building_blocks/crafting/kinetics/blue_seat" | "minecraft:recipes/decorations/pink_glazed_terracotta" | "minecraft:recipes/misc/coal" | "minecraft:recipes/transportation/spruce_chest_boat" | "create_dd:recipes/create_dd.palettes/magenta_padded_rubber_stairs_from_magenta_rubber_decor_stonecutting" | "smallships:recipes/transportation/jungle_cog" | "sophisticatedstorage:recipes/misc/pink_shulker_box_to_sophisticated" | "createdeco:recipes/building_blocks/blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "tfmg:recipes/building_blocks/small_galena_bricks_from_stone_types_galena_stonecutting" | "minecraft:recipes/combat/leather_chestplate" | "numismatics:recipes/misc/crafting/orange_id_card" | "ae2:recipes/misc/network/cells/item_storage_cell_256k" | "minecraft:recipes/misc/magenta_dye_from_blue_red_pink" | "tconstruct:recipes/redstone/world/wood/enderbark/fence_gate" | "securitycraft:recipes/building_blocks/reinforced_quartz_bricks" | "minecraft:recipes/decorations/yellow_candle" | "numismatics:recipes/misc/crafting/light_gray_card" | "sophisticatedstorage:recipes/misc/jukebox_upgrade" | "minecraft:nether/obtain_blaze_rod" | "superbwarfare:recipes/misc/mk_42_blueprint" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_riveted_locometal" | "ae2:recipes/misc/network/cables/dense_smart_white" | "interiors:recipes/building_blocks/crafting/chair/white_chair_from_other_chair" | "create:recipes/building_blocks/cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/placard" | "createdeco:recipes/building_blocks/tiled_dusk_bricks_from_short_dusk_bricks_stonecutting" | "immersive_aircraft:misc/aircraftery" | "create:recipes/building_blocks/small_tuff_brick_wall" | "alexscaves:alexscaves/summon_luxtructosaurus" | "storagedelight:recipes/decorations/warped_drawer_with_door" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_iron_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "minecraft:adventure/shoot_arrow" | "securitycraft:recipes/misc/cyan_lens" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_slashed_locometal" | "framedblocks:recipes/building_blocks/framed_stacked_slope_edge" | "minecraft:recipes/building_blocks/polished_blackstone_stairs" | "createdeco:recipes/decorations/industrial_iron_hull_from_stonecutting" | "createdeco:recipes/decorations/decal_up" | "sophisticatedstorage:recipes/misc/gold_to_netherite_tier_upgrade" | "create:recipes/misc/smelting/lead_ingot_compat_thermal" | "computercraft:recipes/redstone/pocket_normal/computercraft/speaker" | "create:recipes/building_blocks/cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_slab_recycling" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab" | "createdeco:recipes/building_blocks/dean_brick_slab_from_long_dean_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_boiler" | "farmersdelight:recipes/food/fried_egg_from_campfire_cooking" | "createdeco:recipes/decorations/zinc_mesh_fence_from_stonecutting" | "minecraft:recipes/decorations/pink_candle" | "ae2:recipes/misc/network/cables/smart_gray" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_brick_slab" | "minecraft:recipes/building_blocks/deepslate_brick_stairs" | "create:recipes/building_blocks/small_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/light_blue_bed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/wrapping/white_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal" | "ae2:recipes/misc/network/wireless_part" | "securitycraft:recipes/building_blocks/deepslate_copper_mine" | "createdeco:recipes/building_blocks/mossy_scarlet_bricks_from_vine" | "create_dd:recipes/create_dd.palettes/crafting/decor/black_asphalt_block" | "design_decor:recipes/building_blocks/deepslate_castel_brick_slab_from_stone_types_deepslate_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_elev_slope_slab_corner" | "minecraft:recipes/decorations/purple_stained_glass_pane" | "minecraft:recipes/building_blocks/brick_stairs_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "create:hand_crank_000" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/covered_fluix_clean" | "minecraft:nether/charge_respawn_anchor" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper_slab_from_reinforced_weathered_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/bamboo_planks" | "design_decor:recipes/building_blocks/limestone_castel_tile_wall_from_stone_types_limestone_stonecutting" | "create:mechanical_mixer" | "create_connected:brass_gearbox" | "sophisticatedstorage:recipes/misc/iron_shulker_box" | "minecraft:recipes/decorations/crafting_table" | "create:recipes/misc/crafting/kinetics/portable_storage_interface" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_short_red_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_copper_block_stonecutting" | "minecraft:recipes/decorations/chest" | "minecraft:story/shiny_gear" | "createdeco:recipes/building_blocks/mossy_dusk_brick_slab" | "create:recipes/misc/blasting/ingot_tin_compat_ic2" | "create_dd:recipes/create_dd.palettes/crafting/decor/gray_blueprint_block" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_from_stone_types_weathered_limestone_stonecutting" | "minecraft:recipes/misc/stick" | "minecraft:recipes/redstone/crimson_pressure_plate" | "create:funnel" | "superbwarfare:recipes/misc/insidious_blueprint" | "minecraft:recipes/redstone/polished_blackstone_button" | "copycats:recipes/crafting/copycat_beam" | "tconstruct:recipes/misc/common/materials/queens_slime_ingot_from_nuggets" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_riveted_locometal" | "create:recipes/building_blocks/cut_andesite_slab" | "createdeco:recipes/decorations/cyan_placard" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_smokebox" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_stairs" | "create_dd:recipes/create_dd.palettes/white_padded_rubber_slab_from_white_rubber_decor_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal_boiler" | "sophisticatedstorage:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "superbwarfare:recipes/misc/hk_416_blueprint" | "securitycraft:recipes/building_blocks/reinforced_packed_mud" | "design_decor:recipes/building_blocks/orange_metal_plate_from_metal_plate_stonecutting" | "superbwarfare:recipes/misc/glock_17_blueprint" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_stairs_from_cracked_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal" | "brewery:recipes/fried_chicken" | "computercraft:recipes/redstone/turtle_normal_overlays/turtle_trans_overlay" | "securitycraft:recipes/building_blocks/reinforced_cobblestone_stairs" | "create:recipes/misc/crafting/kinetics/steam_engine" | "minecraft:recipes/building_blocks/pink_terracotta" | "spelunkery:spelunkery/conk_fungus" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "minecraft:adventure/summon_iron_golem" | "securitycraft:recipes/building_blocks/reinforced_cyan_terracotta" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_wall_from_reinforced_polished_blackstone_stonecutting" | "create:recipes/building_blocks/weathered_copper_shingle_stairs" | "create_dd:recipes/create_dd.palettes/green_padded_rubber_stairs_from_green_rubber_decor_stonecutting" | "tconstruct:recipes/decorations/common/copper_platform" | "create:recipes/building_blocks/cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/weathered_copper_shingle_slab" | "ae2:recipes/misc/network/parts/panels_monitor" | "ae2:recipes/misc/tools/fluix_upgrade_smithing_template" | "framedblocks:recipes/building_blocks/framed_slope_slab" | "create_dd:recipes/create_dd.base/item_stockpile_from_item_vault_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_slab_from_honeycomb" | "create:recipes/building_blocks/cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_brick_stairs" | "minecraft:recipes/misc/storage_output_from_input" | "minecraft:recipes/redstone/lectern" | "tfmg:recipes/building_blocks/small_bauxite_brick_stairs" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_from_stone_types_amethyst_block_stonecutting" | "create:recipes/building_blocks/cut_crimsite_brick_slab_recycling" | "minecraft:recipes/building_blocks/stone_stairs_from_stone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_smooth_sandstone_slab_from_reinforced_smooth_sandstone_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_purple_and_pink" | "minecraft:recipes/decorations/mossy_stone_brick_wall" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "copycats:recipes/crafting/copycat_stairs_from_conversion" | "create:recipes/building_blocks/polished_cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper" | "alexscaves:alexscaves/seeking_arrow" | "sophisticatedstorage:recipes/misc/storage_pickup_upgrade_from_backpack_pickup_upgrade" | "create:recipes/building_blocks/horizontal_framed_glass_from_glass_colorless_stonecutting" | "minecraft:adventure/sleep_in_bed" | "minecraft:recipes/food/cooked_rabbit_from_campfire_cooking" | "create:recipes/building_blocks/cut_scorchia_brick_slab" | "alexscaves:alexscaves/root" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper_slab_from_reinforced_oxidized_copper_stonecutting" | "minecraft:recipes/decorations/birch_sign" | "minecraft:recipes/transportation/cherry_boat" | "create_connected:recipes/crafting/palettes/copycat_fence_compat" | "createdeco:recipes/decorations/red_shipping_container" | "createbigcannons:recipes/misc/nethersteel_ingot_from_nuggets" | "storagedrawers:recipes/storagedrawers/dark_oak_drawers" | "copycats:recipes/crafting/copycat_step_from_conversion" | "interiors:recipes/building_blocks/crafting/chair/light_blue_chair_from_floor_chair" | "tconstruct:recipes/combat/tools/armor/travelers_boots" | "minecraft:recipes/tools/diamond_pickaxe" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "minecraft:recipes/decorations/brown_glazed_terracotta" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite_stairs" | "storagedrawers:recipes/storagedrawers/illumination_upgrade" | "createdeco:recipes/building_blocks/scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "vinery:recipes/fermentation_barrel" | "create:recipes/building_blocks/oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/white_blueprint_block" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat" | "minecraft:adventure/voluntary_exile" | "minecraft:recipes/decorations/granite_wall_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_granite" | "sophisticatedstorage:recipes/misc/storage_advanced_magnet_upgrade_from_backpack_advanced_magnet_upgrade" | "design_decor:recipes/building_blocks/lime_metal_plate_slab_from_metal_plate_stonecutting" | "farmersdelight:recipes/food/cabbage_from_leaves" | "createdeco:recipes/misc/industrial_iron_ingot" | "createdeco:recipes/building_blocks/blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_nether_brick_stairs_from_reinforced_nether_bricks_stonecutting" | "astikorcarts:recipes/supply_cart" | "storagedrawers:recipes/storagedrawers/remote_upgrade" | "create:recipes/misc/crafting/kinetics/gearbox" | "minecraft:recipes/building_blocks/cherry_planks" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_from_stone_types_amethyst_block_stonecutting" | "createdeco:recipes/decorations/brass_bars" | "create:recipes/building_blocks/polished_cut_scoria_slab" | "createdeco:recipes/decorations/iron_catwalk_from_stonecutting" | "securitycraft:recipes/decorations/reinforced_gray_stained_glass_pane_from_dye" | "create:recipes/building_blocks/polished_cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/combat/golden_chestplate" | "design_decor:recipes/building_blocks/tuff_castel_bricks_from_stone_types_tuff_stonecutting" | "tconstruct:recipes/combat/gadgets/shuriken/flint_shuriken" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_pickaxe" | "securitycraft:recipes/building_blocks/reinforced_sandstone_stairs_from_reinforced_sandstone_stonecutting" | "createdeco:recipes/building_blocks/cracked_dean_brick_stairs" | "sophisticatedbackpacks:recipes/misc/feeding_upgrade" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_stairs_from_stone_types_packed_mud_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_prismarine_stairs_from_reinforced_prismarine_stonecutting" | "create:recipes/misc/crafting/logistics/brass_tunnel" | "framedblocks:recipes/building_blocks/framed_stone_button" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_slab_from_stone_types_stone_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "toms_storage:unlock_netherite" | "create_dd:recipes/create_dd.palettes/cut_gabbro_stairs" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_wall" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_pillar" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_stairs_from_stone_types_dolomite_stonecutting" | "farmersdelight:recipes/food/bacon_sandwich" | "sophisticatedstorage:recipes/misc/backpack_chipped_mason_table_upgrade_from_storage_chipped_mason_table_upgrade" | "minecraft:recipes/misc/red_dye_from_poppy" | "create_dd:recipes/create_dd.palettes/cut_stone_brick_slab_recycling" | "minecraft:recipes/building_blocks/clay" | "create:recipes/building_blocks/small_granite_brick_stairs" | "create:mechanical_crafter" | "tconstruct:recipes/redstone/smeltery/scorched/ingot_gauge" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k_storage" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "create:recipes/misc/blasting/iron_ingot_from_crushed" | "vinery:recipes/mangrove_wine_rack_small" | "camerapture:recipes/album" | "create:recipes/building_blocks/small_dripstone_brick_slab" | "mts:custombench" | "createdeco:recipes/building_blocks/cracked_pearl_bricks_from_pearl_bricks_blasting" | "minecraft:recipes/transportation/mangrove_chest_boat" | "sophisticatedstorage:recipes/misc/storage_output" | "minecraft:recipes/decorations/gray_carpet" | "ae2:recipes/misc/tools/paintballs_red" | "design_decor:recipes/building_blocks/light_gray_metal_sheet_from_metal_plate_stonecutting" | "minecraft:recipes/decorations/deepslate_tile_wall" | "minecraft:recipes/redstone/tripwire_hook" | "create:recipes/misc/crafting/kinetics/wooden_bracket" | "create:recipes/misc/crafting/kinetics/weighted_ejector" | "securitycraft:recipes/building_blocks/reinforced_andesite_stairs_from_reinforced_andesite_stonecutting" | "securitycraft:recipes/decorations/secret_dark_oak_sign_item" | "comforts:sleeping_bag_brown" | "createdeco:recipes/building_blocks/mossy_blue_brick_stairs_from_mossy_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_short_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/andesite_window_pane" | "create:recipes/misc/smelting/zinc_ingot_from_raw_ore" | "minecraft:recipes/building_blocks/packed_mud" | "create_dd:recipes/create_dd.palettes/purple_padded_rubber_slab_from_purple_rubber_decor_stonecutting" | "createdeco:recipes/decorations/decal_warning" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "securitycraft:recipes/redstone/reinforced_birch_pressure_plate" | "minecraft:recipes/building_blocks/smooth_sandstone_slab" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "securitycraft:recipes/decorations/secret_mangrove_sign_item" | "ae2:recipes/misc/network/wireless_crafting_terminal" | "minecraft:recipes/building_blocks/blue_terracotta" | "tconstruct:recipes/misc/common/materials/steel_nugget_from_ingot" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_bricks_from_stone_types_weathered_limestone_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_from_smart" | "securitycraft:recipes/building_blocks/reinforced_andesite_slab_from_reinforced_andesite_stonecutting" | "smallships:recipes/transportation/oak_drakkar" | "vinery:recipes/dirt_slab" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_riveted_locometal" | "create_dd:recipes/create_dd.palettes/crafting/decor/brown_blueprint_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_slashed_locometal" | "computercraft:recipes/redstone/speaker" | "spelunkery:recipes/tangle_roots" | "minecraft:recipes/building_blocks/cut_red_sandstone" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/battery_upgrade" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_verdant_bricks_from_vine" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal_boiler" | "minecraft:recipes/decorations/purple_carpet" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_slab" | "ae2:recipes/misc/tools/portable_fluid_cell_16k" | "create:recipes/building_blocks/polished_cut_granite_wall" | "minecraft:recipes/misc/netherite_ingot" | "create:recipes/building_blocks/small_granite_brick_stairs_from_stone_types_granite_stonecutting" | "framedblocks:recipes/building_blocks/framed_prism_corner" | "advancedperipherals:recipes/redstone/weak_automata_core" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_pillar" | "sophisticatedstorage:recipes/misc/backpack_filter_upgrade_from_storage_filter_upgrade" | "tconstruct:recipes/misc/common/materials/steel_ingot_from_nuggets" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_brick_stairs_from_stone_types_weathered_limestone_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs" | "createdeco:recipes/misc/industrial_iron_nugget_from_industrial_iron_ingot" | "create_dd:recipes/create_dd.palettes/small_blackstone_brick_slab_from_stone_types_blackstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_riveted_locometal" | "create:recipes/building_blocks/cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_gray_carpet_from_dye" | "railways:recipes/misc/crafting/palettes/wrapping/purple_iron_wrapped_locometal" | "ae2:recipes/misc/decorative/quartz_vibrant_glass" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "design_decor:recipes/building_blocks/calcite_castel_bricks_from_stone_types_calcite_stonecutting" | "securitycraft:recipes/transportation/track_mine" | "superbwarfare:recipes/combat/awm_smithing" | "railways:recipes/misc/stonecutting/palettes/cycling/green_riveted_locometal" | "securitycraft:recipes/building_blocks/reinforced_purpur_pillar" | "sophisticatedbackpacks:recipes/misc/advanced_deposit_upgrade" | "createdeco:recipes/decorations/yellow_placard_from_dyeing" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_umber_bricks_stonecutting" | "design_decor:recipes/building_blocks/tuff_castel_tile_wall_from_stone_types_tuff_stonecutting" | "create:recipes/misc/crafting/kinetics/large_water_wheel" | "minecraft:adventure/trade_at_world_height" | "createdeco:recipes/decorations/gray_shipping_container" | "tconstruct:recipes/misc/common/materials/pig_iron_ingot_from_block" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_riveted_locometal" | "storagedrawers:recipes/storagedrawers/cherry_drawers" | "minecraft:recipes/decorations/light_blue_stained_glass_pane_from_glass_pane" | "interiors:recipes/building_blocks/crafting/chair/gray_chair_from_other_chair" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/acacia_stairs" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_short_red_bricks_stonecutting" | "create:recipes/building_blocks/small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_slashed_locometal" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal" | "brewery:main/get_dried_corn" | "create:recipes/building_blocks/small_veridium_brick_stairs" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "createbb:p1/obtain_sudafed" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_red_carpet_from_dye" | "create:recipes/misc/crafting/materials/andesite_alloy" | "createdeco:recipes/building_blocks/tiled_scarlet_bricks_from_long_scarlet_bricks_stonecutting" | "farmersdelight:recipes/cooking/baked_cod_stew" | "securitycraft:recipes/redstone/reinforced_crimson_pressure_plate" | "securitycraft:recipes/building_blocks/reinforced_andesite_with_vanilla_cobblestone" | "securitycraft:recipes/building_blocks/reinforced_smooth_sandstone_slab" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "alexscaves:alexscaves/ominous_catalyst" | "farmersdelight:recipes/combat/golden_knife" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "computercraft:recipes/redstone/computer_advanced" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_wall_from_stone_types_stone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_slab_from_reinforced_crystal_quartz_block_stonecutting" | "minecraft:recipes/decorations/candle" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_1" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_2" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal_boiler" | "computercraft:recipes/redstone/turtle_advanced/computercraft/wireless_modem_advanced" | "createdeco:recipes/decorations/andesite_mesh_fence_from_stonecutting" | "minecraft:recipes/misc/bone_meal_from_bone_block" | "securitycraft:recipes/building_blocks/reinforced_prismarine_slab" | "create:recipes/building_blocks/cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "create_dd:recipes/create_dd.palettes/small_packed_mud_bricks_from_stone_types_packed_mud_stonecutting" | "dragnvehicles:recipes/misc/classic_body" | "storagedrawers:recipes/storagedrawers/personal_key_cofh" | "create_dd:recipes/create_dd.palettes/small_stone_brick_wall" | "sophisticatedstorage:recipes/misc/storage_stonecutter_upgrade_from_backpack_stonecutter_upgrade" | "minecraft:nether/create_full_beacon" | "ae2:recipes/misc/tools/paintballs_lumen_gray" | "create_dd:recipes/create_dd.palettes/cut_gabbro_brick_wall" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_3" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_4" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_5" | "create:recipes/building_blocks/small_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/iron_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/green_padded_tiled_rubber_from_green_rubber_decor_stonecutting" | "tconstruct:recipes/redstone/smeltery/seared/ingot_tank" | "framedblocks:recipes/building_blocks/framed_vertical_stairs" | "farmersdelight:recipes/building_blocks/rice_bale" | "create_dd:recipes/create_dd.palettes/small_blackstone_brick_stairs_from_stone_types_blackstone_stonecutting" | "createdeco:recipes/decorations/industrial_iron_support_wedge_from_stonecutting" | "securitycraft:recipes/misc/brown_lens" | "sophisticatedstorage:recipes/misc/double_netherite_chest" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "securitycraft:recipes/decorations/reinforced_gray_stained_glass_pane" | "create:recipes/misc/crafting/logistics/brass_funnel" | "alexscaves:alexscaves/cave_map" | "minecraft:recipes/building_blocks/birch_slab" | "minecraft:recipes/misc/raw_gold" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_pillar" | "sophisticatedstorage:recipes/misc/mangrove_chest_from_quark_mangrove_chest" | "superbwarfare:recipes/combat/marlin_smithing" | "create:potato_cannon_collide" | "minecraft:recipes/decorations/oak_hanging_sign" | "securitycraft:recipes/building_blocks/crystal_quartz_stairs" | "minecraft:recipes/building_blocks/dye_lime_carpet" | "create:recipes/building_blocks/small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs" | "cgs:recipes/misc/lead_ingot_from_lead_nugget" | "tconstruct:recipes/tools/tools/building/ender_staff" | "minecraft:recipes/misc/leather_horse_armor" | "create_dd:recipes/create_dd.palettes/small_dolomite_brick_slab_recycling" | "createdeco:recipes/decorations/locked_zinc_door" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite_slab_from_reinforced_andesite_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_from_stone_types_weathered_limestone_stonecutting" | "tconstruct:recipes/redstone/smeltery/scorched/fuel_gauge" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_cut_sandstone_stonecutting" | "alexscaves:alexscaves/defeat_gloomoth" | "storagedelight:recipes/decorations/glass_spruce_cabinet" | "storagedelight:recipes/decorations/jungle_bookshelf_with_door" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_1" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_2" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_3" | "sophisticatedstorage:recipes/misc/limited_diamond_barrel_4" | "minecraft:recipes/transportation/oak_chest_boat" | "farmersdelight:recipes/decorations/blue_hanging_canvas_sign" | "securitycraft:recipes/building_blocks/reinforced_smooth_basalt" | "createdeco:recipes/decorations/decal_electrical" | "tfmg:recipes/building_blocks/cut_bauxite_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_slashed_locometal" | "superbwarfare:recipes/misc/m_2_hb_blueprint" | "farmersdelight:recipes/cooking/apple_cider" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_acacia_slab" | "design_decor:recipes/building_blocks/white_metal_plate_from_metal_plate_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_waxed_copper_block" | "framedblocks:recipes/building_blocks/framed_large_button" | "securitycraft:recipes/building_blocks/copper_mine" | "createdeco:recipes/decorations/gray_placard_from_dyeing" | "securitycraft:recipes/misc/gray_lens" | "createdeco:recipes/building_blocks/tiled_umber_bricks_from_long_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "create:recipes/misc/crafting/appliances/copper_diving_helmet" | "sophisticatedstorage:recipes/misc/compacting_upgrade" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_stairs_from_reinforced_end_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_smokebox" | "superbwarfare:recipes/misc/marlin_blueprint" | "minecraft:recipes/misc/tide_armor_trim_smithing_template" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_slab" | "interiors:recipes/building_blocks/crafting/chair/light_gray_chair_from_seat" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_short_dean_bricks_stonecutting" | "ae2:recipes/misc/network/parts/quartz_fiber_part" | "minecraft:recipes/tools/diamond_hoe" | "securitycraft:recipes/building_blocks/iron_mine" | "minecraft:recipes/building_blocks/dark_oak_stairs" | "securitycraft:recipes/decorations/display_case" | "createdeco:recipes/building_blocks/short_dusk_brick_slab" | "create_connected:recipes/crafting/kinetics/overstress_clutch" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_pillar" | "tconstruct:recipes/misc/common/materials/slimesteel_ingot_from_block" | "minecraft:recipes/building_blocks/granite_slab" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_honeycomb" | "smallships:recipes/transportation/jungle_brigg" | "minecraft:nether/uneasy_alliance" | "design_decor:recipes/building_blocks/granite_castel_tile_wall_from_stone_types_granite_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/dark_metal_brick_stairs_from_dark_metal_brick_stairs" | "toms_storage:unlock_chest" | "farmersdelight:recipes/misc/book_from_canvas" | "framedblocks:recipes/building_blocks/framed_iron_door" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "farmersdelight:main/eat_comfort_food" | "minecraft:recipes/redstone/redstone_from_blasting_redstone_ore" | "create:recipes/building_blocks/cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal_boiler" | "vinery:recipes/birch_wine_rack_small" | "railways:recipes/misc/crafting/palettes/wrapping/brown_brass_wrapped_locometal" | "farmersdelight:main/plant_all_crops" | "create:recipes/misc/blasting/ingot_tin_compat_mekanism" | "create:recipes/building_blocks/cut_granite_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_bricks_from_umber_bricks_stonecutting" | "advancedperipherals:recipes/redstone/overpowered_husbandry_automata_core" | "superbwarfare:recipes/misc/legendary_material_pack" | "railways:recipes/transportation/benchcart" | "alexscaves:alexscaves/nuclear_furnace_component" | "superbwarfare:recipes/misc/steel_trigger" | "tconstruct:recipes/misc/common/slime/ichor/crystal_growing" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal_boiler" | "create_connected:recipes/crafting/kinetics/redstone_link_from_conversion" | "ae2:recipes/misc/decorative/chiseled_quartz_block" | "storagedrawers:recipes/storagedrawers/bamboo_drawers" | "createdeco:recipes/decorations/industrial_iron_catwalk_from_stonecutting" | "create:recipes/misc/crafting/kinetics/mechanical_plough" | "create:recipes/misc/smelting/tin_ingot_compat_thermal" | "createbigcannons:recipes/misc/cannon_welder_mirrored" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_2" | "interiors:recipes/building_blocks/crafting/chair/red_chair" | "tconstruct:recipes/decorations/common/glass/red_clear_stained_glass_pane" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_1" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_4" | "sophisticatedstorage:recipes/misc/dark_oak_limited_barrel_3" | "numismatics:root" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_wall" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_from_reinforced_blackstone_stonecutting" | "createbigcannons:recipes/misc/mortar_stone" | "sophisticatedstorage:recipes/misc/storage_magnet_upgrade_from_backpack_magnet_upgrade" | "alexscaves:alexscaves/trade_with_deep_one" | "create:recipes/building_blocks/cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create_dd:recipes/create_dd.palettes/white_padded_rubber_stairs_from_white_rubber_decor_stonecutting" | "securitycraft:recipes/misc/keycard_lv5_reset" | "create:recipes/misc/crafting/kinetics/belt_connector" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab" | "design_decor:recipes/building_blocks/lime_metal_sheet_slab_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_slab" | "createdeco:recipes/decorations/industrial_iron_bars" | "securitycraft:recipes/building_blocks/reinforced_chiseled_stone_bricks_from_reinforced_stone_stonecutting" | "create:recipes/building_blocks/cut_asurine_slab" | "createdeco:recipes/decorations/zinc_hull" | "design_decor:recipes/building_blocks/andesite_castel_tile_slab_from_stone_types_andesite_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_stairs_stonecutter" | "createbigcannons:recipes/misc/casting_sand" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_polished_andesite_stonecutting" | "tconstruct:recipes/decorations/common/iron_platform" | "storagedrawers:recipes/storagedrawers/acacia_trim" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal_boiler" | "sophisticatedstorage:recipes/misc/smoking_upgrade" | "tconstruct:recipes/misc/common/slime/earth/crystal_smelting" | "framedblocks:recipes/building_blocks/framed_double_slope" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_blackstone_stairs_from_reinforced_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/small_basalt_brick_slab_recycling" | "create_dd:recipes/create_dd.palettes/small_dolomite_brick_wall_from_stone_types_dolomite_stonecutting" | "vinery:main/mashy_success" | "create_dd:recipes/create_dd.palettes/cut_netherrack_slab" | "storagedelight:recipes/decorations/dark_oak_single_door_cabinet" | "interiors:recipes/building_blocks/crafting/floor_chair/blue_floor_chair_from_seat" | "minecraft:recipes/decorations/bamboo_fence" | "create:recipes/misc/crafting/logistics/content_observer" | "securitycraft:recipes/building_blocks/reinforced_smooth_quartz_slab" | "minecraft:recipes/building_blocks/polished_granite_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_riveted_locometal" | "alexscaves:alexscaves/convert_biome" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_smokebox" | "create_dd:recipes/create_dd.palettes/crafting/decor/pink_blueprint_block" | "minecraft:recipes/decorations/gray_candle" | "ae2:recipes/misc/network/blocks/quantum_ring" | "alexscaves:alexscaves/sugar_rush" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_vine" | "tconstruct:recipes/decorations/tables/scorched_anvil" | "ae2:recipes/misc/network/cables/dense_smart_brown" | "create_dd:recipes/create_dd.palettes/gabbro_from_stone_types_gabbro_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_granite_wall_from_reinforced_granite_stonecutting" | "tconstruct:recipes/redstone/smeltery/scorched/fluid_cannon" | "securitycraft:recipes/decorations/reinforced_orange_stained_glass_pane" | "create_dd:recipes/create_dd.base/crafting/raw_rubber_block_from_raw_rubber" | "minecraft:recipes/decorations/cyan_bed" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_slab_recycling" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_2" | "superbwarfare:recipes/misc/rare_material_pack" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_1" | "createbigcannons:recipes/building_blocks/cast_iron_nugget" | "create:recipes/building_blocks/polished_cut_dripstone_wall" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_4" | "sophisticatedstorage:recipes/misc/spruce_limited_barrel_3" | "securitycraft:recipes/redstone/reinforced_polished_blackstone_pressure_plate" | "minecraft:recipes/building_blocks/jungle_stairs" | "createdeco:recipes/building_blocks/tiled_dean_bricks_from_dean_bricks_stonecutting" | "minecraft:recipes/food/pumpkin_pie" | "minecraft:recipes/misc/host_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_calcite_stairs" | "interiors:recipes/building_blocks/crafting/chair/brown_chair_from_other_chair" | "minecraft:husbandry/breed_an_animal" | "securitycraft:recipes/building_blocks/cobblestone_mine" | "tcintegrations:recipes/misc/bronze_block_from_ingots" | "smallships:recipes/transportation/spruce_galley" | "spelunkery:recipes/quartz" | "create:recipes/building_blocks/polished_cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/combat/netherite_helmet_smithing" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_sword" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cracked_polished_blackstone_bricks" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_wall_from_reinforced_polished_deepslate_stonecutting" | "minecraft:husbandry/complete_catalogue" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_spruce_wood" | "create:recipes/building_blocks/small_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "minecraft:recipes/decorations/brown_stained_glass_pane" | "farmersdelight:recipes/decorations/lime_canvas_sign" | "securitycraft:recipes/redstone/reinforced_dark_oak_pressure_plate" | "securitycraft:recipes/building_blocks/reinforced_granite_slab" | "farmersdelight:recipes/decorations/black_hanging_canvas_sign" | "framedblocks:recipes/building_blocks/framed_fence_gate" | "tfmg:recipes/building_blocks/lead_truss_from_ingots_lead_stonecutting" | "tconstruct:recipes/decorations/common/glass/orange_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_riveted_locometal" | "create:recipes/building_blocks/deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_honeycomb" | "tconstruct:recipes/redstone/world/wood/bloodshroom/fence_gate" | "framedblocks:recipes/building_blocks/framed_gate" | "securitycraft:recipes/building_blocks/reinforced_white_carpet_from_dye" | "ae2:recipes/misc/network/cables/smart_fluix" | "superbwarfare:recipes/misc/secondary_cataclysm_blueprint" | "create:recipes/misc/crafting/logistics/display_link" | "numismatics:recipes/misc/crafting/white_card" | "design_decor:recipes/building_blocks/deepslate_castel_tiles_from_stone_types_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal_boiler" | "comforts:sleeping_bag_light_blue" | "createdeco:recipes/decorations/gray_placard" | "minecraft:recipes/building_blocks/stripped_cherry_wood" | "minecraft:recipes/misc/light_blue_dye_from_blue_orchid" | "createdeco:recipes/building_blocks/long_pearl_bricks_from_short_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs" | "minecraft:recipes/building_blocks/lime_concrete_powder" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_stairs" | "alexscaves:alexscaves/guano" | "framedblocks:recipes/building_blocks/framed_vertical_sliced_stairs" | "create:recipes/building_blocks/crimson_window" | "create:recipes/building_blocks/cut_granite_brick_stairs_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_long_pearl_brick_slab_stonecutting" | "superbwarfare:recipes/misc/mosin_nagant_blueprint" | "securitycraft:recipes/building_blocks/coal_mine" | "smallships:recipes/transportation/birch_cog" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_smokebox" | "minecraft:recipes/building_blocks/dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_elev_double_slope_slab_corner_rotate_to_framed_flat_ext_double_slope_panel_corner" | "storagedelight:recipes/decorations/small_crimson_drawers" | "create_enchantment_industry:experienced_engineer" | "securitycraft:recipes/misc/portable_tune_player" | "create:train_portal" | "minecraft:recipes/redstone/spruce_button" | "sophisticatedbackpacks:recipes/misc/xp_pump_upgrade" | "interiors:recipes/building_blocks/crafting/floor_chair/black_floor_chair_from_other_floor_chair" | "tfmg:recipes/decorations/aluminum_bars_from_ingots_aluminum_stonecutting" | "alexscaves:alexscaves/convert_nether_biome" | "petrolpark:badge/bestie" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_smelting" | "superbwarfare:recipes/misc/m_60_blueprint" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "storagedelight:recipes/decorations/dark_oak_cabinet_with_glass_doors" | "alexscaves:alexscaves/licowitch_tower" | "sophisticatedstorage:recipes/misc/backpack_chipped_glassblower_upgrade_from_storage_chipped_glassblower_upgrade" | "minecraft:recipes/misc/flower_banner_pattern" | "storagedrawers:recipes/storagedrawers/priority_key" | "ae2:recipes/misc/smelting/smooth_sky_stone_block" | "ae2:recipes/misc/tools/paintballs_lime" | "framedblocks:recipes/building_blocks/framed_flat_double_slope_panel_corner_from_flat_inverse_double_slope_panel_corner" | "create_dd:recipes/create_dd.palettes/crafting/decor/white_padded_rubber_from_white_padded_rubber" | "create_dd:recipes/create_dd.palettes/layered_weathered_limestone_from_stone_types_weathered_limestone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_bamboo_stairs" | "tconstruct:recipes/misc/tables/book_substitute" | "securitycraft:recipes/building_blocks/reinforced_quartz_slab" | "securitycraft:recipes/building_blocks/reinforced_cut_red_sandstone_slab_from_reinforced_cut_red_sandstone_stonecutting" | "framedblocks:recipes/building_blocks/framed_cube" | "farmersdelight:recipes/food/apple_pie" | "createdeco:recipes/building_blocks/dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "minecraft:recipes/redstone/dark_oak_door" | "createdeco:recipes/decorations/decal_down" | "createdeco:recipes/decorations/red_copper_lamp" | "minecraft:recipes/misc/coal_from_smelting_deepslate_coal_ore" | "create:brass" | "minecraft:recipes/redstone/hopper" | "create:recipes/misc/crafting/kinetics/mechanical_harvester" | "create:recipes/building_blocks/polished_cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "createdeco:recipes/decorations/copper_bars_overlay" | "petrolpark:badge/early_bird" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal" | "minecraft:recipes/redstone/calibrated_sculk_sensor" | "create_dd:recipes/create_dd.palettes/lime_padded_rubber_stairs_from_lime_rubber_decor_stonecutting" | "spelunkery:recipes/rough_quartz_block" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_pillar" | "design_decor:recipes/building_blocks/magenta_metal_plate_from_metal_plate_stonecutting" | "minecraft:recipes/misc/lime_dye" | "create:recipes/misc/crafting/materials/zinc_ingot_from_compacting" | "interiors:recipes/building_blocks/crafting/floor_chair/white_floor_chair" | "securitycraft:recipes/building_blocks/reinforced_cyan_wool" | "createdeco:recipes/building_blocks/cracked_red_brick_slab_from_cracked_red_bricks_stonecutting" | "design_decor:recipes/building_blocks/wood_support_from_planks_stonecutting" | "create:recipes/building_blocks/small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_chiseled_deepslate_from_reinforced_cobbled_deepslate_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "create:recipes/misc/crafting/palettes/scorchia" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_riveted_locometal" | "framedblocks:recipes/building_blocks/framed_chiseled_bookshelf" | "sophisticatedstorage:recipes/misc/bamboo_chest_from_quark_bamboo_chest" | "create:recipes/misc/smoking/bread" | "advancedperipherals:recipes/redstone/energy_detector" | "createdeco:recipes/building_blocks/umber_brick_slab_from_long_umber_bricks_stonecutting" | "advancedperipherals:recipes/redstone/player_detector" | "design_decor:recipes/building_blocks/magenta_metal_plate_wall_from_metal_plate_stonecutting" | "minecraft:recipes/building_blocks/tinted_glass" | "minecraft:recipes/building_blocks/dye_blue_wool" | "sophisticatedbackpacks:recipes/misc/smelting_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_scoria_stairs" | "minecraft:recipes/redstone/comparator" | "minecraft:recipes/redstone/mangrove_pressure_plate" | "createdeco:recipes/building_blocks/cracked_umber_brick_stairs" | "create:recipes/building_blocks/polished_cut_granite_from_stone_types_granite_stonecutting" | "farmersdelight:recipes/cooking/hot_cocoa" | "create:recipes/building_blocks/small_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "tconstruct:recipes/building_blocks/common/glass/green_clear_stained_glass" | "design_decor:recipes/building_blocks/asurine_castel_tile_stairs_from_stone_types_asurine_stonecutting" | "create:recipes/misc/crafting/appliances/tree_fertilizer" | "minecraft:recipes/building_blocks/red_stained_glass" | "minecraft:adventure/very_very_frightening" | "minecraft:story/lava_bucket" | "farmersdelight:recipes/food/chocolate_pie" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_plated_locometal" | "securitycraft:recipes/decorations/reinforced_orange_carpet" | "farmersdelight:recipes/food/cooked_bacon_from_smoking" | "securitycraft:recipes/redstone/reinforced_bamboo_fence_gate" | "computercraft:recipes/redstone/printed_pages" | "securitycraft:recipes/redstone/reinforced_fence_gate" | "minecraft:recipes/building_blocks/quartz_stairs" | "create:recipes/building_blocks/cut_crimsite_wall" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper_stairs_from_reinforced_oxidized_copper_stonecutting" | "ae2:recipes/misc/materials/carddistribution" | "minecraft:recipes/misc/copper_ingot_from_blasting_raw_copper" | "tconstruct:world/slime_collector" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_4" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_3" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_2" | "sophisticatedstorage:recipes/misc/mangrove_limited_barrel_1" | "vs_eureka:recipes/balloon_wool" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_tiled_pearl_brick_slab_stonecutting" | "create:recipes/building_blocks/small_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "design_decor:recipes/building_blocks/yellow_metal_plate_from_metal_plate_stonecutting" | "create:recipes/building_blocks/layered_scoria_from_stone_types_scoria_stonecutting" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "createdeco:recipes/decorations/brown_placard_from_dyeing" | "ae2:recipes/misc/decorative/cut_quartz_block_from_stonecutting" | "tfmg:recipes/building_blocks/layered_galena_from_stone_types_galena_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cobblestone_wall_from_reinforced_cobblestone_stonecutting" | "railways:recipes/misc/crafting/smokestack_coalburner" | "farmersdelight:recipes/combat/netherite_knife_smithing" | "interiors:recipes/building_blocks/crafting/floor_chair/orange_floor_chair" | "alexscaves:alexscaves/radon_bottle" | "tfmg:recipes/building_blocks/polished_cut_bauxite_slab" | "storagedelight:recipes/decorations/crimson_drawer_with_books" | "superbwarfare:recipes/combat/m_870_smithing" | "minecraft:recipes/building_blocks/polished_deepslate_from_cobbled_deepslate_stonecutting" | "createdeco:recipes/decorations/yellow_shipping_container_from_dyeing_vaults" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_slab" | "createdeco:recipes/decorations/brass_catwalk_railing_from_stonecutting" | "create:recipes/building_blocks/polished_cut_dripstone_slab_recycling" | "minecraft:recipes/decorations/pink_stained_glass_pane" | "design_decor:recipes/building_blocks/white_metal_plate_slab_from_metal_plate_stonecutting" | "farmersdelight:recipes/decorations/spruce_cabinet" | "create_dd:recipes/create_dd.palettes/crafting/decor/green_asphalt_block" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_pillar" | "minecraft:recipes/misc/emerald_from_blasting_emerald_ore" | "sophisticatedstorage:recipes/misc/storage_chipped_carpenters_table_upgrade_from_backpack_chipped_carpenters_table_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_slashed_locometal" | "createdeco:recipes/decorations/red_placard" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "ae2:main/network3" | "create:recipes/building_blocks/cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "tconstruct:recipes/decorations/world/wood/greenheart/hanging_sign" | "ae2:main/network2" | "createdeco:recipes/building_blocks/cracked_dean_bricks_from_dean_bricks_blasting" | "tfmg:recipes/building_blocks/cut_bauxite_brick_slab_from_stone_types_bauxite_stonecutting" | "create_connected:recipes/crafting/kinetics/large_crank_wheel" | "ae2:main/network1" | "securitycraft:recipes/redstone/reinforced_bamboo_pressure_plate" | "minecraft:recipes/food/cooked_porkchop" | "minecraft:recipes/building_blocks/oak_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_slashed_locometal" | "spelunkery:recipes/raw_copper_nugget" | "minecraft:husbandry/tame_an_animal" | "ae2:recipes/misc/network/parts/monitors_storage" | "farmersdelight:recipes/food/roasted_mutton_chops" | "minecraft:recipes/decorations/cyan_glazed_terracotta" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal" | "vinery:main/the_first_press" | "createdeco:recipes/building_blocks/iron_window" | "minecraft:recipes/tools/brush" | "design_decor:recipes/building_blocks/magenta_metal_sheet_wall_from_metal_plate_stonecutting" | "minecraft:recipes/decorations/cyan_candle" | "minecraft:recipes/building_blocks/diorite_stairs_from_diorite_stonecutting" | "design_decor:recipes/building_blocks/brown_metal_plate_from_metal_plate_stonecutting" | "design_decor:recipes/building_blocks/orange_metal_plate_slab_from_metal_plate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_pillar" | "minecraft:recipes/building_blocks/stripped_acacia_wood" | "tconstruct:recipes/misc/common/materials/cinderslime_block_from_ingots" | "copycats:recipes/crafting/copycat_byte" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_slab_from_reinforced_stone_bricks_stonecutting" | "create:recipes/misc/crafting/curiosities/minecart_coupling" | "securitycraft:recipes/redstone/reinforced_warped_button" | "securitycraft:recipes/decorations/reinforced_white_stained_glass_pane" | "spelunkery:recipes/obsidian" | "farmersdelight:recipes/decorations/brown_hanging_canvas_sign" | "minecraft:recipes/decorations/light_gray_bed" | "create:recipes/building_blocks/acacia_window_pane" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_stairs_from_reinforced_crystal_quartz_block_stonecutting" | "securitycraft:recipes/decorations/reinforced_polished_deepslate_wall" | "minecraft:recipes/building_blocks/blackstone_stairs" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_long_red_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_slashed_locometal" | "alexscaves:alexscaves/tame_tremorzilla" | "securitycraft:recipes/misc/keycard_lv5" | "farmersdelight:recipes/misc/gold_nugget_from_smelting_knife" | "securitycraft:recipes/misc/keycard_lv3" | "securitycraft:recipes/misc/keycard_lv4" | "create:windmill_maxed" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "astikorcarts:recipes/plow" | "create:recipes/misc/crafting/kinetics/deployer" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite_from_reinforced_andesite_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_pearl_bricks_stonecutting" | "securitycraft:recipes/misc/keycard_lv1" | "tconstruct:recipes/decorations/smeltery/scorched/table" | "securitycraft:recipes/misc/keycard_lv2" | "spelunkery:recipes/redstone_ores" | "create:recipes/building_blocks/polished_cut_tuff_wall_from_stone_types_tuff_stonecutting" | "createdeco:recipes/decorations/white_shipping_container" | "design_decor:recipes/building_blocks/dripstone_castel_brick_stairs_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/cut_limestone_wall_from_stone_types_limestone_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs" | "minecraft:recipes/decorations/cyan_banner" | "framedblocks:recipes/building_blocks/framed_prism" | "vs_eureka:recipes/balloon_color" | "createdeco:recipes/decorations/decal_cross" | "securitycraft:recipes/redstone/reinforced_stone_button" | "createdeco:recipes/building_blocks/short_umber_bricks_from_tiled_umber_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/brown_clear_stained_glass_pane_from_panes" | "interiors:recipes/building_blocks/crafting/chair/lime_chair_from_floor_chair" | "minecraft:recipes/decorations/red_banner" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal" | "tfmg:recipes/building_blocks/cut_bauxite_brick_wall" | "create_connected:recipes/crafting/kinetics/clutch_from_conversion" | "superbwarfare:recipes/misc/rpk_blueprint" | "minecraft:recipes/combat/iron_boots" | "copycats:recipes/crafting/copycat_folding_door_from_conversion" | "minecraft:recipes/building_blocks/birch_planks" | "railways:recipes/misc/crafting/palettes/wrapping/copper_wrapped_locometal" | "tfmg:recipes/building_blocks/nickel_frame_from_ingots_nickel_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_stone" | "createdeco:recipes/decorations/brass_mesh_fence" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_stairs_from_reinforced_cobbled_deepslate_stonecutting" | "comforts:sleeping_bag_white" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "copycats:recipes/crafting/copycat_wooden_button" | "create:recipes/building_blocks/acacia_window" | "create:recipes/misc/smelting/glass_from_tiled_glass" | "createbigcannons:recipes/misc/wrought_iron_cannon_chamber" | "securitycraft:recipes/building_blocks/reinforced_dark_oak_stairs" | "securitycraft:recipes/transportation/bamboo_security_sea_raft" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab" | "createbigcannons:recipes/misc/powder_charge" | "securitycraft:recipes/building_blocks/reinforced_magenta_stained_glass" | "securitycraft:recipes/decorations/reinforced_cyan_stained_glass_pane_from_dye" | "railways:recipes/misc/crafting/palettes/wrapping/black_copper_wrapped_locometal" | "minecraft:recipes/decorations/magenta_glazed_terracotta" | "ae2:recipes/misc/tools/certus_quartz_spade" | "create_dd:recipes/create_dd.palettes/amethyst_block_pillar_from_stone_types_amethyst_block_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal_boiler" | "createbigcannons:recipes/misc/flak_autocannon_round" | "design_decor:recipes/building_blocks/purple_metal_sheet_stairs_from_metal_plate_stonecutting" | "advancedperipherals:recipes/redstone/geo_scanner" | "create:recipes/building_blocks/polished_cut_deepslate_stairs" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_polished_granite_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "ae2:recipes/misc/network/parts/energy_acceptor" | "minecraft:recipes/building_blocks/mud_brick_stairs" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_jungle_slab" | "tfmg:recipes/building_blocks/cut_bauxite_bricks_from_stone_types_bauxite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_basalt_from_stone_types_basalt_stonecutting" | "sophisticatedstorage:recipes/misc/advanced_void_upgrade" | "minecraft:recipes/building_blocks/dye_light_gray_wool" | "ae2:recipes/misc/network/crafting/16k_cpu_crafting_storage" | "securitycraft:recipes/misc/lens" | "createdeco:recipes/building_blocks/mossy_dusk_bricks_from_moss_block" | "create:recipes/building_blocks/polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_light_blue_carpet_from_dye" | "alexscaves:alexscaves/defeat_mine_guardian" | "spelunkery:spelunkery/carved_nephrite" | "advancedperipherals:recipes/redstone/nbt_storage" | "crusty_chunks:tools" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/light_gray_stained_glass" | "railways:recipes/misc/crafting/palettes/wrapping/brown_iron_wrapped_locometal" | "tconstruct:recipes/decorations/gadgets/fancy_frame/clear" | "create:recipes/building_blocks/small_crimsite_brick_wall" | "minecraft:recipes/decorations/acacia_sign" | "securitycraft:recipes/building_blocks/reinforced_smooth_red_sandstone_slab_from_reinforced_smooth_red_sandstone_stonecutting" | "ae2:recipes/misc/network/cables/covered_purple" | "ae2:recipes/misc/shaped/stairs/quartz_pillar" | "vinery:main/wine_somelier" | "astikorcarts:recipes/wheel" | "minecraft:recipes/building_blocks/brick_slab" | "crusty_chunks:powder_types" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed_storage" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_brick_slab" | "minecraft:recipes/decorations/cherry_sign" | "createdeco:recipes/building_blocks/dean_bricks_from_long_dean_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/diamond_chest" | "framedblocks:recipes/building_blocks/framed_flat_stacked_slope_panel_corner" | "railways:recipes/misc/crafting/palettes/wrapping/white_iron_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/dark_metal_block_stairs_from_industrial_iron_block_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_pickup_upgrade_from_storage_pickup_upgrade" | "tconstruct:recipes/redstone/smeltery/seared/chute_retextured" | "createdeco:recipes/decorations/lime_shipping_container" | "sophisticatedbackpacks:recipes/misc/stonecutter_upgrade" | "ae2:recipes/misc/tools/paintballs_brown" | "createbigcannons:recipes/building_blocks/cast_iron_block" | "storagedelight:recipes/decorations/warped_cabinet_with_glass_doors" | "minecraft:recipes/misc/orange_dye_from_red_yellow" | "createdeco:recipes/building_blocks/scarlet_brick_stairs" | "design_decor:recipes/building_blocks/scoria_castel_tiles_from_stone_types_scoria_stonecutting" | "framedblocks:recipes/building_blocks/framed_fence" | "railways:recipes/misc/crafting/track_switch_andesite" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_smokebox" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper_stairs_from_reinforced_weathered_cut_copper_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_nether_gold_ore" | "create:fist_bump" | "minecraft:recipes/building_blocks/dye_orange_bed" | "minecraft:recipes/food/rabbit_stew_from_brown_mushroom" | "minecraft:recipes/building_blocks/magenta_concrete_powder" | "sophisticatedstorage:recipes/misc/copper_to_diamond_tier_upgrade" | "minecraft:recipes/decorations/green_bed" | "createdeco:recipes/decorations/orange_shipping_container_from_dyeing_vaults" | "railways:recipes/misc/stonecutting/palettes/cycling/black_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_smokebox" | "securitycraft:recipes/misc/mine" | "minecraft:recipes/building_blocks/cut_sandstone_from_sandstone_stonecutting" | "superbwarfare:recipes/misc/epic_material_pack" | "minecraft:recipes/decorations/campfire" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_smokebox" | "create_dd:recipes/create_dd.palettes/layered_blackstone_from_stone_types_blackstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite_stairs_from_reinforced_diorite_stonecutting" | "spelunkery:recipes/charcoal" | "minecraft:recipes/decorations/lime_stained_glass_pane" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_3_from_storage_stack_upgrade_tier_4" | "minecraft:recipes/misc/snout_armor_trim_smithing_template" | "securitycraft:recipes/decorations/reinforced_red_stained_glass_pane" | "minecraft:recipes/transportation/hopper_minecart" | "createdeco:recipes/building_blocks/short_pearl_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_plated_locometal" | "interiors:recipes/building_blocks/crafting/floor_chair/black_floor_chair" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_short_blue_bricks_stonecutting" | "createdeco:recipes/decorations/copper_support" | "sophisticatedstorage:recipes/misc/advanced_jukebox_upgrade" | "railways:recipes/combat/dying_existing_cap_light_blue" | "securitycraft:recipes/building_blocks/reinforced_red_sandstone" | "securitycraft:recipes/transportation/cherry_security_sea_boat" | "numismatics:recipes/misc/crafting/vendor" | "create:recipes/building_blocks/cut_ochrum_brick_wall" | "minecraft:recipes/building_blocks/terracotta" | "storagedrawers:recipes/storagedrawers/warped_drawers" | "spelunkery:spelunkery/item_magnet" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "securitycraft:recipes/misc/block_pocket_manager" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal" | "storagedelight:recipes/decorations/jungle_cabinet_with_glass_doors" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_smokebox" | "cgs:recipes/misc/lead_ingot_from_smelting_raw_lead" | "farmersdelight:main/get_ham" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_tiled_verdant_bricks_stonecutting" | "create:recipes/building_blocks/scoria_pillar_from_stone_types_scoria_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_slab_stonecutter" | "minecraft:recipes/redstone/jungle_trapdoor" | "securitycraft:recipes/building_blocks/reinforced_magenta_glazed_terracotta" | "framedblocks:recipes/building_blocks/framed_inner_threeway_corner" | "framedblocks:recipes/building_blocks/framed_inner_corner_slope" | "create_connected:recipes/crafting/kinetics/vertical_parallel_gearbox_from_conversion" | "farmersdelight:recipes/decorations/orange_canvas_sign" | "securitycraft:recipes/decorations/reinforced_red_nether_brick_wall" | "railways:recipes/misc/crafting/palettes/wrapping/black_brass_wrapped_locometal" | "sophisticatedstorage:recipes/misc/dark_oak_chest" | "minecraft:recipes/building_blocks/chiseled_sandstone_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_polished_deepslate_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stonecutting" | "createdeco:recipes/decorations/brass_bars_overlay_from_stonecutting" | "tconstruct:tools/one_shot" | "framedblocks:recipes/building_blocks/framed_bouncy_cube" | "design_decor:recipes/building_blocks/ochrum_castel_bricks_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal" | "tconstruct:smeltery/puny_smelting" | "createbb:p2/obtain_blue_meth" | "securitycraft:recipes/redstone/reinforced_oak_button" | "tconstruct:recipes/decorations/world/wood/greenheart/sign" | "minecraft:recipes/building_blocks/orange_terracotta" | "design_decor:recipes/building_blocks/dripstone_castel_tiles_from_stone_types_dripstone_stonecutting" | "framedblocks:recipes/building_blocks/framed_large_inner_corner_slope_panel" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_tiled_verdant_brick_slab_stonecutting" | "create_dd:recipes/create_dd.palettes/small_dolomite_brick_stairs" | "minecraft:recipes/misc/silence_armor_trim_smithing_template" | "spelunkery:recipes/lapis_ores" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_short_blue_bricks_stonecutting" | "minecraft:recipes/food/cooked_chicken_from_smoking" | "create:recipes/building_blocks/cut_deepslate_brick_slab_recycling" | "create:recipes/misc/crafting/kinetics/metal_girder" | "create:recipes/building_blocks/cut_asurine_brick_stairs" | "vinery:recipes/dark_cherry_trapdoor" | "storagedelight:recipes/decorations/cherry_cabinet_with_glass_doors" | "create:recipes/building_blocks/cut_diorite_stairs" | "create:recipes/building_blocks/polished_cut_galena_slab_recycling" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_stairs" | "createbigcannons:recipes/misc/cannon_builder" | "create_enchantment_industry:experienced_recycler" | "ae2:recipes/misc/network/cables/covered_yellow" | "tconstruct:recipes/misc/smeltery/copper_can" | "create_dd:recipes/create_dd.palettes/cut_basalt_slab_from_stone_types_basalt_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_4" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_slab" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_3" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_blue_bricks_stonecutting" | "minecraft:recipes/redstone/cherry_pressure_plate" | "minecraft:recipes/redstone/warped_pressure_plate" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_from_vanilla_moss" | "framedblocks:recipes/building_blocks/framed_thick_lattice" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_stairs_from_reinforced_polished_deepslate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_chiseled_red_sandstone" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/stairs" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_2" | "sophisticatedstorage:recipes/misc/acacia_limited_barrel_1" | "minecraft:recipes/food/cooked_salmon_from_campfire_cooking" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_brick_slab_recycling" | "design_decor:recipes/building_blocks/calcite_castel_brick_slab_from_stone_types_calcite_stonecutting" | "farmersdelight:recipes/food/cooked_mutton_chops_from_campfire_cooking" | "storagedelight:recipes/decorations/small_cherry_drawers" | "create_dd:recipes/create_dd.palettes/cut_basalt_stairs" | "create:recipes/building_blocks/cut_andesite_brick_wall" | "securitycraft:recipes/building_blocks/reinforced_smooth_quartz" | "tconstruct:recipes/building_blocks/common/glass/magenta_clear_stained_glass" | "create:recipes/building_blocks/cut_veridium_stairs" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_tiled_red_brick_slab_stonecutting" | "create:recipes/building_blocks/cut_crimsite_from_stone_types_crimsite_stonecutting" | "disccord:recipes/tools/custom_record" | "create:recipes/building_blocks/small_ochrum_brick_slab" | "minecraft:recipes/redstone/bamboo_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal_boiler" | "farmersdelight:recipes/cooking/pasta_with_meatballs" | "minecraft:recipes/misc/ward_armor_trim_smithing_template_smithing_trim" | "spelunkery:spelunkery/coal_lump" | "railways:recipes/misc/stonecutting/palettes/cycling/red_plated_locometal" | "createdeco:recipes/decorations/andesite_bars" | "framedblocks:recipes/building_blocks/framed_slope_edge" | "securitycraft:recipes/decorations/reinforced_stone_brick_wall" | "ae2:recipes/misc/network/cells/item_cell_housing" | "createdeco:recipes/decorations/red_placard_from_dyeing" | "ae2:recipes/misc/network/cables/smart_pink" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_slashed_locometal" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_boiler" | "tconstruct:recipes/redstone/smeltery/scorched/chute_retextured" | "alexscaves:alexscaves/cave_codex" | "createdeco:recipes/decorations/copper_coin" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_umber_bricks_from_short_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_boiler" | "alexscaves:alexscaves/primordial_armor" | "minecraft:recipes/building_blocks/chiseled_nether_bricks_from_nether_bricks_stonecutting" | "ae2:recipes/misc/network/cables/smart_orange" | "sophisticatedbackpacks:recipes/misc/advanced_pump_upgrade" | "tconstruct:recipes/building_blocks/world/wood/greenheart/slab" | "create:recipes/building_blocks/polished_cut_asurine_wall" | "copycats:recipes/crafting/copycat_shaft" | "vinery:main/vintage_perfection" | "create:recipes/misc/crafting/kinetics/gearboxfrom_conversion" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/framed_glass_from_glass_colorless_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_from_stone_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal" | "minecraft:recipes/decorations/pink_bed" | "minecraft:recipes/misc/coal_from_blasting_deepslate_coal_ore" | "design_decor:recipes/building_blocks/lime_metal_plate_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_smooth_crystal_quartz_slab_from_reinforced_smooth_crystal_quartz_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "comforts:sleeping_bag_purple" | "securitycraft:recipes/building_blocks/reinforced_jungle_planks" | "ae2:recipes/misc/block_cutter/walls/cut_quartz_wall" | "ae2:recipes/misc/network/cells/item_storage_cell_1k_storage" | "ae2:recipes/misc/network/cables/glass_yellow" | "securitycraft:recipes/building_blocks/reinforced_polished_granite_stairs" | "alexscaves:alexscaves/enter_acid_with_armor" | "createdeco:recipes/decorations/industrial_iron_catwalk_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_plated_locometal" | "sophisticatedstorage:recipes/misc/storage_chipped_alchemy_bench_upgrade_from_backpack_chipped_alchemy_bench_upgrade" | "superbwarfare:recipes/misc/artillery_indicator_clear" | "minecraft:recipes/decorations/jungle_sign" | "sophisticatedstorage:recipes/misc/storage_feeding_upgrade_from_backpack_feeding_upgrade" | "storagedelight:recipes/decorations/cherry_drawer_with_door" | "sophisticatedstorage:recipes/misc/backpack_stonecutter_upgrade_from_storage_stonecutter_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/exposed_cut_copper_from_exposed_copper_stonecutting" | "comforts:sleeping_bag_green" | "design_decor:recipes/building_blocks/white_metal_sheet_slab_from_metal_plate_stonecutting" | "ae2:recipes/misc/decorative/chiseled_quartz_block_from_stonecutting" | "create_connected:recipes/crafting/kinetics/fluid_vessel_from_conversion" | "tconstruct:foundry/alloyer" | "tfmg:recipes/building_blocks/rebar_concrete_slab_from_rebar_concrete_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mud_brick_stairs_from_reinforced_mud_bricks_stonecutting" | "minecraft:husbandry/feed_snifflet" | "minecraft:recipes/building_blocks/sandstone_slab_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/copper_valve_handle" | "create:recipes/building_blocks/cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_brick_wall" | "ae2:recipes/misc/misc/deconstruction_chiseled_certus_quartz" | "minecraft:recipes/misc/netherite_ingot_from_netherite_block" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/short_red_bricks_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/small_crimsite_brick_stairs" | "create:recipes/building_blocks/cut_dripstone_brick_slab_recycling" | "design_decor:recipes/building_blocks/metal_plate_stairs_from_ingots_iron_stonecutting" | "minecraft:end/enter_end_gateway" | "minecraft:recipes/building_blocks/bamboo_slab" | "create:recipes/building_blocks/cut_scoria_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_riveted_locometal" | "copycats:recipes/crafting/copycat_pane" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_ingot_from_block" | "create_dd:recipes/create_dd.palettes/basalt_pillar_from_stone_types_basalt_stonecutting" | "createdeco:recipes/building_blocks/mossy_red_brick_stairs" | "create_connected:recipes/crafting/kinetics/fluid_vessel" | "interiors:recipes/building_blocks/crafting/floor_chair/purple_floor_chair" | "mts:jumperpack" | "securitycraft:recipes/building_blocks/reinforced_chiseled_quartz_block_from_reinforced_quartz_block_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_bricks_from_dusk_bricks_stonecutting" | "copycats:recipes/crafting/copycat_layer_from_half_layers" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_fancy_bricks_crafting" | "create_dd:recipes/create_dd.palettes/crafting/decor/blue_asphalt_block" | "ae2:recipes/misc/tools/paintballs_blue" | "minecraft:recipes/redstone/oak_door" | "minecraft:recipes/building_blocks/dye_yellow_carpet" | "create_dd:recipes/create_dd.palettes/raw_padded_rubber_stairs_from_raw_rubber_decor_stonecutting" | "create:recipes/building_blocks/copycat_panel_from_ingots_zinc_stonecutting" | "securitycraft:recipes/misc/protecto" | "minecraft:recipes/misc/iron_ingot_from_iron_block" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "framedblocks:recipes/building_blocks/framed_extended_double_slope_panel" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_copper_wrapped_locometal" | "securitycraft:recipes/building_blocks/smooth_crystal_quartz" | "create:recipes/building_blocks/horizontal_framed_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_riveted_locometal" | "create:recipes/misc/smelting/zinc_ingot_from_crushed" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_blackstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade" | "securitycraft:recipes/building_blocks/reinforced_andesite_slab" | "create:recipes/misc/crafting/kinetics/propeller" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_boiler" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_stairs_from_honeycomb" | "ae2:recipes/misc/shaped/walls/smooth_sky_stone_block" | "createdeco:recipes/decorations/decal_no_entry" | "createdeco:recipes/building_blocks/dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_slab_from_reinforced_end_stone_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_brick_wall_from_stone_types_weathered_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "tconstruct:recipes/misc/common/materials/steel_block_from_ingots" | "createbigcannons:recipes/misc/worm" | "framedblocks:recipes/building_blocks/framed_fancy_detector_rail_slope" | "minecraft:recipes/decorations/light_gray_candle" | "createdeco:recipes/building_blocks/short_dean_bricks_from_long_dean_bricks_stonecutting" | "create:recipes/building_blocks/calcite_pillar_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/melon" | "superbwarfare:recipes/combat/sentinel_smithing" | "securitycraft:recipes/decorations/reinforced_diorite_wall" | "farmersdelight:recipes/decorations/canvas_rug" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/polished_andesite_slab" | "create:recipes/building_blocks/polished_cut_ochrum_slab_recycling" | "securitycraft:recipes/decorations/secret_jungle_hanging_sign" | "ae2:recipes/misc/block_cutter/slabs/smooth_quartz_slab" | "create_connected:recipes/crafting/palettes/cherry_window_pane" | "create:recipes/building_blocks/cut_veridium_brick_stairs" | "create:recipes/building_blocks/diorite_from_stone_types_diorite_stonecutting" | "framedblocks:recipes/building_blocks/framed_panel_from_framed_centered_panel" | "alexscaves:alexscaves/tame_tremorsaurus" | "create_dd:recipes/create_dd.palettes/orange_padded_rubber_stairs_from_orange_rubber_decor_stonecutting" | "minecraft:recipes/decorations/yellow_stained_glass_pane_from_glass_pane" | "create_dd:recipes/create_dd.base/crafting/rubber_from_rubber_block" | "createdeco:recipes/building_blocks/mossy_dean_bricks_from_moss_block" | "create:recipes/building_blocks/cut_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_stairs" | "framedblocks:recipes/building_blocks/framed_centered_panel_rotate_to_framed_centered_slab" | "securitycraft:recipes/building_blocks/reinforced_pink_terracotta" | "minecraft:recipes/combat/golden_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_plated_locometal" | "minecraft:end/elytra" | "minecraft:recipes/decorations/mangrove_sign" | "brewery:main/get_beer_wheat" | "securitycraft:recipes/building_blocks/reinforced_cracked_nether_bricks" | "farmersdelight:recipes/decorations/birch_cabinet" | "securitycraft:recipes/building_blocks/reinforced_brown_terracotta" | "createdeco:recipes/decorations/blue_iron_lamp" | "minecraft:recipes/redstone/redstone_lamp" | "createdeco:recipes/decorations/industrial_iron_hull" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/black_clear_stained_glass_pane_from_panes" | "minecraft:recipes/redstone/dispenser" | "create:recipes/building_blocks/polished_cut_limestone_stairs" | "create_connected:recipes/crafting/palettes/copycat_wall_compat" | "createdeco:recipes/decorations/purple_shipping_container_from_dyeing_vaults" | "securitycraft:recipes/redstone/reinforced_sticky_piston" | "tfmg:recipes/building_blocks/small_bauxite_bricks_from_stone_types_bauxite_stonecutting" | "superbwarfare:recipes/misc/iron_barrel" | "create:recipes/building_blocks/polished_cut_andesite_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar_from_purpur_block_stonecutting" | "securitycraft:recipes/redstone/reinforced_dark_oak_fence_gate" | "createdeco:recipes/building_blocks/long_dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_stairs" | "minecraft:recipes/building_blocks/cobblestone_slab" | "securitycraft:recipes/building_blocks/reinforced_end_stone_bricks" | "create_dd:recipes/building_blocks/blackstone_from_stone_types_blackstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mud_brick_wall_from_reinforced_mud_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/encased_chain_drive" | "create:recipes/misc/crafting/kinetics/mechanical_drill" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_riveted_locometal" | "create_dd:recipes/create_dd.palettes/cut_gabbro_stairs_from_stone_types_gabbro_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_bricks_from_short_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/magenta_terracotta" | "securitycraft:recipes/decorations/secret_acacia_hanging_sign" | "interiors:recipes/building_blocks/crafting/chair/gray_chair_from_seat" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_slab" | "minecraft:recipes/misc/brick" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_boiler" | "ae2:recipes/misc/tools/portable_item_cell_256k" | "tconstruct:recipes/decorations/common/glass/lime_clear_stained_glass_pane" | "sophisticatedstorage:recipes/misc/green_shulker_box_to_sophisticated" | "storagedrawers:recipes/storagedrawers/cherry_trim" | "ae2:recipes/misc/network/cables/covered_green" | "create:recipes/building_blocks/cut_crimsite_stairs" | "storagedelight:recipes/decorations/oak_bookshelf_with_door" | "securitycraft:recipes/building_blocks/reinforced_dark_oak_wood" | "tconstruct:recipes/decorations/common/glass/black_clear_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_veridium_stairs" | "createbigcannons:recipes/misc/machine_gun_round" | "minecraft:recipes/building_blocks/gold_block" | "vs_tournament:balloon_pop" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_blue_stained_glass" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_bricks_from_short_dean_bricks_stonecutting" | "createdeco:recipes/decorations/copper_mesh_fence_from_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_slashed_locometal" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_short_red_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_pillar" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab" | "minecraft:recipes/decorations/armor_stand" | "spelunkery:recipes/diamond_shard" | "design_decor:recipes/building_blocks/granite_castel_bricks_from_stone_types_granite_stonecutting" | "create_dd:recipes/create_dd.palettes/blue_padded_mosaic_rubber_from_blue_rubber_decor_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "design_decor:recipes/building_blocks/red_metal_plate_from_metal_plate_stonecutting" | "minecraft:recipes/transportation/acacia_boat" | "minecraft:recipes/redstone/iron_trapdoor" | "createdeco:recipes/building_blocks/short_dusk_bricks_from_long_dusk_bricks_stonecutting" | "railways:recipes/misc/crafting/buffer" | "createdeco:recipes/decorations/andesite_trapdoor" | "ae2:recipes/misc/materials/formationcore" | "tfmg:recipes/building_blocks/cut_galena_bricks_from_stone_types_galena_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs" | "vinery:recipes/mangrove_wine_rack_big" | "create_dd:recipes/create_dd.palettes/green_padded_mosaic_rubber_from_green_rubber_decor_stonecutting" | "securitycraft:recipes/misc/scanner_door_item" | "minecraft:recipes/decorations/jungle_fence" | "create_enchantment_industry:gone_with_the_foil" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "minecraft:recipes/misc/tide_armor_trim_smithing_template_smithing_trim" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_boiler" | "storagedelight:recipes/decorations/glass_warped_cabinet" | "minecraft:recipes/decorations/mud_brick_wall_from_mud_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_double_stairs_rotate_to_framed_vertical_double_stairs" | "minecraft:recipes/building_blocks/chiseled_quartz_block_from_quartz_block_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_bricks_from_stone_types_packed_mud_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_spruce_stairs" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_pillar" | "tconstruct:recipes/decorations/common/glass/green_clear_stained_glass_pane" | "tconstruct:recipes/decorations/world/wood/enderbark/sign" | "design_decor:recipes/building_blocks/light_gray_metal_plate_stairs_from_metal_plate_stonecutting" | "copycats:recipes/crafting/copycat_folding_door" | "tconstruct:recipes/decorations/gadgets/frame/diamond" | "securitycraft:recipes/building_blocks/reinforced_mangrove_slab" | "ae2:recipes/misc/decorative/sky_stone_brick_from_stonecutting" | "storagedelight:recipes/decorations/cherry_drawer" | "securitycraft:recipes/decorations/reinforced_purple_stained_glass_pane" | "minecraft:recipes/building_blocks/cyan_terracotta" | "framedblocks:recipes/building_blocks/framed_stacked_slope_slab_rotate_to_framed_stacked_slope_panel" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor" | "superbwarfare:recipes/misc/vector_blueprint" | "interiors:recipes/building_blocks/crafting/floor_chair/gray_floor_chair_from_seat" | "createdeco:recipes/decorations/decal_left" | "ae2:recipes/misc/shaped/stairs/fluix_block" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_short_umber_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/io_condenser" | "minecraft:story/follow_ender_eye" | "framedblocks:recipes/building_blocks/framed_elevated_double_slope_slab_rotate_to_framed_extended_double_slope_panel" | "minecraft:recipes/building_blocks/weathered_cut_copper_from_weathered_copper_stonecutting" | "tconstruct:recipes/tools/gadgets/throwball/efln_ball" | "chipped:recipes/glassblower" | "design_decor:recipes/building_blocks/cyan_metal_sheet_slab_from_metal_plate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/ingot_lead_compat_immersiveengineering" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_pillar" | "createdeco:recipes/building_blocks/cracked_umber_brick_slab" | "minecraft:recipes/misc/iron_ingot_from_blasting_raw_iron" | "securitycraft:recipes/tools/codebreaker" | "create:recipes/misc/crafting/materials/brass_ingot_from_compacting" | "computercraft:recipes/redstone/computer_advanced_upgrade" | "create:steam_engine" | "createdeco:recipes/decorations/industrial_iron_trapdoor" | "minecraft:recipes/misc/blue_dye_from_cornflower" | "minecraft:recipes/redstone/slime_block" | "numismatics:recipes/misc/crafting/light_gray_id_card" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_stairs" | "createdeco:recipes/decorations/gold_coinstack" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_wall" | "ae2:recipes/misc/network/cables/glass_cyan" | "minecraft:recipes/building_blocks/acacia_wood" | "minecraft:recipes/decorations/polished_blackstone_brick_wall" | "ae2:recipes/misc/shaped/walls/sky_stone_small_brick" | "alexscaves:alexscaves/conversion_crucible" | "storagedrawers:recipes/storagedrawers/framing_table" | "tconstruct:recipes/redstone/smeltery/seared/gauge" | "framedblocks:recipes/building_blocks/framed_flat_stacked_inner_slope_panel_corner" | "minecraft:recipes/combat/wooden_sword" | "minecraft:recipes/decorations/gray_banner" | "minecraft:recipes/building_blocks/oak_planks" | "create_enchantment_industry:blazes_new_job" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "alexscaves:alexscaves/defeat_magnetron" | "farmersdelight:recipes/food/wheat_dough" | "minecraft:recipes/building_blocks/dye_blue_bed" | "framedblocks:recipes/building_blocks/framed_gold_pressure_plate" | "create_dd:recipes/create_dd.palettes/blue_padded_rubber_stairs_from_blue_rubber_decor_stonecutting" | "ae2:recipes/misc/network/parts/energy_level_emitter" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_slashed_locometal" | "sophisticatedstorage:recipes/misc/chipped/carpenters_table_upgrade" | "minecraft:recipes/building_blocks/black_concrete_powder" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_slab_from_cracked_scarlet_bricks_stonecutting" | "securitycraft:recipes/building_blocks/smooth_crystal_quartz_slab_from_smooth_crystal_quartz_stonecutting" | "farmersdelight:recipes/building_blocks/tatami_block_from_full" | "securitycraft:recipes/redstone/reinforced_acacia_pressure_plate" | "createdeco:recipes/decorations/brass_bars_from_stonecutting" | "minecraft:recipes/building_blocks/mud_bricks" | "vs_eureka:recipes/ship_helm" | "securitycraft:recipes/decorations/reinforced_mud_brick_wall" | "create:recipes/building_blocks/cut_granite_brick_wall" | "minecraft:recipes/food/cooked_porkchop_from_smoking" | "vinery:recipes/dark_cherry_pressure_plate" | "createdeco:recipes/decorations/light_gray_placard_from_dyeing" | "createdeco:recipes/building_blocks/cracked_dean_brick_slab" | "create_dd:recipes/create_dd.palettes/crafting/decor/green_blueprint_block" | "create:recipes/misc/crafting/kinetics/train_trapdoor" | "spelunkery:recipes/rough_lazurite" | "minecraft:recipes/building_blocks/chiseled_nether_bricks" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "createdeco:recipes/decorations/copper_coinstack" | "marbledsfirstaid:marbleds_first_aid/walking_er" | "create_dd:recipes/create_dd.palettes/small_netherrack_brick_slab_recycling" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_fancy_bricks_stonecutting" | "create:millstone" | "create_dd:recipes/create_dd.palettes/yellow_padded_rubber_stairs_from_yellow_rubber_decor_stonecutting" | "computercraft:recipes/redstone/turtle_normal/computercraft/speaker" | "createdeco:recipes/misc/industrial_iron_ingot_from_industrial_iron_block" | "tconstruct:recipes/misc/common/materials/cobalt_ingot_smelting" | "tconstruct:recipes/redstone/world/wood/skyroot/button" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_plated_locometal" | "securitycraft:recipes/building_blocks/reinforced_purple_stained_glass" | "farmersdelight:recipes/cooking/beetroot_soup" | "framedblocks:recipes/building_blocks/framed_flat_double_slope_panel_corner_rotate_to_framed_flat_double_slope_slab_corner" | "tconstruct:recipes/decorations/common/copper_platform_waxing_oxidized" | "minecraft:recipes/redstone/bamboo_button" | "create:recipes/misc/blasting/ingot_silver_compat_ic2" | "minecraft:recipes/decorations/light_gray_carpet" | "create:recipes/building_blocks/cut_diorite_slab_recycling" | "superbwarfare:main/clean_energy" | "minecraft:recipes/misc/rib_armor_trim_smithing_template" | "tconstruct:recipes/decorations/world/wood/enderbark/fence" | "minecraft:recipes/combat/leather_boots" | "minecraft:recipes/misc/red_dye_from_tulip" | "minecraft:husbandry/axolotl_in_a_bucket" | "minecraft:recipes/decorations/cobblestone_wall_from_cobblestone_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_chipped_loom_table_upgrade_from_storage_chipped_loom_table_upgrade" | "minecraft:recipes/decorations/grindstone" | "farmersdelight:recipes/food/sweet_berry_cookie" | "alexscaves:alexscaves/floater" | "minecraft:recipes/building_blocks/diamond_block" | "create_connected:recipes/crafting/kinetics/brass_gearbox_from_conversion" | "securitycraft:recipes/building_blocks/reinforced_chiseled_red_sandstone_from_reinforced_red_sandstone_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_slab_recycling" | "minecraft:recipes/decorations/yellow_carpet" | "minecraft:recipes/building_blocks/stripped_oak_wood" | "interiors:recipes/building_blocks/crafting/floor_chair/pink_floor_chair_from_seat" | "create:recipes/building_blocks/cut_calcite_wall" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_short_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "minecraft:nether/ride_strider_in_overworld_lava" | "create:recipes/building_blocks/polished_cut_andesite_slab_recycling" | "alexscaves:alexscaves/primitive_club" | "securitycraft:recipes/building_blocks/reinforced_red_sandstone_slab" | "design_decor:recipes/building_blocks/tuff_castel_brick_stairs_from_stone_types_tuff_stonecutting" | "framedblocks:recipes/building_blocks/framed_obsidian_pressure_plate" | "framedblocks:recipes/building_blocks/framed_flat_ext_slope_panel_corner" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_slashed_locometal" | "create:recipes/building_blocks/cut_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cracked_stone_bricks" | "sophisticatedstorage:recipes/misc/iron_chest" | "framedblocks:recipes/building_blocks/framed_bars" | "minecraft:recipes/decorations/blue_banner" | "storagedelight:recipes/decorations/acacia_drawer_with_door" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_smokebox" | "create_dd:recipes/create_dd.palettes/cut_gabbro_from_stone_types_gabbro_stonecutting" | "createdeco:recipes/decorations/yellow_placard" | "securitycraft:recipes/building_blocks/redstone_mine" | "minecraft:recipes/building_blocks/dark_prismarine_slab_from_dark_prismarine_stonecutting" | "tconstruct:recipes/decorations/gadgets/frame/gold" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_andesite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_purpur_stairs_from_reinforced_purpur_block_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_fluix" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_from_stone_types_gabbro_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/cut_blackstone_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs" | "create:recipes/misc/crafting/kinetics/copper_valve_handle_from_others" | "minecraft:recipes/decorations/deepslate_brick_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_deepslate_lapis_ore" | "create:recipes/building_blocks/small_ochrum_brick_stairs" | "farmersdelight:recipes/food/potato_from_crate" | "securitycraft:recipes/building_blocks/deepslate_diamond_mine" | "securitycraft:recipes/building_blocks/reinforced_smooth_crystal_quartz_stairs_from_reinforced_smooth_crystal_quartz_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cherry_slab" | "securitycraft:recipes/misc/speed_module" | "cgs:recipes/misc/lead_ingot_from_blasting_deepslate_lead_ore" | "ae2:recipes/misc/tools/portable_item_cell_64k" | "minecraft:recipes/misc/firework_rocket_simple" | "minecraft:nether/summon_wither" | "securitycraft:recipes/building_blocks/suspicious_sand_mine" | "vinery:recipes/flower_box" | "securitycraft:recipes/tools/remote_access_sentry" | "create:recipes/building_blocks/small_scoria_brick_slab_recycling" | "createdeco:recipes/building_blocks/long_umber_bricks_from_tiled_umber_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_wall_from_reinforced_mossy_cobblestone_stonecutting" | "create:recipes/building_blocks/cut_crimsite_brick_wall" | "create:recipes/misc/crafting/kinetics/nozzle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_pillar" | "securitycraft:recipes/misc/reinforced_dark_oak_fence" | "securitycraft:recipes/misc/reinforced_oak_fence" | "design_decor:recipes/building_blocks/cyan_metal_plate_slab_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper_from_reinforced_oxidized_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_riveted_locometal" | "create:recipes/building_blocks/polished_cut_ochrum_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/dense_smart_orange" | "minecraft:recipes/building_blocks/red_nether_brick_slab" | "minecraft:recipes/building_blocks/cobblestone_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_riveted_locometal" | "createdeco:recipes/decorations/andesite_hull" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_short_red_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/green_slashed_locometal" | "securitycraft:recipes/building_blocks/reinforced_oak_planks" | "create:burner" | "createdeco:recipes/decorations/brass_hull" | "minecraft:recipes/decorations/pink_banner" | "create_dd:recipes/create_dd.palettes/brown_padded_mosaic_rubber_from_brown_rubber_decor_stonecutting" | "farmersdelight:recipes/food/pie_crust" | "farmersdelight:recipes/combat/iron_knife" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_boiler" | "superbwarfare:recipes/combat/k_98_smithing" | "create_dd:recipes/create_dd.palettes/cut_netherrack_slab_from_stone_types_netherrack_stonecutting" | "design_decor:recipes/building_blocks/veridium_castel_brick_stairs_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_copper_from_honeycomb" | "design_decor:recipes/building_blocks/orange_metal_sheet_slab_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "create_dd:recipes/create_dd.base/crafting/coal_piece_from_coal" | "smallships:recipes/transportation/bamboo_brigg" | "ae2:recipes/misc/network/cables/covered_light_gray" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "ae2:recipes/misc/network/cables/smart_brown" | "create:recipes/building_blocks/cut_granite_wall" | "minecraft:recipes/building_blocks/prismarine_slab" | "minecraft:recipes/decorations/orange_carpet" | "securitycraft:recipes/misc/green_lens" | "create:recipes/misc/crafting/kinetics/mechanical_piston" | "vinery:recipes/big_table" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_plated_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_crafting" | "create_dd:recipes/create_dd.palettes/small_blackstone_brick_slab" | "securitycraft:recipes/redstone/reinforced_oak_fence_gate" | "alexscaves:alexscaves/extinction_spear" | "minecraft:recipes/decorations/warped_hanging_sign" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_stairs_from_reinforced_cobbled_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal_boiler" | "create:shifting_gears" | "create:recipes/misc/crafting/kinetics/encased_fan" | "framedblocks:recipes/building_blocks/framed_slab_corner" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_boiler" | "sophisticatedstorage:recipes/misc/storage_smelting_upgrade_from_backpack_smelting_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_plated_locometal" | "ae2:recipes/misc/materials/cardredstone" | "design_decor:recipes/building_blocks/diorite_castel_brick_wall_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/conductor_whistle" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stonecutting" | "storagedelight:recipes/decorations/spruce_drawer" | "ae2:recipes/misc/network/parts/toggle_bus" | "securitycraft:recipes/building_blocks/reinforced_red_sandstone_stairs" | "ae2:recipes/misc/shaped/stairs/sky_stone_brick" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_hoe" | "create:recipes/building_blocks/cut_diorite_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "dragnvehicles:recipes/misc/sport_car" | "mts:root" | "create_dd:recipes/create_dd.palettes/cut_dolomite_brick_wall_from_stone_types_dolomite_stonecutting" | "createdeco:recipes/decorations/copper_sheet_metal" | "tconstruct:foundry/manyullyn_lanterns" | "securitycraft:recipes/building_blocks/reinforced_quartz_slab_from_reinforced_quartz_block_stonecutting" | "create_dd:recipes/create_dd.palettes/pink_padded_tiled_rubber_from_pink_rubber_decor_stonecutting" | "framedblocks:recipes/building_blocks/framed_stairs_rotate_to_framed_vertical_stairs" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/dean_brick_stairs" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_granite_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/light_blue_chair_from_other_chair" | "securitycraft:recipes/misc/reinforced_bamboo_fence" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_wall_from_stone_types_amethyst_block_stonecutting" | "create:track_crafting_factory" | "create:recipes/misc/crafting/kinetics/framed_glass_door" | "securitycraft:recipes/misc/reinforced_nether_brick_fence" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_stairs_from_stone_types_stone_stonecutting" | "create:recipes/building_blocks/polished_cut_dripstone_stairs" | "minecraft:recipes/building_blocks/cyan_concrete_powder" | "create_dd:recipes/create_dd.palettes/white_padded_mosaic_rubber_from_white_rubber_decor_stonecutting" | "securitycraft:recipes/misc/red_lens" | "ae2:recipes/misc/tools/misctools_entropy_manipulator" | "create:recipes/misc/crafting/materials/electron_tube" | "design_decor:recipes/building_blocks/dripstone_castel_brick_wall_from_stone_types_dripstone_stonecutting" | "create_dd:recipes/create_dd.palettes/dark_metal_block_slab_from_dark_metal_decor_stonecutting" | "farmersdelight:recipes/food/cake_from_milk_bottle" | "superbwarfare:recipes/misc/javelin_blueprint" | "create:recipes/building_blocks/cut_tuff_brick_slab_recycling" | "tconstruct:recipes/misc/common/materials/slimesteel_block_from_ingots" | "createdeco:recipes/building_blocks/verdant_brick_slab" | "ae2:main/network_tool" | "create:recipes/building_blocks/polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/decorations/copper_bars_from_ingots_copper_stonecutting" | "securitycraft:recipes/misc/reinforced_crimson_fence" | "securitycraft:recipes/building_blocks/reinforced_smooth_crystal_quartz_stairs" | "design_decor:recipes/building_blocks/scoria_castel_bricks_from_stone_types_scoria_stonecutting" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_1" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_plated_locometal" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_3" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_2" | "sophisticatedstorage:recipes/misc/cherry_limited_barrel_4" | "minecraft:recipes/misc/nether_brick" | "interiors:recipes/building_blocks/crafting/floor_chair/black_floor_chair_from_seat" | "storagedelight:recipes/decorations/oak_drawer_with_door" | "create:recipes/building_blocks/small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "storagedelight:recipes/decorations/bamboo_drawer" | "create:recipes/building_blocks/cut_scorchia_stairs" | "railways:recipes/misc/crafting/handcar" | "securitycraft:recipes/decorations/reinforced_lime_stained_glass_pane" | "farmersdelight:recipes/food/onion" | "crusty_chunks:basic_machine" | "create:recipes/misc/smelting/ingot_silver_compat_immersiveengineering" | "create_dd:recipes/create_dd.palettes/cut_gabbro_brick_wall_from_stone_types_gabbro_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "design_decor:recipes/building_blocks/purple_metal_sheet_wall_from_metal_plate_stonecutting" | "numismatics:recipes/misc/crafting/cyan_card" | "ae2:recipes/misc/shaped/slabs/cut_quartz_block" | "superbwarfare:recipes/combat/m_79_smithing" | "create:recipes/building_blocks/jungle_window" | "create_dd:recipes/create.base/fluid_tank_from_fluid_reservoir_stonecutting" | "createdeco:recipes/decorations/copper_catwalk_stairs" | "railways:recipes/combat/dying_existing_cap_pink" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_slashed_locometal" | "minecraft:recipes/building_blocks/polished_deepslate_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_slashed_locometal" | "minecraft:recipes/decorations/shulker_box" | "tfmg:recipes/building_blocks/cut_galena_slab" | "createdeco:recipes/decorations/andesite_support" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_boiler" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/layered_andesite_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_smokebox" | "securitycraft:recipes/redstone/inventory_scanner" | "securitycraft:recipes/misc/door_indestructible_iron_item" | "farmersdelight:recipes/food/cooked_bacon" | "ae2:recipes/misc/network/cables/covered_white" | "framedblocks:recipes/building_blocks/framed_stacked_inner_corner_slope_panel" | "create_dd:recipes/create_dd.palettes/crafting/decor/white_asphalt_block" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab" | "createdeco:recipes/building_blocks/mossy_dean_bricks_from_vine" | "copycats:recipes/crafting/copycat_sliding_door" | "numismatics:recipes/misc/crafting/banking_guide" | "design_decor:recipes/building_blocks/magenta_metal_sheet_stairs_from_metal_plate_stonecutting" | "vinery:main/the_noble_drop" | "storagedelight:recipes/decorations/crimson_single_door_cabinet" | "vinery:recipes/grass_slab" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_stairs_from_reinforced_polished_deepslate_stonecutting" | "tconstruct:recipes/decorations/common/glass/light_gray_clear_stained_glass_pane_from_panes" | "design_decor:recipes/building_blocks/granite_castel_tile_slab_from_stone_types_granite_stonecutting" | "minecraft:recipes/transportation/powered_rail" | "createdeco:recipes/building_blocks/short_blue_bricks_from_tiled_blue_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/red_clear_stained_glass_pane_from_panes" | "minecraft:recipes/misc/iron_ingot_from_nuggets" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "tconstruct:smeltery/tool_forge" | "minecraft:recipes/transportation/jungle_boat" | "create_dd:recipes/create_dd.palettes/brown_padded_tiled_rubber_from_brown_rubber_decor_stonecutting" | "createdeco:recipes/decorations/locked_andesite_door" | "ae2:recipes/misc/network/cables/dense_smart_gray" | "createbigcannons:recipes/misc/hardened_nitro" | "design_decor:recipes/building_blocks/purple_metal_plate_wall_from_metal_plate_stonecutting" | "tconstruct:recipes/food/gadgets/cake/ichor" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "minecraft:story/enter_the_end" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal" | "tconstruct:recipes/building_blocks/world/wood/greenheart/stripped_log_to_wood" | "comforts:hammock_orange" | "minecraft:recipes/building_blocks/stone_stairs" | "create_dd:recipes/create_dd.palettes/cut_stone_bricks_from_stone_types_stone_stonecutting" | "tfmg:recipes/building_blocks/nickel_truss_from_ingots_nickel_stonecutting" | "create:recipes/misc/smelting/iron_ingot_from_crushed" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_slashed_locometal" | "minecraft:recipes/building_blocks/purpur_slab_from_purpur_block_stonecutting" | "minecraft:recipes/transportation/rail" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "vs_eureka:recipes/balloon_membrane" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_slab_stonecutter" | "storagedrawers:recipes/storagedrawers/gold_storage_upgrade" | "createdeco:recipes/decorations/copper_catwalk_railing_forge" | "farmersdelight:recipes/decorations/full_tatami_mat" | "create:recipes/misc/blasting/ingot_aluminium_compat_ic2" | "create_dd:recipes/create_dd.palettes/cut_stone_from_stone_types_stone_stonecutting" | "farmersdelight:recipes/food/horse_feed" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_honeycomb" | "securitycraft:recipes/building_blocks/reinforced_cracked_deepslate_tiles" | "minecraft:recipes/redstone/lever" | "create:recipes/decorations/andesite_scaffolding_from_andesite_alloy_stonecutting" | "farmersdelight:recipes/cooking/dog_food" | "createbigcannons:recipes/misc/basin_foundry_lid" | "minecraft:nether/obtain_crying_obsidian" | "framedblocks:recipes/building_blocks/framed_panel" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "securitycraft:recipes/decorations/secret_crimson_sign_item" | "tconstruct:recipes/tools/gadgets/throwball/glow_ball" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_brass_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/stone_pillar_from_stone_types_stone_stonecutting" | "create:recipes/building_blocks/polished_cut_limestone_wall_from_stone_types_limestone_stonecutting" | "minecraft:recipes/misc/pink_dye_from_pink_petals" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_slashed_locometal" | "superbwarfare:recipes/combat/m_4_smithing" | "farmersdelight:main/place_cooking_pot" | "minecraft:husbandry/froglights" | "create:recipes/building_blocks/small_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_pillar" | "create:recipes/building_blocks/cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_bricks_from_vine" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "create:recipes/building_blocks/cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_riveted_locometal" | "createdeco:recipes/building_blocks/verdant_bricks_from_long_verdant_bricks_stonecutting" | "create_dd:recipes/create_dd.base/crafting/industrial_fan" | "securitycraft:recipes/decorations/reinforced_orange_stained_glass_pane_from_dye" | "securitycraft:recipes/building_blocks/reinforced_blackstone_stairs" | "sophisticatedbackpacks:recipes/misc/advanced_void_upgrade" | "railways:recipes/misc/crafting/portable_fuel_interface" | "alexscaves:alexscaves/ride_nuclear_bomb" | "minecraft:recipes/building_blocks/lime_terracotta" | "create:recipes/building_blocks/small_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "createdeco:recipes/decorations/decal_right" | "design_decor:recipes/building_blocks/gray_metal_sheet_from_metal_plate_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_wall_stonecutter" | "minecraft:recipes/building_blocks/light_gray_terracotta" | "create:ejector_maxed" | "interiors:recipes/building_blocks/crafting/chair/purple_chair_from_seat" | "createdeco:recipes/building_blocks/tiled_scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_scarlet_brick_slab_stonecutting" | "spelunkery:recipes/phosphor_fungus" | "create:recipes/building_blocks/cut_limestone_bricks_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/materials/brass_ingot_from_decompacting" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_long_dean_bricks_stonecutting" | "farmersdelight:recipes/food/smoked_ham" | "spelunkery:spelunkery/rock_salt" | "comforts:sleeping_bag_pink" | "create:recipes/misc/crafting/kinetics/speedometer" | "securitycraft:recipes/building_blocks/reinforced_crimson_stairs" | "securitycraft:recipes/building_blocks/reinforced_white_glazed_terracotta" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_stairs" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/button" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "comforts:hammock_magenta" | "ae2:main/charger" | "createdeco:recipes/building_blocks/pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "create:recipes/building_blocks/cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/pink_concrete_powder" | "minecraft:recipes/building_blocks/sandstone_slab" | "createdeco:recipes/building_blocks/cracked_dean_brick_stairs_from_cracked_dean_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_glowing_item_frame" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper" | "securitycraft:recipes/building_blocks/reinforced_pink_carpet_from_dye" | "securitycraft:recipes/decorations/secret_oak_hanging_sign" | "ae2:recipes/misc/network/cables/glass_green" | "alexscaves:alexscaves/radiant_essence" | "vinery:recipes/dark_oak_wine_rack_big" | "create_dd:recipes/create_dd.base/crafting/raw_rubber_from_raw_rubber_block" | "createdeco:recipes/building_blocks/cracked_red_brick_slab" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tiles_from_reinforced_deepslate_bricks_stonecutting" | "minecraft:story/obtain_armor" | "create:recipes/building_blocks/polished_cut_andesite_stairs" | "create_dd:recipes/create_dd.palettes/dark_metal_block_from_dark_metal_decor_stonecutting" | "create:diving_suit" | "framedblocks:recipes/building_blocks/framed_stone_pressure_plate" | "securitycraft:recipes/building_blocks/reinforced_yellow_terracotta" | "tfmg:recipes/building_blocks/small_galena_brick_stairs_from_stone_types_galena_stonecutting" | "minecraft:recipes/decorations/gray_stained_glass_pane" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "tconstruct:recipes/redstone/world/wood/skyroot/pressure_plate" | "create:recipes/building_blocks/small_diorite_bricks_from_stone_types_diorite_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smelting" | "smallships:recipes/transportation/bamboo_cog" | "interiors:recipes/building_blocks/crafting/chair/white_chair" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal_boiler" | "securitycraft:recipes/building_blocks/reinforced_light_gray_wool" | "tconstruct:recipes/decorations/tables/tinkers_anvil" | "create:recipes/building_blocks/layered_diorite_from_stone_types_diorite_stonecutting" | "tconstruct:world/piggybackpack" | "sophisticatedstorage:recipes/misc/iron_to_gold_tier_upgrade" | "storagedelight:recipes/decorations/birch_drawer_with_door" | "create_dd:recipes/create_dd.palettes/cut_basalt_brick_slab_recycling" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_verdant_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "createdeco:recipes/decorations/copper_bars_from_stonecutting" | "sophisticatedstorage:recipes/misc/compression_upgrade" | "superbwarfare:recipes/combat/hunting_rifle_smithing" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_plated_locometal" | "design_decor:recipes/building_blocks/tinted_framed_glass_from_glass_tinted_stonecutting" | "tconstruct:recipes/redstone/smeltery/seared/ingot_gauge" | "create:recipes/building_blocks/polished_cut_deepslate_slab" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_stairs" | "vinery:recipes/basket" | "vinery:recipes/stackable_log" | "create_dd:recipes/create_dd.palettes/cut_gabbro_brick_slab" | "cgs:recipes/misc/lead_block_from_lead_ingot" | "minecraft:recipes/decorations/orange_candle" | "create:recipes/building_blocks/asurine_pillar_from_stone_types_asurine_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper_from_reinforced_weathered_copper_stonecutting" | "farmersdelight:main/place_skillet" | "create:encased_fan" | "create:recipes/building_blocks/cut_diorite_wall_from_stone_types_diorite_stonecutting" | "ae2:recipes/misc/shaped/slabs/chiseled_quartz_block" | "minecraft:recipes/building_blocks/waxed_weathered_copper_from_honeycomb" | "minecraft:recipes/misc/iron_nugget_from_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_plated_locometal" | "create:recipes/misc/crafting/kinetics/cuckoo_clock" | "numismatics:recipes/misc/crafting/purple_id_card" | "minecraft:recipes/misc/copper_ingot_from_smelting_copper_ore" | "createbigcannons:recipes/misc/delayed_impact_fuze" | "ae2:recipes/misc/block_cutter/stairs/quartz_brick_stairs" | "superbwarfare:recipes/misc/cemented_carbide_barrel" | "minecraft:recipes/food/baked_potato_from_campfire_cooking" | "create:recipes/building_blocks/cut_deepslate_stairs" | "vinery:recipes/acacia_wine_rack_big" | "createdeco:recipes/building_blocks/blue_brick_slab_from_blue_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/blue_seat_from_other_seat" | "superbwarfare:recipes/combat/small_rocket" | "copycats:recipes/crafting/copycat_ghost_block" | "securitycraft:recipes/misc/blacklist_module" | "create:recipes/building_blocks/limestone_from_stone_types_limestone_stonecutting" | "minecraft:husbandry/make_a_sign_glow" | "create:andesite_alloy" | "minecraft:recipes/building_blocks/dye_lime_wool" | "minecraft:recipes/redstone/acacia_pressure_plate" | "create:water_wheel" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "alexscaves:alexscaves/defeat_luxtructosaurus" | "minecraft:recipes/building_blocks/crimson_slab" | "securitycraft:recipes/building_blocks/reinforced_prismarine_brick_stairs" | "createdeco:recipes/building_blocks/mossy_verdant_brick_slab_from_mossy_verdant_bricks_stonecutting" | "design_decor:recipes/building_blocks/limestone_castel_bricks_from_stone_types_limestone_stonecutting" | "superbwarfare:main/hammer" | "ae2:recipes/misc/tools/paintballs_lumen_pink" | "create:recipes/building_blocks/vertical_framed_glass_from_glass_colorless_stonecutting" | "ae2:recipes/misc/shaped/walls/quartz_bricks" | "tconstruct:recipes/decorations/common/glass/yellow_clear_stained_glass_pane_from_panes" | "ae2:recipes/misc/network/cables/glass_light_blue" | "create_dd:recipes/create_dd.palettes/small_packed_mud_brick_wall" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_tiled_scarlet_bricks_stonecutting" | "minecraft:recipes/building_blocks/green_stained_glass" | "sophisticatedstorage:recipes/misc/crimson_barrel" | "ae2:recipes/misc/network/parts/annihilation_plane_alt" | "create_dd:recipes/create_dd.palettes/orange_padded_tiled_rubber_from_orange_rubber_decor_stonecutting" | "ae2:recipes/misc/network/cables/glass_black" | "create:recipes/building_blocks/small_granite_brick_slab_recycling" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_stairs" | "ae2:recipes/misc/network/blocks/pattern_providers_interface" | "create:recipes/building_blocks/small_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "minecraft:recipes/building_blocks/bookshelf" | "ae2:recipes/misc/block_cutter/stairs/fluix_stairs" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_long_dean_bricks_stonecutting" | "mts:fuelpump" | "tconstruct:recipes/decorations/common/glass/light_blue_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "securitycraft:recipes/decorations/reinforced_andesite_wall" | "tconstruct:recipes/decorations/world/wood/skyroot/hanging_sign" | "securitycraft:recipes/building_blocks/crystal_quartz_bricks_from_crystal_quartz_stonecutting" | "tconstruct:recipes/decorations/common/copper_platform_waxing_unaffected" | "computercraft:recipes/redstone/monitor_normal" | "createdeco:recipes/building_blocks/cracked_pearl_brick_stairs_from_cracked_pearl_bricks_stonecutting" | "create:recipes/building_blocks/small_tuff_bricks_from_stone_types_tuff_stonecutting" | "minecraft:story/iron_tools" | "ae2:recipes/misc/tools/certus_quartz_axe" | "securitycraft:recipes/building_blocks/reinforced_deepslate_bricks_from_reinforced_cobbled_deepslate_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_vertical_framed_glass_pane" | "createdeco:recipes/building_blocks/mossy_pearl_brick_slab_from_mossy_pearl_bricks_stonecutting" | "minecraft:recipes/combat/iron_chestplate" | "createdeco:recipes/decorations/brass_catwalk_stairs" | "alexscaves:alexscaves/feed_gummy_bear" | "tconstruct:recipes/redstone/common/slime/ichor/slimeblock" | "securitycraft:recipes/redstone/reinforced_cherry_button" | "create_dd:recipes/create_dd.base/crafting/fan_catalyst/sanding_sail" | "sophisticatedstorage:recipes/misc/void_upgrade" | "minecraft:recipes/redstone/oak_trapdoor" | "securitycraft:recipes/building_blocks/reinforced_cherry_stairs" | "tconstruct:recipes/food/gadgets/cake/magma" | "create_connected:recipes/crafting/kinetics/inverted_gearshift_from_conversion" | "create_dd:recipes/create_dd.palettes/small_basalt_brick_wall" | "securitycraft:recipes/building_blocks/reinforced_lime_stained_glass" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed" | "create:recipes/building_blocks/limestone_pillar_from_stone_types_limestone_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/mason_table_upgrade" | "alexscaves:alexscaves/breed_grottoceratops" | "create:honey_drain" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "design_decor:recipes/building_blocks/cyan_metal_plate_stairs_from_metal_plate_stonecutting" | "create_dd:recipes/create_dd.palettes/gray_padded_mosaic_rubber_from_gray_rubber_decor_stonecutting" | "minecraft:recipes/building_blocks/purpur_slab" | "createdeco:recipes/decorations/green_iron_lamp" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_block" | "minecraft:recipes/combat/stone_sword" | "minecraft:recipes/decorations/cobblestone_wall" | "createdeco:recipes/building_blocks/pearl_bricks_from_long_pearl_bricks_stonecutting" | "securitycraft:recipes/redstone/alarm" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_short_umber_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor_alt" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tiles_from_reinforced_polished_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_smokebox" | "create:recipes/misc/smelting/ingot_lead_compat_mekanism" | "vinery:recipes/jungle_wine_rack_small" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_1" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_2" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_3" | "sophisticatedstorage:recipes/misc/oak_limited_barrel_4" | "create:recipes/building_blocks/cut_asurine_from_stone_types_asurine_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/magenta_chair_from_seat" | "framedblocks:recipes/building_blocks/framed_horizontal_pane" | "framedblocks:recipes/building_blocks/framed_elevated_slope_slab" | "create_dd:recipes/create_dd.base/cog_crank" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_wall_from_reinforced_stone_stonecutting" | "minecraft:recipes/decorations/red_stained_glass_pane" | "minecraft:recipes/food/dried_kelp_from_campfire_cooking" | "securitycraft:recipes/building_blocks/reinforced_red_stained_glass" | "numismatics:recipes/misc/crafting/gray_card" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_stairs" | "securitycraft:recipes/decorations/reinforced_white_stained_glass_pane_from_dye" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal" | "sophisticatedstorage:recipes/misc/spruce_chest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_riveted_locometal" | "framedblocks:recipes/building_blocks/framed_flat_inner_slope_panel_corner_rotate_to_framed_flat_inner_slope_slab_corner" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_stairs_from_reinforced_deepslate_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_blue_bricks_stonecutting" | "minecraft:recipes/misc/gold_nugget_from_smelting" | "createdeco:recipes/decorations/copper_mesh_fence" | "ae2:recipes/misc/tools/misctools_charged_staff" | "minecraft:recipes/misc/netherite_upgrade_smithing_template" | "minecraft:recipes/tools/stone_axe" | "securitycraft:recipes/building_blocks/reinforced_quartz_pillar_from_reinforced_quartz_block_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_warped_slab" | "comforts:sleeping_bag_light_gray" | "minecraft:recipes/decorations/blue_candle" | "create_dd:recipes/create_dd.palettes/cut_netherrack_brick_slab_from_stone_types_netherrack_stonecutting" | "tfmg:recipes/building_blocks/brass_truss_from_ingots_brass_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_scarlet_brick_slab_stonecutting" | "superbwarfare:recipes/combat/rpk_smithing" | "tconstruct:recipes/misc/common/materials/rose_gold_ingot_from_nuggets" | "vinery:recipes/birch_wine_rack_big" | "interiors:recipes/building_blocks/crafting/floor_chair/green_floor_chair_from_seat" | "create:recipes/misc/blasting/zinc_ingot_from_raw_ore" | "tconstruct:recipes/redstone/smeltery/seared/fuel_tank" | "vinery:recipes/loam_stairs" | "securitycraft:recipes/misc/limited_use_keycard" | "minecraft:nether/ride_strider" | "createdeco:recipes/building_blocks/short_dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "securitycraft:recipes/misc/crystal_quartz_item" | "securitycraft:recipes/building_blocks/reinforced_granite_stairs_from_reinforced_granite_stonecutting" | "chipped:recipes/tinkering_table" | "vinery:recipes/wine_bottle" | "securitycraft:recipes/misc/bouncing_betty" | "superbwarfare:main/physics_excalibur" | "tconstruct:smeltery/tinkers_anvil" | "createdeco:recipes/building_blocks/short_pearl_bricks_from_long_pearl_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/carpenters_table_upgrade" | "storagedrawers:recipes/storagedrawers/jungle_drawers" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/misc/iron_nugget" | "alexscaves:alexscaves/radgill_bucket" | "create:recipes/building_blocks/cut_calcite_slab_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/blue_stained_glass" | "create:self_deploying" | "petrolpark:badge_root" | "framedblocks:recipes/building_blocks/framed_flat_elev_inner_double_slope_slab_corner" | "computercraft:recipes/redstone/wired_modem_full_from" | "framedblocks:recipes/building_blocks/framed_flat_stacked_inner_slope_slab_corner" | "framedblocks:recipes/building_blocks/framed_activator_rail_slope" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_slab_stonecutter" | "design_decor:recipes/building_blocks/yellow_metal_sheet_stairs_from_metal_plate_stonecutting" | "dragnvehicles:recipes/misc/suv" | "securitycraft:recipes/building_blocks/reinforced_light_blue_glazed_terracotta" | "farmersdelight:recipes/decorations/cyan_hanging_canvas_sign" | "tconstruct:smeltery/cast_collector" | "minecraft:recipes/building_blocks/cut_copper_slab_from_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_riveted_locometal" | "copycats:recipes/crafting/copycat_stone_pressure_plate" | "create_dd:recipes/create_dd.palettes/purple_padded_tiled_rubber_from_purple_rubber_decor_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_iron_ore" | "casinocraft:recipes/decorations/wool_black" | "securitycraft:recipes/building_blocks/reinforced_magenta_terracotta" | "mts:decorbench" | "createdeco:recipes/building_blocks/short_verdant_brick_slab" | "minecraft:recipes/misc/bucket" | "securitycraft:recipes/building_blocks/reinforced_granite_slab_from_reinforced_granite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal" | "ae2:main/qnb" | "minecraft:recipes/building_blocks/diorite_slab" | "minecraft:adventure/bullseye" | "create:recipes/building_blocks/polished_cut_veridium_slab_from_stone_types_veridium_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_stone_bricks_from_reinforced_stone_stonecutting" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_shovel" | "minecraft:recipes/decorations/orange_stained_glass_pane" | "create:recipes/building_blocks/small_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "createdeco:recipes/decorations/zinc_mesh_fence" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_slab_from_reinforced_deepslate_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/mechanical_roller" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_smokebox" | "createdeco:recipes/decorations/blue_brass_lamp" | "create_dd:recipes/create_dd.palettes/small_dolomite_brick_stairs_from_stone_types_dolomite_stonecutting" | "design_decor:recipes/building_blocks/yellow_metal_sheet_from_metal_plate_stonecutting" | "design_decor:recipes/building_blocks/tuff_castel_tile_slab_from_stone_types_tuff_stonecutting" | "minecraft:recipes/combat/bow" | "minecraft:recipes/building_blocks/acacia_slab" | "minecraft:recipes/building_blocks/smooth_sandstone" | "tconstruct:recipes/misc/common/materials/queens_slime_ingot_from_block" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_stairs_from_reinforced_stone_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/walls/smooth_quartz_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_boiler" | "create:recipes/building_blocks/cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "design_decor:recipes/building_blocks/scorchia_castel_tile_wall_from_stone_types_scorchia_stonecutting" | "create_dd:recipes/create_dd.base/music_disc_waltz_of_the_flowers_from_rose_quartz_stonecutting" | "tfmg:recipes/building_blocks/cut_bauxite_wall_from_stone_types_bauxite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_slashed_locometal" | "cgs:recipes/misc/long_barrel" | "farmersdelight:recipes/decorations/safety_net" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_small_brick_slab" | "dragnvehicles:recipes/misc/sport_car_body" | "minecraft:recipes/decorations/orange_glazed_terracotta" | "farmersdelight:recipes/food/cooked_salmon_slice_from_smoking" | "design_decor:recipes/building_blocks/brown_metal_sheet_wall_from_metal_plate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_plated_locometal" | "numismatics:recipes/misc/crafting/light_blue_id_card" | "create:recipes/misc/crafting/materials/copper_nugget" | "minecraft:recipes/decorations/green_stained_glass_pane" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper_from_reinforced_exposed_copper_stonecutting" | "create_dd:recipes/create_dd.palettes/layered_basalt_from_stone_types_basalt_stonecutting" | "design_decor:recipes/building_blocks/scorchia_castel_tile_stairs_from_stone_types_scorchia_stonecutting" | "copycats:recipes/crafting/copycat_byte_panel" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "ae2:recipes/misc/network/cables/glass_pink" | "superbwarfare:main/enclave" | "ae2:recipes/misc/tools/network_memory_card" | "cgs:recipes/misc/flintlock" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_slashed_locometal" | "farmersdelight:recipes/decorations/magenta_hanging_canvas_sign" | "create:steam_engine_maxed" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_short_blue_brick_stairs_stonecutting" | "vinery:recipes/flower_pot" | "minecraft:story/enter_the_nether" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal" | "securitycraft:recipes/decorations/reinforced_pink_carpet" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_bricks_stonecutting" | "computercraft:recipes/redstone/cable" | "tconstruct:world/sky_island" | "create:recipes/misc/crafting/kinetics/filter" | "create:recipes/building_blocks/cut_andesite_stairs" | "createdeco:recipes/building_blocks/cracked_verdant_brick_stairs_from_cracked_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_plated_locometal" | "create:recipes/building_blocks/cut_limestone_brick_stairs" | "create:recipes/misc/crafting/kinetics/white_sail" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_slab_from_honeycomb" | "create:recipes/misc/crafting/tree_fertilizer" | "securitycraft:recipes/decorations/reinforced_moss_carpet" | "securitycraft:recipes/building_blocks/reinforced_chiseled_sandstone_from_reinforced_sandstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_basalt" | "computercraft:recipes/redstone/pocket_advanced/computercraft/speaker" | "storagedelight:recipes/decorations/cherry_single_door_cabinet" | "tconstruct:recipes/redstone/world/wood/enderbark/trapdoor" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_slashed_locometal" | "minecraft:recipes/misc/pink_dye_from_pink_tulip" | "minecraft:recipes/building_blocks/mangrove_stairs" | "createdeco:recipes/building_blocks/mossy_umber_bricks_from_vine" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_wall_from_reinforced_end_stone_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_white_wool" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade" | "advancedperipherals:recipes/redstone/environment_detector" | "vinery:main/nectar_of_life" | "sophisticatedstorage:recipes/misc/storage_crafting_upgrade_from_backpack_crafting_upgrade" | "alexscaves:alexscaves/gingerbread_armor" | "minecraft:recipes/decorations/spruce_sign" | "sophisticatedstorage:recipes/misc/iron_to_diamond_tier_upgrade" | "framedblocks:recipes/building_blocks/framed_pyramid" | "sophisticatedbackpacks:recipes/misc/diamond_backpack" | "create:recipes/building_blocks/cut_calcite_brick_wall" | "securitycraft:recipes/building_blocks/reinforced_polished_granite_slab" | "createdeco:recipes/decorations/iron_bars_overlay" | "securitycraft:recipes/decorations/secret_spruce_hanging_sign" | "design_decor:recipes/building_blocks/metal_sheet_from_ingots_iron_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_2_from_storage_stack_upgrade_tier_3" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_pillar" | "tfmg:recipes/building_blocks/polished_cut_bauxite_from_stone_types_bauxite_stonecutting" | "createdeco:recipes/decorations/decal_fire_diamond" | "ae2:main/crafting_terminal" | "design_decor:recipes/building_blocks/lime_metal_sheet_wall_from_metal_plate_stonecutting" | "createdeco:recipes/decorations/purple_shipping_container" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_brick_slab_from_stone_types_weathered_limestone_stonecutting" | "securitycraft:recipes/redstone/block_change_detector" | "minecraft:recipes/combat/netherite_leggings_smithing" | "createdeco:recipes/building_blocks/short_blue_brick_slab" | "storagedelight:recipes/decorations/glass_acacia_cabinet" | "securitycraft:recipes/building_blocks/reinforced_dark_prismarine_slab" | "tconstruct:recipes/smeltery/seared/seared_brick_kiln" | "minecraft:recipes/building_blocks/red_terracotta" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_slab_from_stone_types_gabbro_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_purple" | "interiors:recipes/building_blocks/crafting/floor_chair/red_floor_chair_from_other_floor_chair" | "create_dd:recipes/create_dd.palettes/light_blue_padded_mosaic_rubber_from_light_blue_rubber_decor_stonecutting" | "create_dd:recipes/create_dd.palettes/dark_metal_block_stairs_from_dark_metal_decor_stonecutting" | "create:recipes/building_blocks/small_diorite_brick_slab_recycling" | "tconstruct:recipes/misc/common/materials/cinderslime_ingot_from_block" | "interiors:recipes/building_blocks/crafting/floor_chair/light_blue_floor_chair_from_seat" | "createdeco:recipes/building_blocks/mossy_dean_brick_stairs" | "tconstruct:recipes/misc/smeltery/sand_cast" | "storagedelight:recipes/decorations/small_dark_oak_drawers" | "tconstruct:recipes/misc/common/materials/pig_iron_block_from_ingots" | "tconstruct:recipes/redstone/smeltery/seared/drain_retextured" | "create:recipes/building_blocks/crafting/kinetics/red_seat" | "farmersdelight:recipes/decorations/dark_oak_cabinet" | "design_decor:recipes/building_blocks/magenta_metal_plate_slab_from_metal_plate_stonecutting" | "minecraft:recipes/combat/golden_helmet" | "framedblocks:recipes/building_blocks/framed_adj_double_copycat_panel" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_from_reinforced_cobbled_deepslate_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_framed_glass_pane" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_splashing" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_pillar" | "create:recipes/building_blocks/cut_ochrum_stairs" | "minecraft:recipes/building_blocks/brick_slab_from_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_riveted_locometal" | "create_dd:recipes/create_dd.palettes/cut_gabbro_bricks_from_stone_types_gabbro_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_riveted_locometal" | "create:recipes/building_blocks/small_andesite_brick_wall" | "createdeco:recipes/decorations/cyan_shipping_container_from_dyeing_vaults" | "ae2:recipes/misc/block_cutter/slabs/quartz_pillar_slab" | "petrolpark:badge/translator" | "createdeco:recipes/building_blocks/cracked_blue_brick_stairs" | "framedblocks:recipes/building_blocks/framed_flat_elev_inner_double_slope_slab_corner_rotate_to_framed_flat_ext_inner_double_slope_panel_corner" | "securitycraft:recipes/building_blocks/reinforced_stripped_crimson_hyphae" | "create_dd:recipes/create_dd.palettes/cut_stone_stairs" | "design_decor:recipes/building_blocks/pink_metal_sheet_slab_from_metal_plate_stonecutting" | "minecraft:recipes/decorations/composter" | "ae2:recipes/misc/decorative/sky_stone_brick" | "create_dd:recipes/create_dd.palettes/raw_padded_rubber_slab_from_raw_rubber_decor_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/pressure_plate" | "design_decor:recipes/building_blocks/yellow_metal_plate_slab_from_metal_plate_stonecutting" | "create:recipes/building_blocks/cut_ochrum_brick_slab" | "vinery:main/vineyard_visionary" | "create:recipes/building_blocks/dripstone_block_from_stone_types_dripstone_stonecutting" | "sophisticatedstorage:recipes/misc/upgrade_base" | "create:recipes/building_blocks/cut_scorchia_slab" | "tfmg:recipes/building_blocks/polished_cut_galena_wall_from_stone_types_galena_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_pillar" | "ae2:recipes/misc/block_cutter/walls/sky_stone_brick_wall" | "create:recipes/building_blocks/cut_calcite_brick_stairs" | "minecraft:recipes/building_blocks/end_stone_bricks" | "dragnvehicles:recipes/misc/car" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_starter_tier" | "createdeco:recipes/building_blocks/umber_brick_slab" | "create_dd:recipes/create_dd.palettes/black_padded_rubber_stairs_from_black_rubber_decor_stonecutting" | "minecraft:recipes/decorations/glow_item_frame" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_copper_wrapped_locometal" | "minecraft:husbandry/silk_touch_nest" | "minecraft:recipes/building_blocks/dark_prismarine_stairs" | "createdeco:recipes/decorations/orange_placard_from_dyeing" | "securitycraft:recipes/building_blocks/reinforced_red_terracotta" | "create_dd:recipes/create_dd.palettes/crafting/dark_metal_block_slab_from_dark_metal_block_slab" | "createbigcannons:recipes/misc/cast_iron_ingot_from_nuggets" | "securitycraft:recipes/building_blocks/reinforced_oak_slab" | "sophisticatedstorage:recipes/misc/purple_shulker_box_to_sophisticated" | "create:train_roadkill" | "sophisticatedbackpacks:recipes/misc/chipped/glassblower_upgrade" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_brick_slab_recycling" | "securitycraft:recipes/decorations/reinforced_brown_stained_glass_pane_from_dye" | "create_dd:recipes/create_dd.palettes/cut_gabbro_slab_from_stone_types_gabbro_stonecutting" | "createdeco:recipes/misc/industrial_iron_block" | "design_decor:recipes/building_blocks/magenta_metal_plate_stairs_from_metal_plate_stonecutting" | "comforts:sleeping_bag_magenta" | "framedblocks:recipes/building_blocks/framed_slope_panel" | "createdeco:recipes/decorations/andesite_catwalk_from_stonecutting" | "createdeco:recipes/decorations/magenta_shipping_container" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite" | "createdeco:recipes/decorations/zinc_catwalk_forge" | "create:recipes/misc/crafting/kinetics/black_valve_handle_from_other_valve_handle" | "create_dd:recipes/create_dd.palettes/purple_padded_rubber_stairs_from_purple_rubber_decor_stonecutting" | "create:recipes/building_blocks/oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_dolomite_wall_from_stone_types_dolomite_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_advanced_void_upgrade_from_storage_advanced_void_upgrade" | "minecraft:story/smelt_iron" | "minecraft:recipes/misc/orange_dye_from_torchflower" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_gray_padded_rubber_from_light_gray_padded_rubber" | "framedblocks:recipes/misc/framed_reinforcement" | "create:recipes/misc/smelting/ingot_tin_compat_mekanism" | "createbigcannons:recipes/misc/log_cannon_chamber" | "storagedelight:recipes/decorations/crimson_bookshelf_with_door" | "spelunkery:recipes/coal_lump" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "minecraft:recipes/decorations/smoker" | "tcintegrations:recipes/misc/bronze_ingots_from_block" | "create:wrench_goggles" | "vinery:main/juicy_success" | "securitycraft:recipes/tools/universal_block_reinforcer_lvl1" | "railways:recipes/misc/crafting/palettes/wrapping/gray_iron_wrapped_locometal" | "securitycraft:recipes/tools/universal_block_reinforcer_lvl3" | "securitycraft:recipes/building_blocks/reinforced_oak_stairs" | "create_dd:recipes/create_dd.base/crafting/kinetics/inverse_box" | "securitycraft:recipes/tools/universal_block_reinforcer_lvl2" | "framedblocks:recipes/tools/framed_hammer" | "createdeco:recipes/decorations/andesite_support_wedge" | "farmersdelight:recipes/decorations/jungle_cabinet" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/log_to_wood" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "createbigcannons:recipes/misc/impact_fuze" | "alexscaves:alexscaves/polymer_plate" | "create:recipes/misc/blasting/ingot_osmium_compat_mekanism" | "design_decor:recipes/building_blocks/asurine_castel_bricks_from_stone_types_asurine_stonecutting" | "framedblocks:recipes/building_blocks/framed_adj_double_copycat_slab" | "minecraft:husbandry/wax_off" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_slashed_locometal" | "ae2:recipes/misc/decorative/quartz_block" | "securitycraft:recipes/decorations/reinforced_cobbled_deepslate_wall" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_short_blue_brick_stairs_stonecutting" | "farmersdelight:recipes/food/rice_panicle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_riveted_locometal" | "create_dd:recipes/create_dd.palettes/magenta_padded_tiled_rubber_from_magenta_rubber_decor_stonecutting" | "createdeco:recipes/decorations/iron_bars_overlay_from_stonecutting" | "minecraft:recipes/misc/rib_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/lime_candle" | "sophisticatedstorage:recipes/misc/storage_auto_blasting_upgrade_from_backpack_auto_blasting_upgrade" | "minecraft:recipes/building_blocks/emerald_block" | "petrolsparts:differential" | "sophisticatedbackpacks:recipes/misc/chipped/tinkering_table_upgrade" | "securitycraft:recipes/building_blocks/reinforced_bamboo_slab" | "farmersdelight:recipes/cooking/cabbage_rolls" | "tfmg:recipes/building_blocks/concrete_wall_from_concrete_stonecutting" | "minecraft:recipes/redstone/trapped_chest" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_brick_wall" | "tconstruct:world/slimeskull" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "petrolpark:badge/suggestion" | "petrolsparts:colossal_cogwheel_power_many" | "securitycraft:recipes/building_blocks/reinforced_brick_wall_from_reinforced_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_inner_slope_slab_corner_rotate_to_framed_flat_inner_slope_panel_corner" | "createbigcannons:recipes/misc/tracer_tip" | "securitycraft:recipes/building_blocks/reinforced_warped_hyphae" | "create_dd:recipes/create_dd.palettes/crafting/padded_rubber_from_padded_rubber" | "ae2:recipes/misc/tools/nether_quartz_cutting_knife" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_slab" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade_from_basic" | "framedblocks:recipes/building_blocks/framed_elevated_slope_edge" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "casinocraft:recipes/decorations/wool_pink" | "framedblocks:recipes/building_blocks/framed_flat_ext_double_slope_panel_corner" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_1" | "create:rose_quartz" | "tconstruct:recipes/building_blocks/smeltery/scorched/polished_scorched_stone_stonecutting" | "create:recipes/misc/smelting/ingot_uranium_compat_ic2" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_4" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_3" | "ae2:recipes/misc/tools/fluix_axe" | "sophisticatedstorage:recipes/misc/warped_limited_barrel_2" | "minecraft:recipes/building_blocks/sponge" | "createbigcannons:recipes/misc/fixed_cannon_mount" | "create_dd:recipes/create_dd.palettes/crafting/dark_metal_brick_slab_from_dark_metal_brick_slab" | "create:recipes/building_blocks/cut_veridium_wall" | "storagedrawers:recipes/storagedrawers/birch_trim" | "comforts:sleeping_bag_red" | "create:recipes/building_blocks/cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "sophisticatedstorage:recipes/misc/diamond_barrel" | "create:recipes/misc/crafting/schematics/empty_schematic" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_1_from_limited_copper_barrel_1" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "minecraft:recipes/redstone/warped_fence_gate" | "create_dd:recipes/create_dd.palettes/cut_blackstone_slab_from_stone_types_blackstone_stonecutting" | "create:recipes/building_blocks/cut_veridium_brick_slab_recycling" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_stairs_from_reinforced_polished_blackstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal" | "tconstruct:recipes/decorations/world/wood/bloodshroom/sign" | "tconstruct:recipes/decorations/common/glass/gray_clear_stained_glass_pane_from_panes" | "farmersdelight:recipes/food/salmon_roll" | "create:recipes/misc/smelting/glass_pane_from_horizontal_framed_glass_pane" | "create_dd:recipes/create_dd.palettes/blue_padded_rubber_slab_from_blue_rubber_decor_stonecutting" | "design_decor:recipes/building_blocks/tuff_castel_brick_wall_from_stone_types_tuff_stonecutting" | "ae2:recipes/misc/network/crystal_resonance_generator" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_smokebox" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_riveted_locometal" | "cgs:recipes/misc/lead_ingot_from_blasting_raw_lead" | "storagedrawers:recipes/storagedrawers/void_upgrade" | "sophisticatedstorage:recipes/misc/birch_chest_from_quark_birch_chest" | "minecraft:end/dragon_breath" | "create:recipes/misc/blasting/silver_ingot_compat_galosphere" | "securitycraft:recipes/misc/keycard_lv4_reset" | "railways:recipes/combat/dying_existing_cap_purple" | "createdeco:recipes/decorations/andesite_hull_from_stonecutting" | "create:recipes/misc/crafting/kinetics/blue_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_boiler" | "minecraft:recipes/building_blocks/white_concrete_powder" | "create_dd:recipes/create_dd.palettes/cut_stone_slab" | "create:recipes/building_blocks/small_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "securitycraft:recipes/misc/purple_lens" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/stripped_log_to_wood" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_short_blue_brick_stairs_stonecutting" | "minecraft:recipes/misc/music_disc_5" | "create:recipes/building_blocks/cut_dripstone_slab" | "framedblocks:recipes/building_blocks/framed_fence_from_post" | "petrolsparts:coaxial_gear" | "create:recipes/building_blocks/layered_crimsite_from_stone_types_crimsite_stonecutting" | "computercraft:recipes/redstone/disk_drive" | "advancedperipherals:husbandry_automata_core" | "minecraft:recipes/building_blocks/lime_stained_glass" | "create:recipes/misc/crafting/kinetics/stressometerfrom_conversion" | "create:recipes/building_blocks/polished_cut_tuff_wall" | "create_dd:recipes/create_dd.palettes/light_gray_padded_mosaic_rubber_from_light_gray_rubber_decor_stonecutting" | "minecraft:recipes/building_blocks/quartz_pillar_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_tuff_wall" | "minecraft:recipes/redstone/cherry_trapdoor" | "create:recipes/misc/crafting/kinetics/brass_hand" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_pillar" | "create:stressometer_maxed" | "framedblocks:recipes/building_blocks/framed_sloped_stairs" | "minecraft:recipes/decorations/yellow_bed" | "interiors:recipes/building_blocks/crafting/chair/pink_chair" | "create:recipes/building_blocks/layered_ochrum_from_stone_types_ochrum_stonecutting" | "tconstruct:tools/tool_smith" | "createdeco:recipes/building_blocks/mossy_umber_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_smokebox" | "create_dd:recipes/create_dd.palettes/red_padded_rubber_slab_from_red_rubber_decor_stonecutting" | "createbigcannons:recipes/misc/cannon_mount" | "securitycraft:recipes/misc/reinforced_warped_fence" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_slab" | "superbwarfare:recipes/transportation/a_10a_container" | "create:recipes/building_blocks/cut_limestone_stairs" | "superbwarfare:main/cannon_blueprint" | "minecraft:recipes/redstone/cherry_button" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs" | "minecraft:recipes/misc/coal_from_blasting_coal_ore" | "create_connected:recipes/crafting/palettes/copycat_board_compat" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_smokebox" | "securitycraft:recipes/redstone/reinforced_observer" | "ae2:recipes/misc/network/cells/item_storage_cell_4k" | "minecraft:recipes/building_blocks/chiseled_bookshelf" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/appliances/clipboard" | "create:recipes/building_blocks/crafting/kinetics/black_seat_from_other_seat" | "create_dd:recipes/create_dd.palettes/crafting/decor/green_padded_rubber_from_green_padded_rubber" | "overworld_netherite_ore:overworld_netherite" | "framedblocks:recipes/building_blocks/framed_item_frame" | "securitycraft:recipes/building_blocks/reinforced_diorite_wall_from_reinforced_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_boiler" | "securitycraft:recipes/building_blocks/reinforced_brown_glazed_terracotta" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_slashed_locometal" | "createdeco:recipes/decorations/red_brass_lamp" | "createdeco:recipes/decorations/cyan_shipping_container" | "ae2:recipes/misc/tools/paintballs_lumen_purple" | "create:recipes/building_blocks/cut_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "create:crafter_lazy_000" | "minecraft:recipes/building_blocks/nether_brick_stairs_from_nether_bricks_stonecutting" | "create:recipes/building_blocks/copper_shingle_stairs" | "ae2:recipes/misc/network/parts/export_bus" | "create:recipes/misc/crafting/kinetics/linear_chassis" | "create:recipes/building_blocks/cut_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs" | "storagedelight:recipes/decorations/jungle_drawer_with_books" | "create_dd:recipes/create_dd.palettes/weathered_limestone_pillar_from_stone_types_weathered_limestone_stonecutting" | "minecraft:recipes/building_blocks/spruce_wood" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/track_signal" | "ae2:recipes/misc/network/cables/smart_light_gray" | "minecraft:recipes/misc/yellow_dye_from_dandelion" | "petrolpark:badge/developer" | "ae2:recipes/misc/tools/paintballs_lumen_light_gray" | "securitycraft:recipes/redstone/reinforced_polished_blackstone_button" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper_slab_from_reinforced_weathered_copper_stonecutting" | "securitycraft:recipes/decorations/reinforced_mossy_cobblestone_wall" | "cgs:recipes/misc/scope" | "createdeco:recipes/building_blocks/mossy_pearl_bricks_from_vine" | "storagedrawers:recipes/storagedrawers/fill_level_upgrade" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stairs" | "framedblocks:recipes/building_blocks/framed_threeway_corner" | "create:recipes/misc/crafting/kinetics/gantry_carriage" | "securitycraft:recipes/building_blocks/reinforced_spruce_planks" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal_boiler" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_wall" | "create_connected:recipes/crafting/kinetics/sequenced_pulse_generator" | "vinery:recipes/window" | "create:recipes/misc/crafting/kinetics/secondary_linear_chassisfrom_conversion" | "minecraft:recipes/building_blocks/deepslate_bricks_from_polished_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_slashed_locometal" | "storagedelight:recipes/decorations/birch_drawer_with_books" | "design_decor:recipes/building_blocks/diorite_castel_bricks_from_stone_types_diorite_stonecutting" | "minecraft:recipes/misc/black_dye_from_wither_rose" | "minecraft:recipes/misc/bone_meal" | "interiors:recipes/building_blocks/crafting/floor_chair/cyan_floor_chair" | "create:speed_controller" | "computercraft:recipes/redstone/turtle_advanced_overlays/turtle_rainbow_overlay" | "framedblocks:recipes/tools/framed_screwdriver" | "railways:recipes/misc/crafting/palettes/wrapping/blue_copper_wrapped_locometal" | "cgs:recipes/misc/raw_lead_block_from_raw_lead" | "securitycraft:recipes/building_blocks/reinforced_bookshelf" | "create:recipes/building_blocks/tuff_pillar_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/diorite_pillar_from_stone_types_diorite_stonecutting" | "design_decor:recipes/building_blocks/limestone_castel_brick_wall_from_stone_types_limestone_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_slab_from_prismarine_stonecutting" | "alexscaves:alexscaves/defeat_forsaken" | "minecraft:adventure/totem_of_undying" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper_slab_from_reinforced_exposed_copper_stonecutting" | "minecraft:recipes/decorations/cobbled_deepslate_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal_boiler" | "createbigcannons:recipes/misc/big_cannon_sheet_inexpensive" | "minecraft:recipes/building_blocks/prismarine_bricks" | "farmersdelight:recipes/food/chocolate_pie_from_slices" | "design_decor:recipes/building_blocks/light_blue_metal_plate_from_metal_plate_stonecutting" | "minecraft:recipes/decorations/polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_stack_downgrade_tier_2_from_storage_stack_downgrade_tier_2" | "securitycraft:recipes/redstone/reinforced_piston" | "tconstruct:recipes/building_blocks/world/wood/skyroot/planks" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal" | "vinery:recipes/vinemaker_apron" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "minecraft:recipes/decorations/diorite_wall" | "superbwarfare:recipes/misc/ntw_20_blueprint" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_boiler" | "createdeco:recipes/decorations/decal_creeper" | "minecraft:recipes/decorations/stonecutter" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "create_dd:recipes/create_dd.palettes/small_packed_mud_brick_wall_from_stone_types_packed_mud_stonecutting" | "farmersdelight:recipes/food/barbecue_stick" | "createdeco:recipes/decorations/andesite_bars_overlay" | "tconstruct:recipes/misc/common/materials/netherite_ingot_from_nuggets" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "sophisticatedstorage:recipes/misc/storage_advanced_jukebox_upgrade_from_backpack_advanced_jukebox_upgrade" | "create_dd:recipes/create_dd.palettes/magenta_padded_rubber_slab_from_magenta_rubber_decor_stonecutting" | "tconstruct:recipes/misc/common/materials/pig_iron_ingot_from_nuggets" | "ae2:recipes/misc/tools/nether_quartz_spade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal_boiler" | "design_decor:recipes/building_blocks/purple_metal_sheet_from_metal_plate_stonecutting" | "tconstruct:recipes/misc/common/slime/ichor/slimeball_from_congealed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_pillar" | "securitycraft:recipes/building_blocks/reinforced_gray_glazed_terracotta" | "minecraft:recipes/misc/sugar_from_honey_bottle" | "minecraft:recipes/building_blocks/dye_red_carpet" | "createdeco:recipes/decorations/locked_brass_door" | "tconstruct:recipes/misc/common/slime/sky/crystal_growing" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "sophisticatedstorage:recipes/misc/backpack_compacting_upgrade_from_storage_compacting_upgrade" | "securitycraft:recipes/decorations/reinforced_pink_stained_glass_pane_from_dye" | "alexscaves:alexscaves/atlatitan_stomp" | "create:recipes/building_blocks/cut_limestone_brick_wall" | "securitycraft:recipes/building_blocks/reinforced_nether_brick_stairs" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "alexscaves:alexscaves/confection_oven" | "minecraft:recipes/decorations/orange_stained_glass_pane_from_glass_pane" | "dragnvehicles:recipes/misc/sports_engine" | "cgs:recipes/misc/ball" | "sophisticatedstorage:recipes/misc/gold_to_diamond_tier_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_riveted_locometal" | "create:recipes/building_blocks/cut_bauxite_brick_slab_recycling" | "framedblocks:recipes/building_blocks/framed_flat_ext_inner_double_slope_panel_corner" | "createdeco:recipes/decorations/lime_placard" | "brewery:main/netherite_brewmaster" | "tfmg:recipes/building_blocks/polished_cut_bauxite_wall_from_stone_types_bauxite_stonecutting" | "tconstruct:recipes/decorations/common/gold_bars" | "create_dd:recipes/create_dd.palettes/cut_gabbro_wall" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_stairs" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_omega_tier_from_storage_stack_upgrade_omega_tier" | "design_decor:recipes/building_blocks/black_metal_plate_wall_from_metal_plate_stonecutting" | "create_connected:recipes/crafting/kinetics/parallel_gearbox" | "minecraft:recipes/building_blocks/dye_green_bed" | "design_decor:recipes/building_blocks/red_metal_sheet_from_metal_plate_stonecutting" | "design_decor:recipes/building_blocks/diorite_castel_brick_stairs_from_stone_types_diorite_stonecutting" | "tconstruct:recipes/building_blocks/common/slime/sky/congealed" | "securitycraft:recipes/building_blocks/reinforced_crimson_slab" | "minecraft:recipes/building_blocks/quartz_pillar" | "createdeco:recipes/building_blocks/copper_window_pane" | "design_decor:recipes/building_blocks/gray_metal_plate_stairs_from_metal_plate_stonecutting" | "create:recipes/misc/crafting/logistics/powered_latch" | "superbwarfare:main/banzai" | "computercraft:recipes/redstone/turtle_normal" | "spelunkery:recipes/lapis_lazuli_shard" | "ae2:recipes/misc/network/cables/smart_magenta" | "securitycraft:recipes/misc/keycard_lv3_reset" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_short_red_bricks_stonecutting" | "minecraft:recipes/decorations/magenta_bed" | "createdeco:recipes/decorations/zinc_catwalk_stairs_from_stonecutting" | "create:recipes/building_blocks/polished_cut_granite_slab_recycling" | "minecraft:recipes/redstone/honey_block" | "create:recipes/building_blocks/polished_cut_limestone_wall" | "minecraft:recipes/redstone/redstone" | "securitycraft:recipes/building_blocks/reinforced_gray_stained_glass" | "minecraft:recipes/misc/coast_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/blue_bricks_from_tiled_blue_bricks_stonecutting" | "securitycraft:recipes/misc/light_blue_lens" | "railways:recipes/misc/crafting/palettes/wrapping/pink_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_boiler" | "storagedrawers:recipes/storagedrawers/crimson_drawers" | "design_decor:recipes/building_blocks/crimsite_castel_tile_slab_from_stone_types_crimsite_stonecutting" | "framedblocks:recipes/building_blocks/framed_tube" | "minecraft:recipes/transportation/spruce_boat" | "tconstruct:recipes/misc/common/materials/cobalt_ingot_from_nuggets" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_slashed_locometal" | "createbigcannons:recipes/misc/cannon_welder" | "ae2:recipes/misc/network/cables/dense_covered_blue" | "copycats:recipes/crafting/copycat_panel_from_half_panels" | "ae2:recipes/misc/block_cutter/slabs/quartz_slab" | "framedblocks:recipes/building_blocks/framed_extended_slope_panel_rotate_to_framed_elevated_slope_slab" | "securitycraft:recipes/redstone/reinforced_cherry_fence_gate" | "create:recipes/building_blocks/crimsite_pillar_from_stone_types_crimsite_stonecutting" | "copycats:recipes/crafting/copycat_stacked_half_layer_from_conversion" | "securitycraft:recipes/building_blocks/reinforced_birch_stairs" | "securitycraft:recipes/misc/ims" | "create_dd:recipes/misc/crafting/lapis_lazuli_from_lapis_lazuli_shard" | "interiors:recipes/building_blocks/crafting/chair/lime_chair" | "smallships:recipes/transportation/acacia_brigg" | "create_dd:recipes/create_dd.palettes/cut_dolomite_wall" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_smokebox" | "framedblocks:recipes/building_blocks/framed_corner_strip_from_framed_floor_board" | "superbwarfare:recipes/combat/minigun_smithing" | "farmersdelight:recipes/misc/canvas" | "securitycraft:recipes/building_blocks/reinforced_cut_red_sandstone_from_reinforced_red_sandstone_stonecutting" | "securitycraft:recipes/transportation/dark_oak_security_sea_boat" | "minecraft:recipes/redstone/note_block" | "interiors:recipes/building_blocks/crafting/floor_chair/light_blue_floor_chair" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal" | "minecraft:recipes/decorations/green_stained_glass_pane_from_glass_pane" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_umber_brick_slab_stonecutting" | "create:hose_pulley" | "minecraft:recipes/decorations/crimson_hanging_sign" | "vinery:recipes/dark_cherry_fence" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal" | "minecraft:recipes/decorations/lime_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_riveted_locometal" | "create:recipes/building_blocks/polished_cut_granite_slab_from_stone_types_granite_stonecutting" | "create:recipes/misc/crafting/kinetics/empty_blaze_burner" | "framedblocks:recipes/building_blocks/framed_threeway_corner_pillar" | "farmersdelight:recipes/decorations/light_gray_canvas_sign" | "minecraft:recipes/building_blocks/smooth_stone_slab" | "farmersdelight:recipes/food/cooked_mutton_chops_from_smoking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_slashed_locometal" | "tfmg:recipes/decorations/nickel_ladder_from_ingots_nickel_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat" | "create:recipes/building_blocks/small_asurine_brick_wall" | "mts:paintgun" | "framedblocks:recipes/building_blocks/framed_slab_edge" | "create_dd:recipes/create_dd.palettes/crafting/decor/white_blueprint_block_from_white_dye" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_riveted_locometal" | "sophisticatedstorage:recipes/misc/backpack_advanced_feeding_upgrade_from_storage_advanced_feeding_upgrade" | "securitycraft:recipes/redstone/reinforced_dark_oak_button" | "minecraft:recipes/misc/beacon" | "create:recipes/misc/crafting/kinetics/millstone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_boiler" | "interiors:recipes/building_blocks/crafting/floor_chair/pink_floor_chair_from_other_floor_chair" | "minecraft:recipes/building_blocks/cut_copper_from_copper_block_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_packed_ice" | "securitycraft:recipes/building_blocks/reinforced_blackstone_slab" | "superbwarfare:recipes/combat/m_60_smithing" | "ae2:recipes/misc/tools/paintballs_yellow" | "alexscaves:alexscaves/hatch_tremorzilla_egg" | "ae2:recipes/misc/network/cells/item_storage_cell_1k" | "design_decor:recipes/building_blocks/scoria_castel_tile_stairs_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_slab_from_mossy_scarlet_bricks_stonecutting" | "farmersdelight:recipes/food/cod_roll" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_short_scarlet_brick_slab_stonecutting" | "superbwarfare:main/super_container" | "railways:recipes/misc/crafting/palettes/wrapping/blue_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/cherry_wood" | "create_dd:recipes/create_dd.palettes/crafting/decor/lime_blueprint_block_from_lime_dye" | "createdeco:recipes/decorations/decal_fire" | "minecraft:recipes/decorations/bamboo_sign" | "create_dd:recipes/create_dd.base/crafting/diamond_shard_from_diamond" | "create_dd:recipes/create_dd.palettes/crafting/decor/orange_blueprint_block_from_orange_dye" | "ae2:recipes/misc/tools/matter_cannon" | "minecraft:recipes/building_blocks/blue_ice" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_slashed_locometal" | "storagedelight:recipes/decorations/bamboo_single_door_cabinet" | "minecraft:recipes/building_blocks/red_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_boiler" | "minecraft:recipes/decorations/pink_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_blueprint_block" | "securitycraft:recipes/building_blocks/reinforced_stone_slab_from_reinforced_smooth_stone_stonecutting" | "create_dd:recipes/create_dd.palettes/light_gray_padded_tiled_rubber_from_light_gray_rubber_decor_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_brick_slab_from_stone_types_stone_stonecutting" | "create:recipes/misc/crafting/schematics/schematic_table" | "tconstruct:recipes/smeltery/scorched/scorched_brick_kiln" | "securitycraft:recipes/building_blocks/smooth_crystal_quartz_stairs" | "farmersdelight:recipes/decorations/skillet" | "alexscaves:alexscaves/gingerbread_crumbs" | "tfmg:recipes/building_blocks/cut_galena_brick_wall" | "ae2:recipes/misc/network/parts/monitors_conversion" | "copycats:recipes/crafting/copycat_half_layer_from_conversion" | "ae2:main/storage_cell" | "create:recipes/building_blocks/polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "vinery:recipes/jungle_wine_rack_big" | "minecraft:recipes/building_blocks/bamboo_mosaic_stairs" | "sophisticatedstorage:recipes/misc/warped_barrel" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_smokebox" | "tconstruct:recipes/decorations/world/wood/skyroot/fence" | "create_dd:recipes/create_dd.palettes/small_netherrack_brick_wall_from_stone_types_netherrack_stonecutting" | "create_dd:recipes/create_dd.palettes/dark_metal_bricks_from_industrial_iron_block_stonecutting" | "ae2:recipes/misc/network/cables/covered_gray" | "design_decor:recipes/building_blocks/green_metal_sheet_slab_from_metal_plate_stonecutting" | "minecraft:recipes/misc/paper" | "superbwarfare:recipes/misc/ak_47_blueprint" | "create:recipes/building_blocks/polished_cut_tuff_stairs" | "tconstruct:smeltery/structure" | "create:backtank" | "tconstruct:recipes/decorations/smeltery/seared/seared_soul_glass_pane" | "framedblocks:recipes/building_blocks/framed_flat_stacked_slope_panel_corner_rotate_to_framed_flat_stacked_slope_slab_corner" | "securitycraft:recipes/building_blocks/deepslate_lapis_mine" | "minecraft:husbandry/kill_axolotl_target" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_slashed_locometal" | "createbigcannons:recipes/building_blocks/nethersteel_nugget" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_riveted_locometal" | "create:recipes/building_blocks/small_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "ae2:recipes/misc/network/crafting/patterns_blank" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k" | "minecraft:recipes/building_blocks/warped_stairs" | "sophisticatedbackpacks:recipes/misc/alchemy_upgrade" | "create:recipes/building_blocks/small_scorchia_brick_wall" | "sophisticatedstorage:recipes/misc/storage_advanced_alchemy_upgrade_from_backpack_advanced_alchemy_upgrade" | "alexscaves:alexscaves/remote_detonation" | "framedblocks:recipes/building_blocks/framed_flat_double_slope_slab_corner" | "minecraft:recipes/building_blocks/white_stained_glass" | "ae2:recipes/misc/network/cables/dense_covered_lime" | "farmersdelight:recipes/food/bread_from_smoking" | "sophisticatedstorage:recipes/misc/backpack_crafting_upgrade_from_storage_crafting_upgrade" | "minecraft:recipes/decorations/blue_glazed_terracotta" | "alexscaves:alexscaves/cooked_mussel" | "minecraft:recipes/building_blocks/andesite_slab_from_andesite_stonecutting" | "createdeco:recipes/building_blocks/short_dean_bricks_from_tiled_dean_bricks_stonecutting" | "tfmg:recipes/building_blocks/small_bauxite_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal" | "casinocraft:recipes/decorations/wool_magenta" | "brewery:recipes/patterned_wool" | "tconstruct:recipes/misc/common/materials/queens_slime_nugget_from_ingot" | "securitycraft:recipes/building_blocks/reinforced_birch_slab" | "tfmg:recipes/building_blocks/polished_cut_galena_stairs" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_slab_recycling" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_slab_recycling" | "design_decor:recipes/building_blocks/andesite_castel_bricks_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_short_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_slab_recycling" | "ae2:recipes/misc/shaped/walls/chiseled_quartz_block" | "minecraft:recipes/tools/lead" | "minecraft:recipes/decorations/warped_sign" | "ae2:recipes/misc/network/cells/view_cell_storage" | "securitycraft:recipes/building_blocks/reinforced_chiseled_deepslate" | "createdeco:recipes/building_blocks/verdant_bricks_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "framedblocks:recipes/building_blocks/framed_small_double_corner_slope_panel" | "sophisticatedstorage:recipes/misc/chipped/tinkering_table_upgrade" | "sophisticatedstorage:recipes/misc/double_copper_chest" | "storagedelight:recipes/decorations/bamboo_drawer_with_door" | "sophisticatedstorage:recipes/misc/birch_chest" | "computercraft:recipes/redstone/wired_modem" | "computercraft:recipes/redstone/turtle_advanced/computercraft/wireless_modem_normal" | "minecraft:recipes/decorations/lodestone" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_slashed_locometal" | "tconstruct:recipes/decorations/tables/part_builder" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_2_from_tier_1_plus" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_tiled_pearl_bricks_stonecutting" | "tconstruct:recipes/decorations/common/glass/white_clear_stained_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_pillar" | "create:recipes/building_blocks/cut_calcite_brick_slab_recycling" | "securitycraft:recipes/building_blocks/reinforced_blue_glazed_terracotta" | "createdeco:recipes/building_blocks/long_pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "createdeco:recipes/decorations/andesite_door" | "framedblocks:recipes/building_blocks/framed_double_slope_slab_from_inverse" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_slab_from_stone_types_weathered_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_smokebox" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k" | "design_decor:recipes/building_blocks/light_blue_metal_plate_slab_from_metal_plate_stonecutting" | "design_decor:recipes/building_blocks/limestone_castel_tiles_from_stone_types_limestone_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_stairs_from_stone_types_amethyst_block_stonecutting" | "immersive_paintings:misc/painting" | "minecraft:adventure/honey_block_slide" | "alexscaves:alexscaves/defeat_gumbeeper" | "create_connected:recipes/crafting/kinetics/brake" | "alexscaves:alexscaves/tremorzilla_kill_beam" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_slab" | "superbwarfare:recipes/misc/m_1911_blueprint" | "minecraft:recipes/redstone/dark_oak_pressure_plate" | "securitycraft:recipes/building_blocks/reinforced_stripped_cherry_wood" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_plated_locometal" | "createdeco:recipes/building_blocks/long_dean_brick_slab" | "minecraft:recipes/building_blocks/smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_long_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/industrial_iron_window_pane" | "create:recipes/building_blocks/small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "alexscaves:alexscaves/neodymium_ingot" | "minecraft:recipes/misc/iron_ingot_from_smelting_deepslate_iron_ore" | "create_dd:recipes/create_dd.palettes/crafting/decor/pink_padded_rubber_from_pink_padded_rubber" | "minecraft:recipes/decorations/nether_brick_fence" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_brick_slab_recycling" | "ae2:recipes/misc/tools/nether_quartz_axe" | "createbb:createbb" | "createdeco:recipes/building_blocks/short_umber_bricks_from_long_umber_bricks_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_allium" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template_smithing_trim" | "create_connected:recipes/crafting/kinetics/fluid_tank_from_conversion" | "createdeco:recipes/decorations/decal_top_left" | "minecraft:recipes/decorations/decorated_pot_simple" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal_boiler" | "securitycraft:recipes/decorations/reinforced_cyan_stained_glass_pane" | "minecraft:recipes/building_blocks/cracked_deepslate_tiles" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "numismatics:recipes/misc/crafting/green_id_card" | "smallships:recipes/transportation/mangrove_galley" | "sophisticatedbackpacks:recipes/misc/advanced_alchemy_upgrade" | "tfmg:recipes/building_blocks/polished_cut_bauxite_stairs_from_stone_types_bauxite_stonecutting" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab" | "minecraft:recipes/decorations/stone_brick_walls_from_stone_stonecutting" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_pillar" | "create:arm_many_targets" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_iceandfire" | "minecraft:recipes/redstone/daylight_detector" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal_boiler" | "vinery:main/root" | "create:recipes/misc/crafting/materials/copper_ingot" | "copycats:recipes/crafting/copycat_sliding_door_from_conversion" | "createbigcannons:recipes/misc/wired_fuze" | "createdeco:recipes/building_blocks/cracked_pearl_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/large_cogwheel" | "securitycraft:recipes/building_blocks/reinforced_brown_stained_glass" | "advancedperipherals:base_toolkit" | "ae2:recipes/misc/network/parts/formation_plane_alt" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade" | "cgs:recipes/misc/lead_ingot_from_smelting_deepslate_lead_ore" | "minecraft:recipes/combat/diamond_boots" | "securitycraft:recipes/building_blocks/reinforced_gray_wool" | "securitycraft:recipes/redstone/reinforced_dispenser" | "ae2:recipes/misc/shaped/slabs/smooth_quartz_block" | "create:recipes/misc/crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/decorative/quartz_glass" | "create:recipes/misc/crafting/kinetics/fluid_valve" | "railways:recipes/misc/crafting/palettes/wrapping/brown_copper_wrapped_locometal" | "securitycraft:recipes/decorations/reinforced_red_carpet" | "sophisticatedstorage:recipes/misc/blue_shulker_box_to_sophisticated" | "create:recipes/building_blocks/small_dripstone_brick_stairs" | "farmersdelight:recipes/decorations/warped_cabinet" | "ae2:recipes/misc/network/cables/dense_smart_cyan" | "create:red_signal" | "minecraft:recipes/combat/iron_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_riveted_locometal" | "design_decor:recipes/building_blocks/metal_plate_slab_from_ingots_iron_stonecutting" | "design_decor:recipes/building_blocks/cyan_metal_plate_from_metal_plate_stonecutting" | "minecraft:recipes/misc/light_gray_dye_from_white_tulip" | "ae2:recipes/misc/materials/cardvoid" | "minecraft:recipes/tools/iron_pickaxe" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_stairs_from_reinforced_blackstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_lime_carpet_from_dye" | "createdeco:recipes/decorations/copper_catwalk_from_stonecutting" | "spelunkery:recipes/charcoal_lump" | "minecraft:recipes/building_blocks/polished_granite_stairs" | "computercraft:recipes/decorations/skull_cloudy" | "minecraft:recipes/building_blocks/dark_oak_slab" | "ae2:recipes/misc/misc/deconstruction_fluix_block" | "minecraft:recipes/transportation/mangrove_boat" | "create:recipes/misc/crafting/kinetics/light_blue_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/cut_limestone_from_stone_types_limestone_stonecutting" | "superbwarfare:recipes/misc/netherite_spring" | "ae2:recipes/misc/tools/portable_fluid_cell_64k" | "ae2:recipes/misc/network/crafting/64k_cpu_crafting_storage" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_wall" | "create_connected:recipes/crafting/kinetics/brass_gearbox" | "spelunkery:recipes/sculk_vein" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_stonecutting" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_honeycomb" | "ae2:recipes/misc/tools/paintballs_lumen_brown" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_slab" | "mts:wrench" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed" | "spelunkery:recipes/nephrite" | "storagedelight:recipes/decorations/jungle_drawer" | "overworld_netherite_ore:shardkeeper" | "createdeco:recipes/building_blocks/cracked_red_brick_stairs_from_cracked_red_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_double_slope_panel_corner" | "createdeco:recipes/decorations/andesite_mesh_fence" | "minecraft:recipes/transportation/detector_rail" | "createdeco:recipes/building_blocks/umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_fancy_powered_rail" | "ae2:recipes/misc/network/blocks/controller" | "create_dd:recipes/create_dd.base/crafting/fan_catalyst/freezing_sail" | "minecraft:recipes/combat/shield" | "create_dd:recipes/create_dd.base/crafting/rubber_block_from_rubber" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "design_decor:recipes/building_blocks/blue_metal_sheet_slab_from_metal_plate_stonecutting" | "brewery:main/get_beer_haley" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_boiler" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_verdant_bricks_stonecutting" | "mts:itembench" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_polished_deepslate_stonecutting" | "sophisticatedstorage:recipes/misc/copper_shulker_box" | "create:recipes/building_blocks/polished_cut_scoria_wall_from_stone_types_scoria_stonecutting" | "create:recipes/decorations/copper_ladder_from_ingots_copper_stonecutting" | "minecraft:recipes/misc/dune_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal" | "interiors:recipes/building_blocks/crafting/chair/brown_chair_from_floor_chair" | "minecraft:recipes/misc/creeper_banner_pattern" | "ae2:recipes/misc/network/cells/item_storage_cell_256k_storage" | "ae2:recipes/misc/network/parts/toggle_bus_inverted_alt" | "createdeco:recipes/building_blocks/mossy_umber_brick_stairs_from_mossy_umber_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_stairs_from_reinforced_polished_deepslate_stonecutting" | "create:recipes/misc/crafting/kinetics/controls" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_smokebox" | "createdeco:recipes/building_blocks/cracked_dean_brick_slab_from_cracked_dean_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/storage_link_from_controller" | "create_dd:recipes/create_dd.palettes/cyan_padded_rubber_stairs_from_cyan_rubber_decor_stonecutting" | "minecraft:recipes/decorations/iron_bars" | "ae2:recipes/misc/block_cutter/stairs/cut_quartz_stairs" | "create:recipes/building_blocks/cut_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "interiors:recipes/building_blocks/crafting/floor_chair/brown_floor_chair_from_seat" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_brick_slab" | "minecraft:recipes/misc/copper_ingot" | "ae2:recipes/misc/network/cables/smart_cyan" | "create:recipes/building_blocks/cut_veridium_slab_from_stone_types_veridium_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/scorched/polished_scorched_stone_crafting" | "ae2:recipes/misc/network/parts/tunnels_me" | "minecraft:recipes/building_blocks/dye_purple_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal" | "minecraft:recipes/transportation/chest_minecart" | "spelunkery:spelunkery/diamond_grindstone" | "superbwarfare:recipes/combat/glock_17_smithing" | "createdeco:recipes/decorations/brown_shipping_container_from_dyeing_vaults" | "minecraft:recipes/building_blocks/netherite_block" | "create:recipes/building_blocks/cut_granite_slab_recycling" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_bricks_from_reinforced_polished_blackstone_stonecutting" | "minecraft:recipes/decorations/red_carpet" | "createdeco:recipes/decorations/red_zinc_lamp" | "ae2:recipes/misc/tools/paintballs_black" | "minecraft:recipes/misc/wild_armor_trim_smithing_template" | "vinery:recipes/dark_cherry_wood" | "alexscaves:alexscaves/discover_forlorn_hollows" | "framedblocks:recipes/building_blocks/framed_divided_slope" | "createdeco:recipes/building_blocks/mossy_pearl_bricks_from_moss_block" | "create:long_travel" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_brick_slab" | "minecraft:recipes/transportation/dark_oak_chest_boat" | "comforts:hammock_red" | "securitycraft:recipes/building_blocks/reinforced_cut_red_sandstone_slab_from_reinforced_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_stonecutting" | "sophisticatedstorage:recipes/misc/advanced_pickup_upgrade" | "createdeco:recipes/building_blocks/verdant_bricks" | "securitycraft:recipes/transportation/acacia_security_sea_boat" | "minecraft:recipes/building_blocks/mud_brick_slab" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "create_dd:recipes/create_dd.palettes/dark_metal_block_from_dark_metal_plating_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_boiler" | "createdeco:recipes/building_blocks/mossy_dusk_brick_stairs_from_mossy_dusk_bricks_stonecutting" | "securitycraft:recipes/building_blocks/end_stone_mine" | "sophisticatedbackpacks:recipes/misc/advanced_tool_swapper_upgrade" | "minecraft:recipes/brewing/glistering_melon_slice" | "create_dd:recipes/create_dd.palettes/small_blackstone_brick_wall" | "minecraft:recipes/building_blocks/cracked_nether_bricks" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_plated_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "tconstruct:recipes/misc/common/slime/ichor/crystal_smelting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_slab" | "minecraft:recipes/misc/wild_armor_trim_smithing_template_smithing_trim" | "sophisticatedstorage:recipes/misc/yellow_shulker_box_to_sophisticated" | "farmersdelight:recipes/decorations/cherry_cabinet" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_slab_stonecutter" | "sophisticatedstorage:recipes/misc/storage_chipped_botanist_workbench_upgrade_from_backpack_chipped_botanist_workbench_upgrade" | "create:recipes/building_blocks/crafting/kinetics/pink_seat" | "spelunkery:recipes/minecart" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_slab_recycling" | "createdeco:recipes/building_blocks/cracked_pearl_brick_slab_from_cracked_pearl_bricks_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/black_chair_from_seat" | "create:recipes/building_blocks/mangrove_window_pane" | "create:recipes/building_blocks/polished_cut_calcite_slab_from_stone_types_calcite_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "ae2:recipes/misc/network/cells/view_cell" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_pillar" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_wall" | "createdeco:recipes/decorations/netherite_coinstack" | "framedblocks:recipes/building_blocks/framed_divided_slab_rotate_to_framed_divided_panel_horizontal" | "minecraft:recipes/decorations/polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_smoking" | "smallships:recipes/transportation/cherry_drakkar" | "tconstruct:recipes/decorations/smeltery/seared/seared_glass_pane" | "securitycraft:recipes/redstone/reinforced_birch_button" | "minecraft:recipes/tools/netherite_shovel_smithing" | "interiors:recipes/building_blocks/crafting/floor_chair/red_floor_chair_from_seat" | "minecraft:recipes/brewing/glass_bottle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal" | "superbwarfare:recipes/combat/ak_12_smithing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal" | "sophisticatedstorage:recipes/misc/advanced_hopper_upgrade" | "design_decor:recipes/building_blocks/red_metal_sheet_stairs_from_metal_plate_stonecutting" | "ae2:recipes/misc/network/cables/glass_orange" | "securitycraft:recipes/redstone/keycard_lock" | "storagedelight:recipes/decorations/bamboo_cabinet_with_glass_doors" | "minecraft:recipes/misc/lime_dye_from_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_pillar" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_slab_from_honeycomb" | "alexscaves:alexscaves/discover_primordial_caves" | "alexscaves:alexscaves/eat_radiation_foods" | "alexscaves:alexscaves/shadow_armor" | "createdeco:recipes/decorations/green_copper_lamp" | "ae2:recipes/misc/network/cables/covered_fluix" | "create_dd:recipes/create_dd.palettes/layered_amethyst_block_from_stone_types_amethyst_block_stonecutting" | "design_decor:recipes/building_blocks/pink_metal_sheet_wall_from_metal_plate_stonecutting" | "storagedelight:recipes/decorations/glass_oak_cabinet" | "interiors:recipes/building_blocks/crafting/chair/blue_chair_from_floor_chair" | "design_decor:recipes/building_blocks/ochrum_castel_tile_wall_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/copycat_step_from_ingots_zinc_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal_boiler" | "framedblocks:recipes/building_blocks/framed_stacked_slope_slab" | "interiors:recipes/building_blocks/crafting/floor_chair/pink_floor_chair" | "create:recipes/building_blocks/small_tuff_brick_slab" | "interiors:recipes/building_blocks/crafting/chair/yellow_chair_from_seat" | "sophisticatedstorage:recipes/misc/basic_to_netherite_tier_upgrade" | "framedblocks:recipes/building_blocks/framed_floor_board_rotate_to_framed_wall_board" | "comforts:sleeping_bag_gray" | "createdeco:recipes/building_blocks/brass_window" | "sophisticatedstorage:recipes/misc/basic_to_iron_tier_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal_boiler" | "farmersdelight:recipes/decorations/oak_cabinet" | "farmersdelight:recipes/food/cooked_cod_slice" | "create_connected:recipes/crafting/kinetics/inventory_access_port" | "createbigcannons:recipes/misc/cannon_loader" | "framedblocks:recipes/building_blocks/framed_bookshelf" | "create:recipes/building_blocks/cut_diorite_brick_slab" | "vinery:recipes/loam" | "createdeco:recipes/building_blocks/short_blue_bricks_from_long_blue_bricks_stonecutting" | "farmersdelight:main/get_mushroom_colony" | "mts:fuelhose" | "create:recipes/building_blocks/small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/logistics/redstone_contact" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_tiled_dusk_bricks_stonecutting" | "ae2:recipes/misc/tools/network_color_applicator" | "alexscaves:alexscaves/cooked_dinosaur_chop" | "createdeco:recipes/building_blocks/long_red_bricks_from_short_red_bricks_stonecutting" | "vinery:recipes/dark_cherry_button" | "create_dd:recipes/create_dd.palettes/cut_dolomite_brick_slab" | "tconstruct:recipes/decorations/common/copper_platform_waxing_weathered" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_smokebox" | "design_decor:recipes/building_blocks/scorchia_castel_brick_stairs_from_stone_types_scorchia_stonecutting" | "sophisticatedstorage:recipes/misc/storage_alchemy_upgrade_from_backpack_alchemy_upgrade" | "astikorcarts:recipes/animal_cart" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_riveted_locometal" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_riveted_locometal" | "tconstruct:recipes/building_blocks/common/slime/ender/crystal_block" | "ae2:recipes/misc/tools/fluix_pickaxe" | "smallships:recipes/transportation/dark_oak_drakkar" | "advancedperipherals:recipes/redstone/memory_card" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_riveted_locometal" | "design_decor:recipes/building_blocks/asurine_castel_tiles_from_stone_types_asurine_stonecutting" | "ae2:recipes/misc/shaped/slabs/sky_stone_brick" | "minecraft:recipes/brewing/fermented_spider_eye" | "minecraft:recipes/misc/iron_ingot_from_smelting_raw_iron" | "ae2:recipes/misc/network/cables/smart_fluix_clean" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_smokebox" | "cgs:recipes/misc/nail" | "framedblocks:recipes/building_blocks/framed_divided_panel_horizontal_rotate_to_framed_divided_slab" | "alexscaves:alexscaves/finished_quarry" | "minecraft:recipes/misc/purple_dye" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_brick_stairs_from_stone_types_amethyst_block_stonecutting" | "create:recipes/building_blocks/cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_bricks_from_long_red_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_waxed_copper_block_stonecutting" | "create_dd:recipes/create_dd.palettes/small_gabbro_brick_wall_from_stone_types_gabbro_stonecutting" | "createbigcannons:recipes/misc/steel_screw_lock" | "minecraft:recipes/building_blocks/dried_kelp_block" | "tconstruct:tools/tinker_tool" | "minecraft:recipes/building_blocks/quartz_bricks_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_calcite_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab_recycling" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_stairs_stonecutter" | "copycats:recipes/crafting/copycat_vertical_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_slashed_locometal" | "alexscaves:alexscaves/defeat_boundroid" | "tconstruct:tools/material_master" | "create:recipes/building_blocks/small_deepslate_brick_slab_recycling" | "tconstruct:recipes/decorations/common/glass/yellow_clear_stained_glass_pane" | "design_decor:recipes/building_blocks/blue_metal_plate_from_metal_plate_stonecutting" | "design_decor:recipes/building_blocks/brown_metal_sheet_stairs_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "tconstruct:foundry/structure" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tiles_from_reinforced_cobbled_deepslate_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_wall" | "farmersdelight:recipes/food/cabbage" | "tconstruct:recipes/misc/common/materials/hepatizon_ingot_from_block" | "minecraft:recipes/building_blocks/dye_white_carpet" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/white_terracotta" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_slab_from_reinforced_blackstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal" | "minecraft:recipes/misc/white_dye_from_lily_of_the_valley" | "createdeco:recipes/decorations/zinc_support_wedge_from_stonecutting" | "create:recipes/misc/crafting/materials/andesite_alloy_from_zinc" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "createdeco:recipes/decorations/zinc_catwalk_railing_forge" | "superbwarfare:main/legendary_blueprint" | "tconstruct:recipes/misc/common/materials/manyullyn_block_from_ingots" | "create:recipes/building_blocks/cut_granite_wall_from_stone_types_granite_stonecutting" | "design_decor:recipes/building_blocks/red_metal_sheet_slab_from_metal_plate_stonecutting" | "create_connected:recipes/crafting/palettes/bamboo_window_pane" | "alexscaves:alexscaves/sack_of_sating" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stairs_stonecutter" | "createdeco:recipes/decorations/zinc_bars_overlay_from_stonecutting" | "superbwarfare:main/best_friend" | "ae2:recipes/misc/misc/chests_smooth_sky_stone" | "minecraft:recipes/building_blocks/dye_light_blue_bed" | "minecraft:recipes/decorations/lime_carpet" | "smallships:recipes/transportation/jungle_drakkar" | "railways:recipes/misc/crafting/smokestack_diesel" | "spelunkery:recipes/iron_ores" | "design_decor:recipes/building_blocks/deepslate_castel_tile_slab_from_stone_types_deepslate_stonecutting" | "farmersdelight:recipes/decorations/canvas_sign" | "createdeco:recipes/building_blocks/scarlet_bricks" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_tiled_red_bricks_stonecutting" | "securitycraft:recipes/misc/keypad_frame" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_bricks_stonecutting" | "tfmg:recipes/building_blocks/cut_bauxite_slab" | "tconstruct:recipes/decorations/smeltery/seared/basin" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_slab_from_reinforced_stone_stonecutting" | "minecraft:recipes/misc/spire_armor_trim_smithing_template" | "framedblocks:recipes/building_blocks/framed_redstone_block" | "minecraft:recipes/building_blocks/stone_slab_from_stone_stonecutting" | "destroy:badge/patreon_1" | "railways:recipes/misc/crafting/palettes/wrapping/gray_brass_wrapped_locometal" | "destroy:badge/patreon_2" | "destroy:badge/patreon_3" | "securitycraft:recipes/decorations/reinforced_polished_blackstone_wall" | "tcintegrations:recipes/misc/bronze_nuggets_from_ingot" | "securitycraft:recipes/building_blocks/reinforced_deepslate_bricks" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_tinted_glass" | "spelunkery:recipes/copper_ingot" | "minecraft:recipes/tools/flint_and_steel" | "minecraft:recipes/building_blocks/dye_purple_carpet" | "minecraft:recipes/building_blocks/nether_bricks" | "sophisticatedstorage:recipes/misc/iron_to_netherite_tier_upgrade" | "create:recipes/building_blocks/andesite_pillar_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_long_red_bricks_stonecutting" | "superbwarfare:recipes/misc/qbz_191_blueprint" | "create:recipes/building_blocks/scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/sugar_from_sugar_cane" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_riveted_locometal" | "minecraft:recipes/building_blocks/dye_magenta_bed" | "create_dd:recipes/create_dd.palettes/small_packed_mud_brick_stairs" | "sophisticatedstorage:recipes/misc/magnet_upgrade" | "alexscaves:alexscaves/gelatin" | "create_dd:recipes/create_dd.palettes/cut_dolomite_bricks_from_stone_types_dolomite_stonecutting" | "minecraft:recipes/decorations/respawn_anchor" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_from_stone_types_netherrack_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/grout_multiple" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_short_dean_brick_stairs_stonecutting" | "alexscaves:alexscaves/quarry" | "interiors:recipes/building_blocks/crafting/floor_chair/purple_floor_chair_from_seat" | "createdeco:recipes/decorations/blue_placard" | "copycats:recipes/crafting/copycat_wall" | "computercraft:recipes/redstone/turtle_advanced/minecraft/crafting_table" | "ae2:recipes/misc/network/cables/glass_gray" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_smokebox" | "create_dd:recipes/create_dd.palettes/light_blue_padded_rubber_slab_from_light_blue_rubber_decor_stonecutting" | "minecraft:recipes/decorations/mossy_cobblestone_wall" | "create_dd:recipes/create_dd.palettes/cut_dolomite_slab_recycling" | "create_dd:recipes/create_dd.palettes/black_padded_mosaic_rubber_from_black_rubber_decor_stonecutting" | "create:recipes/building_blocks/cut_veridium_slab_recycling" | "createdeco:recipes/building_blocks/mossy_umber_brick_slab_from_mossy_umber_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/gray_padded_rubber_stairs_from_gray_rubber_decor_stonecutting" | "numismatics:recipes/misc/crafting/magenta_id_card" | "minecraft:nether/get_wither_skull" | "tconstruct:recipes/misc/common/fantastic_foundry" | "sophisticatedstorage:recipes/misc/generic_barrel" | "securitycraft:recipes/misc/keypad_item" | "sophisticatedstorage:recipes/misc/chipped/glassblower_upgrade" | "createdeco:recipes/building_blocks/short_umber_brick_stairs" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_short_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_short_umber_bricks_stonecutting" | "mts:jerrycan" | "minecraft:recipes/decorations/diorite_wall_from_diorite_stonecutting" | "vinery:recipes/dark_cherry_fence_gate" | "farmersdelight:recipes/misc/straw" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_wall_from_reinforced_polished_blackstone_stonecutting" | "railways:recipes/misc/crafting/big_buffer" | "create:recipes/misc/crafting/kinetics/magenta_valve_handle_from_other_valve_handle" | "computercraft:recipes/redstone/disk_8" | "computercraft:recipes/redstone/disk_9" | "copycats:recipes/crafting/copycat_trapdoor" | "computercraft:recipes/redstone/disk_6" | "design_decor:recipes/building_blocks/orange_metal_sheet_from_metal_plate_stonecutting" | "computercraft:recipes/redstone/disk_7" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "smallships:recipes/transportation/birch_brigg" | "interiors:recipes/building_blocks/crafting/chair/purple_chair_from_floor_chair" | "create:recipes/building_blocks/small_granite_brick_slab_from_stone_types_granite_stonecutting" | "computercraft:recipes/redstone/disk_1" | "minecraft:recipes/tools/wooden_pickaxe" | "computercraft:recipes/redstone/disk_4" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs" | "computercraft:recipes/redstone/disk_5" | "create:recipes/misc/crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "computercraft:recipes/redstone/disk_2" | "computercraft:recipes/redstone/disk_3" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/umber_bricks_from_long_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_tuff_brick_slab" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/orange_asphalt_block" | "mts:enginebench" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "securitycraft:recipes/decorations/reinforced_polished_blackstone_brick_wall" | "ae2:recipes/misc/network/cables/glass_fluix_clean" | "storagedelight:recipes/decorations/warped_drawer_with_books" | "create:recipes/building_blocks/polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "farmersdelight:recipes/food/mixed_salad" | "minecraft:recipes/food/baked_potato_from_smoking" | "create:recipes/building_blocks/small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_dripstone_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal_boiler" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite" | "create_enchantment_industry:emerging_brand" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_glass" | "create:recipes/misc/smelting/ingot_silver_compat_ic2" | "brewery:recipes/wooden_brewingstation" | "minecraft:recipes/decorations/black_stained_glass_pane_from_glass_pane" | "securitycraft:recipes/building_blocks/reinforced_diorite_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/short_pearl_bricks_from_pearl_bricks_stonecutting" | "create:recipes/building_blocks/small_scoria_brick_stairs" | "securitycraft:recipes/building_blocks/reinforced_prismarine_stairs" | "create_dd:recipes/create_dd.palettes/dark_metal_block_from_industrial_iron_block_stonecutting" | "superbwarfare:recipes/misc/steel_barrel" | "alexscaves:alexscaves/sulfur_dust" | "ae2:recipes/misc/tools/paintballs_pink" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_slashed_locometal" | "securitycraft:recipes/building_blocks/reinforced_prismarine_brick_slab" | "minecraft:recipes/decorations/red_candle" | "create_dd:recipes/create_dd.palettes/cut_basalt_brick_wall" | "minecraft:story/upgrade_tools" | "farmersdelight:recipes/building_blocks/packed_mud_from_straw" | "camerapture:shutterbug" | "farmersdelight:recipes/decorations/painting_from_canvas" | "create_dd:recipes/create_dd.palettes/crafting/decor/green_blueprint_block_from_green_dye" | "create:recipes/building_blocks/cut_deepslate_brick_slab" | "tconstruct:recipes/building_blocks/common/glass/black_clear_stained_glass" | "create:recipes/building_blocks/cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_elev_inner_slope_slab_corner_rotate_to_framed_flat_ext_inner_slope_panel_corner" | "securitycraft:recipes/redstone/reinforced_mangrove_button" | "createdeco:recipes/decorations/brown_placard" | "spelunkery:recipes/rough_cinnabar_block" | "alexscaves:alexscaves/limestone" | "create:recipes/misc/crafting/kinetics/crafter_slot_cover" | "farmersdelight:main/master_chef" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal_boiler" | "create:arm_blaze_burner" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "ae2:recipes/misc/block_cutter/walls/chiseled_quartz_wall" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_thermal" | "farmersdelight:recipes/cooking/bone_broth" | "minecraft:husbandry/tactical_fishing" | "create:recipes/building_blocks/polished_cut_andesite_wall_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_riveted_locometal" | "design_decor:recipes/building_blocks/tuff_castel_brick_slab_from_stone_types_tuff_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab" | "securitycraft:recipes/building_blocks/reinforced_magenta_carpet_from_dye" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_long_verdant_bricks_stonecutting" | "alexscaves:alexscaves/totem_of_possession" | "securitycraft:recipes/decorations/reinforced_deepslate_brick_wall" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_dean_bricks_stonecutting" | "create:recipes/building_blocks/cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "securitycraft:recipes/redstone/keypad_door_item" | "alexscaves:alexscaves/sweetish_fish_bucket" | "framedblocks:recipes/building_blocks/framed_slope_panel_rotate_to_framed_slope_slab" | "create:recipes/building_blocks/small_calcite_bricks_from_stone_types_calcite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_wall_from_reinforced_blackstone_stonecutting" | "tconstruct:recipes/misc/common/slime/ender/crystal_smelting" | "securitycraft:recipes/building_blocks/reinforced_black_glazed_terracotta" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_stairs_from_honeycomb" | "farmersdelight:recipes/misc/gold_nugget_from_blasting_knife" | "minecraft:recipes/redstone/mangrove_trapdoor" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs_from_oxidized_copper_shingles_stonecutting" | "framedblocks:recipes/building_blocks/framed_large_stone_button" | "spelunkery:recipes/raw_iron_nugget" | "design_decor:recipes/building_blocks/green_metal_sheet_wall_from_metal_plate_stonecutting" | "sophisticatedbackpacks:recipes/misc/upgrade_base" | "interiors:recipes/building_blocks/crafting/chair/pink_chair_from_seat" | "minecraft:recipes/redstone/oak_pressure_plate" | "securitycraft:recipes/building_blocks/nether_gold_mine" | "tconstruct:recipes/tools/tools/building/sky_staff" | "ae2:recipes/misc/network/cells/item_storage_cell_64k_storage" | "create_dd:recipes/create_dd.palettes/cut_dolomite_brick_stairs" | "sophisticatedstorage:recipes/misc/storage_chipped_tinkering_table_upgrade_from_backpack_chipped_tinkering_table_upgrade" | "create:recipes/building_blocks/small_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab" | "farmersdelight:recipes/decorations/bamboo_cabinet" | "interiors:recipes/building_blocks/crafting/chair/orange_chair_from_seat" | "computercraft:recipes/redstone/pocket_computer_normal" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "securitycraft:recipes/decorations/reinforced_nether_brick_wall" | "create:recipes/misc/crafting/kinetics/schedule" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_plated_locometal" | "sophisticatedstorage:recipes/misc/gray_shulker_box_to_sophisticated" | "minecraft:recipes/redstone/dropper" | "tconstruct:recipes/building_blocks/common/slime/ichor/crystal_block" | "create:recipes/building_blocks/cut_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "create_dd:recipes/create_dd.palettes/dark_metal_plating_from_industrial_iron_block_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_yellow_wool" | "ae2:recipes/misc/block_cutter/walls/quartz_brick_wall" | "superbwarfare:recipes/misc/bocek_blueprint" | "vinery:main/the_magic_of_the_barrel" | "comforts:hammock_light_blue" | "ae2:recipes/misc/network/blocks/storage_drive" | "design_decor:recipes/building_blocks/crimsite_castel_brick_wall_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/oxidized_copper_tile_slab" | "create_dd:recipes/create_dd.base/crafting/equipment/flipped_deforester_saw" | "securitycraft:recipes/misc/smart_module" | "securitycraft:recipes/building_blocks/reinforced_light_gray_carpet_from_dye" | "create:recipes/building_blocks/mangrove_window" | "create:recipes/building_blocks/warped_window_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_slashed_locometal" | "create:recipes/building_blocks/cut_veridium_brick_slab" | "securitycraft:recipes/building_blocks/reinforced_brick_stairs" | "tconstruct:recipes/misc/common/materials/hepatizon_ingot_from_nuggets" | "minecraft:recipes/building_blocks/dye_light_blue_carpet" | "design_decor:recipes/building_blocks/calcite_castel_tiles_from_stone_types_calcite_stonecutting" | "sophisticatedstorage:recipes/misc/storage_auto_smelting_upgrade_from_backpack_auto_smelting_upgrade" | "framedblocks:recipes/tools/powered_framing_saw" | "minecraft:recipes/building_blocks/purpur_block" | "securitycraft:recipes/redstone/reinforced_oak_pressure_plate" | "design_decor:recipes/building_blocks/calcite_castel_tile_slab_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/small_andesite_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_iron_wrapped_locometal" | "storagedrawers:recipes/storagedrawers/oak_trim" | "createdeco:recipes/decorations/zinc_bars" | "toms_storage:unlock_dia_pearl" | "securitycraft:recipes/redstone/reinforced_mangrove_fence_gate" | "create_dd:recipes/create_dd.palettes/cut_netherrack_brick_wall_from_stone_types_netherrack_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_brick_slab_from_stone_types_packed_mud_stonecutting" | "immersive_paintings:misc/graffiti" | "alexscaves:alexscaves/defeat_nucleeper" | "create_dd:recipes/create_dd.palettes/small_stone_brick_slab_from_stone_types_stone_stonecutting" | "copycats:recipes/crafting/copycat_vertical_step" | "computercraft:recipes/redstone/turtle_advanced_overlays/turtle_trans_overlay" | "framedblocks:recipes/building_blocks/framed_flat_double_slope_slab_corner_rotate_to_framed_flat_double_slope_panel_corner" | "ae2:recipes/misc/shaped/stairs/quartz_bricks" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/blueprint_block_from_blue_dye" | "createdeco:recipes/decorations/iron_hull_from_stonecutting" | "vinery:main/cherry_picker" | "railways:recipes/misc/crafting/palettes/wrapping/purple_copper_wrapped_locometal" | "farmersdelight:recipes/misc/pumpkin_seeds_from_slice" | "framedblocks:recipes/building_blocks/framed_fancy_activator_rail_slope" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_axe" | "alexscaves:alexscaves/mussel" | "minecraft:recipes/building_blocks/polished_granite" | "farmersdelight:main/use_skillet" | "createdeco:recipes/building_blocks/cracked_red_bricks_from_bricks_smelting" | "create_dd:recipes/create_dd.palettes/crafting/decor/yellow_padded_rubber_from_yellow_padded_rubber" | "minecraft:recipes/redstone/birch_trapdoor" | "storagedrawers:recipes/storagedrawers/emerald_storage_upgrade" | "securitycraft:recipes/building_blocks/crystal_quartz_slab" | "minecraft:recipes/redstone/spruce_trapdoor" | "minecraft:recipes/misc/quartz" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat_from_other_seat" | "create_enchantment_industry:recipes/experience_rotor" | "storagedrawers:recipes/storagedrawers/obsidian_storage_upgrade" | "create_connected:recipes/crafting/kinetics/item_vault_from_conversion" | "framedblocks:recipes/building_blocks/framed_divided_panel_horizontal" | "minecraft:end/respawn_dragon" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_slab_from_reinforced_deepslate_tiles_stonecutting" | "minecraft:recipes/decorations/soul_campfire" | "sophisticatedstorage:recipes/misc/filter_upgrade" | "create:recipes/building_blocks/cut_deepslate_slab" | "interiors:recipes/building_blocks/crafting/floor_chair/blue_floor_chair_from_other_floor_chair" | "minecraft:recipes/food/cooked_mutton_from_campfire_cooking" | "sophisticatedstorage:recipes/misc/iron_shulker_box_from_copper_shulker_box" | "create:recipes/misc/smelting/ingot_uranium_compat_immersiveengineering" | "create:recipes/building_blocks/polished_cut_dripstone_slab" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_slab_stonecutter" | "design_decor:recipes/building_blocks/white_metal_sheet_from_metal_plate_stonecutting" | "farmersdelight:recipes/decorations/light_gray_hanging_canvas_sign" | "tfmg:recipes/building_blocks/small_bauxite_brick_slab_from_stone_types_bauxite_stonecutting" | "cgs:recipes/misc/shotgun_long_barrel" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_brick_wall_from_stone_types_weathered_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_slashed_locometal" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_3_from_backpack_stack_upgrade_tier_2" | "minecraft:recipes/building_blocks/crimson_hyphae" | "minecraft:recipes/building_blocks/dye_orange_wool" | "minecraft:recipes/building_blocks/yellow_concrete_powder" | "ae2:recipes/misc/network/cables/dense_smart_magenta" | "farmersdelight:recipes/cooking/pasta_with_mutton_chop" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_3" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_2" | "minecraft:recipes/building_blocks/purple_stained_glass" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_1" | "createbigcannons:recipes/misc/wrought_iron_drop_mortar_end_mirrored" | "design_decor:recipes/building_blocks/limestone_castel_tile_slab_from_stone_types_limestone_stonecutting" | "create_connected:recipes/crafting/kinetics/gearshift_from_conversion" | "farmersdelight:recipes/decorations/white_canvas_sign" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_brick_stairs" | "createdeco:recipes/decorations/blue_shipping_container" | "superbwarfare:recipes/misc/cemented_carbide_spring" | "brewery:main/get_beer_hops" | "superbwarfare:recipes/combat/rpg_rocket_standard" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat_from_other_seat" | "dragnvehicles:recipes/misc/wheel" | "sophisticatedstorage:recipes/misc/double_diamond_chest" | "design_decor:recipes/building_blocks/andesite_castel_tile_wall_from_stone_types_andesite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_slab_from_stone_types_stone_stonecutting" | "create:recipes/building_blocks/cut_limestone_slab_recycling" | "sophisticatedstorage:recipes/misc/jungle_limited_barrel_4" | "minecraft:recipes/decorations/blue_carpet" | "minecraft:recipes/misc/snout_armor_trim_smithing_template_smithing_trim" | "ae2:recipes/misc/network/cables/covered_cyan" | "ae2:recipes/misc/network/cables/glass_white" | "create:recipes/building_blocks/polished_cut_diorite_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_riveted_locometal" | "vinery:recipes/oak_wine_rack_big" | "tconstruct:recipes/building_blocks/common/glass/gray_clear_stained_glass" | "create_dd:recipes/create_dd.palettes/small_netherrack_brick_slab" | "tfmg:recipes/building_blocks/small_galena_brick_wall_from_stone_types_galena_stonecutting" | "framedblocks:recipes/building_blocks/framed_compound_slope_panel" | "design_decor:recipes/building_blocks/gray_metal_plate_slab_from_metal_plate_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_from_blackstone_stonecutting" | "storagedelight:recipes/decorations/warped_single_door_cabinet" | "create:recipes/misc/crafting/curiosities/brown_toolbox" | "copycats:recipes/crafting/copycat_trapdoor_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal" | "comforts:hammock_lime" | "tconstruct:recipes/redstone/smeltery/scorched/drain" | "create_enchantment_industry:copiable_mystery" | "minecraft:recipes/decorations/polished_blackstone_wall_from_polished_blackstone_stonecutting" | "farmersdelight:recipes/decorations/yellow_canvas_sign" | "framedblocks:recipes/building_blocks/framed_slab_corner_from_half_pillar" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_honeycomb" | "copycats:recipes/crafting/copycat_vertical_slice_from_conversion" | "minecraft:recipes/building_blocks/dripstone_block" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_brass_wrapped_locometal" | "minecraft:adventure/avoid_vibration" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_stairs_from_stone_types_gabbro_stonecutting" | "create:recipes/building_blocks/polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_slab_from_reinforced_polished_deepslate_stonecutting" | "railways:recipes/combat/dying_existing_cap_blue" | "superbwarfare:recipes/misc/netherite_barrel" | "farmersdelight:recipes/decorations/red_canvas_sign" | "design_decor:recipes/building_blocks/black_metal_plate_slab_from_metal_plate_stonecutting" | "ae2:recipes/misc/network/crafting/cpu_crafting_monitor" | "minecraft:recipes/decorations/acacia_fence" | "create:recipes/building_blocks/polished_cut_deepslate_from_stone_types_deepslate_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "securitycraft:recipes/misc/reinforced_lectern" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_stairs" | "createdeco:recipes/building_blocks/scarlet_brick_slab" | "minecraft:recipes/misc/iron_ingot_from_blasting_deepslate_iron_ore" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_brown_carpet" | "create:recipes/building_blocks/small_limestone_brick_slab_recycling" | "farmersdelight:recipes/decorations/red_hanging_canvas_sign" | "minecraft:nether/return_to_sender" | "farmersdelight:recipes/cooking/tomato_sauce" | "casinocraft:recipes/decorations/wool_green" | "minecraft:recipes/building_blocks/sandstone" | "create_dd:recipes/create_dd.palettes/small_stone_brick_slab" | "tfmg:recipes/decorations/steel_scaffolding_from_ingots_steel_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/magenta_chair" | "farmersdelight:recipes/cooking/ratatouille" | "create_dd:recipes/create_dd.palettes/small_stone_bricks_from_stone_types_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_plated_locometal" | "createdeco:recipes/decorations/zinc_bars_overlay" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_smokebox" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_long_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_verdant_bricks_from_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_bricks_from_scarlet_bricks_stonecutting" | "create_connected:control_chip" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_brick_wall" | "storagedelight:recipes/decorations/mangrove_bookshelf_with_door" | "computercraft:recipes/redstone/turtle_normal/computercraft/wireless_modem_normal" | "design_decor:recipes/building_blocks/light_gray_metal_sheet_wall_from_metal_plate_stonecutting" | "create:recipes/building_blocks/polished_cut_diorite_slab_recycling" | "ae2:recipes/misc/shaped/stairs/sky_stone_small_brick" | "railways:recipes/combat/dying_existing_cap_lime" | "securitycraft:recipes/building_blocks/reinforced_orange_wool" | "createdeco:recipes/decorations/zinc_catwalk_stairs" | "sophisticatedstorage:recipes/misc/lime_shulker_box_to_sophisticated" | "numismatics:questionable_investment" | "storagedelight:recipes/decorations/spruce_bookshelf_with_door" | "spelunkery:recipes/mushgloom" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/mossy_blue_brick_slab_from_mossy_blue_bricks_stonecutting" | "minecraft:recipes/decorations/brown_stained_glass_pane_from_glass_pane" | "minecraft:husbandry/obtain_sniffer_egg" | "smallships:recipes/transportation/cherry_brigg" | "smallships:recipes/transportation/spruce_brigg" | "sophisticatedstorage:recipes/misc/double_iron_chest" | "createdeco:recipes/decorations/brass_coinstack" | "tconstruct:recipes/redstone/world/wood/skyroot/trapdoor" | "numismatics:recipes/misc/crafting/black_id_card" | "framedblocks:recipes/building_blocks/framed_checkered_panel" | "minecraft:recipes/decorations/brick_wall_from_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_wall" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "ae2:recipes/misc/shaped/walls/fluix_block" | "ae2:recipes/misc/network/cells/item_storage_components_cell_4k_part" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_dean_bricks_stonecutting" | "farmersdelight:recipes/building_blocks/organic_compost_from_rotten_flesh" | "storagedrawers:recipes/storagedrawers/iron_storage_upgrade" | "createdeco:recipes/building_blocks/mossy_red_brick_stairs_from_mossy_red_bricks_stonecutting" | "comforts:hammock_blue" | "design_decor:recipes/building_blocks/light_blue_metal_plate_wall_from_metal_plate_stonecutting" | "minecraft:recipes/food/cooked_cod_from_campfire_cooking" | "createdeco:recipes/building_blocks/short_blue_bricks_from_blue_bricks_stonecutting" | "ae2:recipes/misc/materials/cardcapacity" | "interiors:recipes/building_blocks/crafting/floor_chair/white_floor_chair_from_seat" | "createdeco:recipes/building_blocks/short_verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal" | "createdeco:recipes/decorations/blue_andesite_lamp" | "minecraft:recipes/misc/pink_dye_from_red_white_dye" | "brewery:main/get_whiskey_cristelwalker" | "securitycraft:recipes/building_blocks/reinforced_chiseled_polished_blackstone_from_reinforced_polished_blackstone_stonecutting" | "create:recipes/building_blocks/small_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "computercraft:recipes/redstone/disk_12" | "computercraft:recipes/redstone/disk_11" | "computercraft:recipes/redstone/disk_14" | "computercraft:recipes/redstone/disk_13" | "minecraft:recipes/redstone/jungle_pressure_plate" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_stairs_from_stone_types_packed_mud_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite_from_reinforced_diorite_stonecutting" | "create:recipes/misc/crafting/kinetics/clockwork_bearing" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_slashed_locometal" | "computercraft:recipes/redstone/disk_10" | "createdeco:recipes/building_blocks/dean_brick_slab" | "storagedelight:recipes/decorations/crimson_cabinet_with_glass_doors" | "computercraft:recipes/redstone/disk_16" | "computercraft:recipes/redstone/disk_15" | "create_dd:recipes/create_dd.palettes/cut_netherrack_slab_recycling" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/cyan_blueprint_block" | "minecraft:recipes/misc/diamond_from_blasting_diamond_ore" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "create:recipes/building_blocks/dripstone_pillar_from_stone_types_dripstone_stonecutting" | "design_decor:recipes/building_blocks/purple_metal_plate_stairs_from_metal_plate_stonecutting" | "create:recipes/misc/blasting/ingot_nickel_compat_immersiveengineering" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_polished_diorite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_slashed_locometal" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_pearl_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab" | "minecraft:recipes/decorations/blackstone_wall_from_blackstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_black_carpet_from_dye" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal" | "create:recipes/building_blocks/cut_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "storagedelight:recipes/decorations/dark_oak_drawer_with_door" | "ae2:recipes/misc/network/parts/formation_plane" | "create:copper_casing" | "ae2:recipes/misc/network/cables/smart_yellow" | "securitycraft:recipes/building_blocks/reinforced_smooth_crystal_quartz_slab" | "minecraft:recipes/building_blocks/amethyst_block" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_scarlet_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_riveted_locometal" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "superbwarfare:recipes/combat/hk_416_smithing" | "minecraft:husbandry/obtain_netherite_hoe" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_slab" | "minecraft:recipes/decorations/light_gray_banner" | "spelunkery:recipes/rough_diamond_shard" | "alexscaves:alexscaves/defeat_brainiac" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_riveted_locometal" | "casinocraft:recipes/decorations/wool_yellow" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_smelting" | "spelunkery:spelunkery/obsidian_chisel" | "minecraft:recipes/tools/iron_axe" | "framedblocks:recipes/building_blocks/framed_ext_corner_slope_panel" | "minecraft:recipes/building_blocks/sea_lantern" | "ae2:main/p2p" | "framedblocks:recipes/building_blocks/framed_inner_sloped_prism" | "sophisticatedstorage:recipes/misc/iron_barrel" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/curiosities/peculiar_bell" | "alexscaves:alexscaves/discover_abyssal_chasm" | "createdeco:recipes/building_blocks/copper_window" | "create_dd:recipes/create_dd.palettes/dark_metal_brick_slab_from_dark_metal_decor_stonecutting" | "create:recipes/building_blocks/polished_cut_diorite_slab" | "create:recipes/misc/blasting/zinc_ingot_from_crushed" | "create:recipes/building_blocks/small_limestone_brick_wall" | "minecraft:recipes/building_blocks/deepslate_tile_slab" | "minecraft:recipes/building_blocks/polished_diorite_from_diorite_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_wall" | "farmersdelight:recipes/food/tomato" | "tconstruct:recipes/building_blocks/common/glass/purple_clear_stained_glass" | "minecraft:recipes/building_blocks/nether_brick_slab_from_nether_bricks_stonecutting" | "securitycraft:recipes/building_blocks/crystal_quartz_pillar" | "railways:recipes/misc/crafting/small_buffer" | "superbwarfare:recipes/redstone/superb_item_interface" | "farmersdelight:recipes/food/mutton_wrap" | "minecraft:adventure/kill_a_mob" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_slashed_locometal" | "create:pipe_organ" | "sophisticatedbackpacks:recipes/misc/gold_backpack" | "framedblocks:recipes/tools/framed_blueprint" | "createdeco:recipes/decorations/copper_door" | "create:recipes/building_blocks/crafting/kinetics/brown_seat_from_other_seat" | "minecraft:recipes/building_blocks/deepslate_bricks_from_cobbled_deepslate_stonecutting" | "create:recipes/misc/crafting/materials/rose_quartz_tilesfrom_conversion" | "storagedelight:recipes/decorations/oak_drawer" | "tconstruct:recipes/building_blocks/world/wood/enderbark/planks" | "design_decor:recipes/building_blocks/gray_metal_plate_wall_from_metal_plate_stonecutting" | "create:recipes/building_blocks/polished_cut_asurine_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_spruce_slab" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stairs" | "tfmg:recipes/building_blocks/cut_bauxite_brick_stairs_from_stone_types_bauxite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_dripstone_brick_slab" | "superbwarfare:recipes/transportation/ah_6_container" | "create:recipes/building_blocks/cut_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_umber_brick_slab_stonecutting" | "sophisticatedstorage:recipes/misc/bamboo_barrel" | "create_dd:recipes/create_dd.palettes/cut_basalt_wall_from_stone_types_basalt_stonecutting" | "securitycraft:recipes/tools/universal_block_modifier" | "createbigcannons:recipes/misc/pair_of_cannon_wheels" | "sliceanddice:recipes/misc/sprinkler" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_polished_andesite_stonecutting" | "createdeco:recipes/decorations/andesite_catwalk_stairs_from_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_stairs_from_reinforced_mossy_cobblestone_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/magenta_blueprint_block" | "minecraft:recipes/misc/raw_iron" | "create:recipes/building_blocks/cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "interiors:recipes/building_blocks/crafting/floor_chair/light_gray_floor_chair_from_other_floor_chair" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs" | "create:recipes/building_blocks/cut_scoria_brick_slab" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "create_connected:overstress_clutch" | "minecraft:recipes/misc/stick_from_bamboo_item" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper" | "framedblocks:recipes/building_blocks/framed_double_sloped_prism" | "minecraft:recipes/redstone/bamboo_fence_gate" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_long_dean_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_slab_from_reinforced_polished_blackstone_stonecutting" | "create:fan_processing" | "create_dd:recipes/create_dd.palettes/cut_blackstone_wall_from_stone_types_blackstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal_boiler" | "create:water_supply" | "ae2:recipes/misc/tools/paintballs_white" | "createdeco:recipes/building_blocks/mossy_blue_bricks_from_moss_block" | "minecraft:recipes/misc/light_gray_dye_from_black_white_dye" | "securitycraft:recipes/decorations/reinforced_cyan_carpet" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_slab_recycling" | "create_dd:recipes/create_dd.palettes/small_dolomite_brick_slab" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/small_veridium_brick_wall" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "securitycraft:recipes/redstone/reinforced_jungle_button" | "create:recipes/building_blocks/layered_veridium_from_stone_types_veridium_stonecutting" | "tfmg:recipes/building_blocks/small_galena_brick_slab" | "create:recipes/building_blocks/polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_wall_from_stone_types_packed_mud_stonecutting" | "spelunkery:recipes/rock_salt_bricks" | "create:recipes/building_blocks/warped_window" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_smokebox" | "create:recipes/misc/crafting/kinetics/adjustable_chain_gearshift" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_glass" | "create_dd:recipes/create_dd.base/crafting/fan_catalyst/blasting_sail" | "minecraft:recipes/food/rabbit_stew_from_red_mushroom" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "railways:recipes/transportation/jukeboxcart" | "minecraft:recipes/tools/golden_hoe" | "copycats:recipes/crafting/copycat_wooden_pressure_plate" | "createdeco:recipes/building_blocks/long_dean_brick_stairs" | "createdeco:recipes/building_blocks/mossy_verdant_brick_stairs_from_mossy_verdant_bricks_stonecutting" | "create:recipes/misc/smelting/glass_from_horizontal_framed_glass" | "create:recipes/building_blocks/polished_cut_deepslate_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_plated_locometal" | "tconstruct:recipes/building_blocks/common/glass/yellow_clear_stained_glass" | "securitycraft:recipes/building_blocks/reinforced_purpur_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal_boiler" | "ae2:recipes/misc/network/crafting/cpu_crafting_accelerator" | "create_dd:recipes/create_dd.palettes/crafting/decor/pink_blueprint_block_from_pink_dye" | "framedblocks:recipes/building_blocks/framed_checkered_slab" | "create_connected:pulse_generator_infinite_loop" | "framedblocks:recipes/building_blocks/framed_large_corner_slope_panel" | "design_decor:recipes/building_blocks/metal_plate_wall_from_ingots_iron_stonecutting" | "create:recipes/misc/blasting/ingot_lead_compat_mekanism" | "minecraft:recipes/building_blocks/cut_copper_slab_from_copper_block_stonecutting" | "sophisticatedstorage:recipes/misc/diamond_to_netherite_tier_upgrade" | "ae2:recipes/misc/shaped/not_so_mysterious_cube" | "minecraft:recipes/food/mushroom_stew" | "securitycraft:recipes/building_blocks/diamond_mine" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_long_blue_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab" | "superbwarfare:recipes/misc/artillery_indicator" | "create:recipes/misc/blasting/zinc_ingot_from_ore" | "ae2:recipes/misc/network/parts/level_emitter" | "minecraft:husbandry/balanced_diet" | "minecraft:recipes/building_blocks/gray_terracotta" | "framedblocks:recipes/building_blocks/framed_flat_slope_panel_corner" | "farmersdelight:recipes/building_blocks/cabbage_crate" | "minecraft:recipes/food/cooked_cod" | "ae2:recipes/misc/network/parts/toggle_bus_alt" | "securitycraft:recipes/building_blocks/reinforced_light_blue_stained_glass" | "minecraft:recipes/building_blocks/bamboo_stairs" | "ae2:recipes/misc/network/cables/dense_covered_light_blue" | "copycats:recipes/crafting/copycat_cogwheel" | "minecraft:recipes/building_blocks/dye_yellow_bed" | "securitycraft:recipes/building_blocks/reinforced_stripped_acacia_wood" | "create:recipes/misc/crafting/materials/zinc_nugget_from_decompacting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "minecraft:recipes/building_blocks/bamboo_block" | "framedblocks:recipes/building_blocks/framed_double_threeway_corner_pillar" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_wool" | "securitycraft:recipes/decorations/secret_warped_sign_item" | "securitycraft:recipes/decorations/reinforced_blue_stained_glass_pane" | "create_dd:recipes/building_blocks/netherrack_from_stone_types_netherrack_stonecutting" | "createdeco:recipes/decorations/andesite_bars_overlay_from_stonecutting" | "minecraft:recipes/decorations/mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "storagedrawers:recipes/storagedrawers/controller_slave" | "minecraft:recipes/decorations/black_stained_glass_pane" | "design_decor:recipes/building_blocks/asurine_castel_brick_slab_from_stone_types_asurine_stonecutting" | "brewery:main/get_dried_wheat" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_slab_from_honeycomb" | "create_dd:recipes/create_dd.palettes/hazard_block_from_asphalt_blocks_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_long_dusk_brick_slab_stonecutting" | "tconstruct:recipes/decorations/smeltery/scorched/scorched_soul_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_plated_locometal" | "create:recipes/building_blocks/small_scoria_bricks_from_stone_types_scoria_stonecutting" | "sophisticatedstorage:recipes/misc/storage_advanced_feeding_upgrade_from_backpack_advanced_feeding_upgrade" | "framedblocks:recipes/building_blocks/framed_double_slope_panel" | "design_decor:recipes/building_blocks/lime_metal_sheet_stairs_from_metal_plate_stonecutting" | "superbwarfare:main/root" | "minecraft:recipes/building_blocks/dye_gray_bed" | "sophisticatedstorage:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "ae2:recipes/misc/shaped/stairs/smooth_sky_stone_block" | "createbigcannons:recipes/misc/nethersteel_screw_lock" | "storagedelight:recipes/decorations/crimson_drawer_with_door" | "framedblocks:recipes/building_blocks/framed_pyramid_slab" | "interiors:recipes/building_blocks/crafting/floor_chair/light_gray_floor_chair_from_seat" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "tconstruct:recipes/tools/tools/building/flint_and_brick" | "create:recipes/misc/crafting/materials/rose_quartz" | "createdeco:recipes/decorations/light_blue_placard" | "create:train_casing_00" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "framedblocks:recipes/building_blocks/framed_slab_rotate_to_framed_panel" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "advancedperipherals:recipes/redstone/chunk_controller" | "minecraft:recipes/food/dried_kelp" | "crusty_chunks:casting" | "sophisticatedstorage:recipes/misc/backpack_void_upgrade_from_storage_void_upgrade" | "tfmg:recipes/building_blocks/bauxite_pillar_from_stone_types_bauxite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_brick_stairs" | "brewery:recipes/pretzel" | "minecraft:nether/use_lodestone" | "create:recipes/building_blocks/cut_calcite_slab_recycling" | "framedblocks:recipes/building_blocks/framed_hanging_sign" | "securitycraft:recipes/building_blocks/reinforced_stone_stairs_from_reinforced_stone_stonecutting" | "sophisticatedbackpacks:recipes/misc/tank_upgrade" | "minecraft:recipes/building_blocks/mangrove_slab" | "tconstruct:smeltery/sand_casting" | "securitycraft:recipes/building_blocks/reinforced_pink_stained_glass" | "tconstruct:recipes/building_blocks/smeltery/scorched/nether_grout" | "alexscaves:alexscaves/gingerbread_town" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_sandstone_stairs_from_red_sandstone_stonecutting" | "ae2:recipes/misc/shaped/walls/cut_quartz_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_slashed_locometal" | "tconstruct:recipes/misc/common/flint" | "create:recipes/building_blocks/layered_deepslate_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_short_scarlet_brick_slab_stonecutting" | "minecraft:recipes/decorations/anvil" | "sophisticatedstorage:recipes/misc/red_shulker_box_to_sophisticated" | "framedblocks:recipes/tools/framed_wrench" | "createdeco:recipes/decorations/iron_catwalk_railing_forge" | "ae2:recipes/misc/tools/paintballs_lumen_red" | "framedblocks:recipes/building_blocks/framed_centered_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_honeycomb" | "securitycraft:recipes/decorations/reinforced_gray_carpet" | "create:recipes/misc/crafting/materials/raw_zinc_block" | "create:recipes/building_blocks/exposed_copper_shingle_stairs" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_blue_bricks_stonecutting" | "tconstruct:smeltery/mighty_smelting" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_smokebox" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_bricks_stonecutting" | "securitycraft:recipes/building_blocks/quartz_mine" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "createdeco:recipes/decorations/brass_catwalk_from_stonecutting" | "dragnvehicles:recipes/misc/truck" | "createdeco:recipes/building_blocks/cracked_umber_bricks_from_umber_bricks_blasting" | "ae2:recipes/misc/materials/cardfuzzy" | "minecraft:recipes/building_blocks/end_stone_bricks_from_end_stone_stonecutting" | "sophisticatedstorage:recipes/misc/storage_auto_smoking_upgrade_from_backpack_auto_smoking_upgrade" | "create:recipes/misc/crafting/appliances/filter_clear" | "tconstruct:tools/tinker_station" | "farmersdelight:recipes/cooking/vegetable_soup" | "tfmg:recipes/building_blocks/cut_bauxite_brick_slab" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/small_packed_mud_brick_slab_from_stone_types_packed_mud_stonecutting" | "create:recipes/building_blocks/polished_cut_calcite_stairs" | "create_dd:recipes/building_blocks/stone_from_stone_types_stone_stonecutting" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_brick_stairs_from_stone_types_weathered_limestone_stonecutting" | "smallships:recipes/transportation/bamboo_drakkar" | "advancedperipherals:weak_automata_core" | "tconstruct:recipes/building_blocks/common/firewood/blazewood_slab" | "createdeco:recipes/decorations/industrial_iron_catwalk_railing_forge" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_short_umber_brick_stairs_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_wall_from_stone_types_gabbro_stonecutting" | "create_dd:recipes/create_dd.palettes/raw_padded_tiled_rubber_from_raw_rubber_decor_stonecutting" | "smallships:recipes/transportation/mangrove_cog" | "minecraft:recipes/building_blocks/diorite_stairs" | "createdeco:recipes/building_blocks/umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/green_terracotta" | "createdeco:recipes/decorations/iron_coin" | "brewery:recipes/gingerbread" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper_stairs_from_reinforced_weathered_copper_stonecutting" | "securitycraft:recipes/building_blocks/sand_mine" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "create:recipes/building_blocks/small_granite_brick_slab" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k_storage" | "casinocraft:recipes/decorations/wool_white" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_short_dusk_brick_stairs_stonecutting" | "superbwarfare:recipes/combat/rpg_rocket_tbg" | "ae2:main/controller" | "sophisticatedstorage:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "createdeco:recipes/decorations/zinc_trapdoor" | "create:recipes/building_blocks/small_crimsite_brick_slab" | "alexscaves:alexscaves/neodymium" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_moss_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_smokebox" | "copycats:recipes/crafting/copycat_fluid_pipe" | "minecraft:recipes/misc/skull_banner_pattern" | "copycats:recipes/crafting/copycat_slope_layer" | "createbb:ring_bell" | "spelunkery:spelunkery/depth_gauge" | "dragnvehicles:recipes/misc/motorcycle_body" | "tconstruct:recipes/misc/common/slime/earth/slimeball_from_congealed" | "minecraft:recipes/brewing/brewing_stand" | "minecraft:recipes/root" | "farmersdelight:recipes/food/sweet_berry_cheesecake" | "railways:recipes/transportation/conductor_vent_from_industrial_iron_block_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal_boiler" | "casinocraft:recipes/decorations/item_quartz" | "minecraft:recipes/misc/quartz_from_blasting" | "createdeco:recipes/decorations/lime_shipping_container_from_dyeing_vaults" | "minecraft:recipes/building_blocks/acacia_planks" | "create:recipes/building_blocks/industrial_iron_block_from_ingots_iron_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/cracked_blue_brick_stairs_from_cracked_blue_bricks_stonecutting" | "securitycraft:recipes/misc/cage_trap" | "securitycraft:recipes/building_blocks/deepslate_emerald_mine" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_short_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "ae2:recipes/misc/shaped/slabs/quartz_pillar" | "alexscaves:alexscaves/candy_cane_hook" | "createdeco:recipes/building_blocks/zinc_window" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_stairs" | "createdeco:recipes/decorations/locked_copper_door" | "alexscaves:alexscaves/pearl" | "minecraft:recipes/redstone/iron_door" | "design_decor:recipes/building_blocks/crimsite_castel_tile_stairs_from_stone_types_crimsite_stonecutting" | "design_decor:recipes/building_blocks/green_metal_plate_stairs_from_metal_plate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_boiler" | "create_dd:recipes/create_dd.palettes/crafting/decor/gray_padded_rubber_from_gray_padded_rubber" | "tfmg:recipes/building_blocks/polished_cut_bauxite_stairs" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_slashed_locometal" | "minecraft:recipes/building_blocks/blackstone_stairs_from_blackstone_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_long_blue_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_basalt_brick_stairs_from_stone_types_basalt_stonecutting" | "alexscaves:alexscaves/raygun" | "create:recipes/building_blocks/cut_asurine_slab_recycling" | "minecraft:recipes/transportation/dark_oak_boat" | "create:recipes/building_blocks/cut_asurine_brick_wall" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs" | "create:recipes/building_blocks/polished_cut_bauxite_slab_recycling" | "crusty_chunks:uranium" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs" | "minecraft:recipes/misc/mojang_banner_pattern" | "minecraft:recipes/redstone/piston" | "securitycraft:recipes/decorations/reinforced_blue_stained_glass_pane_from_dye" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/advanced_pickup_upgrade" | "securitycraft:recipes/building_blocks/reinforced_glass" | "framedblocks:recipes/building_blocks/framed_half_slope" | "sophisticatedbackpacks:recipes/misc/iron_backpack" | "sophisticatedstorage:recipes/misc/storage_smoking_upgrade_from_backpack_smoking_upgrade" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_bricks_stonecutting" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "securitycraft:recipes/decorations/reinforced_green_carpet" | "tconstruct:recipes/redstone/smeltery/scorched/faucet" | "tconstruct:recipes/building_blocks/world/wood/skyroot/stairs" | "ae2:recipes/misc/tools/paintballs_green" | "tconstruct:recipes/misc/common/slime/sky/slimeball_from_congealed" | "create:recipes/building_blocks/vertical_framed_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal_boiler" | "minecraft:recipes/decorations/light_gray_stained_glass_pane" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "securitycraft:recipes/misc/sentry" | "minecraft:recipes/redstone/acacia_button" | "tconstruct:recipes/decorations/smeltery/scorched/scorched_glass_pane" | "ae2:recipes/misc/tools/paintballs_lumen_blue" | "tconstruct:recipes/building_blocks/smeltery/scorched/nether_grout_multiple" | "minecraft:recipes/building_blocks/stone_bricks" | "createdeco:recipes/building_blocks/umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "create:recipes/building_blocks/cut_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "securitycraft:recipes/building_blocks/crystal_quartz_stairs_from_crystal_quartz_stonecutting" | "crusty_chunks:the_forge" | "design_decor:recipes/building_blocks/limestone_castel_brick_stairs_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/kinetics/white_sailfrom_conversion" | "securitycraft:recipes/building_blocks/cobbled_deepslate_mine" | "minecraft:recipes/decorations/blast_furnace" | "minecraft:recipes/decorations/red_nether_brick_wall" | "railways:recipes/combat/dying_existing_cap_light_gray" | "create:recipes/misc/crafting/kinetics/mechanical_saw" | "alexscaves:alexscaves/fiddlehead" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_umber_brick_stairs_stonecutting" | "mts:rtfm" | "superbwarfare:recipes/combat/secondary_cataclysm_smithing" | "tconstruct:recipes/misc/common/slime/ender/slimeball_from_block" | "tconstruct:recipes/decorations/common/glass/pink_clear_stained_glass_pane_from_panes" | "tconstruct:recipes/misc/common/slime/sky/crystal_smelting" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite_stairs_from_reinforced_andesite_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_long_blue_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/birch_window" | "design_decor:recipes/building_blocks/metal_sheet_wall_from_ingots_iron_stonecutting" | "tfmg:recipes/building_blocks/small_galena_brick_slab_from_stone_types_galena_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_brick_wall" | "tconstruct:recipes/misc/common/materials/queens_slime_block_from_ingots" | "ae2:recipes/misc/decorative/smooth_quartz_block" | "railways:recipes/misc/crafting/palettes/wrapping/orange_iron_wrapped_locometal" | "minecraft:recipes/decorations/brown_banner" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_from_brick" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "securitycraft:recipes/building_blocks/reinforced_chiseled_stone_bricks" | "farmersdelight:recipes/food/melon_juice" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_triangle_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/rotation_speed_controller" | "create_enchantment_industry:a_shower_experience" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "superbwarfare:recipes/misc/m_98b_blueprint" | "spelunkery:recipes/raw_magnetite_block" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/mangrove_planks" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_blue_padded_rubber_from_light_blue_padded_rubber" | "ae2:recipes/misc/network/cables/glass_blue" | "create:recipes/building_blocks/small_veridium_brick_slab" | "ae2:recipes/misc/network/parts/annihilation_plane_alt2" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_deepslate_lapis_ore" | "securitycraft:recipes/building_blocks/reinforced_sandstone_slab_from_reinforced_sandstone_stonecutting" | "cgs:recipes/misc/lead_ingot" | "createdeco:recipes/decorations/yellow_industrial_iron_lamp" | "minecraft:recipes/building_blocks/brick_stairs" | "sophisticatedstorage:recipes/misc/advanced_alchemy_upgrade" | "computercraft:recipes/redstone/pocket_advanced/computercraft/wireless_modem_advanced" | "mts:seatbench" | "minecraft:recipes/misc/storage_io_from_output" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal_boiler" | "create_connected:recipes/crafting/kinetics/freewheel_clutch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal_boiler" | "createbigcannons:recipes/misc/wrought_iron_cannon_end" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "minecraft:recipes/misc/eye_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/lime_stained_glass_pane_from_glass_pane" | "numismatics:money_laundering" | "securitycraft:recipes/redstone/reinforced_crimson_fence_gate" | "tconstruct:recipes/decorations/smeltery/scorched/basin" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal" | "create:recipes/combat/crafting/appliances/netherite_diving_boots" | "createdeco:recipes/decorations/pink_shipping_container_from_dyeing_vaults" | "alexscaves:alexscaves/enter_purple_soda" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_dean_brick_slab_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "createbigcannons:recipes/misc/shot_balls" | "securitycraft:recipes/decorations/reinforced_blue_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "securitycraft:recipes/misc/motion_activated_light" | "ae2:recipes/misc/network/cells/spatial_components" | "alexscaves:alexscaves/ride_submarine" | "create:recipes/building_blocks/cut_tuff_brick_wall" | "framedblocks:recipes/building_blocks/framed_one_way_window" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_1_plus_from_backpack_stack_upgrade_starter_tier" | "tconstruct:foundry/plate_armor" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_stairs" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tiles_from_honeycomb" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_tiled_pearl_brick_slab_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_gabbro_slab_recycling" | "tconstruct:world/blood_island" | "tconstruct:recipes/food/gadgets/cake/earth" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite_slab_from_reinforced_polished_andesite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_smokebox" | "brewery:main/brewing_pioneer" | "alexscaves:alexscaves/nuclear_bomb" | "railways:recipes/misc/stonecutting/palettes/cycling/slashed_locometal" | "spelunkery:recipes/diamond_ores" | "securitycraft:recipes/building_blocks/reinforced_orange_stained_glass" | "minecraft:recipes/decorations/fletching_table" | "minecraft:recipes/decorations/brown_bed" | "minecraft:recipes/food/cooked_mutton_from_smoking" | "petrolpark:badge/beta_tester" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_hoe" | "create_dd:recipes/create_dd.palettes/lime_padded_mosaic_rubber_from_lime_rubber_decor_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_boiler" | "minecraft:recipes/building_blocks/polished_diorite_stairs" | "create_dd:recipes/create_dd.palettes/yellow_padded_tiled_rubber_from_yellow_rubber_decor_stonecutting" | "spelunkery:spelunkery/compression_blast_miner" | "minecraft:recipes/building_blocks/dye_brown_bed" | "ae2:main/facade" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_stairs_stonecutter" | "minecraft:recipes/misc/gold_ingot_from_gold_block" | "ae2:recipes/misc/network/cables/glass_lime" | "tconstruct:recipes/decorations/common/glass/magenta_clear_stained_glass_pane_from_panes" | "design_decor:recipes/building_blocks/red_metal_sheet_wall_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_sandstone" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_smokebox" | "create:recipes/misc/crafting/kinetics/portable_fluid_interface" | "advancedperipherals:recipes/redstone/overpowered_end_automata_core" | "create:recipes/misc/crafting/kinetics/wrench" | "create:recipes/misc/crafting/kinetics/rose_quartz_lamp" | "create:recipes/misc/crafting/kinetics/steam_whistle" | "securitycraft:recipes/misc/lime_lens" | "minecraft:recipes/decorations/purple_bed" | "tconstruct:recipes/decorations/tables/scorched_forge" | "securitycraft:recipes/transportation/birch_security_sea_boat" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "farmersdelight:recipes/decorations/pink_hanging_canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_slashed_locometal" | "create:recipes/building_blocks/crafting/kinetics/pink_seat_from_other_seat" | "securitycraft:recipes/building_blocks/smooth_crystal_quartz_stairs_from_smooth_crystal_quartz_stonecutting" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_tiled_pearl_brick_slab_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/pink_chair_from_floor_chair" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_plated_locometal" | "create:recipes/building_blocks/oxidized_copper_shingle_slab_from_oxidized_copper_shingles_stonecutting" | "createdeco:recipes/decorations/red_industrial_iron_lamp" | "farmersdelight:recipes/cooking/rabbit_stew" | "create_dd:recipes/create_dd.palettes/crafting/decor/purple_asphalt_block" | "minecraft:recipes/building_blocks/quartz_slab" | "railways:recipes/misc/crafting/semaphore" | "ae2:recipes/misc/tools/certus_quartz_pickaxe" | "alexscaves:alexscaves/defeat_gum_worm" | "superbwarfare:recipes/combat/sks_smithing" | "createdeco:recipes/building_blocks/long_dusk_bricks_from_short_dusk_bricks_stonecutting" | "create_enchantment_industry:recipes/printer" | "spelunkery:spelunkery/echo_fork" | "design_decor:recipes/building_blocks/magenta_metal_sheet_from_metal_plate_stonecutting" | "create:sturdy_sheet" | "interiors:recipes/building_blocks/crafting/chair/orange_chair_from_floor_chair" | "create_dd:recipes/create_dd.palettes/crafting/decor/brown_padded_rubber_from_brown_padded_rubber" | "farmersdelight:recipes/cooking/stuffed_pumpkin_block" | "minecraft:recipes/tools/golden_axe" | "minecraft:husbandry/leash_all_frog_variants" | "framedblocks:recipes/building_blocks/framed_stacked_slope_panel" | "create:recipes/building_blocks/cut_limestone_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_andesite_brick_slab" | "securitycraft:recipes/building_blocks/reinforced_purple_wool" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_blue_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "superbwarfare:recipes/combat/mp_443_smithing" | "minecraft:recipes/decorations/orange_banner" | "createdeco:recipes/decorations/black_placard" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_bricks" | "minecraft:recipes/decorations/oak_sign" | "create_dd:recipes/create_dd.palettes/crafting/decor/yellow_blueprint_block" | "securitycraft:recipes/building_blocks/reinforced_black_stained_glass" | "create_enchantment_industry:black_as_ink" | "comforts:rope_and_nail" | "spelunkery:recipes/polished_rock_salt" | "framedblocks:recipes/building_blocks/framed_centered_slab_rotate_to_framed_centered_panel" | "minecraft:recipes/building_blocks/red_concrete_powder" | "createdeco:recipes/building_blocks/umber_bricks_from_short_umber_bricks_stonecutting" | "ae2:recipes/misc/blasting/silicon_from_certus_quartz_dust" | "superbwarfare:recipes/misc/m_4_blueprint" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "minecraft:recipes/tools/golden_pickaxe" | "interiors:recipes/building_blocks/crafting/chair/orange_chair" | "tconstruct:recipes/decorations/smeltery/seared/table" | "design_decor:recipes/building_blocks/andesite_castel_brick_wall_from_stone_types_andesite_stonecutting" | "toms_storage:unlock_glowstone" | "createdeco:recipes/building_blocks/dean_bricks_from_tiled_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_plated_locometal" | "framedblocks:recipes/building_blocks/framed_stairs" | "dragnvehicles:recipes/misc/car_body" | "comforts:sleeping_bag_cyan" | "minecraft:recipes/building_blocks/polished_deepslate_slab" | "create:recipes/misc/crafting/appliances/copper_backtank" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_brick_slab" | "railways:recipes/combat/dying_existing_cap_cyan" | "railways:recipes/misc/crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "minecraft:recipes/building_blocks/quartz_bricks" | "sophisticatedstorage:recipes/misc/advanced_magnet_upgrade" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper_slab" | "numismatics:recipes/misc/crafting/blue_card" | "storagedelight:recipes/decorations/glass_birch_cabinet" | "sophisticatedstorage:recipes/misc/storage_advanced_void_upgrade_from_backpack_advanced_void_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_omega_tier_from_backpack_stack_upgrade_omega_tier" | "minecraft:end/dragon_egg" | "framedblocks:recipes/building_blocks/framed_flat_elev_inner_slope_slab_corner" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_ladder" | "ae2:recipes/misc/decorative/light_detector" | "minecraft:recipes/building_blocks/lapis_block" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_short_scarlet_brick_stairs_stonecutting" | "farmersdelight:recipes/food/steak_and_potatoes" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_4_from_storage_stack_upgrade_tier_5" | "create:recipes/building_blocks/polished_cut_calcite_slab" | "tconstruct:recipes/food/gadgets/cake/sky" | "createdeco:recipes/building_blocks/dean_brick_slab_from_long_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/mossy_blue_brick_stairs" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mangrove_planks" | "vinery:main/budding_grapes" | "minecraft:recipes/food/cooked_cod_from_smoking" | "framedblocks:recipes/building_blocks/framed_inv_double_slope_slab_rotate_to_framed_inv_double_slope_panel" | "farmersdelight:main/obtain_netherite_knife" | "railways:recipes/misc/stonecutting/palettes/cycling/black_plated_locometal" | "framedblocks:recipes/building_blocks/framed_double_prism_corner" | "farmersdelight:recipes/decorations/orange_hanging_canvas_sign" | "design_decor:recipes/building_blocks/deepslate_castel_bricks_from_stone_types_deepslate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cracked_deepslate_bricks" | "tconstruct:recipes/misc/common/tinkers_gadgetry" | "ae2:recipes/misc/tools/paintballs_orange" | "create:recipes/building_blocks/cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal_boiler" | "minecraft:recipes/misc/brown_dye" | "framedblocks:recipes/building_blocks/framed_sloped_prism" | "sophisticatedstorage:recipes/misc/basic_to_diamond_tier_upgrade" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_short_dusk_bricks_stonecutting" | "alexscaves:alexscaves/bioluminesscence" | "createbb:p1/obtain_ephedra" | "tconstruct:foundry/fantastic_foundry" | "create:recipes/building_blocks/cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "ae2:recipes/misc/network/cables/glass_brown" | "ae2:recipes/misc/network/wireless_terminal" | "alexscaves:alexscaves/defeat_notor" | "create:recipes/building_blocks/exposed_copper_tile_slab" | "copycats:recipes/crafting/copycat_vertical_slope" | "design_decor:recipes/building_blocks/metal_support_from_ingots_iron_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cobblestone_slab_from_reinforced_cobblestone_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/cut_andesite_slab_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "storagedrawers:recipes/storagedrawers/compacting_drawers" | "create:recipes/building_blocks/cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "create:extendo_grip" | "casinocraft:recipes/decorations/item_prismarine" | "computercraft:recipes/redstone/pocket_normal/computercraft/wireless_modem_normal" | "create:recipes/building_blocks/cut_scoria_brick_stairs" | "farmersdelight:recipes/cooking/mushroom_stew" | "create:recipes/building_blocks/polished_cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/cut_diorite_slab_from_stone_types_diorite_stonecutting" | "design_decor:recipes/building_blocks/limestone_castel_tile_stairs_from_stone_types_limestone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_stripped_warped_hyphae" | "minecraft:recipes/misc/white_dye" | "framedblocks:recipes/building_blocks/framed_checkered_cube" | "create:recipes/building_blocks/cut_scoria_brick_wall" | "framedblocks:recipes/building_blocks/framed_lattice_block" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_riveted_locometal" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_slab" | "petrolsparts:root" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_slashed_locometal" | "tconstruct:recipes/building_blocks/world/wood/enderbark/stairs" | "create:recipes/building_blocks/small_deepslate_brick_slab" | "create:recipes/building_blocks/polished_cut_veridium_slab" | "securitycraft:recipes/decorations/reinforced_green_stained_glass_pane_from_dye" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_blue_brick_slab_stonecutting" | "sophisticatedstorage:recipes/misc/diamond_shulker_box" | "ae2:recipes/misc/tools/paintballs_lumen_white" | "createdeco:recipes/building_blocks/pearl_brick_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/red_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "create:recipes/building_blocks/cut_veridium_brick_wall" | "create:recipes/building_blocks/small_scoria_brick_slab" | "createdeco:recipes/decorations/red_shipping_container_from_dyeing_vaults" | "createdeco:recipes/building_blocks/dusk_bricks_from_tiled_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_short_dean_bricks_stonecutting" | "ae2:recipes/misc/shaped/stairs/sky_stone_block" | "framedblocks:recipes/building_blocks/framed_centered_panel" | "minecraft:recipes/combat/diamond_chestplate" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_umber_bricks_stonecutting" | "numismatics:recipes/misc/crafting/cyan_id_card" | "tconstruct:recipes/misc/common/materials_and_you" | "minecraft:story/mine_stone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/decorations/furnace" | "securitycraft:recipes/misc/retinal_scanner" | "farmersdelight:recipes/tools/lead_from_straw" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/cracked_dusk_bricks_from_dusk_bricks_blasting" | "framedblocks:recipes/building_blocks/framed_slope_slab_rotate_to_framed_slope_panel" | "crusty_chunks:fission_core_acquired" | "minecraft:recipes/building_blocks/andesite_stairs" | "create_dd:recipes/create_dd.palettes/cut_blackstone_brick_slab" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_slab_from_stone_types_basalt_stonecutting" | "createdeco:recipes/decorations/copper_bars" | "create:recipes/misc/crafting/kinetics/mechanical_arm" | "minecraft:recipes/redstone/redstone_torch" | "railways:recipes/misc/crafting/palettes/wrapping/orange_brass_wrapped_locometal" | "interiors:recipes/building_blocks/crafting/chair/red_chair_from_seat" | "createdeco:recipes/decorations/cyan_placard_from_dyeing" | "minecraft:recipes/misc/gold_ingot_from_blasting_raw_gold" | "minecraft:recipes/building_blocks/green_concrete_powder" | "create:recipes/building_blocks/cut_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_stairs" | "create:recipes/misc/blasting/nickel_ingot_compat_thermal" | "create:recipes/misc/blasting/copper_ingot_from_crushed" | "tconstruct:recipes/decorations/world/wood/bloodshroom/hanging_sign" | "railways:recipes/misc/crafting/palettes/wrapping/lime_iron_wrapped_locometal" | "design_decor:recipes/building_blocks/scoria_castel_brick_slab_from_stone_types_scoria_stonecutting" | "farmersdelight:recipes/food/cooked_salmon_slice_from_campfire_cooking" | "framedblocks:recipes/building_blocks/framed_secret_storage" | "create:recipes/misc/crafting/kinetics/super_glue" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_brick_wall_from_stone_types_packed_mud_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_sandstone_wall_from_reinforced_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/lime_brass_wrapped_locometal" | "create_dd:recipes/building_blocks/basalt_from_stone_types_basalt_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_dean_brick_slab_stonecutting" | "vinery:recipes/spruce_wine_rack_big" | "createdeco:recipes/decorations/industrial_iron_bars_overlay_from_stonecutting" | "create:recipes/building_blocks/cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "tconstruct:recipes/decorations/common/glass/blue_clear_stained_glass_pane_from_panes" | "farmersdelight:recipes/food/roast_chicken_block" | "design_decor:recipes/building_blocks/scoria_castel_brick_stairs_from_stone_types_scoria_stonecutting" | "superbwarfare:recipes/misc/ak_12_blueprint" | "create:recipes/building_blocks/exposed_copper_shingle_slab" | "vinery:main/forbidden_fruit" | "create:recipes/building_blocks/cut_crimsite_slab" | "minecraft:recipes/redstone/birch_door" | "create:recipes/misc/crafting/logistics/pulse_extender" | "spelunkery:spelunkery/raw_nuggets" | "create:recipes/building_blocks/crimsite_from_stone_types_crimsite_stonecutting" | "design_decor:recipes/building_blocks/purple_metal_plate_slab_from_metal_plate_stonecutting" | "storagedrawers:recipes/storagedrawers/diamond_storage_upgrade" | "securitycraft:recipes/building_blocks/reinforced_chiseled_quartz_block" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_umber_brick_stairs_stonecutting" | "minecraft:recipes/decorations/snow" | "minecraft:recipes/building_blocks/oxidized_cut_copper_from_oxidized_copper_stonecutting" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_long_dean_bricks_stonecutting" | "createdeco:recipes/decorations/iron_catwalk_forge" | "create:recipes/building_blocks/cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_stairs" | "create:recipes/building_blocks/cut_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_red_sandstone_stairs_from_reinforced_red_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_boiler" | "tconstruct:recipes/decorations/gadgets/fancy_frame/reversed_reversed_gold" | "alexscaves:alexscaves/defeat_corrodent" | "sophisticatedstorage:recipes/misc/advanced_magnet_upgrade_from_basic" | "storagedelight:recipes/decorations/dark_oak_bookshelf_with_door" | "ae2:recipes/misc/network/cells/item_storage_components_cell_1k_part" | "tconstruct:recipes/decorations/world/wood/greenheart/fence" | "sophisticatedstorage:recipes/misc/storage_stack_downgrade_tier_2_from_backpack_stack_downgrade_tier_2" | "securitycraft:recipes/building_blocks/reinforced_orange_terracotta" | "create:recipes/building_blocks/polished_cut_tuff_slab_from_stone_types_tuff_stonecutting" | "spelunkery:spelunkery/magnetite" | "minecraft:recipes/misc/gold_ingot_from_smelting_gold_ore" | "minecraft:recipes/building_blocks/stone_bricks_from_stone_stonecutting" | "securitycraft:recipes/building_blocks/lapis_mine" | "create:copper" | "create:recipes/building_blocks/small_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "tconstruct:recipes/misc/common/materials/hepatizon_block_from_ingots" | "spelunkery:recipes/cinnabar_block" | "superbwarfare:recipes/misc/mk_14_blueprint" | "securitycraft:recipes/building_blocks/stone_mine" | "securitycraft:recipes/building_blocks/reinforced_cut_sandstone_slab_from_reinforced_sandstone_stonecutting" | "design_decor:recipes/building_blocks/orange_metal_plate_wall_from_metal_plate_stonecutting" | "create:recipes/misc/smelting/glass_from_framed_glass" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_bricks_stonecutting" | "createdeco:recipes/decorations/decal_down_right" | "createdeco:recipes/decorations/andesite_catwalk_railing_forge" | "minecraft:recipes/building_blocks/stone_slab" | "minecraft:recipes/decorations/black_carpet" | "create_dd:recipes/create_dd.palettes/cut_gabbro_brick_stairs_from_stone_types_gabbro_stonecutting" | "minecraft:recipes/misc/gold_nugget_from_blasting" | "securitycraft:recipes/building_blocks/reinforced_polished_basalt_from_reinforced_basalt_stonecutting" | "createdeco:recipes/building_blocks/mossy_umber_brick_slab" | "createdeco:recipes/building_blocks/umber_bricks" | "farmersdelight:main/get_fd_seed" | "minecraft:recipes/building_blocks/blue_concrete_powder" | "createdeco:recipes/building_blocks/blue_brick_slab_from_short_blue_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_fluix" | "superbwarfare:main/rush_rush_run" | "createdeco:recipes/building_blocks/blue_brick_slab" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_long_dusk_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_long_umber_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_4" | "minecraft:recipes/building_blocks/crimson_planks" | "design_decor:recipes/building_blocks/purple_metal_sheet_slab_from_metal_plate_stonecutting" | "create_connected:recipes/crafting/kinetics/centrifugal_clutch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_riveted_locometal" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_2" | "storagedelight:recipes/decorations/bamboo_drawer_with_books" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_3" | "create:chute" | "securitycraft:recipes/building_blocks/blast_furnace_mine" | "sophisticatedstorage:recipes/misc/limited_copper_barrel_1" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/cracked_verdant_bricks_from_verdant_bricks_blasting" | "superbwarfare:recipes/combat/ak_47_smithing" | "design_decor:recipes/building_blocks/andesite_castel_tile_stairs_from_stone_types_andesite_stonecutting" | "casinocraft:recipes/decorations/wool_brown" | "minecraft:recipes/building_blocks/black_terracotta" | "framedblocks:recipes/building_blocks/framed_flat_elev_slope_slab_corner_rotate_to_framed_flat_ext_slope_panel_corner" | "sophisticatedstorage:recipes/misc/copper_to_iron_tier_upgrade" | "tfmg:recipes/decorations/steel_bars_from_ingots_steel_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "storagedelight:recipes/decorations/small_mangrove_drawers" | "sophisticatedstorage:recipes/misc/smelting_upgrade" | "create:recipes/building_blocks/cut_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "securitycraft:recipes/building_blocks/deepslate_coal_mine" | "sophisticatedbackpacks:recipes/misc/magnet_upgrade" | "minecraft:recipes/food/cooked_rabbit" | "design_decor:recipes/building_blocks/blue_metal_plate_stairs_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_light_blue_wool" | "create:recipes/misc/crafting/appliances/crafting_blueprint" | "interiors:recipes/building_blocks/crafting/chair/blue_chair_from_other_chair" | "ae2:recipes/misc/tools/paintballs_lumen_lime" | "alexscaves:alexscaves/marine_snow" | "create:recipes/building_blocks/polished_cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/decorations/zinc_coin" | "securitycraft:recipes/redstone/reinforced_spruce_fence_gate" | "securitycraft:recipes/decorations/reinforced_blackstone_wall" | "create:crushing_wheel" | "storagedrawers:recipes/storagedrawers/acacia_drawers" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_riveted_locometal" | "createdeco:recipes/building_blocks/cracked_verdant_brick_slab" | "securitycraft:recipes/building_blocks/reinforced_nether_brick_slab" | "create:recipes/building_blocks/cut_crimsite_brick_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_pink_glazed_terracotta" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_stairs_from_stone_types_weathered_limestone_stonecutting" | "vinery:recipes/acacia_wine_rack_small" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_riveted_locometal" | "storagedelight:recipes/decorations/glass_jungle_cabinet" | "sophisticatedstorage:recipes/misc/decoration_table" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs" | "create:recipes/misc/crafting/kinetics/water_wheel" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "create:recipes/building_blocks/cut_granite_slab_from_stone_types_granite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal_boiler" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_smokebox" | "create:recipes/misc/blasting/silver_ingot_compat_oreganized" | "create_dd:recipes/create_dd.palettes/gabbro_pillar_from_stone_types_gabbro_stonecutting" | "createdeco:recipes/building_blocks/mossy_dusk_brick_slab_from_mossy_dusk_bricks_stonecutting" | "interiors:recipes/building_blocks/crafting/floor_chair/cyan_floor_chair_from_other_floor_chair" | "create:recipes/building_blocks/cut_limestone_brick_slab_recycling" | "createdeco:recipes/building_blocks/pearl_bricks_from_short_pearl_bricks_stonecutting" | "farmersdelight:main/place_organic_compost" | "alexscaves:alexscaves/desolate_dagger" | "createdeco:recipes/building_blocks/long_verdant_brick_slab" | "design_decor:recipes/building_blocks/orange_metal_sheet_wall_from_metal_plate_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/black_blueprint_block" | "securitycraft:recipes/misc/rift_stabilizer" | "create_dd:recipes/misc/crafting/coal_from_coal_piece" | "create:recipes/building_blocks/oxidized_copper_shingle_slab" | "farmersdelight:main/place_campfire" | "railways:recipes/combat/dying_existing_cap_red" | "createdeco:recipes/decorations/andesite_catwalk_stairs" | "minecraft:recipes/building_blocks/chiseled_red_sandstone" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat" | "framedblocks:recipes/building_blocks/framed_flat_inv_double_slope_slab_corner_rotate_to_framed_flat_inv_double_slope_panel_corner" | "spelunkery:recipes/rock_salt_block" | "minecraft:recipes/decorations/light_gray_stained_glass_pane_from_glass_pane" | "ae2:recipes/misc/tools/portable_fluid_cell_256k" | "superbwarfare:recipes/misc/glock_18_blueprint" | "smallships:recipes/transportation/dark_oak_brigg" | "minecraft:adventure/arbalistic" | "securitycraft:recipes/building_blocks/reinforced_pink_wool" | "tconstruct:recipes/decorations/smeltery/scorched/lantern" | "storagedrawers:recipes/storagedrawers/remote_group_upgrade" | "createdeco:recipes/decorations/green_shipping_container" | "sophisticatedstorage:recipes/misc/storage_compacting_upgrade_from_backpack_compacting_upgrade" | "tfmg:recipes/building_blocks/cut_galena_brick_slab_from_stone_types_galena_stonecutting" | "minecraft:recipes/building_blocks/pink_stained_glass" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_brick_stairs_from_stone_types_packed_mud_stonecutting" | "create:recipes/misc/crafting/kinetics/large_cogwheel_from_little" | "minecraft:recipes/building_blocks/black_stained_glass" | "tfmg:recipes/building_blocks/cut_bauxite_slab_from_stone_types_bauxite_stonecutting" | "framedblocks:recipes/building_blocks/framed_divided_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_slashed_locometal" | "securitycraft:recipes/building_blocks/reinforced_stripped_mangrove_wood" | "securitycraft:recipes/building_blocks/reinforced_green_glazed_terracotta" | "createdeco:recipes/decorations/green_placard_from_dyeing" | "spelunkery:spelunkery/purple_drink" | "create_dd:recipes/create_dd.palettes/cut_dolomite_stairs" | "securitycraft:recipes/decorations/reinforced_magenta_stained_glass_pane" | "securitycraft:recipes/building_blocks/reinforced_andesite_with_vanilla_diorite" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_sword" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_slab_from_reinforced_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/cracked_polished_blackstone_bricks" | "minecraft:recipes/building_blocks/gray_stained_glass" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cut_copper" | "securitycraft:recipes/redstone/reinforced_spruce_button" | "securitycraft:recipes/misc/storage_module" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_pearl_bricks_stonecutting" | "create:super_glue" | "interiors:recipes/building_blocks/crafting/chair/magenta_chair_from_other_chair" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_long_verdant_brick_stairs_stonecutting" | "minecraft:recipes/misc/map" | "ae2:recipes/misc/network/cables/dense_covered_light_gray" | "tconstruct:recipes/decorations/common/glass/vanilla/end_crystal" | "sophisticatedstorage:recipes/misc/paintbrush" | "brewery:main/drying_expertise" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab" | "create:recipes/building_blocks/cut_scorchia_wall" | "ae2:recipes/misc/network/parts/terminals" | "interiors:recipes/building_blocks/crafting/chair/light_gray_chair" | "securitycraft:recipes/building_blocks/reinforced_acacia_wood" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_gray_asphalt_block" | "spelunkery:recipes/copper_nugget" | "minecraft:recipes/tools/shears" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "spelunkery:recipes/emerald_ores" | "farmersdelight:recipes/decorations/gray_canvas_sign" | "ae2:recipes/misc/misc/tiny_tnt" | "railways:recipes/misc/stonecutting/palettes/cycling/white_plated_locometal" | "sophisticatedstorage:recipes/misc/storage_filter_upgrade_from_backpack_filter_upgrade" | "framedblocks:recipes/building_blocks/framed_flat_slope_slab_corner_rotate_to_framed_flat_slope_panel_corner" | "sophisticatedstorage:recipes/misc/double_gold_chest" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_wall_from_stone_types_dolomite_stonecutting" | "create:recipes/misc/crafting/materials/andesite_alloy_block" | "createdeco:recipes/decorations/green_andesite_lamp" | "tconstruct:recipes/misc/common/slime/ender/crystal_growing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal" | "superbwarfare:main/ancient_technology" | "minecraft:recipes/brewing/golden_carrot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_riveted_locometal" | "createdeco:recipes/decorations/industrial_iron_door" | "design_decor:recipes/building_blocks/calcite_castel_brick_wall_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_plated_locometal" | "framedblocks:recipes/building_blocks/framed_slab_from_framed_centered_slab" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_riveted_locometal" | "design_decor:recipes/building_blocks/veridium_castel_brick_slab_from_stone_types_veridium_stonecutting" | "ae2:recipes/misc/network/crafting/1k_cpu_crafting_storage" | "tconstruct:recipes/redstone/smeltery/seared/drain" | "create_dd:recipes/create_dd.palettes/orange_padded_mosaic_rubber_from_orange_rubber_decor_stonecutting" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k" | "minecraft:recipes/transportation/jungle_chest_boat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal_boiler" | "petrolpark:badge/nitro" | "design_decor:recipes/building_blocks/dripstone_castel_tile_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/dye_pink_bed" | "create_dd:recipes/create_dd.palettes/crafting/decor/blueprint_block" | "securitycraft:recipes/redstone/reinforced_crimson_button" | "securitycraft:recipes/building_blocks/reinforced_cut_sandstone_slab_from_reinforced_cut_sandstone_stonecutting" | "minecraft:recipes/tools/spyglass" | "securitycraft:recipes/building_blocks/reinforced_blackstone_wall_from_reinforced_blackstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_red_sandstone_wall_from_reinforced_red_sandstone_stonecutting" | "tconstruct:recipes/misc/common/materials/rose_gold_block_from_ingots" | "createdeco:recipes/building_blocks/iron_window_pane" | "railways:recipes/misc/crafting/smokestack_woodburner" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal_boiler" | "create_dd:recipes/create_dd.palettes/cut_netherrack_wall_from_stone_types_netherrack_stonecutting" | "minecraft:recipes/misc/red_dye_from_rose_bush" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_long_umber_bricks_stonecutting" | "smallships:recipes/transportation/birch_galley" | "createbigcannons:recipes/misc/nethersteel_ingot_from_block" | "sophisticatedbackpacks:recipes/misc/filter_upgrade" | "sophisticatedstorage:recipes/misc/iron_barrel_from_copper_barrel" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_smokebox" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_soul_glass" | "create:recipes/building_blocks/ochrum_pillar_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/building_blocks/cobblestone_slab_from_cobblestone_stonecutting" | "framedblocks:recipes/building_blocks/framed_double_stairs" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_stairs_from_stone_types_weathered_limestone_stonecutting" | "ae2:recipes/misc/network/cables/covered_red" | "tfmg:recipes/building_blocks/layered_bauxite_from_stone_types_bauxite_stonecutting" | "create:recipes/building_blocks/cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/light_blue_chair_from_seat" | "copycats:recipes/crafting/copycat_flat_pane" | "minecraft:recipes/building_blocks/prismarine_slab_from_prismarine_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "design_decor:recipes/building_blocks/yellow_metal_plate_wall_from_metal_plate_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_riveted_locometal" | "farmersdelight:recipes/food/carrot_from_crate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal_boiler" | "securitycraft:recipes/transportation/mangrove_security_sea_boat" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_brick_wall_from_stone_types_amethyst_block_stonecutting" | "minecraft:recipes/redstone/lightning_rod" | "minecraft:adventure/kill_all_mobs" | "create_dd:recipes/create_dd.palettes/cut_gabbro_wall_from_stone_types_gabbro_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/smart_purple" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k" | "minecraft:recipes/building_blocks/birch_wood" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_plated_locometal" | "create:recipes/misc/blasting/ingot_silver_compat_immersiveengineering" | "createdeco:recipes/building_blocks/mossy_verdant_brick_stairs" | "minecraft:recipes/decorations/crimson_sign" | "framedblocks:recipes/building_blocks/framed_double_prism" | "tconstruct:recipes/misc/common/materials/rose_gold_nugget_from_ingot" | "computercraft:recipes/redstone/turtle_advanced_upgrade" | "copycats:recipes/crafting/copycat_half_panel" | "vs_tournament:ship_assemble" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_blue_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_slab_recycling" | "create:recipes/misc/smelting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/polished_cut_diorite_wall" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "create:recipes/misc/crafting/appliances/schedule_clear" | "computercraft:recipes/redstone/turtle_advanced" | "securitycraft:recipes/decorations/reinforced_yellow_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_pillar" | "ae2:recipes/misc/misc/deconstruction_cut_certus_quartz_block" | "interiors:recipes/building_blocks/crafting/floor_chair/yellow_floor_chair_from_seat" | "create_dd:recipes/building_blocks/amethyst_block_from_stone_types_amethyst_block_stonecutting" | "minecraft:recipes/building_blocks/dye_cyan_bed" | "design_decor:recipes/building_blocks/dripstone_castel_brick_slab_from_stone_types_dripstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_smooth_red_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_boiler" | "minecraft:recipes/building_blocks/stripped_dark_oak_wood" | "sophisticatedstorage:recipes/misc/diamond_shulker_from_diamond_chest" | "copycats:recipes/crafting/copycat_slice_from_conversion" | "minecraft:recipes/building_blocks/dye_yellow_wool" | "securitycraft:recipes/building_blocks/reinforced_smooth_sandstone_stairs" | "ae2:recipes/misc/network/cables/smart_lime" | "createdeco:recipes/building_blocks/cracked_umber_brick_stairs_from_cracked_umber_bricks_stonecutting" | "create:recipes/misc/crafting/logistics/pulse_repeater" | "create:extendo_grip_dual" | "create_dd:recipes/create_dd.palettes/black_padded_rubber_slab_from_black_rubber_decor_stonecutting" | "minecraft:recipes/building_blocks/iron_block" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_pillar" | "ae2:recipes/misc/network/cables/dense_covered_brown" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_tiled_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_slab_from_umber_bricks_stonecutting" | "createdeco:recipes/decorations/copper_hull" | "spelunkery:spelunkery/grindstone" | "create:recipes/misc/smelting/bread" | "vinery:recipes/spruce_wine_rack_small" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs" | "alexscaves:alexscaves/stop_nuclear_furnace_meltdown" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab" | "create_dd:recipes/create_dd.palettes/cut_basalt_stairs_from_stone_types_basalt_stonecutting" | "create:recipes/misc/crafting/kinetics/furnace_minecart_from_contraption_cart" | "create:recipes/misc/crafting/kinetics/green_valve_handle_from_other_valve_handle" | "securitycraft:recipes/building_blocks/crystal_quartz" | "sophisticatedbackpacks:recipes/misc/advanced_compacting_upgrade" | "securitycraft:recipes/building_blocks/reinforced_cyan_glazed_terracotta" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_stairs" | "sophisticatedstorage:recipes/misc/basic_to_copper_tier_upgrade" | "ae2:recipes/misc/tools/certus_quartz_sword" | "create_connected:recipes/crafting/kinetics/vertical_brass_gearbox_from_conversion" | "minecraft:recipes/decorations/birch_hanging_sign" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_slab" | "design_decor:recipes/building_blocks/yellow_metal_sheet_wall_from_metal_plate_stonecutting" | "tconstruct:recipes/misc/common/materials/hepatizon_nugget_from_ingot" | "securitycraft:recipes/redstone/reinforced_jungle_pressure_plate" | "create_dd:recipes/create_dd.palettes/cut_blackstone_stairs_from_stone_types_blackstone_stonecutting" | "securitycraft:recipes/decorations/secret_sign_item" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "casinocraft:recipes/decorations/wool_blue" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_short_pearl_brick_stairs_stonecutting" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_dusk_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_granite_slab_from_reinforced_granite_stonecutting" | "tconstruct:recipes/decorations/tables/tinkers_chest" | "createdeco:recipes/decorations/yellow_iron_lamp" | "minecraft:recipes/redstone/birch_fence_gate" | "tconstruct:recipes/decorations/common/glass/magenta_clear_stained_glass_pane" | "minecraft:recipes/redstone/stone_button" | "ae2:recipes/misc/network/cables/dense_smart_lime" | "create:recipes/building_blocks/cut_dripstone_brick_stairs" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_slab_from_reinforced_cobbled_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_plated_locometal" | "farmersdelight:recipes/decorations/cooking_pot" | "ae2:recipes/misc/network/parts/terminals_crafting" | "storagedrawers:recipes/storagedrawers/drawer_puller" | "farmersdelight:recipes/food/apple_pie_from_slices" | "create:spout" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal" | "spelunkery:spelunkery/wooden_rail" | "alexscaves:alexscaves/galena_gauntlet_challenge" | "minecraft:recipes/building_blocks/stone" | "minecraft:recipes/decorations/green_carpet" | "createbigcannons:recipes/misc/autocannon_ammo_container" | "minecraft:recipes/building_blocks/light_blue_terracotta" | "superbwarfare:recipes/misc/m_79_blueprint" | "createdeco:recipes/decorations/iron_mesh_fence_from_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_iron_wrapped_locometal" | "create_dd:recipes/create_dd.base/crafting/multimeter" | "minecraft:recipes/transportation/bamboo_raft" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor_alt" | "create:recipes/building_blocks/small_crimsite_brick_slab_recycling" | "createdeco:recipes/building_blocks/cracked_umber_bricks_from_umber_bricks_smelting" | "createdeco:recipes/building_blocks/long_red_bricks_from_tiled_red_bricks_stonecutting" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst" | "vinery:main/grape_picker" | "createdeco:recipes/decorations/iron_ladder_from_stonecutting" | "create:recipes/building_blocks/small_rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab" | "copycats:recipes/crafting/copycat_flat_pane_from_conversion" | "spelunkery:spelunkery/rough_diamond" | "framedblocks:recipes/building_blocks/framed_flat_stacked_inner_slope_panel_corner_rotate_to_framed_flat_stacked_inner_slope_slab_corner" | "minecraft:recipes/building_blocks/cut_copper" | "minecraft:recipes/redstone/stone_pressure_plate" | "tconstruct:recipes/building_blocks/world/wood/enderbark/slab" | "create:recipes/building_blocks/cut_ochrum_brick_slab_recycling" | "minecraft:recipes/building_blocks/dye_lime_bed" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_short_blue_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_blue" | "securitycraft:recipes/building_blocks/deepslate_mine" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_pillar" | "sophisticatedstorage:recipes/misc/basic_to_iron_tier_from_basic_to_copper_tier" | "minecraft:adventure/spyglass_at_dragon" | "smallships:recipes/transportation/mangrove_brigg" | "ae2:recipes/misc/network/cables/dense_covered_pink" | "sophisticatedbackpacks:recipes/misc/advanced_jukebox_upgrade" | "securitycraft:recipes/building_blocks/reinforced_jungle_stairs" | "sophisticatedstorage:recipes/misc/dark_oak_chest_from_quark_dark_oak_chest" | "alexscaves:alexscaves/uranium" | "create:recipes/building_blocks/deepslate_from_stone_types_deepslate_stonecutting" | "ae2:recipes/misc/network/cables/smart_blue" | "sophisticatedstorage:recipes/misc/auto_smoking_upgrade" | "ae2:recipes/misc/network/cells/item_storage_components_cell_64k_part" | "create:recipes/misc/crafting/kinetics/speedometerfrom_conversion" | "spelunkery:recipes/rough_diamond_block" | "sophisticatedstorage:recipes/misc/jungle_chest" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_axe" | "copycats:recipes/crafting/copycat_slope_from_conversion" | "minecraft:recipes/decorations/red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:recipes/food/cookie" | "createdeco:recipes/building_blocks/zinc_window_pane" | "vinery:main/juice_it_up" | "securitycraft:recipes/building_blocks/reinforced_stripped_spruce_wood" | "comforts:hammock_brown" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_long_scarlet_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_pillar" | "interiors:recipes/building_blocks/crafting/chair/green_chair_from_other_chair" | "create:recipes/building_blocks/small_asurine_brick_slab_recycling" | "minecraft:recipes/misc/fire_charge" | "vinery:recipes/grapevine_pot" | "minecraft:recipes/decorations/soul_torch" | "superbwarfare:recipes/combat/mp_5_smithing" | "tfmg:recipes/building_blocks/cut_galena_wall" | "mts:partscanner" | "minecraft:recipes/building_blocks/yellow_terracotta" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_wall" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_wall_from_reinforced_deepslate_tiles_stonecutting" | "superbwarfare:recipes/misc/mp_5_blueprint" | "design_decor:recipes/building_blocks/white_metal_plate_wall_from_metal_plate_stonecutting" | "spelunkery:recipes/raw_iron" | "spelunkery:recipes/raw_magnetite" | "createbigcannons:recipes/misc/cannon_carriage" | "minecraft:recipes/misc/writable_book" | "createdeco:recipes/decorations/brass_door" | "sophisticatedstorage:recipes/misc/feeding_upgrade" | "create:recipes/building_blocks/polished_cut_granite_stairs" | "sophisticatedstorage:recipes/misc/alchemy_upgrade" | "casinocraft:recipes/decorations/wool_lime" | "create_connected:recipes/crafting/palettes/copycat_slab_compat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_slashed_locometal" | "createdeco:recipes/decorations/magenta_shipping_container_from_dyeing_vaults" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs" | "design_decor:recipes/building_blocks/veridium_castel_tile_wall_from_stone_types_veridium_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_backtank_from_netherite" | "tconstruct:recipes/decorations/common/glass/light_gray_clear_stained_glass_pane" | "minecraft:recipes/food/bread" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal" | "minecraft:nether/obtain_ancient_debris" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_gray_blueprint_block_from_light_gray_dye" | "ae2:recipes/misc/decorative/fluix_block" | "design_decor:recipes/building_blocks/light_gray_metal_sheet_slab_from_metal_plate_stonecutting" | "minecraft:recipes/decorations/magenta_candle" | "cgs:recipes/misc/lead_nugget" | "create:recipes/building_blocks/cut_veridium_wall_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "tfmg:recipes/decorations/nickel_bars_from_ingots_nickel_stonecutting" | "create:recipes/building_blocks/tuff_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/diorite" | "securitycraft:recipes/misc/username_logger" | "minecraft:recipes/building_blocks/dye_white_bed" | "design_decor:recipes/building_blocks/brown_metal_plate_slab_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/cracked_blue_bricks_from_blue_bricks_blasting" | "createdeco:recipes/decorations/iron_coinstack" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "minecraft:recipes/decorations/spruce_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_riveted_locometal" | "securitycraft:recipes/building_blocks/reinforced_quartz_stairs_from_reinforced_quartz_block_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_from_granite_stonecutting" | "create:recipes/building_blocks/cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "sophisticatedstorage:recipes/misc/advanced_filter_upgrade" | "ae2:recipes/misc/tools/paintballs_light_blue" | "alexscaves:alexscaves/eat_darkened_apple" | "createdeco:recipes/building_blocks/cracked_dusk_brick_slab" | "framedblocks:recipes/building_blocks/framed_lever" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "numismatics:recipes/misc/crafting/white_id_card" | "tconstruct:recipes/tools/common/slime/lead" | "farmersdelight:recipes/decorations/magenta_canvas_sign" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_long_red_bricks_stonecutting" | "create:cart_pickup" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_honeycomb" | "sophisticatedstorage:recipes/misc/stack_upgrade_tier_1_plus" | "create:recipes/building_blocks/copper_tiles_from_ingots_copper_stonecutting" | "minecraft:recipes/misc/shulker_box_from_vanilla_shulker_box" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_blackstone_stonecutting" | "tfmg:recipes/building_blocks/polished_cut_bauxite_wall" | "create:recipes/building_blocks/cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_slashed_locometal" | "minecraft:recipes/redstone/redstone_from_smelting_redstone_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_riveted_locometal" | "tconstruct:recipes/misc/common/slime/sky/slimeball_from_block" | "minecraft:recipes/building_blocks/hay_block" | "securitycraft:recipes/building_blocks/reinforced_prismarine_slab_from_reinforced_prismarine_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal_boiler" | "tconstruct:recipes/decorations/gadgets/frame/manyullyn" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_slab_from_honeycomb" | "securitycraft:recipes/building_blocks/reinforced_cut_copper_slab" | "ae2:recipes/misc/block_cutter/walls/fluix_wall" | "create:recipes/building_blocks/weathered_copper_shingle_stairs_from_weathered_copper_shingles_stonecutting" | "minecraft:recipes/building_blocks/granite" | "create:recipes/building_blocks/cut_granite_brick_slab" | "create:recipes/building_blocks/polished_cut_limestone_slab_recycling" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_dean_bricks_stonecutting" | "tfmg:recipes/building_blocks/polished_cut_galena_slab_from_stone_types_galena_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_smokebox" | "securitycraft:recipes/misc/whitelist_module" | "minecraft:recipes/misc/emerald_from_smelting_deepslate_emerald_ore" | "design_decor:recipes/building_blocks/light_gray_metal_plate_from_metal_plate_stonecutting" | "minecraft:recipes/redstone/target" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_brick_stairs" | "alexscaves:alexscaves/tame_raycat" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_slab" | "minecraft:recipes/redstone/crimson_door" | "create:recipes/misc/smelting/lead_ingot_compat_oreganized" | "createdeco:recipes/decorations/light_blue_shipping_container_from_dyeing_vaults" | "tconstruct:recipes/building_blocks/common/firewood/nahuatl_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_pillar" | "minecraft:recipes/redstone/acacia_door" | "design_decor:recipes/building_blocks/scoria_castel_tile_slab_from_stone_types_scoria_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "securitycraft:recipes/misc/keycard_lv1_reset" | "createdeco:recipes/decorations/blue_shipping_container_from_dyeing_vaults" | "securitycraft:recipes/building_blocks/reinforced_prismarine_brick_slab_from_reinforced_prismarine_bricks_stonecutting" | "superbwarfare:main/blueprint" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_slab_from_reinforced_end_stone_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/interfaces_interface" | "framedblocks:recipes/building_blocks/framed_ext_double_corner_slope_panel" | "minecraft:recipes/decorations/spruce_fence" | "minecraft:recipes/transportation/activator_rail" | "minecraft:recipes/tools/diamond_shovel" | "createdeco:recipes/building_blocks/cracked_scarlet_bricks_from_scarlet_bricks_smelting" | "minecraft:recipes/building_blocks/polished_granite_slab_from_polished_granite_stonecutting" | "chipped:recipes/carpenters_table" | "farmersdelight:recipes/cooking/squid_ink_pasta" | "createdeco:recipes/decorations/industrial_iron_catwalk_stairs_from_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_stairs_from_stone_types_stone_stonecutting" | "sophisticatedbackpacks:recipes/misc/netherite_backpack" | "minecraft:husbandry/safely_harvest_honey" | "create:recipes/building_blocks/polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "sophisticatedstorage:recipes/misc/stonecutter_upgrade" | "ae2:recipes/misc/network/parts/panels_dark_monitor" | "securitycraft:recipes/building_blocks/gilded_blackstone_mine" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "minecraft:adventure/spyglass_at_ghast" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_bricks_from_vanilla_stone_bricks" | "minecraft:adventure/trim_with_any_armor_pattern" | "tconstruct:recipes/combat/tools/armor/travelers_chestplate" | "create_enchantment_industry:recipes/disenchanter" | "alexscaves:alexscaves/walk_on_rock_candy" | "copycats:recipes/crafting/copycat_slab_from_steps" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_slab" | "tfmg:recipes/building_blocks/small_galena_brick_stairs" | "securitycraft:recipes/misc/reinforced_acacia_fence" | "securitycraft:recipes/building_blocks/reinforced_cherry_planks" | "createdeco:recipes/decorations/orange_placard" | "create:recipes/building_blocks/small_limestone_brick_slab" | "sophisticatedstorage:recipes/misc/crimson_chest" | "securitycraft:recipes/decorations/secret_spruce_sign_item" | "createbigcannons:recipes/misc/smoke_shell" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_slashed_locometal" | "create_dd:recipes/create_dd.palettes/crafting/decor/red_asphalt_block" | "create_dd:recipes/create_dd.palettes/gray_padded_rubber_slab_from_gray_rubber_decor_stonecutting" | "securitycraft:recipes/decorations/reinforced_granite_wall" | "securitycraft:recipes/decorations/secret_cherry_sign_item" | "framedblocks:recipes/building_blocks/framed_fancy_rail" | "tconstruct:recipes/decorations/smeltery/scorched/alloyer" | "create:long_train" | "framedblocks:recipes/building_blocks/framed_corner_pillar_from_pillar" | "advancedperipherals:recipes/redstone/overpowered_weak_automata_core" | "copycats:recipes/crafting/copycat_panel_from_conversion" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_diorite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cyan_stained_glass" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_slashed_locometal" | "framedblocks:recipes/building_blocks/framed_divided_panel_vertical" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_3" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_4" | "railways:recipes/misc/crafting/palettes/wrapping/black_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_2" | "create:recipes/building_blocks/cut_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_deepslate" | "securitycraft:recipes/decorations/secret_dark_oak_hanging_sign" | "design_decor:recipes/building_blocks/granite_castel_brick_wall_from_stone_types_granite_stonecutting" | "superbwarfare:recipes/misc/steel_action" | "minecraft:recipes/building_blocks/dye_black_carpet" | "ae2:recipes/misc/misc/deconstruction_smooth_certus_quartz_block" | "minecraft:recipes/building_blocks/waxed_copper_block_from_honeycomb" | "minecraft:recipes/building_blocks/weathered_cut_copper" | "create:recipes/building_blocks/small_bauxite_brick_slab_recycling" | "create:recipes/building_blocks/cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_red_nether_brick_slab_from_reinforced_red_nether_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_basalt_brick_slab_from_stone_types_basalt_stonecutting" | "minecraft:recipes/redstone/warped_trapdoor" | "ae2:recipes/misc/shaped/slabs/smooth_sky_stone_block" | "create_connected:shear_pin" | "securitycraft:recipes/building_blocks/reinforced_smooth_quartz_stairs_from_reinforced_smooth_quartz_stonecutting" | "minecraft:recipes/building_blocks/dye_brown_wool" | "mts:wheelbench" | "minecraft:recipes/redstone/light_weighted_pressure_plate" | "numismatics:recipes/misc/crafting/brass_depositor" | "superbwarfare:recipes/combat/svd_smithing" | "numismatics:recipes/misc/crafting/orange_card" | "minecraft:adventure/throw_trident" | "farmersdelight:recipes/cooking/glow_berry_custard" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_slab_from_stone_types_packed_mud_stonecutting" | "minecraft:recipes/misc/conduit" | "create:recipes/building_blocks/spruce_window" | "createdeco:recipes/building_blocks/blue_bricks_from_short_blue_bricks_stonecutting" | "spelunkery:recipes/salt" | "createdeco:recipes/decorations/brass_mesh_fence_from_stonecutting" | "create_connected:recipes/crafting/kinetics/item_silo_from_conversion" | "minecraft:recipes/building_blocks/prismarine_stairs_from_prismarine_stonecutting" | "ae2:main/presses" | "create_dd:recipes/create_dd.palettes/dark_metal_plating_from_dark_metal_decor_stonecutting" | "minecraft:recipes/decorations/green_candle" | "ae2:recipes/misc/network/cables/dense_covered_yellow" | "securitycraft:recipes/building_blocks/crystal_quartz_pillar_from_crystal_quartz_stonecutting" | "sophisticatedstorage:recipes/misc/storage_chipped_loom_table_upgrade_from_backpack_chipped_loom_table_upgrade" | "createdeco:recipes/decorations/blue_zinc_lamp" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_slashed_locometal" | "design_decor:recipes/building_blocks/orange_metal_plate_stairs_from_metal_plate_stonecutting" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "storagedrawers:recipes/storagedrawers/crimson_trim" | "create_dd:recipes/create_dd.palettes/cut_netherrack_brick_stairs_from_stone_types_netherrack_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "alexscaves:alexscaves/discover_toxic_caves" | "computercraft:recipes/redstone/wireless_modem_normal" | "design_decor:recipes/building_blocks/purple_metal_plate_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_long_dusk_brick_slab_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_auto_smelting_upgrade_from_storage_auto_smelting_upgrade" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "ae2:recipes/misc/network/cells/fluid_cell_housing" | "farmersdelight:recipes/decorations/white_hanging_canvas_sign" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "create_dd:recipes/create_dd.palettes/cyan_padded_mosaic_rubber_from_cyan_rubber_decor_stonecutting" | "interiors:recipes/building_blocks/crafting/floor_chair/orange_floor_chair_from_other_floor_chair" | "securitycraft:recipes/building_blocks/reinforced_dark_oak_planks" | "minecraft:recipes/redstone/repeater" | "minecraft:recipes/tools/compass" | "create_dd:recipes/create_dd.palettes/crafting/decor/yellow_blueprint_block_from_yellow_dye" | "createdeco:recipes/building_blocks/cracked_dean_bricks_from_dean_bricks_smelting" | "farmersdelight:recipes/food/kelp_roll" | "create:recipes/misc/crafting/kinetics/fluid_pipe_vertical" | "brewery:main/get_beer_barley" | "design_decor:recipes/building_blocks/white_metal_sheet_wall_from_metal_plate_stonecutting" | "superbwarfare:recipes/combat/m_98b_smithing" | "createdeco:recipes/decorations/decal_down_left" | "design_decor:recipes/building_blocks/red_metal_plate_wall_from_metal_plate_stonecutting" | "minecraft:adventure/ol_betsy" | "minecraft:recipes/building_blocks/quartz_block" | "create_dd:recipes/create_dd.palettes/small_gabbro_brick_stairs" | "sophisticatedstorage:recipes/misc/backpack_feeding_upgrade_from_storage_feeding_upgrade" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite_slab_from_reinforced_polished_diorite_stonecutting" | "tfmg:recipes/building_blocks/galena_pillar_from_stone_types_galena_stonecutting" | "create:recipes/building_blocks/cut_crimsite_brick_slab" | "securitycraft:recipes/redstone/keycard_holder" | "design_decor:recipes/building_blocks/brown_metal_sheet_slab_from_metal_plate_stonecutting" | "createdeco:recipes/decorations/andesite_catwalk_railing_from_stonecutting" | "ae2:recipes/misc/network/blocks/crystal_processing_growth_accelerator" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "tconstruct:recipes/redstone/world/wood/skyroot/fence_gate" | "design_decor:recipes/building_blocks/light_gray_metal_plate_slab_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_normal_stone_slab" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_wall_from_reinforced_deepslate_bricks_stonecutting" | "minecraft:nether/netherite_armor" | "minecraft:recipes/building_blocks/birch_stairs" | "securitycraft:recipes/building_blocks/reinforced_blue_carpet_from_dye" | "alexscaves:alexscaves/deep_ones_become_helpful" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_long_blue_brick_stairs_stonecutting" | "alexscaves:alexscaves/underzealot_sacrifice" | "minecraft:recipes/building_blocks/purpur_pillar" | "securitycraft:recipes/misc/security_camera" | "minecraft:recipes/decorations/end_rod" | "create:recipes/building_blocks/small_veridium_brick_slab_recycling" | "vinery:recipes/dark_cherry_shelf" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_tiled_dusk_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_wall" | "createdeco:recipes/decorations/zinc_support" | "create_dd:recipes/create_dd.palettes/cut_netherrack_stairs_from_stone_types_netherrack_stonecutting" | "minecraft:recipes/decorations/gray_stained_glass_pane_from_glass_pane" | "design_decor:recipes/building_blocks/andesite_castel_brick_slab_from_stone_types_andesite_stonecutting" | "create:recipes/misc/crafting/kinetics/mechanical_pump" | "ae2:recipes/misc/decorative/sky_stone_small_brick_from_stonecutting" | "superbwarfare:recipes/misc/common_material_pack" | "tconstruct:recipes/decorations/common/glass/cyan_clear_stained_glass_pane" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs" | "securitycraft:recipes/building_blocks/reinforced_acacia_stairs" | "tconstruct:recipes/decorations/common/glass/light_blue_clear_stained_glass_pane" | "create_dd:recipes/create_dd.palettes/dark_metal_brick_stairs_from_dark_metal_decor_stonecutting" | "ae2:main/charged_quartz" | "securitycraft:recipes/building_blocks/reinforced_cobbled_deepslate_slab_from_reinforced_cobbled_deepslate_stonecutting" | "ae2:recipes/misc/tools/fluix_shovel" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_wall" | "minecraft:recipes/decorations/gray_glazed_terracotta" | "sophisticatedstorage:recipes/misc/controller" | "vinery:main/fruits_of_the_field" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_short_umber_brick_slab_stonecutting" | "createdeco:recipes/decorations/yellow_copper_lamp" | "design_decor:recipes/building_blocks/cyan_metal_plate_wall_from_metal_plate_stonecutting" | "farmersdelight:recipes/food/hamburger" | "minecraft:recipes/building_blocks/copper_block" | "design_decor:recipes/building_blocks/diorite_castel_brick_slab_from_stone_types_diorite_stonecutting" | "farmersdelight:recipes/food/rice" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite_slab" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_block_from_ingots" | "securitycraft:recipes/building_blocks/reinforced_white_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_riveted_locometal" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_slab_recycling" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "minecraft:recipes/misc/popped_chorus_fruit" | "framedblocks:recipes/building_blocks/framed_trapdoor" | "minecraft:nether/distract_piglin" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_2_from_backpack_stack_upgrade_tier_1" | "create_dd:recipes/create_dd.palettes/crafting/decor/purple_padded_rubber_from_purple_padded_rubber" | "design_decor:recipes/building_blocks/light_blue_metal_sheet_stairs_from_metal_plate_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_red" | "minecraft:recipes/building_blocks/sandstone_stairs" | "sophisticatedbackpacks:recipes/misc/void_upgrade" | "comforts:hammock_purple" | "createdeco:recipes/decorations/green_zinc_lamp" | "create:mechanical_pump_0" | "create:recipes/building_blocks/polished_cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smoking" | "createdeco:recipes/building_blocks/cracked_umber_brick_slab_from_cracked_umber_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_brick_slab_recycling" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_slab_from_reinforced_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_quartz_pillar" | "createdeco:recipes/decorations/iron_sheet_metal" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_smokebox" | "farmersdelight:recipes/food/cooked_bacon_from_campfire_cooking" | "createdeco:recipes/building_blocks/dusk_brick_slab" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_raw_gold" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/smooth_basalt" | "securitycraft:recipes/misc/blue_lens" | "create:recipes/building_blocks/small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "create_dd:recipes/create_dd.palettes/pink_padded_rubber_stairs_from_pink_rubber_decor_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_bricks_from_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_bricks_from_stone_types_amethyst_block_stonecutting" | "create_dd:recipes/create_dd.palettes/small_packed_mud_brick_stairs_from_stone_types_packed_mud_stonecutting" | "framedblocks:recipes/building_blocks/framed_redstone_torch" | "securitycraft:recipes/misc/briefcase" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal_boiler" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_slab" | "minecraft:recipes/decorations/deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_pillar" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "ae2:recipes/misc/decorative/certus_quartz_bricks_from_stonecutting" | "tfmg:recipes/building_blocks/copper_truss_from_ingots_copper_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "ae2:main/crafting_cpu" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_long_dean_bricks_stonecutting" | "minecraft:recipes/decorations/black_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_pillar" | "sophisticatedstorage:recipes/misc/generic_chest" | "ae2:recipes/misc/network/cables/covered_light_blue" | "create:recipes/building_blocks/crafting/kinetics/red_seat_from_other_seat" | "securitycraft:recipes/building_blocks/reinforced_chiseled_nether_bricks" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_slab_from_stone_types_netherrack_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/fence_gate" | "interiors:recipes/building_blocks/crafting/floor_chair/orange_floor_chair_from_seat" | "framedblocks:recipes/building_blocks/framed_door" | "railways:recipes/combat/dying_existing_cap_magenta" | "alexscaves:alexscaves/defuse_nuclear_bomb" | "spelunkery:spelunkery/magnetic_compass" | "securitycraft:recipes/building_blocks/deepslate_iron_mine" | "brewery:main/get_whiskey_maggoallan" | "overworld_netherite_ore:ancient_remnants" | "sophisticatedstorage:recipes/misc/blasting_upgrade" | "tfmg:recipes/building_blocks/concrete_stairs_from_concrete_stonecutting" | "securitycraft:recipes/misc/keycard_lv2_reset" | "dragnvehicles:recipes/misc/motorcycle" | "sophisticatedbackpacks:recipes/misc/backpack" | "ae2:recipes/misc/block_cutter/slabs/smooth_sky_stone_slab" | "createdeco:recipes/building_blocks/long_umber_brick_slab_from_long_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_granite_brick_slab_recycling" | "createdeco:recipes/decorations/andesite_catwalk_forge" | "minecraft:recipes/food/cooked_beef_from_smoking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_slashed_locometal" | "storagedrawers:recipes/storagedrawers/shroud_key" | "design_decor:recipes/building_blocks/diorite_castel_tile_slab_from_stone_types_diorite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_red_glazed_terracotta" | "createdeco:recipes/building_blocks/long_blue_brick_stairs" | "minecraft:nether/all_potions" | "securitycraft:recipes/redstone/reinforced_mangrove_pressure_plate" | "create_dd:recipes/create_dd.palettes/cut_dolomite_stairs_from_stone_types_dolomite_stonecutting" | "vinery:recipes/red_grape_bag" | "tconstruct:recipes/decorations/smeltery/seared/lantern" | "minecraft:recipes/misc/diamond_from_smelting_deepslate_diamond_ore" | "create:recipes/building_blocks/cut_andesite_bricks_from_stone_types_andesite_stonecutting" | "minecraft:recipes/combat/netherite_boots_smithing" | "minecraft:recipes/misc/light_blue_dye_from_blue_white_dye" | "securitycraft:recipes/decorations/reinforced_end_stone_brick_wall" | "create_dd:recipes/create_dd.palettes/small_dolomite_brick_wall" | "ae2:recipes/misc/shaped/stairs/cut_quartz_block" | "smallships:recipes/transportation/mangrove_drakkar" | "minecraft:recipes/building_blocks/orange_concrete_powder" | "ae2:recipes/misc/block_cutter/slabs/cut_quartz_slab" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_campfire_cooking" | "create:recipes/building_blocks/crafting/kinetics/orange_seat_from_other_seat" | "chipped:recipes/botanist_workbench" | "interiors:recipes/building_blocks/crafting/floor_chair/magenta_floor_chair_from_other_floor_chair" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone" | "minecraft:recipes/building_blocks/raw_copper_block" | "minecraft:recipes/building_blocks/granite_stairs" | "sophisticatedstorage:recipes/misc/backpack_chipped_carpenters_table_upgrade_from_storage_chipped_carpenters_table_upgrade" | "sophisticatedstorage:recipes/misc/storage_input" | "securitycraft:recipes/tools/remote_access_mine" | "create:recipes/building_blocks/small_andesite_bricks_from_stone_types_andesite_stonecutting" | "tconstruct:recipes/decorations/common/glass/clear_glass_pane" | "minecraft:recipes/building_blocks/dye_red_bed" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_short_dusk_bricks_stonecutting" | "securitycraft:recipes/decorations/reinforced_magenta_carpet" | "create_dd:recipes/create_dd.base/crafting/equipment/flipped_magnet" | "securitycraft:recipes/misc/electrified_iron_fence" | "minecraft:recipes/building_blocks/dye_black_bed" | "tfmg:recipes/building_blocks/copper_frame_from_ingots_copper_stonecutting" | "framedblocks:recipes/building_blocks/framed_pane" | "createdeco:recipes/building_blocks/cracked_red_bricks_from_bricks_blasting" | "createdeco:recipes/building_blocks/mossy_pearl_brick_stairs_from_mossy_pearl_bricks_stonecutting" | "securitycraft:recipes/decorations/reinforced_lime_stained_glass_pane_from_dye" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_dean_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_brick_slab_from_reinforced_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_slab" | "sophisticatedstorage:recipes/misc/copper_to_netherite_tier_upgrade" | "minecraft:recipes/misc/leather" | "create:recipes/building_blocks/cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/cut_veridium_from_stone_types_veridium_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/black_chair_from_other_chair" | "farmersdelight:recipes/building_blocks/tomato_crate" | "cgs:recipes/misc/shotgun_spread_barrel" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_stairs" | "ae2:recipes/misc/tools/paintballs_lumen_black" | "storagedelight:recipes/decorations/dark_oak_drawer_with_books" | "tconstruct:recipes/misc/common/materials/slimesteel_nugget_from_ingot" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_tinted_glass" | "farmersdelight:recipes/food/cooked_salmon_slice" | "create:recipes/misc/crafting/appliances/copper_diving_boots" | "minecraft:recipes/transportation/bamboo_chest_raft" | "securitycraft:recipes/building_blocks/reinforced_warped_stairs" | "ae2:recipes/misc/decorative/certus_quartz_pillar" | "create_dd:recipes/create_dd.palettes/small_stone_brick_wall_from_stone_types_stone_stonecutting" | "tconstruct:recipes/misc/common/materials/cobalt_nugget_from_ingot" | "design_decor:recipes/building_blocks/asurine_castel_tile_slab_from_stone_types_asurine_stonecutting" | "minecraft:recipes/building_blocks/raw_gold_block" | "minecraft:recipes/building_blocks/dye_red_wool" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_short_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_slashed_locometal" | "securitycraft:recipes/decorations/reinforced_red_sandstone_wall" | "sophisticatedstorage:recipes/misc/gold_barrel" | "ae2:recipes/misc/network/cells/item_storage_components_cell_16k_part" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_long_umber_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_wall" | "brewery:main/wild_crops" | "ae2:main/storage_bus" | "copycats:recipes/crafting/copycat_light_weighted_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_boiler" | "securitycraft:recipes/decorations/reinforced_black_carpet" | "ae2:recipes/misc/block_cutter/slabs/quartz_brick_slab" | "create:track_0" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_blackstone_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_deepslate_gold_ore" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_slashed_locometal" | "minecraft:recipes/redstone/spruce_pressure_plate" | "minecraft:recipes/building_blocks/granite_stairs_from_granite_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_tiled_umber_bricks_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs_from_prismarine_stonecutting" | "tconstruct:recipes/decorations/tables/modifier_worktable" | "interiors:recipes/building_blocks/crafting/floor_chair/cyan_floor_chair_from_seat" | "minecraft:recipes/misc/gold_ingot_from_blasting_gold_ore" | "ae2:recipes/misc/network/blocks/energy_energy_cell" | "tconstruct:recipes/redstone/world/wood/bloodshroom/door" | "create:recipes/misc/crafting/kinetics/clutch" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_stairs" | "securitycraft:recipes/decorations/reinforced_light_blue_stained_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/refill_upgrade" | "superbwarfare:recipes/combat/aurelia_sceptre_smithing" | "ae2:recipes/misc/network/parts/cable_anchor" | "minecraft:recipes/building_blocks/dye_blue_carpet" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_tiled_red_bricks_stonecutting" | "storagedelight:recipes/decorations/birch_single_door_cabinet" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_riveted_locometal" | "storagedelight:recipes/decorations/oak_cabinet_with_glass_doors" | "create:recipes/building_blocks/cut_dripstone_stairs" | "create:recipes/building_blocks/copper_tile_stairs" | "framedblocks:recipes/building_blocks/framed_flat_stacked_slope_slab_corner_rotate_to_framed_flat_stacked_slope_panel_corner" | "create:recipes/misc/crafting/curiosities/cake" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_riveted_locometal" | "minecraft:recipes/decorations/magenta_banner" | "minecraft:recipes/tools/stone_pickaxe" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "storagedelight:recipes/decorations/mangrove_cabinet_with_glass_doors" | "create:recipes/misc/crafting/kinetics/depot" | "create_dd:recipes/create_dd.palettes/small_blackstone_brick_slab_recycling" | "minecraft:recipes/decorations/deepslate_brick_wall" | "smallships:recipes/misc/sail" | "railways:recipes/misc/stonecutting/palettes/cycling/red_riveted_locometal" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_blasting" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_2_from_limited_copper_barrel_2" | "createdeco:recipes/building_blocks/long_red_brick_stairs" | "minecraft:recipes/misc/black_dye" | "minecraft:recipes/food/honey_bottle" | "securitycraft:recipes/building_blocks/reinforced_chiseled_polished_blackstone" | "create:recipes/building_blocks/layered_calcite_from_stone_types_calcite_stonecutting" | "minecraft:recipes/misc/light_gray_dye_from_gray_white_dye" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_backtank" | "spelunkery:recipes/netherite_ingot" | "minecraft:recipes/misc/iron_ingot_from_smelting_iron_ore" | "minecraft:recipes/decorations/lantern" | "sophisticatedstorage:recipes/misc/cherry_chest" | "create:recipes/building_blocks/cut_scorchia_brick_slab_recycling" | "ae2:recipes/misc/network/blocks/storage_chest" | "storagedelight:recipes/decorations/warped_drawer" | "create:recipes/misc/crafting/kinetics/minecart_from_contraption_cart" | "numismatics:recipes/misc/crafting/purple_card" | "securitycraft:recipes/building_blocks/reinforced_chiseled_crystal_quartz_block" | "farmersdelight:recipes/food/beef_patty" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1_from_starter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_diorite_slab_from_reinforced_diorite_stonecutting" | "create:recipes/building_blocks/cut_diorite_brick_slab_recycling" | "securitycraft:recipes/building_blocks/reinforced_stone_bricks" | "create:recipes/building_blocks/ornate_iron_window" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tiles" | "create:recipes/misc/crafting/kinetics/attribute_filter" | "create:recipes/building_blocks/cut_crimsite_slab_recycling" | "minecraft:adventure/fall_from_world_height" | "framedblocks:recipes/building_blocks/framed_flat_inv_double_slope_panel_corner" | "tfmg:recipes/building_blocks/lead_frame_from_ingots_lead_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs" | "securitycraft:recipes/misc/projector" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_stairs_from_honeycomb" | "superbwarfare:recipes/combat/ntw_20_smithing" | "minecraft:recipes/decorations/blue_bed" | "create:recipes/building_blocks/cut_scorchia_brick_stairs" | "storagedelight:recipes/decorations/jungle_single_door_cabinet" | "sophisticatedstorage:recipes/misc/spruce_barrel_from_vanilla_barrel" | "tconstruct:recipes/redstone/smeltery/seared/channel" | "createbigcannons:recipes/misc/wrought_iron_drop_mortar_end" | "tconstruct:recipes/building_blocks/world/wood/skyroot/log_to_wood" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_slab_from_honeycomb" | "tfmg:recipes/building_blocks/polished_cut_galena_slab" | "design_decor:recipes/building_blocks/gray_metal_plate_from_metal_plate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_plated_locometal" | "securitycraft:recipes/building_blocks/reinforced_bamboo_planks" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_jungle_wood" | "sophisticatedstorage:recipes/misc/black_shulker_box_to_sophisticated" | "createdeco:recipes/building_blocks/cracked_verdant_brick_slab_from_cracked_verdant_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/small_dolomite_bricks_from_stone_types_dolomite_stonecutting" | "farmersdelight:recipes/cooking/dumplings" | "storagedrawers:recipes/storagedrawers/portability_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_riveted_locometal" | "ae2:recipes/misc/block_cutter/walls/quartz_pillar_wall" | "farmersdelight:recipes/food/sweet_berry_cheesecake_from_slices" | "sophisticatedbackpacks:recipes/misc/chipped/botanist_workbench_upgrade" | "securitycraft:recipes/building_blocks/reinforced_dark_oak_slab" | "minecraft:recipes/misc/red_dye_from_beetroot" | "createbigcannons:recipes/misc/log_cannon_end" | "ae2:recipes/misc/tools/paintballs_lumen_green" | "design_decor:recipes/building_blocks/crimsite_castel_bricks_from_stone_types_crimsite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_from_stone_types_packed_mud_stonecutting" | "create:display_link" | "create_dd:recipes/create_dd.palettes/crafting/decor/brown_asphalt_block" | "minecraft:recipes/tools/wooden_hoe" | "create:recipes/building_blocks/polished_cut_scorchia_from_stone_types_scorchia_stonecutting" | "copycats:recipes/crafting/copycat_board" | "sophisticatedbackpacks:recipes/misc/pickup_upgrade" | "farmersdelight:recipes/decorations/light_blue_canvas_sign" | "sophisticatedstorage:recipes/misc/storage_stack_downgrade_tier_3_from_backpack_stack_downgrade_tier_3" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_pillar" | "superbwarfare:recipes/misc/bl_132_blueprint" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_wall_from_reinforced_cobbled_deepslate_stonecutting" | "spelunkery:recipes/raw_gold" | "numismatics:recipes/misc/crafting/andesite_depositor" | "minecraft:recipes/decorations/granite_wall" | "ae2:recipes/misc/network/cables/glass_fluix" | "create_dd:recipes/create_dd.palettes/gray_padded_tiled_rubber_from_gray_rubber_decor_stonecutting" | "securitycraft:recipes/redstone/portable_radar" | "create:recipes/building_blocks/copper_tile_slab_from_copper_tiles_stonecutting" | "framedblocks:recipes/building_blocks/framed_torch" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_tiled_dusk_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mangrove_wood" | "tconstruct:recipes/misc/common/slime/ichor/slimeball_from_block" | "sophisticatedstorage:recipes/misc/oak_chest" | "create:recipes/misc/crafting/schematics/schematicannon" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_boiler" | "farmersdelight:recipes/food/cooked_chicken_cuts" | "minecraft:recipes/redstone/oak_fence_gate" | "alexscaves:alexscaves/tame_candicorn" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_riveted_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_pillar" | "minecraft:husbandry/bred_all_animals" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "tconstruct:recipes/misc/common/materials/copper_nugget_from_ingot" | "mts:jumpercable" | "createdeco:recipes/decorations/decal_skull" | "numismatics:recipes/misc/crafting/bank_terminal" | "createdeco:recipes/building_blocks/mossy_dusk_brick_stairs" | "create_dd:recipes/create_dd.palettes/small_basalt_brick_wall_from_stone_types_basalt_stonecutting" | "tconstruct:recipes/redstone/world/wood/enderbark/door" | "create:recipes/building_blocks/cut_tuff_slab" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_stairs" | "tconstruct:recipes/misc/common/glass/vanilla/beacon" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal" | "createdeco:recipes/building_blocks/tiled_blue_bricks_from_long_blue_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/green_plated_locometal" | "create:saw_processing" | "interiors:recipes/building_blocks/crafting/chair/blue_chair" | "minecraft:recipes/misc/charcoal" | "create_dd:recipes/create_dd.palettes/dark_metal_brick_slab_from_industrial_iron_block_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_slab" | "tfmg:recipes/building_blocks/bauxite_from_stone_types_bauxite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_brick_stairs" | "minecraft:recipes/building_blocks/polished_granite_slab_from_granite_stonecutting" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_haunting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_small_brick_wall" | "minecraft:recipes/building_blocks/polished_andesite_from_andesite_stonecutting" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_long_scarlet_brick_stairs_stonecutting" | "vinery:recipes/campfire" | "create_dd:recipes/create_dd.palettes/small_blackstone_brick_stairs" | "ae2:recipes/misc/tools/nether_quartz_pickaxe" | "minecraft:recipes/tools/iron_shovel" | "create_dd:recipes/create_dd.palettes/small_netherrack_brick_stairs_from_stone_types_netherrack_stonecutting" | "create:recipes/building_blocks/cut_asurine_slab_from_stone_types_asurine_stonecutting" | "tfmg:recipes/decorations/aluminum_ladder_from_ingots_aluminum_stonecutting" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed_storage" | "sophisticatedbackpacks:recipes/misc/jukebox_upgrade" | "create:recipes/misc/crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "create:recipes/misc/crafting/materials/brass_block_from_compacting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_pearl_bricks_from_long_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_plated_locometal" | "minecraft:recipes/decorations/item_frame" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "farmersdelight:recipes/decorations/gray_hanging_canvas_sign" | "minecraft:recipes/building_blocks/cut_copper_slab" | "farmersdelight:recipes/food/rice_roll_medley_block" | "farmersdelight:recipes/food/cake_from_slices" | "tfmg:recipes/building_blocks/cut_bauxite_from_stone_types_bauxite_stonecutting" | "design_decor:recipes/building_blocks/black_metal_sheet_stairs_from_metal_plate_stonecutting" | "securitycraft:recipes/misc/sonic_security_system" | "interiors:recipes/building_blocks/crafting/chair/red_chair_from_floor_chair" | "interiors:recipes/building_blocks/crafting/floor_chair/yellow_floor_chair" | "createdeco:recipes/building_blocks/tiled_verdant_bricks_from_long_verdant_bricks_stonecutting" | "create:recipes/building_blocks/jungle_window_pane" | "sophisticatedstorage:recipes/misc/magenta_shulker_box_to_sophisticated" | "create:recipes/building_blocks/crimson_window_pane" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_short_umber_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_dusk_bricks_stonecutting" | "tconstruct:recipes/decorations/gadgets/fancy_frame/reversed_gold" | "create:recipes/misc/crafting/kinetics/shaft" | "createdeco:recipes/building_blocks/long_blue_brick_slab_from_short_blue_bricks_stonecutting" | "vinery:recipes/vinemaker_leggings" | "advancedperipherals:recipes/redstone/peripheral_casing" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal" | "minecraft:recipes/misc/coast_armor_trim_smithing_template" | "minecraft:recipes/combat/diamond_helmet" | "create_dd:recipes/create_dd.palettes/cut_basalt_slab_recycling" | "numismatics:recipes/misc/crafting/black_card" | "create:recipes/misc/crafting/kinetics/white_valve_handle_from_other_valve_handle" | "farmersdelight:recipes/decorations/full_tatami_mat_from_halves" | "sophisticatedstorage:recipes/misc/chipped/mason_table_upgrade" | "sliceanddice:recipes/misc/slicer" | "securitycraft:recipes/building_blocks/reinforced_orange_glazed_terracotta" | "securitycraft:recipes/building_blocks/reinforced_bamboo_mosaic" | "tconstruct:recipes/tools/tools/building/earth_staff" | "mts:vehiclebench" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "alexscaves:alexscaves/feed_relicheirus" | "create:deployer" | "securitycraft:recipes/building_blocks/reinforced_smooth_sandstone" | "superbwarfare:recipes/combat/steel_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template" | "create_connected:recipes/crafting/kinetics/inverted_clutch_from_conversion" | "tconstruct:recipes/decorations/common/glass/gray_clear_stained_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal" | "create:recipes/building_blocks/small_calcite_brick_stairs" | "casinocraft:recipes/decorations/wool_light_blue" | "spelunkery:recipes/raw_gold_nugget" | "create_connected:recipes/crafting/palettes/bamboo_window" | "farmersdelight:recipes/decorations/crimson_cabinet" | "createdeco:recipes/decorations/pink_placard" | "create:recipes/misc/crafting/kinetics/hand_crank" | "storagedrawers:recipes/storagedrawers/upgrade_template" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal_boiler" | "advancedperipherals:sense_toolkit" | "create:recipes/building_blocks/cut_asurine_wall_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_slab_recycling" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_short_verdant_brick_slab_stonecutting" | "alexscaves:alexscaves/caramel_apple" | "spelunkery:recipes/polished_nephrite" | "alexscaves:alexscaves/caramel" | "ae2:recipes/misc/network/wireless_access_point" | "create:recipes/building_blocks/copper_tile_slab" | "tconstruct:recipes/building_blocks/smeltery/scorched/chiseled_scorched_bricks_stonecutting" | "marbledsfirstaid:marbleds_first_aid/root" | "tconstruct:recipes/combat/tools/armor/travelers_pants" | "farmersdelight:recipes/decorations/hanging_canvas_sign" | "create:recipes/building_blocks/cut_tuff_brick_stairs" | "superbwarfare:recipes/misc/taser_blueprint" | "minecraft:recipes/building_blocks/cyan_stained_glass" | "minecraft:recipes/tools/netherite_axe_smithing" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_brick_slab" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_slab" | "ae2:recipes/misc/network/blocks/interfaces_interface_alt" | "railways:recipes/misc/crafting/smokestack_oilburner" | "minecraft:recipes/building_blocks/andesite" | "numismatics:recipes/misc/crafting/yellow_id_card" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_pillar" | "create_dd:recipes/create_dd.palettes/polished_cut_gabbro_slab" | "createdeco:recipes/building_blocks/short_red_brick_slab" | "createdeco:recipes/building_blocks/long_red_bricks_from_bricks_stonecutting" | "numismatics:recipes/misc/crafting/brown_id_card" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal" | "ae2:recipes/misc/tools/paintballs_lumen_yellow" | "minecraft:recipes/building_blocks/blackstone_slab" | "interiors:recipes/building_blocks/crafting/floor_chair/lime_floor_chair_from_other_floor_chair" | "create:recipes/building_blocks/small_deepslate_brick_stairs" | "create_dd:recipes/create_dd.palettes/small_basalt_brick_stairs_from_stone_types_basalt_stonecutting" | "minecraft:story/form_obsidian" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "create:recipes/building_blocks/layered_scorchia_from_stone_types_scorchia_stonecutting" | "create:haunted_bell" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_purpur_slab" | "design_decor:recipes/building_blocks/cyan_metal_sheet_wall_from_metal_plate_stonecutting" | "create:recipes/building_blocks/cut_calcite_wall_from_stone_types_calcite_stonecutting" | "createdeco:recipes/building_blocks/brass_window_pane" | "framedblocks:recipes/building_blocks/framed_slope" | "tconstruct:recipes/building_blocks/common/glass/red_clear_stained_glass" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_polished_blackstone_stonecutting" | "tconstruct:recipes/decorations/common/glass/purple_clear_stained_glass_pane" | "createdeco:recipes/decorations/decal_fluid" | "createdeco:recipes/building_blocks/dean_brick_slab_from_short_dean_bricks_stonecutting" | "createdeco:recipes/decorations/decal_ice" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_riveted_locometal" | "interiors:recipes/building_blocks/crafting/floor_chair/magenta_floor_chair_from_seat" | "createdeco:recipes/building_blocks/mossy_red_bricks_from_moss_block" | "create_dd:recipes/create_dd.palettes/cut_netherrack_stairs" | "minecraft:nether/loot_bastion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal_boiler" | "tconstruct:recipes/building_blocks/common/glass/brown_clear_stained_glass" | "create:recipes/misc/campfire_cooking/bread" | "spelunkery:recipes/stick" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_slab_recycling" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_alt" | "tconstruct:recipes/misc/common/materials/raw_cobalt_from_raw_block" | "storagedrawers:recipes/storagedrawers/drawer_key" | "create:recipes/building_blocks/cut_diorite_slab" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "design_decor:recipes/building_blocks/pink_metal_plate_from_metal_plate_stonecutting" | "design_decor:recipes/building_blocks/orange_metal_sheet_stairs_from_metal_plate_stonecutting" | "minecraft:recipes/redstone/jungle_door" | "create:recipes/building_blocks/small_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/granite_pillar_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_slab" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_end_stone_bricks_from_reinforced_end_stone_stonecutting" | "createdeco:recipes/decorations/decal_flow" | "alexscaves:alexscaves/gummy_rings" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal_boiler" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_slab_from_reinforced_polished_blackstone_stonecutting" | "ae2:recipes/misc/network/parts/terminals_pattern_access" | "copycats:recipes/crafting/copycat_fence" | "tconstruct:recipes/decorations/gadgets/frame/netherite" | "tconstruct:world/ancient_tools" | "copycats:recipes/crafting/copycat_vertical_stairs_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "create_connected:sequenced_pulse_generator" | "createdeco:recipes/decorations/industrial_iron_ladder_from_stonecutting" | "create:recipes/building_blocks/cut_andesite_slab_recycling" | "securitycraft:recipes/decorations/reinforced_cobblestone_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_pillar" | "create_dd:recipes/create_dd.palettes/crafting/raw_padded_rubber_from_raw_padded_rubber" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "copycats:recipes/crafting/copycat_half_layer" | "tfmg:recipes/building_blocks/small_bauxite_brick_wall_from_stone_types_bauxite_stonecutting" | "superbwarfare:recipes/misc/mle_1934_blueprint" | "design_decor:recipes/building_blocks/green_metal_sheet_stairs_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_smooth_sandstone_stairs_from_reinforced_smooth_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_pillar" | "framedblocks:recipes/building_blocks/framed_small_inner_corner_slope_panel" | "mts:key" | "createdeco:recipes/building_blocks/dusk_bricks" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_stairs_from_reinforced_deepslate_bricks_stonecutting" | "tfmg:recipes/building_blocks/cut_bauxite_stairs_from_stone_types_bauxite_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/grout" | "ae2:main/spatial_ioport" | "securitycraft:recipes/building_blocks/reinforced_polished_granite_stairs_from_reinforced_polished_granite_stonecutting" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_alchemy_upgrade_from_storage_alchemy_upgrade" | "create:recipes/misc/crafting/materials/experience_nugget_from_block" | "create:recipes/misc/crafting/kinetics/orange_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/polished_cut_granite_wall_from_stone_types_granite_stonecutting" | "ae2:main/compass" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_long_red_bricks_stonecutting" | "design_decor:recipes/building_blocks/deepslate_castel_brick_wall_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/cut_bauxite_slab_recycling" | "ae2:recipes/misc/materials/advancedcard" | "ae2:main/glass_cable" | "farmersdelight:recipes/decorations/lime_hanging_canvas_sign" | "securitycraft:recipes/building_blocks/deepslate_gold_mine" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_slab" | "create_dd:recipes/create_dd.palettes/crafting/decor/brown_blueprint_block_from_brown_dye" | "create:recipes/misc/crafting/kinetics/gray_valve_handle_from_other_valve_handle" | "create:mechanical_press" | "tfmg:recipes/building_blocks/cut_galena_stairs_from_stone_types_galena_stonecutting" | "create_dd:recipes/create_dd.palettes/light_gray_padded_rubber_slab_from_light_gray_rubber_decor_stonecutting" | "create:recipes/misc/crafting/kinetics/turntable" | "securitycraft:recipes/decorations/reinforced_sandstone_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_slashed_locometal" | "minecraft:recipes/tools/wooden_shovel" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_tiled_blue_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cut_copper_stairs" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_bricks_from_reinforced_blackstone_stonecutting" | "minecraft:recipes/decorations/bamboo_mosaic" | "brewery:main/crop_collector" | "minecraft:recipes/building_blocks/purpur_stairs" | "securitycraft:recipes/misc/pink_lens" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_slab_from_reinforced_polished_blackstone_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/hopper_upgrade" | "ae2:recipes/misc/tools/paintballs_lumen_magenta" | "smallships:recipes/transportation/acacia_galley" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "createdeco:recipes/decorations/industrial_iron_support" | "railways:recipes/misc/crafting/palettes/wrapping/orange_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_riveted_locometal" | "vs_eureka:recipes/balloon_leather" | "securitycraft:recipes/redstone/keycard_reader" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_slab" | "minecraft:recipes/decorations/crimson_fence" | "create:recipes/misc/crafting/appliances/clipboard_clear" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_smooth_red_sandstone" | "securitycraft:recipes/building_blocks/reinforced_green_stained_glass" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_stairs" | "farmersdelight:recipes/food/beetroot_from_crate" | "minecraft:recipes/building_blocks/stripped_crimson_hyphae" | "createdeco:recipes/decorations/netherite_coin" | "securitycraft:recipes/decorations/reinforced_purple_carpet" | "securitycraft:recipes/building_blocks/reinforced_mud_brick_slab_from_reinforced_mud_bricks_stonecutting" | "createbigcannons:recipes/misc/ap_autocannon_round" | "create_connected:recipes/crafting/palettes/copycat_vertical_step_compat" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_dusk_bricks_stonecutting" | "cgs:recipes/misc/stock" | "spelunkery:recipes/polished_nephrite_bricks" | "computercraft:recipes/redstone/turtle_normal/computercraft/wireless_modem_advanced" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_stairs" | "sophisticatedstorage:recipes/misc/storage_stack_downgrade_tier_1_from_backpack_stack_downgrade_tier_1" | "superbwarfare:recipes/misc/cemented_carbide_trigger" | "interiors:recipes/building_blocks/crafting/floor_chair/blue_floor_chair" | "sophisticatedstorage:recipes/misc/oak_chest_from_vanilla_chest" | "mts:gunbench" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal" | "sophisticatedstorage:recipes/misc/backpack_auto_blasting_upgrade_from_storage_auto_blasting_upgrade" | "design_decor:recipes/building_blocks/granite_castel_tiles_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_long_umber_bricks_stonecutting" | "railways:recipes/combat/dying_existing_cap_brown" | "create:recipes/building_blocks/cut_andesite_brick_slab_recycling" | "create:recipes/misc/smelting/ingot_uranium_compat_mekanism" | "create:recipes/building_blocks/layered_dripstone_from_stone_types_dripstone_stonecutting" | "vinery:main/wild_harvest" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_bricks_from_vanilla_moss" | "securitycraft:recipes/misc/trophy_system" | "minecraft:recipes/misc/yellow_dye_from_sunflower" | "storagedrawers:recipes/storagedrawers/oak_drawers" | "securitycraft:recipes/tools/taser" | "alexscaves:alexscaves/feed_gammaroach" | "minecraft:recipes/brewing/cauldron" | "createdeco:recipes/building_blocks/cracked_verdant_brick_stairs" | "create:recipes/building_blocks/cut_andesite_wall_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/misc/crafting/kinetics/track_observer" | "create:recipes/decorations/andesite_bars_from_andesite_alloy_stonecutting" | "superbwarfare:recipes/misc/aurelia_sceptre_blueprint" | "comforts:sleeping_bag_orange" | "create_dd:recipes/create_dd.palettes/small_stone_brick_stairs_from_stone_types_stone_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cherry_wood" | "create_dd:recipes/create_dd.palettes/dark_metal_brick_stairs_from_industrial_iron_block_stonecutting" | "create:recipes/misc/crafting/kinetics/sail_framefrom_conversion" | "framedblocks:recipes/building_blocks/framed_vertical_double_stairs_rotate_to_framed_double_stairs" | "create:recipes/misc/crafting/kinetics/sticker" | "storagedrawers:recipes/storagedrawers/min_redstone_upgrade" | "createdeco:recipes/building_blocks/long_blue_brick_slab" | "minecraft:adventure/root" | "framedblocks:recipes/building_blocks/framed_inv_double_corner_slope_panel" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs" | "spelunkery:recipes/rough_cinnabar_shard" | "securitycraft:recipes/building_blocks/chiseled_crystal_quartz" | "createdeco:recipes/building_blocks/long_red_brick_slab_from_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/dean_brick_slab_from_dean_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_gray" | "superbwarfare:recipes/combat/vector_smithing" | "ae2:recipes/misc/block_cutter/walls/quartz_wall" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_slashed_locometal" | "minecraft:recipes/misc/ender_eye" | "tconstruct:recipes/misc/common/slime/earth/crystal_growing" | "computercraft:recipes/redstone/pocket_computer_advanced" | "minecraft:recipes/redstone/redstone_block" | "ae2:main/spatial_explorer" | "minecraft:recipes/decorations/dark_oak_hanging_sign" | "framedblocks:recipes/building_blocks/framed_pillar" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_brick_stairs" | "tconstruct:recipes/redstone/common/slime/ender/slimeblock" | "ae2:recipes/misc/shaped/stairs/smooth_quartz_block" | "ae2:recipes/misc/shaped/walls/sky_stone_block" | "createdeco:recipes/building_blocks/long_scarlet_brick_stairs_from_short_scarlet_brick_stairs_stonecutting" | "create:recipes/misc/crafting/kinetics/smart_fluid_pipe" | "create:recipes/building_blocks/polished_cut_tuff_slab_recycling" | "tfmg:recipes/building_blocks/cut_bauxite_wall" | "rechiseledcreate:recipes/misc/mechanical_chisel" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "create:recipes/misc/crafting/materials/raw_zinc" | "minecraft:recipes/decorations/nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:recipes/decorations/red_stained_glass_pane_from_glass_pane" | "createbigcannons:recipes/misc/gunpowder_pinch" | "spelunkery:spelunkery/every_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_slashed_locometal" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_stairs" | "copycats:recipes/crafting/copycat_block_from_slabs" | "ae2:recipes/misc/network/cables/dense_smart_light_blue" | "create:recipes/building_blocks/cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/decorations/copper_hull_from_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_slab_from_stone_types_dolomite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_yellow_stained_glass" | "sophisticatedstorage:recipes/misc/double_iron_chest_from_copper_chest" | "superbwarfare:recipes/misc/m_870_blueprint" | "ae2:recipes/misc/decorative/sky_stone_small_brick" | "framedblocks:recipes/building_blocks/framed_corner_slope" | "minecraft:recipes/decorations/deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/small_limestone_bricks_from_stone_types_limestone_stonecutting" | "framedblocks:recipes/building_blocks/framed_compound_slope_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_pillar" | "create:recipes/building_blocks/small_asurine_brick_slab" | "create:recipes/building_blocks/polished_cut_scorchia_wall" | "create:recipes/building_blocks/small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "create:recipes/building_blocks/cut_granite_brick_stairs" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_brick_stairs" | "create_dd:recipes/create_dd.palettes/cut_stone_brick_slab" | "minecraft:recipes/decorations/bamboo_hanging_sign" | "create:recipes/building_blocks/small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_riveted_locometal" | "design_decor:recipes/building_blocks/veridium_castel_brick_wall_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_smokebox" | "design_decor:recipes/building_blocks/ochrum_castel_tile_slab_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tiles_from_honeycomb" | "design_decor:recipes/building_blocks/tuff_castel_tiles_from_stone_types_tuff_stonecutting" | "createdeco:recipes/decorations/brass_coin" | "sophisticatedbackpacks:recipes/misc/pump_upgrade" | "create:recipes/building_blocks/ornate_iron_window_pane" | "ae2:main/growth_accelerator" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_riveted_locometal" | "createbigcannons:recipes/misc/ram_head" | "create:recipes/building_blocks/scorchia_pillar_from_stone_types_scorchia_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_stairs" | "ae2:recipes/misc/tools/paintballs_magenta" | "securitycraft:recipes/building_blocks/smooth_crystal_quartz_slab" | "createdeco:recipes/decorations/purple_placard_from_dyeing" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed_storage" | "minecraft:recipes/decorations/light_blue_carpet" | "sophisticatedstorage:recipes/misc/backpack_smelting_upgrade_from_storage_smelting_upgrade" | "create_dd:recipes/create_dd.palettes/cut_netherrack_brick_slab" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stairs_stonecutter" | "create:recipes/building_blocks/cut_scoria_wall" | "alexscaves:alexscaves/eat_block_of_chocolate" | "securitycraft:recipes/building_blocks/reinforced_cobblestone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_slashed_locometal" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "railways:recipes/misc/crafting/smokestack_long" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs" | "sophisticatedstorage:recipes/misc/copper_barrel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal_boiler" | "vinery:recipes/dark_cherry_floorboard" | "casinocraft:recipes/misc/item_book" | "createdeco:recipes/decorations/iron_catwalk_railing_from_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/chiseled_quartz_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/quartz_slab_from_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper_stairs_from_reinforced_exposed_cut_copper_stonecutting" | "numismatics:recipes/misc/crafting/red_id_card" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_plated_locometal" | "ae2:recipes/misc/network/blocks/spatial_io_pylon" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_stairs_from_reinforced_cobbled_deepslate_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_slashed_locometal" | "securitycraft:recipes/building_blocks/reinforced_acacia_planks" | "create:recipes/building_blocks/cut_veridium_slab" | "minecraft:recipes/combat/crossbow" | "farmersdelight:recipes/food/shepherds_pie_block" | "create_dd:recipes/create_dd.palettes/crafting/decor/magenta_asphalt_block" | "minecraft:recipes/building_blocks/cracked_deepslate_bricks" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_dusk_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper_stairs_from_reinforced_exposed_copper_stonecutting" | "minecraft:recipes/building_blocks/warped_planks" | "createdeco:recipes/decorations/copper_trapdoor" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab" | "minecraft:recipes/decorations/warped_fence" | "framedblocks:recipes/building_blocks/framed_stacked_slope_panel_rotate_to_framed_stacked_slope_slab" | "minecraft:recipes/decorations/black_glazed_terracotta" | "tconstruct:recipes/misc/common/materials/copper_ingot_from_nuggets" | "create:recipes/building_blocks/crafting/kinetics/green_seat" | "railways:recipes/combat/dying_existing_cap_yellow" | "create:recipes/building_blocks/cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs" | "ae2:recipes/misc/network/cables/dense_smart_purple" | "framedblocks:recipes/tools/framing_saw" | "farmersdelight:recipes/decorations/green_canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal_boiler" | "createbb:p1/obtain_white_meth" | "create_dd:recipes/create_dd.palettes/crafting/decor/orange_padded_rubber_from_orange_padded_rubber" | "minecraft:recipes/misc/gray_dye" | "create:train_whistle" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_4_from_limited_copper_barrel_4" | "create:recipes/building_blocks/cut_limestone_wall" | "securitycraft:recipes/building_blocks/reinforced_purpur_pillar_from_reinforced_purpur_block_stonecutting" | "createdeco:recipes/building_blocks/cracked_dusk_brick_slab_from_cracked_dusk_bricks_stonecutting" | "createbigcannons:recipes/misc/empty_powder_charge" | "sophisticatedstorage:recipes/misc/netherite_barrel" | "securitycraft:recipes/building_blocks/reinforced_stripped_oak_wood" | "minecraft:recipes/decorations/barrel" | "ae2:recipes/misc/tools/paintballs_gray" | "create:recipes/building_blocks/polished_cut_diorite_stairs" | "sophisticatedstorage:recipes/misc/backpack_auto_smoking_upgrade_from_storage_auto_smoking_upgrade" | "minecraft:recipes/misc/orange_dye_from_orange_tulip" | "sophisticatedbackpacks:recipes/misc/anvil_upgrade" | "createdeco:recipes/building_blocks/long_dean_bricks_from_dean_bricks_stonecutting" | "copycats:recipes/crafting/copycat_vertical_slope_from_conversion" | "ae2:recipes/misc/network/parts/terminals_pattern_encoding" | "copycats:recipes/crafting/copycat_stairs" | "numismatics:recipes/misc/crafting/pink_card" | "framedblocks:recipes/building_blocks/framed_flat_inner_slope_slab_corner" | "farmersdelight:main/craft_knife" | "framedblocks:recipes/building_blocks/framed_floor_board" | "tconstruct:recipes/decorations/common/glass/white_clear_stained_glass_pane_from_panes" | "spelunkery:recipes/rough_emerald_shard" | "securitycraft:recipes/building_blocks/reinforced_black_wool" | "comforts:hammock_pink" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_smokebox" | "securitycraft:recipes/building_blocks/reinforced_purple_glazed_terracotta" | "create:recipes/misc/smelting/ingot_nickel_compat_immersiveengineering" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_umber_bricks_stonecutting" | "farmersdelight:recipes/decorations/cyan_canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_slashed_locometal" | "create_dd:recipes/create_dd.palettes/cut_netherrack_wall" | "sophisticatedstorage:recipes/misc/acacia_chest_from_quark_acacia_chest" | "createdeco:recipes/building_blocks/tiled_verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/green_chair" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/purple_seat" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal_boiler" | "securitycraft:recipes/building_blocks/reinforced_purple_carpet_from_dye" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_short_dean_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_wall" | "tfmg:recipes/building_blocks/zinc_frame_from_ingots_zinc_stonecutting" | "create:recipes/building_blocks/weathered_copper_tile_slab" | "framedblocks:recipes/building_blocks/framed_double_slope_panel_from_inverse_double_slope_panel" | "spelunkery:spelunkery/summon_slime" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/glass_magenta" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_polished_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_granite_slab" | "storagedelight:recipes/decorations/small_acacia_drawers" | "minecraft:recipes/decorations/lime_banner" | "minecraft:recipes/decorations/white_bed" | "tfmg:recipes/building_blocks/concrete_slab_from_concrete_stonecutting" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "vs_eureka:recipes/balloon_paper" | "create:recipes/building_blocks/polished_cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/weathered_copper_tile_slab_from_weathered_copper_tiles_stonecutting" | "minecraft:recipes/decorations/nether_brick_wall" | "ae2:recipes/misc/network/cables/covered_pink" | "createdeco:recipes/building_blocks/cracked_pearl_bricks_from_pearl_bricks_smelting" | "createdeco:recipes/building_blocks/long_umber_bricks_from_umber_bricks_stonecutting" | "minecraft:recipes/misc/ward_armor_trim_smithing_template" | "spelunkery:spelunkery/nephrite_chunk" | "design_decor:recipes/building_blocks/dripstone_castel_bricks_from_stone_types_dripstone_stonecutting" | "tconstruct:recipes/decorations/tables/crafting_station" | "create:recipes/misc/crafting/appliances/linked_controller" | "minecraft:recipes/misc/copper_ingot_from_smelting_deepslate_copper_ore" | "securitycraft:recipes/misc/reinforced_birch_fence" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_slashed_locometal" | "create:recipes/building_blocks/cut_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "create_dd:recipes/create_dd.palettes/raw_padded_mosaic_rubber_from_raw_rubber_decor_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal" | "minecraft:recipes/misc/gold_ingot_from_smelting_deepslate_gold_ore" | "alexscaves:alexscaves/dreadbow" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "ae2:recipes/misc/shaped/stairs/quartz_block" | "create:compacting" | "framedblocks:recipes/building_blocks/framed_flat_elev_double_slope_slab_corner" | "minecraft:recipes/redstone/redstone_from_blasting_deepslate_redstone_ore" | "create:recipes/misc/crafting/kinetics/radial_chassis" | "ae2:recipes/misc/tools/certus_quartz_hoe" | "smallships:recipes/transportation/jungle_galley" | "securitycraft:recipes/building_blocks/reinforced_sandstone_stairs" | "tconstruct:recipes/building_blocks/world/wood/enderbark/stripped_log_to_wood" | "create_dd:recipes/create_dd.palettes/yellow_padded_mosaic_rubber_from_yellow_rubber_decor_stonecutting" | "securitycraft:recipes/misc/camera_monitor" | "create:recipes/building_blocks/small_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_bricks_from_blue_bricks_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_blasting_copper_ore" | "minecraft:recipes/building_blocks/dye_green_carpet" | "alexscaves:alexscaves/deepsight" | "create_dd:recipes/create_dd.palettes/small_gabbro_bricks_from_stone_types_gabbro_stonecutting" | "design_decor:recipes/building_blocks/diorite_castel_tile_stairs_from_stone_types_diorite_stonecutting" | "design_decor:recipes/building_blocks/green_metal_sheet_from_metal_plate_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_stairs_from_reinforced_blackstone_stonecutting" | "design_decor:recipes/building_blocks/ochrum_castel_brick_slab_from_stone_types_ochrum_stonecutting" | "ae2:recipes/misc/network/cells/item_storage_cell_16k" | "smallships:recipes/transportation/dark_oak_galley" | "createdeco:recipes/decorations/brass_catwalk_forge" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_smokebox" | "securitycraft:recipes/misc/magenta_lens" | "create:recipes/misc/smelting/nickel_ingot_compat_thermal" | "createdeco:recipes/decorations/brass_support_wedge" | "minecraft:recipes/building_blocks/prismarine_brick_slab" | "chipped:recipes/loom_table" | "spelunkery:recipes/cinnabar_shard" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/magenta_dye_from_blue_red_white_dye" | "sophisticatedstorage:recipes/misc/light_gray_shulker_box_to_sophisticated" | "minecraft:recipes/building_blocks/purple_concrete_powder" | "storagedelight:recipes/decorations/acacia_single_door_cabinet" | "design_decor:recipes/building_blocks/crimsite_castel_brick_slab_from_stone_types_crimsite_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/cyan_padded_rubber_from_cyan_padded_rubber" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "createdeco:recipes/building_blocks/tiled_pearl_bricks_from_pearl_bricks_stonecutting" | "securitycraft:recipes/redstone/reinforced_dropper" | "create_dd:recipes/create_dd.palettes/crafting/decor/magenta_padded_rubber_from_magenta_padded_rubber" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_stairs_from_reinforced_stone_stonecutting" | "framedblocks:recipes/building_blocks/framed_double_half_stairs" | "minecraft:recipes/redstone/cherry_door" | "securitycraft:recipes/building_blocks/reinforced_lime_wool" | "sophisticatedstorage:recipes/misc/backpack_stack_downgrade_tier_3_from_storage_stack_downgrade_tier_3" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/cut_copper_stairs" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_slab_recycling" | "minecraft:recipes/misc/storage_input_from_io" | "storagedrawers:recipes/storagedrawers/keyring" | "superbwarfare:recipes/combat/medical_kit" | "create:recipes/misc/crafting/kinetics/sticky_mechanical_piston" | "create_dd:recipes/create_dd.palettes/small_netherrack_brick_slab_from_stone_types_netherrack_stonecutting" | "create:recipes/building_blocks/exposed_copper_shingle_slab_from_exposed_copper_shingles_stonecutting" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_4" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_dusk_brick_slab_stonecutting" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_3" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_2" | "securitycraft:recipes/misc/sc_manual" | "tconstruct:tools/make_part" | "alexscaves:alexscaves/deep_one_items" | "sophisticatedstorage:recipes/misc/limited_netherite_barrel_1" | "superbwarfare:recipes/combat/mosin_nagant_smithing" | "create:recipes/building_blocks/cut_scoria_wall_from_stone_types_scoria_stonecutting" | "farmersdelight:recipes/decorations/rope" | "create_connected:overpowered_brake_0" | "create:recipes/building_blocks/cut_dripstone_wall" | "design_decor:recipes/building_blocks/cyan_metal_sheet_from_metal_plate_stonecutting" | "create:recipes/misc/crafting/appliances/attribute_filter_clear" | "ae2:recipes/misc/tools/nether_quartz_hoe" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_umber_brick_stairs_stonecutting" | "minecraft:recipes/combat/spectral_arrow" | "minecraft:recipes/decorations/white_stained_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_plated_locometal" | "railways:recipes/misc/crafting/wooden_headstock_link_and_pin" | "create_dd:recipes/create_dd.palettes/small_gabbro_brick_slab_from_stone_types_gabbro_stonecutting" | "tconstruct:recipes/redstone/smeltery/scorched/ingot_tank" | "minecraft:recipes/decorations/ender_chest" | "railways:recipes/misc/crafting/palettes/wrapping/blue_brass_wrapped_locometal" | "minecraft:recipes/decorations/dark_oak_sign" | "framedblocks:recipes/building_blocks/framed_fancy_activator_rail" | "createdeco:recipes/decorations/decal_radioactive" | "create:recipes/misc/crafting/materials/experience_block" | "framedblocks:recipes/building_blocks/framed_flat_slope_panel_corner_rotate_to_framed_flat_slope_slab_corner" | "createdeco:recipes/building_blocks/dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_short_scarlet_brick_slab_stonecutting" | "create:recipes/building_blocks/veridium_pillar_from_stone_types_veridium_stonecutting" | "createdeco:recipes/decorations/brass_support" | "minecraft:story/mine_diamond" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_cut_copper_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_long_red_brick_slab_stonecutting" | "securitycraft:recipes/misc/redstone_module" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_pillar" | "tconstruct:recipes/decorations/tables/part_chest" | "create:belt" | "design_decor:recipes/building_blocks/scorchia_castel_brick_slab_from_stone_types_scorchia_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_gabbro_brick_stairs" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_wall" | "createdeco:recipes/building_blocks/mossy_dean_brick_slab_from_mossy_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_bricks_from_short_scarlet_bricks_stonecutting" | "alexscaves:alexscaves/defeat_big_dinosaur" | "securitycraft:recipes/decorations/reinforced_light_gray_stained_glass_pane" | "ae2:recipes/misc/network/blocks/energy_vibration_chamber" | "createbigcannons:recipes/misc/solid_shot" | "securitycraft:recipes/building_blocks/reinforced_blue_wool" | "minecraft:recipes/misc/pink_dye_from_peony" | "dragnvehicles:recipes/misc/classic" | "interiors:recipes/building_blocks/crafting/floor_chair/white_floor_chair_from_other_floor_chair" | "create:recipes/misc/crafting/kinetics/goggles" | "sophisticatedbackpacks:recipes/misc/iron_backpack_from_copper" | "create:recipes/misc/crafting/materials/andesite_alloy_from_block" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_slab" | "minecraft:recipes/misc/coal_from_smelting_coal_ore" | "create:recipes/misc/crafting/kinetics/copper_door" | "minecraft:nether/find_fortress" | "createdeco:recipes/building_blocks/mossy_red_bricks_from_vine" | "farmersdelight:recipes/building_blocks/organic_compost_from_tree_bark" | "create_dd:recipes/create_dd.palettes/cut_stone_wall_from_stone_types_stone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_bricks" | "smallships:recipes/transportation/spruce_drakkar" | "securitycraft:recipes/decorations/reinforced_brown_carpet" | "ae2:recipes/misc/network/cables/smart_light_blue" | "spelunkery:recipes/emerald" | "tfmg:recipes/decorations/lead_ladder_from_ingots_lead_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_slashed_locometal" | "framedblocks:recipes/building_blocks/framed_ext_inner_corner_slope_panel" | "minecraft:recipes/decorations/red_sandstone_wall" | "design_decor:recipes/building_blocks/blue_metal_sheet_stairs_from_metal_plate_stonecutting" | "farmersdelight:recipes/food/rice_from_bag" | "createdeco:recipes/building_blocks/short_blue_brick_stairs" | "interiors:recipes/building_blocks/crafting/chair/green_chair_from_floor_chair" | "create:recipes/building_blocks/cut_scorchia_brick_wall" | "casinocraft:recipes/decorations/wool_orange" | "minecraft:recipes/tools/stone_shovel" | "ae2:recipes/misc/materials/annihilationcore" | "createdeco:recipes/decorations/magenta_placard_from_dyeing" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_scarlet_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/small_gabbro_brick_slab" | "createdeco:recipes/building_blocks/mossy_dean_brick_slab" | "create:lava_wheel_00000" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_pickaxe" | "alexscaves:alexscaves/shadow_silk" | "create_dd:recipes/create_dd.palettes/small_stone_brick_stairs" | "create:recipes/misc/blasting/ingot_lead_compat_immersiveengineering" | "create:recipes/misc/crafting/kinetics/whisk" | "minecraft:recipes/building_blocks/brown_terracotta" | "tconstruct:recipes/decorations/gadgets/punji" | "create:recipes/misc/crafting/kinetics/display_board" | "create_dd:recipes/create_dd.palettes/polished_cut_weathered_limestone_wall_from_stone_types_weathered_limestone_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_ingot_from_nuggets" | "spelunkery:recipes/rough_emerald" | "minecraft:recipes/building_blocks/polished_basalt" | "minecraft:recipes/building_blocks/oak_wood" | "minecraft:recipes/building_blocks/smooth_quartz_stairs" | "minecraft:recipes/misc/slime_ball" | "create:recipes/misc/smelting/ingot_aluminium_compat_ic2" | "dragnvehicles:recipes/misc/truck_body" | "superbwarfare:recipes/combat/aa_12_smithing" | "design_decor:recipes/building_blocks/limestone_castel_brick_slab_from_stone_types_limestone_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_bricks_from_long_dean_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/small_gabbro_brick_stairs_from_stone_types_gabbro_stonecutting" | "createdeco:recipes/decorations/industrial_iron_coin" | "ae2:recipes/misc/blasting/sky_stone_block" | "create:recipes/building_blocks/polished_cut_calcite_slab_recycling" | "minecraft:recipes/building_blocks/dye_green_wool" | "minecraft:recipes/decorations/cherry_hanging_sign" | "ae2:recipes/misc/network/crafting/molecular_assembler" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_short_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/jungle_slab" | "create:recipes/building_blocks/polished_cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "spelunkery:spelunkery/soulbound" | "securitycraft:recipes/building_blocks/reinforced_coarse_dirt" | "minecraft:recipes/decorations/light_blue_candle" | "interiors:recipes/building_blocks/crafting/chair/magenta_chair_from_floor_chair" | "create:recipes/misc/smelting/ingot_tin_compat_ic2" | "ae2:recipes/misc/network/crafting/4k_cpu_crafting_storage" | "createdeco:recipes/building_blocks/tiled_red_brick_slab" | "advancedperipherals:nbt_toolkit" | "create:recipes/building_blocks/framed_glass_pane" | "createdeco:recipes/decorations/zinc_sheet_metal" | "create:recipes/building_blocks/polished_cut_asurine_slab_recycling" | "create:recipes/building_blocks/polished_cut_scoria_wall" | "design_decor:recipes/building_blocks/crimsite_castel_tile_wall_from_stone_types_crimsite_stonecutting" | "crusty_chunks:explosives" | "brewery:recipes/breathalyzer" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_riveted_locometal" | "minecraft:recipes/food/cooked_beef" | "sophisticatedstorage:recipes/misc/jungle_chest_from_quark_jungle_chest" | "create_dd:recipes/create_dd.palettes/cut_netherrack_from_stone_types_netherrack_stonecutting" | "tconstruct:recipes/building_blocks/common/glass/orange_clear_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "interiors:recipes/building_blocks/crafting/floor_chair/yellow_floor_chair_from_other_floor_chair" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper_stairs" | "superbwarfare:recipes/misc/iron_action" | "securitycraft:recipes/tools/universal_block_remover" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_smoking" | "interiors:recipes/building_blocks/crafting/floor_chair/brown_floor_chair" | "minecraft:recipes/decorations/red_bed" | "createdeco:recipes/decorations/light_blue_placard_from_dyeing" | "create_connected:recipes/crafting/palettes/cherry_window" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/piston_extension_pole" | "minecraft:recipes/redstone/heavy_weighted_pressure_plate" | "createdeco:recipes/building_blocks/cracked_red_brick_stairs" | "spelunkery:recipes/inkcap_mushroom" | "tconstruct:recipes/building_blocks/common/slime/sky/crystal_block" | "numismatics:recipes/misc/crafting/gray_id_card" | "farmersdelight:main/harvest_ropelogged_tomato" | "cgs:recipes/misc/lead_ingot_from_blasting_lead_ore" | "minecraft:recipes/transportation/warped_fungus_on_a_stick" | "alexscaves:alexscaves/jelly_bean" | "createdeco:recipes/building_blocks/long_dusk_brick_slab_from_long_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_dean_bricks_from_short_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_jungle_wood" | "create:recipes/building_blocks/polished_cut_calcite_from_stone_types_calcite_stonecutting" | "tconstruct:recipes/misc/common/materials/cobalt_block_from_ingots" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_bricks_from_reinforced_crystal_quartz_block_stonecutting" | "create:recipes/building_blocks/oak_window_pane" | "copycats:recipes/crafting/copycat_iron_door" | "create:recipes/building_blocks/spruce_window_pane" | "create:recipes/building_blocks/small_diorite_brick_slab" | "design_decor:recipes/building_blocks/black_metal_sheet_from_metal_plate_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_advanced_jukebox_upgrade_from_storage_advanced_jukebox_upgrade" | "ae2:recipes/misc/shaped/walls/quartz_pillar" | "securitycraft:recipes/transportation/jungle_security_sea_boat" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal_boiler" | "create_dd:recipes/create_dd.palettes/dark_metal_bricks_from_dark_metal_decor_stonecutting" | "ae2:recipes/misc/network/blocks/crank" | "minecraft:recipes/building_blocks/bone_block" | "sophisticatedbackpacks:recipes/misc/advanced_restock_upgrade" | "framedblocks:recipes/building_blocks/framed_iron_gate" | "design_decor:recipes/building_blocks/lime_metal_plate_stairs_from_metal_plate_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_lilac" | "farmersdelight:recipes/food/fried_egg_from_smoking" | "create_dd:recipes/create_dd.palettes/layered_stone_from_stone_types_stone_stonecutting" | "create:recipes/misc/crafting/materials/zinc_ingot_from_decompacting" | "farmersdelight:recipes/food/nether_salad" | "securitycraft:recipes/building_blocks/reinforced_stone_stairs" | "interiors:recipes/building_blocks/crafting/chair/green_chair_from_seat" | "ae2:recipes/misc/block_cutter/stairs/quartz_pillar_stairs" | "farmersdelight:recipes/decorations/half_tatami_mat" | "create_dd:recipes/create_dd.palettes/layered_dolomite_from_stone_types_dolomite_stonecutting" | "tconstruct:recipes/brewing/common/slime/magma_cream" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_freezing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/small_blackstone_bricks_from_stone_types_blackstone_stonecutting" | "minecraft:recipes/misc/melon_seeds" | "minecraft:recipes/building_blocks/magma_block" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_long_dean_brick_slab_stonecutting" | "farmersdelight:recipes/combat/diamond_knife" | "securitycraft:recipes/building_blocks/reinforced_diorite_stairs_from_reinforced_diorite_stonecutting" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_shovel" | "farmersdelight:recipes/misc/iron_nugget_from_blasting_knife" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_short_dean_bricks_stonecutting" | "create_dd:recipes/misc/crafting/diamond_from_diamond_shard" | "copycats:recipes/crafting/copycat_block" | "securitycraft:recipes/building_blocks/reinforced_cut_copper_stairs_from_reinforced_copper_block_stonecutting" | "minecraft:recipes/building_blocks/smooth_quartz_slab_from_smooth_quartz_stonecutting" | "create:recipes/building_blocks/cut_scoria_brick_slab_recycling" | "tconstruct:recipes/combat/tools/armor/travelers_goggles" | "minecraft:recipes/food/cake" | "vinery:recipes/stripped_dark_cherry_wood" | "minecraft:recipes/combat/iron_leggings" | "create:recipes/misc/crafting/kinetics/mechanical_crafter" | "securitycraft:recipes/building_blocks/gravel_mine" | "framedblocks:recipes/building_blocks/framed_masonry_corner" | "securitycraft:recipes/decorations/reinforced_green_stained_glass_pane" | "create:recipes/building_blocks/cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "minecraft:recipes/decorations/gray_bed" | "securitycraft:recipes/decorations/reinforced_white_carpet" | "minecraft:recipes/misc/emerald_from_smelting_emerald_ore" | "minecraft:recipes/building_blocks/coarse_dirt" | "design_decor:recipes/building_blocks/brown_metal_plate_wall_from_metal_plate_stonecutting" | "farmersdelight:recipes/food/milk_bottle" | "interiors:recipes/building_blocks/crafting/chair/light_blue_chair" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_dusk_brick_stairs_stonecutting" | "farmersdelight:recipes/food/bread_from_smelting" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_wall_from_reinforced_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/light_gray_concrete_powder" | "createdeco:recipes/building_blocks/cracked_scarlet_brick_stairs" | "create:recipes/building_blocks/small_diorite_brick_wall" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_verdant_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_riveted_locometal" | "createdeco:recipes/building_blocks/blue_brick_stairs" | "securitycraft:recipes/building_blocks/reinforced_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_riveted_locometal" | "framedblocks:recipes/building_blocks/framed_flat_ext_inner_slope_panel_corner_rotate_to_framed_flat_elev_inner_slope_slab_corner" | "casinocraft:recipes/decorations/wool_red" | "minecraft:recipes/combat/leather_leggings" | "copycats:recipes/crafting/copycat_vertical_step_from_conversion" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_smelting" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_riveted_locometal" | "superbwarfare:recipes/misc/k_98_blueprint" | "farmersdelight:recipes/building_blocks/straw_bale" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal_boiler" | "alexscaves:alexscaves/discover_dinosaur" | "smallships:recipes/transportation/oak_brigg" | "framedblocks:recipes/building_blocks/framed_flower_pot" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_pearl_brick_slab_stonecutting" | "minecraft:recipes/redstone/crimson_button" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "tconstruct:recipes/decorations/common/glass/pink_clear_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_veridium_wall_from_stone_types_veridium_stonecutting" | "framedblocks:recipes/building_blocks/framed_adj_double_panel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal_boiler" | "securitycraft:recipes/building_blocks/reinforced_lime_terracotta" | "sophisticatedstorage:recipes/misc/shulker_from_chest" | "createdeco:recipes/building_blocks/long_blue_bricks_from_blue_bricks_stonecutting" | "minecraft:recipes/combat/diamond_leggings" | "securitycraft:recipes/decorations/reinforced_light_gray_carpet" | "railways:recipes/misc/stonecutting/palettes/cycling/black_slashed_locometal" | "alexscaves:alexscaves/discover_underzealot" | "create:recipes/building_blocks/cut_galena_brick_slab_recycling" | "create_dd:recipes/create_dd.base/crafting/fan_catalyst/haunting_sail" | "create:recipes/misc/smelting/gold_ingot_from_crushed" | "create:hose_pulley_lava" | "framedblocks:recipes/building_blocks/framed_panel_rotate_to_framed_slab" | "interiors:recipes/building_blocks/crafting/chair/light_gray_chair_from_other_chair" | "sophisticatedstorage:recipes/misc/basic_tier_upgrade" | "farmersdelight:recipes/cooking/fish_stew" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_1" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_2" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_3" | "sophisticatedstorage:recipes/misc/limited_iron_barrel_4" | "tconstruct:recipes/redstone/world/wood/bloodshroom/button" | "tconstruct:recipes/building_blocks/world/wood/skyroot/stripped_log_to_wood" | "interiors:recipes/building_blocks/crafting/floor_chair/lime_floor_chair" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_pillar" | "storagedelight:recipes/decorations/glass_mangrove_cabinet" | "minecraft:recipes/building_blocks/cherry_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "ae2:recipes/misc/network/cables/smart_white" | "create:recipes/building_blocks/small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "tconstruct:recipes/misc/common/materials/amethyst_bronze_nugget_from_ingot" | "sophisticatedbackpacks:recipes/misc/everlasting_upgrade" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_wall_from_reinforced_blackstone_stonecutting" | "minecraft:end/kill_dragon" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs" | "securitycraft:recipes/building_blocks/reinforced_smooth_crystal_quartz" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/scoria" | "railways:recipes/misc/crafting/fuel_tank" | "minecraft:recipes/decorations/stone_brick_wall" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper" | "minecraft:recipes/redstone/dark_oak_fence_gate" | "framedblocks:recipes/building_blocks/framed_double_half_slope" | "minecraft:recipes/decorations/prismarine_wall_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/dye_light_gray_bed" | "createdeco:recipes/decorations/andesite_sheet_metal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_brick" | "design_decor:recipes/building_blocks/green_metal_plate_slab_from_metal_plate_stonecutting" | "create:recipes/building_blocks/copper_shingle_slab" | "securitycraft:recipes/misc/orange_lens" | "storagedelight:recipes/decorations/spruce_drawer_with_door" | "farmersdelight:recipes/misc/milk_bucket_from_bottles" | "minecraft:recipes/misc/blue_dye" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "copycats:recipes/crafting/copycat_slab" | "computercraft:recipes/redstone/turtle_normal_overlays/turtle_rainbow_overlay" | "design_decor:recipes/building_blocks/granite_castel_brick_stairs_from_stone_types_granite_stonecutting" | "createdeco:recipes/building_blocks/umber_bricks_from_tiled_umber_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/analog_lever" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_pillar" | "casinocraft:recipes/decorations/wool_light_gray" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_slab_from_reinforced_blackstone_stonecutting" | "minecraft:recipes/misc/cyan_dye" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_stairs" | "tconstruct:recipes/redstone/smeltery/scorched/drain_retextured" | "design_decor:recipes/building_blocks/white_metal_plate_stairs_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cut_copper_from_reinforced_copper_block_stonecutting" | "create_connected:recipes/crafting/palettes/copycat_stairs_compat" | "securitycraft:recipes/building_blocks/reinforced_mud_brick_stairs" | "storagedelight:recipes/decorations/acacia_bookshelf_with_door" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_brick_wall_from_reinforced_mossy_stone_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_long_pearl_bricks_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "create:recipes/misc/blasting/silver_ingot_compat_thermal" | "petrolpark:badge/competition_winner" | "computercraft:recipes/redstone/computer_command" | "securitycraft:recipes/tools/universal_key_changer" | "minecraft:nether/create_beacon" | "ae2:recipes/misc/network/blocks/spatial_io_port" | "create_dd:recipes/create_dd.palettes/cut_dolomite_slab_from_stone_types_dolomite_stonecutting" | "minecraft:recipes/building_blocks/crimson_stairs" | "copycats:recipes/crafting/copycat_catwalk" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_slashed_locometal" | "minecraft:recipes/building_blocks/bamboo_mosaic_slab" | "minecraft:recipes/decorations/yellow_glazed_terracotta" | "securitycraft:recipes/building_blocks/deepslate_redstone_mine" | "securitycraft:recipes/decorations/glow_display_case" | "railways:recipes/misc/stonecutting/palettes/cycling/white_riveted_locometal" | "ae2:recipes/misc/shaped/walls/smooth_quartz_block" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_4" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_3" | "create:recipes/misc/crafting/logistics/redstone_link" | "numismatics:recipes/misc/crafting/red_card" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_2" | "storagedelight:recipes/decorations/spruce_single_door_cabinet" | "sophisticatedstorage:recipes/misc/birch_limited_barrel_1" | "ae2:recipes/misc/network/parts/storage_bus" | "sophisticatedbackpacks:recipes/misc/auto_smelting_upgrade" | "ae2:recipes/misc/block_cutter/slabs/chiseled_quartz_slab" | "create_dd:recipes/create_dd.palettes/crafting/decor/gray_asphalt_block" | "tfmg:recipes/decorations/cast_iron_ladder_from_ingots_cast_iron_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_long_umber_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/cart_assembler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_pillar" | "create_dd:recipes/create_dd.palettes/light_blue_padded_tiled_rubber_from_light_blue_rubber_decor_stonecutting" | "design_decor:recipes/building_blocks/brown_metal_plate_stairs_from_metal_plate_stonecutting" | "alexscaves:alexscaves/tree_star" | "create:recipes/building_blocks/exposed_copper_shingle_stairs_from_exposed_copper_shingles_stonecutting" | "alexscaves:alexscaves/mystery_cave_painting" | "create:recipes/misc/crafting/kinetics/controller_rail" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_blackstone_stonecutting" | "advancedperipherals:recipes/redstone/computer_tool" | "create:recipes/building_blocks/small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/redstone/dark_oak_trapdoor" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_tiled_pearl_brick_stairs_stonecutting" | "create:recipes/building_blocks/tiled_glass_pane" | "securitycraft:recipes/building_blocks/reinforced_red_nether_brick_stairs_from_reinforced_red_nether_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/packing_tape" | "createdeco:recipes/decorations/green_brass_lamp" | "superbwarfare:main/common_blueprint" | "design_decor:recipes/building_blocks/scoria_castel_tile_wall_from_stone_types_scoria_stonecutting" | "smallships:recipes/combat/cannon" | "securitycraft:recipes/building_blocks/reinforced_tinted_glass" | "create_dd:recipes/create_dd.palettes/small_basalt_brick_slab_from_stone_types_basalt_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_riveted_locometal" | "createdeco:recipes/decorations/industrial_iron_coinstack" | "storagedelight:recipes/decorations/glass_bamboo_cabinet" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_plated_locometal" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/book" | "create:recipes/building_blocks/small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_seething" | "create:recipes/building_blocks/crafting/kinetics/brown_seat" | "farmersdelight:recipes/decorations/blue_canvas_sign" | "spelunkery:recipes/emerald_shard" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "minecraft:recipes/misc/dune_armor_trim_smithing_template_smithing_trim" | "createdeco:recipes/building_blocks/tiled_blue_brick_slab_from_long_blue_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_slab" | "minecraft:recipes/building_blocks/brown_stained_glass" | "alexscaves:alexscaves/magnet" | "ae2:recipes/misc/block_cutter/walls/smooth_sky_stone_wall" | "minecraft:recipes/decorations/brown_carpet" | "createdeco:recipes/decorations/zinc_ladder_from_stonecutting" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs_from_long_dean_brick_stairs_stonecutting" | "minecraft:recipes/combat/netherite_sword_smithing" | "interiors:recipes/building_blocks/crafting/chair/gray_chair" | "securitycraft:recipes/building_blocks/reinforced_chiseled_polished_blackstone_from_reinforced_blackstone_stonecutting" | "securitycraft:recipes/building_blocks/emerald_mine" | "create:pulley_maxed" | "railways:recipes/misc/crafting/palettes/wrapping/red_brass_wrapped_locometal" | "create:recipes/building_blocks/veridium_from_stone_types_veridium_stonecutting" | "securitycraft:recipes/decorations/secret_jungle_sign_item" | "securitycraft:recipes/redstone/secure_redstone_interface" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal" | "storagedelight:recipes/decorations/jungle_drawer_with_door" | "createdeco:recipes/building_blocks/short_red_brick_slab_from_tiled_red_brick_slab_stonecutting" | "minecraft:recipes/misc/diamond" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal" | "minecraft:recipes/food/cooked_chicken" | "create:recipes/building_blocks/small_veridium_bricks_from_stone_types_veridium_stonecutting" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k_storage" | "create:chocolate_bucket" | "create:recipes/building_blocks/asurine_from_stone_types_asurine_stonecutting" | "tconstruct:tools/modified" | "create:recipes/building_blocks/cut_deepslate_wall" | "create:recipes/building_blocks/small_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "create:recipes/misc/crafting/kinetics/mysterious_cuckoo_clock" | "createdeco:recipes/building_blocks/short_red_brick_stairs" | "create_dd:recipes/create_dd.palettes/weathered_limestone_from_stone_types_weathered_limestone_stonecutting" | "tconstruct:recipes/misc/smeltery/red_sand_cast" | "create:recipes/building_blocks/cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "create_dd:recipes/create_dd.palettes/yellow_padded_rubber_slab_from_yellow_rubber_decor_stonecutting" | "create:recipes/building_blocks/cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "superbwarfare:main/boomstick_melee" | "create:recipes/building_blocks/small_andesite_brick_stairs" | "ae2:recipes/misc/block_cutter/slabs/fluix_slab" | "createbigcannons:recipes/misc/cannon_mount_extension" | "framedblocks:recipes/building_blocks/framed_inv_double_slope_panel" | "securitycraft:recipes/building_blocks/reinforced_cut_copper_slab_from_reinforced_copper_block_stonecutting" | "minecraft:recipes/building_blocks/brown_concrete_powder" | "create_enchantment_industry:relic_restoration" | "alexscaves:alexscaves/abyssal_bucket" | "minecraft:end/levitate" | "create:recipes/misc/blasting/tin_ingot_compat_thermal" | "superbwarfare:recipes/combat/trachelium_smithing" | "sophisticatedstorage:recipes/misc/stack_upgrade_omega_tier" | "framedblocks:recipes/building_blocks/framed_detector_rail_slope" | "create_dd:recipes/create_dd.palettes/brown_padded_rubber_stairs_from_brown_rubber_decor_stonecutting" | "framedblocks:recipes/building_blocks/framed_collapsible_block" | "ae2:recipes/misc/decorative/certus_quartz_pillar_from_stonecutting" | "ae2:recipes/misc/materials/cardcrafting" | "minecraft:recipes/building_blocks/cracked_stone_bricks" | "design_decor:recipes/building_blocks/asurine_castel_brick_stairs_from_stone_types_asurine_stonecutting" | "framedblocks:recipes/building_blocks/framed_sliced_stairs_panel" | "farmersdelight:recipes/combat/flint_knife" | "farmersdelight:main/plant_rice" | "createdeco:recipes/decorations/industrial_iron_catwalk_railing_from_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_short_verdant_brick_stairs_stonecutting" | "design_decor:recipes/building_blocks/light_blue_metal_plate_stairs_from_metal_plate_stonecutting" | "design_decor:recipes/building_blocks/light_blue_metal_sheet_wall_from_metal_plate_stonecutting" | "framedblocks:recipes/building_blocks/framed_chest" | "create:recipes/building_blocks/small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_dripstone_brick_wall" | "createdeco:recipes/decorations/white_shipping_container_from_dyeing_vaults" | "securitycraft:recipes/building_blocks/reinforced_smooth_quartz_slab_from_reinforced_smooth_quartz_stonecutting" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_bricks_stonecutting" | "securitycraft:recipes/misc/block_pocket_wall" | "superbwarfare:recipes/misc/sentinel_blueprint" | "farmersdelight:recipes/decorations/black_canvas_sign" | "tconstruct:recipes/combat/tools/armor/travelers_shield" | "sophisticatedstorage:recipes/misc/advanced_compacting_upgrade" | "createdeco:recipes/decorations/brass_hull_from_stonecutting" | "create:recipes/misc/crafting/kinetics/track_station" | "minecraft:recipes/building_blocks/light_blue_concrete_powder" | "create:recipes/building_blocks/cut_diorite_wall" | "securitycraft:recipes/misc/disguise_module" | "alexscaves:alexscaves/frostmint_spear" | "create_dd:recipes/create_dd.palettes/orange_padded_rubber_slab_from_orange_rubber_decor_stonecutting" | "create_dd:recipes/create_dd.palettes/small_netherrack_brick_stairs" | "tfmg:recipes/building_blocks/cinderblock_from_concrete_stonecutting" | "storagedrawers:recipes/storagedrawers/detached_drawer" | "minecraft:recipes/building_blocks/glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal_boiler" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_1" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_2" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_3" | "sophisticatedstorage:recipes/misc/limited_gold_barrel_4" | "farmersdelight:recipes/building_blocks/tatami" | "createbigcannons:recipes/misc/cannon_drill" | "securitycraft:recipes/transportation/spruce_security_sea_boat" | "design_decor:recipes/building_blocks/deepslate_castel_tile_stairs_from_stone_types_deepslate_stonecutting" | "create_connected:root" | "ae2:recipes/misc/network/cables/dense_smart_red" | "ae2:main/fluix" | "minecraft:recipes/transportation/minecart" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_brick_stairs" | "create:andesite_casing" | "create:recipes/building_blocks/crafting/kinetics/gray_seat" | "ae2:recipes/misc/network/cables/covered_black" | "tconstruct:recipes/food/gadgets/cake/blood" | "minecraft:recipes/tools/iron_hoe" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "farmersdelight:recipes/misc/iron_nugget_from_smelting_knife" | "casinocraft:recipes/decorations/wool_purple" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_starter_tier_from_storage_stack_upgrade_tier_1_plus" | "tconstruct:recipes/building_blocks/common/glass/pink_clear_stained_glass" | "create_dd:recipes/create_dd.base/crafting/kinetics/redstone_divider" | "minecraft:recipes/misc/bowl" | "create:recipes/building_blocks/polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "sophisticatedstorage:recipes/misc/auto_blasting_upgrade" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_slab_from_stone_types_weathered_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_riveted_locometal" | "minecraft:recipes/building_blocks/dye_orange_carpet" | "ae2:recipes/misc/tools/nether_quartz_sword" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_crafting" | "create:recipes/building_blocks/crafting/kinetics/white_seat_from_other_seat" | "design_decor:recipes/building_blocks/scorchia_castel_tiles_from_stone_types_scorchia_stonecutting" | "farmersdelight:recipes/food/cooked_mutton_chops" | "farmersdelight:recipes/food/honey_cookie" | "minecraft:recipes/tools/clock" | "tconstruct:foundry/blaze" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/dark_metal_block_stairs_from_dark_metal_block_stairs" | "ae2:recipes/misc/network/cells/item_storage_cell_4k_storage" | "createdeco:recipes/building_blocks/short_umber_bricks_from_umber_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/lime_padded_rubber_slab_from_lime_rubber_decor_stonecutting" | "minecraft:recipes/decorations/red_glazed_terracotta" | "minecraft:adventure/whos_the_pillager_now" | "create:recipes/building_blocks/small_asurine_bricks_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/food/baked_potato" | "sophisticatedstorage:recipes/misc/storage_void_upgrade_from_backpack_void_upgrade" | "storagedelight:recipes/decorations/mangrove_drawer" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_pillar" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_tiled_scarlet_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_riveted_locometal" | "spelunkery:recipes/white_inkcap_mushroom" | "vinery:recipes/dark_oak_wine_rack_small" | "minecraft:recipes/decorations/green_banner" | "storagedelight:recipes/decorations/glass_cherry_cabinet" | "create:recipes/misc/smelting/silver_ingot_compat_oreganized" | "storagedelight:recipes/decorations/birch_drawer" | "minecraft:recipes/misc/gold_ingot_from_nuggets" | "sophisticatedstorage:recipes/misc/gold_shulker_box" | "tconstruct:recipes/building_blocks/common/glass/white_clear_stained_glass" | "design_decor:recipes/building_blocks/magenta_metal_sheet_slab_from_metal_plate_stonecutting" | "sophisticatedstorage:recipes/misc/storage_link" | "comforts:hammock_gray" | "securitycraft:recipes/building_blocks/reinforced_chiseled_bookshelf" | "create:recipes/building_blocks/cut_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "createdeco:recipes/decorations/gray_shipping_container_from_dyeing_vaults" | "securitycraft:recipes/building_blocks/reinforced_polished_granite" | "create:recipes/building_blocks/polished_cut_crimsite_from_stone_types_crimsite_stonecutting" | "create_connected:recipes/crafting/kinetics/six_way_gearbox_from_conversion" | "create:recipes/building_blocks/cut_deepslate_brick_wall" | "design_decor:recipes/building_blocks/yellow_metal_sheet_slab_from_metal_plate_stonecutting" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template" | "create:recipes/building_blocks/layered_granite_from_stone_types_granite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_magenta_wool" | "railways:recipes/misc/crafting/track_coupler" | "alexscaves:alexscaves/serene_salad" | "sophisticatedstorage:recipes/misc/pickup_upgrade" | "storagedrawers:recipes/storagedrawers/personal_key" | "createdeco:recipes/misc/netherite_nugget_from_netherite_ingot" | "create:anvil_plough" | "ae2:main/ioport" | "tfmg:recipes/decorations/lead_bars_from_ingots_lead_stonecutting" | "createdeco:recipes/building_blocks/cracked_blue_bricks_from_blue_bricks_smelting" | "minecraft:recipes/building_blocks/bricks" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_fence" | "farmersdelight:recipes/cooking/noodle_soup" | "securitycraft:recipes/redstone/laser_block" | "sophisticatedstorage:recipes/misc/oak_barrel" | "minecraft:recipes/decorations/painting" | "create:stressometer" | "petrolpark:badge/content_creator" | "tconstruct:recipes/building_blocks/common/slime/ender/congealed" | "minecraft:recipes/building_blocks/waxed_cut_copper" | "copycats:recipes/crafting/copycat_stacked_half_layer" | "ae2:recipes/misc/tools/fluix_hoe" | "farmersdelight:main/hit_raider_with_rotten_tomato" | "design_decor:recipes/building_blocks/pink_metal_plate_slab_from_metal_plate_stonecutting" | "storagedelight:recipes/decorations/oak_single_door_cabinet" | "minecraft:recipes/combat/arrow" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_pillar" | "ae2:recipes/misc/network/blocks/spatial_anchor" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "tconstruct:recipes/redstone/smeltery/scorched/fuel_tank" | "sophisticatedbackpacks:recipes/misc/chipped/alchemy_bench_upgrade" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_brass_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_veridium_slab_recycling" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template_smithing_trim" | "create_dd:recipes/create_dd.palettes/green_padded_rubber_slab_from_green_rubber_decor_stonecutting" | "minecraft:recipes/redstone/acacia_trapdoor" | "design_decor:recipes/building_blocks/brown_metal_sheet_from_metal_plate_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tiles_from_honeycomb" | "tconstruct:recipes/redstone/common/glass/vanilla/daylight_detector" | "ae2:recipes/misc/network/blocks/energy_dense_energy_cell" | "create:recipes/building_blocks/polished_cut_andesite_slab" | "createdeco:recipes/building_blocks/mossy_pearl_brick_slab" | "create:train" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_long_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "minecraft:recipes/food/cooked_salmon" | "minecraft:recipes/building_blocks/cherry_stairs" | "securitycraft:recipes/building_blocks/crystal_quartz_bricks" | "storagedelight:recipes/decorations/spruce_cabinet_with_glass_doors" | "copycats:recipes/crafting/copycat_heavy_weighted_pressure_plate" | "create_connected:recipes/crafting/kinetics/encased_chain_cogwheel" | "createdeco:recipes/building_blocks/short_scarlet_bricks_from_tiled_scarlet_bricks_stonecutting" | "create:recipes/building_blocks/small_tuff_brick_stairs" | "ae2:recipes/misc/network/cables/smart_red" | "design_decor:recipes/building_blocks/scorchia_castel_bricks_from_stone_types_scorchia_stonecutting" | "tconstruct:recipes/decorations/common/glass/blue_clear_stained_glass_pane" | "spelunkery:recipes/cinnabar" | "superbwarfare:recipes/misc/annihilator_blueprint" | "create_dd:recipes/create_dd.palettes/polished_cut_dolomite_slab" | "createdeco:recipes/decorations/pink_placard_from_dyeing" | "design_decor:recipes/building_blocks/pink_metal_sheet_stairs_from_metal_plate_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/black_chair_from_floor_chair" | "create_dd:recipes/create_dd.palettes/padded_rubber_stairs_from_rubber_decor_stonecutting" | "superbwarfare:recipes/combat/m_1911_smithing" | "copycats:recipes/crafting/copycat_stone_button" | "securitycraft:recipes/building_blocks/reinforced_green_carpet_from_dye" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_slab_from_reinforced_mossy_cobblestone_stonecutting" | "design_decor:recipes/building_blocks/vertical_tinted_framed_glass_from_glass_tinted_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal_boiler" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_wall_from_reinforced_polished_blackstone_bricks_stonecutting" | "createdeco:recipes/decorations/red_iron_lamp" | "spelunkery:recipes/echo_shard" | "createdeco:recipes/building_blocks/short_scarlet_bricks_from_long_scarlet_bricks_stonecutting" | "superbwarfare:recipes/misc/netherite_trigger" | "create:recipes/building_blocks/cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_slashed_locometal" | "createdeco:recipes/building_blocks/tiled_pearl_bricks_from_short_pearl_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_black_terracotta" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_wall_stonecutter" | "createdeco:recipes/building_blocks/industrial_iron_window" | "alexscaves:alexscaves/hologram_projector" | "minecraft:recipes/building_blocks/red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/orange_seat" | "interiors:recipes/building_blocks/crafting/chair/purple_chair" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_short_red_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_blackstone_slab_from_reinforced_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_brick_wall" | "interiors:recipes/building_blocks/crafting/floor_chair/magenta_floor_chair" | "numismatics:recipes/misc/crafting/light_blue_card" | "create:recipes/building_blocks/weathered_copper_tile_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_riveted_locometal" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "minecraft:recipes/building_blocks/dye_cyan_wool" | "ae2:recipes/misc/tools/portable_item_cell_16k" | "create_dd:recipes/building_blocks/packed_mud_from_stone_types_packed_mud_stonecutting" | "minecraft:recipes/decorations/andesite_wall_from_andesite_stonecutting" | "securitycraft:recipes/building_blocks/smoker_mine" | "tconstruct:recipes/building_blocks/common/slime/earth/congealed" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_honeycomb" | "minecraft:recipes/building_blocks/nether_brick_stairs" | "design_decor:recipes/building_blocks/veridium_castel_bricks_from_stone_types_veridium_stonecutting" | "securitycraft:recipes/decorations/secret_birch_hanging_sign" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_slab" | "securitycraft:recipes/building_blocks/reinforced_red_nether_brick_stairs" | "create:recipes/building_blocks/cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "framedblocks:recipes/building_blocks/framed_post" | "createdeco:recipes/decorations/gold_coin" | "farmersdelight:recipes/cooking/vegetable_noodles" | "create_dd:recipes/create_dd.palettes/cut_dolomite_brick_wall" | "spelunkery:recipes/rough_lazurite_shard" | "tconstruct:recipes/decorations/common/copper_platform_waxing_exposed" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab" | "design_decor:recipes/building_blocks/lime_metal_plate_wall_from_metal_plate_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_brick_stairs_from_stone_types_blackstone_stonecutting" | "framedblocks:recipes/building_blocks/framed_elevated_slope_slab_rotate_to_framed_extended_slope_panel" | "tconstruct:recipes/decorations/common/firewood/blazewood_fence" | "sophisticatedstorage:recipes/misc/backpack_jukebox_upgrade_from_storage_jukebox_upgrade" | "ae2:recipes/misc/shaped/walls/quartz_block" | "numismatics:recipes/misc/crafting/green_card" | "create:brass_casing" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_4_from_backpack_stack_upgrade_tier_3" | "design_decor:recipes/building_blocks/ochrum_castel_tile_stairs_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/building_blocks/scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "copycats:recipes/crafting/copycat_corner_slice" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite_slab_from_reinforced_diorite_stonecutting" | "minecraft:recipes/tools/fishing_rod" | "createdeco:recipes/building_blocks/long_red_brick_stairs_from_long_red_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_slashed_locometal" | "computercraft:recipes/redstone/pocket_normal/computercraft/wireless_modem_advanced" | "createdeco:recipes/building_blocks/tiled_dusk_bricks_from_dusk_bricks_stonecutting" | "vinery:main/sowing_the_future" | "create:recipes/building_blocks/copper_tile_stairs_from_copper_tiles_stonecutting" | "alexscaves:alexscaves/deep_ones_become_neutral" | "create_dd:recipes/create_dd.palettes/dark_metal_block_slab_from_industrial_iron_block_stonecutting" | "minecraft:recipes/building_blocks/chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "framedblocks:recipes/building_blocks/framed_vertical_stairs_rotate_to_framed_stairs" | "framedblocks:recipes/building_blocks/framed_double_corner" | "create:recipes/building_blocks/layered_tuff_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks" | "minecraft:recipes/building_blocks/nether_brick_slab" | "create:recipes/building_blocks/cut_granite_slab" | "minecraft:recipes/misc/pumpkin_seeds" | "framedblocks:recipes/building_blocks/framed_fancy_rail_slope" | "numismatics:recipes/misc/crafting/lime_id_card" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_cut_sandstone_slab" | "create:recipes/misc/crafting/kinetics/mechanical_bearing" | "securitycraft:recipes/building_blocks/reinforced_cut_copper_stairs_from_reinforced_cut_copper_stonecutting" | "comforts:sleeping_bag_black" | "create:cross_streams" | "minecraft:recipes/decorations/mud_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/red_sandstone" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_riveted_locometal" | "overworld_netherite_ore:pieceofdebris" | "minecraft:husbandry/tadpole_in_a_bucket" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_slashed_locometal" | "minecraft:recipes/redstone/dark_oak_button" | "ae2:recipes/misc/smelting/silicon_from_certus_quartz_dust" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_stairs_from_honeycomb" | "createdeco:recipes/decorations/copper_catwalk_forge" | "securitycraft:recipes/building_blocks/reinforced_deepslate_bricks_from_reinforced_polished_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_blue_bricks_from_tiled_blue_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/copper_chest" | "spelunkery:spelunkery/every_fungus" | "design_decor:recipes/building_blocks/dripstone_castel_tile_slab_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/beehive" | "createdeco:recipes/building_blocks/blue_bricks" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_4" | "minecraft:recipes/tools/netherite_hoe_smithing" | "copycats:recipes/crafting/copycat_door" | "createdeco:recipes/building_blocks/short_verdant_bricks_from_long_verdant_bricks_stonecutting" | "minecraft:recipes/food/cooked_rabbit_from_smoking" | "createdeco:recipes/decorations/yellow_shipping_container" | "create:recipes/misc/crafting/kinetics/train_door" | "design_decor:recipes/building_blocks/black_metal_sheet_wall_from_metal_plate_stonecutting" | "framedblocks:recipes/building_blocks/framed_target" | "securitycraft:recipes/decorations/secret_mangrove_hanging_sign" | "ae2:recipes/misc/shaped/slabs/quartz_block" | "create_dd:recipes/create_dd.palettes/cut_netherrack_brick_slab_recycling" | "farmersdelight:recipes/misc/paper_from_tree_bark" | "create_dd:recipes/create_dd.palettes/blackstone_pillar_from_stone_types_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/lime_padded_rubber_from_lime_padded_rubber" | "minecraft:recipes/building_blocks/nether_wart_block" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite_slab" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/storage_stack_upgrade_tier_5_from_backpack_stack_upgrade_tier_4" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_wall_from_reinforced_polished_deepslate_stonecutting" | "storagedelight:recipes/decorations/spruce_drawer_with_books" | "create:recipes/building_blocks/cut_deepslate_slab_recycling" | "minecraft:recipes/building_blocks/dye_pink_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k_storage" | "ae2:recipes/misc/network/cables/dense_covered_black" | "vinery:recipes/dark_cherry_stairs" | "minecraft:recipes/decorations/cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/andesite_from_stone_types_andesite_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_scarlet_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_slab_from_tiled_blue_brick_slab_stonecutting" | "createdeco:recipes/decorations/decal_top_right" | "superbwarfare:main/epic_blueprint" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_bricks_from_stone_types_amethyst_block_stonecutting" | "ae2:recipes/misc/network/blocks/crystal_processing_charger" | "securitycraft:recipes/misc/reinforced_jungle_fence" | "minecraft:recipes/building_blocks/stripped_birch_wood" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_1" | "create:recipes/misc/crafting/schematics/schematic_and_quill" | "create:recipes/building_blocks/cut_andesite_from_stone_types_andesite_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_from_stone_types_blackstone_stonecutting" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_3" | "create:windmill" | "createdeco:recipes/decorations/iron_support_wedge_from_stonecutting" | "sophisticatedstorage:recipes/misc/crimson_limited_barrel_2" | "framedblocks:recipes/building_blocks/framed_inv_double_slope_panel_rotate_to_framed_inv_double_slope_slab" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "storagedelight:recipes/decorations/birch_bookshelf_with_door" | "railways:recipes/misc/stonecutting/palettes/cycling/plated_locometal" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_cyan" | "ae2:recipes/misc/shaped/stairs/chiseled_quartz_block" | "minecraft:recipes/building_blocks/prismarine_brick_stairs" | "spelunkery:recipes/coal" | "minecraft:recipes/decorations/prismarine_wall" | "create_dd:recipes/create_dd.palettes/padded_rubber_slab_from_rubber_decor_stonecutting" | "interiors:recipes/building_blocks/crafting/floor_chair/red_floor_chair" | "framedblocks:recipes/building_blocks/framed_ladder" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_slashed_locometal" | "storagedelight:recipes/decorations/acacia_cabinet_with_glass_doors" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal_boiler" | "minecraft:recipes/transportation/acacia_chest_boat" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_copper_wrapped_locometal" | "create_connected:recipes/crafting/palettes/copycat_step_from_conversion" | "create_dd:recipes/create_dd.palettes/crafting/decor/orange_blueprint_block" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_long_dusk_bricks_stonecutting" | "minecraft:recipes/decorations/white_candle" | "create_dd:recipes/create_dd.base/crafting/seething_ablaze_powder_from_seething_ablaze_rod" | "createdeco:recipes/building_blocks/verdant_bricks_from_tiled_verdant_bricks_stonecutting" | "minecraft:recipes/combat/turtle_helmet" | "minecraft:recipes/building_blocks/mud_brick_stairs_from_mud_bricks_stonecutting" | "crusty_chunks:electricity" | "framedblocks:recipes/building_blocks/framed_rail_slope" | "numismatics:recipes/misc/crafting/blue_id_card" | "farmersdelight:main/place_feast" | "tconstruct:recipes/redstone/world/wood/enderbark/button" | "minecraft:recipes/building_blocks/oak_stairs" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_andesite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_bamboo_mosaic_stairs" | "createdeco:recipes/decorations/blue_copper_lamp" | "create:recipes/building_blocks/copper_shingles_from_ingots_copper_stonecutting" | "sophisticatedstorage:recipes/misc/storage_io" | "vinery:recipes/grapevine_lattice" | "sophisticatedbackpacks:recipes/misc/smithing_upgrade" | "create_connected:recipes/crafting/palettes/copycat_beam_compat" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat_from_other_seat" | "create:recipes/misc/crafting/kinetics/fluid_pipe" | "framedblocks:recipes/building_blocks/framed_wall_board_rotate_to_framed_floor_board" | "createdeco:recipes/building_blocks/tiled_blue_brick_stairs_from_blue_bricks_stonecutting" | "storagedrawers:recipes/storagedrawers/warped_trim" | "spelunkery:recipes/raw_copper" | "spelunkery:recipes/raw_magnetite_nugget" | "create:recipes/building_blocks/polished_cut_crimsite_stairs" | "ae2:recipes/misc/network/cables/glass_light_gray" | "minecraft:recipes/misc/netherite_scrap" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs" | "securitycraft:recipes/decorations/reinforced_yellow_stained_glass_pane_from_dye" | "minecraft:story/enchant_item" | "mts:instrumentbench" | "create_dd:recipes/create_dd.palettes/blue_padded_tiled_rubber_from_blue_rubber_decor_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_slashed_locometal" | "create_dd:recipes/create_dd.palettes/cut_netherrack_brick_wall" | "createdeco:recipes/building_blocks/short_verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal" | "create:recipes/building_blocks/cut_tuff_stairs" | "securitycraft:recipes/building_blocks/reinforced_normal_stone_slab_from_reinforced_stone_stonecutting" | "chipped:recipes/alchemy_bench" | "ae2:recipes/misc/tools/network_tool" | "create_connected:recipes/crafting/palettes/copycat_fence_gate_compat" | "minecraft:recipes/decorations/chain" | "createdeco:recipes/decorations/blue_placard_from_dyeing" | "create_dd:recipes/create_dd.base/crafting/bury_blend" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_boiler" | "create:recipes/building_blocks/cut_scoria_from_stone_types_scoria_stonecutting" | "minecraft:recipes/decorations/oak_fence" | "storagedrawers:recipes/storagedrawers/jungle_trim" | "spelunkery:recipes/diamond" | "tfmg:recipes/building_blocks/cut_galena_wall_from_stone_types_galena_stonecutting" | "create:recipes/building_blocks/ochrum_from_stone_types_ochrum_stonecutting" | "sophisticatedstorage:recipes/misc/warped_chest_from_quark_warped_chest" | "tconstruct:recipes/redstone/world/wood/greenheart/trapdoor" | "mts:ticket" | "minecraft:recipes/redstone/mangrove_door" | "createdeco:recipes/building_blocks/tiled_red_brick_slab_from_long_red_bricks_stonecutting" | "create:display_board_0" | "minecraft:recipes/redstone/redstone_from_smelting_deepslate_redstone_ore" | "create:steam_whistle" | "minecraft:recipes/food/cooked_porkchop_from_campfire_cooking" | "securitycraft:recipes/building_blocks/reinforced_smooth_stone" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_tiled_dean_bricks_stonecutting" | "farmersdelight:recipes/cooking/pumpkin_soup" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_smoking" | "design_decor:recipes/building_blocks/asurine_castel_brick_wall_from_stone_types_asurine_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_blue_brick_stairs_stonecutting" | "sophisticatedstorage:recipes/misc/gold_chest" | "securitycraft:recipes/building_blocks/reinforced_cut_red_sandstone" | "create_dd:recipes/create_dd.palettes/layered_packed_mud_from_stone_types_packed_mud_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_advanced_magnet_upgrade_from_storage_advanced_magnet_upgrade" | "tconstruct:tools/perfect_aim" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/planks" | "minecraft:recipes/decorations/light_blue_stained_glass_pane" | "minecraft:adventure/spyglass_at_parrot" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "smallships:recipes/transportation/oak_cog" | "create:recipes/building_blocks/small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "create_enchantment_industry:experimental" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_plated_locometal" | "superbwarfare:recipes/misc/iron_trigger" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_slashed_locometal" | "ae2:recipes/misc/network/blocks/interfaces_interface_part" | "tfmg:recipes/decorations/aluminum_scaffolding_from_ingots_aluminum_stonecutting" | "create:recipes/misc/blasting/ingot_uranium_compat_immersiveengineering" | "securitycraft:recipes/building_blocks/reinforced_cobbled_deepslate_stairs_from_reinforced_cobbled_deepslate_stonecutting" | "alexscaves:alexscaves/dinosaur_nugget" | "framedblocks:recipes/building_blocks/framed_wall_board" | "interiors:recipes/building_blocks/crafting/chair/cyan_chair" | "framedblocks:recipes/building_blocks/framed_powered_rail_slope" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_tiled_verdant_bricks_stonecutting" | "securitycraft:recipes/decorations/reinforced_magenta_stained_glass_pane_from_dye" | "minecraft:recipes/decorations/end_stone_brick_wall" | "storagedrawers:recipes/storagedrawers/max_redstone_upgrade" | "create_dd:recipes/create_dd.palettes/cut_gabbro_brick_slab_from_stone_types_gabbro_stonecutting" | "createdeco:recipes/decorations/light_gray_shipping_container_from_dyeing_vaults" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_plated_locometal" | "sophisticatedstorage:recipes/misc/cherry_barrel" | "tconstruct:recipes/redstone/smeltery/seared/seared_casting_tank" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_bricks" | "create_dd:recipes/create_dd.palettes/crafting/decor/red_blueprint_block_from_red_dye" | "minecraft:recipes/decorations/mangrove_hanging_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_riveted_locometal" | "minecraft:recipes/decorations/black_banner" | "storagedrawers:recipes/storagedrawers/mangrove_drawers" | "create:recipes/building_blocks/small_granite_brick_wall_from_stone_types_granite_stonecutting" | "storagedrawers:recipes/storagedrawers/birch_drawers" | "vinery:recipes/wine_press" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal" | "design_decor:recipes/building_blocks/white_metal_sheet_stairs_from_metal_plate_stonecutting" | "create:recipes/misc/blasting/ingot_uranium_compat_ic2" | "brewery:main/get_saturated" | "tfmg:recipes/building_blocks/cut_bauxite_brick_wall_from_stone_types_bauxite_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_bricks_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_long_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/sandstone_stairs_from_sandstone_stonecutting" | "ae2:recipes/misc/tools/paintballs_cyan" | "securitycraft:recipes/building_blocks/reinforced_crimson_hyphae" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_slashed_locometal" | "securitycraft:recipes/building_blocks/reinforced_dark_prismarine_slab_from_reinforced_dark_prismarine_stonecutting" | "alexscaves:alexscaves/tremorzilla_egg" | "securitycraft:recipes/building_blocks/reinforced_smooth_red_sandstone_stairs" | "tconstruct:recipes/redstone/smeltery/scorched/chute" | "framedblocks:recipes/building_blocks/framed_pressure_plate" | "securitycraft:recipes/building_blocks/reinforced_chiseled_crystal_quartz_block_from_reinforced_crystal_quartz_block_stonecutting" | "create_dd:recipes/create_dd.base/crafting/lapis_lazuli_shard_from_lapis_lazuli" | "create_dd:recipes/create_dd.palettes/lime_padded_tiled_rubber_from_lime_rubber_decor_stonecutting" | "farmersdelight:recipes/decorations/green_hanging_canvas_sign" | "tfmg:recipes/building_blocks/small_galena_brick_wall" | "create_dd:recipes/create_dd.base/fluid_reservoir_from_fluid_tank_stonecutting" | "ae2:recipes/misc/tools/paintballs_lumen_orange" | "createdeco:recipes/building_blocks/mossy_blue_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal_boiler" | "createdeco:recipes/building_blocks/long_pearl_brick_slab" | "create:recipes/building_blocks/cut_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cobblestone_stairs_from_reinforced_cobblestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/compacting_upgrade" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_bricks_from_stone_types_weathered_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal_boiler" | "tconstruct:recipes/building_blocks/world/wood/skyroot/slab" | "tconstruct:recipes/misc/common/materials/pig_iron_nugget_from_ingot" | "minecraft:recipes/decorations/light_blue_banner" | "superbwarfare:recipes/combat/mk_14_smithing" | "minecraft:recipes/decorations/smithing_table" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_long_scarlet_brick_slab_stonecutting" | "minecraft:recipes/building_blocks/cut_sandstone_slab" | "createdeco:recipes/decorations/pink_shipping_container" | "ae2:recipes/misc/decorative/quartz_fixture_from_anchors" | "smallships:recipes/transportation/oak_galley" | "securitycraft:recipes/building_blocks/reinforced_birch_wood" | "advancedperipherals:overpowered_automata_core" | "createdeco:recipes/decorations/purple_placard" | "create:recipes/building_blocks/oxidized_copper_tile_stairs" | "storagedelight:recipes/decorations/small_jungle_drawers" | "tconstruct:recipes/decorations/common/glass/green_clear_stained_glass_pane_from_panes" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/transportation/tnt_minecart" | "advancedperipherals:recipes/redstone/redstone_integrator" | "ae2:recipes/misc/tools/certus_quartz_wrench" | "ae2:recipes/misc/tools/nether_quartz_wrench" | "create:crusher_maxed_0000" | "create:recipes/misc/smelting/copper_ingot_from_crushed" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_slab_from_reinforced_polished_deepslate_stonecutting" | "create:recipes/building_blocks/small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/pink_asphalt_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_smokebox" | "alexscaves:alexscaves/eat_candy_cane" | "sophisticatedstorage:recipes/misc/generic_limited_barrel_2" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "sophisticatedstorage:recipes/misc/generic_limited_barrel_3" | "ae2:recipes/misc/network/cables/covered_magenta" | "sophisticatedstorage:recipes/misc/generic_limited_barrel_1" | "createdeco:recipes/decorations/brass_support_wedge_from_stonecutting" | "design_decor:recipes/building_blocks/asurine_castel_tile_wall_from_stone_types_asurine_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_long_umber_brick_slab_stonecutting" | "storagedrawers:recipes/storagedrawers/controller" | "sophisticatedstorage:recipes/misc/backpack_stack_upgrade_tier_1_from_storage_stack_upgrade_tier_2" | "framedblocks:recipes/building_blocks/framed_mini_cube" | "sophisticatedstorage:recipes/misc/generic_limited_barrel_4" | "tconstruct:recipes/building_blocks/common/firewood/nahuatl_slab" | "create:recipes/building_blocks/polished_cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/brown_candle" | "tconstruct:recipes/decorations/common/glass/cyan_clear_stained_glass_pane_from_panes" | "framedblocks:recipes/building_blocks/framed_inner_prism_corner" | "alexscaves:alexscaves/diving_armor" | "minecraft:husbandry/wax_on" | "minecraft:recipes/building_blocks/purple_terracotta" | "create_connected:recipes/crafting/kinetics/empty_fan_catalyst_from_sanding" | "design_decor:recipes/building_blocks/cyan_metal_sheet_stairs_from_metal_plate_stonecutting" | "createdeco:recipes/decorations/zinc_catwalk_from_stonecutting" | "numismatics:recipes/misc/crafting/lime_card" | "vinery:recipes/coarse_dirt_slab" | "createbigcannons:recipes/misc/drop_mortar_shell" | "minecraft:adventure/play_jukebox_in_meadows" | "vinery:recipes/white_grape_bag" | "create:recipes/building_blocks/polished_cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_dolomite_brick_stairs_from_stone_types_dolomite_stonecutting" | "minecraft:recipes/misc/green_dye" | "framedblocks:recipes/building_blocks/framed_flat_ext_slope_panel_corner_rotate_to_framed_flat_elev_slope_slab_corner" | "minecraft:recipes/building_blocks/dark_prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_slashed_locometal" | "minecraft:adventure/hero_of_the_village" | "railways:recipes/misc/stonecutting/palettes/cycling/riveted_locometal" | "createdeco:recipes/decorations/black_shipping_container_from_dyeing_vaults" | "createdeco:recipes/building_blocks/cracked_verdant_bricks_from_verdant_bricks_smelting" | "minecraft:recipes/building_blocks/smooth_stone" | "create_connected:recipes/crafting/kinetics/vertical_six_way_gearbox_from_conversion" | "create:recipes/building_blocks/small_scorchia_brick_slab_recycling" | "create:recipes/misc/crafting/logistics/andesite_tunnel" | "alexscaves:alexscaves/magnetic_levitation_rail" | "minecraft:recipes/building_blocks/dye_pink_carpet" | "securitycraft:recipes/building_blocks/reinforced_light_blue_terracotta" | "createdeco:recipes/decorations/industrial_iron_catwalk_forge" | "alexscaves:alexscaves/shot_gum" | "superbwarfare:recipes/combat/taser_smithing" | "copycats:recipes/crafting/copycat_box" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite_stairs_from_reinforced_polished_diorite_stonecutting" | "minecraft:recipes/building_blocks/packed_ice" | "design_decor:recipes/building_blocks/pink_metal_plate_stairs_from_metal_plate_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_small_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/quartz_stairs_from_quartz_block_stonecutting" | "alexscaves:alexscaves/cave_tablet" | "securitycraft:recipes/building_blocks/reinforced_mud_brick_slab" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_short_verdant_brick_slab_stonecutting" | "superbwarfare:recipes/combat/bocek_smithing" | "minecraft:recipes/building_blocks/deepslate_tiles" | "minecraft:recipes/building_blocks/warped_hyphae" | "minecraft:recipes/redstone/jungle_button" | "createdeco:recipes/building_blocks/long_blue_bricks_from_short_blue_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/acacia_chest" | "createdeco:recipes/decorations/industrial_iron_mesh_fence_from_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_stairs" | "alexscaves:alexscaves/defeat_watcher" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_wall_from_stone_types_basalt_stonecutting" | "brewery:recipes/patterned_carpet" | "storagedrawers:recipes/storagedrawers/bamboo_trim" | "railways:recipes/combat/dying_existing_cap_gray" | "design_decor:recipes/building_blocks/diorite_castel_tile_wall_from_stone_types_diorite_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/lime_seat_from_other_seat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_slashed_locometal" | "tconstruct:recipes/redstone/smeltery/seared/faucet" | "createdeco:recipes/decorations/copper_catwalk_stairs_from_stonecutting" | "ae2:recipes/misc/network/wireless_booster" | "storagedelight:recipes/decorations/cherry_bookshelf_with_door" | "tconstruct:world/slimesuit" | "create_dd:recipes/create.base/item_vault_from_item_stockpile_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_slab_recycling" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade" | "minecraft:recipes/building_blocks/red_nether_bricks" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_bricks_from_reinforced_ingredients" | "ae2:recipes/misc/network/cables/dense_covered_white" | "minecraft:recipes/decorations/cyan_carpet" | "copycats:recipes/crafting/copycat_pane_from_conversion" | "tconstruct:recipes/decorations/common/gold_platform" | "minecraft:husbandry/root" | "create:recipes/building_blocks/cut_granite_bricks_from_stone_types_granite_stonecutting" | "tconstruct:recipes/tools/tools/building/ichor_staff" | "minecraft:recipes/transportation/birch_boat" | "tconstruct:smeltery/abilities" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone_brick_stairs_from_reinforced_polished_blackstone_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_short_dean_bricks_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_orange" | "ae2:recipes/misc/network/cables/dense_covered_green" | "createdeco:recipes/building_blocks/long_scarlet_bricks_from_scarlet_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_dean_brick_slab_from_tiled_dean_brick_slab_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_chipped_botanist_workbench_upgrade_from_storage_chipped_botanist_workbench_upgrade" | "framedblocks:recipes/building_blocks/framed_inv_double_slope_slab" | "create:recipes/building_blocks/crafting/kinetics/purple_seat_from_other_seat" | "minecraft:recipes/redstone/crimson_trapdoor" | "minecraft:recipes/decorations/green_glazed_terracotta" | "create:recipes/misc/blasting/lead_ingot_compat_thermal" | "create:recipes/building_blocks/cut_ochrum_brick_stairs" | "framedblocks:recipes/building_blocks/framed_vertical_double_stairs" | "design_decor:recipes/building_blocks/veridium_castel_tiles_from_stone_types_veridium_stonecutting" | "createdeco:recipes/decorations/andesite_support_wedge_from_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_pink" | "minecraft:adventure/trade" | "minecraft:recipes/building_blocks/deepslate" | "framedblocks:recipes/building_blocks/framed_double_slope_slab_rotate_to_framed_double_slope_panel" | "design_decor:recipes/building_blocks/calcite_castel_tile_stairs_from_stone_types_calcite_stonecutting" | "minecraft:recipes/decorations/white_carpet" | "ae2:main/pattern_encoding_terminal" | "minecraft:recipes/transportation/cherry_chest_boat" | "tconstruct:recipes/building_blocks/world/wood/greenheart/log_to_wood" | "securitycraft:recipes/misc/yellow_lens" | "interiors:recipes/building_blocks/crafting/chair/light_gray_chair_from_floor_chair" | "minecraft:recipes/building_blocks/dark_prismarine_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_slashed_locometal" | "create:recipes/building_blocks/cut_scoria_slab" | "create:recipes/misc/smelting/glass_pane_from_tiled_glass_pane" | "securitycraft:recipes/building_blocks/reinforced_yellow_glazed_terracotta" | "minecraft:recipes/building_blocks/jack_o_lantern" | "minecraft:recipes/transportation/birch_chest_boat" | "minecraft:recipes/decorations/glass_pane" | "securitycraft:recipes/decorations/reinforced_prismarine_wall" | "createdeco:recipes/decorations/brown_shipping_container" | "securitycraft:recipes/building_blocks/reinforced_red_wool" | "minecraft:recipes/decorations/purple_banner" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_brick_slab_from_stone_types_amethyst_block_stonecutting" | "storagedelight:recipes/decorations/small_warped_drawers" | "minecraft:recipes/building_blocks/magenta_stained_glass" | "securitycraft:recipes/building_blocks/reinforced_prismarine_brick_stairs_from_reinforced_prismarine_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_smoking_upgrade_from_storage_smoking_upgrade" | "create_dd:recipes/create_dd.palettes/light_blue_padded_rubber_stairs_from_light_blue_rubber_decor_stonecutting" | "tfmg:recipes/building_blocks/cut_galena_brick_wall_from_stone_types_galena_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/transportation/oak_boat" | "sophisticatedstorage:recipes/misc/backpack_advanced_filter_upgrade_from_storage_advanced_filter_upgrade" | "create:recipes/decorations/brass_scaffolding_from_ingots_brass_stonecutting" | "alexscaves:alexscaves/hazmat_armor" | "ae2:recipes/misc/network/cables/dense_covered_magenta" | "sophisticatedstorage:recipes/misc/storage_chipped_glassblower_upgrade_from_backpack_chipped_glassblower_upgrade" | "railways:recipes/misc/crafting/smokestack_streamlined" | "create_dd:recipes/create_dd.palettes/brown_padded_rubber_slab_from_brown_rubber_decor_stonecutting" | "sophisticatedstorage:recipes/misc/stack_downgrade_tier_3" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_plated_locometal" | "cgs:recipes/misc/lead_ingot_from_smelting_lead_ore" | "sophisticatedstorage:recipes/misc/stack_downgrade_tier_2" | "sophisticatedstorage:recipes/misc/stack_downgrade_tier_1" | "create:recipes/building_blocks/polished_cut_scorchia_stairs" | "tconstruct:recipes/redstone/smeltery/scorched/duct" | "framedblocks:recipes/building_blocks/framed_collapsible_copycat_block" | "framedblocks:recipes/building_blocks/framed_sign" | "create:recipes/building_blocks/small_granite_brick_wall" | "minecraft:recipes/building_blocks/smooth_stone_slab_from_smooth_stone_stonecutting" | "brewery:main/kill_beer_elemental" | "interiors:recipes/building_blocks/crafting/chair/cyan_chair_from_other_chair" | "createdeco:recipes/building_blocks/tiled_dean_brick_stairs" | "design_decor:recipes/building_blocks/dripstone_castel_tile_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "design_decor:recipes/building_blocks/tuff_castel_tile_stairs_from_stone_types_tuff_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_from_vine" | "superbwarfare:recipes/misc/awm_blueprint" | "minecraft:recipes/redstone/warped_button" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_riveted_locometal" | "crusty_chunks:oil_refinery" | "minecraft:recipes/decorations/stone_brick_wall_from_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_nether_brick_stairs" | "securitycraft:recipes/building_blocks/reinforced_stripped_dark_oak_wood" | "create:recipes/misc/crafting/kinetics/brass_door" | "securitycraft:recipes/tools/wire_cutters" | "create_dd:recipes/create_dd.palettes/red_padded_rubber_stairs_from_red_rubber_decor_stonecutting" | "design_decor:recipes/building_blocks/metal_sheet_stairs_from_ingots_iron_stonecutting" | "framedblocks:recipes/building_blocks/framed_corner_pillar" | "design_decor:recipes/building_blocks/calcite_castel_brick_stairs_from_stone_types_calcite_stonecutting" | "createdeco:recipes/decorations/yellow_brass_lamp" | "tconstruct:world/ender_island" | "farmersdelight:recipes/cooking/cooked_rice" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_moss_block" | "brewery:recipes/barrel_main" | "minecraft:recipes/redstone/acacia_fence_gate" | "minecraft:recipes/building_blocks/coal_block" | "superbwarfare:recipes/misc/aa_12_blueprint" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal_boiler" | "storagedrawers:recipes/storagedrawers/spruce_drawers" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_honeycomb" | "create_dd:recipes/create_dd.palettes/cut_weathered_limestone_brick_wall" | "design_decor:recipes/building_blocks/scoria_castel_brick_wall_from_stone_types_scoria_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/brass_wrapped_locometal" | "design_decor:recipes/building_blocks/andesite_castel_brick_stairs_from_stone_types_andesite_stonecutting" | "sophisticatedstorage:recipes/misc/copper_to_gold_tier_upgrade" | "minecraft:recipes/building_blocks/spruce_slab" | "dragnvehicles:recipes/misc/engine" | "vinery:main/overgrown_lattices" | "minecraft:recipes/decorations/polished_blackstone_wall_from_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_brick_stairs_from_stone_types_stone_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_ext_inner_slope_panel_corner" | "tconstruct:recipes/food/common/cheese_ingot_from_block" | "createbigcannons:recipes/misc/quickfiring_mechanism" | "createdeco:recipes/building_blocks/long_dean_brick_slab_from_dean_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_vertical_double_half_stairs" | "farmersdelight:recipes/cooking/fried_rice" | "sophisticatedstorage:recipes/misc/storage_chipped_mason_table_upgrade_from_backpack_chipped_mason_table_upgrade" | "createbigcannons:recipes/misc/steel_sliding_breechblock" | "securitycraft:recipes/building_blocks/reinforced_mangrove_stairs" | "create_dd:recipes/create_dd.base/crafting/equipment/deforester_saw" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_gray_blueprint_block" | "minecraft:recipes/decorations/white_stained_glass_pane_from_glass_pane" | "create:recipes/misc/crafting/kinetics/windmill_bearing" | "create_dd:recipes/create_dd.palettes/crafting/decor/blue_padded_rubber_from_blue_padded_rubber" | "securitycraft:recipes/redstone/reinforced_bamboo_button" | "framedblocks:recipes/building_blocks/framed_fancy_detector_rail" | "create_dd:recipes/create_dd.palettes/polished_cut_basalt_from_stone_types_basalt_stonecutting" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_blue_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_ochrum_from_stone_types_ochrum_stonecutting" | "securitycraft:recipes/redstone/reinforced_acacia_fence_gate" | "createdeco:recipes/building_blocks/cracked_dusk_bricks_from_dusk_bricks_smelting" | "framedblocks:recipes/building_blocks/framed_vertical_half_stairs" | "create:recipes/building_blocks/cut_asurine_bricks_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_filter_upgrade" | "minecraft:recipes/redstone/bamboo_door" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_tuff_slab_recycling" | "create:recipes/misc/crafting/materials/sand_paper" | "sophisticatedstorage:recipes/misc/oak_chest_from_quark_oak_chest" | "create:recipes/building_blocks/layered_limestone_from_stone_types_limestone_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_bricks_from_stone_types_blackstone_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_bamboo_mosaic_slab" | "securitycraft:recipes/building_blocks/reinforced_cobbled_deepslate_stairs" | "createdeco:recipes/building_blocks/short_umber_brick_slab_from_tiled_umber_brick_slab_stonecutting" | "crusty_chunks:heavy_artillery" | "create:recipes/building_blocks/polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_amethyst_block_slab_from_stone_types_amethyst_block_stonecutting" | "createdeco:recipes/building_blocks/mossy_verdant_brick_slab" | "minecraft:recipes/redstone/oak_button" | "create:recipes/misc/crafting/kinetics/basin" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_long_dean_brick_stairs_stonecutting" | "create:belt_funnel_kiss" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_brick_slab_from_stone_types_amethyst_block_stonecutting" | "securitycraft:recipes/decorations/reinforced_mossy_stone_brick_wall" | "create:recipes/building_blocks/dark_oak_window_pane" | "storagedelight:recipes/decorations/acacia_drawer_with_books" | "storagedelight:recipes/decorations/acacia_drawer" | "superbwarfare:recipes/misc/minigun_blueprint" | "createdeco:recipes/building_blocks/cracked_pearl_brick_stairs" | "securitycraft:recipes/building_blocks/reinforced_deepslate_tile_wall_from_reinforced_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template" | "create:recipes/building_blocks/cut_calcite_slab" | "securitycraft:recipes/building_blocks/reinforced_orange_carpet_from_dye" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "mts:propellerbench" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_slab_from_stone_types_blackstone_stonecutting" | "framedblocks:recipes/building_blocks/framed_glowing_cube" | "vinery:recipes/dark_cherry_door" | "createdeco:recipes/decorations/iron_support" | "createdeco:recipes/building_blocks/tiled_dusk_bricks_from_long_dusk_bricks_stonecutting" | "advancedperipherals:recipes/redstone/chat_box" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_smokebox" | "createdeco:recipes/decorations/andesite_bars_from_stonecutting" | "tconstruct:recipes/redstone/common/slime/sky/slimeblock" | "createdeco:recipes/building_blocks/short_red_bricks_from_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/purple_blueprint_block_from_purple_dye" | "sophisticatedbackpacks:recipes/misc/inception_upgrade" | "minecraft:recipes/building_blocks/exposed_cut_copper" | "storagedrawers:recipes/storagedrawers/mangrove_trim" | "create:linked_controller" | "createdeco:recipes/building_blocks/short_dusk_brick_slab_from_dusk_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_diorite_wall_from_stone_types_diorite_stonecutting" | "minecraft:recipes/misc/diamond_from_blasting_deepslate_diamond_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/small_calcite_brick_slab" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_1" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_3" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_2" | "minecraft:recipes/building_blocks/dye_purple_bed" | "minecraft:recipes/redstone/jungle_fence_gate" | "createdeco:recipes/building_blocks/long_pearl_bricks_from_pearl_bricks_stonecutting" | "create:recipes/misc/crafting/materials/zinc_block_from_compacting" | "immersive_paintings:misc/glow_graffiti" | "minecraft:recipes/building_blocks/dye_light_gray_carpet" | "create_dd:recipes/create_dd.palettes/dolomite_from_stone_types_dolomite_stonecutting" | "ae2:main/portable_cell" | "minecraft:recipes/redstone/warped_door" | "design_decor:recipes/building_blocks/ochrum_castel_brick_stairs_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/decorations/dark_oak_fence" | "create:recipes/misc/crafting/logistics/andesite_funnel" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat_from_other_seat" | "smallships:recipes/transportation/dark_oak_cog" | "createdeco:recipes/building_blocks/blue_bricks_from_long_blue_bricks_stonecutting" | "railways:recipes/misc/crafting/smokestack_caboosestyle" | "spelunkery:recipes/sculk" | "createdeco:recipes/building_blocks/tiled_verdant_bricks_from_verdant_bricks_stonecutting" | "computercraft:recipes/decorations/skull_dan200" | "createdeco:recipes/decorations/iron_hull" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_slab" | "create:recipes/building_blocks/polished_cut_asurine_stairs" | "smallships:recipes/transportation/birch_drakkar" | "securitycraft:recipes/redstone/reinforced_redstone_lamp" | "securitycraft:recipes/building_blocks/reinforced_red_sandstone_slab_from_reinforced_red_sandstone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_pillar" | "superbwarfare:main/rare_blueprint" | "create:recipes/building_blocks/polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "copycats:recipes/crafting/copycat_slice" | "minecraft:recipes/redstone/observer" | "securitycraft:recipes/building_blocks/reinforced_polished_granite_stairs_from_reinforced_granite_stonecutting" | "tconstruct:internal/starting_book" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal_boiler" | "tconstruct:recipes/redstone/world/wood/bloodshroom/pressure_plate" | "advancedperipherals:root" | "design_decor:recipes/building_blocks/green_metal_plate_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_long_umber_brick_stairs_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_granite_stairs" | "design_decor:recipes/building_blocks/light_blue_metal_sheet_slab_from_metal_plate_stonecutting" | "minecraft:recipes/decorations/torch" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal" | "securitycraft:recipes/building_blocks/reinforced_polished_granite_from_reinforced_granite_stonecutting" | "storagedelight:recipes/decorations/small_birch_drawers" | "create_connected:recipes/crafting/kinetics/linked_transmitter_from_conversion" | "createdeco:recipes/building_blocks/mossy_verdant_bricks_from_moss_block" | "storagedelight:recipes/decorations/warped_bookshelf_with_door" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_wall_from_reinforced_deepslate_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/magenta_blueprint_block_from_magenta_dye" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal_boiler" | "sophisticatedstorage:recipes/misc/storage_tool" | "securitycraft:recipes/redstone/reinforced_warped_pressure_plate" | "createdeco:recipes/building_blocks/umber_brick_stairs" | "tconstruct:recipes/food/common/cheese_block_from_ingot" | "alexscaves:alexscaves/ride_gum_worm" | "minecraft:recipes/building_blocks/dark_oak_planks" | "storagedelight:recipes/decorations/mangrove_drawer_with_books" | "securitycraft:recipes/building_blocks/reinforced_lime_glazed_terracotta" | "ae2:recipes/misc/tools/paintballs_light_gray" | "computercraft:recipes/redstone/turtle_normal/minecraft/crafting_table" | "create:recipes/building_blocks/small_dripstone_brick_slab_recycling" | "minecraft:recipes/building_blocks/red_sandstone_stairs" | "storagedelight:recipes/decorations/mangrove_single_door_cabinet" | "create:recipes/misc/crafting/logistics/stockpile_switch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/birch_window_pane" | "create_dd:recipes/create_dd.base/crafting/bore_block" | "create_dd:recipes/create_dd.palettes/crafting/dark_metal_block_from_dark_metal_block" | "create:recipes/building_blocks/small_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "tconstruct:recipes/building_blocks/common/basalt_blast_furnace" | "create_dd:recipes/create_dd.palettes/crafting/dark_metal_plating_from_dark_metal_plating" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_riveted_locometal" | "design_decor:recipes/building_blocks/red_metal_plate_slab_from_metal_plate_stonecutting" | "sophisticatedstorage:recipes/misc/chipped/alchemy_bench_upgrade" | "createdeco:recipes/building_blocks/mossy_scarlet_bricks_from_moss_block" | "securitycraft:recipes/building_blocks/netherrack_mine" | "securitycraft:recipes/decorations/secret_bamboo_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_riveted_locometal" | "create:recipes/building_blocks/polished_cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "spelunkery:recipes/portabella" | "create:recipes/building_blocks/polished_cut_andesite_slab_from_stone_types_andesite_stonecutting" | "createdeco:recipes/decorations/industrial_iron_mesh_fence" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_short_pearl_brick_stairs_stonecutting" | "minecraft:recipes/decorations/magenta_carpet" | "securitycraft:recipes/decorations/reinforced_light_gray_stained_glass_pane_from_dye" | "create:recipes/building_blocks/polished_cut_calcite_wall" | "create_dd:recipes/create_dd.palettes/small_blackstone_brick_wall_from_stone_types_blackstone_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/greenheart/planks" | "securitycraft:recipes/misc/reinforced_cherry_fence" | "create_dd:recipes/create_dd.palettes/dark_metal_plating_from_dark_metal_block_stonecutting" | "spelunkery:recipes/shard" | "tconstruct:tools/part_builder" | "crusty_chunks:gun_recipes" | "create:recipes/misc/crafting/materials/red_sand_paper" | "interiors:recipes/building_blocks/crafting/chair/yellow_chair" | "tconstruct:recipes/misc/common/materials/manyullyn_ingot_from_nuggets" | "createbigcannons:recipes/misc/worm_head" | "sophisticatedstorage:recipes/misc/iron_chest_from_copper_chest" | "create_dd:recipes/create_dd.palettes/cut_dolomite_brick_slab_from_stone_types_dolomite_stonecutting" | "createdeco:recipes/building_blocks/tiled_red_brick_stairs_from_short_red_brick_stairs_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/lime_asphalt_block" | "ae2:recipes/misc/network/cables/glass_purple" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/andesite_stairs_from_andesite_stonecutting" | "createbigcannons:recipes/building_blocks/nethersteel_block" | "createdeco:recipes/decorations/light_gray_shipping_container" | "create:recipes/building_blocks/cut_galena_slab_recycling" | "securitycraft:recipes/building_blocks/furnace_mine" | "tconstruct:recipes/decorations/common/firewood/nahuatl_fence" | "spelunkery:recipes/rough_diamond" | "tconstruct:recipes/misc/common/slime/ender/slimeball_from_congealed" | "brewery:main/eat_everything" | "framedblocks:recipes/building_blocks/framed_double_slope_slab" | "tfmg:recipes/building_blocks/small_bauxite_brick_wall" | "create:recipes/misc/blasting/ingot_aluminum_compat_immersiveengineering" | "tconstruct:recipes/building_blocks/common/slime/earth/crystal_block" | "create:recipes/building_blocks/cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "ae2:recipes/misc/network/cables/covered_lime" | "securitycraft:recipes/decorations/reinforced_yellow_stained_glass_pane" | "create_dd:recipes/create_dd.palettes/cut_gabbro_brick_slab_recycling" | "createdeco:recipes/decorations/green_shipping_container_from_dyeing_vaults" | "tconstruct:recipes/decorations/world/wood/bloodshroom/fence" | "minecraft:recipes/building_blocks/spruce_planks" | "railways:recipes/misc/crafting/remote_lens" | "createdeco:recipes/decorations/magenta_placard" | "tconstruct:recipes/redstone/smeltery/seared/duct" | "securitycraft:recipes/building_blocks/ancient_debris_mine" | "minecraft:recipes/building_blocks/polished_diorite_slab" | "tconstruct:recipes/decorations/smeltery/seared/melter" | "create:train_crash" | "createdeco:recipes/building_blocks/cracked_dusk_brick_stairs" | "design_decor:recipes/building_blocks/crimsite_castel_brick_stairs_from_stone_types_crimsite_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_wall_from_reinforced_cobbled_deepslate_stonecutting" | "tconstruct:recipes/redstone/smeltery/seared/fluid_cannon" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_pearl_bricks_stonecutting" | "createdeco:recipes/decorations/zinc_door" | "vinery:recipes/grapevine_stem" | "tconstruct:world/clay_island" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_plated_locometal" | "ae2:recipes/misc/network/cables/covered_orange" | "ae2:recipes/misc/tools/certus_quartz_cutting_knife" | "create:recipes/misc/crafting/kinetics/sequenced_gearshift" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_smokebox" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "create_dd:recipes/create_dd.palettes/small_basalt_bricks_from_stone_types_basalt_stonecutting" | "minecraft:recipes/misc/host_armor_trim_smithing_template" | "create:recipes/building_blocks/cut_ochrum_from_stone_types_ochrum_stonecutting" | "sophisticatedstorage:recipes/misc/birch_barrel" | "sophisticatedstorage:recipes/misc/copper_shulker_from_copper_chest" | "createdeco:recipes/building_blocks/tiled_umber_brick_slab_from_umber_brick_slab_stonecutting" | "ae2:main/recursive" | "spelunkery:recipes/amethyst" | "createdeco:recipes/building_blocks/short_scarlet_brick_slab_from_short_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_slashed_locometal" | "securitycraft:recipes/decorations/reinforced_light_blue_stained_glass_pane_from_dye" | "interiors:recipes/building_blocks/crafting/chair/cyan_chair_from_floor_chair" | "create_dd:recipes/create_dd.palettes/netherrack_pillar_from_stone_types_netherrack_stonecutting" | "minecraft:recipes/misc/light_gray_dye_from_azure_bluet" | "storagedrawers:recipes/storagedrawers/redstone_upgrade" | "superbwarfare:recipes/combat/qbz_191_smithing" | "create_dd:recipes/create_dd.base/smoking/rubber" | "spelunkery:spelunkery/rough_gem" | "createdeco:recipes/building_blocks/long_umber_brick_stairs" | "minecraft:recipes/building_blocks/smooth_quartz" | "ae2:recipes/misc/network/cables/dense_smart_black" | "numismatics:recipes/misc/crafting/pink_id_card" | "sophisticatedstorage:recipes/misc/jungle_barrel" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_limestone_slab" | "storagedrawers:recipes/storagedrawers/spruce_trim" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal_boiler" | "vinery:recipes/wine_box" | "createdeco:recipes/building_blocks/short_blue_brick_slab_from_long_blue_brick_slab_stonecutting" | "create:recipes/building_blocks/small_scoria_brick_wall" | "tconstruct:recipes/combat/gadgets/shuriken/quartz_shuriken" | "design_decor:recipes/building_blocks/granite_castel_tile_stairs_from_stone_types_granite_stonecutting" | "minecraft:recipes/decorations/blue_stained_glass_pane" | "framedblocks:recipes/building_blocks/framed_iron_pressure_plate" | "createdeco:recipes/building_blocks/tiled_blue_bricks_from_short_blue_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_stone_brick_wall_from_reinforced_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "ae2:recipes/misc/network/cables/covered_blue" | "create_dd:recipes/create_dd.palettes/light_gray_padded_rubber_stairs_from_light_gray_rubber_decor_stonecutting" | "createdeco:recipes/building_blocks/andesite_window" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "sophisticatedstorage:recipes/misc/basic_to_gold_tier_upgrade" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_wall_from_stone_types_packed_mud_stonecutting" | "brewery:main/drying_excellence" | "railways:recipes/combat/dying_existing_cap_green" | "securitycraft:recipes/redstone/reinforced_spruce_pressure_plate" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper_slab_from_reinforced_exposed_cut_copper_stonecutting" | "create:mechanical_arm" | "minecraft:recipes/decorations/acacia_hanging_sign" | "createbigcannons:recipes/misc/gunpowder_from_pinches" | "tconstruct:world/tinkers_gadgetry" | "createdeco:recipes/building_blocks/scarlet_brick_stairs_from_long_scarlet_brick_stairs_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_carpet" | "interiors:recipes/building_blocks/crafting/chair/yellow_chair_from_other_chair" | "create:recipes/misc/crafting/materials/brass_nugget_from_decompacting" | "create:recipes/misc/crafting/kinetics/item_drain" | "create:recipes/building_blocks/small_diorite_brick_stairs" | "alexscaves:alexscaves/discover_abyssal_ruins" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_short_verdant_bricks_stonecutting" | "create:recipes/building_blocks/rose_quartz_block_from_rose_quartz_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_brick_wall" | "securitycraft:recipes/decorations/reinforced_black_stained_glass_pane" | "securitycraft:recipes/redstone/reinforced_warped_fence_gate" | "minecraft:recipes/decorations/red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "securitycraft:recipes/decorations/reinforced_brick_wall" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_slashed_locometal" | "securitycraft:recipes/building_blocks/reinforced_deepslate_brick_slab_from_reinforced_polished_deepslate_stonecutting" | "create:recipes/building_blocks/cut_asurine_wall" | "minecraft:recipes/building_blocks/blackstone_slab_from_blackstone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_pillar" | "minecraft:recipes/redstone/cherry_fence_gate" | "create_dd:recipes/create_dd.palettes/crafting/decor/purple_blueprint_block" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs" | "createdeco:recipes/building_blocks/short_umber_brick_slab" | "create:recipes/misc/crafting/kinetics/mechanical_mixer" | "minecraft:recipes/building_blocks/chiseled_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/jungle_planks" | "securitycraft:recipes/building_blocks/reinforced_smooth_quartz_stairs" | "farmersdelight:recipes/decorations/stove" | "brewery:recipes/pork_knuckle" | "minecraft:recipes/building_blocks/chiseled_quartz_block" | "ae2:recipes/misc/network/cables/dense_smart_green" | "minecraft:recipes/redstone/bamboo_trapdoor" | "interiors:recipes/building_blocks/crafting/floor_chair/gray_floor_chair" | "storagedelight:recipes/decorations/small_oak_drawers" | "spelunkery:recipes/rock_salt" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/framed_glass_trapdoor" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_pillar" | "createdeco:recipes/building_blocks/verdant_brick_slab_from_tiled_verdant_brick_slab_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_chiseled_stone_bricks_from_reinforced_stone_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_deepslate_wall" | "framedblocks:recipes/building_blocks/framed_flat_ext_inner_double_slope_panel_corner_rotate_to_framed_flat_elev_inner_double_slope_slab_corner" | "create:recipes/building_blocks/crafting/kinetics/black_seat" | "create:recipes/decorations/andesite_ladder_from_andesite_alloy_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_diving_boots_from_netherite" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_ladder" | "spelunkery:recipes/glowstick" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "superbwarfare:recipes/misc/trachelium_blueprint" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "computercraft:recipes/redstone/computer_normal" | "create_dd:recipes/create_dd.palettes/cut_blackstone_brick_slab_from_stone_types_blackstone_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_from_stone_types_stone_stonecutting" | "framedblocks:recipes/building_blocks/framed_inner_prism" | "createdeco:recipes/decorations/copper_bars_overlay_from_stonecutting" | "createdeco:recipes/decorations/black_placard_from_dyeing" | "create:recipes/misc/crafting/kinetics/red_valve_handle_from_other_valve_handle" | "minecraft:recipes/building_blocks/dye_light_blue_wool" | "sophisticatedstorage:recipes/misc/advanced_feeding_upgrade" | "sophisticatedstorage:recipes/misc/mangrove_chest" | "createdeco:recipes/decorations/black_shipping_container" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_copper_wrapped_locometal" | "minecraft:recipes/redstone/sticky_piston" | "interiors:recipes/building_blocks/crafting/floor_chair/gray_floor_chair_from_other_floor_chair" | "securitycraft:recipes/building_blocks/suspicious_gravel_mine" | "tconstruct:recipes/decorations/tables/tinkers_forge" | "spelunkery:recipes/rough_emerald_block" | "createdeco:recipes/building_blocks/short_dean_brick_stairs" | "sophisticatedstorage:recipes/misc/cyan_shulker_box_to_sophisticated" | "superbwarfare:recipes/misc/qbz_95_blueprint" | "tconstruct:recipes/building_blocks/common/firewood/blazewood_stairs" | "framedblocks:recipes/building_blocks/framed_stacked_corner_slope_panel" | "sophisticatedstorage:recipes/misc/storage_blasting_upgrade_from_backpack_blasting_upgrade" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "alexscaves:alexscaves/discover_magnetic_caves" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_riveted_locometal" | "brewery:main/copper_brewmaster" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/crafting/decor/yellow_asphalt_block" | "create:recipes/building_blocks/polished_cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_brick_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_cut_sandstone_from_reinforced_sandstone_stonecutting" | "alexscaves:alexscaves/cave_painting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_wall" | "securitycraft:recipes/building_blocks/reinforced_stripped_jungle_wood" | "securitycraft:recipes/building_blocks/dirt_mine" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_slab" | "minecraft:recipes/building_blocks/waxed_oxidized_copper_from_honeycomb" | "create_dd:recipes/create_dd.palettes/layered_gabbro_from_stone_types_gabbro_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/greenheart/stairs" | "farmersdelight:recipes/food/beef_patty_from_smoking" | "create:recipes/building_blocks/small_andesite_brick_slab" | "create_dd:recipes/create_dd.palettes/white_padded_tiled_rubber_from_white_rubber_decor_stonecutting" | "create:recipes/building_blocks/exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "farmersdelight:recipes/cooking/beef_stew" | "design_decor:recipes/building_blocks/andesite_castel_tiles_from_stone_types_andesite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_stairs" | "minecraft:recipes/decorations/mangrove_fence" | "create:recipes/misc/crafting/kinetics/fluid_tank" | "vinery:recipes/straw_hat" | "createdeco:recipes/building_blocks/long_dusk_bricks_from_dusk_bricks_stonecutting" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_slab_from_tiled_scarlet_bricks_stonecutting" | "create_connected:recipes/crafting/palettes/copycat_block_compat" | "createdeco:recipes/decorations/locked_industrial_iron_door" | "minecraft:recipes/food/cooked_mutton" | "railways:recipes/misc/crafting/palettes/wrapping/pink_iron_wrapped_locometal" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k" | "minecraft:recipes/building_blocks/deepslate_tile_stairs" | "create_dd:recipes/create_dd.palettes/small_basalt_brick_stairs" | "create_dd:recipes/create_dd.palettes/packed_mud_pillar_from_stone_types_packed_mud_stonecutting" | "tconstruct:recipes/misc/common/materials/manyullyn_ingot_from_block" | "create:recipes/building_blocks/calcite_from_stone_types_calcite_stonecutting" | "createdeco:recipes/decorations/green_industrial_iron_lamp" | "comforts:hammock_black" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_riveted_locometal" | "createbigcannons:recipes/misc/bronze_sliding_breechblock" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_long_red_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/small_basalt_brick_slab" | "minecraft:adventure/sniper_duel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_slashed_locometal" | "create:track_signal" | "tconstruct:recipes/redstone/world/wood/enderbark/pressure_plate" | "minecraft:recipes/building_blocks/polished_andesite_stairs" | "create:recipes/decorations/copper_scaffolding_from_ingots_copper_stonecutting" | "minecraft:recipes/transportation/furnace_minecart" | "securitycraft:recipes/building_blocks/reinforced_dark_prismarine_stairs_from_reinforced_dark_prismarine_stonecutting" | "minecraft:nether/root" | "ae2:recipes/misc/shaped/slabs/quartz_bricks" | "securitycraft:recipes/building_blocks/reinforced_weathered_cut_copper_stairs" | "create_dd:recipes/create_dd.palettes/small_dolomite_brick_slab_from_stone_types_dolomite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_slashed_locometal" | "design_decor:recipes/building_blocks/blue_metal_plate_slab_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_gray_terracotta" | "create:recipes/misc/crafting/kinetics/track_observer_from_other_plates" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_brick_stairs_from_reinforced_mossy_stone_bricks_stonecutting" | "farmersdelight:recipes/misc/canvas_from_canvas_rug" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_boiler" | "create:recipes/misc/crafting/materials/small_rose_quartz_tilesfrom_conversion" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_dean_bricks_stonecutting" | "create:musical_arm" | "securitycraft:recipes/building_blocks/reinforced_spruce_wood" | "createdeco:recipes/decorations/copper_support_wedge_from_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_mossy_cobblestone_from_vanilla_cobblestone" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_slashed_locometal" | "createdeco:recipes/decorations/yellow_zinc_lamp" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_brick_stonecutting" | "createdeco:recipes/building_blocks/short_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/backpack_chipped_tinkering_table_upgrade_from_storage_chipped_tinkering_table_upgrade" | "tconstruct:recipes/misc/common/materials/rose_gold_ingot_from_block" | "ae2:recipes/misc/network/cells/item_storage_components_cell_256k_part" | "tconstruct:recipes/building_blocks/common/slime/ichor/congealed" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_long_dean_brick_stairs_stonecutting" | "framedblocks:recipes/building_blocks/framed_half_stairs" | "design_decor:recipes/building_blocks/light_gray_metal_sheet_stairs_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_stairs_from_long_verdant_bricks_stonecutting" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "createbigcannons:recipes/misc/cast_iron_sliding_breechblock" | "create_dd:recipes/create_dd.palettes/crafting/dark_metal_bricks_from_dark_metal_bricks" | "createdeco:recipes/building_blocks/cracked_blue_brick_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_plated_locometal" | "create:recipes/building_blocks/cut_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_plated_locometal" | "interiors:recipes/building_blocks/crafting/chair/blue_chair_from_seat" | "alexscaves:alexscaves/sundae" | "minecraft:recipes/decorations/white_banner" | "copycats:recipes/crafting/copycat_slab_from_beams" | "securitycraft:recipes/building_blocks/reinforced_cyan_carpet_from_dye" | "securitycraft:recipes/misc/claymore" | "tconstruct:recipes/building_blocks/common/glass/lime_clear_stained_glass" | "copycats:recipes/crafting/copycat_vertical_slice" | "sophisticatedstorage:recipes/misc/backpack_stack_downgrade_tier_1_from_storage_stack_downgrade_tier_1" | "securitycraft:recipes/building_blocks/reinforced_polished_blackstone" | "sophisticatedstorage:recipes/misc/bamboo_chest" | "securitycraft:recipes/misc/harming_module" | "createdeco:recipes/building_blocks/short_pearl_bricks_from_tiled_pearl_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_netherrack_bricks_from_stone_types_netherrack_stonecutting" | "minecraft:recipes/building_blocks/dye_magenta_wool" | "railways:recipes/misc/crafting/palettes/wrapping/red_iron_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_scorchia_slab" | "storagedelight:recipes/decorations/dark_oak_drawer" | "design_decor:recipes/building_blocks/metal_sheet_slab_from_ingots_iron_stonecutting" | "securitycraft:recipes/decorations/secret_bamboo_sign_item" | "framedblocks:recipes/building_blocks/framed_flat_inv_double_slope_panel_corner_rotate_to_framed_flat_inv_double_slope_slab_corner" | "securitycraft:recipes/building_blocks/crystal_quartz_slab_from_crystal_quartz_stonecutting" | "framedblocks:recipes/building_blocks/framed_fancy_powered_rail_slope" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_stairs" | "tconstruct:foundry/encyclopedia" | "create_enchantment_industry:spirit_taking" | "securitycraft:recipes/transportation/oak_security_sea_boat" | "tconstruct:tools/travelers_gear" | "create_dd:recipes/create_dd.palettes/cut_basalt_wall" | "alexscaves:alexscaves/cave_book" | "securitycraft:recipes/building_blocks/reinforced_oxidized_cut_copper_slab_from_reinforced_oxidized_cut_copper_stonecutting" | "sophisticatedstorage:recipes/misc/storage_advanced_pickup_upgrade_from_backpack_advanced_pickup_upgrade" | "create:recipes/building_blocks/polished_cut_tuff_slab" | "framedblocks:recipes/tools/framed_key" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_slashed_locometal" | "create_dd:recipes/create_dd.palettes/crafting/decor/black_blueprint_block_from_black_dye" | "casinocraft:recipes/decorations/wool_cyan" | "alexscaves:alexscaves/telecore" | "minecraft:recipes/building_blocks/dark_oak_wood" | "create_dd:recipes/create_dd.base/crafting/fan_catalyst/splashing_sail" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_riveted_locometal" | "createdeco:recipes/building_blocks/long_verdant_bricks_from_verdant_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_omega_tier" | "minecraft:recipes/building_blocks/polished_blackstone" | "minecraft:recipes/misc/diamond_from_smelting_diamond_ore" | "framedblocks:recipes/building_blocks/framed_adj_double_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_riveted_locometal" | "create:recipes/building_blocks/cut_andesite_wall" | "farmersdelight:main/root" | "railways:recipes/combat/dying_existing_cap_white" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_stairs_from_stone_types_blackstone_stonecutting" | "framedblocks:recipes/building_blocks/framed_wall" | "create:recipes/building_blocks/cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs" | "create:recipes/building_blocks/cut_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "copycats:recipes/crafting/copycat_fence_gate" | "smallships:recipes/transportation/acacia_drakkar" | "railways:recipes/misc/stonecutting/palettes/cycling/white_slashed_locometal" | "design_decor:recipes/building_blocks/scorchia_castel_brick_wall_from_stone_types_scorchia_stonecutting" | "alexscaves:alexscaves/pearl_on_abyssal_altar" | "spelunkery:recipes/copper_ores" | "create:recipes/misc/crafting/kinetics/linear_chassisfrom_conversion" | "create_connected:recipes/crafting/kinetics/crank_wheel" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cracked_bricks_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_blue_asphalt_block" | "copycats:recipes/crafting/copycat_ladder" | "sophisticatedstorage:recipes/misc/backpack_advanced_pickup_upgrade_from_storage_advanced_pickup_upgrade" | "minecraft:recipes/misc/lapis_lazuli" | "interiors:recipes/building_blocks/crafting/chair/pink_chair_from_other_chair" | "sophisticatedstorage:recipes/misc/mangrove_barrel" | "storagedelight:recipes/decorations/small_spruce_drawers" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k_storage" | "ae2:recipes/misc/materials/cardspeed" | "create_dd:recipes/create_dd.base/crafting/kinetics/kinetic_motor" | "minecraft:recipes/misc/eye_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_slashed_locometal" | "sophisticatedstorage:recipes/misc/white_shulker_box_to_sophisticated" | "camerapture:recipes/camera" | "create:diving_suit_lava" | "ae2:recipes/misc/network/cables/glass_red" | "farmersdelight:main/use_cutting_board" | "create:cuckoo_clock" | "tconstruct:recipes/redstone/smeltery/seared/duct_retextured" | "create:recipes/building_blocks/cut_granite_stairs_from_stone_types_granite_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/orange_chair_from_other_chair" | "create:recipes/misc/crafting/logistics/powered_toggle_latch" | "sophisticatedstorage:recipes/misc/backpack_chipped_alchemy_bench_upgrade_from_storage_chipped_alchemy_bench_upgrade" | "createdeco:recipes/building_blocks/cracked_scarlet_bricks_from_scarlet_bricks_blasting" | "superbwarfare:recipes/combat/devotion_smithing" | "computercraft:recipes/redstone/printed_book" | "minecraft:adventure/salvage_sherd" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_slab_stonecutter" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_short_dean_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_slashed_locometal" | "computercraft:recipes/redstone/pocket_advanced/computercraft/wireless_modem_normal" | "create_dd:recipes/create_dd.base/crafting/equipment/magnet" | "framedblocks:recipes/building_blocks/framed_half_pillar" | "design_decor:recipes/building_blocks/calcite_castel_tile_wall_from_stone_types_calcite_stonecutting" | "createdeco:recipes/building_blocks/pearl_brick_stairs_from_short_pearl_brick_stairs_stonecutting" | "numismatics:recipes/misc/crafting/brown_card" | "createdeco:recipes/building_blocks/tiled_pearl_brick_stairs_from_short_pearl_bricks_stonecutting" | "storagedelight:recipes/decorations/bamboo_bookshelf_with_door" | "createdeco:recipes/building_blocks/short_blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "numismatics:is_this_legal" | "create_dd:recipes/create_dd.palettes/cut_basalt_brick_wall_from_stone_types_basalt_stonecutting" | "comforts:hammock_cyan" | "design_decor:recipes/building_blocks/diorite_castel_tiles_from_stone_types_diorite_stonecutting" | "minecraft:story/cure_zombie_villager" | "overworld_netherite_ore:the_big_one" | "vinery:recipes/dark_cherry_slab" | "design_decor:recipes/building_blocks/light_gray_metal_plate_wall_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_stone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal" | "storagedrawers:recipes/storagedrawers/quantify_key" | "create:recipes/building_blocks/small_granite_bricks_from_stone_types_granite_stonecutting" | "createdeco:recipes/decorations/brass_catwalk_railing_forge" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_tiled_blue_brick_stairs_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "minecraft:recipes/tools/recovery_compass" | "interiors:recipes/building_blocks/crafting/floor_chair/brown_floor_chair_from_other_floor_chair" | "ae2:recipes/misc/network/cables/dense_covered_fluix_clean" | "createdeco:recipes/decorations/orange_shipping_container" | "storagedrawers:recipes/storagedrawers/dark_oak_trim" | "create_dd:recipes/create_dd.palettes/small_weathered_limestone_brick_slab_from_stone_types_weathered_limestone_stonecutting" | "tconstruct:recipes/decorations/common/glass/orange_clear_stained_glass_pane" | "create_dd:recipes/create_dd.base/crafting/kinetics/fluid_reservoir" | "create:drain" | "minecraft:end/find_end_city" | "createdeco:recipes/building_blocks/mossy_umber_bricks_from_moss_block" | "interiors:recipes/building_blocks/crafting/floor_chair/purple_floor_chair_from_other_floor_chair" | "minecraft:recipes/redstone/mangrove_fence_gate" | "create:recipes/misc/blasting/ingot_uranium_compat_mekanism" | "create:recipes/building_blocks/polished_cut_scoria_slab_recycling" | "create:recipes/building_blocks/cut_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_brick_slab_from_tiled_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/tiled_umber_brick_stairs_from_umber_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_veridium_wall" | "immersive_paintings:misc/glow_painting" | "minecraft:recipes/building_blocks/polished_andesite" | "minecraft:recipes/decorations/lime_glazed_terracotta" | "securitycraft:recipes/building_blocks/reinforced_warped_planks" | "create_dd:recipes/create_dd.palettes/cut_basalt_bricks_from_stone_types_basalt_stonecutting" | "alexscaves:alexscaves/acid_create_rust" | "railways:recipes/misc/crafting/palettes/wrapping/green_iron_wrapped_locometal" | "createdeco:recipes/building_blocks/mossy_dean_brick_stairs_from_mossy_dean_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_slashed_locometal" | "ae2:recipes/misc/materials/basiccard" | "sophisticatedstorage:recipes/misc/brown_shulker_box_to_sophisticated" | "createdeco:recipes/building_blocks/mossy_scarlet_brick_stairs_from_mossy_scarlet_bricks_stonecutting" | "ae2:recipes/misc/tools/portable_item_cell_1k" | "framedblocks:recipes/building_blocks/framed_vertical_divided_stairs" | "create:recipes/misc/crafting/kinetics/cogwheel" | "smallships:recipes/transportation/cherry_galley" | "brewery:main/root" | "create:recipes/building_blocks/cut_tuff_slab_from_stone_types_tuff_stonecutting" | "tfmg:recipes/decorations/cast_iron_bars_from_ingots_cast_iron_stonecutting" | "securitycraft:recipes/redstone/panic_button" | "minecraft:recipes/transportation/carrot_on_a_stick" | "createdeco:recipes/building_blocks/tiled_verdant_brick_slab" | "create:recipes/building_blocks/small_dripstone_brick_wall" | "ae2:recipes/misc/tools/portable_item_cell_4k" | "railways:recipes/misc/crafting/palettes/wrapping/red_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "farmersdelight:main/eat_nourishing_food" | "design_decor:recipes/building_blocks/veridium_castel_tile_slab_from_stone_types_veridium_stonecutting" | "securitycraft:recipes/decorations/reinforced_black_stained_glass_pane_from_dye" | "createdeco:recipes/building_blocks/umber_brick_slab_from_short_umber_bricks_stonecutting" | "tfmg:recipes/building_blocks/cut_galena_slab_from_stone_types_galena_stonecutting" | "computercraft:recipes/redstone/pocket_computer_advanced_upgrade" | "minecraft:recipes/building_blocks/muddy_mangrove_roots" | "minecraft:recipes/building_blocks/red_sandstone_slab_from_red_sandstone_stonecutting" | "createdeco:recipes/building_blocks/long_pearl_brick_slab_from_short_pearl_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_asurine_from_stone_types_asurine_stonecutting" | "storagedelight:recipes/decorations/oak_drawer_with_books" | "ae2:recipes/misc/shaped/slabs/fluix_block" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_verdant_brick_slab_stonecutting" | "createdeco:recipes/building_blocks/tiled_pearl_brick_slab_from_short_pearl_brick_slab_stonecutting" | "numismatics:recipes/misc/crafting/yellow_card" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_plated_locometal" | "tfmg:recipes/building_blocks/zinc_truss_from_ingots_zinc_stonecutting" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/copper_backpack" | "comforts:hammock_green" | "design_decor:recipes/building_blocks/green_metal_plate_wall_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_red_nether_brick_slab" | "farmersdelight:recipes/decorations/yellow_hanging_canvas_sign" | "framedblocks:recipes/building_blocks/framed_extended_double_slope_panel_rotate_to_framed_elevated_double_slope_slab" | "tconstruct:recipes/misc/common/materials/cobalt_ingot_from_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/scarlet_bricks_from_long_scarlet_bricks_stonecutting" | "sophisticatedstorage:recipes/misc/storage_jukebox_upgrade_from_backpack_jukebox_upgrade" | "minecraft:recipes/building_blocks/warped_slab" | "spelunkery:spelunkery/feed_slime" | "create_dd:recipes/create_dd.palettes/crafting/decor/cyan_asphalt_block" | "createdeco:recipes/decorations/industrial_iron_sheet_metal" | "computercraft:recipes/redstone/monitor_advanced" | "farmersdelight:main/harvest_straw" | "design_decor:recipes/building_blocks/gray_metal_sheet_wall_from_metal_plate_stonecutting" | "createdeco:recipes/decorations/zinc_coinstack" | "minecraft:recipes/redstone/spruce_door" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_pillar" | "spelunkery:recipes/nephrite_chunk" | "vinery:recipes/vinemaker_boots" | "minecraft:recipes/redstone/spruce_fence_gate" | "farmersdelight:recipes/decorations/scaffolding_from_canvas" | "farmersdelight:recipes/decorations/purple_canvas_sign" | "securitycraft:recipes/building_blocks/reinforced_light_gray_terracotta" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_stone_from_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_slashed_locometal" | "create:recipes/misc/crafting/appliances/dough" | "create:recipes/building_blocks/weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "createdeco:recipes/building_blocks/dean_bricks_from_short_dean_bricks_stonecutting" | "createdeco:recipes/building_blocks/short_pearl_brick_slab_from_tiled_pearl_bricks_stonecutting" | "securitycraft:recipes/decorations/secret_cherry_hanging_sign" | "ae2:recipes/misc/network/cables/smart_green" | "farmersdelight:recipes/decorations/acacia_cabinet" | "securitycraft:recipes/misc/reinforced_mangrove_fence" | "minecraft:recipes/building_blocks/dye_white_wool" | "securitycraft:recipes/building_blocks/reinforced_andesite" | "create_dd:recipes/create_dd.palettes/polished_cut_stone_slab" | "superbwarfare:recipes/misc/netherite_action" | "sophisticatedstorage:recipes/misc/chipped/loom_table_upgrade" | "minecraft:recipes/decorations/light_blue_glazed_terracotta" | "securitycraft:recipes/building_blocks/reinforced_cobbled_deepslate_wall_from_reinforced_cobbled_deepslate_stonecutting" | "farmersdelight:recipes/decorations/pink_canvas_sign" | "create:recipes/misc/blasting/gold_ingot_from_crushed" | "createdeco:recipes/building_blocks/pearl_bricks" | "create:recipes/misc/crafting/kinetics/contraption_controls" | "create:recipes/building_blocks/polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "farmersdelight:recipes/decorations/rope_from_safety_net" | "minecraft:recipes/building_blocks/prismarine_stairs" | "securitycraft:recipes/decorations/secret_warped_hanging_sign" | "create:recipes/misc/crafting/kinetics/flywheel" | "tfmg:recipes/building_blocks/brass_frame_from_ingots_brass_stonecutting" | "create_dd:recipes/create_dd.palettes/cyan_padded_tiled_rubber_from_cyan_rubber_decor_stonecutting" | "create:recipes/misc/crafting/kinetics/hose_pulley" | "alexscaves:alexscaves/uranium_rod" | "create_dd:recipes/create_dd.palettes/cut_gabbro_slab" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tiles_from_polished_deepslate_stonecutting" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_tiled_blue_bricks_stonecutting" | "tfmg:recipes/building_blocks/cut_galena_brick_stairs_from_stone_types_galena_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tiles_from_deepslate_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_brick" | "minecraft:recipes/building_blocks/mangrove_wood" | "framedblocks:recipes/building_blocks/framed_flat_slope_slab_corner" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor" | "design_decor:recipes/building_blocks/gray_metal_sheet_stairs_from_metal_plate_stonecutting" | "createdeco:recipes/building_blocks/verdant_brick_stairs" | "tconstruct:recipes/decorations/common/glass/brown_clear_stained_glass_pane" | "superbwarfare:recipes/misc/sks_blueprint" | "create:recipes/building_blocks/small_ochrum_brick_wall" | "superbwarfare:recipes/transportation/speedboat_container" | "create:recipes/building_blocks/small_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "create:contraption_actors" | "minecraft:recipes/misc/gold_ingot_from_smelting_nether_gold_ore" | "securitycraft:recipes/building_blocks/reinforced_brown_carpet_from_dye" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/white_seat" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_smokebox" | "create:recipes/building_blocks/cut_calcite_brick_slab" | "spelunkery:recipes/gunpowder" | "securitycraft:recipes/redstone/reinforced_lever" | "minecraft:recipes/building_blocks/yellow_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/spire_armor_trim_smithing_template_smithing_trim" | "tconstruct:recipes/misc/common/materials/raw_cobalt_block_from_raws" | "tfmg:recipes/building_blocks/polished_cut_galena_from_stone_types_galena_stonecutting" | "create:recipes/building_blocks/rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "createbigcannons:recipes/misc/ap_shot" | "createdeco:recipes/decorations/zinc_support_wedge" | "create_dd:recipes/create_dd.palettes/cut_basalt_brick_stairs" | "minecraft:recipes/redstone/mangrove_button" | "securitycraft:recipes/building_blocks/reinforced_nether_brick_slab_from_reinforced_nether_bricks_stonecutting" | "framedblocks:recipes/building_blocks/framed_double_threeway_corner" | "interiors:recipes/building_blocks/crafting/chair/red_chair_from_other_chair" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingles_from_honeycomb" | "railways:recipes/combat/dying_existing_cap_orange" | "create_dd:recipes/create_dd.palettes/polished_cut_packed_mud_from_stone_types_packed_mud_stonecutting" | "sophisticatedstorage:recipes/misc/warped_chest" | "securitycraft:recipes/building_blocks/reinforced_green_wool" | "create_dd:recipes/create_dd.palettes/cyan_padded_rubber_slab_from_cyan_rubber_decor_stonecutting" | "farmersdelight:recipes/misc/tomato_seeds" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_boiler" | "design_decor:recipes/building_blocks/blue_metal_plate_wall_from_metal_plate_stonecutting" | "spelunkery:recipes/rough_cinnabar" | "tfmg:recipes/building_blocks/cut_bauxite_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_slashed_locometal" | "ae2:recipes/misc/network/cables/dense_smart_yellow" | "create:recipes/building_blocks/cut_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_stairs" | "minecraft:recipes/building_blocks/polished_basalt_from_basalt_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab" | "createdeco:recipes/building_blocks/long_dusk_brick_slab" | "ae2:recipes/misc/decorative/cut_quartz_block" | "securitycraft:recipes/building_blocks/reinforced_green_terracotta" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_plated_locometal" | "ae2:recipes/misc/block_cutter/stairs/quartz_stairs" | "create:recipes/building_blocks/polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/white_wool_from_string" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_tiled_dean_brick_stairs_stonecutting" | "alexscaves:alexscaves/rainbounce_boots" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "minecraft:recipes/decorations/yellow_banner" | "design_decor:recipes/building_blocks/deepslate_castel_brick_stairs_from_stone_types_deepslate_stonecutting" | "design_decor:recipes/building_blocks/light_blue_metal_sheet_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_blue_terracotta" | "design_decor:recipes/building_blocks/black_metal_plate_stairs_from_metal_plate_stonecutting" | "vinery:recipes/oak_wine_rack_small" | "minecraft:recipes/building_blocks/deepslate_brick_slab" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_polished_diorite_stonecutting" | "createbb:p2/obtain_liquid_blue_methamphetamine_bucket" | "storagedelight:recipes/decorations/cherry_drawer_with_books" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "create:recipes/building_blocks/cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "ae2:recipes/misc/materials/cardinverter" | "minecraft:recipes/redstone/polished_blackstone_pressure_plate" | "createdeco:recipes/building_blocks/dean_bricks" | "create:recipes/building_blocks/small_deepslate_brick_wall" | "farmersdelight:recipes/building_blocks/rice_bag" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_dusk_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_riveted_locometal" | "tconstruct:recipes/redstone/smeltery/scorched/channel" | "alexscaves:alexscaves/gobthumper" | "copycats:recipes/crafting/copycat_large_cogwheel" | "create:recipes/building_blocks/cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/magenta_stained_glass_pane_from_glass_pane" | "createdeco:recipes/building_blocks/long_umber_brick_stairs_from_tiled_umber_brick_stairs_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_diorite" | "comforts:hammock_white" | "copycats:recipes/crafting/copycat_vertical_half_layer_from_conversion" | "tconstruct:recipes/building_blocks/common/glass/blue_clear_stained_glass" | "alexscaves:alexscaves/moth_ball" | "minecraft:recipes/brewing/blaze_powder" | "minecraft:end/root" | "tconstruct:recipes/decorations/tables/cast_chest" | "ae2:recipes/misc/materials/cardenergy" | "create_dd:recipes/create_dd.base/crafting/kinetics/item_stockpile" | "securitycraft:recipes/building_blocks/reinforced_polished_diorite_stairs" | "tconstruct:recipes/misc/common/materials/cinderslime_ingot_from_nuggets" | "vinery:recipes/loam_slab" | "create_dd:recipes/create_dd.palettes/padded_mosaic_rubber_from_rubber_decor_stonecutting" | "sophisticatedstorage:recipes/misc/iron_shulker_from_iron_chest" | "create_connected:recipes/crafting/kinetics/parallel_gearbox_from_conversion" | "sophisticatedbackpacks:recipes/misc/chipped/loom_table_upgrade" | "minecraft:recipes/decorations/moss_carpet" | "farmersdelight:recipes/food/stuffed_potato" | "minecraft:recipes/decorations/cyan_stained_glass_pane_from_glass_pane" | "farmersdelight:recipes/food/fruit_salad" | "farmersdelight:recipes/decorations/light_blue_hanging_canvas_sign" | "minecraft:recipes/redstone/crimson_fence_gate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper" | "securitycraft:recipes/building_blocks/reinforced_hardened_clay" | "create_dd:recipes/create_dd.palettes/polished_cut_blackstone_wall_from_stone_types_blackstone_stonecutting" | "create:recipes/misc/crafting/kinetics/vertical_gearbox" | "securitycraft:recipes/redstone/reinforced_cherry_pressure_plate" | "create_dd:recipes/create_dd.palettes/cut_blackstone_from_stone_types_blackstone_stonecutting" | "interiors:recipes/building_blocks/crafting/chair/white_chair_from_floor_chair" | "createdeco:recipes/building_blocks/tiled_dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "minecraft:recipes/building_blocks/gray_concrete_powder" | "create:foods" | "securitycraft:recipes/decorations/reinforced_brown_stained_glass_pane" | "create_dd:recipes/create_dd.palettes/magenta_padded_mosaic_rubber_from_magenta_rubber_decor_stonecutting" | "tconstruct:recipes/decorations/tables/crafting_station_from_logs" | "securitycraft:recipes/building_blocks/reinforced_exposed_cut_copper_stairs" | "copycats:recipes/crafting/copycat_slab_from_panels" | "createbigcannons:recipes/misc/proximity_fuze" | "comforts:hammock_light_gray" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_pillar" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_riveted_locometal" | "minecraft:recipes/building_blocks/glowstone" | "create:recipes/building_blocks/oak_window" | "createdeco:recipes/building_blocks/short_verdant_brick_slab_from_long_verdant_brick_slab_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal" | "design_decor:recipes/building_blocks/ochrum_castel_tiles_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/decorations/industrial_iron_bars_overlay" | "framedblocks:recipes/building_blocks/framed_small_corner_slope_panel" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_long_dusk_brick_stairs_stonecutting" | "tconstruct:tools/netherite_tier" | "minecraft:recipes/decorations/cartography_table" | "tfmg:recipes/building_blocks/cut_galena_from_stone_types_galena_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_stone_wall" | "securitycraft:recipes/building_blocks/reinforced_dark_prismarine_stairs" | "createdeco:recipes/decorations/blue_industrial_iron_lamp" | "tconstruct:tools/upgrade_slots" | "securitycraft:recipes/building_blocks/reinforced_mossy_stone_brick_slab_from_reinforced_mossy_stone_bricks_stonecutting" | "createdeco:recipes/building_blocks/long_verdant_bricks_from_short_verdant_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_deepslate" | "design_decor:recipes/building_blocks/lime_metal_sheet_from_metal_plate_stonecutting" | "create:recipes/misc/crafting/kinetics/nixie_tube" | "minecraft:recipes/misc/iron_nugget_from_blasting" | "brewery:main/get_whiskey_jojannik" | "sophisticatedbackpacks:recipes/misc/restock_upgrade" | "superbwarfare:recipes/misc/hpj_11_blueprint" | "interiors:recipes/building_blocks/crafting/chair/brown_chair" | "securitycraft:recipes/building_blocks/reinforced_cut_sandstone" | "create_dd:recipes/create_dd.palettes/cut_packed_mud_slab" | "createdeco:recipes/decorations/brass_trapdoor" | "minecraft:husbandry/plant_any_sniffer_seed" | "framedblocks:recipes/building_blocks/framed_flat_inner_slope_panel_corner" | "create_dd:recipes/create_dd.palettes/crafting/decor/red_blueprint_block" | "farmersdelight:recipes/food/cooked_cod_slice_from_campfire_cooking" | "minecraft:adventure/adventuring_time" | "minecraft:recipes/building_blocks/dye_cyan_carpet" | "tconstruct:recipes/redstone/world/wood/bloodshroom/trapdoor" | "brewery:main/get_whiskey_hadarilabel" | "create:recipes/building_blocks/polished_cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "createdeco:recipes/decorations/yellow_andesite_lamp" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_pillar" | "tconstruct:recipes/redstone/smeltery/scorched/duct_retextured" | "securitycraft:recipes/building_blocks/reinforced_oak_wood" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_stairs" | "create_dd:recipes/create_dd.palettes/crafting/decor/red_padded_rubber_from_red_padded_rubber" | "createdeco:recipes/building_blocks/long_dean_brick_stairs_from_tiled_dean_brick_stairs_stonecutting" | "createdeco:recipes/misc/netherite_ingot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_riveted_locometal" | "minecraft:husbandry/plant_seed" | "minecraft:nether/find_bastion" | "create:recipes/building_blocks/small_galena_brick_slab_recycling" | "create:recipes/building_blocks/crafting/kinetics/lime_seat" | "createdeco:recipes/decorations/lime_placard_from_dyeing" | "railways:recipes/misc/crafting/palettes/wrapping/white_brass_wrapped_locometal" | "securitycraft:recipes/decorations/secret_acacia_sign_item" | "securitycraft:recipes/building_blocks/reinforced_polished_andesite_stairs_from_reinforced_polished_andesite_stonecutting" | "sophisticatedstorage:recipes/misc/crimson_chest_from_quark_crimson_chest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_slashed_locometal" | "minecraft:recipes/decorations/flower_pot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/cut_dolomite_brick_slab_recycling" | "securitycraft:recipes/building_blocks/reinforced_chiseled_sandstone" | "ae2:recipes/misc/network/cables/smart_black" | "create_dd:recipes/create_dd.palettes/small_stone_brick_slab_recycling" | "createdeco:recipes/building_blocks/dean_brick_stairs_from_tiled_dean_brick_stairs_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_galosphere" | "alexscaves:alexscaves/beholder_far_away" | "dragnvehicles:recipes/misc/suv_body" | "sophisticatedbackpacks:recipes/misc/tool_swapper_upgrade" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "createbigcannons:recipes/misc/big_cartridge_sheet" | "create:recipes/building_blocks/layered_asurine_from_stone_types_asurine_stonecutting" | "railways:recipes/combat/dying_existing_cap_black" | "superbwarfare:recipes/misc/hunting_rifle_blueprint" | "createbb:p2/obtain_methylamine_bucket" | "framedblocks:recipes/building_blocks/framed_divided_slab" | "minecraft:recipes/decorations/sandstone_wall" | "farmersdelight:recipes/food/chicken_sandwich" | "create:recipes/misc/crafting/kinetics/purple_valve_handle_from_other_valve_handle" | "ae2:recipes/misc/shaped/slabs/sky_stone_block" | "securitycraft:recipes/building_blocks/reinforced_end_stone_brick_wall_from_reinforced_end_stone_stonecutting" | "create_dd:recipes/create_dd.palettes/small_netherrack_bricks_from_stone_types_netherrack_stonecutting" | "create:recipes/misc/smelting/glass_from_vertical_framed_glass" | "interiors:recipes/building_blocks/crafting/chair/cyan_chair_from_seat" | "tconstruct:recipes/redstone/common/slime/sticky_piston" | "create_connected:recipes/crafting/kinetics/item_silo" | "minecraft:recipes/decorations/andesite_wall" | "minecraft:recipes/building_blocks/andesite_slab" | "minecraft:recipes/misc/light_gray_dye_from_oxeye_daisy" | "design_decor:recipes/building_blocks/gray_metal_sheet_slab_from_metal_plate_stonecutting" | "create:recipes/misc/crafting/kinetics/metal_bracket" | "ae2:recipes/misc/network/blocks/inscribers" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_riveted_locometal" | "create:recipes/building_blocks/cut_ochrum_slab_recycling" | "createdeco:recipes/building_blocks/umber_brick_stairs_from_tiled_umber_bricks_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/black_padded_rubber_from_black_padded_rubber" | "minecraft:recipes/building_blocks/cobblestone_stairs_from_cobblestone_stonecutting" | "framedblocks:recipes/building_blocks/framed_flat_stacked_slope_slab_corner" | "comforts:sleeping_bag_lime" | "advancedperipherals:recipes/redstone/block_reader" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal_boiler" | "minecraft:recipes/misc/wheat" | "sophisticatedstorage:recipes/misc/netherite_chest" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_riveted_locometal" | "design_decor:recipes/building_blocks/black_metal_sheet_slab_from_metal_plate_stonecutting" | "minecraft:recipes/redstone/birch_pressure_plate" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_pillar_from_reinforced_crystal_quartz_block_stonecutting" | "sophisticatedstorage:recipes/misc/spruce_barrel" | "railways:recipes/misc/stonecutting/riveted_locometal" | "minecraft:recipes/building_blocks/purpur_stairs_from_purpur_block_stonecutting" | "minecraft:recipes/building_blocks/cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/diorite_slab_from_diorite_stonecutting" | "createdeco:recipes/decorations/brass_sheet_metal" | "createbigcannons:recipes/misc/bag_of_grapeshot" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_long_scarlet_bricks_stonecutting" | "alexscaves:alexscaves/deep_sea_sushi_roll" | "design_decor:recipes/building_blocks/deepslate_castel_tile_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/pink_carpet" | "create:portable_storage_interface" | "farmersdelight:recipes/decorations/purple_hanging_canvas_sign" | "sophisticatedstorage:recipes/misc/auto_smelting_upgrade" | "storagedrawers:recipes/storagedrawers/balance_fill_upgrade" | "comforts:hammock_yellow" | "brewery:recipes/rope" | "create:conductor" | "createdeco:recipes/building_blocks/long_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "ae2:main/root" | "farmersdelight:recipes/decorations/cutting_board" | "tconstruct:recipes/decorations/world/wood/skyroot/sign" | "createbigcannons:recipes/misc/ram_rod" | "tconstruct:recipes/food/gadgets/cake/ender" | "ae2:recipes/misc/network/blocks/io_port" | "create_dd:recipes/create_dd.palettes/crafting/decor/light_blueprint_block_from_light_blue_dye" | "create:recipes/building_blocks/cut_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "spelunkery:recipes/flint" | "sophisticatedstorage:recipes/misc/backpack_advanced_alchemy_upgrade_from_storage_advanced_alchemy_upgrade" | "createdeco:recipes/building_blocks/dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "minecraft:recipes/tools/netherite_pickaxe_smithing" | "alexscaves:alexscaves/repair_submarine" | "tfmg:recipes/building_blocks/cut_galena_stairs" | "createdeco:recipes/building_blocks/short_dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "alexscaves:alexscaves/dinosaurs_minecart" | "create_dd:recipes/create_dd.palettes/purple_padded_mosaic_rubber_from_purple_rubber_decor_stonecutting" | "minecraft:nether/fast_travel" | "securitycraft:recipes/building_blocks/reinforced_polished_deepslate_slab_from_reinforced_cobbled_deepslate_stonecutting" | "tconstruct:recipes/brewing/common/glass/vanilla/glass_bottle" | "create_enchantment_industry:recipes/enchanting_guide" | "farmersdelight:recipes/food/bacon_and_eggs" | "sophisticatedstorage:recipes/misc/backpack_blasting_upgrade_from_storage_blasting_upgrade" | "sophisticatedstorage:recipes/misc/orange_shulker_box_to_sophisticated" | "createdeco:recipes/building_blocks/tiled_dusk_brick_slab_from_short_dusk_brick_slab_stonecutting" | "create_enchantment_industry:copiable_masterpiece" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_long_red_brick_stairs_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_crystal_quartz_stairs" | "create:recipes/building_blocks/copper_shingle_slab_from_copper_shingles_stonecutting" | "create:precision_mechanism" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal" | "tfmg:recipes/building_blocks/cut_galena_brick_stairs" | "minecraft:recipes/building_blocks/deepslate_tiles_from_cobbled_deepslate_stonecutting" | "ae2:recipes/misc/network/crafting/cpu_crafting_unit" | "overworld_netherite_ore:master_of_ancient_shards" | "createdeco:recipes/building_blocks/verdant_brick_stairs_from_tiled_verdant_brick_stairs_stonecutting" | "securitycraft:recipes/tools/universal_owner_changer" | "superbwarfare:recipes/misc/svd_blueprint" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_riveted_locometal" | "tconstruct:recipes/building_blocks/common/glass/light_gray_clear_stained_glass" | "framedblocks:recipes/building_blocks/framed_elevated_double_slope_edge" | "minecraft:recipes/redstone/tnt" | "securitycraft:recipes/decorations/reinforced_purple_stained_glass_pane_from_dye" | "create:recipes/building_blocks/cut_tuff_bricks_from_stone_types_tuff_stonecutting" | "create_dd:recipes/create_dd.base/crafting/fan_catalyst/smoking_sail" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_brick_stairs" | "comforts:sleeping_bag_blue" | "sophisticatedstorage:recipes/misc/storage_advanced_filter_upgrade_from_backpack_advanced_filter_upgrade" | "createdeco:recipes/decorations/zinc_hull_from_stonecutting" | "farmersdelight:recipes/building_blocks/pumpkin_from_slices" | "superbwarfare:recipes/combat/m_2_hb_smithing" | "alexscaves:alexscaves/toxic_paste" | "create:recipes/building_blocks/small_limestone_brick_stairs" | "create_dd:recipes/create_dd.palettes/polished_cut_amethyst_block_slab_from_stone_types_amethyst_block_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_light_gray_glazed_terracotta" | "minecraft:recipes/decorations/enchanting_table" | "design_decor:recipes/building_blocks/metal_plate_from_ingots_iron_stonecutting" | "createdeco:recipes/building_blocks/long_scarlet_brick_slab_from_tiled_scarlet_brick_slab_stonecutting" | "design_decor:recipes/building_blocks/pink_metal_sheet_from_metal_plate_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_quartz_stairs" | "createdeco:recipes/building_blocks/short_red_brick_stairs_from_bricks_stonecutting" | "create:recipes/misc/blasting/lead_ingot_compat_oreganized" | "create_connected:recipes/crafting/kinetics/inventory_bridge" | "sophisticatedstorage:recipes/misc/storage_advanced_compacting_upgrade_from_backpack_advanced_compacting_upgrade" | "tconstruct:recipes/misc/common/materials/slimesteel_ingot_from_nuggets" | "alexscaves:alexscaves/trilocaris_bucket" | "createdeco:recipes/building_blocks/short_dean_brick_stairs_from_dean_brick_stairs_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_plated_locometal" | "chipped:recipes/mason_table" | "createdeco:recipes/building_blocks/mossy_red_brick_slab_from_mossy_red_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal_boiler" | "design_decor:recipes/building_blocks/scorchia_castel_tile_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/tools/stone_hoe" | "spelunkery:recipes/gold_ores" | "createdeco:recipes/building_blocks/short_scarlet_brick_stairs_from_scarlet_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal" | "vinery:recipes/dark_cherry_planks" | "design_decor:recipes/building_blocks/veridium_castel_tile_stairs_from_stone_types_veridium_stonecutting" | "minecraft:recipes/decorations/jungle_hanging_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_riveted_locometal" | "minecraft:recipes/building_blocks/spruce_stairs" | "create:recipes/misc/blasting/silver_ingot_compat_iceandfire" | "sophisticatedbackpacks:recipes/misc/crafting_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_plated_locometal" | "securitycraft:recipes/building_blocks/reinforced_chiseled_nether_bricks_from_reinforced_nether_bricks_stonecutting" | "securitycraft:recipes/building_blocks/reinforced_andesite_wall_from_reinforced_andesite_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/cyan_blueprint_block_from_cyan_dye" | "createbigcannons:recipes/misc/cast_iron_ingot_from_block" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_copper_wrapped_locometal" | "createdeco:recipes/building_blocks/long_dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "alexscaves:alexscaves/stalked_by_deep_one" | "securitycraft:recipes/building_blocks/reinforced_yellow_carpet_from_dye" | "tconstruct:recipes/redstone/smeltery/scorched/proxy_tank" | "tconstruct:recipes/redstone/smeltery/seared/fuel_gauge" | "minecraft:recipes/decorations/black_candle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_riveted_locometal" | "create:recipes/building_blocks/small_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "create_dd:recipes/create_dd.palettes/cut_blackstone_brick_wall_from_stone_types_blackstone_stonecutting" | "create:recipes/misc/crafting/kinetics/item_vault" | "create:recipes/building_blocks/crafting/kinetics/gray_seat_from_other_seat" | "securitycraft:recipes/building_blocks/reinforced_polished_granite_slab_from_reinforced_polished_granite_stonecutting" | "minecraft:recipes/decorations/mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "createdeco:recipes/building_blocks/long_red_brick_slab" | "tconstruct:recipes/decorations/smeltery/seared/heater" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_smokebox" | "farmersdelight:recipes/building_blocks/onion_crate" | "minecraft:recipes/decorations/loom" | "create:recipes/building_blocks/exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "create_dd:recipes/create_dd.palettes/crafting/decor/lime_blueprint_block" | "minecraft:recipes/tools/diamond_axe" | "createdeco:recipes/building_blocks/blue_brick_stairs_from_short_blue_bricks_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_stonecutting" | "superbwarfare:recipes/misc/devotion_blueprint" | "design_decor:recipes/building_blocks/diagonal_metal_support_from_ingots_iron_stonecutting" | "minecraft:recipes/misc/emerald_from_blasting_deepslate_emerald_ore" | "createdeco:recipes/decorations/iron_mesh_fence" | "minecraft:recipes/decorations/scaffolding" | "createdeco:recipes/building_blocks/tiled_scarlet_brick_stairs_from_long_scarlet_bricks_stonecutting" | "tconstruct:recipes/redstone/world/wood/greenheart/door" | "ae2:recipes/misc/tools/paintballs_lumen_light_blue" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_boiler" | "createdeco:recipes/decorations/copper_catwalk_railing_from_stonecutting" | "alexscaves:alexscaves/tame_vallumraptor" | "createdeco:recipes/building_blocks/long_pearl_brick_stairs_from_pearl_brick_stairs_stonecutting" | "design_decor:recipes/building_blocks/pink_metal_plate_wall_from_metal_plate_stonecutting" | "tfmg:recipes/decorations/steel_ladder_from_ingots_steel_stonecutting" | "superbwarfare:recipes/combat/qbz_95_smithing" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper" | "comforts:sleeping_bag_yellow" | "rechiseled:recipes/misc/chisel" | "create:recipes/building_blocks/cut_granite_stairs" | "createdeco:recipes/building_blocks/cracked_blue_brick_slab_from_cracked_blue_bricks_stonecutting" | "spelunkery:spelunkery/true_north" | "create:recipes/building_blocks/small_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:recipes/misc/raw_copper" | "interiors:recipes/building_blocks/crafting/chair/black_chair" | "create:recipes/building_blocks/copper_shingle_stairs_from_copper_shingles_stonecutting" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_brick_slab_recycling" | "create:recipes/misc/crafting/kinetics/gearshift" | "storagedelight:recipes/decorations/glass_crimson_cabinet" | "framedblocks:recipes/building_blocks/framed_flat_ext_double_slope_panel_corner_rotate_to_framed_flat_elev_double_slope_slab_corner" | "brewery:main/get_dried_barley" | "tconstruct:recipes/redstone/smeltery/seared/chute" | "minecraft:story/root" | "minecraft:recipes/building_blocks/dye_black_wool" | "create:recipes/building_blocks/tiled_glass_from_glass_colorless_stonecutting" | "ae2:recipes/misc/tools/paintballs_lumen_cyan" | "advancedperipherals:end_automata_core" | "securitycraft:recipes/misc/light_gray_lens" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal_boiler" | "securitycraft:recipes/misc/white_lens" | "create_dd:recipes/create_dd.palettes/small_gabbro_brick_slab_recycling" | "create:recipes/building_blocks/cut_limestone_brick_slab" | "createbigcannons:recipes/misc/gas_mask" | "securitycraft:recipes/misc/reinforced_spruce_fence" | "computercraft:recipes/redstone/turtle_advanced/computercraft/speaker" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat" | "framedblocks:recipes/building_blocks/framed_sliced_stairs_slab" | "design_decor:recipes/building_blocks/granite_castel_brick_slab_from_stone_types_granite_stonecutting" | "vinery:main/purely_apple" | "tconstruct:recipes/decorations/common/cobalt_platform" | "ae2:recipes/misc/misc/chests_sky_stone" | "create_dd:recipes/create_dd.palettes/small_amethyst_block_brick_stairs_from_stone_types_amethyst_block_stonecutting" | "spelunkery:recipes/rough_lazurite_block" | "framedblocks:recipes/building_blocks/framed_double_slope_panel_rotate_to_framed_double_slope_slab" | "create:recipes/misc/crafting/appliances/slime_ball" | "interiors:recipes/building_blocks/crafting/chair/lime_chair_from_other_chair" | "securitycraft:recipes/building_blocks/reinforced_stripped_birch_wood" | "smallships:recipes/transportation/cherry_cog" | "securitycraft:recipes/misc/black_lens" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_honeycomb" | "create_dd:recipes/create_dd.palettes/small_packed_mud_brick_slab" | "createdeco:recipes/decorations/iron_catwalk_stairs" | "farmersdelight:recipes/food/honey_glazed_ham_block" | "minecraft:recipes/misc/copper_ingot_from_smelting_raw_copper" | "create:recipes/building_blocks/cut_tuff_wall_from_stone_types_tuff_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_stairs_stonecutter" | "securitycraft:recipes/building_blocks/reinforced_quartz_bricks_from_reinforced_quartz_block_stonecutting" | "minecraft:recipes/building_blocks/snow_block" | "superbwarfare:recipes/combat/insidious_smithing" | "createdeco:recipes/decorations/green_placard" | "create_dd:recipes/create_dd.palettes/cut_netherrack_brick_stairs" | "interiors:recipes/building_blocks/crafting/floor_chair/green_floor_chair_from_other_floor_chair" | "minecraft:recipes/decorations/polished_blackstone_wall" | "create:recipes/building_blocks/cut_asurine_stairs" | "createbigcannons:recipes/misc/timed_fuze" | "minecraft:recipes/decorations/honeycomb_block" | "superbwarfare:recipes/misc/cemented_carbide_action" | "sophisticatedstorage:recipes/misc/backpack_advanced_compacting_upgrade_from_storage_advanced_compacting_upgrade" | "interiors:recipes/building_blocks/crafting/floor_chair/light_blue_floor_chair_from_other_floor_chair" | "create_dd:recipes/create_dd.palettes/cut_blackstone_slab_recycling" | "create_dd:recipes/create_dd.palettes/pink_padded_rubber_slab_from_pink_rubber_decor_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "minecraft:recipes/combat/golden_leggings" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_lapis_ore" | "superbwarfare:recipes/combat/glock_18_smithing" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal" | "create_dd:recipes/create_dd.palettes/polished_cut_netherrack_stairs_from_stone_types_netherrack_stonecutting" | "minecraft:recipes/food/cooked_beef_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_slashed_locometal" | "ae2:recipes/misc/network/cells/item_storage_cell_16k_storage" | "farmersdelight:recipes/food/fried_egg" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_slashed_locometal" | "createdeco:recipes/decorations/iron_support_wedge" | "securitycraft:recipes/redstone/reinforced_acacia_button" | "createdeco:recipes/building_blocks/short_pearl_brick_stairs_from_long_pearl_brick_stairs_stonecutting" | "create_connected:recipes/crafting/kinetics/six_way_gearbox_from_parallel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_scorchia_slab_recycling" | "securitycraft:recipes/building_blocks/reinforced_andesite_stairs" | "design_decor:recipes/building_blocks/yellow_metal_plate_stairs_from_metal_plate_stonecutting";
    type RecipeId = "tconstruct:tools/modifiers/salvage/upgrade/fireprimer" | "farmersdelight:cutting/brown_mushroom_colony" | "tconstruct:tools/parts/casting/bow_grip_composite" | "alexscaves:stripped_pewen_wood" | "railways:sequenced_assembly/track_biomesoplenty_umbran_wide" | "cib:attachments/muzzle_silencer_shotgun" | "ae2:matter_cannon/nuggets/yttrium" | "create:milling/charcoal" | "tfmg:compacting/plastic_molding" | "s_a_b:stonecutting/blocks/normal_slabs/steel_brown_vslab" | "createdeco:tiled_pearl_brick_slab_from_long_pearl_bricks_stonecutting" | "create:milling/compat/environmental/violet" | "minecraft:stonecutter" | "tcintegrations:tools/modifiers/salvage/compat/precipitate" | "maxstuff:gun/aks74u" | "minecraft:bone_block" | "create_tank_defenses:muddy_steel_pressurized_armor_craft" | "tacz:gun/type_81" | "crusty_chunks:small_bomb_recipe" | "tconstruct:smeltery/casting/metal/iron/ingot_gold_cast" | "petrolsparts:mechanical_crafting/colossal_cogwheel" | "ae2:inscriber/certus_quartz_dust" | "tconstruct:smeltery/casting/metal/uranium/coin_gold_cast" | "create:cut_granite_wall" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "createdieselgenerators:mixing/biodiesel" | "ae2:network/cells/item_storage_cell_256k_storage" | "s_a_b:crafting/colored/normal/steel_block_gelb" | "tconstruct:common/glass/pink_clear_stained_glass_pane" | "create:oak_window" | "farmersdelight:cutting/bamboo_trapdoor" | "create_tank_defenses:sunflower_steel_armor_craft" | "crusty_chunks:stealth_pistol_recipe" | "crusty_chunks:battle_cannon_autoloader_recipe" | "spelunkery:polished_nephrite_wall_from_stonecutting" | "createdeco:long_red_bricks_from_bricks_stonecutting" | "s_a_b:crafting/colored/hard/hard_steel_block_pink" | "spelunkery:polished_nephrite_brick_from_raw_stonecutting" | "create:cut_diorite_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:void_upgrade" | "securitycraft:reinforced_cracked_stone_bricks" | "createdeco:short_red_brick_stairs_from_tiled_red_brick_stairs_stonecutting" | "create:brass_ladder_from_ingots_brass_stonecutting" | "minecraft:cobblestone_wall" | "railways:crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "securitycraft:reinforced_quartz_slab_from_reinforced_quartz_block_stonecutting" | "marbledsarsenal:olive_plate_carrier_heavy" | "spelunkery:nephrite_siphon" | "tconstruct:smeltery/melting/metal/rose_gold/block" | "alexscaves:cinder_block" | "minecraft:raw_copper" | "railways:crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "tconstruct:smeltery/melting/scorched/pane_soul" | "tconstruct:tools/severing/wither_skeleton_skull" | "create_tank_defenses:purity_titanium_reinforced_armor_block_craft" | "create_tank_defenses:see_letter_craft" | "tconstruct:smeltery/melting/metal/refined_glowstone/axes" | "design_decor:stonecutting/signs/bun_sign" | "createdeco:long_dean_bricks_from_tiled_dean_bricks_stonecutting" | "create:splashing/endergetic/petrified_end_corrock_block" | "createdeco:andesite_catwalk_from_stonecutting" | "farmersdelight:cooked_chicken_cuts_from_smoking" | "create:crushing/compat/elementaryores/ore_lapis_end" | "minecraft:map_extending" | "tconstruct:smeltery/scorched/scorched_bricks_crafting" | "minecraft:spruce_sign" | "create:cutting/compat/regions_unexplored/joshua_wood" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "createbigcannons:pair_of_cannon_wheels" | "createdeco:copper_catwalk_stairs" | "create:crushing/raw_silver" | "sophisticatedbackpacks:advanced_refill_upgrade" | "sophisticatedstorage:copper_to_iron_tier_upgrade" | "valkyrien_warium:helicopter_blade_recipe" | "s_a_b:stonecutting/blocks/normal_slabs/steel_camo_swamp_vslab" | "minecraft:glow_item_frame" | "tconstruct:smeltery/melting/metal/invar/gear" | "create_tank_defenses:snow_titanium_armor_craft" | "tfmg:smelting/aluminum_ingot" | "interiors:crafting/floor_chair/light_gray_floor_chair_from_seat" | "railways:sequenced_assembly/track_bamboo_narrow" | "framedblocks:framed_stairs_rotate_to_framed_vertical_stairs" | "tconstruct:smeltery/melting/metal/constantan/block" | "minecraft:copper_block" | "create:cutting/spruce_wood" | "railways:sequenced_assembly/track_tfc_white_cedar_wide" | "sliceanddice:slicer" | "create_tank_defenses:ceramic_plate_craft" | "create_tank_defenses:blast_raw_titanium" | "tconstruct:smeltery/casting/seared/bricks/stairs" | "tconstruct:smeltery/casting/metal/nickel/gear_gold_cast" | "railways:sequenced_assembly/track_crimson_narrow" | "tconstruct:smeltery/entity_melting/heads/zombie" | "create_tank_defenses:blast_titanium_ore" | "minecraft:green_stained_glass" | "create:cutting/crimson_hyphae" | "interiors:crafting/floor_chair/brown_floor_chair" | "create_dd:small_packed_mud_brick_wall" | "vinery:wine_fermentation/aegis_wine" | "tacz:ammo/9mm" | "create:small_veridium_brick_slab_recycling" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "tconstruct:tools/building/pickaxe" | "tconstruct:tools/modifiers/salvage/upgrade/sinistral" | "create_tank_defenses:forest_chain_armor_block_craft" | "tconstruct:common/materials/manyullyn_block_from_ingots" | "createdeco:long_red_brick_stairs_from_tiled_red_bricks_stonecutting" | "createdeco:purple_shipping_container_from_dyeing_vaults" | "marbledsarsenal:spruce_ghillie_boots" | "createdeco:long_blue_brick_stairs_from_long_blue_bricks_stonecutting" | "securitycraft:reinforced_smooth_basalt" | "tconstruct:smeltery/casting/metal/iron/rod_sand_cast" | "tconstruct:smeltery/casting/metal/enderium/plate_gold_cast" | "tconstruct:smeltery/melting/metal/osmium/oreberry" | "securitycraft:reinforced_spruce_slab" | "securitycraft:green_lens" | "tconstruct:smeltery/casting/metal/slimesteel/block" | "alexscaves:gingerbread_slab" | "s_a_b:crafting/colored/normal/steel_block_purple" | "securitycraft:reinforced_smooth_quartz" | "minecraft:cut_sandstone_slab" | "tconstruct:smeltery/casts/sand/molding/hammer_head" | "railways:crafting/palettes/dyeing_1x/gray_locometal_pillar" | "superbwarfare:marlin_blueprint" | "railways:mechanical_crafting/green_locometal_boiler" | "cbc_cw:paracetic_acid_craft" | "tconstruct:common/materials/pig_iron_ingot_from_block" | "tconstruct:smeltery/melting/metal/tin/plate" | "create_dd:seething/thermal/crushed_raw_lead" | "s_a_b:crafting/camos/light/light_steel_block_camo_mesa" | "createdeco:verdant_brick_slab" | "tconstruct:tools/modifiers/worktable/extract/upgrade" | "s_a_b:crafting/camos/double/double_steel_block_camo_plains" | "create_dd:cut_amethyst_block_brick_slab" | "create:cutting/compat/blue_skies/dusk_log" | "tconstruct:tools/modifiers/salvage/ability/bucketing" | "tfmg:stonecutting/copper_wire" | "superbwarfare:taser_electrode_crafting" | "minecraft:mojang_banner_pattern" | "create:cutting/compat/regions_unexplored/cobalt_wood" | "create_tank_defenses:dusty_steel_pressurized_armor_craft" | "ae2:matter_cannon/nuggets/indium" | "minecraft:golden_hoe" | "suffuse:gun/pf98a" | "s_a_b:stonecutting/blocks/light_stairs/light_steel_yellow_stairs" | "create_tank_defenses:yo_letter_craft" | "create:cutting/stripped_warped_stem" | "ae2:tools/misctools_charged_staff" | "spelunkery:crushing/granite_gold_ore" | "design_decor:item_application/millstones/diorite_millstone" | "minecraft:dye_green_bed" | "create_enchantment_industry:compat/pneumaticcraft/mixing/experience_conversion" | "computercraft:printer" | "farmersdelight:rice_roll_medley_block" | "s_a_b:stonecutting/blocks/light_slabs/light_steel_gray_vslab" | "daffas_arsenal:attachments/reflect_digi_daw" | "alexscaves:radon_lamp_magenta_dye" | "create:crafting/kinetics/cyan_seat_from_other_seat" | "tconstruct:smeltery/seared/seared_ladder" | "alexscaves:cinder_block_slab" | "create:cutting/compat/biomesoplenty/stripped_umbran_log" | "createbigcannons:compacting/packed_gunpowder" | "tconstruct:tools/materials/melting/ice" | "create_tank_defenses:vengeful_titanium_reinforced_cage_armor_craft" | "railways:crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "create_dd:dark_metal_block_slab_from_dark_metal_decor_stonecutting" | "alexscaves:rock_candy_purple_dye" | "maxstuff:gun/db_50" | "createclothes:cutting/forest_vest" | "tconstruct:tools/modifiers/ability/leaping" | "create_tank_defenses:plastanium_block_uncraft" | "suffuse:ammo/6.8tvcm" | "tconstruct:tools/modifiers/salvage/ability/snowdrift" | "alexscaves:smooth_limestone_wall" | "createdeco:cracked_umber_brick_slab" | "minecraft:purpur_block" | "farmersdelight:cutting/smoked_ham" | "createdieselgenerators:crafting/asphalt_block" | "railways:crafting/palettes/wrapping/iron_wrapped_locometal" | "minecraft:polished_blackstone_slab" | "railways:mechanical_crafting/red_copper_wrapped_locometal_boiler" | "create_dd:splashing/weathered_cut_copper_stairs" | "farmersdelight:blue_canvas_sign" | "create:cutting/compat/botania/dreamwood_log" | "create_tank_defenses:cream_chain_armor_craft" | "tconstruct:smeltery/casting/metal/copper/nugget_sand_cast" | "maxstuff:attachments/a3_grip" | "interiors:crafting/floor_chair/cyan_floor_chair_from_seat" | "securitycraft:reinforced_bamboo_slab" | "create_dd:fluid_reservoir_from_fluid_tank_stonecutting" | "railways:sequenced_assembly/track_tfc_sequoia_wide" | "alexscaves:bone_nodule" | "minecraft:gray_concrete_powder" | "vs_tournament:seat" | "tconstruct:smeltery/melting/metal/lead/tools_complement_excavator" | "interiors:crafting/floor_chair/light_blue_floor_chair_from_seat" | "alexscaves:rock_candy_yellow" | "create_tank_defenses:caramel_titanium_explosive_armor_craft" | "tfmg:cut_bauxite_brick_slab_from_stone_types_bauxite_stonecutting" | "tcintegrations:smeltery/melting/metal/soul_stained_steel/ingot" | "create:crafting/kinetics/mechanical_roller" | "valkyrien_warium:horizontal_stabilizer_recipe" | "minecraft:redstone_from_blasting_redstone_ore" | "ae2:tools/paintballs_light_blue" | "securitycraft:reinforced_warped_button" | "crusty_chunks:control_rod_recipe" | "spelunkery:diamond_from_shard" | "casinocraft:cardtable_base_yellow" | "railways:crafting/track_coupler" | "design_decor:dripstone_castel_brick_stairs_from_stone_types_dripstone_stonecutting" | "framedblocks:framing_saw/framed_activator_rail_slope" | "tconstruct:tools/materials/composite/whitestone_from_tin" | "tconstruct:tools/modifiers/upgrade/springy" | "railways:crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "create:cutting/compat/twilightforest/stripped_mangrove_wood" | "comforts:hammock_to_green" | "computercraft:computer_command" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "tfmg:crafting/armor/steel_chestplate" | "framedblocks:framing_saw/framed_divided_panel_horizontal" | "createdeco:mossy_pearl_bricks_from_moss_block" | "createdeco:cracked_dusk_brick_stairs" | "createdeco:cracked_dusk_brick_stairs_from_cracked_dusk_bricks_stonecutting" | "create:cutting/compat/byg/green_enchanted_log" | "marbledsarsenal:olive_juggernaut_armor_chestplate" | "superbwarfare:primer_crafting" | "tconstruct:smeltery/seared/seared_bricks_stonecutting" | "create_tank_defenses:vengeful_titanium_electromagnetic_armor_craft" | "railways:crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "ashvehicle:su-25_spawn_item" | "create_radar:crafting/monitor" | "railways:crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "spelunkery:stone_pebble" | "tconstruct:smeltery/casting/metal/refined_obsidian/block" | "tacz:attachments/sight_coyote" | "alexscaves:gummy_ring_yellow" | "securitycraft:reinforced_stone_brick_slab_from_reinforced_stone_bricks_stonecutting" | "createpropulsion:crafting/inline_optical_sensor" | "ae2:matter_cannon/nuggets/bismuth" | "create_dd:polished_cut_amethyst_block_slab" | "securitycraft:reinforced_purpur_pillar" | "create:item_application/brass_casing_from_log" | "create_tank_defenses:military_titanium_composite_reactive_armor_block_craft" | "railways:crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "create:splashing/light_gray_concrete_powder" | "create:cutting/compat/tconstruct/greenheart_log" | "burnt:burnt_bamboo_slab_recipe" | "sophisticatedstorage:birch_barrel" | "railways:crafting/palettes/dyeing_1x/pink_riveted_locometal" | "create:cutting/compat/regions_unexplored/blue_bioshroom_stem" | "create_tank_defenses:vengeful_titanium_armor_craft" | "tcintegrations:tools/modifiers/compat/geomancer" | "marbledsarsenal:un_military_beret" | "cbc_cw:detergent_soap_craft" | "create_tank_defenses:equal_symbol_craft" | "cib:gun/pm9" | "create:smelting/ingot_silver_compat_ic2" | "tconstruct:common/materials/queens_slime_ingot_from_nuggets" | "securitycraft:reinforced_mud_brick_wall_from_reinforced_mud_bricks_stonecutting" | "create:crafting/kinetics/chute" | "create:brass_scaffolding_from_ingots_brass_stonecutting" | "cib:gun/pkp" | "create:crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "tconstruct:smeltery/melting/metal/lead/sheetmetal" | "create:crafting/materials/small_rose_quartz_tilesfrom_conversion" | "create_dd:raw_padded_mosaic_rubber_from_raw_rubber_decor_stonecutting" | "tconstruct:smeltery/melting/metal/gold/nether_gold_ore" | "createdeco:short_red_bricks_from_tiled_red_bricks_stonecutting" | "copycats:crafting/copycat_vertical_half_layer_from_conversion" | "tconstruct:tools/modifiers/defense/magic_protection" | "spelunkery:charcoal_lump" | "tconstruct:smeltery/casting/slime/ender/bottle" | "create_tank_defenses:exclamation_symbol_craft" | "createdeco:tiled_verdant_bricks_from_verdant_bricks_stonecutting" | "tconstruct:smeltery/melting/metal/invar/nugget" | "railways:crafting/palettes/dyeing_1x/lime_slashed_locometal" | "tacz:attachments/sight_sro_dot" | "farmersdelight:cutting/mangrove_trapdoor" | "create:polished_cut_asurine_stairs" | "create_tank_defenses:smelt_raw_titanium" | "tconstruct:tools/materials/melting/platinum" | "s_a_b:olivesb" | "securitycraft:redstone_mine" | "create:crafting/kinetics/fluid_tank" | "create:cutting/compat/blue_skies/stripped_maple_log" | "alexscaves:stonecutter/coprolith_wall_stonecutting" | "create_tank_defenses:ashes_titanium_reinfoced_armor_craft" | "securitycraft:reinforced_red_nether_brick_stairs_from_reinforced_red_nether_bricks_stonecutting" | "create:smoking/bread" | "create_tank_defenses:ceramic_tank_hatch_craft" | "spelunkery:polished_nephrite" | "tconstruct:tools/materials/ancient/nugget" | "createdeco:dusk_brick_stairs_from_tiled_dusk_brick_stairs_stonecutting" | "framedblocks:framed_flat_ext_inner_slope_panel_corner" | "create:cutting/compat/blue_skies/starlit_log" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "create_dd:green_padded_mosaic_rubber_from_green_rubber_decor_stonecutting" | "tconstruct:tools/parts/casting/tough_binding_gold_cast" | "tconstruct:tools/materials/slimeskin/composite/ichor_cleaning" | "s_a_b:stonecutting/letters_brass/symbols/brassdoubledot" | "sophisticatedstorage:storage_output" | "tconstruct:tools/recycling/general" | "s_a_b:crafting/colored/double/double_steel_block_purple" | "create_connected:crafting/palettes/copycat_fence_compat" | "create:cutting/compat/blue_skies/maple_log" | "create_tank_defenses:purity_titanium_fortified_armor_block_craft" | "createdeco:long_verdant_brick_stairs_from_verdant_brick_stairs_stonecutting" | "createdeco:dean_brick_slab_from_tiled_dean_bricks_stonecutting" | "tconstruct:common/slime/ichor/slimeball_from_congealed" | "minecraft:iron_ingot_from_nuggets" | "design_decor:lime_metal_plate_stairs_from_metal_plate_stonecutting" | "securitycraft:reinforced_magenta_carpet" | "tconstruct:smeltery/casting/soul/glass" | "minecraft:golden_pickaxe" | "tconstruct:smeltery/casting/metal/slimesteel/nugget_gold_cast" | "framedblocks:framed_divided_panel_vertical" | "create:cutting/compat/byg/stripped_lament_log" | "createdeco:tiled_blue_brick_stairs_from_blue_bricks_stonecutting" | "create_tank_defenses:morning_fire_supression_system_craft" | "railways:sequenced_assembly/track_byg_white_mangrove_wide" | "create_ultimate_factory:crushing_soulsand" | "create:filling/compat/regions_unexplored/silt_grass_block" | "create:deploying/waxed_copper_tile_stairs_from_adding_wax" | "railways:crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "create:filling/builders_tea" | "railways:sequenced_assembly/track_blackstone_wide" | "tconstruct:smeltery/melting/metal/copper/gear" | "create:milling/compat/botania/yellow_petal" | "minecraft:redstone_torch" | "tconstruct:smeltery/melting/metal/signalum/ingot" | "spelunkery:mixing/rock_salt" | "valkyrien_warium:slab_wing_recipe" | "createdeco:orange_placard" | "create:small_tuff_brick_stairs" | "tconstruct:tools/modifiers/salvage/upgrade/swift_sneak" | "burnt:burnt_stairs_recipe" | "sophisticatedstorage:backpack_stack_upgrade_starter_tier_from_storage_stack_upgrade_tier_1_plus" | "spelunkery:zinc_ore_blasting" | "maxstuff:gun/m17" | "create:crafting/kinetics/deployer" | "immersive_paintings:glow_painting" | "createdeco:short_red_brick_slab_from_tiled_red_bricks_stonecutting" | "create_dd:small_blackstone_brick_slab" | "minecraft:gray_bed" | "farmersdelight:basket" | "crusty_chunks:jet_gearbox_recipe" | "storagedelight:small_oak_drawers" | "vs_eureka:orange_balloon" | "superbwarfare:iron_action" | "storagedrawers:crimson_full_drawers_4" | "create:crafting/materials/andesite_alloy" | "s_a_b:stonecutting/blocks/normal_slabs/steel_camo_swamp_slab" | "tconstruct:tools/modifiers/salv