/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import net.minecraft.client.gui.Font;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CountFormatter {
    public static String format(Font font, IDrawer drawer) {
        return CountFormatter.formatApprox(font, drawer);
    }

    public static String formatStackNotation(IDrawer drawer) {
        if (drawer == null || drawer.isEmpty()) {
            return "";
        }
        int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
        int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
        Object text = stacks > 0 && remainder > 0 ? stacks + "x" + drawer.getStoredItemStackSize() + "+" + remainder : (stacks > 0 ? stacks + "x" + drawer.getStoredItemStackSize() : String.valueOf(remainder));
        return text;
    }

    public static String formatExact(IDrawer drawer) {
        if (drawer == null || drawer.isEmpty()) {
            return "";
        }
        return String.valueOf(drawer.getStoredItemCount());
    }

    public static String formatApprox(Font font, IDrawer drawer) {
        if (drawer == null || drawer.isEmpty()) {
            return "";
        }
        int count = drawer.getStoredItemCount();
        String text = count >= 1000000000 ? String.format("%.1fG", Float.valueOf((float)count / 1.0E9f)) : (count >= 100000000 ? String.format("%.0fM", Float.valueOf((float)count / 1000000.0f)) : (count >= 1000000 ? String.format("%.1fM", Float.valueOf((float)count / 1000000.0f)) : (count >= 100000 ? String.format("%.0fK", Float.valueOf((float)count / 1000.0f)) : (count >= 10000 ? String.format("%.1fK", Float.valueOf((float)count / 1000.0f)) : String.valueOf(count)))));
        return text;
    }
}

