/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MaterialData
extends BlockEntityDataShim
implements IFramedMaterials {
    @NotNull
    private ItemStack frameBase;
    @NotNull
    private ItemStack materialSide;
    @NotNull
    private ItemStack materialFront;
    @NotNull
    private ItemStack materialTrim;

    public MaterialData() {
        this(ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_);
    }

    public MaterialData(@NotNull ItemStack frameBase, @NotNull ItemStack side, @NotNull ItemStack front, @NotNull ItemStack trim) {
        this.frameBase = frameBase;
        this.materialSide = side;
        this.materialFront = front;
        this.materialTrim = trim;
    }

    public MaterialData(IFramedMaterials materials) {
        this();
        if (materials != null) {
            this.frameBase = materials.getHostBlock();
            this.materialSide = materials.getMaterial(FrameMaterial.SIDE);
            this.materialFront = materials.getMaterial(FrameMaterial.FRONT);
            this.materialTrim = materials.getMaterial(FrameMaterial.TRIM);
        }
    }

    @NotNull
    public ItemStack getFrameBase() {
        return this.frameBase;
    }

    @NotNull
    public ItemStack getSide() {
        return this.materialSide;
    }

    @NotNull
    public ItemStack getFront() {
        return this.materialFront;
    }

    @NotNull
    public ItemStack getTrim() {
        return this.materialTrim;
    }

    @NotNull
    public ItemStack getEffectiveSide() {
        return this.materialSide;
    }

    @NotNull
    public ItemStack getEffectiveFront() {
        return !this.materialFront.m_41619_() ? this.materialFront : this.materialSide;
    }

    @NotNull
    public ItemStack getEffectiveTrim() {
        return !this.materialTrim.m_41619_() ? this.materialTrim : this.materialSide;
    }

    public void setFrameBase(@NotNull ItemStack frameBase) {
        this.frameBase = frameBase;
    }

    public void setSide(@NotNull ItemStack material) {
        this.materialSide = material;
    }

    public void setFront(@NotNull ItemStack material) {
        this.materialFront = material;
    }

    public void setTrim(@NotNull ItemStack material) {
        this.materialTrim = material;
    }

    public void clear() {
        this.materialSide = ItemStack.f_41583_;
        this.materialFront = ItemStack.f_41583_;
        this.materialTrim = ItemStack.f_41583_;
    }

    public boolean isEmpty() {
        return this.materialFront.m_41619_() && this.materialSide.m_41619_() && this.materialTrim.m_41619_();
    }

    @Override
    public void read(CompoundTag tag) {
        this.frameBase = ItemStack.f_41583_;
        if (tag.m_128441_("MatB")) {
            this.frameBase = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MatB"));
        }
        this.materialSide = ItemStack.f_41583_;
        if (tag.m_128441_("MatS")) {
            this.materialSide = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MatS"));
        }
        this.materialFront = ItemStack.f_41583_;
        if (tag.m_128441_("MatF")) {
            this.materialFront = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MatF"));
        }
        this.materialTrim = ItemStack.f_41583_;
        if (tag.m_128441_("MatT")) {
            this.materialTrim = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MatT"));
        }
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        CompoundTag itag;
        if (!this.frameBase.m_41619_()) {
            itag = new CompoundTag();
            this.frameBase.m_41739_(itag);
            tag.m_128365_("MatB", (Tag)itag);
        } else if (tag.m_128441_("MatB")) {
            tag.m_128473_("MatB");
        }
        if (!this.materialSide.m_41619_()) {
            itag = new CompoundTag();
            this.materialSide.m_41739_(itag);
            tag.m_128365_("MatS", (Tag)itag);
        } else if (tag.m_128441_("MatS")) {
            tag.m_128473_("MatS");
        }
        if (!this.materialFront.m_41619_()) {
            itag = new CompoundTag();
            this.materialFront.m_41739_(itag);
            tag.m_128365_("MatF", (Tag)itag);
        } else if (tag.m_128441_("MatF")) {
            tag.m_128473_("MatF");
        }
        if (!this.materialTrim.m_41619_()) {
            itag = new CompoundTag();
            this.materialTrim.m_41739_(itag);
            tag.m_128365_("MatT", (Tag)itag);
        } else if (tag.m_128441_("MatT")) {
            tag.m_128473_("MatT");
        }
        return tag;
    }

    @Override
    @NotNull
    public ItemStack getHostBlock() {
        return this.frameBase;
    }

    @Override
    public void setHostBlock(@NotNull ItemStack stack) {
        this.frameBase = stack;
    }

    @Override
    @NotNull
    public ItemStack getMaterial(FrameMaterial material) {
        return switch (material) {
            default -> throw new IncompatibleClassChangeError();
            case FrameMaterial.SIDE -> this.materialSide;
            case FrameMaterial.TRIM -> this.materialTrim;
            case FrameMaterial.FRONT -> this.materialFront;
        };
    }

    @Override
    public void setMaterial(FrameMaterial material, @NotNull ItemStack stack) {
        switch (material) {
            case SIDE: {
                this.materialSide = stack;
                break;
            }
            case TRIM: {
                this.materialTrim = stack;
                break;
            }
            case FRONT: {
                this.materialFront = stack;
            }
        }
    }
}

